import { Connector, NodeInputVariable, NodeOutputVariable } from 'flow-models';

import { FlowContentState } from 'state-flow/types';

export type State = {
  flowContent: FlowContentState;
};

export enum ChangeEventType {
  // React Flow
  RF_EDGES_CHANGE = 'RF_EDGES_CHANGE',
  RF_NODES_CHANGE = 'RF_NODES_CHANGE',
  RF_ON_CONNECT = 'RF_ON_CONNECT',
  // Nodes
  ADDING_NODE = 'ADDING_NODE',
  REMOVING_NODE = 'REMOVING_NODE',
  UPDATING_NODE_CONFIG = 'UPDATING_NODE_CONFIG',
  // Variables & Conditions
  ADDING_VARIABLE = 'ADDING_VARIABLE',
  ADDING_CONNECTOR_FOR_NODE_CONFIG_FIELD = 'ADDING_CONNECTOR_FOR_NODE_CONFIG_FIELD',
  REMOVING_VARIABLE = 'REMOVING_VARIABLE',
  UPDATE_CONNECTORS = 'UPDATE_CONNECTORS',
  UPDATE_VARIABLE_VALUES = 'UPDATE_VARIABLE_VALUES',
  CREATE_GLOBAL_VARIABLE = 'CREATE_GLOBAL_VARIABLE',
  UPDATE_CONDITION_RESULTS = 'UPDATE_CONDITION_RESULTS',
  // Run Flow
  FLOW_SINGLE_RUN_STARTED = 'FLOW_SINGLE_RUN_STARTED',
  FLOW_SINGLE_RUN_STOPPED = 'FLOW_SINGLE_RUN_STOPPED',
  FLOW_SINGLE_RUN_NODE_EXECUTION_STATE_CHANGE = 'FLOW_SINGLE_RUN_NODE_EXECUTION_STATE_CHANGE',
  FLOW_SINGLE_RUN_ACCOUNT_LEVEL_FIELD_ERROR = 'FLOW_SINGLE_RUN_ACCOUNT_LEVEL_FIELD_ERROR',

  // NOTE: Derived
  // Derived Nodes
  NODE_AND_CONNECTORS_ADDED = 'NODE_AND_CONNECTORS_ADDED',
  NODE_REMOVED = 'NODE_REMOVED',
  NODE_MOVED = 'NODE_MOVED',
  NODE_CONFIG_UPDATED = 'NODE_CONFIG_UPDATED',
  // Derived Edges
  EDGE_ADDED = 'EDGE_ADDED',
  EDGE_REPLACED = 'EDGE_REPLACED',
  // Derived Variables
  VARIABLE_ADDED = 'VARIABLE_ADDED',
  VARIABLE_REMOVED = 'VARIABLE_REMOVED',
  VARIABLE_UPDATED = 'VARIABLE_UPDATED',
  // Derived Conditions
  CONDITION_ADDED = 'CONDITION_ADDED',
  CONDITION_REMOVED = 'CONDITION_REMOVED',
  CONDITION_TARGET_REMOVED = 'CONDITION_TARGET_REMOVED',
  // Derived Other
  VAR_VALUE_MAP_UPDATED = 'VAR_VALUE_MAP_UPDATED',
}

// ANCHOR: Event shared by multiple handlers

export type VariableRemovedEvent = {
  type: ChangeEventType.VARIABLE_REMOVED;
  removedVariable: NodeInputVariable | NodeOutputVariable;
};

export type VariableUpdatedEvent = {
  type: ChangeEventType.VARIABLE_UPDATED;
  prevVariable: Connector;
  nextVariable: Connector;
};
