# Code of Conduct #

[_Adapted from the Rust Code of Conduct_](https://github.com/rust-lang/rust/wiki/Note-development-policy#conduct)

We are committed to providing a friendly, safe and welcoming environment for all, regardless of gender, sexual orientation, disability, ethnicity, religion, or similar personal characteristic.

- Please be kind and courteous. There's no need to be mean or rude.
- Respect that people have differences of opinion and that every design or implementation choice carries a trade-off and numerous costs. There is seldom a right answer.
- Please keep unstructured critique to a minimum. If you have a negative experience with the technology, express your thoughts with respectful and fact-based arguments, assuming the other people reading your message have good intentions.
- Refrain from [ad hominen](https://en.wikipedia.org/wiki/Ad_hominem) comments.
- On any communication medium, please avoid using overtly sexual nicknames or other nicknames that might detract from a friendly, safe and welcoming environment for all.
- Any spamming, trolling, flaming, baiting or other attention-stealing behavior is not welcome.
- We will exclude you from interaction if you insult, demean or harass anyone. That is not welcome behavior. We interpret the term "harassment" as including the definition in the [Citizen Code of Conduct](http://citizencodeofconduct.org/); if you have any lack of clarity about what might be included in that concept, please read their definition. In particular, we don't tolerate behavior that excludes people in socially marginalized groups.
- In case you have been excluded from interaction (GitHub "blocked"), the core team *may choose* to unblock you after 1 week. After that, if an offense is repeated, you will be blocked, and the core team *may choose* to unblock you after 1 month. A third offense will mean permanent blocking.
- Private harassment is also unacceptable. No matter who you are, if you feel you have been or are being harassed or made uncomfortable by a community member, please contact one the Cycle.js team immediately. Whether you're a regular contributor or a newcomer, we care about making this community a safe place for you and we've got your back.
