#pragma once

/* Some import MIME types for the Web.

   Ref: https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/MIME_types/Common_types
*/
#define  OCGI_MIME_TYPE_AAC   @"audio/aac"
#define  OCGI_MIME_TYPE_ABW   @"application/x-abiword"
#define  OCGI_MIME_TYPE_ARC   @"application/x-freearc"
#define  OCGI_MIME_TYPE_AVI   @"video/x-msvideo"
#define  OCGI_MIME_TYPE_AZW   @"application/vnd.amazon.ebook"
#define  OCGI_MIME_TYPE_BIN   @"application/octet-stream"
#define  OCGI_MIME_TYPE_BMP   @"image/bmp"
#define  OCGI_MIME_TYPE_BZ    @"application/x-bzip"
#define  OCGI_MIME_TYPE_BZ2   @"application/x-bzip2"
#define  OCGI_MIME_TYPE_CSH   @"application/x-csh"
#define  OCGI_MIME_TYPE_CSS   @"text/css"
#define  OCGI_MIME_TYPE_CSV   @"text/csv"
#define  OCGI_MIME_TYPE_DOC   @"application/msword"

#define  OCGI_MIME_TYPE_DOCX  \
    @"application/vnd.openxmlformats-officedocument.wordprocessingml.document"

#define  OCGI_MIME_TYPE_EOT   @"application/vnd.ms-fontobject"
#define  OCGI_MIME_TYPE_EPUB  @"application/epub+zip"
#define  OCGI_MIME_TYPE_GZ    @"application/gzip"
#define  OCGI_MIME_TYPE_GIF   @"image/gif"

#define  OCGI_MIME_TYPE_HTML       @"text/html"
#define  OCGI_MIME_TYPE_HTML_UTF8  @"text/html; charset=utf-8"

#define  OCGI_MIME_TYPE_ICON  @"image/vnd.microsoft.icon"
#define  OCGI_MIME_TYPE_ICS   @"text/calendar"
#define  OCGI_MIME_TYPE_JAR   @"application/java-archive"
#define  OCGI_MIME_TYPE_JPEG  @"image/jpeg"
#define  OCGI_MIME_TYPE_JS    @"text/javascript"

#define  OCGI_MIME_TYPE_JSON       @"application/json"
#define  OCGI_MIME_TYPE_JSON_UTF8  @"application/json; charset=utf-8"
#define  OCGI_MIME_TYPE_JSONLD     @"application/ld+json"

#define  OCGI_MIME_TYPE_MIDI  @"audio/midi"
#define  OCGI_MIME_TYPE_MJS   @"text/javascript"
#define  OCGI_MIME_TYPE_MP3   @"audio/mpeg"
#define  OCGI_MIME_TYPE_MPEG  @"video/mpeg"
#define  OCGI_MIME_TYPE_MPKG  @"application/vnd.apple.installer+xml"
#define  OCGI_MIME_TYPE_ODP   @"application/vnd.oasis.opendocument.presentation"
#define  OCGI_MIME_TYPE_ODS   @"application/vnd.oasis.opendocument.spreadsheet"
#define  OCGI_MIME_TYPE_ODT   @"application/vnd.oasis.opendocument.text"
#define  OCGI_MIME_TYPE_OGA   @"audio/ogg"
#define  OCGI_MIME_TYPE_OGV   @"video/ogg"
#define  OCGI_MIME_TYPE_OGX   @"application/ogg"
#define  OCGI_MIME_TYPE_OPUS  @"audio/opus"
#define  OCGI_MIME_TYPE_OTF   @"font/otf"
#define  OCGI_MIME_TYPE_PNG   @"image/png"
#define  OCGI_MIME_TYPE_PDF   @"application/pdf"
#define  OCGI_MIME_TYPE_PHP   @"application/x-httpd-php"
#define  OCGI_MIME_TYPE_PPT   @"application/vnd.ms-powerpoint"

#define  OCGI_MIME_TYPE_PPTX  \
    @"application/vnd.openxmlformats-officedocument.presentationml.presentation"

#define  OCGI_MIME_TYPE_RAR   @"application/vnd.rar"
#define  OCGI_MIME_TYPE_RTF   @"application/rtf"
#define  OCGI_MIME_TYPE_SH    @"application/x-sh"
#define  OCGI_MIME_TYPE_SVG   @"image/svg+xml"
#define  OCGI_MIME_TYPE_SWF   @"application/x-shockwave-flash"
#define  OCGI_MIME_TYPE_TAR   @"application/x-tar"
#define  OCGI_MIME_TYPE_TIFF  @"image/tiff"
#define  OCGI_MIME_TYPE_TS    @"video/mp2t"
#define  OCGI_MIME_TYPE_TTF   @"font/ttf"
#define  OCGI_MIME_TYPE_TXT   @"text/plain"
#define  OCGI_MIME_TYPE_VSD   @"application/vnd.visio"
#define  OCGI_MIME_TYPE_WAV   @"audio/wav"
#define  OCGI_MIME_TYPE_WEBA  @"audio/webm"
#define  OCGI_MIME_TYPE_WEBM  @"video/webm"
#define  OCGI_MIME_TYPE_WEBP  @"image/webp"

#define  OCGI_MIME_TYPE_WOFF   @"font/woff"
#define  OCGI_MIME_TYPE_WOFF2  @"font/woff2"

#define  OCGI_MIME_TYPE_XHTML  @"application/xhtml+xml"

#define  OCGI_MIME_TYPE_XLS   @"application/vnd.ms-excel"
#define  OCGI_MIME_TYPE_XLSX \
    @"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"

#define  OCGI_MIME_TYPE_XML_APP  @"application/xml"
#define  OCGI_MIME_TYPE_XML_TXT  @"text/xml"

#define  OCGI_MIME_TYPE_XUL   @"application/vnd.mozilla.xul+xml"
#define  OCGI_MIME_TYPE_ZIP   @"application/zip"

#define  OCGI_MIME_TYPE_3GP_VIDEO  @"video/3gpp"
#define  OCGI_MIME_TYPE_3GP_AUDIO  @"audio/3gpp"
#define  OCGI_MIME_TYPE_3G2_VIDEO  @"video/3gpp2"
#define  OCGI_MIME_TYPE_3G2_AUDIO  @"audio/3gpp2"

#define  OCGI_MIME_TYPE_7Z    @"	application/x-7z-compressed"