#!/bin/bash
# this script is used for creating zip archives for release

# create directory and copy macOS related sources into it
macOSPath="ofxOfelia_macOS"
rm -rf "${macOSPath}"
mkdir "${macOSPath}"
mkdir "${macOSPath}/scripts"
cp -rp "../../scripts/common" "${macOSPath}/scripts"
cp -rp "../../macOSExample" "${macOSPath}"
cp -rp "../../macOSExternal" "${macOSPath}"
cp -rp "../../libs" "${macOSPath}"
cp -rp "../../src" "${macOSPath}"
cp -rp "../../ofelia" "${macOSPath}"
cp -rp "../../LICENSE.txt" "${macOSPath}"
cp -rp "../../CHANGES.txt" "${macOSPath}"
cp -rp "../../README.md" "${macOSPath}"
cp -rp "../../addon_config.mk" "${macOSPath}"
rm -rf "${macOSPath}/libs/ofxLua/swig"
rm -rf "${macOSPath}/libs/ofxLua/src/bindings/ios"
rm -rf "${macOSPath}/libs/ofxLua/src/bindings/linuxarm"
rm -rf "${macOSPath}/libs/ofxMidi/libs/pgmidi"
rm -rf "${macOSPath}/libs/ofxMidi/src/ios"
rm -rf "${macOSPath}/libs/ofxOsc/libs/oscpack/src/ip/win32"
rm -rf "${macOSPath}/libs/ofxPd/libs/libpd/lib"

# create directory and copy Linux related sources into it
LinuxPath="ofxOfelia_Linux"
rm -rf "${LinuxPath}"
mkdir "${LinuxPath}"
mkdir "${LinuxPath}/scripts"
cp -rp "../../scripts/common" "${LinuxPath}/scripts"
cp -rp "../../scripts/Linux64" "${LinuxPath}/scripts"
cp -rp "../../LinuxExample" "${LinuxPath}"
cp -rp "../../LinuxExternal" "${LinuxPath}"
cp -rp "../../libs" "${LinuxPath}"
cp -rp "../../src" "${LinuxPath}"
cp -rp "../../ofelia" "${LinuxPath}"
cp -rp "../../LICENSE.txt" "${LinuxPath}"
cp -rp "../../CHANGES.txt" "${LinuxPath}"
cp -rp "../../README.md" "${LinuxPath}"
cp -rp "../../addon_config.mk" "${LinuxPath}"
rm -rf "${LinuxPath}/libs/ofxLua/swig"
rm -rf "${LinuxPath}/libs/ofxLua/src/bindings/ios"
rm -rf "${LinuxPath}/libs/ofxMidi/libs/pgmidi"
rm -rf "${LinuxPath}/libs/ofxMidi/src/ios"
rm -rf "${LinuxPath}/libs/ofxOsc/libs/oscpack/src/ip/win32"
rm -rf "${LinuxPath}/libs/ofxPd/libs/libpd/lib"
rm -rf "${LinuxPath}/libs/ofxZipPass/libs/zlib"

# create directory and copy Windows related sources into it
WindowsPath="ofxOfelia_Windows"
rm -rf "${WindowsPath}"
mkdir "${WindowsPath}"
mkdir "${WindowsPath}/scripts"
cp -rp "../../scripts/common" "${WindowsPath}/scripts"
cp -rp "../../WindowsExample" "${WindowsPath}"
cp -rp "../../WindowsExternal" "${WindowsPath}"
cp -rp "../../libs" "${WindowsPath}"
cp -rp "../../src" "${WindowsPath}"
cp -rp "../../ofelia" "${WindowsPath}"
cp -rp "../../LICENSE.txt" "${WindowsPath}"
cp -rp "../../CHANGES.txt" "${WindowsPath}"
cp -rp "../../README.md" "${WindowsPath}"
cp -rp "../../addon_config.mk" "${WindowsPath}"
rm -rf "${WindowsPath}/libs/ofxLua/swig"
rm -rf "${WindowsPath}/libs/ofxLua/src/bindings/ios"
rm -rf "${WindowsPath}/libs/ofxLua/src/bindings/linuxarm"
rm -rf "${WindowsPath}/libs/ofxMidi/libs/pgmidi"
rm -rf "${WindowsPath}/libs/ofxMidi/src/ios"
rm -rf "${WindowsPath}/libs/ofxOsc/libs/oscpack/src/ip/posix"

# create directory and copy iOS related sources into it
iOSPath="ofxOfelia_iOS"
rm -rf "${iOSPath}"
mkdir "${iOSPath}"
mkdir "${iOSPath}/scripts"
cp -rp "../../scripts/common" "${iOSPath}/scripts"
cp -rp "../../iOSExample" "${iOSPath}"
cp -rp "../../libs" "${iOSPath}"
cp -rp "../../src" "${iOSPath}"
cp -rp "../../LICENSE.txt" "${iOSPath}"
cp -rp "../../CHANGES.txt" "${iOSPath}"
cp -rp "../../README.md" "${iOSPath}"
cp -rp "../../addon_config.mk" "${iOSPath}"
rm -rf "${iOSPath}/libs/ofxLua/swig"
rm -rf "${iOSPath}/libs/ofxLua/src/bindings/desktop"
rm -rf "${iOSPath}/libs/ofxLua/src/bindings/linuxarm"
rm -rf "${iOSPath}/libs/ofxMidi/libs/rtmidi"
rm -rf "${iOSPath}/libs/ofxMidi/libs/portmidi"
rm -rf "${iOSPath}/libs/ofxMidi/src/desktop"
rm -rf "${iOSPath}/libs/ofxOsc/libs/oscpack/src/ip/win32"
rm -rf "${iOSPath}/libs/ofxPd/libs/libpd/lib"

# create directory and copy Android related sources into it
AndroidPath="ofxOfelia_Android"
rm -rf "${AndroidPath}"
mkdir "${AndroidPath}"
mkdir "${AndroidPath}/scripts"
cp -rp "../../scripts/common" "${AndroidPath}/scripts"
cp -rp "../../AndroidExample" "${AndroidPath}"
cp -rp "../../libs" "${AndroidPath}"
cp -rp "../../src" "${AndroidPath}"
cp -rp "../../LICENSE.txt" "${AndroidPath}"
cp -rp "../../CHANGES.txt" "${AndroidPath}"
cp -rp "../../README.md" "${AndroidPath}"
cp -rp "../../addon_config.mk" "${AndroidPath}"
rm -rf "${AndroidPath}/libs/ofxLua/swig"
rm -rf "${AndroidPath}/libs/ofxLua/src/bindings/desktop"
rm -rf "${AndroidPath}/libs/ofxLua/src/bindings/linuxarm"
rm -rf "${AndroidPath}/libs/ofxMidi/libs/pgmidi"
rm -rf "${AndroidPath}/libs/ofxMidi/src/ios"
rm -rf "${AndroidPath}/libs/ofxOsc/libs/oscpack/src/ip/win32"
rm -rf "${AndroidPath}/libs/ofxPd/libs/libpd/lib"

# create directory and copy Emscripten related sources into it
EmscriptenPath="ofxOfelia_Emscripten"
rm -rf "${EmscriptenPath}"
mkdir "${EmscriptenPath}"
mkdir "${EmscriptenPath}/scripts"
cp -rp "../../scripts/common" "${EmscriptenPath}/scripts"
cp -rp "../../scripts/Emscripten" "${EmscriptenPath}/scripts"
cp -rp "../../EmscriptenExample" "${EmscriptenPath}"
cp -rp "../../libs" "${EmscriptenPath}"
cp -rp "../../src" "${EmscriptenPath}"
cp -rp "../../LICENSE.txt" "${EmscriptenPath}"
cp -rp "../../CHANGES.txt" "${EmscriptenPath}"
cp -rp "../../README.md" "${EmscriptenPath}"
cp -rp "../../addon_config.mk" "${EmscriptenPath}"
rm -rf "${EmscriptenPath}/libs/ofxLua/swig"
rm -rf "${EmscriptenPath}/libs/ofxLua/src/bindings/desktop"
rm -rf "${EmscriptenPath}/libs/ofxLua/src/bindings/linuxarm"
rm -rf "${EmscriptenPath}/libs/ofxMidi/libs/pgmidi"
rm -rf "${EmscriptenPath}/libs/ofxMidi/src/ios"
rm -rf "${EmscriptenPath}/libs/ofxOsc/libs/oscpack/src/ip/win32"
rm -rf "${EmscriptenPath}/libs/ofxPd/libs/libpd/lib"

# delete all .DS_Store files
find . -name '.DS_Store' -type f -delete

# zip each created directory
zip -r ofxOfelia_macOS.zip ofxOfelia_macOS
zip -r ofxOfelia_Linux.zip ofxOfelia_Linux
zip -r ofxOfelia_Windows.zip ofxOfelia_Windows
zip -r ofxOfelia_iOS.zip ofxOfelia_iOS
zip -r ofxOfelia_Android.zip ofxOfelia_Android
zip -r ofxOfelia_Emscripten.zip ofxOfelia_Emscripten

# remove all created directories
rm -rf "${macOSPath}"
rm -rf "${LinuxPath}"
rm -rf "${WindowsPath}"
rm -rf "${iOSPath}"
rm -rf "${AndroidPath}"
rm -rf "${EmscriptenPath}"
