// SSCD (Super Simple Collision Detection) is distributed with the zlib-license:
/* 
  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.


  Made by Ronen Ness
  ronenness@gmail.com
  
  Modified by CoMiGo Games
  admin@nersta.ru

*/

"use strict";var SSCD=function(){var c=c||{};return c.VERSION=1.5,c.Math={},c.Math.to_radians=function(d){return d*Math.PI/180},c.Math.to_degrees=function(d){return 180*d/Math.PI},c.Math.distance=function(d,e){var f=e.x-d.x,g=e.y-d.y;return Math.sqrt(f*f+g*g)},c.Math.dist2=function(d,e){var f=e.x-d.x,g=e.y-d.y;return f*f+g*g},c.Math.angle=function(d,e){var f=e.y-d.y,g=e.x-d.x;return 180*Math.atan2(f,g)/Math.PI},c.Math.distance_to_line=function(d,e,f){var g=c.Math.dist2(e,f),h=((d.x-e.x)*(f.x-e.x)+(d.y-e.y)*(f.y-e.y))/g;return 0>h?c.Math.distance(d,e):1<h?c.Math.distance(d,f):c.Math.distance(d,{x:e.x+h*(f.x-e.x),y:e.y+h*(f.y-e.y)})},c.Math.line_intersects=function(d,e,f,g){var h,k,l,m;h=e.x-d.x,k=e.y-d.y,l=g.x-f.x,m=g.y-f.y;var n,o;return n=(-k*(d.x-f.x)+h*(d.y-f.y))/(-l*k+h*m),o=(l*(d.y-f.y)-m*(d.x-f.x))/(-l*k+h*m),0<=n&&1>=n&&0<=o&&1>=o?1:0},c.Math.is_on_line=function(d,e,f){return 5>=c.Math.distance_to_line(d,e,f)},c.Math.angles_dis=function(d,e){d=c.Math.to_radians(d),e=c.Math.to_radians(e);var f=2*Math.PI,g=(e-d)%f,h=2*g%f-g;return h=c.Math.to_degrees(h),Math.abs(h)},c.Vector=function(d,e){this.x=d,this.y=e},c.Vector.prototype={get_name:function get_name(){return"vector"},clone:function clone(){return new c.Vector(this.x,this.y)},set:function set(d){this.x=d.x,this.y=d.y},flip:function flip(){return new c.Vector(this.y,this.x)},flip_self:function flip_self(){return this.y=[this.x,this.x=this.y][0],this},negative:function negative(){return this.multiply_scalar(-1)},negative_self:function negative_self(){return this.multiply_scalar_self(-1),this},distance_from:function distance_from(d){return c.Math.distance(this,d)},angle_from:function angle_from(d){return c.Math.angle(this,d)},move:function move(d){return this.x+=d.x,this.y+=d.y,this},normalize_self:function normalize_self(){var d=Math.sqrt(this.x*this.x+this.y*this.y);return 0===d?this:(this.x/=d,this.y/=d,this)},normalize:function normalize(){return this.clone().normalize_self()},add_self:function add_self(d){return this.x+=d.x,this.y+=d.y,this},sub_self:function sub_self(d){return this.x-=d.x,this.y-=d.y,this},divide_self:function divide_self(d){return this.x/=d.x,this.y/=d.y,this},multiply_self:function multiply_self(d){return this.x*=d.x,this.y*=d.y,this},add_scalar_self:function add_scalar_self(d){return this.x+=d,this.y+=d,this},sub_scalar_self:function sub_scalar_self(d){return this.x-=d,this.y-=d,this},divide_scalar_self:function divide_scalar_self(d){return this.x/=d,this.y/=d,this},multiply_scalar_self:function multiply_scalar_self(d){return this.x*=d,this.y*=d,this},add:function add(d){return this.clone().add_self(d)},sub:function sub(d){return this.clone().sub_self(d)},multiply:function multiply(d){return this.clone().multiply_self(d)},divide:function divide(d){return this.clone().divide_self(d)},add_scalar:function add_scalar(d){return this.clone().add_scalar_self(d)},sub_scalar:function sub_scalar(d){return this.clone().sub_scalar_self(d)},multiply_scalar:function multiply_scalar(d){return this.clone().multiply_scalar_self(d)},divide_scalar:function divide_scalar(d){return this.clone().divide_scalar_self(d)},clamp:function clamp(d,e){return this.x<d&&(this.x=d),this.y<d&&(this.y=d),this.x>e&&(this.x=e),this.y>e&&(this.y=e),this},from_radian:function from_radian(d){return this.x=Math.cos(d),this.y=Math.sin(d),this},from_angle:function from_angle(d){return this.from_radian(c.Math.to_radians(d))},apply_self:function apply_self(d){return this.x=d(this.x),this.y=d(this.y),this},apply:function apply(d){return this.clone().apply_self(d)},debug:function debug(){console.debug(this.x+", "+this.y)}},c.Vector.ZERO=new c.Vector(0,0),c.Vector.ONE=new c.Vector(1,1),c.Vector.UP=new c.Vector(0,-1),c.Vector.DOWN=new c.Vector(0,1),c.Vector.LEFT=new c.Vector(-1,0),c.Vector.RIGHT=new c.Vector(1,0),c.Vector.UP_LEFT=new c.Vector(-1,-1),c.Vector.DOWN_LEFT=new c.Vector(-1,1),c.Vector.UP_RIGHT=new c.Vector(1,-1),c.Vector.DOWN_RIGHT=new c.Vector(1,1),c.extend=function(d,e){for(var f in d)e[f]||(e[f]=d[f]);e.__inits=e.__inits||[],d.__init__&&e.__inits.push(d.__init__),e.init=function(){for(var g=0;g<this.__inits.length;++g)this.__curr_init_func=this.__inits[g],this.__curr_init_func();delete this.__curr_init_func}},c.NotImplementedError=function(d){this.name="NotImplementedError",this.message=d||""},c.NotImplementedError.prototype=Error.prototype,c.AABB=function(d,e){this.position=d.clone(),this.size=e.clone()},c.AABB.prototype={expand:function expand(d){var e=Math.min(this.position.x,d.position.x),f=Math.min(this.position.y,d.position.y),g=Math.max(this.position.x+this.size.x,d.position.x+d.size.x),h=Math.max(this.position.y+this.size.y,d.position.y+d.size.y);this.position.x=e,this.position.y=f,this.size.x=g-e,this.size.y=h-f},add_vector:function add_vector(d){var e=this.position.x-d.x;0<e&&(this.position.x-=e,this.size.x+=e);var f=this.position.y-d.y;0<f&&(this.position.y-=f,this.size.y+=f);var g=d.x-(this.position.x+this.size.x);0<g&&(this.size.x+=g);var h=d.y-(this.position.y+this.size.y);0<h&&(this.size.y+=h)},clone:function clone(){return new c.AABB(this.position,this.size)},intersects:function intersects(){return!(b.position.x>=a.position.x+a.size.x||b.position.x+b.size.x<=a.position.x||b.position.y>=a.position.y+a.size.y||b.position.y+b.size.y<=a.position.y)}},c.Shape=function(){},c.Shape.prototype={__type:"shape",__collision_type:null,is_shape:!0,__data:null,__next_id:0,__init__:function __init__(){this.__position=new c.Vector},test_collide_with:function test_collide_with(d){return c.CollisionManager.test_collision(this,d)},repel:function repel(d,e,f,g,h){e=e||1,f=f||1,void 0===g&&(g=0),void 0===h&&(h=1);var k,l,m=this.get_repel_direction(d).multiply_scalar_self(e);h&&(k=m.multiply_scalar(h)),g&&(l=m.multiply_scalar(-1*g));for(var n=c.Vector.ZERO.clone(),o=!0;o&&0<f;)f--,k&&d.move(k),l&&this.move(l),n.add_self(m),o=this.test_collide_with(d);return n},get_repel_direction:function get_repel_direction(d){var f,e=this.get_abs_center();return f=d instanceof c.Vector?d:d.get_abs_center(),f.sub(e).normalize_self()},set_data:function set_data(d){return this.__data=d,this},get_data:function get_data(){return this.__data},get_name:function get_name(){return this.__type},set_position:function set_position(d){return this.__position.x=d.x,this.__position.y=d.y,this.__update_position(),this},get_position:function get_position(){return this.__position.clone()},move:function move(d){return this.set_position(this.__position.add(d)),this},__update_position:function __update_position(){this.__update_position_hook&&this.__update_position_hook(),this.__aabb&&this.__update_aabb_pos()},__update_aabb_pos:function __update_aabb_pos(){this.__aabb.position=this.__position},get_abs_center:function get_abs_center(){var d=this.get_aabb();return d.position.add(d.size.multiply_scalar(0.5))},reset_aabb:function reset_aabb(){this.__aabb=void 0},__update_position_hook:null,build_aabb:function build_aabb(){throw new c.NotImplementedError},get_aabb:function get_aabb(){return this.__aabb=this.__aabb||this.build_aabb(),this.__aabb}},c.Circle=function(d,e){this.init(),this.__radius=e,this.__size=new c.Vector(e,e).multiply_scalar_self(2),this.set_position(d)},c.Circle.prototype={__type:"circle",__collision_type:"circle",get_radius:function get_radius(){return this.__radius},__update_aabb_pos:function __update_aabb_pos(){this.__aabb.position=this.__position.sub_scalar(this.__radius)},build_aabb:function build_aabb(){return new c.AABB(this.__position.sub_scalar(this.__radius),this.__size)},get_abs_center:function get_abs_center(){return this.__position.clone()}},c.extend(c.Shape.prototype,c.Circle.prototype),c.Rectangle=function(d,e){this.init(),this.__size=e,this.set_position(d)},c.Rectangle.prototype={__type:"rectangle",__collision_type:"rectangle",get_size:function get_size(){return this.__size.clone()},build_aabb:function build_aabb(){return new c.AABB(this.__position,this.__size)},get_top_left:function get_top_left(){return this.__top_left_c=this.__top_left_c||this.__position.clone(),this.__top_left_c},get_bottom_left:function get_bottom_left(){return this.__bottom_left_c=this.__bottom_left_c||this.__position.add(new c.Vector(0,this.__size.y)),this.__bottom_left_c},get_top_right:function get_top_right(){return this.__top_right_c=this.__top_right_c||this.__position.add(new c.Vector(this.__size.x,0)),this.__top_right_c},get_bottom_right:function get_bottom_right(){return this.__bottom_right_c=this.__bottom_right_c||this.__position.add(new c.Vector(this.__size.x,this.__size.y)),this.__bottom_right_c},get_abs_center:function get_abs_center(){return this.__abs_center_c=this.__abs_center_c||this.__position.add(this.__size.divide_scalar(2)),this.__abs_center_c},__update_position_hook:function __update_position_hook(){this.__top_left_c=void 0,this.__top_right_c=void 0,this.__bottom_left_c=void 0,this.__bottom_right_c=void 0,this.__abs_center_c=void 0}},c.extend(c.Shape.prototype,c.Rectangle.prototype),c.Line=function(d,e){this.init(),this.__dest=e,this.set_position(d)},c.Line.prototype={__type:"line",__collision_type:"line",build_aabb:function build_aabb(){var d=new c.Vector(0,0);d.x=0<this.__dest.x?this.__position.x:this.__position.x+this.__dest.x,d.y=0<this.__dest.y?this.__position.y:this.__position.y+this.__dest.y;var e=this.__dest.apply(Math.abs);return new c.AABB(d,e)},get_p1:function get_p1(){return this.__p1_c=this.__p1_c||this.__position.clone(),this.__p1_c},get_p2:function get_p2(){return this.__p2_c=this.__p2_c||this.__position.add(this.__dest),this.__p2_c},__update_position_hook:function __update_position_hook(){this.__p1_c=void 0,this.__p2_c=void 0}},c.extend(c.Shape.prototype,c.Line.prototype),c.LineStrip=function(d,e,f){if(this.init(),this.__points=e,1>=e.length)throw new c.IllegalActionError("Not enough vectors for LineStrip (got to have at least two vectors)");f&&this.__points.push(this.__points[0]),this.set_position(d)},c.LineStrip.prototype={__type:"line-strip",__collision_type:"line-strip",get_abs_lines:function get_abs_lines(){if(this.__abs_lines_c)return this.__abs_lines_c;for(var d=this.get_abs_points(),e=[],f=0;f<d.length-1;f++)e.push([d[f],d[f+1]]);return this.__abs_lines_c=e,e},get_abs_points:function get_abs_points(){if(this.__abs_points_c)return this.__abs_points_c;for(var d=[],e=0;e<this.__points.length;e++)d.push(this.__points[e].add(this.__position));return this.__abs_points_c=d,d},__update_position_hook:function __update_position_hook(){this.__abs_points_c=void 0,this.__abs_lines_c=void 0},__update_aabb_pos:function __update_aabb_pos(){this.__aabb.position.set(this.__aabb_offset_c.add(this.__position))},build_aabb:function build_aabb(){for(var d=new c.AABB(c.Vector.ZERO,c.Vector.ZERO),e=0;e<this.__points.length;++e)d.add_vector(this.__points[e]);return this.__aabb_offset_c=d.position.clone(),d.position.add_self(this.__position),d}},c.extend(c.Shape.prototype,c.LineStrip.prototype),c.CompositeShape=function(d,e){this.init(),this.__init_comp_shape(d,e)},c.CompositeShape.prototype={__type:"composite-shape",__collision_type:"composite-shape",__init_comp_shape:function __init_comp_shape(d,e){if(this.__shapes=[],d=d||c.Vector.ZERO,this.set_position(d),e)for(var f=0;f<e.length;++f)this.add(e[f])},repel:function repel(d,e,f,g,h){for(var m,k=c.Vector.ZERO.clone(),l=0;l<this.__shapes.length;++l)m=this.__shapes[l].shape,m.test_collide_with(d)&&k.add_self(m.repel(d,e,f,0,h));return 0!==(g||0)&&this.move(k.multiply_scalar(-1*g)),k},get_shapes:function get_shapes(){if(this.__shapes_list_c)return this.__shapes_list_c;for(var d=[],e=0;e<this.__shapes.length;++e)d.push(this.__shapes[e].shape);return this.__shapes_list_c=d,d},build_aabb:function build_aabb(){if(0===this.__shapes.length)return this.__aabb_pos_offset_c=c.Vector.ZERO,new c.AABB(c.Vector.ZERO,c.Vector.ZERO);for(var f,d=null,e=0;e<this.__shapes.length;++e)f=this.__shapes[e].shape.get_aabb(),d?d.expand(f):d=f;return this.__aabb_pos_offset_c=d.position.sub(this.__position),d},__update_aabb_pos:function __update_aabb_pos(){this.__aabb.position=this.__position.add(this.__aabb_pos_offset_c)},add:function add(d){var e=d.__position;return this.__shapes_list_c=void 0,this.__shapes.push({shape:d,offset:e.clone()}),d.set_position(this.__position.add(e)),this.reset_aabb(),d.__collision_tags_val=this.__collision_tags_val,d.__collision_tags=this.__collision_tags,d.__override_fill_color=this.__override_fill_color,d.__override_stroke_color=this.__override_stroke_color,d},__update_tags_hook:function __update_tags_hook(){for(var e,d=0;d<this.__shapes;++d)e=this.__shapes[d].shape,e.__collision_tags_val=this.__collision_tags_val,e.__collision_tags=this.__collision_tags},remove:function remove(d){this.__shapes_list_c=void 0;for(var e=0;e<this.__shapes.length;++e)if(this.__shapes[e].shape===d)return void this.__shapes.splice(e,1);throw new c.IllegalActionError("Shape to remove is not in composite shape!")},__update_position_hook:function __update_position_hook(){for(var d=0;d<this.__shapes.length;++d)this.__shapes[d].shape.set_position(this.__position.add(this.__shapes[d].offset))}},c.extend(c.Shape.prototype,c.CompositeShape.prototype),c.Capsule=function(d,e,f){this.init(),void 0===f&&(f=!0),objects=[],f?(e=e.clone(),e.y-=e.x,objects.push(new c.Rectangle(new c.Vector(0.5*-e.x,0.5*-e.y),e)),objects.push(new c.Circle(new c.Vector(0,0.5*-e.y),0.5*e.x)),objects.push(new c.Circle(new c.Vector(0,0.5*e.y),0.5*e.x))):(e=e.clone(),e.y-=e.x,objects.push(new c.Rectangle(new c.Vector(0.5*-e.y,0.5*-e.x),e.flip())),objects.push(new c.Circle(new c.Vector(0.5*-e.y,0),0.5*e.x)),objects.push(new c.Circle(new c.Vector(0.5*e.y,0),0.5*e.x))),this.__init_comp_shape(d,objects)},c.Capsule.prototype={__type:"capsule"},c.extend(c.CompositeShape.prototype,c.Capsule.prototype),c.CollisionManager={test_collision:function test_collision(d,e){if(d instanceof c.Vector&&e instanceof c.Vector)return this._test_collision_vector_vector(d,e);if("composite-shape"==d.__collision_type)return this._test_collision_composite_shape(d,e);if("composite-shape"==e.__collision_type)return this._test_collision_composite_shape(e,d);if(d instanceof c.Vector&&"circle"==e.__collision_type)return this._test_collision_circle_vector(e,d);if("circle"==d.__collision_type&&e instanceof c.Vector)return this._test_collision_circle_vector(d,e);if("circle"==d.__collision_type&&"circle"==e.__collision_type)return this._test_collision_circle_circle(e,d);if("circle"==d.__collision_type&&"rectangle"==e.__collision_type)return this._test_collision_circle_rect(d,e);if("rectangle"==d.__collision_type&&"circle"==e.__collision_type)return this._test_collision_circle_rect(e,d);if("circle"==d.__collision_type&&"line"==e.__collision_type)return this._test_collision_circle_line(d,e);if("line"==d.__collision_type&&"circle"==e.__collision_type)return this._test_collision_circle_line(e,d);if("line-strip"==d.__collision_type&&"line"==e.__collision_type)return this._test_collision_linestrip_line(d,e);if("line"==d.__collision_type&&"line-strip"==e.__collision_type)return this._test_collision_linestrip_line(e,d);if("circle"==d.__collision_type&&"line-strip"==e.__collision_type)return this._test_collision_circle_linestrip(d,e);if("line-strip"==d.__collision_type&&"circle"==e.__collision_type)return this._test_collision_circle_linestrip(e,d);if(d instanceof c.Vector&&"rectangle"==e.__collision_type)return this._test_collision_rect_vector(e,d);if("rectangle"==d.__collision_type&&e instanceof c.Vector)return this._test_collision_rect_vector(d,e);if("rectangle"==d.__collision_type&&"rectangle"==e.__collision_type)return this._test_collision_rect_rect(e,d);if("line-strip"==d.__collision_type&&"line-strip"==e.__collision_type)return this._test_collision_linestrip_linestrip(d,e);if("line"==d.__collision_type&&"rectangle"==e.__collision_type)return this._test_collision_rect_line(e,d);if("rectangle"==d.__collision_type&&"line"==e.__collision_type)return this._test_collision_rect_line(d,e);if("line-strip"==d.__collision_type&&"rectangle"==e.__collision_type)return this._test_collision_rect_linestrip(e,d);if("rectangle"==d.__collision_type&&"line-strip"==e.__collision_type)return this._test_collision_rect_linestrip(d,e);if("line"==d.__collision_type&&"line"==e.__collision_type)return this._test_collision_line_line(d,e);if("line"==d.__collision_type&&e instanceof c.Vector)return this._test_collision_vector_line(e,d);if(d instanceof c.Vector&&"line"==e.__collision_type)return this._test_collision_vector_line(d,e);if("line-strip"==d.__collision_type&&e instanceof c.Vector)return this._test_collision_vector_linestrip(e,d);if(d instanceof c.Vector&&"line-strip"==e.__collision_type)return this._test_collision_vector_linestrip(d,e);throw new c.UnsupportedShapes(d,e)},_test_collision_vector_vector:function _test_collision_vector_vector(d,e){return d.x===e.x&&d.y===e.y},_test_collision_circle_vector:function _test_collision_circle_vector(d,e){return c.Math.distance(d.__position,e)<=d.__radius},_test_collision_circle_circle:function _test_collision_circle_circle(d,e){return c.Math.distance(d.__position,e.__position)<=d.__radius+e.__radius},_test_collision_rect_vector:function _test_collision_rect_vector(d,e){return e.x>=d.__position.x&&e.y>=d.__position.y&&e.x<=d.__position.x+d.__size.x&&e.y<=d.__position.y+d.__size.y},_test_collision_vector_line:function _test_collision_vector_line(d,e){return c.Math.is_on_line(d,e.get_p1(),e.get_p2())},_test_collision_vector_linestrip:function _test_collision_vector_linestrip(d,e){for(var f=e.get_abs_lines(),g=0;g<f.length;++g)if(c.Math.is_on_line(d,f[g][0],f[g][1]))return!0;return!1},_test_collision_circle_line:function _test_collision_circle_line(d,e){return c.Math.distance_to_line(d.__position,e.get_p1(),e.get_p2())<=d.__radius},_test_collision_circle_linestrip:function _test_collision_circle_linestrip(d,e){for(var f=e.get_abs_lines(),g=0;g<f.length;++g)if(c.Math.distance_to_line(d.__position,f[g][0],f[g][1])<=d.__radius)return!0;return!1},_test_collision_linestrip_line:function _test_collision_linestrip_line(d,e){for(var f=d.get_abs_lines(),g=e.get_p1(),h=e.get_p2(),k=0;k<f.length;++k)if(c.Math.line_intersects(g,h,f[k][0],f[k][1]))return!0;return!1},_test_collision_line_line:function _test_collision_line_line(d,e){return c.Math.line_intersects(d.get_p1(),d.get_p2(),e.get_p1(),e.get_p2())},_test_collision_rect_line:function _test_collision_rect_line(d,e){var f=e.get_p1(),g=e.get_p2();if(c.CollisionManager._test_collision_rect_vector(d,f)||c.CollisionManager._test_collision_rect_vector(d,g))return!0;var h=d.get_top_left(),k=d.get_bottom_left();if(c.Math.line_intersects(f,g,h,k))return!0;var l=d.get_top_right(),m=d.get_bottom_right();return!!c.Math.line_intersects(f,g,l,m)||!!c.Math.line_intersects(f,g,h,l)||!!c.Math.line_intersects(f,g,k,m)},_test_collision_rect_linestrip:function _test_collision_rect_linestrip(d,e){for(var f=e.get_abs_points(),g=0;g<f.length;++g)if(this._test_collision_rect_vector(d,f[g]))return!0;for(var h=d.get_top_left(),k=d.get_bottom_left(),l=d.get_top_right(),m=d.get_bottom_right(),n=e.get_abs_lines(),g=0;g<n.length;++g){var o=n[g][0],q=n[g][1];if(c.Math.line_intersects(o,q,h,k))return!0;if(c.Math.line_intersects(o,q,l,m))return!0;if(c.Math.line_intersects(o,q,h,l))return!0;if(c.Math.line_intersects(o,q,k,m))return!0}return!1},_test_collision_linestrip_linestrip:function _test_collision_linestrip_linestrip(d,e){for(var f=d.get_abs_lines(),g=e.get_abs_lines(),h=0;h<f.length;++h)for(var k=0;k<g.length;++k)if(c.Math.line_intersects(f[h][0],f[h][1],g[k][0],g[k][1]))return!0;return!1},_test_collision_composite_shape:function _test_collision_composite_shape(d,e){var f=d.get_shapes();if("composite-shape"==e.__collision_type){for(var g=e.get_shapes(),h=0;h<f.length;++h)for(var k=0;k<g.length;++k)if(c.CollisionManager.test_collision(f[h],g[k]))return!0;}else for(var h=0;h<f.length;++h)if(c.CollisionManager.test_collision(f[h],e))return!0;return!1},_test_collision_circle_rect:function _test_collision_circle_rect(d,e){var f=d.__position,g=c.CollisionManager._test_collision_rect_vector(e,f);if(g)return!0;var h=e.get_abs_center(),g=c.CollisionManager._test_collision_circle_vector(d,h);if(g)return!0;var k=[];h.x>f.x?k.push([e.get_top_left(),e.get_bottom_left()]):k.push([e.get_top_right(),e.get_bottom_right()]),h.y>f.y?k.push([e.get_top_left(),e.get_top_right()]):k.push([e.get_bottom_left(),e.get_bottom_right()]);for(var m,l=0;l<k.length;++l)if(m=c.Math.distance_to_line(f,k[l][0],k[l][1]),m<=d.__radius)return!0;return!1},_test_collision_rect_rect:function _test_collision_rect_rect(d,e){return!(e.__position.x>=d.__position.x+d.__size.x||e.__position.x+e.__size.x<=d.__position.x||e.__position.y>=d.__position.y+d.__size.y||e.__position.y+e.__size.y<=d.__position.y)}},c.UnsupportedShapes=function(d,e){this.name="Unsupported Shapes",this.message="Unsupported shapes collision test! '"+d.get_name()+"' <-> '"+e.get_name()+"'."},c.UnsupportedShapes.prototype=Error.prototype,c}();"undefined"!=typeof exports&&(exports.sscd=SSCD);