## :busts_in_silhouette: Contributing
This page discusses about how to contribute properly and what are the things you need to know.

### :books: Contributing to `/docs`

The documentations in this repository is undeniably inconsistent, bland, and a bit messy. You are allowed to improve the documentation only if you follow the correct default format and if the contents are correct.

1. Follow the default format. This includes the title being aligned at the center, the usage of badges like <kbd>Nullable</kbd>, and the `Related links` as the footer section.
2. The contents should be correct. This includes the correct data type of the property, the correct count of properties, and the correct referrer to the snippets.
3. The document path MUST NOT change. They have their own folder category and filename. Changing its path will lead to inconsistent connection of links.

### :package: Contributing to `/dist`

The distribution folder includes all the script that gives life to this repository. As this affects the whole repository, I will be stricter on this folder than the documentations.

#### :card_file_box: Bundled contribution

Since this includes the script, you should also add changes to the documentations. The modification of the documentation must relate to your modified script.

#### :construction: Disallowed contributions

I will not allow any additional classes and methods in the mean time. However, I allow additional properties and variables.

Of course, you are allowed to modify anything, unless the class names, property names, and method names. These modification should be:

1. Bug fixing &ndash; If there is a producible bug such as wrong http request url.
2. Correction &ndash; If there is an incorrect stuffs such as wrong key name.

And nothing else.

#### :fallen_leaf: New feature update

As I mentioned earlier, I do not allow additional stuffs except for properties and variables. However, if you would like to make a new feature, you should open an issue first.

<img src="https://komarev.com/ghpvc/?username=creuserr" alt="" width="0"></img>
