SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for nuclear_power_plants
-- ----------------------------
DROP TABLE IF EXISTS `nuclear_power_plants`;
CREATE TABLE `nuclear_power_plants`  (
  `id` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `latitude` decimal(10, 6) NULL DEFAULT NULL,
  `longitude` decimal(10, 6) NULL DEFAULT NULL,
  `country_code` char(2) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `status_id` tinyint(4) UNSIGNED NOT NULL,
  `reactor_type_id` tinyint(4) UNSIGNED NULL DEFAULT NULL,
  `reactor_model` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `construction_start_at` date NULL DEFAULT NULL,
  `operational_from` date NULL DEFAULT NULL,
  `operational_to` date NULL DEFAULT NULL,
  `capacity` int(4) UNSIGNED NULL DEFAULT NULL COMMENT 'in MWe',
  `source` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `last_updated_at` datetime NULL DEFAULT NULL,
  `iaea_id` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `idx_name`(`name`) USING BTREE,
  INDEX `fk_nuclear_power_plants_countries_code`(`country_code`) USING BTREE,
  INDEX `fk_nuclear_power_plants_status_type_id`(`status_id`) USING BTREE,
  INDEX `fk_nuclear_power_plants_nuclear_reactor_type_id`(`reactor_type_id`) USING BTREE,
  CONSTRAINT `fk_nuclear_power_plants_countries_code` FOREIGN KEY (`country_code`) REFERENCES `countries` (`code`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_nuclear_power_plants_nuclear_reactor_type_id` FOREIGN KEY (`reactor_type_id`) REFERENCES `nuclear_reactor_type` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_nuclear_power_plants_status_type_id` FOREIGN KEY (`status_id`) REFERENCES `nuclear_power_plant_status_type` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 821 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci COMMENT = 'GeoNuclearData\r\n\r\n# https://github.com/cristianst85/GeoNuclearData\r\n\r\nVERSION\r\n\r\n# Database version: 0.17.0 (2020/04/19)\r\n# Dataset last updated in version: 0.17.17 (2024/03/03)\r\n\r\nCHANGELOG\r\n\r\n# For full changelog see:\r\n# https://github.com/cristianst85/GeoNuclearData/blob/master/CHANGELOG.md\r\n\r\nLICENSE\r\n\r\n# Copyright (c) 2015-2024 Cristian Stoica.\r\n#\r\n# The GeoNuclearData database is made available under the\r\n# Open Database License whose full text can be found at\r\n# https://opendatacommons.org/licenses/odbl/1.0/.\r\n#\r\n# Any rights in individual contents of the database are licensed\r\n# under the Database Contents License whose full text can be\r\n# found at https://opendatacommons.org/licenses/dbcl/1.0/. \r\n\r\n' ROW_FORMAT = COMPACT;

-- ----------------------------
-- Records of nuclear_power_plants
-- ----------------------------
INSERT INTO `nuclear_power_plants` VALUES (1, 'Ågesta', 59.206000, 18.082900, 'SE', 5, 20, NULL, '1957-12-01', '1964-05-01', '1974-06-02', 9, 'WNA/IAEA', '2015-05-24 04:51:37', 528);
INSERT INTO `nuclear_power_plants` VALUES (2, 'Akademik Lomonosov-1', 69.709579, 170.306250, 'RU', 3, 21, 'KLT-40S \'Floating\'', '2007-04-15', '2020-05-22', NULL, 30, 'WNA/IAEA/Google Maps', '2021-05-31 00:00:00', 895);
INSERT INTO `nuclear_power_plants` VALUES (3, 'Akademik Lomonosov-2', 69.709579, 170.306250, 'RU', 3, 21, 'KLT-40S \'Floating\'', '2007-04-15', '2020-05-22', NULL, 30, 'WNA/IAEA/Google Maps', '2021-05-31 00:00:00', 896);
INSERT INTO `nuclear_power_plants` VALUES (4, 'Akhvaz-1', NULL, NULL, 'IR', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (5, 'Akhvaz-2', NULL, NULL, 'IR', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (6, 'Akkuyu-1', 36.144444, 33.541111, 'TR', 2, 21, 'VVER V-509', '2018-04-03', NULL, NULL, 1114, 'WNA/Wikipedia/IAEA', '2018-07-01 01:21:08', 553);
INSERT INTO `nuclear_power_plants` VALUES (7, 'Akkuyu-2', 36.144444, 33.541111, 'TR', 2, 21, 'VVER V-509', '2020-04-08', NULL, NULL, 1114, 'Wikipedia/IAEA', '2020-08-31 01:39:56', 1080);
INSERT INTO `nuclear_power_plants` VALUES (8, 'Akkuyu-3', 36.144444, 33.541111, 'TR', 2, 21, 'VVER V-509', '2021-03-10', NULL, NULL, 1114, 'Wikipedia/IAEA', '2021-04-20 02:47:37', 1081);
INSERT INTO `nuclear_power_plants` VALUES (9, 'Akkuyu-4', 36.144444, 33.541111, 'TR', 2, 21, 'VVER V-509', '2022-07-21', NULL, NULL, 1114, 'Wikipedia/IAEA', '2022-09-24 22:33:57', 1082);
INSERT INTO `nuclear_power_plants` VALUES (10, 'Aktau (Shevchenko)', 43.607000, 51.283000, 'KZ', 5, 7, 'BN-350', '1964-10-01', '1973-07-16', '1999-04-22', 52, 'WNA/IAEA', '2021-10-01 00:14:53', 414);
INSERT INTO `nuclear_power_plants` VALUES (11, 'Almaraz-1', 39.807000, -5.698000, 'ES', 3, 21, 'WH 3LP', '1973-07-03', '1983-09-01', NULL, 900, 'WNA/IAEA', '2017-02-10 23:56:15', 153);
INSERT INTO `nuclear_power_plants` VALUES (12, 'Almaraz-2', 39.807000, -5.698000, 'ES', 3, 21, 'WH 3LP', '1973-07-03', '1984-07-01', NULL, 900, 'WNA/IAEA', '2019-06-02 20:17:55', 154);
INSERT INTO `nuclear_power_plants` VALUES (13, 'Angra-1', -23.008000, -44.457000, 'BR', 3, 21, 'WH 2LP', '1971-05-01', '1985-01-01', NULL, 609, 'WNA/IAEA', '2021-02-14 03:47:53', 24);
INSERT INTO `nuclear_power_plants` VALUES (14, 'Angra-2', -23.008000, -44.457000, 'BR', 3, 21, 'PRE KONVOI', '1976-01-01', '2001-02-01', NULL, 1245, 'WNA/IAEA', '2015-05-24 04:50:19', 25);
INSERT INTO `nuclear_power_plants` VALUES (15, 'Angra-3', -23.010000, -44.470000, 'BR', 2, 21, 'PRE KONVOI', '2010-05-30', NULL, NULL, 1340, 'WNA/IAEA', '2023-08-28 08:01:45', 26);
INSERT INTO `nuclear_power_plants` VALUES (16, 'APS-1 Obninsk', 55.084000, 36.570000, 'RU', 5, 17, 'AM-1', '1951-01-01', '1954-12-01', '2002-04-29', 5, 'WNA/IAEA', '2015-05-24 04:51:32', 447);
INSERT INTO `nuclear_power_plants` VALUES (17, 'Arkansas Nuclear One-1 (ANO-1)', 35.310000, -93.230000, 'US', 3, 21, 'B&W LLP (DRYAMB)', '1968-10-01', '1974-12-19', NULL, 850, 'WNA/IAEA', '2017-02-10 23:58:30', 652);
INSERT INTO `nuclear_power_plants` VALUES (18, 'Arkansas Nuclear One-2 (ANO-2)', 35.310000, -93.229000, 'US', 3, 21, 'CE 2LP (DRYAMB)', '1968-12-06', '1980-03-26', NULL, 912, 'WNA/IAEA', '2017-02-10 23:58:53', 689);
INSERT INTO `nuclear_power_plants` VALUES (19, 'Armenian-1', 40.182000, 44.147000, 'AM', 5, 21, 'VVER V-270', '1969-07-01', '1977-10-06', '1989-02-25', 376, 'WNA/IAEA', '2021-06-07 00:00:00', 1);
INSERT INTO `nuclear_power_plants` VALUES (20, 'Armenian-2', 40.182000, 44.147000, 'AM', 3, 21, 'VVER V-270', '1975-07-01', '1980-05-03', NULL, 375, 'WNA/IAEA', '2021-06-29 00:12:17', 2);
INSERT INTO `nuclear_power_plants` VALUES (21, 'Armenian-3', 40.180800, 44.147200, 'AM', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', '2021-06-07 00:00:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (22, 'Asco-1', 41.202000, 0.571000, 'ES', 3, 21, 'WH 3LP', '1974-05-16', '1984-12-10', NULL, 888, 'WNA/IAEA', '2023-08-28 08:01:45', 155);
INSERT INTO `nuclear_power_plants` VALUES (23, 'Asco-2', 41.202000, 0.571000, 'ES', 3, 21, 'WH 3LP', '1975-03-07', '1986-03-31', NULL, 888, 'WNA/IAEA', '2023-08-28 08:01:45', 156);
INSERT INTO `nuclear_power_plants` VALUES (24, 'Atucha-1', -33.967000, -59.209000, 'AR', 3, 20, 'PHWR KWU', '1968-05-31', '1974-06-23', NULL, 319, 'WNA/IAEA', '2024-03-03 20:43:43', 3);
INSERT INTO `nuclear_power_plants` VALUES (25, 'Atucha-2', -33.967000, -59.209000, 'AR', 3, 20, 'PHWR KWU', '1981-07-13', '2016-05-25', NULL, 692, 'WNA/IAEA', '2023-08-28 08:01:45', 5);
INSERT INTO `nuclear_power_plants` VALUES (26, 'Balakovo-1', 52.092000, 47.952000, 'RU', 3, 21, 'VVER V-320', '1980-12-01', '1986-05-23', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:36', 524);
INSERT INTO `nuclear_power_plants` VALUES (27, 'Balakovo-2', 52.092000, 47.952000, 'RU', 3, 21, 'VVER V-320', '1981-08-01', '1988-01-18', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:36', 525);
INSERT INTO `nuclear_power_plants` VALUES (28, 'Balakovo-3', 52.092000, 47.952000, 'RU', 3, 21, 'VVER V-320', '1982-11-01', '1989-04-08', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:36', 526);
INSERT INTO `nuclear_power_plants` VALUES (29, 'Balakovo-4', 52.092000, 47.952000, 'RU', 3, 21, 'VVER V-320', '1984-04-01', '1993-12-22', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:36', 527);
INSERT INTO `nuclear_power_plants` VALUES (30, 'Baltic-1', 54.939000, 22.162000, 'RU', 2, 21, 'VVER V-491', '2012-02-22', NULL, NULL, 1109, 'WNA/IAEA', '2015-05-24 04:51:57', 968);
INSERT INTO `nuclear_power_plants` VALUES (31, 'Barakah-1 (Braka)', 23.952748, 52.193298, 'AE', 3, 21, 'APR-1400', '2012-07-19', '2021-04-01', NULL, 1310, 'WNA/IAEA', '2023-08-28 08:01:45', 1050);
INSERT INTO `nuclear_power_plants` VALUES (32, 'Barakah-2 (Braka)', 23.952748, 52.193298, 'AE', 3, 21, 'APR-1400', '2013-04-15', '2022-03-24', NULL, 1310, 'WNA/IAEA', '2023-08-28 08:01:45', 1051);
INSERT INTO `nuclear_power_plants` VALUES (33, 'Barakah-3 (Braka)', 23.952748, 52.203298, 'AE', 3, 21, 'APR-1400', '2014-09-24', '2023-02-24', NULL, 1310, 'WNA/IAEA', '2023-08-28 08:01:45', 1052);
INSERT INTO `nuclear_power_plants` VALUES (34, 'Chutka-1', NULL, NULL, 'IN', 1, 20, NULL, NULL, NULL, NULL, NULL, 'WNA', '2021-06-07 00:00:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (35, 'Chutka-2', NULL, NULL, 'IN', 1, 20, NULL, NULL, NULL, NULL, NULL, 'WNA', '2021-06-07 00:00:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (36, 'Barseback-1', 55.745000, 12.926000, 'SE', 5, 5, 'AA-II', '1971-02-01', '1975-07-01', '1999-11-30', 570, 'WNA/IAEA', '2018-03-10 14:52:00', 538);
INSERT INTO `nuclear_power_plants` VALUES (37, 'Barseback-2', 55.745000, 12.926000, 'SE', 5, 5, 'AA-II', '1973-01-01', '1977-07-01', '2005-05-31', 570, 'WNA/IAEA', '2018-03-10 14:52:02', 540);
INSERT INTO `nuclear_power_plants` VALUES (38, 'Beaver Valley-1', 40.624000, -80.432000, 'US', 3, 21, 'WH 3LP (DRYSUB)', '1970-06-26', '1976-10-01', NULL, 835, 'WNA/IAEA', '2017-02-10 23:58:44', 669);
INSERT INTO `nuclear_power_plants` VALUES (39, 'Beaver Valley-2', 40.624000, -80.432000, 'US', 3, 21, 'WH 3LP (DRYSUB)', '1974-05-03', '1987-11-17', NULL, 836, 'WNA/IAEA', '2017-02-10 23:58:59', 712);
INSERT INTO `nuclear_power_plants` VALUES (40, 'Belarusian-1', 54.766667, 26.116667, 'BY', 3, 21, 'VVER V-491', '2013-11-08', '2021-06-10', NULL, 1110, 'IAEA', '2021-10-01 00:14:53', 1056);
INSERT INTO `nuclear_power_plants` VALUES (41, 'Belarusian-2', 54.766667, 26.116667, 'BY', 3, 21, 'VVER V-491', '2014-04-27', '2023-11-01', NULL, 1110, 'IAEA', '2024-03-03 20:43:43', 1061);
INSERT INTO `nuclear_power_plants` VALUES (42, 'Belene-1', 43.624530, 25.186750, 'BG', 9, 21, NULL, '1987-01-01', NULL, NULL, 953, 'WNA/IAEA', '2021-02-14 00:57:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (43, 'Belene-2', 43.624530, 25.186500, 'BG', 9, 21, NULL, '1987-03-31', NULL, NULL, 953, 'WNA/IAEA', '2021-02-14 00:57:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (44, 'Belleville-1', 47.511000, 2.871000, 'FR', 3, 21, 'P4 REP 1300', '1980-05-01', '1988-06-01', NULL, 1310, 'WNA/IAEA', '2015-05-24 04:51:02', 211);
INSERT INTO `nuclear_power_plants` VALUES (45, 'Belleville-2', 47.511000, 2.871000, 'FR', 3, 21, 'P4 REP 1300', '1980-08-01', '1989-01-01', NULL, 1310, 'WNA/IAEA', '2015-05-24 04:51:02', 212);
INSERT INTO `nuclear_power_plants` VALUES (46, 'Beloyarsk-1', 56.842000, 61.321000, 'RU', 5, 17, 'AMB-100', '1958-06-01', '1964-04-26', '1983-01-01', 102, 'WNA/IAEA', '2015-05-24 04:51:34', 488);
INSERT INTO `nuclear_power_plants` VALUES (47, 'Beloyarsk-2', 56.842000, 61.321000, 'RU', 5, 17, 'AMB-200', '1962-01-01', '1969-12-01', '1990-01-01', 146, 'WNA/IAEA', '2015-05-24 04:51:35', 503);
INSERT INTO `nuclear_power_plants` VALUES (48, 'Beloyarsk-3', 56.842000, 61.321000, 'RU', 3, 7, 'BN-600', '1969-01-01', '1981-11-01', NULL, 560, 'WNA/IAEA', '2015-05-24 04:51:34', 484);
INSERT INTO `nuclear_power_plants` VALUES (49, 'Beloyarsk-4', 56.842000, 61.321000, 'RU', 3, 7, 'BN-800', '2006-07-18', '2016-10-31', NULL, 820, 'WNA/IAEA', '2017-09-25 03:19:53', 451);
INSERT INTO `nuclear_power_plants` VALUES (50, 'Beloyarsk-5', 56.842000, 61.321000, 'RU', 1, 7, 'BN-1200', NULL, NULL, NULL, NULL, 'WNA/Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (51, 'Berkeley-1', 51.692000, -2.494000, 'GB', 5, 8, 'MAGNOX', '1957-01-01', '1962-06-12', '1989-03-31', 138, 'WNA/IAEA', '2015-05-24 04:51:19', 264);
INSERT INTO `nuclear_power_plants` VALUES (52, 'Berkeley-2', 51.692000, -2.494000, 'GB', 5, 8, 'MAGNOX', '1957-01-01', '1962-10-20', '1988-10-26', 138, 'WNA/IAEA', '2015-05-24 04:51:19', 265);
INSERT INTO `nuclear_power_plants` VALUES (53, 'Beznau-1', 47.552000, 8.229000, 'CH', 3, 21, 'WH 2LP', '1965-09-01', '1969-12-09', NULL, 350, 'WNA/IAEA', '2022-04-21 20:26:19', 55);
INSERT INTO `nuclear_power_plants` VALUES (54, 'Beznau-2', 47.552000, 8.229000, 'CH', 3, 21, 'WH 2LP', '1968-01-01', '1972-03-04', NULL, 350, 'WNA/IAEA', '2023-08-28 08:01:45', 57);
INSERT INTO `nuclear_power_plants` VALUES (55, 'Biblis-A', 49.709000, 8.415000, 'DE', 5, 21, 'PWR', '1970-01-01', '1975-02-26', '2011-08-06', 1146, 'WNA/IAEA', '2015-05-24 04:50:42', 85);
INSERT INTO `nuclear_power_plants` VALUES (56, 'Biblis-B', 49.709000, 8.415000, 'DE', 5, 21, 'PWR', '1972-02-01', '1977-01-31', '2011-08-06', 1178, 'WNA/IAEA', '2015-05-24 04:50:42', 91);
INSERT INTO `nuclear_power_plants` VALUES (57, 'Big Rock Point', 45.359000, -85.195000, 'US', 5, 5, NULL, '1960-05-01', '1963-03-29', '1997-08-29', 72, 'WNA/IAEA', '2015-05-24 04:51:41', 601);
INSERT INTO `nuclear_power_plants` VALUES (58, 'Bilibino-1', 68.059000, 166.492000, 'RU', 5, 17, 'EGP-6', '1970-01-01', '1974-04-01', '2019-01-14', 11, 'WNA/IAEA', '2019-06-02 20:18:07', 467);
INSERT INTO `nuclear_power_plants` VALUES (59, 'Bilibino-2', 68.059000, 166.492000, 'RU', 3, 17, 'EGP-6', '1970-01-01', '1975-02-01', NULL, 11, 'WNA/IAEA', '2015-05-24 04:51:32', 468);
INSERT INTO `nuclear_power_plants` VALUES (60, 'Bilibino-3', 68.059000, 166.492000, 'RU', 3, 17, 'EGP-6', '1970-01-01', '1976-02-01', NULL, 11, 'WNA/IAEA', '2015-05-24 04:51:32', 469);
INSERT INTO `nuclear_power_plants` VALUES (61, 'Bilibino-4', 68.059000, 166.492000, 'RU', 3, 17, 'EGP-6', '1970-01-01', '1977-01-01', NULL, 11, 'WNA/IAEA', '2015-05-24 04:51:33', 470);
INSERT INTO `nuclear_power_plants` VALUES (62, 'Blayais-1', 45.256000, -0.691000, 'FR', 3, 21, 'CP1', '1977-01-01', '1981-12-01', NULL, 910, 'WNA/IAEA', '2015-05-24 04:50:53', 187);
INSERT INTO `nuclear_power_plants` VALUES (63, 'Blayais-2', 45.256000, -0.691000, 'FR', 3, 21, 'CP1', '1977-01-01', '1983-02-01', NULL, 910, 'WNA/IAEA', '2015-05-24 04:50:54', 188);
INSERT INTO `nuclear_power_plants` VALUES (64, 'Blayais-3', 45.256000, -0.691000, 'FR', 3, 21, 'CP1', '1978-04-01', '1983-11-14', NULL, 910, 'WNA/IAEA', '2015-05-24 04:50:54', 189);
INSERT INTO `nuclear_power_plants` VALUES (65, 'Blayais-4', 45.256000, -0.691000, 'FR', 3, 21, 'CP1', '1978-04-01', '1983-10-01', NULL, 910, 'WNA/IAEA', '2015-05-24 04:50:54', 190);
INSERT INTO `nuclear_power_plants` VALUES (66, 'Bohunice-1', 48.494000, 17.687000, 'SK', 5, 21, 'VVER V-230', '1972-04-24', '1980-04-01', '2006-12-31', 408, 'WNA/IAEA', '2015-05-24 04:51:38', 548);
INSERT INTO `nuclear_power_plants` VALUES (67, 'Bohunice-2', 48.494000, 17.687000, 'SK', 5, 21, 'VVER V-230', '1972-04-24', '1981-01-01', '2008-12-31', 408, 'WNA/IAEA', '2015-05-24 04:51:38', 549);
INSERT INTO `nuclear_power_plants` VALUES (68, 'Bohunice-3', 48.494000, 17.687000, 'SK', 3, 21, 'VVER V-213', '1976-12-01', '1985-02-14', NULL, 466, 'WNA/IAEA', '2021-02-14 03:47:53', 546);
INSERT INTO `nuclear_power_plants` VALUES (69, 'Bohunice-4', 48.494000, 17.687000, 'SK', 3, 21, 'VVER V-213', '1976-12-01', '1985-12-18', NULL, 466, 'WNA/IAEA', '2021-02-14 03:47:53', 547);
INSERT INTO `nuclear_power_plants` VALUES (70, 'Bohunice-A1', 48.494000, 17.687000, 'SK', 5, 11, 'KS 150', '1958-08-01', '1972-12-25', '1977-02-22', 110, 'WNA/IAEA', '2015-05-24 04:51:38', 543);
INSERT INTO `nuclear_power_plants` VALUES (71, 'BONUS', 18.365000, -67.268000, 'US', 5, 5, 'Superheater', '1960-01-01', '1965-09-01', '1968-06-01', 17, 'WNA/IAEA', '2021-06-06 00:00:00', 703);
INSERT INTO `nuclear_power_plants` VALUES (72, 'Borssele', 51.431000, 3.719000, 'NL', 3, 21, 'KWU 2LP', '1969-07-01', '1973-10-26', NULL, 495, 'WNA/IAEA', '2017-02-10 23:57:03', 423);
INSERT INTO `nuclear_power_plants` VALUES (73, 'BR-3', 51.217000, 5.099000, 'BE', 5, 21, 'Prototype', '1957-11-01', '1962-10-10', '1987-06-30', 11, 'WNA/IAEA', '2015-05-24 04:50:07', 8);
INSERT INTO `nuclear_power_plants` VALUES (74, 'Bradwell-1', 51.742000, 0.899000, 'GB', 5, 8, 'MAGNOX', '1957-01-01', '1962-07-01', '2002-03-31', 150, 'WNA/IAEA', '2015-05-24 04:51:19', 266);
INSERT INTO `nuclear_power_plants` VALUES (75, 'Bradwell-2', 51.742000, 0.899000, 'GB', 5, 8, 'MAGNOX', '1957-01-01', '1962-11-12', '2002-03-30', 150, 'WNA/IAEA', '2015-05-24 04:51:19', 267);
INSERT INTO `nuclear_power_plants` VALUES (76, 'Braidwood-1', 41.247000, -88.230000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1975-08-01', '1988-07-29', NULL, 1120, 'WNA/IAEA', '2017-02-10 23:59:18', 737);
INSERT INTO `nuclear_power_plants` VALUES (77, 'Braidwood-2', 41.247000, -88.230000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1975-08-01', '1988-10-17', NULL, 1120, 'WNA/IAEA', '2017-02-10 23:59:19', 738);
INSERT INTO `nuclear_power_plants` VALUES (79, 'Brokdorf', 53.850000, 9.345000, 'DE', 5, 21, 'PWR', '1976-01-01', '1986-12-22', '2021-12-31', 1307, 'WNA/IAEA', '2022-04-21 20:26:19', 107);
INSERT INTO `nuclear_power_plants` VALUES (80, 'Browns Ferry-1', 34.704000, -87.119000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1967-05-01', '1974-12-20', NULL, 1065, 'WNA/IAEA', '2022-04-21 20:26:19', 617);
INSERT INTO `nuclear_power_plants` VALUES (81, 'Browns Ferry-2', 34.704000, -87.119000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1967-05-01', '1975-03-01', NULL, 1065, 'WNA/IAEA', '2015-05-24 04:51:42', 618);
INSERT INTO `nuclear_power_plants` VALUES (82, 'Browns Ferry-3', 34.704000, -87.119000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1968-07-01', '1977-03-01', NULL, 1065, 'WNA/IAEA', '2015-05-24 04:51:43', 641);
INSERT INTO `nuclear_power_plants` VALUES (83, 'Bruce-1', 44.341000, -81.572000, 'CA', 3, 20, 'CANDU 791', '1971-06-01', '1977-09-01', NULL, 732, 'WNA/IAEA', '2022-04-21 20:26:19', 53);
INSERT INTO `nuclear_power_plants` VALUES (84, 'Bruce-2', 44.341000, -81.572000, 'CA', 3, 20, 'CANDU 791', '1970-12-01', '1977-09-01', NULL, 732, 'WNA/IAEA', '2022-04-21 20:26:19', 54);
INSERT INTO `nuclear_power_plants` VALUES (85, 'Bruce-3', 44.341000, -81.572000, 'CA', 3, 20, 'CANDU 750A', '1972-07-01', '1978-02-01', NULL, 750, 'WNA/IAEA', '2022-04-21 20:26:19', 30);
INSERT INTO `nuclear_power_plants` VALUES (86, 'Bruce-4', 44.341000, -81.572000, 'CA', 3, 20, 'CANDU 750A', '1972-09-01', '1979-01-18', NULL, 750, 'WNA/IAEA', '2022-04-21 20:26:19', 31);
INSERT INTO `nuclear_power_plants` VALUES (87, 'Bruce-5', 44.341000, -81.572000, 'CA', 3, 20, 'CANDU 750B', '1978-05-31', '1985-02-28', NULL, 822, 'WNA/IAEA', '2022-04-21 20:26:19', 38);
INSERT INTO `nuclear_power_plants` VALUES (88, 'Bruce-6', 44.341000, -81.572000, 'CA', 3, 20, 'CANDU 750B', '1978-01-01', '1984-09-14', NULL, 822, 'WNA/IAEA', '2015-05-24 04:50:24', 39);
INSERT INTO `nuclear_power_plants` VALUES (89, 'Bruce-7', 44.341000, -81.572000, 'CA', 3, 20, 'CANDU 750B', '1979-05-01', '1986-04-10', NULL, 822, 'WNA/IAEA', '2015-05-24 04:50:24', 41);
INSERT INTO `nuclear_power_plants` VALUES (90, 'Bruce-8', 44.341000, -81.572000, 'CA', 3, 20, 'CANDU 750B', '1979-07-30', '1987-05-20', NULL, 795, 'WNA/IAEA', '2022-04-21 20:26:19', 42);
INSERT INTO `nuclear_power_plants` VALUES (91, 'Brunsbuettel', 53.891000, 9.202000, 'DE', 5, 5, 'BWR-69', '1970-04-15', '1977-02-09', '2011-08-06', 770, 'WNA/IAEA', '2015-05-24 04:50:42', 86);
INSERT INTO `nuclear_power_plants` VALUES (92, 'Brunswick-1', 33.958000, -78.007000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1970-02-07', '1977-03-18', NULL, 821, 'WNA/IAEA', '2015-05-24 04:51:46', 662);
INSERT INTO `nuclear_power_plants` VALUES (93, 'Brunswick-2', 33.958000, -78.007000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1970-02-07', '1975-11-03', NULL, 821, 'WNA/IAEA', '2015-05-24 04:51:46', 661);
INSERT INTO `nuclear_power_plants` VALUES (94, 'Bugey-1', 45.796000, 5.268000, 'FR', 5, 8, 'UNGG', '1965-12-01', '1972-07-01', '1994-05-27', 540, 'WNA/IAEA', '2015-05-24 04:51:08', 230);
INSERT INTO `nuclear_power_plants` VALUES (95, 'Bugey-2', 45.796000, 5.268000, 'FR', 3, 21, 'CP0', '1972-11-01', '1979-03-01', NULL, 920, 'WNA/IAEA', '2015-05-24 04:50:51', 165);
INSERT INTO `nuclear_power_plants` VALUES (96, 'Bugey-3', 45.798000, 5.268000, 'FR', 3, 21, 'CP0', '1973-09-01', '1979-03-01', NULL, 920, 'WNA/IAEA', '2015-05-24 04:50:51', 166);
INSERT INTO `nuclear_power_plants` VALUES (97, 'Bugey-4', 45.800000, 5.267000, 'FR', 3, 21, 'CP0', '1974-06-01', '1979-07-01', NULL, 900, 'WNA/IAEA', '2015-05-24 04:50:51', 167);
INSERT INTO `nuclear_power_plants` VALUES (98, 'Bugey-5', 45.800000, 5.267000, 'FR', 3, 21, 'CP0', '1974-07-01', '1980-01-03', NULL, 900, 'WNA/IAEA', '2015-05-24 04:50:51', 168);
INSERT INTO `nuclear_power_plants` VALUES (99, 'Bushehr-1', 28.831000, 50.887000, 'IR', 3, 21, 'VVER V-446', '1975-05-01', '2013-09-23', NULL, 915, 'WNA/IAEA', '2015-05-24 04:51:26', 310);
INSERT INTO `nuclear_power_plants` VALUES (100, 'Bushehr-2', 28.828700, 50.889500, 'IR', 2, 21, 'V-528 VVER-1000 AES-92 GIII+', '2019-09-27', NULL, NULL, 974, 'WNA/IAEA', '2020-04-18 04:46:52', 311);
INSERT INTO `nuclear_power_plants` VALUES (101, 'Bushehr-3', 28.830500, 50.887200, 'IR', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (102, 'Bushehr-4', 28.830500, 50.887200, 'IR', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (103, 'Byron-1', 42.074000, -89.277000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1975-04-01', '1985-09-16', NULL, 1120, 'WNA/IAEA', '2017-02-10 23:59:17', 735);
INSERT INTO `nuclear_power_plants` VALUES (104, 'Byron-2', 42.074000, -89.277000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1975-04-01', '1987-08-02', NULL, 1120, 'WNA/IAEA', '2017-02-10 23:59:18', 736);
INSERT INTO `nuclear_power_plants` VALUES (105, 'Calder Hall-1', 54.420000, -3.491000, 'GB', 5, 8, 'MAGNOX', '1953-08-01', '1956-10-01', '2003-03-31', 35, 'WNA/IAEA', '2015-05-24 04:51:09', 231);
INSERT INTO `nuclear_power_plants` VALUES (106, 'Calder Hall-2', 54.420000, -3.491000, 'GB', 5, 8, 'MAGNOX', '1953-08-01', '1957-02-01', '2003-03-31', 35, 'WNA/IAEA', '2015-05-24 04:51:09', 232);
INSERT INTO `nuclear_power_plants` VALUES (107, 'Calder Hall-3', 54.420000, -3.491000, 'GB', 5, 8, 'MAGNOX', '1955-08-01', '1958-05-01', '2003-03-31', 35, 'WNA/IAEA', '2015-05-24 04:51:10', 233);
INSERT INTO `nuclear_power_plants` VALUES (108, 'Calder Hall-4', 54.420000, -3.491000, 'GB', 5, 8, 'MAGNOX', '1955-08-01', '1959-04-01', '2003-03-31', 35, 'WNA/IAEA', '2015-05-24 04:51:10', 234);
INSERT INTO `nuclear_power_plants` VALUES (109, 'Callaway-1', 38.763000, -91.781000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1975-09-01', '1984-12-19', NULL, 1171, 'WNA/IAEA', '2017-02-10 23:59:20', 752);
INSERT INTO `nuclear_power_plants` VALUES (110, 'Calvert Cliffs-1', 38.435000, -76.439000, 'US', 3, 21, 'CE 2LP (DRYAMB)', '1968-06-01', '1975-05-08', NULL, 845, 'WNA/IAEA', '2017-02-10 23:58:35', 655);
INSERT INTO `nuclear_power_plants` VALUES (111, 'Calvert Cliffs-2', 38.435000, -76.439000, 'US', 3, 21, 'CE 2LP (DRYAMB)', '1968-06-01', '1977-04-01', NULL, 845, 'WNA/IAEA', '2017-02-10 23:58:36', 656);
INSERT INTO `nuclear_power_plants` VALUES (112, 'Caorso', 45.072000, 9.872000, 'IT', 5, 5, 'BWR-4 (Mark 2)', '1970-01-01', '1981-12-01', '1990-07-01', 840, 'WNA/IAEA', '2015-05-24 04:51:26', 327);
INSERT INTO `nuclear_power_plants` VALUES (113, 'CAREM25', -33.966667, -59.211111, 'AR', 2, 21, 'CAREM Prototype (Integrated-PWR)', '2015-08-25', NULL, NULL, 25, 'IAEA', '2022-04-21 20:26:19', 1055);
INSERT INTO `nuclear_power_plants` VALUES (114, 'Carolinas CVTR', 34.263000, -81.330000, 'US', 5, 20, 'Prototype', '1960-01-01', '1963-12-18', '1967-01-10', 17, 'WNA/IAEA', '2017-02-10 23:57:39', 600);
INSERT INTO `nuclear_power_plants` VALUES (115, 'Catawba-1', 35.053000, -81.071000, 'US', 3, 21, 'WH 4LP (ICECND)', '1974-05-01', '1985-06-29', NULL, 1145, 'WNA/IAEA', '2017-02-10 23:59:13', 713);
INSERT INTO `nuclear_power_plants` VALUES (116, 'Catawba-2', 35.053000, -81.071000, 'US', 3, 21, 'WH 4LP (ICECND)', '1974-05-01', '1986-08-19', NULL, 1145, 'WNA/IAEA', '2017-02-10 23:59:14', 714);
INSERT INTO `nuclear_power_plants` VALUES (117, 'Cattenom-1', 49.416000, 6.217000, 'FR', 3, 21, 'P4 REP 1300', '1979-10-29', '1987-04-01', NULL, 1300, 'WNA/IAEA', '2015-05-24 04:51:01', 207);
INSERT INTO `nuclear_power_plants` VALUES (118, 'Cattenom-2', 49.416000, 6.217000, 'FR', 3, 21, 'P4 REP 1300', '1980-07-28', '1988-02-01', NULL, 1300, 'WNA/IAEA', '2015-05-24 04:51:02', 210);
INSERT INTO `nuclear_power_plants` VALUES (119, 'Cattenom-3', 49.416000, 6.217000, 'FR', 3, 21, 'P4 REP 1300', '1982-06-15', '1991-02-01', NULL, 1300, 'WNA/IAEA', '2015-05-24 04:51:04', 218);
INSERT INTO `nuclear_power_plants` VALUES (120, 'Cattenom-4', 49.416000, 6.217000, 'FR', 3, 21, 'P4 REP 1300', '1983-09-28', '1992-01-01', NULL, 1300, 'WNA/IAEA', '2015-05-24 04:51:06', 223);
INSERT INTO `nuclear_power_plants` VALUES (121, 'CEFR (China Experimental Fast Reactor)', 39.739000, 116.030000, 'CN', 3, 7, 'BN-20', '2000-05-10', NULL, NULL, 20, 'WNA/IAEA', '2021-06-12 00:00:00', 1047);
INSERT INTO `nuclear_power_plants` VALUES (122, 'Cernavoda-1', 44.322000, 28.061000, 'RO', 3, 20, 'CANDU 6', '1983-03-31', '1996-12-02', NULL, 650, 'WNA/IAEA', '2021-01-06 01:19:47', 442);
INSERT INTO `nuclear_power_plants` VALUES (123, 'Cernavoda-2', 44.322000, 28.061000, 'RO', 3, 20, 'CANDU 6', '1983-07-01', '2007-11-01', NULL, 650, 'WNA/IAEA', '2019-06-02 20:18:16', 443);
INSERT INTO `nuclear_power_plants` VALUES (124, 'Cernavoda-3', 44.322000, 28.061000, 'RO', 8, 20, NULL, '1984-02-09', NULL, NULL, 655, 'WNA/IAEA/Wikipedia', '2021-02-14 00:59:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (125, 'Changjiang-1', 19.460750, 108.899917, 'CN', 3, 21, 'CNP-600', '2010-04-25', '2015-12-25', NULL, 601, 'WNA/IAEA/Wikipedia', '2021-04-20 03:20:43', 939);
INSERT INTO `nuclear_power_plants` VALUES (126, 'Changjiang-2', 19.460750, 108.899917, 'CN', 3, 21, 'CNP-600', '2010-11-21', '2016-08-12', NULL, 601, 'WNA/IAEA/Wikipedia', '2021-04-20 03:20:43', 940);
INSERT INTO `nuclear_power_plants` VALUES (127, 'Chapelcross-1', 55.014000, -3.223000, 'GB', 5, 8, 'MAGNOX', '1955-10-01', '1959-03-01', '2004-06-29', 35, 'WNA/IAEA', '2015-05-24 04:51:17', 252);
INSERT INTO `nuclear_power_plants` VALUES (128, 'Chapelcross-2', 55.014000, -3.223000, 'GB', 5, 8, 'MAGNOX', '1955-10-01', '1959-08-01', '2004-06-29', 35, 'WNA/IAEA', '2015-05-24 04:51:18', 253);
INSERT INTO `nuclear_power_plants` VALUES (129, 'Chapelcross-3', 55.014000, -3.223000, 'GB', 5, 8, 'MAGNOX', '1955-10-01', '1959-12-01', '2004-06-29', 35, 'WNA/IAEA', '2015-05-24 04:51:18', 254);
INSERT INTO `nuclear_power_plants` VALUES (130, 'Chapelcross-4', 55.014000, -3.223000, 'GB', 5, 8, 'MAGNOX', '1955-10-01', '1960-03-01', '2004-06-29', 35, 'WNA/IAEA', '2015-05-24 04:51:18', 255);
INSERT INTO `nuclear_power_plants` VALUES (131, 'CHASNUPP-1', 32.392000, 71.463000, 'PK', 3, 21, 'CNP-300', '1993-08-01', '2000-09-15', NULL, 300, 'WNA/IAEA', '2021-06-07 00:00:00', 428);
INSERT INTO `nuclear_power_plants` VALUES (132, 'CHASNUPP-2', 32.392000, 71.463000, 'PK', 3, 21, 'CNP-300', '2005-12-28', '2011-05-18', NULL, 300, 'WNA/IAEA', '2021-06-07 00:00:00', 429);
INSERT INTO `nuclear_power_plants` VALUES (133, 'CHASNUPP-3', 32.392000, 71.465000, 'PK', 3, 21, 'CNP-300', '2011-05-28', '2016-12-06', NULL, 315, 'WNA/IAEA', '2021-06-07 00:00:00', 1044);
INSERT INTO `nuclear_power_plants` VALUES (134, 'CHASNUPP-4', 32.391944, 71.461667, 'PK', 3, 21, 'CNP-300', '2011-12-18', '2017-09-19', NULL, 313, 'IAEA', '2021-06-07 00:00:00', 1045);
INSERT INTO `nuclear_power_plants` VALUES (135, 'Chernobyl-1', 51.389000, 30.103000, 'UA', 5, 17, 'RBMK', '1970-03-01', '1978-05-27', '1996-11-30', 925, 'WNA/IAEA', '2015-05-24 04:51:39', 568);
INSERT INTO `nuclear_power_plants` VALUES (136, 'Chernobyl-2', 51.389000, 30.103000, 'UA', 5, 17, 'RBMK', '1973-02-01', '1979-05-28', '1991-10-11', 925, 'WNA/IAEA', '2015-05-24 04:51:39', 569);
INSERT INTO `nuclear_power_plants` VALUES (137, 'Chernobyl-3', 51.389000, 30.103000, 'UA', 5, 17, 'RBMK', '1976-03-01', '1982-06-08', '2000-12-15', 925, 'WNA/IAEA', '2015-05-24 04:51:40', 575);
INSERT INTO `nuclear_power_plants` VALUES (138, 'Chernobyl-4', 51.389000, 30.103000, 'UA', 5, 17, 'RBMK', '1979-04-01', '1984-03-26', '1986-04-26', 925, 'WNA/IAEA', '2015-05-24 04:51:40', 576);
INSERT INTO `nuclear_power_plants` VALUES (139, 'Chin Shan-1', 25.292000, 121.567000, 'TW', 5, 5, 'BWR-4 (Mark 1)', '1972-06-02', '1978-12-10', '2018-12-06', 604, 'WNA/IAEA', '2019-06-02 20:18:27', 554);
INSERT INTO `nuclear_power_plants` VALUES (140, 'Chin Shan-2', 25.292000, 121.567000, 'TW', 5, 5, 'BWR-4 (Mark 1)', '1973-12-07', '1979-07-15', '2019-07-16', 604, 'WNA/IAEA', '2019-11-22 00:00:00', 555);
INSERT INTO `nuclear_power_plants` VALUES (141, 'Chinon-A1', 47.232000, 0.167000, 'FR', 5, 8, 'UNGG', '1957-02-01', '1964-02-01', '1973-04-16', 68, 'WNA/IAEA', '2015-05-24 04:50:52', 173);
INSERT INTO `nuclear_power_plants` VALUES (142, 'Chinon-A2', 47.232000, 0.167000, 'FR', 5, 8, 'UNGG', '1959-08-01', '1965-02-24', '1985-06-14', 170, 'WNA/IAEA', '2015-05-24 04:50:53', 184);
INSERT INTO `nuclear_power_plants` VALUES (143, 'Chinon-A3', 47.232000, 0.167000, 'FR', 5, 8, 'UNGG', '1961-03-01', '1966-08-04', '1990-06-15', 480, 'WNA/IAEA', '2015-05-24 04:50:58', 195);
INSERT INTO `nuclear_power_plants` VALUES (144, 'Chinon-B1', 47.232000, 0.167000, 'FR', 3, 21, 'CP2', '1977-03-01', '1984-02-01', NULL, 870, 'WNA/IAEA', '2015-05-24 04:50:58', 196);
INSERT INTO `nuclear_power_plants` VALUES (145, 'Chinon-B2', 47.232000, 0.167000, 'FR', 3, 21, 'CP2', '1977-03-01', '1984-08-01', NULL, 870, 'WNA/IAEA', '2015-05-24 04:50:59', 197);
INSERT INTO `nuclear_power_plants` VALUES (146, 'Chinon-B3', 47.232000, 0.167000, 'FR', 3, 21, 'CP2', '1980-10-01', '1987-03-04', NULL, 905, 'WNA/IAEA', '2015-05-24 04:51:03', 213);
INSERT INTO `nuclear_power_plants` VALUES (147, 'Chinon-B4', 47.232000, 0.167000, 'FR', 3, 21, 'CP2', '1981-02-01', '1988-04-01', NULL, 905, 'WNA/IAEA', '2015-05-24 04:51:03', 214);
INSERT INTO `nuclear_power_plants` VALUES (148, 'Chooz-A', 50.086000, 4.792000, 'FR', 5, 21, 'CHOOZ-A', '1962-01-01', '1967-04-15', '1991-10-30', 280, 'WNA/IAEA', '2015-05-24 04:51:01', 206);
INSERT INTO `nuclear_power_plants` VALUES (149, 'Chooz-B1', 50.086000, 4.792000, 'FR', 3, 21, 'N4 REP 1450', '1984-01-01', '2000-05-15', NULL, 1455, 'WNA/IAEA', '2015-05-24 04:51:04', 220);
INSERT INTO `nuclear_power_plants` VALUES (150, 'Chooz-B2', 50.086000, 4.792000, 'FR', 3, 21, 'N4 REP 1450', '1985-12-31', '2000-09-29', NULL, 1455, 'WNA/IAEA', '2015-05-24 04:51:06', 226);
INSERT INTO `nuclear_power_plants` VALUES (151, 'Civaux-1', 46.457000, 0.654000, 'FR', 3, 21, 'N4 REP 1450', '1988-10-15', '2002-01-29', NULL, 1450, 'WNA/IAEA', '2015-05-24 04:51:07', 227);
INSERT INTO `nuclear_power_plants` VALUES (152, 'Civaux-2', 46.457000, 0.654000, 'FR', 3, 21, 'N4 REP 1450', '1991-04-01', '2002-04-23', NULL, 1450, 'WNA/IAEA', '2015-05-24 04:51:07', 228);
INSERT INTO `nuclear_power_plants` VALUES (153, 'Clinton-1', 40.172000, -88.834000, 'US', 3, 5, 'BWR-6 (Mark 3)', '1975-10-01', '1987-11-24', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:49', 742);
INSERT INTO `nuclear_power_plants` VALUES (154, 'Cofrentes', 39.216000, -1.051000, 'ES', 3, 5, 'BWR-6 (Mark 3)', '1975-09-09', '1985-03-11', NULL, 939, 'WNA/IAEA', '2017-02-10 23:56:09', 140);
INSERT INTO `nuclear_power_plants` VALUES (155, 'Columbia (WNP-2)', 46.471000, -119.333000, 'US', 3, 5, 'BWR-5 (Mark 2)', '1972-08-01', '1984-12-13', NULL, 1100, 'WNA/IAEA', '2015-05-24 04:51:48', 702);
INSERT INTO `nuclear_power_plants` VALUES (156, 'Comanche Peak-1', 32.301000, -97.787000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1974-12-19', '1990-08-13', NULL, 1150, 'WNA/IAEA', '2017-02-10 23:59:17', 729);
INSERT INTO `nuclear_power_plants` VALUES (157, 'Comanche Peak-2', 32.301000, -97.787000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1974-12-19', '1993-08-03', NULL, 1150, 'WNA/IAEA', '2017-02-10 23:59:17', 730);
INSERT INTO `nuclear_power_plants` VALUES (158, 'Cooper', 40.361000, -95.643000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1968-06-01', '1974-07-01', NULL, 778, 'WNA/IAEA', '2015-05-24 04:51:43', 642);
INSERT INTO `nuclear_power_plants` VALUES (159, 'Cruas-1', 44.634000, 4.757000, 'FR', 3, 21, 'CP2', '1978-08-01', '1984-04-02', NULL, 880, 'WNA/IAEA', '2015-05-24 04:50:59', 198);
INSERT INTO `nuclear_power_plants` VALUES (160, 'Cruas-2', 44.634000, 4.757000, 'FR', 3, 21, 'CP2', '1978-11-15', '1985-04-01', NULL, 915, 'WNA/IAEA', '2015-05-24 04:50:59', 199);
INSERT INTO `nuclear_power_plants` VALUES (161, 'Cruas-3', 44.634000, 4.757000, 'FR', 3, 21, 'CP2', '1979-04-15', '1984-09-10', NULL, 880, 'WNA/IAEA', '2015-05-24 04:50:59', 200);
INSERT INTO `nuclear_power_plants` VALUES (162, 'Cruas-4', 44.634000, 4.757000, 'FR', 3, 21, 'CP2', '1979-10-01', '1985-02-11', NULL, 880, 'WNA/IAEA', '2015-05-24 04:51:00', 201);
INSERT INTO `nuclear_power_plants` VALUES (163, 'Crystal River-3', 28.966000, -82.697000, 'US', 5, 21, 'B&W LLP (DRYAMB)', '1968-09-25', '1977-03-13', '2013-02-05', 825, 'WNA/IAEA', '2017-02-10 23:58:22', 645);
INSERT INTO `nuclear_power_plants` VALUES (164, 'Dampierre-1', 47.732000, 2.513000, 'FR', 3, 21, 'CP1', '1975-02-01', '1980-09-10', NULL, 890, 'WNA/IAEA', '2015-05-24 04:50:53', 176);
INSERT INTO `nuclear_power_plants` VALUES (165, 'Dampierre-2', 47.732000, 2.513000, 'FR', 3, 21, 'CP1', '1975-04-01', '1981-02-16', NULL, 890, 'WNA/IAEA', '2015-05-24 04:50:53', 183);
INSERT INTO `nuclear_power_plants` VALUES (166, 'Dampierre-3', 47.732000, 2.513000, 'FR', 3, 21, 'CP1', '1975-09-01', '1981-05-27', NULL, 890, 'WNA/IAEA', '2015-05-24 04:50:53', 185);
INSERT INTO `nuclear_power_plants` VALUES (167, 'Dampierre-4', 47.732000, 2.513000, 'FR', 3, 21, 'CP1', '1975-12-01', '1981-11-20', NULL, 890, 'WNA/IAEA', '2015-05-24 04:50:53', 186);
INSERT INTO `nuclear_power_plants` VALUES (168, 'Darkhovin', 30.707778, 48.380000, 'IR', 0, 21, NULL, NULL, NULL, NULL, NULL, 'Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (169, 'Darlington-1', 43.867000, -78.724000, 'CA', 3, 20, 'CANDU 850', '1982-04-01', '1992-11-14', NULL, 881, 'WNA/IAEA', '2015-05-24 04:50:25', 43);
INSERT INTO `nuclear_power_plants` VALUES (170, 'Darlington-2', 43.867000, -78.724000, 'CA', 3, 20, 'CANDU 850', '1981-09-01', '1990-10-09', NULL, 881, 'WNA/IAEA', '2015-05-24 04:50:26', 44);
INSERT INTO `nuclear_power_plants` VALUES (171, 'Darlington-3', 43.867000, -78.724000, 'CA', 3, 20, 'CANDU 850', '1984-09-01', '1993-02-14', NULL, 881, 'WNA/IAEA', '2015-05-24 04:50:26', 45);
INSERT INTO `nuclear_power_plants` VALUES (172, 'Darlington-4', 43.867000, -78.724000, 'CA', 3, 20, 'CANDU 850', '1985-07-01', '1993-06-14', NULL, 881, 'WNA/IAEA', '2015-05-24 04:50:26', 46);
INSERT INTO `nuclear_power_plants` VALUES (173, 'Darlington-5', 43.864400, -78.724400, 'CA', 1, 20, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (174, 'Darlington-6', 43.863300, -78.724400, 'CA', 1, 20, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (175, 'Davis Besse-1', 41.597000, -83.092000, 'US', 3, 21, 'B&W RLP (DRYAMB)', '1970-09-01', '1978-07-31', NULL, 906, 'WNA/IAEA', '2017-02-10 23:58:51', 676);
INSERT INTO `nuclear_power_plants` VALUES (176, 'Daya Bay-1 (Guangdong-1)', 22.599000, 114.544000, 'CN', 3, 21, 'M310', '1987-08-07', '1994-02-01', NULL, 930, 'WNA/IAEA', '2015-05-24 04:50:39', 63);
INSERT INTO `nuclear_power_plants` VALUES (177, 'Daya Bay-2 (Guangdong-2)', 22.599000, 114.544000, 'CN', 3, 21, 'M310', '1988-04-07', '1994-05-06', NULL, 930, 'WNA/IAEA', '2015-05-24 04:50:39', 64);
INSERT INTO `nuclear_power_plants` VALUES (178, 'Diablo Canyon-1', 35.212000, -120.854000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1968-04-23', '1985-05-07', NULL, 1084, 'WNA/IAEA', '2017-02-10 23:58:09', 628);
INSERT INTO `nuclear_power_plants` VALUES (179, 'Diablo Canyon-2', 35.212000, -120.854000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1970-12-09', '1986-03-13', NULL, 1106, 'WNA/IAEA', '2017-02-10 23:58:39', 660);
INSERT INTO `nuclear_power_plants` VALUES (180, 'Doel-1', 51.323000, 4.259000, 'BE', 3, 21, 'WH 2LP', '1969-07-01', '1975-02-15', NULL, 392, 'WNA/IAEA', '2017-02-10 23:55:14', 9);
INSERT INTO `nuclear_power_plants` VALUES (181, 'Doel-2', 51.323000, 4.259000, 'BE', 3, 21, 'WH 2LP', '1971-09-01', '1975-12-01', NULL, 445, 'WNA/IAEA', '2021-01-06 01:19:47', 11);
INSERT INTO `nuclear_power_plants` VALUES (182, 'Doel-3', 51.323000, 4.259000, 'BE', 5, 21, 'WH 3LP', '1975-01-01', '1982-10-01', '2022-09-23', 890, 'WNA/IAEA', '2022-12-30 00:57:40', 12);
INSERT INTO `nuclear_power_plants` VALUES (183, 'Doel-4', 51.323000, 4.259000, 'BE', 3, 21, 'WH 3LP', '1978-12-01', '1985-07-01', NULL, 1000, 'WNA/IAEA', '2017-02-10 23:55:43', 14);
INSERT INTO `nuclear_power_plants` VALUES (184, 'Donald Cook-1', 41.975000, -86.564000, 'US', 3, 21, 'WH 4LP (ICECDN)', '1969-03-25', '1975-08-28', NULL, 1030, 'WNA/IAEA', '2017-02-10 23:58:31', 653);
INSERT INTO `nuclear_power_plants` VALUES (185, 'Donald Cook-2', 41.975000, -86.564000, 'US', 3, 21, 'WH 4LP (ICECDN)', '1969-03-25', '1978-07-01', NULL, 1100, 'WNA/IAEA', '2017-02-10 23:58:33', 654);
INSERT INTO `nuclear_power_plants` VALUES (186, 'Douglas Point', 44.326000, -81.601000, 'CA', 5, 20, 'CANDU 200', '1960-02-01', '1968-09-26', '1984-05-04', 203, 'WNA/IAEA', '2015-05-24 04:50:24', 40);
INSERT INTO `nuclear_power_plants` VALUES (187, 'Dounreay DFR', 58.577000, -3.745000, 'GB', 5, 7, NULL, '1955-03-01', '1962-10-01', '1977-03-01', 14, 'WNA/IAEA', '2015-05-24 04:51:14', 242);
INSERT INTO `nuclear_power_plants` VALUES (188, 'Dounreay PFR', 58.577000, -3.745000, 'GB', 5, 7, NULL, '1966-01-01', '1976-07-01', '1994-03-31', 234, 'WNA/IAEA', '2015-05-24 04:51:14', 243);
INSERT INTO `nuclear_power_plants` VALUES (189, 'Dresden-1', 41.353000, -88.349000, 'US', 5, 5, NULL, '1956-05-01', '1960-07-04', '1978-10-31', 192, 'WNA/IAEA', '2015-05-24 04:51:40', 597);
INSERT INTO `nuclear_power_plants` VALUES (190, 'Dresden-2', 41.353000, -88.349000, 'US', 3, 5, 'BWR-3 (Mark 1)', '1966-01-10', '1970-06-09', NULL, 794, 'WNA/IAEA', '2015-05-24 04:51:41', 608);
INSERT INTO `nuclear_power_plants` VALUES (191, 'Dresden-3', 41.353000, -88.349000, 'US', 3, 5, 'BWR-3 (Mark 1)', '1966-10-14', '1971-11-16', NULL, 794, 'WNA/IAEA', '2015-05-24 04:51:41', 612);
INSERT INTO `nuclear_power_plants` VALUES (192, 'Duane Arnold-1', 42.101000, -91.776000, 'US', 5, 5, 'BWR-4 (Mark 1)', '1970-06-22', '1975-02-01', '2020-10-12', 601, 'WNA/IAEA', '2021-01-06 01:19:47', 667);
INSERT INTO `nuclear_power_plants` VALUES (193, 'Dukovany-1', 49.089000, 16.149000, 'CZ', 3, 21, 'VVER V-213', '1979-01-01', '1985-05-03', NULL, 420, 'WNA/IAEA', '2023-08-28 08:01:45', 78);
INSERT INTO `nuclear_power_plants` VALUES (194, 'Dukovany-2', 49.089000, 16.149000, 'CZ', 3, 21, 'VVER V-213', '1979-01-01', '1986-03-21', NULL, 420, 'WNA/IAEA', '2015-05-24 04:50:42', 79);
INSERT INTO `nuclear_power_plants` VALUES (195, 'Dukovany-3', 49.089000, 16.149000, 'CZ', 3, 21, 'VVER V-213', '1979-03-01', '1986-12-20', NULL, 420, 'WNA/IAEA', '2015-05-24 04:50:42', 80);
INSERT INTO `nuclear_power_plants` VALUES (196, 'Dukovany-4', 49.089000, 16.149000, 'CZ', 3, 21, 'VVER V-213', '1979-03-01', '1987-07-19', NULL, 420, 'WNA/IAEA', '2015-05-24 04:50:42', 81);
INSERT INTO `nuclear_power_plants` VALUES (197, 'Dungeness-A1', 50.914000, 0.962000, 'GB', 5, 8, 'MAGNOX', '1960-07-01', '1965-10-28', '2006-12-31', 275, 'WNA/IAEA', '2015-05-24 04:51:20', 275);
INSERT INTO `nuclear_power_plants` VALUES (198, 'Dungeness-A2', 50.914000, 0.962000, 'GB', 5, 8, 'MAGNOX', '1960-07-01', '1965-12-30', '2006-12-31', 275, 'WNA/IAEA', '2015-05-24 04:51:20', 276);
INSERT INTO `nuclear_power_plants` VALUES (199, 'Dungeness-B1', 50.914000, 0.962000, 'GB', 5, 8, 'AGR', '1965-10-01', '1985-04-01', '2021-06-07', 607, 'WNA/IAEA', '2022-01-05 00:04:08', 248);
INSERT INTO `nuclear_power_plants` VALUES (200, 'Dungeness-B2', 50.914000, 0.962000, 'GB', 5, 8, 'AGR', '1965-10-01', '1989-04-01', '2021-06-07', 607, 'WNA/IAEA', '2022-01-05 00:04:08', 249);
INSERT INTO `nuclear_power_plants` VALUES (201, 'El Dabaa-1', 31.044167, 28.497778, 'EG', 2, 21, 'VVER-1200', '2022-07-20', NULL, NULL, 1100, 'WNA/IAEA/Wikipedia', '2023-08-28 08:01:45', 137);
INSERT INTO `nuclear_power_plants` VALUES (202, 'EL-4 (Monts D\'Arree)', 48.350000, -3.866667, 'FR', 5, 11, 'Monts-D\'Arree', '1962-07-01', '1968-06-01', '1985-07-31', 70, 'IAEA', '2015-05-24 05:20:27', 217);
INSERT INTO `nuclear_power_plants` VALUES (203, 'Elk River', 45.297000, -93.557000, 'US', 5, 5, NULL, '1959-01-01', '1964-07-01', '1968-02-01', 22, 'WNA/IAEA', '2015-05-24 04:51:40', 596);
INSERT INTO `nuclear_power_plants` VALUES (204, 'Embalse', -32.232000, -64.442000, 'AR', 3, 20, 'CANDU 6', '1974-03-31', '1984-01-19', NULL, 608, 'WNA/IAEA', '2024-03-03 20:43:43', 4);
INSERT INTO `nuclear_power_plants` VALUES (205, 'Emsland', 52.471000, 7.322000, 'DE', 5, 21, 'Konvoi', '1982-08-10', '1988-06-20', '2023-04-15', 1242, 'WNA/IAEA', '2023-08-28 08:01:45', 108);
INSERT INTO `nuclear_power_plants` VALUES (206, 'Enrico Fermi', 45.183333, 8.283333, 'IT', 5, 21, 'WH 4LP', '1961-07-01', '1965-01-01', '1990-07-01', 247, 'IAEA', '2017-02-10 23:56:19', 326);
INSERT INTO `nuclear_power_plants` VALUES (207, 'Enrico Fermi-1', 41.960000, -83.257000, 'US', 5, 7, 'Liquid Metal FBR', '1956-08-08', '1966-08-07', '1972-11-29', 60, 'WNA/IAEA', '2017-02-10 23:57:45', 602);
INSERT INTO `nuclear_power_plants` VALUES (208, 'Enrico Fermi-2', 41.960000, -83.257000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1972-09-26', '1988-01-23', NULL, 1093, 'WNA/IAEA', '2015-05-24 04:51:47', 674);
INSERT INTO `nuclear_power_plants` VALUES (209, 'Fangchenggang-1', 21.600000, 108.300000, 'CN', 3, 21, 'CPR-1000', '2010-07-30', '2016-01-01', NULL, 1000, 'WNA/IAEA', '2019-06-29 22:55:52', 943);
INSERT INTO `nuclear_power_plants` VALUES (210, 'Fangchenggang-2', 21.600000, 108.300000, 'CN', 3, 21, 'CPR-1000', '2010-12-23', '2016-10-01', NULL, 1000, 'WNA/IAEA', '2017-02-10 23:59:36', 944);
INSERT INTO `nuclear_power_plants` VALUES (211, 'Fangjiashan-1', 30.416000, 120.951000, 'CN', 3, 21, 'CPR-1000', '2008-12-26', '2014-12-15', NULL, 1000, 'WNA/IAEA', '2015-05-24 04:51:56', 912);
INSERT INTO `nuclear_power_plants` VALUES (212, 'Fangjiashan-2', 30.416000, 120.951000, 'CN', 3, 21, 'CPR-1000', '2009-07-17', '2015-02-12', NULL, 1000, 'WNA/IAEA', '2015-05-24 04:51:56', 913);
INSERT INTO `nuclear_power_plants` VALUES (213, 'Farley-1', 31.223000, -85.115000, 'US', 3, 21, 'WH 3LP (DRYAMB)', '1970-10-01', '1977-12-01', NULL, 829, 'WNA/IAEA', '2017-02-10 23:58:52', 677);
INSERT INTO `nuclear_power_plants` VALUES (214, 'Farley-2', 31.223000, -85.115000, 'US', 3, 21, 'WH 3LP (DRYAMB)', '1970-10-01', '1981-07-30', NULL, 829, 'WNA/IAEA', '2017-02-10 23:58:53', 686);
INSERT INTO `nuclear_power_plants` VALUES (215, 'Fessenheim-1', 47.903000, 7.564000, 'FR', 5, 21, 'CP0', '1971-09-01', '1978-01-01', '2020-02-22', 880, 'WNA/IAEA', '2020-04-18 04:46:52', 163);
INSERT INTO `nuclear_power_plants` VALUES (216, 'Fessenheim-2', 47.903000, 7.564000, 'FR', 5, 21, 'CP0', '1972-02-01', '1978-04-01', '2020-06-30', 880, 'WNA/IAEA', '2020-08-31 01:39:56', 164);
INSERT INTO `nuclear_power_plants` VALUES (217, 'FitzPatrick', 43.521000, -76.403000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1968-09-01', '1975-07-28', NULL, 821, 'WNA/IAEA', '2015-05-24 04:51:47', 668);
INSERT INTO `nuclear_power_plants` VALUES (218, 'Flamanville-1', 49.537000, -1.881000, 'FR', 3, 21, 'P4 REP 1300', '1979-12-01', '1986-12-01', NULL, 1330, 'WNA/IAEA', '2015-05-24 04:51:00', 202);
INSERT INTO `nuclear_power_plants` VALUES (219, 'Flamanville-2', 49.537000, -1.881000, 'FR', 3, 21, 'P4 REP 1300', '1980-05-01', '1987-03-09', NULL, 1330, 'WNA/IAEA', '2015-05-24 04:51:00', 203);
INSERT INTO `nuclear_power_plants` VALUES (220, 'Flamanville-3', 49.537000, -1.881000, 'FR', 2, 21, 'EPR', '2007-12-03', NULL, NULL, 1630, 'WNA/IAEA', '2015-05-24 04:51:51', 873);
INSERT INTO `nuclear_power_plants` VALUES (221, 'Forsmark-1', 60.405000, 18.168000, 'SE', 3, 5, 'AA-III, BWR-2500', '1973-06-01', '1980-12-10', NULL, 900, 'WNA/IAEA', '2018-03-10 14:52:03', 541);
INSERT INTO `nuclear_power_plants` VALUES (222, 'Forsmark-2', 60.405000, 18.168000, 'SE', 3, 5, 'AA-III, BWR-2500', '1975-01-01', '1981-07-07', NULL, 900, 'WNA/IAEA', '2018-03-10 14:51:47', 530);
INSERT INTO `nuclear_power_plants` VALUES (223, 'Forsmark-3', 60.405000, 18.168000, 'SE', 3, 5, 'AA-IV, BWR-3000', '1979-01-01', '1985-08-18', NULL, 1050, 'WNA/IAEA', '2018-03-10 14:51:53', 532);
INSERT INTO `nuclear_power_plants` VALUES (224, 'Fort Calhoun-1', 41.520000, -96.076000, 'US', 5, 21, 'CE 2LP', '1968-06-07', '1973-09-26', '2016-10-24', 478, 'WNA/IAEA', '2017-02-10 23:58:13', 634);
INSERT INTO `nuclear_power_plants` VALUES (225, 'Fort St. Vrain', 40.244000, -104.874000, 'US', 5, 9, NULL, '1968-09-01', '1979-07-01', '1989-08-29', 330, 'WNA/IAEA', '2015-05-24 04:51:42', 623);
INSERT INTO `nuclear_power_plants` VALUES (226, 'Fugen ATR', 35.751000, 136.020000, 'JP', 5, 12, 'ATR', '1972-05-10', '1979-03-20', '2003-03-29', 148, 'WNA/IAEA', '2015-05-24 04:51:28', 345);
INSERT INTO `nuclear_power_plants` VALUES (227, 'Fukushima Daiichi-1', 37.423000, 141.032000, 'JP', 5, 5, 'BWR-3', '1967-07-25', '1971-03-26', '2011-05-19', 439, 'WNA/IAEA', '2019-06-30 12:49:39', 377);
INSERT INTO `nuclear_power_plants` VALUES (228, 'Fukushima Daiichi-2', 37.423000, 141.032000, 'JP', 5, 5, 'BWR-4', '1969-06-09', '1974-07-18', '2011-05-19', 760, 'WNA/IAEA', '2019-06-30 12:49:43', 389);
INSERT INTO `nuclear_power_plants` VALUES (229, 'Fukushima Daiichi-3', 37.423000, 141.032000, 'JP', 5, 5, 'BWR-4', '1970-12-28', '1976-03-27', '2011-05-19', 760, 'WNA/IAEA', '2019-06-30 12:49:48', 334);
INSERT INTO `nuclear_power_plants` VALUES (230, 'Fukushima Daiichi-4', 37.423000, 141.032000, 'JP', 5, 5, 'BWR-4', '1973-02-12', '1978-10-12', '2011-05-19', 760, 'WNA/IAEA', '2019-06-30 12:49:48', 340);
INSERT INTO `nuclear_power_plants` VALUES (231, 'Fukushima Daiichi-5', 37.423000, 141.032000, 'JP', 5, 5, 'BWR-4', '1972-05-22', '1978-04-18', '2013-12-17', 760, 'WNA/IAEA', '2019-06-30 12:49:49', 341);
INSERT INTO `nuclear_power_plants` VALUES (232, 'Fukushima Daiichi-6', 37.423000, 141.032000, 'JP', 5, 5, 'BWR-5', '1973-10-26', '1979-10-24', '2013-12-17', 1067, 'WNA/IAEA', '2019-06-30 12:52:14', 342);
INSERT INTO `nuclear_power_plants` VALUES (233, 'Fukushima Daini-1', 37.315000, 141.024000, 'JP', 5, 5, 'BWR-5', '1976-03-16', '1982-04-20', '2019-09-30', 1067, 'WNA/IAEA', '2020-04-18 04:46:52', 350);
INSERT INTO `nuclear_power_plants` VALUES (234, 'Fukushima Daini-2', 37.315000, 141.024000, 'JP', 5, 5, 'BWR-5', '1979-05-25', '1984-02-03', '2019-09-30', 1067, 'WNA/IAEA', '2020-04-18 04:46:52', 351);
INSERT INTO `nuclear_power_plants` VALUES (235, 'Fukushima Daini-3', 37.315000, 141.024000, 'JP', 5, 5, 'BWR-5', '1981-03-23', '1985-06-21', '2019-09-30', 1067, 'WNA/IAEA', '2020-04-18 04:46:52', 361);
INSERT INTO `nuclear_power_plants` VALUES (236, 'Fukushima Daini-4', 37.315000, 141.024000, 'JP', 5, 5, 'BWR-5', '1981-05-28', '1987-08-25', '2019-09-30', 1067, 'WNA/IAEA', '2020-04-18 04:46:52', 364);
INSERT INTO `nuclear_power_plants` VALUES (237, 'Fuqing-1', 25.443000, 119.453000, 'CN', 3, 21, 'CNP-1000', '2008-11-21', '2014-11-22', NULL, 1000, 'WNA/IAEA', '2016-03-09 18:43:50', 914);
INSERT INTO `nuclear_power_plants` VALUES (238, 'Fuqing-2', 25.443000, 119.453000, 'CN', 3, 21, 'CNP-1000', '2009-06-17', '2015-10-16', NULL, 1000, 'WNA/IAEA', '2016-03-09 18:43:55', 915);
INSERT INTO `nuclear_power_plants` VALUES (239, 'Fuqing-3', 25.720278, 119.383889, 'CN', 3, 21, 'CNP-1000', '2010-12-31', '2016-10-24', NULL, 1000, 'WNA/IAEA', '2017-02-10 23:59:36', 935);
INSERT INTO `nuclear_power_plants` VALUES (240, 'Fuqing-4', 25.720278, 119.383889, 'CN', 3, 21, 'CNP-1000', '2012-11-17', '2017-09-17', NULL, 1000, 'WNA/IAEA', '2018-03-10 14:52:08', 936);
INSERT INTO `nuclear_power_plants` VALUES (241, 'Fuqing-5', 25.720278, 119.383889, 'CN', 3, 21, 'HPR1000', '2015-05-07', '2021-01-30', NULL, 1075, 'WNA/IAEA', '2022-12-30 00:57:40', 937);
INSERT INTO `nuclear_power_plants` VALUES (242, 'Fuqing-6', 25.720278, 119.383889, 'CN', 3, 21, 'HPR1000', '2015-12-22', '2022-03-25', NULL, 1075, 'WNA/Wikipedia/IAEA', '2022-09-24 22:33:57', 938);
INSERT INTO `nuclear_power_plants` VALUES (243, 'G-2 (Marcoule)', 44.142000, 4.713000, 'FR', 5, 8, NULL, '1955-03-01', '1959-04-22', '1980-02-02', 36, 'WNA/IAEA', '2015-05-24 04:50:51', 172);
INSERT INTO `nuclear_power_plants` VALUES (244, 'G-3 (Marcoule)', 44.142000, 4.713000, 'FR', 5, 8, NULL, '1956-03-01', '1960-04-04', '1984-06-20', 36, 'WNA/IAEA', '2015-05-24 04:50:50', 161);
INSERT INTO `nuclear_power_plants` VALUES (245, 'Garigliano', 41.258000, 13.835000, 'IT', 5, 5, 'BWR-1', '1959-11-01', '1964-06-01', '1982-03-01', 150, 'WNA/IAEA', '2015-05-24 04:51:26', 325);
INSERT INTO `nuclear_power_plants` VALUES (246, 'GE Vallecitos', 37.613056, -121.840000, 'US', 5, 5, '25', '1956-01-01', '1957-10-19', '1963-12-09', 24, 'IAEA', '2021-06-06 00:00:00', 893);
INSERT INTO `nuclear_power_plants` VALUES (247, 'Genkai-1', 33.518000, 129.837000, 'JP', 5, 21, 'M (2-loop)', '1971-09-15', '1975-10-15', '2015-04-27', 529, 'WNA/IAEA', '2015-05-24 04:51:27', 336);
INSERT INTO `nuclear_power_plants` VALUES (248, 'Genkai-2', 33.518000, 129.837000, 'JP', 5, 21, 'M (2-loop)', '1977-02-01', '1981-03-30', '2019-04-09', 529, 'WNA/IAEA', '2019-11-22 00:00:00', 352);
INSERT INTO `nuclear_power_plants` VALUES (249, 'Genkai-3', 33.518000, 129.837000, 'JP', 3, 21, 'M (4-loop)', '1988-06-01', '1994-03-18', NULL, 1127, 'WNA/IAEA', '2015-05-24 04:51:29', 372);
INSERT INTO `nuclear_power_plants` VALUES (250, 'Genkai-4', 33.518000, 129.837000, 'JP', 3, 21, 'M (4-loop)', '1992-07-15', '1997-07-25', NULL, 1127, 'WNA/IAEA', '2015-05-24 04:51:29', 373);
INSERT INTO `nuclear_power_plants` VALUES (251, 'Gentilly-1 (Demo)', 46.395000, -72.357000, 'CA', 5, 12, 'HW BLWR 250', '1966-09-01', '1972-05-01', '1977-06-01', 250, 'WNA/IAEA', '2015-05-24 04:50:26', 47);
INSERT INTO `nuclear_power_plants` VALUES (252, 'Gentilly-2', 46.395000, -72.357000, 'CA', 5, 20, 'CANDU 6', '1974-04-01', '1983-10-01', '2012-12-28', 645, 'WNA/IAEA', '2015-05-24 04:50:21', 32);
INSERT INTO `nuclear_power_plants` VALUES (253, 'Dodewaard', 51.899000, 5.687000, 'NL', 5, 5, 'GE design', '1965-05-01', '1969-03-26', '1997-03-26', 54, 'WNA/IAEA', '2021-06-07 00:00:00', 422);
INSERT INTO `nuclear_power_plants` VALUES (254, 'Goesgen', 47.366000, 7.969000, 'CH', 3, 21, 'PWR 3 Loop', '1973-12-01', '1979-11-01', NULL, 920, 'WNA/IAEA', '2022-04-21 20:26:19', 58);
INSERT INTO `nuclear_power_plants` VALUES (255, 'Golfech-1', 44.105000, 0.845000, 'FR', 3, 21, 'P4 REP 1300', '1982-11-17', '1991-02-01', NULL, 1310, 'WNA/IAEA', '2015-05-24 04:51:04', 219);
INSERT INTO `nuclear_power_plants` VALUES (256, 'Golfech-2', 44.105000, 0.845000, 'FR', 3, 21, 'P4 REP 1300', '1984-10-01', '1994-03-04', NULL, 1310, 'WNA/IAEA', '2015-05-24 04:51:06', 224);
INSERT INTO `nuclear_power_plants` VALUES (257, 'Grafenrheinfeld', 49.984000, 10.186000, 'DE', 5, 21, 'PWR', '1975-01-01', '1982-06-17', '2015-06-27', 1225, 'WNA/IAEA', '2015-08-23 03:28:22', 97);
INSERT INTO `nuclear_power_plants` VALUES (258, 'Grand Gulf-1', 32.007000, -91.045000, 'US', 3, 5, 'BWR-6 (Mark 3)', '1974-05-04', '1985-07-01', NULL, 1250, 'WNA/IAEA', '2015-05-24 04:51:49', 715);
INSERT INTO `nuclear_power_plants` VALUES (259, 'Gravelines-1', 51.014000, 2.138000, 'FR', 3, 21, 'CP1', '1975-02-01', '1980-11-25', NULL, 910, 'WNA/IAEA', '2015-05-24 04:50:52', 174);
INSERT INTO `nuclear_power_plants` VALUES (260, 'Gravelines-2', 51.014000, 2.138000, 'FR', 3, 21, 'CP1', '1975-03-01', '1980-12-01', NULL, 910, 'WNA/IAEA', '2015-05-24 04:50:52', 175);
INSERT INTO `nuclear_power_plants` VALUES (261, 'Gravelines-3', 51.014000, 2.138000, 'FR', 3, 21, 'CP1', '1975-12-01', '1981-06-01', NULL, 910, 'WNA/IAEA', '2015-05-24 04:50:53', 181);
INSERT INTO `nuclear_power_plants` VALUES (262, 'Gravelines-4', 51.014000, 2.138000, 'FR', 3, 21, 'CP1', '1976-04-01', '1981-10-01', NULL, 910, 'WNA/IAEA', '2015-05-24 04:50:53', 182);
INSERT INTO `nuclear_power_plants` VALUES (263, 'Gravelines-5', 51.014000, 2.138000, 'FR', 3, 21, 'CP1', '1979-10-01', '1985-01-15', NULL, 910, 'WNA/IAEA', '2015-05-24 04:51:01', 208);
INSERT INTO `nuclear_power_plants` VALUES (264, 'Gravelines-6', 51.014000, 2.138000, 'FR', 3, 21, 'CP1', '1979-10-01', '1985-10-25', NULL, 910, 'WNA/IAEA', '2015-05-24 04:51:02', 209);
INSERT INTO `nuclear_power_plants` VALUES (265, 'Greifswald-1', 54.143000, 13.668000, 'DE', 5, 21, 'VVER V-230', '1970-03-01', '1974-07-12', '1990-12-18', 440, 'WNA/IAEA', '2022-09-24 22:33:57', 123);
INSERT INTO `nuclear_power_plants` VALUES (266, 'Greifswald-2', 54.143000, 13.668000, 'DE', 5, 21, 'VVER V-230', '1970-03-01', '1975-04-16', '1990-02-14', 408, 'WNA/IAEA', '2015-05-24 04:50:47', 124);
INSERT INTO `nuclear_power_plants` VALUES (267, 'Greifswald-3', 54.143000, 13.668000, 'DE', 5, 21, 'VVER V-230', '1972-04-01', '1978-05-01', '1990-02-28', 408, 'WNA/IAEA', '2015-05-24 04:50:47', 125);
INSERT INTO `nuclear_power_plants` VALUES (268, 'Greifswald-4', 54.143000, 13.668000, 'DE', 5, 21, 'VVER V-230', '1972-04-01', '1979-11-01', '1990-06-02', 408, 'WNA/IAEA', '2022-09-24 22:33:57', 126);
INSERT INTO `nuclear_power_plants` VALUES (269, 'Greifswald-5', 54.143000, 13.668000, 'DE', 5, 21, 'VVER V-213', '1976-12-01', '1989-11-01', '1989-11-24', 408, 'WNA/IAEA', '2015-05-24 04:50:47', 127);
INSERT INTO `nuclear_power_plants` VALUES (270, 'Grohnde', 52.033000, 9.412000, 'DE', 5, 21, 'PWR', '1976-06-01', '1985-02-01', '2021-12-31', 1289, 'WNA/IAEA', '2022-04-21 20:26:19', 101);
INSERT INTO `nuclear_power_plants` VALUES (271, 'Grosswelzheim', 50.055000, 8.985000, 'DE', 11, 5, 'Superheated steam reactor', '1965-01-01', NULL, '1971-07-20', 23, 'WNA/IAEA', '2022-12-30 02:21:21', 134);
INSERT INTO `nuclear_power_plants` VALUES (272, 'Gundremmingen-A', 48.513000, 10.401000, 'DE', 5, 5, NULL, '1962-12-12', '1967-04-12', '1977-01-13', 237, 'WNA/IAEA', '2015-05-24 04:50:46', 104);
INSERT INTO `nuclear_power_plants` VALUES (273, 'Gundremmingen-B', 48.513000, 10.401000, 'DE', 5, 5, 'BWR-72', '1976-07-20', '1984-07-19', '2017-12-31', 1244, 'WNA/IAEA', '2018-03-10 14:51:13', 100);
INSERT INTO `nuclear_power_plants` VALUES (274, 'Gundremmingen-C', 48.513000, 10.401000, 'DE', 5, 5, 'BWR-72', '1976-07-20', '1985-01-18', '2021-12-31', 1249, 'WNA/IAEA', '2022-04-21 20:26:19', 102);
INSERT INTO `nuclear_power_plants` VALUES (275, 'H. B. Robinson-2', 34.402000, -80.158000, 'US', 3, 21, 'WH 3LP (DRYAMB)', '1967-04-13', '1971-03-07', NULL, 700, 'WNA/IAEA', '2017-02-10 23:58:01', 619);
INSERT INTO `nuclear_power_plants` VALUES (276, 'Haddam Neck', 41.483000, -72.500000, 'US', 5, 21, NULL, '1964-05-01', '1968-01-01', '1996-12-05', 582, 'WNA/IAEA', '2015-05-24 04:51:41', 605);
INSERT INTO `nuclear_power_plants` VALUES (277, 'Haiyang-1', 36.704000, 121.382000, 'CN', 3, 21, 'AP-1000', '2009-09-24', '2018-10-22', NULL, 1126, 'WNA/IAEA', '2019-06-02 20:18:34', 908);
INSERT INTO `nuclear_power_plants` VALUES (278, 'Haiyang-2', 36.704000, 121.382000, 'CN', 3, 21, 'AP-1000', '2010-06-20', '2019-01-09', NULL, 1126, 'WNA/IAEA', '2019-06-02 20:18:37', 909);
INSERT INTO `nuclear_power_plants` VALUES (279, 'Haiyang-3', 36.704000, 121.382000, 'CN', 2, 21, 'CAP1000', '2022-07-07', NULL, NULL, 1161, 'WNA/IAEA', '2022-09-24 22:33:57', 993);
INSERT INTO `nuclear_power_plants` VALUES (280, 'Haiyang-4', 36.704000, 121.382000, 'CN', 2, 21, 'CAP1000', '2023-04-22', NULL, NULL, 1161, 'WNA/IAEA', '2023-08-28 08:01:45', 994);
INSERT INTO `nuclear_power_plants` VALUES (281, 'Hallam', 40.559000, -96.785000, 'US', 5, 19, 'LMGMR (SGR-Sodium cooled graphite moderated reactor)', '1959-01-01', '1963-11-01', '1964-09-01', 75, 'WNA/IAEA', '2015-08-23 03:28:28', 891);
INSERT INTO `nuclear_power_plants` VALUES (282, 'Hamaoka-1', 34.621000, 138.141000, 'JP', 5, 5, 'BWR-4', '1971-06-10', '1976-03-17', '2009-01-30', 516, 'WNA/IAEA', '2015-05-24 04:51:27', 335);
INSERT INTO `nuclear_power_plants` VALUES (283, 'Hamaoka-2', 34.621000, 138.141000, 'JP', 5, 5, 'BWR-4', '1974-06-14', '1978-11-29', '2009-01-30', 814, 'WNA/IAEA', '2015-05-24 04:51:28', 349);
INSERT INTO `nuclear_power_plants` VALUES (284, 'Hamaoka-3', 34.621000, 138.141000, 'JP', 4, 5, 'BWR-5', '1983-04-18', '1987-08-28', NULL, 1056, 'WNA/IAEA', '2022-12-30 02:07:18', 362);
INSERT INTO `nuclear_power_plants` VALUES (285, 'Hamaoka-4', 34.621000, 138.141000, 'JP', 4, 5, 'BWR-5', '1989-10-13', '1993-09-03', NULL, 1092, 'WNA/IAEA', '2022-12-30 02:07:18', 376);
INSERT INTO `nuclear_power_plants` VALUES (286, 'Hamaoka-5', 34.621000, 138.141000, 'JP', 4, 5, 'ABWR', '2000-07-12', '2005-01-18', NULL, 1325, 'WNA/IAEA', '2022-12-30 02:07:18', 843);
INSERT INTO `nuclear_power_plants` VALUES (287, 'Hamaoka-6', 34.621000, 138.141000, 'JP', 1, 1, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (288, 'Hanbit-1', 35.405000, 126.410000, 'KR', 3, 21, 'WH F', '1981-06-04', '1986-08-25', NULL, 903, 'IAEA', '2022-04-21 20:26:19', 411);
INSERT INTO `nuclear_power_plants` VALUES (289, 'Hanbit-2', 35.405000, 126.410000, 'KR', 3, 21, 'WH F', '1981-12-01', '1987-06-10', NULL, 903, 'IAEA', '2022-04-21 20:26:19', 412);
INSERT INTO `nuclear_power_plants` VALUES (290, 'Hanbit-3', 35.405000, 126.410000, 'KR', 3, 21, 'OPR-1000', '1989-12-23', '1995-03-31', NULL, 950, 'IAEA', '2022-04-21 20:26:19', 396);
INSERT INTO `nuclear_power_plants` VALUES (291, 'Hanbit-4', 35.405000, 126.410000, 'KR', 3, 21, 'OPR-1000', '1990-05-26', '1996-01-01', NULL, 950, 'IAEA', '2022-09-24 22:33:57', 397);
INSERT INTO `nuclear_power_plants` VALUES (292, 'Hanbit-5', 35.405000, 126.410000, 'KR', 3, 21, 'OPR-1000', '1997-06-29', '2002-05-21', NULL, 950, 'IAEA', '2023-08-28 08:01:45', 402);
INSERT INTO `nuclear_power_plants` VALUES (293, 'Hanbit-6', 35.405000, 126.410000, 'KR', 3, 21, 'OPR-1000', '1997-11-20', '2002-12-24', NULL, 993, 'IAEA', '2021-04-20 02:47:37', 403);
INSERT INTO `nuclear_power_plants` VALUES (294, 'Hanul-1', 37.090000, 129.384444, 'KR', 3, 21, 'France CPI', '1983-01-26', '1988-09-10', NULL, 903, 'IAEA', '2022-04-21 20:26:19', 413);
INSERT INTO `nuclear_power_plants` VALUES (295, 'Hanul-2', 37.090000, 129.384444, 'KR', 3, 21, 'France CPI', '1983-07-05', '1989-09-30', NULL, 903, 'IAEA', '2023-08-28 08:01:45', 395);
INSERT INTO `nuclear_power_plants` VALUES (296, 'Hanul-3', 37.090000, 129.384444, 'KR', 3, 21, 'OPR-1000', '1993-07-21', '1998-08-11', NULL, 997, 'IAEA', '2021-04-20 02:47:37', 398);
INSERT INTO `nuclear_power_plants` VALUES (297, 'Hanul-4', 37.090000, 129.384444, 'KR', 3, 21, 'OPR-1000', '1993-11-01', '1999-12-31', NULL, 950, 'IAEA', '2022-04-21 20:26:19', 399);
INSERT INTO `nuclear_power_plants` VALUES (298, 'Hanul-5', 37.090000, 129.384444, 'KR', 3, 21, 'OPR-1000', '1999-10-01', '2004-07-29', NULL, 950, 'IAEA', '2022-04-21 20:26:19', 404);
INSERT INTO `nuclear_power_plants` VALUES (299, 'Hanul-6', 37.090000, 129.384444, 'KR', 3, 21, 'OPR-1000', '2000-09-29', '2005-04-22', NULL, 950, 'IAEA', '2022-04-21 20:26:19', 406);
INSERT INTO `nuclear_power_plants` VALUES (300, 'Hartlepool-A1', 54.634000, -1.180000, 'GB', 3, 8, 'AGR', '1968-10-01', '1989-04-01', NULL, 590, 'WNA/IAEA', '2021-04-20 02:47:37', 250);
INSERT INTO `nuclear_power_plants` VALUES (301, 'Hartlepool-A2', 54.634000, -1.180000, 'GB', 3, 8, 'AGR', '1968-10-01', '1989-04-01', NULL, 595, 'WNA/IAEA', '2021-04-20 02:47:37', 251);
INSERT INTO `nuclear_power_plants` VALUES (302, 'Hatch-1', 31.935000, -82.346000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1968-09-30', '1975-12-31', NULL, 777, 'WNA/IAEA', '2015-05-24 04:51:44', 658);
INSERT INTO `nuclear_power_plants` VALUES (303, 'Hatch-2', 31.935000, -82.346000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1972-02-01', '1979-09-05', NULL, 784, 'WNA/IAEA', '2015-05-24 04:51:47', 687);
INSERT INTO `nuclear_power_plants` VALUES (304, 'Heysham-A1', 54.029000, -2.912000, 'GB', 3, 8, 'AGR', '1970-12-01', '1989-04-01', NULL, 611, 'WNA/IAEA', '2015-05-24 04:51:18', 256);
INSERT INTO `nuclear_power_plants` VALUES (305, 'Heysham-A2', 54.029000, -2.912000, 'GB', 3, 8, 'AGR', '1970-12-01', '1989-04-01', NULL, 611, 'WNA/IAEA', '2015-05-24 04:51:18', 257);
INSERT INTO `nuclear_power_plants` VALUES (306, 'Heysham-B1', 54.029000, -2.912000, 'GB', 3, 8, 'AGR', '1980-08-01', '1989-04-01', NULL, 615, 'WNA/IAEA', '2015-05-24 04:51:18', 259);
INSERT INTO `nuclear_power_plants` VALUES (307, 'Heysham-B2', 54.029000, -2.912000, 'GB', 3, 8, 'AGR', '1980-08-01', '1989-04-01', NULL, 615, 'WNA/IAEA', '2015-05-24 04:51:18', 260);
INSERT INTO `nuclear_power_plants` VALUES (308, 'Higashi Dori-1 (Tohoku)', 41.188000, 141.393000, 'JP', 4, 5, 'BWR-5', '2000-11-07', '2005-12-08', NULL, 1067, 'WNA/IAEA', '2022-12-30 02:21:21', 841);
INSERT INTO `nuclear_power_plants` VALUES (309, 'Higashi Dori-1 (Tokyo)', 41.185600, 141.388000, 'JP', 1, 1, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (310, 'Higashi Dori-2 (Tohoku)', 41.185600, 141.390000, 'JP', 1, 1, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (311, 'Higashi Dori-2 (Tokyo)', 41.185600, 141.389000, 'JP', 1, 1, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (312, 'Hinkley Point-A1', 51.209000, -3.131000, 'GB', 5, 8, 'MAGNOX', '1957-11-01', '1965-03-30', '2000-05-23', 250, 'WNA/IAEA', '2015-05-24 04:51:19', 271);
INSERT INTO `nuclear_power_plants` VALUES (313, 'Hinkley Point-A2', 51.209000, -3.131000, 'GB', 5, 8, 'MAGNOX', '1957-11-01', '1965-05-05', '2000-05-23', 250, 'WNA/IAEA', '2015-05-24 04:51:19', 272);
INSERT INTO `nuclear_power_plants` VALUES (314, 'Hinkley Point-B1', 51.209000, -3.131000, 'GB', 5, 8, 'AGR', '1967-09-01', '1978-10-02', '2022-08-01', 625, 'WNA/IAEA', '2022-09-24 22:33:57', 244);
INSERT INTO `nuclear_power_plants` VALUES (315, 'Hinkley Point-B2', 51.209000, -3.131000, 'GB', 5, 8, 'AGR', '1967-09-01', '1976-09-27', '2022-07-06', 625, 'WNA/IAEA', '2022-09-24 22:33:57', 245);
INSERT INTO `nuclear_power_plants` VALUES (316, 'Hinkley Point-C1', 51.208700, -3.130500, 'GB', 2, 21, 'EPR-1750', '2018-12-11', NULL, NULL, 1630, 'WNA/IAEA', '2019-06-02 20:18:41', 1072);
INSERT INTO `nuclear_power_plants` VALUES (317, 'Hinkley Point-C2', 51.208700, -3.130500, 'GB', 2, 21, 'EPR-1750', '2019-12-12', NULL, NULL, 1630, 'WNA/IAEA', '2020-04-18 04:46:52', 1073);
INSERT INTO `nuclear_power_plants` VALUES (318, 'Hongshiding-1 (Rushan-1)', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (319, 'Hongshiding-2 (Rushan-2)', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (320, 'Hongyanhe-1', 39.797000, 121.476500, 'CN', 3, 21, 'CPR-1000', '2007-08-18', '2013-06-06', NULL, 1061, 'WNA/IAEA/GEO', '2015-08-23 03:28:28', 904);
INSERT INTO `nuclear_power_plants` VALUES (321, 'Hongyanhe-2', 39.797000, 121.476500, 'CN', 3, 21, 'CPR-1000', '2008-03-28', '2014-05-13', NULL, 1061, 'WNA/IAEA/GEO', '2015-08-23 03:28:28', 905);
INSERT INTO `nuclear_power_plants` VALUES (322, 'Hongyanhe-3', 39.797000, 121.476500, 'CN', 3, 21, 'CPR-1000', '2009-03-07', '2015-08-16', NULL, 1061, 'WNA/IAEA/GEO', '2017-09-25 03:20:36', 906);
INSERT INTO `nuclear_power_plants` VALUES (323, 'Hongyanhe-4', 39.797000, 121.476500, 'CN', 3, 21, 'CPR-1000', '2009-08-15', '2016-06-08', NULL, 1061, 'WNA/IAEA/GEO', '2019-06-02 20:18:47', 907);
INSERT INTO `nuclear_power_plants` VALUES (324, 'Hongyanhe-5', 39.797000, 121.483100, 'CN', 3, 21, 'ACPR-1000', '2015-03-29', '2021-07-31', NULL, 1061, 'WNA/IAEA/GEO', '2022-01-05 00:04:08', 997);
INSERT INTO `nuclear_power_plants` VALUES (325, 'Hongyanhe-6', 39.797000, 121.483100, 'CN', 3, 21, 'ACPR-1000', '2015-07-24', '2022-06-23', NULL, 1061, 'WNA/IAEA/GEO', '2022-09-24 22:33:57', 998);
INSERT INTO `nuclear_power_plants` VALUES (326, 'Hope Creek-1', 39.467000, -75.535000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1976-03-01', '1986-12-20', NULL, 1067, 'WNA/IAEA', '2015-05-24 04:51:47', 680);
INSERT INTO `nuclear_power_plants` VALUES (327, 'Humboldt Bay', 40.741000, -124.210000, 'US', 5, 5, 'Natural cir.', '1960-11-01', '1963-08-01', '1976-07-02', 65, 'WNA/IAEA', '2015-05-24 04:51:41', 599);
INSERT INTO `nuclear_power_plants` VALUES (328, 'Hunterston-A1', 55.722000, -4.893000, 'GB', 5, 8, 'MAGNOX', '1957-10-01', '1964-02-05', '1990-03-30', 150, 'WNA/IAEA', '2015-05-24 04:51:19', 269);
INSERT INTO `nuclear_power_plants` VALUES (329, 'Hunterston-A2', 55.722000, -4.893000, 'GB', 5, 8, 'MAGNOX', '1957-10-01', '1964-07-01', '1989-12-31', 150, 'WNA/IAEA', '2015-05-24 04:51:19', 270);
INSERT INTO `nuclear_power_plants` VALUES (330, 'Hunterston-B1', 55.722000, -4.893000, 'GB', 5, 8, 'AGR', '1967-11-01', '1976-02-07', '2021-11-26', 624, 'WNA/IAEA', '2022-01-05 00:04:08', 246);
INSERT INTO `nuclear_power_plants` VALUES (331, 'Hunterston-B2', 55.722000, -4.893000, 'GB', 5, 8, 'AGR', '1967-11-01', '1977-04-01', '2022-01-07', 624, 'WNA/IAEA', '2022-04-21 20:26:19', 247);
INSERT INTO `nuclear_power_plants` VALUES (332, 'Ignalina-1', 55.604000, 26.562000, 'LT', 5, 17, 'RBMK-1500', '1977-05-01', '1985-05-01', '2004-12-31', 1500, 'WNA/IAEA', '2022-04-21 20:26:19', 415);
INSERT INTO `nuclear_power_plants` VALUES (333, 'Ignalina-2', 55.604000, 26.562000, 'LT', 5, 17, 'RBMK-1500', '1978-01-01', '1987-12-01', '2009-12-31', 1500, 'WNA/IAEA', '2022-04-21 20:26:19', 416);
INSERT INTO `nuclear_power_plants` VALUES (334, 'Ignalina-3', 55.604000, 26.562000, 'LT', 9, 17, 'RBMK-1500', '1985-06-01', NULL, NULL, 1380, 'WNA/IAEA', '2021-02-14 01:18:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (335, 'Ikata-1', 33.491000, 132.309000, 'JP', 5, 21, 'M (2-loop)', '1973-09-01', '1977-09-30', '2016-05-10', 538, 'WNA/IAEA', '2017-02-10 23:56:25', 348);
INSERT INTO `nuclear_power_plants` VALUES (336, 'Ikata-2', 33.491000, 132.309000, 'JP', 5, 21, 'M (2-loop)', '1978-08-01', '1982-03-19', '2018-05-23', 538, 'WNA/IAEA', '2019-06-02 20:18:50', 358);
INSERT INTO `nuclear_power_plants` VALUES (337, 'Ikata-3', 33.491000, 132.309000, 'JP', 3, 21, 'M (3-loop)', '1990-10-01', '1994-12-15', NULL, 846, 'WNA/IAEA', '2015-05-24 04:51:29', 374);
INSERT INTO `nuclear_power_plants` VALUES (338, 'Indian Point-1', 41.270000, -73.950000, 'US', 5, 21, 'PWR', '1956-05-01', '1962-10-01', '1974-10-31', 265, 'WNA/IAEA', '2015-05-24 04:51:43', 643);
INSERT INTO `nuclear_power_plants` VALUES (339, 'Indian Point-2', 41.270000, -73.950000, 'US', 5, 21, 'WH 4LP (DRYAMB)', '1966-10-14', '1974-08-01', '2020-04-30', 873, 'WNA/IAEA', '2020-06-06 02:15:57', 611);
INSERT INTO `nuclear_power_plants` VALUES (340, 'Indian Point-3', 41.270000, -73.950000, 'US', 5, 21, 'WH 4LP (DRYAMB)', '1968-10-30', '1976-08-28', '2021-04-28', 965, 'WNA/IAEA', '2022-04-21 20:26:19', 635);
INSERT INTO `nuclear_power_plants` VALUES (341, 'Isar-1', 48.607000, 12.296000, 'DE', 5, 5, 'BWR-69', '1972-05-01', '1979-03-21', '2011-08-06', 870, 'WNA/IAEA', '2015-05-24 04:50:42', 89);
INSERT INTO `nuclear_power_plants` VALUES (342, 'Isar-2', 48.607000, 12.296000, 'DE', 5, 21, 'Konvoi', '1982-09-15', '1988-04-09', '2023-04-15', 1285, 'WNA/IAEA', '2023-08-28 08:01:45', 106);
INSERT INTO `nuclear_power_plants` VALUES (343, 'Jaitapur-1', 16.595278, 73.341111, 'IN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA/Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (344, 'Jaitapur-2', 16.595278, 73.341111, 'IN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA/Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (345, 'Java-1 (Muria)', NULL, NULL, 'ID', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (346, 'Jose Cabrera-1 (Zorita)', 40.362000, -2.818000, 'ES', 5, 21, 'WH 1LP', '1964-06-24', '1969-08-13', '2006-04-30', 153, 'WNA/IAEA', '2017-02-10 23:56:06', 139);
INSERT INTO `nuclear_power_plants` VALUES (347, 'JPDR', 36.462500, 140.610000, 'JP', 5, 5, 'BWR-1', '1960-12-01', '1965-03-15', '1976-03-18', 10, 'IAEA', '2015-05-24 04:51:26', 333);
INSERT INTO `nuclear_power_plants` VALUES (348, 'AVR Juelich', 50.903000, 6.421000, 'DE', 5, 9, 'Pebble bed reactor prototype', '1961-08-01', '1969-05-19', '1988-12-31', 13, 'WNA/IAEA', '2021-06-07 00:00:00', 114);
INSERT INTO `nuclear_power_plants` VALUES (349, 'Kahl', 50.059000, 8.987000, 'DE', 11, 5, 'BWR', '1958-07-01', NULL, '1985-11-25', 15, 'WNA/IAEA', '2022-12-30 02:24:37', 82);
INSERT INTO `nuclear_power_plants` VALUES (350, 'Kaiga-1', 14.865000, 74.438000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '1989-09-01', '2000-11-16', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:05', 289);
INSERT INTO `nuclear_power_plants` VALUES (351, 'Kaiga-2', 14.865000, 74.438000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '1989-12-01', '2000-03-16', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:05', 290);
INSERT INTO `nuclear_power_plants` VALUES (352, 'Kaiga-3', 14.865000, 74.438000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '2002-03-30', '2007-05-06', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:05', 291);
INSERT INTO `nuclear_power_plants` VALUES (353, 'Kaiga-4', 14.865000, 74.438000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '2002-05-10', '2011-01-20', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:06', 292);
INSERT INTO `nuclear_power_plants` VALUES (354, 'Kaiga-5', 14.868000, 74.441800, 'IN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (355, 'Kaiga-6', 14.868000, 74.442200, 'IN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (356, 'Kakrapar-1', 21.236000, 73.351000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '1984-12-01', '1993-05-06', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:06', 308);
INSERT INTO `nuclear_power_plants` VALUES (357, 'Kakrapar-2', 21.236000, 73.351000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '1985-04-01', '1995-09-01', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:05', 286);
INSERT INTO `nuclear_power_plants` VALUES (358, 'Kakrapar-3', 21.236000, 73.351000, 'IN', 3, 20, 'PHWR-700', '2010-11-22', NULL, NULL, 630, 'WNA/IAEA', '2021-02-14 03:47:53', 986);
INSERT INTO `nuclear_power_plants` VALUES (359, 'Kakrapar-4', 21.236000, 73.351000, 'IN', 2, 20, 'PHWR-700', '2010-11-22', NULL, NULL, 630, 'WNA/IAEA', '2015-05-24 04:51:57', 987);
INSERT INTO `nuclear_power_plants` VALUES (360, 'Kalinin-1', 57.903000, 35.057000, 'RU', 3, 21, 'VVER V-338', '1977-02-01', '1985-06-12', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:34', 489);
INSERT INTO `nuclear_power_plants` VALUES (361, 'Kalinin-2', 57.903000, 35.057000, 'RU', 3, 21, 'VVER V-338', '1982-02-01', '1987-03-03', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:34', 490);
INSERT INTO `nuclear_power_plants` VALUES (362, 'Kalinin-3', 57.903000, 35.057000, 'RU', 3, 21, 'VVER V-320', '1985-10-01', '2005-11-08', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:34', 495);
INSERT INTO `nuclear_power_plants` VALUES (363, 'Kalinin-4', 57.903000, 35.057000, 'RU', 3, 21, 'VVER V-320', '1986-08-01', '2012-12-25', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:35', 496);
INSERT INTO `nuclear_power_plants` VALUES (364, 'Kalpakkam (PFBR)', 12.553000, 80.174000, 'IN', 2, 7, 'Prototype', '2004-10-23', NULL, NULL, 470, 'WNA/IAEA', '2015-05-24 04:51:50', 859);
INSERT INTO `nuclear_power_plants` VALUES (365, 'Kalpakkam-1 (Madras-1 / MAPS1)', 12.553000, 80.174000, 'IN', 4, 20, 'Horizontal Pressure Tube type', '1971-01-01', '1984-01-27', NULL, 202, 'WNA/IAEA', '2023-08-28 08:01:45', 304);
INSERT INTO `nuclear_power_plants` VALUES (366, 'Kalpakkam-2 (Madras-2 / MAPS2)', 12.553000, 80.174000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '1972-10-01', '1986-03-21', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:06', 305);
INSERT INTO `nuclear_power_plants` VALUES (367, 'Kaminoseki-1', NULL, NULL, 'JP', 1, 1, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (368, 'Kaminoseki-2', NULL, NULL, 'JP', 1, 1, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (369, 'KANUPP-1', 24.845000, 66.790000, 'PK', 5, 20, 'CANDU-137 MW', '1966-08-01', '1972-12-07', '2021-08-01', 125, 'WNA/IAEA', '2022-01-05 00:04:08', 427);
INSERT INTO `nuclear_power_plants` VALUES (370, 'MZFR', 49.104000, 8.432000, 'DE', 5, 20, NULL, '1961-12-01', '1966-12-19', '1984-05-03', 50, 'WNA/IAEA', '2021-06-07 00:00:00', 93);
INSERT INTO `nuclear_power_plants` VALUES (371, 'Kashiwazaki Kariwa-1', 37.434000, 138.598000, 'JP', 4, 5, 'BWR-5', '1980-06-05', '1985-09-18', NULL, 1067, 'WNA/IAEA', '2022-09-24 22:33:57', 359);
INSERT INTO `nuclear_power_plants` VALUES (372, 'Kashiwazaki Kariwa-2', 37.434000, 138.598000, 'JP', 4, 5, 'BWR-5', '1985-11-18', '1990-09-28', NULL, 1067, 'WNA/IAEA', '2022-09-24 22:33:57', 365);
INSERT INTO `nuclear_power_plants` VALUES (373, 'Kashiwazaki Kariwa-3', 37.434000, 138.598000, 'JP', 4, 5, 'BWR-5', '1989-03-07', '1993-08-11', NULL, 1067, 'WNA/IAEA', '2022-09-24 22:33:57', 380);
INSERT INTO `nuclear_power_plants` VALUES (374, 'Kashiwazaki Kariwa-4', 37.434000, 138.598000, 'JP', 4, 5, 'BWR-5', '1990-03-05', '1994-08-11', NULL, 1067, 'WNA/IAEA', '2022-09-24 22:33:57', 381);
INSERT INTO `nuclear_power_plants` VALUES (375, 'Kashiwazaki Kariwa-5', 37.434000, 138.598000, 'JP', 4, 5, 'BWR-5', '1985-06-20', '1990-04-10', NULL, 1067, 'WNA/IAEA', '2022-09-24 22:33:57', 367);
INSERT INTO `nuclear_power_plants` VALUES (376, 'Kashiwazaki Kariwa-6', 37.434000, 138.598000, 'JP', 4, 5, 'ABWR', '1992-11-03', '1996-11-07', NULL, 1315, 'WNA/IAEA', '2023-08-28 08:01:45', 383);
INSERT INTO `nuclear_power_plants` VALUES (377, 'Kashiwazaki Kariwa-7', 37.434000, 138.598000, 'JP', 4, 5, 'ABWR', '1993-07-01', '1997-07-02', NULL, 1315, 'WNA/IAEA', '2023-08-28 08:01:45', 384);
INSERT INTO `nuclear_power_plants` VALUES (378, 'Kewaunee', 44.470000, -87.498000, 'US', 5, 21, 'WH 2LP (DRYAMB)', '1968-08-06', '1974-06-16', '2013-05-07', 535, 'WNA/IAEA', '2017-02-10 23:58:26', 647);
INSERT INTO `nuclear_power_plants` VALUES (379, 'Khmelnitski-1', 50.301000, 26.649000, 'UA', 3, 21, 'VVER V-320', '1981-11-01', '1988-08-13', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:40', 573);
INSERT INTO `nuclear_power_plants` VALUES (380, 'Khmelnitski-2', 50.301000, 26.649000, 'UA', 3, 21, 'VVER V-320', '1985-02-01', '2005-12-15', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:40', 574);
INSERT INTO `nuclear_power_plants` VALUES (381, 'Khmelnitski-3', 50.303056, 26.642778, 'UA', 2, 21, 'VVER', '1986-03-01', NULL, NULL, 1035, 'IAEA', '2017-09-25 03:20:02', 581);
INSERT INTO `nuclear_power_plants` VALUES (382, 'Khmelnitski-4', 50.303056, 26.642778, 'UA', 2, 21, 'VVER', '1987-02-01', NULL, NULL, 1035, 'IAEA', '2017-09-25 03:20:09', 582);
INSERT INTO `nuclear_power_plants` VALUES (383, 'KNK-II', 49.098000, 8.441000, 'DE', 5, 7, 'Prototype', '1974-09-01', '1979-03-03', '1991-08-23', 18, 'WNA/IAEA', '2015-05-24 04:50:48', 135);
INSERT INTO `nuclear_power_plants` VALUES (384, 'Koeberg-1', -33.677000, 18.433000, 'ZA', 3, 21, 'CP1', '1976-07-01', '1984-07-21', NULL, 921, 'WNA/IAEA', '2015-05-24 04:51:50', 836);
INSERT INTO `nuclear_power_plants` VALUES (385, 'Koeberg-2', -33.677000, 18.433000, 'ZA', 3, 21, 'CP1', '1976-07-01', '1985-11-09', NULL, 921, 'WNA/IAEA', '2015-05-24 04:51:50', 837);
INSERT INTO `nuclear_power_plants` VALUES (386, 'Kola-1', 67.467000, 32.491000, 'RU', 3, 21, 'VVER V-230', '1970-05-01', '1973-12-28', NULL, 411, 'WNA/IAEA', '2015-05-24 04:51:32', 453);
INSERT INTO `nuclear_power_plants` VALUES (387, 'Kola-2', 67.467000, 32.491000, 'RU', 3, 21, 'VVER V-230', '1970-05-01', '1975-02-21', NULL, 411, 'WNA/IAEA', '2015-05-24 04:51:32', 460);
INSERT INTO `nuclear_power_plants` VALUES (388, 'Kola-3', 67.467000, 32.491000, 'RU', 3, 21, 'VVER V-213', '1977-04-01', '1982-12-03', NULL, 411, 'WNA/IAEA', '2015-05-24 04:51:34', 491);
INSERT INTO `nuclear_power_plants` VALUES (389, 'Kola-4', 67.467000, 32.491000, 'RU', 3, 21, 'VVER V-213', '1976-08-01', '1984-12-06', NULL, 411, 'WNA/IAEA', '2015-05-24 04:51:34', 492);
INSERT INTO `nuclear_power_plants` VALUES (390, 'Kori-1', 35.321000, 129.295000, 'KR', 5, 21, 'WH 60', '1972-08-01', '1978-04-29', '2017-06-18', 558, 'WNA/IAEA', '2017-09-25 03:19:42', 394);
INSERT INTO `nuclear_power_plants` VALUES (391, 'Kori-2', 35.321000, 129.295000, 'KR', 3, 21, 'WH F', '1977-12-23', '1983-07-25', NULL, 618, 'WNA/IAEA', '2022-04-21 20:26:19', 405);
INSERT INTO `nuclear_power_plants` VALUES (392, 'Kori-3', 35.321000, 129.295000, 'KR', 3, 21, 'WH F', '1979-10-01', '1985-09-30', NULL, 1001, 'WNA/IAEA', '2022-04-21 20:26:19', 409);
INSERT INTO `nuclear_power_plants` VALUES (393, 'Kori-4', 35.321000, 129.295000, 'KR', 3, 21, 'WH F', '1980-04-01', '1986-04-29', NULL, 1012, 'WNA/IAEA', '2021-04-20 02:47:37', 410);
INSERT INTO `nuclear_power_plants` VALUES (394, 'Kozloduy-1', 43.744000, 23.776000, 'BG', 5, 21, 'VVER V-230', '1970-04-01', '1974-10-28', '2002-12-31', 408, 'WNA/IAEA', '2015-05-24 04:50:16', 16);
INSERT INTO `nuclear_power_plants` VALUES (395, 'Kozloduy-2', 43.744000, 23.776000, 'BG', 5, 21, 'VVER V-230', '1970-04-01', '1975-11-10', '2002-12-31', 408, 'WNA/IAEA', '2015-05-24 04:50:16', 17);
INSERT INTO `nuclear_power_plants` VALUES (396, 'Kozloduy-3', 43.744000, 23.776000, 'BG', 5, 21, 'VVER V-230', '1973-10-01', '1981-01-20', '2006-12-31', 408, 'WNA/IAEA', '2015-05-24 04:50:17', 18);
INSERT INTO `nuclear_power_plants` VALUES (397, 'Kozloduy-4', 43.744000, 23.776000, 'BG', 5, 21, 'VVER V-230', '1973-10-01', '1982-06-20', '2006-12-31', 408, 'WNA/IAEA', '2015-05-24 04:50:17', 19);
INSERT INTO `nuclear_power_plants` VALUES (398, 'Kozloduy-5', 43.744000, 23.776000, 'BG', 3, 21, 'VVER V-320', '1980-07-09', '1988-12-23', NULL, 953, 'WNA/IAEA', '2022-04-21 20:26:19', 20);
INSERT INTO `nuclear_power_plants` VALUES (399, 'Kozloduy-6', 43.744000, 23.776000, 'BG', 3, 21, 'VVER V-320', '1982-04-01', '1993-12-30', NULL, 1003, 'WNA/IAEA', '2020-04-18 04:46:52', 21);
INSERT INTO `nuclear_power_plants` VALUES (400, 'Krsko', 45.939000, 15.516000, 'SI', 3, 21, 'WH 2LP', '1975-03-30', '1983-01-01', NULL, 632, 'WNA/IAEA', '2017-02-10 23:57:25', 542);
INSERT INTO `nuclear_power_plants` VALUES (401, 'Kruemmel', 53.410000, 10.410000, 'DE', 5, 5, 'BWR-69', '1974-04-05', '1984-03-28', '2011-08-06', 1260, 'WNA/IAEA', '2015-05-24 04:50:44', 94);
INSERT INTO `nuclear_power_plants` VALUES (402, 'Kudankulam-1', 8.167000, 77.713000, 'IN', 3, 21, 'VVER V-412', '2002-03-31', '2014-12-31', NULL, 917, 'WNA/IAEA', '2015-05-24 04:51:50', 852);
INSERT INTO `nuclear_power_plants` VALUES (403, 'Kudankulam-2', 8.167000, 77.713000, 'IN', 3, 21, 'VVER V-412', '2002-07-04', '2017-03-31', NULL, 917, 'WNA/IAEA', '2017-09-25 03:20:10', 853);
INSERT INTO `nuclear_power_plants` VALUES (404, 'Kudankulam-3', 8.167050, 77.708000, 'IN', 2, 21, 'VVER V-412', '2017-06-29', NULL, NULL, 917, 'WNA/IAEA', '2017-09-25 03:20:58', 1059);
INSERT INTO `nuclear_power_plants` VALUES (405, 'Kudankulam-4', 8.166660, 77.708000, 'IN', 2, 21, 'VVER V-412', '2017-10-23', NULL, NULL, 917, 'WNA/IAEA', '2018-07-01 01:21:38', 1060);
INSERT INTO `nuclear_power_plants` VALUES (406, 'Kudankulam-5', 8.166270, 77.708000, 'IN', 2, 21, 'VVERV412', '2021-06-29', NULL, NULL, 917, 'WNA/IAEA', '2022-09-24 22:33:57', 1108);
INSERT INTO `nuclear_power_plants` VALUES (407, 'Kudankulam-6', 8.165880, 77.708000, 'IN', 2, 21, 'VVERV412', '2021-12-20', NULL, NULL, 917, 'WNA/IAEA', '2022-09-24 22:33:57', 1109);
INSERT INTO `nuclear_power_plants` VALUES (408, 'Kumharia-1', NULL, NULL, 'IN', 1, 20, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (409, 'Kumharia-2', NULL, NULL, 'IN', 1, 20, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (410, 'Kumharia-3', NULL, NULL, 'IN', 1, 20, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (411, 'Kumharia-4', NULL, NULL, 'IN', 1, 20, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (412, 'Kuosheng-1', 25.203000, 121.662000, 'TW', 5, 5, 'BWR-6', '1975-11-19', '1981-12-28', '2021-12-28', 948, 'WNA/IAEA', '2022-04-21 20:26:19', 556);
INSERT INTO `nuclear_power_plants` VALUES (413, 'Kuosheng-2', 25.203000, 121.662000, 'TW', 5, 5, 'BWR-6', '1976-03-15', '1983-03-16', '2023-03-14', 948, 'WNA/IAEA', '2024-03-03 20:43:43', 557);
INSERT INTO `nuclear_power_plants` VALUES (414, 'Kursk-1', 51.674000, 35.607000, 'RU', 5, 17, 'RBMK-1000', '1972-06-01', '1977-10-12', '2021-12-19', 925, 'WNA/IAEA', '2022-09-24 22:33:57', 476);
INSERT INTO `nuclear_power_plants` VALUES (415, 'Kursk-2', 51.674000, 35.607000, 'RU', 3, 17, 'RBMK-1000', '1973-01-01', '1979-08-17', NULL, 925, 'WNA/IAEA', '2015-05-24 04:51:34', 485);
INSERT INTO `nuclear_power_plants` VALUES (416, 'Kursk-3', 51.674000, 35.607000, 'RU', 3, 17, 'RBMK-1000', '1978-04-01', '1984-03-30', NULL, 925, 'WNA/IAEA', '2015-05-24 04:51:35', 497);
INSERT INTO `nuclear_power_plants` VALUES (417, 'Kursk-4', 51.674000, 35.607000, 'RU', 3, 17, 'RBMK-1000', '1981-05-01', '1986-02-05', NULL, 925, 'WNA/IAEA', '2015-05-24 04:51:35', 498);
INSERT INTO `nuclear_power_plants` VALUES (418, 'LaCrosse', 43.559000, -91.230000, 'US', 5, 5, NULL, '1963-03-01', '1969-11-07', '1987-04-30', 50, 'WNA/IAEA', '2015-05-24 04:51:48', 710);
INSERT INTO `nuclear_power_plants` VALUES (419, 'Laguna Verde-1', 19.719000, -96.405000, 'MX', 3, 5, 'BWR-5', '1976-09-30', '1990-07-28', NULL, 780, 'WNA/IAEA', '2022-04-21 20:26:19', 420);
INSERT INTO `nuclear_power_plants` VALUES (420, 'Laguna Verde-2', 19.719000, -96.405000, 'MX', 3, 5, 'BWR-5', '1977-06-01', '1995-04-10', NULL, 780, 'WNA/IAEA', '2016-03-09 18:43:28', 421);
INSERT INTO `nuclear_power_plants` VALUES (421, 'LaSalle-1', 41.246000, -88.672000, 'US', 3, 5, 'BWR-5 (Mark 2)', '1973-09-10', '1984-01-01', NULL, 1078, 'WNA/IAEA', '2015-05-24 04:51:48', 692);
INSERT INTO `nuclear_power_plants` VALUES (422, 'LaSalle-2', 41.246000, -88.672000, 'US', 3, 5, 'BWR-5 (Mark 2)', '1973-09-10', '1984-10-19', NULL, 1078, 'WNA/IAEA', '2015-05-24 04:51:48', 693);
INSERT INTO `nuclear_power_plants` VALUES (423, 'Latina', 41.427000, 12.808000, 'IT', 5, 8, 'MAGNOX', '1958-11-01', '1964-01-01', '1987-12-01', 200, 'WNA/IAEA', '2015-05-24 04:51:26', 318);
INSERT INTO `nuclear_power_plants` VALUES (424, 'Leibstadt', 47.601000, 8.183000, 'CH', 3, 5, 'BWR-6', '1974-01-01', '1984-12-15', NULL, 960, 'WNA/IAEA', '2015-05-24 04:50:39', 59);
INSERT INTO `nuclear_power_plants` VALUES (425, 'Leningrad 2-1', 59.837000, 29.039000, 'RU', 3, 21, 'VVER V-491', '2008-10-25', '2018-10-29', NULL, 1066, 'WNA/IAEA', '2019-11-22 00:00:00', 900);
INSERT INTO `nuclear_power_plants` VALUES (426, 'Leningrad 2-2', 59.837000, 29.039000, 'RU', 3, 21, 'VVER V-491', '2010-04-15', '2021-03-18', NULL, 1066, 'WNA/IAEA', '2021-04-30 21:49:18', 901);
INSERT INTO `nuclear_power_plants` VALUES (427, 'Leningrad 2-3', 59.837000, 29.039000, 'RU', 1, 21, 'VVER V-491', NULL, NULL, NULL, 1085, 'Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (428, 'Leningrad 2-4', 59.837000, 29.039000, 'RU', 1, 21, 'VVER V-491', NULL, NULL, NULL, 1085, 'Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (429, 'Leningrad-1', 59.837000, 29.039000, 'RU', 5, 17, 'RBMK-1000', '1970-03-01', '1974-11-01', '2018-12-22', 925, 'WNA/IAEA', '2019-06-02 20:19:08', 474);
INSERT INTO `nuclear_power_plants` VALUES (430, 'Leningrad-2', 59.837000, 29.039000, 'RU', 5, 17, 'RBMK-1000', '1970-06-01', '1976-02-11', '2020-11-10', 925, 'WNA/IAEA', '2021-01-06 01:19:47', 475);
INSERT INTO `nuclear_power_plants` VALUES (431, 'Leningrad-3', 59.837000, 29.039000, 'RU', 3, 17, 'RBMK-1000', '1973-12-01', '1980-06-29', NULL, 925, 'WNA/IAEA', '2015-05-24 04:51:34', 493);
INSERT INTO `nuclear_power_plants` VALUES (432, 'Leningrad-4', 59.837000, 29.039000, 'RU', 3, 17, 'RBMK-1000', '1975-02-01', '1981-08-29', NULL, 925, 'WNA/IAEA', '2015-05-24 04:51:34', 494);
INSERT INTO `nuclear_power_plants` VALUES (433, 'Lianyungang-1', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (434, 'Lianyungang-2', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (435, 'Limerick-1', 40.225000, -75.584000, 'US', 3, 5, 'BWR-4 (Mark 2)', '1974-06-19', '1986-02-01', NULL, 1055, 'WNA/IAEA', '2015-05-24 04:51:47', 678);
INSERT INTO `nuclear_power_plants` VALUES (436, 'Limerick-2', 40.225000, -75.584000, 'US', 3, 5, 'BWR-4 (Mark 2)', '1974-06-19', '1990-01-08', NULL, 1055, 'WNA/IAEA', '2015-05-24 04:51:47', 679);
INSERT INTO `nuclear_power_plants` VALUES (437, 'Lingao-1', 22.606000, 114.550000, 'CN', 3, 21, 'M310', '1997-05-15', '2002-05-28', NULL, 950, 'WNA/IAEA', '2015-05-24 04:50:40', 67);
INSERT INTO `nuclear_power_plants` VALUES (438, 'Lingao-2', 22.606000, 114.550000, 'CN', 3, 21, 'M310', '1997-11-28', '2003-01-08', NULL, 950, 'WNA/IAEA', '2015-05-24 04:50:40', 68);
INSERT INTO `nuclear_power_plants` VALUES (439, 'Lingao-3', 22.609000, 114.552000, 'CN', 3, 21, 'CPR-1000', '2005-12-15', '2010-09-15', NULL, 1007, 'WNA/IAEA', '2015-05-24 04:51:51', 878);
INSERT INTO `nuclear_power_plants` VALUES (440, 'Lingao-4', 22.609000, 114.552000, 'CN', 3, 21, 'CPR-1000', '2006-06-15', '2011-08-07', NULL, 1007, 'WNA/IAEA', '2015-05-24 04:51:51', 875);
INSERT INTO `nuclear_power_plants` VALUES (441, 'Lingen', 52.483000, 7.302000, 'DE', 5, 5, 'BWR with fossil fuel-fired superheater', '1964-10-01', '1968-10-01', '1977-01-05', 183, 'WNA/IAEA', '2021-02-14 03:47:53', 133);
INSERT INTO `nuclear_power_plants` VALUES (442, 'Longyou-1', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (443, 'Longyou-2', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (444, 'Loviisa-1', 60.372000, 26.342000, 'FI', 3, 21, 'VVER V-213', '1971-05-01', '1977-05-09', NULL, 420, 'WNA/IAEA', '2015-05-24 04:50:50', 157);
INSERT INTO `nuclear_power_plants` VALUES (445, 'Loviisa-2', 60.372000, 26.342000, 'FI', 3, 21, 'VVER V-213', '1972-08-01', '1981-01-05', NULL, 420, 'WNA/IAEA', '2015-05-24 04:50:50', 158);
INSERT INTO `nuclear_power_plants` VALUES (446, 'Lucens', 46.693000, 6.827000, 'CH', 5, 11, 'HWGCR: 2-loops', '1962-04-01', NULL, '1969-01-21', 6, 'WNA/IAEA', '2015-05-24 04:51:57', 966);
INSERT INTO `nuclear_power_plants` VALUES (447, 'Lungmen-1', 25.038000, 121.924000, 'TW', 8, 5, 'ABWR', '1999-03-31', NULL, NULL, 1300, 'WNA/IAEA', '2021-02-04 04:51:39', 560);
INSERT INTO `nuclear_power_plants` VALUES (448, 'Lungmen-2', 25.038000, 121.924000, 'TW', 8, 5, 'ABWR', '1999-08-30', NULL, NULL, 1300, 'WNA/IAEA', '2021-02-04 04:51:39', 561);
INSERT INTO `nuclear_power_plants` VALUES (449, 'Maanshan-1', 25.038000, 121.924000, 'TW', 3, 21, 'WH 3LP (WE 312)', '1978-08-21', '1984-07-27', NULL, 936, 'WNA/IAEA', '2021-04-20 02:47:37', 558);
INSERT INTO `nuclear_power_plants` VALUES (450, 'Maanshan-2', 25.038000, 121.924000, 'TW', 3, 21, 'WH 3LP (WE 312)', '1979-02-21', '1985-05-18', NULL, 938, 'WNA/IAEA', '2021-04-20 02:47:37', 559);
INSERT INTO `nuclear_power_plants` VALUES (451, 'Maine Yankee', 43.951000, -69.695000, 'US', 5, 21, NULL, '1968-10-01', '1972-12-28', '1997-08-01', 825, 'WNA/IAEA', '2015-05-24 04:51:44', 649);
INSERT INTO `nuclear_power_plants` VALUES (452, 'McGuire-1', 35.433000, -80.946000, 'US', 3, 21, 'WH 4LP (ICECND)', '1971-04-01', '1981-12-01', NULL, 1180, 'WNA/IAEA', '2017-02-10 23:58:55', 690);
INSERT INTO `nuclear_power_plants` VALUES (453, 'McGuire-2', 35.433000, -80.946000, 'US', 3, 21, 'WH 4LP (ICECND)', '1971-04-01', '1984-03-01', NULL, 1180, 'WNA/IAEA', '2017-02-10 23:58:55', 691);
INSERT INTO `nuclear_power_plants` VALUES (454, 'Mihama-1', 35.701000, 135.962000, 'JP', 5, 21, 'WH 2LP', '1967-02-01', '1970-11-28', '2015-04-27', 320, 'WNA/IAEA', '2017-02-10 23:56:29', 366);
INSERT INTO `nuclear_power_plants` VALUES (455, 'Mihama-2', 35.701000, 135.962000, 'JP', 5, 21, 'M (2-loop)', '1968-05-29', '1972-07-25', '2015-04-27', 470, 'WNA/IAEA', '2015-05-24 04:51:30', 386);
INSERT INTO `nuclear_power_plants` VALUES (456, 'Mihama-3', 35.701000, 135.962000, 'JP', 3, 21, 'M (3-loop)', '1972-08-07', '1976-12-01', NULL, 780, 'WNA/IAEA', '2015-05-24 04:51:27', 338);
INSERT INTO `nuclear_power_plants` VALUES (457, 'Millstone-1', 41.312000, -72.166000, 'US', 5, 5, NULL, '1966-05-01', '1971-03-01', '1998-07-01', 660, 'WNA/IAEA', '2015-05-24 04:51:41', 610);
INSERT INTO `nuclear_power_plants` VALUES (458, 'Millstone-2', 41.312000, -72.166000, 'US', 3, 21, 'CE 2LP (DRYAMB)', '1969-11-01', '1975-12-26', NULL, 870, 'WNA/IAEA', '2017-02-10 23:58:48', 671);
INSERT INTO `nuclear_power_plants` VALUES (459, 'Millstone-3', 41.312000, -72.166000, 'US', 3, 21, 'WH 4LP (DRYSUB)', '1974-08-09', '1986-04-23', NULL, 1159, 'WNA/IAEA', '2017-02-10 23:59:15', 717);
INSERT INTO `nuclear_power_plants` VALUES (460, 'Mochovce-1', 48.261000, 18.455000, 'SK', 3, 21, 'VVER V-213', '1983-10-13', '1998-10-29', NULL, 408, 'WNA/IAEA', '2021-10-01 00:14:53', 550);
INSERT INTO `nuclear_power_plants` VALUES (461, 'Mochovce-2', 48.261000, 18.455000, 'SK', 3, 21, 'VVER V-213', '1983-10-13', '2000-04-11', NULL, 408, 'WNA/IAEA', '2021-10-01 00:14:53', 551);
INSERT INTO `nuclear_power_plants` VALUES (462, 'Mochovce-3', 48.261000, 18.455000, 'SK', 3, 21, 'VVER V-213', '1987-01-27', NULL, NULL, 440, 'WNA/IAEA', '2023-08-28 08:01:45', 544);
INSERT INTO `nuclear_power_plants` VALUES (463, 'Mochovce-4', 48.261000, 18.455000, 'SK', 2, 21, 'VVER V-213', '1987-01-27', NULL, NULL, 440, 'WNA/IAEA', '2015-05-24 04:51:38', 545);
INSERT INTO `nuclear_power_plants` VALUES (464, 'Monju', 35.739000, 135.988000, 'JP', 5, 7, NULL, '1986-05-10', NULL, '2017-12-05', 246, 'WNA/IAEA', '2018-03-10 14:51:35', 357);
INSERT INTO `nuclear_power_plants` VALUES (465, 'Monticello', 45.334000, -93.850000, 'US', 3, 5, 'BWR-3 (Mark 1)', '1967-06-19', '1971-06-30', NULL, 545, 'WNA/IAEA', '2017-02-10 23:58:02', 620);
INSERT INTO `nuclear_power_plants` VALUES (466, 'Muehleberg', 46.969000, 7.266000, 'CH', 5, 5, 'BWR-4', '1967-03-01', '1972-11-06', '2019-12-20', 306, 'WNA/IAEA', '2020-04-18 04:46:52', 56);
INSERT INTO `nuclear_power_plants` VALUES (467, 'Muelheim-Kaerlich', 50.409000, 7.485000, 'DE', 5, 21, 'PWR', '1975-01-15', '1987-08-18', '1988-09-09', 1219, 'WNA/IAEA', '2015-05-24 04:50:45', 96);
INSERT INTO `nuclear_power_plants` VALUES (468, 'Narora-1', 28.156000, 78.409000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '1976-12-01', '1991-01-01', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:06', 306);
INSERT INTO `nuclear_power_plants` VALUES (469, 'Narora-2', 28.155000, 78.409000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '1977-11-01', '1992-07-01', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:06', 307);
INSERT INTO `nuclear_power_plants` VALUES (470, 'Neckarwestheim-1', 49.039000, 9.176000, 'DE', 5, 21, 'PWR', '1972-02-01', '1976-12-01', '2011-08-06', 805, 'WNA/IAEA', '2015-05-24 04:50:42', 88);
INSERT INTO `nuclear_power_plants` VALUES (471, 'Neckarwestheim-2', 49.039000, 9.176000, 'DE', 5, 21, 'Konvoi', '1982-11-09', '1989-04-15', '2023-04-15', 1225, 'WNA/IAEA', '2023-08-28 08:01:45', 119);
INSERT INTO `nuclear_power_plants` VALUES (472, 'Niederaichbach', 48.604000, 12.304000, 'DE', 11, 11, 'pressure tube reactor', '1966-06-01', NULL, '1974-07-31', 100, 'WNA/IAEA', '2022-12-30 02:21:21', 84);
INSERT INTO `nuclear_power_plants` VALUES (473, 'Nine Mile Point-1', 43.522000, -76.412000, 'US', 3, 5, 'BWR-2 (Mark 1)', '1965-04-12', '1969-12-01', NULL, 620, 'WNA/IAEA', '2015-05-24 04:51:41', 607);
INSERT INTO `nuclear_power_plants` VALUES (474, 'Nine Mile Point-2', 43.522000, -76.412000, 'US', 3, 5, 'BWR-5 (Mark 2)', '1975-08-01', '1988-03-11', NULL, 1100, 'WNA/IAEA', '2015-05-24 04:51:48', 711);
INSERT INTO `nuclear_power_plants` VALUES (475, 'Ningde-1', 27.046000, 120.287000, 'CN', 3, 21, 'CPR-1000', '2008-02-18', '2013-04-15', NULL, 1018, 'WNA/IAEA', '2015-05-24 04:51:56', 921);
INSERT INTO `nuclear_power_plants` VALUES (476, 'Ningde-2', 27.046000, 120.287000, 'CN', 3, 21, 'CPR-1000', '2008-11-12', '2014-05-04', NULL, 1018, 'WNA/IAEA', '2015-05-24 04:51:56', 922);
INSERT INTO `nuclear_power_plants` VALUES (477, 'Ningde-3', 27.046000, 120.287000, 'CN', 3, 21, 'CPR-1000', '2010-01-08', '2015-06-10', NULL, 1018, 'WNA/IAEA', '2015-08-23 03:28:29', 923);
INSERT INTO `nuclear_power_plants` VALUES (478, 'Ningde-4', 27.046000, 120.287000, 'CN', 3, 21, 'CPR-1000', '2010-09-29', '2016-07-21', NULL, 1018, 'WNA/IAEA', '2016-10-03 22:05:23', 924);
INSERT INTO `nuclear_power_plants` VALUES (479, 'Ningde-5', 27.046000, 120.287000, 'CN', 1, 21, 'CPR-1000', NULL, NULL, NULL, NULL, 'WNA/Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (480, 'Ningde-6', 27.046000, 120.287000, 'CN', 1, 21, 'CPR-1000', NULL, NULL, NULL, NULL, 'WNA/Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (481, 'Nizhny Novgorod-1', 55.786863, 42.372150, 'RU', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', '2021-06-07 00:00:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (482, 'Nizhny Novgorod-2', 55.787102, 42.372150, 'RU', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', '2021-06-07 00:00:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (483, 'Nogent-1', 48.517000, 3.520000, 'FR', 3, 21, 'P4 REP 1300', '1981-05-26', '1988-02-24', NULL, 1310, 'WNA/IAEA', '2015-05-24 04:51:03', 215);
INSERT INTO `nuclear_power_plants` VALUES (484, 'Nogent-2', 48.517000, 3.520000, 'FR', 3, 21, 'P4 REP 1300', '1982-01-01', '1989-05-01', NULL, 1310, 'WNA/IAEA', '2015-05-24 04:51:03', 216);
INSERT INTO `nuclear_power_plants` VALUES (485, 'North Anna-1', 38.061000, -77.792000, 'US', 3, 21, 'WH 3LP (DRYSUB)', '1971-02-19', '1978-06-06', NULL, 907, 'WNA/IAEA', '2017-02-10 23:58:49', 672);
INSERT INTO `nuclear_power_plants` VALUES (486, 'North Anna-2', 38.061000, -77.792000, 'US', 3, 21, 'WH 3LP (DRYSUB)', '1971-02-19', '1980-12-14', NULL, 907, 'WNA/IAEA', '2017-02-10 23:58:50', 673);
INSERT INTO `nuclear_power_plants` VALUES (487, 'Novovoronezh 2-1', 51.273000, 39.197000, 'RU', 3, 21, 'VVER V-392M', '2008-06-24', '2017-02-27', NULL, 1114, 'WNA/IAEA', '2019-11-22 00:00:00', 898);
INSERT INTO `nuclear_power_plants` VALUES (488, 'Novovoronezh 2-2', 51.273000, 39.197000, 'RU', 3, 21, 'VVER V-392M', '2009-07-12', '2019-10-31', NULL, 1114, 'WNA/IAEA', '2020-04-18 04:46:52', 899);
INSERT INTO `nuclear_power_plants` VALUES (489, 'Novovoronezh-1', 51.275000, 39.206000, 'RU', 5, 21, 'VVER V-210', '1957-07-01', '1964-12-31', '1988-02-16', 197, 'WNA/IAEA', '2018-07-01 01:21:51', 499);
INSERT INTO `nuclear_power_plants` VALUES (490, 'Novovoronezh-2', 51.275000, 39.206000, 'RU', 5, 21, 'VVER V-365', '1964-06-01', '1970-04-14', '1990-08-29', 336, 'WNA/IAEA', '2018-07-01 01:21:53', 513);
INSERT INTO `nuclear_power_plants` VALUES (491, 'Novovoronezh-3', 51.275000, 39.206000, 'RU', 5, 21, 'VVER V-179', '1967-07-01', '1972-06-29', '2016-12-25', 385, 'WNA/IAEA', '2017-02-10 23:57:16', 519);
INSERT INTO `nuclear_power_plants` VALUES (492, 'Novovoronezh-4', 51.275000, 39.206000, 'RU', 3, 21, 'VVER V-179', '1967-07-01', '1973-03-24', NULL, 385, 'WNA/IAEA', '2015-05-24 04:51:32', 448);
INSERT INTO `nuclear_power_plants` VALUES (493, 'Novovoronezh-5', 52.381000, 39.211000, 'RU', 3, 21, 'VVER V-187', '1974-03-01', '1981-02-20', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:34', 483);
INSERT INTO `nuclear_power_plants` VALUES (494, 'Obrigheim', 49.365000, 9.077000, 'DE', 5, 21, NULL, '1965-03-15', '1969-03-31', '2005-05-11', 283, 'WNA/IAEA', '2015-05-24 04:50:46', 121);
INSERT INTO `nuclear_power_plants` VALUES (495, 'Oconee-1', 34.796000, -82.894000, 'US', 3, 21, 'B&W LLP (DRYAMB)', '1967-11-06', '1973-07-15', NULL, 887, 'WNA/IAEA', '2017-02-10 23:58:05', 624);
INSERT INTO `nuclear_power_plants` VALUES (496, 'Oconee-2', 34.796000, -82.894000, 'US', 3, 21, 'B&W LLP (DRYAMB)', '1967-11-06', '1974-09-09', NULL, 887, 'WNA/IAEA', '2017-02-10 23:58:08', 625);
INSERT INTO `nuclear_power_plants` VALUES (497, 'Oconee-3', 34.796000, -82.894000, 'US', 3, 21, 'B&W LLP (DRYAMB)', '1967-11-06', '1974-12-16', NULL, 887, 'WNA/IAEA', '2017-02-10 23:58:18', 636);
INSERT INTO `nuclear_power_plants` VALUES (498, 'Ohi-1', 35.544000, 135.652000, 'JP', 5, 21, 'WH 4LP', '1972-10-26', '1979-03-27', '2018-03-01', 1120, 'WNA/IAEA', '2019-06-02 20:19:15', 339);
INSERT INTO `nuclear_power_plants` VALUES (499, 'Ohi-2', 35.544000, 135.652000, 'JP', 5, 21, 'WH 4LP', '1972-12-08', '1979-12-05', '2018-03-01', 1120, 'WNA/IAEA', '2019-06-02 20:19:18', 343);
INSERT INTO `nuclear_power_plants` VALUES (500, 'Ohi-3', 35.544000, 135.652000, 'JP', 3, 21, 'M (4-loop)', '1987-10-03', '1991-12-18', NULL, 1127, 'WNA/IAEA', '2015-05-24 04:51:30', 378);
INSERT INTO `nuclear_power_plants` VALUES (501, 'Ohi-4', 35.544000, 135.652000, 'JP', 3, 21, 'M (4-loop)', '1988-06-13', '1993-02-02', NULL, 1127, 'WNA/IAEA', '2015-05-24 04:51:30', 379);
INSERT INTO `nuclear_power_plants` VALUES (502, 'Ohma', 41.507000, 140.909000, 'JP', 2, 5, 'ABWR', '2010-05-07', NULL, NULL, 1328, 'WNA/IAEA', '2017-02-10 23:59:23', 867);
INSERT INTO `nuclear_power_plants` VALUES (503, 'Oldbury-A1', 51.649000, -2.567000, 'GB', 5, 8, 'MAGNOX', '1962-05-01', '1967-12-31', '2012-02-29', 300, 'WNA/IAEA', '2015-05-24 04:51:11', 237);
INSERT INTO `nuclear_power_plants` VALUES (504, 'Oldbury-A2', 51.649000, -2.567000, 'GB', 5, 8, 'MAGNOX', '1962-05-01', '1968-09-30', '2011-06-30', 300, 'WNA/IAEA', '2015-05-24 04:51:12', 238);
INSERT INTO `nuclear_power_plants` VALUES (505, 'Olkiluoto-1', 61.235000, 21.444000, 'FI', 3, 5, 'AA-III, BWR-2500', '1974-02-01', '1979-10-10', NULL, 660, 'WNA/IAEA', '2018-03-10 14:51:29', 159);
INSERT INTO `nuclear_power_plants` VALUES (506, 'Olkiluoto-2', 61.235000, 21.444000, 'FI', 3, 5, 'AA-III, BWR-2500', '1975-11-01', '1982-07-10', NULL, 660, 'WNA/IAEA', '2018-03-10 14:51:33', 160);
INSERT INTO `nuclear_power_plants` VALUES (507, 'Olkiluoto-3', 61.234000, 21.435000, 'FI', 3, 21, 'EPR', '2005-08-12', '2023-05-01', NULL, 1600, 'WNA/IAEA', '2024-03-03 20:43:43', 860);
INSERT INTO `nuclear_power_plants` VALUES (508, 'Olkiluoto-4', 61.234352, 21.436287, 'FI', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (509, 'Onagawa-1', 38.400000, 141.504000, 'JP', 5, 5, 'BWR-4', '1980-07-08', '1984-06-01', '2018-12-21', 498, 'WNA/IAEA', '2021-02-14 03:47:53', 347);
INSERT INTO `nuclear_power_plants` VALUES (510, 'Onagawa-2', 38.400000, 141.504000, 'JP', 4, 5, 'BWR-5', '1991-04-12', '1995-07-28', NULL, 796, 'WNA/IAEA', '2023-08-28 08:01:45', 382);
INSERT INTO `nuclear_power_plants` VALUES (511, 'Onagawa-3', 38.400000, 141.504000, 'JP', 4, 5, 'BWR-5', '1998-01-23', '2002-01-30', NULL, 796, 'WNA/IAEA', '2022-12-30 02:21:21', 385);
INSERT INTO `nuclear_power_plants` VALUES (512, 'Oskarshamn-1', 57.415000, 16.666000, 'SE', 5, 5, 'AA-I', '1966-08-01', '1972-02-06', '2017-06-19', 440, 'WNA/IAEA', '2018-03-10 14:51:55', 534);
INSERT INTO `nuclear_power_plants` VALUES (513, 'Oskarshamn-2', 57.415000, 16.666000, 'SE', 5, 5, 'AA-II', '1969-09-01', '1975-01-01', '2016-12-22', 580, 'WNA/IAEA', '2018-03-10 14:51:56', 535);
INSERT INTO `nuclear_power_plants` VALUES (514, 'Oskarshamn-3', 57.415000, 16.666000, 'SE', 3, 5, 'AA-IV, BWR-3000', '1980-05-01', '1985-08-15', NULL, 1050, 'WNA/IAEA', '2018-03-10 14:51:50', 531);
INSERT INTO `nuclear_power_plants` VALUES (515, 'Oyster Creek', 39.815000, -74.208000, 'US', 5, 5, 'BWR-2 (Mark 1)', '1964-12-15', '1969-12-01', '2018-09-17', 650, 'WNA/IAEA', '2018-10-13 22:30:27', 606);
INSERT INTO `nuclear_power_plants` VALUES (516, 'Paks-1', 46.574000, 18.855000, 'HU', 3, 21, 'VVER V-213', '1974-08-01', '1983-08-10', NULL, 408, 'WNA/IAEA', '2015-05-24 04:51:21', 278);
INSERT INTO `nuclear_power_plants` VALUES (517, 'Paks-2', 46.574000, 18.855000, 'HU', 3, 21, 'VVER V-213', '1974-08-01', '1984-11-14', NULL, 410, 'WNA/IAEA', '2015-05-24 04:51:21', 279);
INSERT INTO `nuclear_power_plants` VALUES (518, 'Paks-3', 46.574000, 18.855000, 'HU', 3, 21, 'VVER V-213', '1979-10-01', '1986-12-01', NULL, 410, 'WNA/IAEA', '2015-05-24 04:51:21', 280);
INSERT INTO `nuclear_power_plants` VALUES (519, 'Paks-4', 46.574000, 18.855000, 'HU', 3, 21, 'VVER V-213', '1979-10-01', '1987-11-01', NULL, 410, 'WNA/IAEA', '2015-05-24 04:51:21', 281);
INSERT INTO `nuclear_power_plants` VALUES (520, 'Palisades', 42.323000, -86.316000, 'US', 5, 21, 'CE 2LP (DRYAMB)', '1967-03-12', NULL, '2022-05-20', 805, 'WNA/IAEA', '2022-09-24 22:33:57', 616);
INSERT INTO `nuclear_power_plants` VALUES (521, 'Palo Verde-1', 33.387000, -112.863000, 'US', 3, 21, 'CE80 2LP (DRYAMB)', '1976-05-25', '1986-01-28', NULL, 1221, 'WNA/IAEA', '2017-02-10 23:59:21', 789);
INSERT INTO `nuclear_power_plants` VALUES (522, 'Palo Verde-2', 33.387000, -112.863000, 'US', 3, 21, 'CE80 2LP (DRYAMB)', '1976-06-01', '1986-09-19', NULL, 1304, 'WNA/IAEA', '2017-02-10 23:59:22', 790);
INSERT INTO `nuclear_power_plants` VALUES (523, 'Palo Verde-3', 33.387000, -112.863000, 'US', 3, 21, 'CE80 2LP (DRYAMB)', '1976-06-01', '1988-01-08', NULL, 1304, 'WNA/IAEA', '2017-02-10 23:59:23', 791);
INSERT INTO `nuclear_power_plants` VALUES (524, 'Paluel-1', 49.857000, 0.635000, 'FR', 3, 21, 'P4 REP 1300', '1977-08-15', '1985-12-01', NULL, 1330, 'WNA/IAEA', '2015-05-24 04:50:57', 191);
INSERT INTO `nuclear_power_plants` VALUES (525, 'Paluel-2', 49.857000, 0.635000, 'FR', 3, 21, 'P4 REP 1300', '1978-01-01', '1985-12-01', NULL, 1330, 'WNA/IAEA', '2015-05-24 04:50:57', 192);
INSERT INTO `nuclear_power_plants` VALUES (526, 'Paluel-3', 49.857000, 0.635000, 'FR', 3, 21, 'P4 REP 1300', '1979-02-01', '1986-02-01', NULL, 1330, 'WNA/IAEA', '2015-05-24 04:50:58', 193);
INSERT INTO `nuclear_power_plants` VALUES (527, 'Paluel-4', 49.857000, 0.635000, 'FR', 3, 21, 'P4 REP 1300', '1980-02-01', '1986-06-01', NULL, 1330, 'WNA/IAEA', '2015-05-24 04:50:58', 194);
INSERT INTO `nuclear_power_plants` VALUES (528, 'Pathfinder', 43.603000, -96.636000, 'US', 5, 5, 'Prototype', '1959-01-01', '1966-08-01', '1967-10-01', 59, 'WNA/IAEA', '2017-02-10 23:57:35', 598);
INSERT INTO `nuclear_power_plants` VALUES (529, 'Peach Bottom-1', 39.759000, -76.270000, 'US', 5, 9, NULL, '1962-02-01', '1967-06-01', '1974-11-01', 40, 'WNA/IAEA', '2015-05-24 04:51:41', 603);
INSERT INTO `nuclear_power_plants` VALUES (530, 'Peach Bottom-2', 39.759000, -76.270000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1968-01-31', '1974-07-05', NULL, 1065, 'WNA/IAEA', '2015-05-24 04:51:42', 629);
INSERT INTO `nuclear_power_plants` VALUES (531, 'Peach Bottom-3', 39.759000, -76.270000, 'US', 3, 5, 'BWR-4 (Mark 1)', '1968-01-31', '1974-12-23', NULL, 1065, 'WNA/IAEA', '2015-05-24 04:51:42', 630);
INSERT INTO `nuclear_power_plants` VALUES (532, 'Pengze-1', NULL, NULL, 'CN', 1, 21, 'AP-1000', NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (533, 'Pengze-2', NULL, NULL, 'CN', 1, 21, 'AP-1000', NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (534, 'Penly-1', 49.975000, 1.215000, 'FR', 3, 21, 'P4 REP 1300', '1982-09-01', '1990-12-01', NULL, 1330, 'WNA/IAEA', '2015-05-24 04:51:05', 221);
INSERT INTO `nuclear_power_plants` VALUES (535, 'Penly-2', 49.975000, 1.215000, 'FR', 3, 21, 'P4 REP 1300', '1984-08-01', '1992-11-01', NULL, 1330, 'WNA/IAEA', '2015-05-24 04:51:05', 222);
INSERT INTO `nuclear_power_plants` VALUES (536, 'Penly-3', 49.977611, 1.214090, 'FR', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (537, 'Perry-1', 41.801000, -81.147000, 'US', 3, 5, 'BWR-6 (Mark 3)', '1974-10-01', '1987-11-18', NULL, 1205, 'WNA/IAEA', '2015-05-24 04:51:49', 725);
INSERT INTO `nuclear_power_plants` VALUES (538, 'Phenix', 44.142000, 4.712000, 'FR', 5, 7, 'PH-250', '1968-11-01', '1974-07-14', '2010-02-01', 233, 'WNA/IAEA', '2015-05-24 04:50:50', 162);
INSERT INTO `nuclear_power_plants` VALUES (539, 'Philippsburg-1', 49.253000, 8.432000, 'DE', 5, 5, 'BWR-69', '1970-10-01', '1980-03-26', '2011-08-06', 864, 'WNA/IAEA', '2015-05-24 04:50:42', 87);
INSERT INTO `nuclear_power_plants` VALUES (540, 'Philippsburg-2', 49.253000, 8.432000, 'DE', 5, 21, 'PWR', '1977-07-07', '1985-04-18', '2019-12-31', 1268, 'WNA/IAEA', '2020-04-18 04:46:52', 98);
INSERT INTO `nuclear_power_plants` VALUES (541, 'Pickering-1', 43.812000, -79.070000, 'CA', 3, 20, 'CANDU 500A', '1966-06-01', '1971-07-29', NULL, 508, 'WNA/IAEA', '2015-05-24 04:50:33', 49);
INSERT INTO `nuclear_power_plants` VALUES (542, 'Pickering-2', 43.812000, -79.070000, 'CA', 5, 20, 'CANDU 500A', '1966-09-01', '1971-12-30', '2007-05-28', 508, 'WNA/IAEA', '2015-05-24 04:50:36', 50);
INSERT INTO `nuclear_power_plants` VALUES (543, 'Pickering-3', 43.812000, -79.070000, 'CA', 5, 20, 'CANDU 500A', '1967-12-01', '1972-06-01', '2008-10-31', 508, 'WNA/IAEA', '2015-05-24 04:50:36', 51);
INSERT INTO `nuclear_power_plants` VALUES (544, 'Pickering-4', 43.812000, -79.070000, 'CA', 3, 20, 'CANDU 500A', '1968-05-01', '1973-06-17', NULL, 508, 'WNA/IAEA', '2015-05-24 04:50:37', 52);
INSERT INTO `nuclear_power_plants` VALUES (545, 'Pickering-5', 43.812000, -79.070000, 'CA', 3, 20, 'CANDU 500B', '1974-11-01', '1983-05-10', NULL, 516, 'WNA/IAEA', '2015-05-24 04:50:22', 33);
INSERT INTO `nuclear_power_plants` VALUES (546, 'Pickering-6', 43.812000, -79.070000, 'CA', 3, 20, 'CANDU 500B', '1975-10-01', '1984-02-01', NULL, 516, 'WNA/IAEA', '2015-05-24 04:50:22', 34);
INSERT INTO `nuclear_power_plants` VALUES (547, 'Pickering-7', 43.812000, -79.070000, 'CA', 3, 20, 'CANDU 500B', '1976-03-01', '1985-01-01', NULL, 516, 'WNA/IAEA', '2015-05-24 04:50:23', 35);
INSERT INTO `nuclear_power_plants` VALUES (548, 'Pickering-8', 43.812000, -79.070000, 'CA', 3, 20, 'CANDU 500B', '1976-09-01', '1986-02-28', NULL, 516, 'WNA/IAEA', '2015-05-24 04:50:23', 36);
INSERT INTO `nuclear_power_plants` VALUES (549, 'Pilgrim-1', 41.945000, -70.578000, 'US', 5, 5, 'BWR-3 (Mark 1)', '1968-08-26', '1972-12-01', '2019-05-31', 655, 'WNA/IAEA', '2019-11-22 00:00:00', 639);
INSERT INTO `nuclear_power_plants` VALUES (550, 'Piqua', 40.132222, -84.234722, 'US', 5, 19, 'OCM (Organically Cooled and Moderated Reactor)', '1960-01-01', '1963-11-01', '1966-01-01', 11, 'IAEA', '2015-05-24 04:54:13', 894);
INSERT INTO `nuclear_power_plants` VALUES (551, 'Point Beach-1', 44.282000, -87.534000, 'US', 3, 21, 'WH 2LP (DRYAMB)', '1967-07-19', '1970-12-21', NULL, 497, 'WNA/IAEA', '2017-02-10 23:58:03', 622);
INSERT INTO `nuclear_power_plants` VALUES (552, 'Point Beach-2', 44.282000, -87.534000, 'US', 3, 21, 'WH 2LP (DRYAMB)', '1968-07-25', '1972-10-01', NULL, 497, 'WNA/IAEA', '2017-02-10 23:58:22', 644);
INSERT INTO `nuclear_power_plants` VALUES (553, 'Point Lepreau', 45.068000, -66.455000, 'CA', 3, 20, 'CANDU 6', '1975-05-01', '1983-02-01', NULL, 660, 'WNA/IAEA', '2015-05-24 04:50:23', 37);
INSERT INTO `nuclear_power_plants` VALUES (554, 'Point Lepreau 2', 45.068000, -66.454600, 'CA', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (555, 'Prairie Island-1', 44.622000, -92.631000, 'US', 3, 21, 'WH 2LP (DRYAMB)', '1968-06-25', '1973-12-16', NULL, 530, 'WNA/IAEA', '2017-02-10 23:58:12', 633);
INSERT INTO `nuclear_power_plants` VALUES (556, 'Prairie Island-2', 44.622000, -92.631000, 'US', 3, 21, 'WH 2LP (DRYAMB)', '1969-06-25', '1974-12-21', NULL, 530, 'WNA/IAEA', '2017-02-10 23:58:28', 648);
INSERT INTO `nuclear_power_plants` VALUES (557, 'Qinshan-1', 30.440000, 120.950000, 'CN', 3, 21, 'CNP-300', '1985-03-20', '1994-04-01', NULL, 289, 'WNA/IAEA', '2023-08-28 08:01:45', 62);
INSERT INTO `nuclear_power_plants` VALUES (558, 'Qinshan-2-1 (Qinshan 2)', 30.440000, 120.950000, 'CN', 3, 21, 'CNP-600', '1996-06-02', '2002-04-15', NULL, 610, 'WNA/IAEA', '2015-05-24 04:50:40', 65);
INSERT INTO `nuclear_power_plants` VALUES (559, 'Qinshan-2-2 (Qinshan 3)', 30.440000, 120.950000, 'CN', 3, 21, 'CNP-600', '1997-04-01', '2004-05-03', NULL, 610, 'WNA/IAEA', '2015-05-24 04:50:40', 66);
INSERT INTO `nuclear_power_plants` VALUES (560, 'Qinshan-2-3 (Qinshan 4)', 30.440000, 120.950000, 'CN', 3, 21, 'CNP-600', '2006-04-28', '2010-10-05', NULL, 619, 'WNA/IAEA', '2015-05-24 04:51:51', 876);
INSERT INTO `nuclear_power_plants` VALUES (561, 'Qinshan-2-4 (Qinshan 5)', 30.440000, 120.950000, 'CN', 3, 21, 'CNP-600', '2007-01-28', '2011-12-30', NULL, 619, 'WNA/IAEA', '2015-05-24 04:51:51', 877);
INSERT INTO `nuclear_power_plants` VALUES (562, 'Qinshan-3-1 (Qinshan 6)', 30.440000, 120.950000, 'CN', 3, 20, 'CANDU 6', '1998-06-08', '2002-12-31', NULL, 677, 'WNA/IAEA', '2015-05-24 04:50:40', 69);
INSERT INTO `nuclear_power_plants` VALUES (563, 'Qinshan-3-2 (Qinshan 7)', 30.440000, 120.950000, 'CN', 3, 20, 'CANDU 6', '1998-09-25', '2003-07-24', NULL, 677, 'WNA/IAEA', '2015-05-24 04:51:50', 840);
INSERT INTO `nuclear_power_plants` VALUES (564, 'Quad Cities-1', 41.727000, -90.308000, 'US', 3, 5, 'BWR-3 (Mark 1)', '1967-02-15', '1973-02-18', NULL, 789, 'WNA/IAEA', '2015-05-24 04:51:41', 615);
INSERT INTO `nuclear_power_plants` VALUES (565, 'Quad Cities-2', 41.727000, -90.308000, 'US', 3, 5, 'BWR-3 (Mark 1)', '1967-02-15', '1973-03-10', NULL, 789, 'WNA/IAEA', '2015-05-24 04:51:42', 621);
INSERT INTO `nuclear_power_plants` VALUES (566, 'R. E. Ginna', 43.279000, -77.311000, 'US', 3, 21, 'WH 2LP (DRYAMB)', '1966-04-25', '1970-07-01', NULL, 470, 'WNA/IAEA', '2017-02-10 23:57:51', 609);
INSERT INTO `nuclear_power_plants` VALUES (567, 'Rajasthan-1', 24.876000, 75.608000, 'IN', 4, 20, 'Horizontal Pressure Tube type', '1965-08-01', '1973-12-16', NULL, 207, 'WNA/IAEA', '2022-09-24 22:33:57', 302);
INSERT INTO `nuclear_power_plants` VALUES (568, 'Rajasthan-2', 24.876000, 75.608000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '1968-04-01', '1981-04-01', NULL, 207, 'WNA/IAEA', '2015-05-24 04:54:06', 303);
INSERT INTO `nuclear_power_plants` VALUES (569, 'Rajasthan-3', 24.876000, 75.608000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '1990-02-01', '2000-06-01', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:05', 287);
INSERT INTO `nuclear_power_plants` VALUES (570, 'Rajasthan-4', 24.876000, 75.608000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '1990-10-01', '2000-12-23', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:05', 288);
INSERT INTO `nuclear_power_plants` VALUES (571, 'Rajasthan-5', 24.876000, 75.608000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '2002-09-18', '2010-02-04', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:06', 295);
INSERT INTO `nuclear_power_plants` VALUES (572, 'Rajasthan-6', 24.876000, 75.608000, 'IN', 3, 20, 'Horizontal Pressure Tube type', '2003-01-20', '2010-03-31', NULL, 202, 'WNA/IAEA', '2015-05-24 04:54:06', 297);
INSERT INTO `nuclear_power_plants` VALUES (573, 'Rajasthan-7', 24.876000, 75.608000, 'IN', 2, 20, 'Horizontal Pressure Tube type', '2011-07-18', NULL, NULL, 630, 'WNA/IAEA', '2015-05-24 04:54:06', 298);
INSERT INTO `nuclear_power_plants` VALUES (574, 'Rajasthan-8', 24.876000, 75.608000, 'IN', 2, 20, 'Horizontal Pressure Tube type', '2011-09-30', NULL, NULL, 630, 'WNA/IAEA', '2015-05-24 04:54:06', 299);
INSERT INTO `nuclear_power_plants` VALUES (575, 'Rancho Seco-1', 38.345000, -121.120000, 'US', 5, 21, 'PWR', '1969-04-01', '1975-04-17', '1989-06-07', 918, 'WNA/IAEA', '2022-04-21 20:26:19', 651);
INSERT INTO `nuclear_power_plants` VALUES (576, 'Rheinsberg', 53.147000, 12.991000, 'DE', 5, 21, 'VVER-70', '1960-01-01', '1966-10-11', '1990-06-01', 62, 'WNA/IAEA', '2015-05-24 04:50:47', 122);
INSERT INTO `nuclear_power_plants` VALUES (577, 'Ringhals-1', 57.259000, 12.111000, 'SE', 5, 5, 'AA-I', '1969-02-01', '1976-01-01', '2020-12-31', 881, 'WNA/IAEA', '2021-02-14 03:47:53', 536);
INSERT INTO `nuclear_power_plants` VALUES (578, 'Ringhals-2', 57.259000, 12.111000, 'SE', 5, 21, 'WH 3LP', '1970-10-01', '1975-05-01', '2019-12-31', 820, 'WNA/IAEA', '2020-04-18 04:46:52', 537);
INSERT INTO `nuclear_power_plants` VALUES (579, 'Ringhals-3', 57.259000, 12.111000, 'SE', 3, 21, 'WH 3LP', '1972-09-01', '1981-09-09', NULL, 915, 'WNA/IAEA', '2023-08-28 08:01:45', 539);
INSERT INTO `nuclear_power_plants` VALUES (580, 'Ringhals-4', 57.259000, 12.111000, 'SE', 3, 21, 'WH 3LP', '1973-11-01', '1983-11-21', NULL, 1130, 'WNA/IAEA', '2021-04-20 02:47:37', 529);
INSERT INTO `nuclear_power_plants` VALUES (581, 'River Bend-1', 30.727000, -91.372000, 'US', 3, 5, 'BWR-6 (Mark 3)', '1977-03-25', '1986-06-16', NULL, 966, 'WNA/IAEA', '2015-05-24 04:51:49', 739);
INSERT INTO `nuclear_power_plants` VALUES (582, 'Rolphton NPD', 46.201000, -77.705000, 'CA', 5, 20, 'CANDU', '1958-01-01', '1962-10-01', '1987-08-01', 17, 'WNA/IAEA', '2015-05-24 04:50:20', 29);
INSERT INTO `nuclear_power_plants` VALUES (583, 'Rostov-1 (Volgodonsk-1)', 47.599000, 42.373000, 'RU', 3, 21, 'VVER V-320', '1981-09-01', '2001-12-25', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:35', 502);
INSERT INTO `nuclear_power_plants` VALUES (584, 'Rostov-2 (Volgodonsk-2)', 47.599000, 42.373000, 'RU', 3, 21, 'VVER V-320', '1983-05-01', '2010-12-10', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:35', 505);
INSERT INTO `nuclear_power_plants` VALUES (585, 'Rostov-3 (Volgodonsk-3)', 47.599000, 42.373000, 'RU', 3, 21, 'VVER V-320', '2009-09-15', '2015-09-17', NULL, 950, 'WNA/IAEA', '2017-02-10 23:57:13', 506);
INSERT INTO `nuclear_power_plants` VALUES (586, 'Rostov-4 (Volgodonsk-4)', 47.599000, 42.373000, 'RU', 3, 21, 'VVER V-320', '2010-06-16', '2018-09-28', NULL, 950, 'WNA/IAEA', '2019-06-02 20:19:20', 507);
INSERT INTO `nuclear_power_plants` VALUES (587, 'Rivne-1', 51.326000, 25.900000, 'UA', 3, 21, 'VVER V-213', '1973-08-01', '1981-09-22', NULL, 361, 'WNA/IAEA', '2023-08-28 08:51:40', 570);
INSERT INTO `nuclear_power_plants` VALUES (588, 'Rivne-2', 51.326000, 25.900000, 'UA', 3, 21, 'VVER V-213', '1973-10-01', '1982-07-29', NULL, 384, 'WNA/IAEA', '2023-08-28 08:51:40', 571);
INSERT INTO `nuclear_power_plants` VALUES (589, 'Rivne-3', 51.326000, 25.900000, 'UA', 3, 21, 'VVER V-320', '1980-02-01', '1987-05-16', NULL, 950, 'WNA/IAEA', '2023-08-28 08:51:40', 572);
INSERT INTO `nuclear_power_plants` VALUES (590, 'Rivne-4', 51.326000, 25.900000, 'UA', 3, 21, 'VVER V-320', '1986-08-01', '2006-04-06', NULL, 950, 'WNA/IAEA', '2023-08-28 08:51:40', 589);
INSERT INTO `nuclear_power_plants` VALUES (591, 'Salem-1', 39.463000, -75.534000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1968-09-25', '1977-06-30', NULL, 1090, 'WNA/IAEA', '2017-02-10 23:58:08', 627);
INSERT INTO `nuclear_power_plants` VALUES (592, 'Salem-2', 39.463000, -75.534000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1968-09-25', '1981-10-13', NULL, 1115, 'WNA/IAEA', '2017-02-10 23:58:29', 650);
INSERT INTO `nuclear_power_plants` VALUES (593, 'San Onofre-1', 33.368000, -117.556000, 'US', 5, 21, 'PWR', '1964-05-01', '1968-01-01', '1992-11-30', 436, 'WNA/IAEA', '2022-04-21 20:26:19', 604);
INSERT INTO `nuclear_power_plants` VALUES (594, 'San Onofre-2', 33.368000, -117.556000, 'US', 5, 21, 'CE (2-loop) DRYAMB', '1974-03-01', '1983-08-08', '2013-06-07', 1070, 'WNA/IAEA', '2015-05-24 04:54:11', 683);
INSERT INTO `nuclear_power_plants` VALUES (595, 'San Onofre-3', 33.368000, -117.556000, 'US', 5, 21, 'CE (2-loop) DRYAMB', '1974-03-01', '1984-04-01', '2013-06-07', 1070, 'WNA/IAEA', '2015-05-24 04:54:11', 684);
INSERT INTO `nuclear_power_plants` VALUES (596, 'Sanmen-1', 29.101000, 121.642000, 'CN', 3, 21, 'AP-1000', '2009-04-19', '2018-09-21', NULL, 1157, 'WNA/IAEA', '2018-10-13 22:30:42', 879);
INSERT INTO `nuclear_power_plants` VALUES (597, 'Sanmen-2', 29.101000, 121.642000, 'CN', 3, 21, 'AP-1000', '2009-12-15', '2018-11-05', NULL, 1157, 'WNA/IAEA', '2019-06-02 20:19:24', 880);
INSERT INTO `nuclear_power_plants` VALUES (598, 'Sanmen-3', 29.101111, 121.651944, 'CN', 2, 21, 'CAP1000', '2022-06-28', NULL, NULL, 1163, 'WNA/IAEA', '2022-09-24 22:33:57', 995);
INSERT INTO `nuclear_power_plants` VALUES (599, 'Sanmen-4', 29.101111, 121.656944, 'CN', 2, 21, 'CAP1000', '2023-03-22', NULL, NULL, 1163, 'WNA/IAEA', '2023-08-28 08:01:45', 996);
INSERT INTO `nuclear_power_plants` VALUES (600, 'Sanming-1', NULL, NULL, 'CN', 1, 7, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (601, 'Sanming-2', NULL, NULL, 'CN', 1, 7, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (602, 'Santa Maria de Garona', 42.775000, -3.205000, 'ES', 5, 5, 'BWR-3', '1966-09-01', '1971-05-11', '2017-08-02', 440, 'WNA/IAEA', '2017-09-25 03:19:35', 149);
INSERT INTO `nuclear_power_plants` VALUES (603, 'Saxton', 40.226944, -78.241944, 'US', 5, 21, '25', '1960-01-01', NULL, '1972-05-01', 3, 'IAEA', '2022-04-21 20:26:19', 892);
INSERT INTO `nuclear_power_plants` VALUES (604, 'Seabrook-1', 42.897000, -70.849000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1976-07-07', '1990-08-19', NULL, 1149, 'WNA/IAEA', '2017-02-10 23:59:16', 727);
INSERT INTO `nuclear_power_plants` VALUES (605, 'Sendai-1', 31.834000, 130.193000, 'JP', 3, 21, 'M (3-loop)', '1979-12-15', '1984-07-04', NULL, 846, 'WNA/IAEA', '2015-05-24 04:51:28', 353);
INSERT INTO `nuclear_power_plants` VALUES (606, 'Sendai-2', 31.834000, 130.193000, 'JP', 3, 21, 'M (3-loop)', '1981-10-12', '1985-11-28', NULL, 846, 'WNA/IAEA', '2015-05-24 04:51:29', 363);
INSERT INTO `nuclear_power_plants` VALUES (607, 'Sendai-3', NULL, NULL, 'JP', 1, 3, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (608, 'Sequoyah-1', 35.228000, -85.094000, 'US', 3, 21, 'WH 4LP (ICECND)', '1970-05-27', '1981-07-01', NULL, 1148, 'WNA/IAEA', '2017-02-10 23:58:40', 663);
INSERT INTO `nuclear_power_plants` VALUES (609, 'Sequoyah-2', 35.228000, -85.094000, 'US', 3, 21, 'WH 4LP (ICECND)', '1970-05-27', '1982-06-01', NULL, 1148, 'WNA/IAEA', '2017-02-10 23:58:43', 664);
INSERT INTO `nuclear_power_plants` VALUES (610, 'Shanwei-1', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (611, 'Shaoguan-1', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (612, 'Shaoguan-2', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (613, 'Shaoguan-3', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (614, 'Shaoguan-4', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (615, 'Shearon Harris-1', 35.635000, -78.955000, 'US', 3, 21, 'WH 3LP (DRYAMB)', '1978-01-28', '1987-05-02', NULL, 900, 'WNA/IAEA', '2017-02-10 23:58:59', 704);
INSERT INTO `nuclear_power_plants` VALUES (616, 'Shidao Bay-1', 36.979167, 122.530556, 'CN', 3, 9, 'HTR-PM', '2012-12-09', '2023-12-06', NULL, 200, 'IAEA/wikipedia', '2024-03-03 20:43:43', 957);
INSERT INTO `nuclear_power_plants` VALUES (617, 'Shika-1', 37.061000, 136.728000, 'JP', 4, 5, 'BWR-5', '1989-07-01', '1993-07-30', NULL, 505, 'WNA/IAEA', '2022-12-30 02:24:37', 375);
INSERT INTO `nuclear_power_plants` VALUES (618, 'Shika-2', 37.061000, 136.728000, 'JP', 4, 5, 'ABWR', '2001-08-20', '2006-03-15', NULL, 1304, 'WNA/IAEA', '2022-12-30 02:24:37', 842);
INSERT INTO `nuclear_power_plants` VALUES (619, 'Shimane-1', 35.537000, 132.999000, 'JP', 5, 5, 'BWR-3', '1970-07-02', '1974-03-29', '2015-04-30', 439, 'WNA/IAEA', '2015-05-24 04:51:30', 387);
INSERT INTO `nuclear_power_plants` VALUES (620, 'Shimane-2', 35.537000, 132.999000, 'JP', 4, 5, 'BWR-5', '1985-02-02', '1989-02-10', NULL, 789, 'WNA/IAEA', '2023-08-28 08:01:45', 368);
INSERT INTO `nuclear_power_plants` VALUES (621, 'Shimane-3', 35.537000, 132.999000, 'JP', 2, 5, 'ABWR', '2006-10-24', NULL, NULL, 1325, 'WNA/IAEA', '2021-02-14 03:47:53', 862);
INSERT INTO `nuclear_power_plants` VALUES (622, 'Shin-Wolsong-1', 35.722000, 129.479000, 'KR', 3, 21, 'OPR-1000', '2007-11-20', '2012-07-31', NULL, 950, 'WNA/IAEA', '2022-04-21 20:26:19', 883);
INSERT INTO `nuclear_power_plants` VALUES (623, 'Shin-Wolsong-2', 35.722000, 129.479000, 'KR', 3, 21, 'OPR-1000', '2008-09-23', '2015-07-24', NULL, 950, 'WNA/IAEA', '2022-04-21 20:26:19', 884);
INSERT INTO `nuclear_power_plants` VALUES (624, 'Shin-Hanul-1', 37.083889, 129.391667, 'KR', 3, 21, 'APR-1400', '2012-07-10', '2022-12-07', NULL, 1340, 'IAEA', '2022-12-30 00:57:40', 887);
INSERT INTO `nuclear_power_plants` VALUES (625, 'Shin-Hanul-2', 37.083889, 129.391667, 'KR', 3, 21, 'APR-1400', '2013-06-19', NULL, NULL, 1340, 'IAEA', '2024-03-03 20:43:43', 888);
INSERT INTO `nuclear_power_plants` VALUES (626, 'Shin-Kori-1', 35.327000, 129.302000, 'KR', 3, 21, 'OPR-1000', '2006-06-16', '2011-02-28', NULL, 998, 'WNA/IAEA', '2022-04-21 20:26:19', 864);
INSERT INTO `nuclear_power_plants` VALUES (627, 'Shin-Kori-2', 35.327000, 129.302000, 'KR', 3, 21, 'OPR-1000', '2007-06-05', '2012-07-20', NULL, 995, 'WNA/IAEA', '2022-04-21 20:26:19', 865);
INSERT INTO `nuclear_power_plants` VALUES (628, 'Saeul-1', 35.327000, 129.302000, 'KR', 3, 21, 'APR-1400', '2008-10-16', '2016-12-20', NULL, 1340, 'WNA/IAEA', '2022-12-30 01:45:43', 885);
INSERT INTO `nuclear_power_plants` VALUES (629, 'Saeul-2', 35.327000, 129.302000, 'KR', 3, 21, 'APR-1400', '2009-08-19', '2019-08-29', NULL, 1340, 'WNA/IAEA', '2022-12-30 01:45:43', 886);
INSERT INTO `nuclear_power_plants` VALUES (630, 'Saeul-3', 35.327000, 129.302000, 'KR', 2, 21, 'APR-1400', '2017-04-01', NULL, NULL, 1340, 'WNA/Wikipedia/IAEA', '2022-12-30 01:45:43', 1074);
INSERT INTO `nuclear_power_plants` VALUES (631, 'Saeul-4', 35.327000, 129.302000, 'KR', 2, 21, 'APR-1400', '2018-09-20', NULL, NULL, 1340, 'WNA/Wikipedia/IAEA', '2022-12-30 01:45:43', 1075);
INSERT INTO `nuclear_power_plants` VALUES (632, 'Shippingport', 40.630000, -80.417778, 'US', 5, 21, 'PLWBR', '1954-01-01', '1958-05-26', '1982-10-01', 60, 'IAEA', '2015-05-24 04:51:54', 890);
INSERT INTO `nuclear_power_plants` VALUES (633, 'Shoreham', 40.960000, -72.866000, 'US', 5, 5, 'BWR', '1972-11-01', NULL, '1989-06-28', 809, 'WNA/IAEA', '2022-04-21 20:26:19', 659);
INSERT INTO `nuclear_power_plants` VALUES (634, 'Sinop-1', 42.000000, 35.000000, 'TR', 1, 21, 'ATMEA-1', NULL, NULL, NULL, NULL, 'Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (635, 'Sinop-2', 42.000000, 35.000000, 'TR', 1, 21, 'ATMEA-1', NULL, NULL, NULL, NULL, 'Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (636, 'Sinop-3', 42.000000, 35.000000, 'TR', 1, 21, 'ATMEA-1', NULL, NULL, NULL, NULL, 'Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (637, 'Sinop-4', 42.000000, 35.000000, 'TR', 1, 21, 'ATMEA-1', NULL, NULL, NULL, NULL, 'Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (638, 'Sizewell-A1', 52.212000, 1.621000, 'GB', 5, 8, 'MAGNOX', '1961-04-01', '1966-03-25', '2006-12-31', 290, 'WNA/IAEA', '2015-05-24 04:51:10', 235);
INSERT INTO `nuclear_power_plants` VALUES (639, 'Sizewell-A2', 52.212000, 1.621000, 'GB', 5, 8, 'MAGNOX', '1961-04-01', '1966-09-15', '2006-12-31', 290, 'WNA/IAEA', '2015-05-24 04:51:11', 236);
INSERT INTO `nuclear_power_plants` VALUES (640, 'Sizewell-B', 52.212000, 1.621000, 'GB', 3, 21, 'SNUPPS', '1988-07-18', '1995-09-22', NULL, 1188, 'WNA/IAEA', '2015-05-24 04:51:18', 263);
INSERT INTO `nuclear_power_plants` VALUES (641, 'Sizewell-C1', 52.219390, 1.622800, 'GB', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (642, 'Sizewell-C2', 52.219390, 1.623800, 'GB', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (643, 'Smolensk-1', 54.169000, 33.245000, 'RU', 3, 17, 'RBMK-1000', '1975-10-01', '1983-09-30', NULL, 925, 'WNA/IAEA', '2015-05-24 04:51:34', 486);
INSERT INTO `nuclear_power_plants` VALUES (644, 'Smolensk-2', 54.169000, 33.245000, 'RU', 3, 17, 'RBMK-1000', '1976-06-01', '1985-07-02', NULL, 925, 'WNA/IAEA', '2015-05-24 04:51:34', 487);
INSERT INTO `nuclear_power_plants` VALUES (645, 'Smolensk-3', 54.169000, 33.245000, 'RU', 3, 17, 'RBMK-1000', '1984-05-01', '1990-10-12', NULL, 925, 'WNA/IAEA', '2015-05-24 04:51:36', 508);
INSERT INTO `nuclear_power_plants` VALUES (647, 'South Texas-1', 28.797000, -96.044000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1975-12-22', '1988-08-25', NULL, 1250, 'WNA/IAEA', '2017-02-10 23:59:20', 764);
INSERT INTO `nuclear_power_plants` VALUES (648, 'South Texas-2', 28.796000, -96.044000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1975-12-22', '1989-06-19', NULL, 1250, 'WNA/IAEA', '2017-02-10 23:59:21', 765);
INSERT INTO `nuclear_power_plants` VALUES (649, 'South Ukraine-1', 47.811000, 31.220000, 'UA', 3, 21, 'VVER V-302', '1976-08-01', '1983-12-02', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:40', 577);
INSERT INTO `nuclear_power_plants` VALUES (650, 'South Ukraine-2', 47.811000, 31.220000, 'UA', 3, 21, 'VVER V-338', '1981-07-01', '1985-04-06', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:40', 578);
INSERT INTO `nuclear_power_plants` VALUES (651, 'South Ukraine-3', 47.811000, 31.220000, 'UA', 3, 21, 'VVER V-320', '1984-11-01', '1989-12-29', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:40', 579);
INSERT INTO `nuclear_power_plants` VALUES (652, 'St. Alban-1', 45.404000, 4.754000, 'FR', 3, 21, 'P4 REP 1300', '1979-01-29', '1986-05-01', NULL, 1335, 'WNA/IAEA', '2015-05-24 04:51:00', 204);
INSERT INTO `nuclear_power_plants` VALUES (653, 'St. Alban-2', 45.404000, 4.754000, 'FR', 3, 21, 'P4 REP 1300', '1979-07-31', '1987-03-01', NULL, 1335, 'WNA/IAEA', '2015-05-24 04:51:01', 205);
INSERT INTO `nuclear_power_plants` VALUES (654, 'St. Laurent-A1', 47.724000, 1.582000, 'FR', 5, 8, 'UNGG', '1963-10-01', '1969-06-01', '1990-04-18', 480, 'WNA/IAEA', '2015-05-24 04:51:06', 225);
INSERT INTO `nuclear_power_plants` VALUES (655, 'St. Laurent-A2', 47.724000, 1.582000, 'FR', 5, 8, 'UNGG', '1966-01-01', '1971-11-01', '1992-05-27', 515, 'WNA/IAEA', '2015-05-24 04:51:07', 229);
INSERT INTO `nuclear_power_plants` VALUES (656, 'St. Laurent-B1', 47.724000, 1.582000, 'FR', 3, 21, 'CP2', '1976-05-01', '1983-08-01', NULL, 915, 'WNA/IAEA', '2015-05-24 04:50:51', 169);
INSERT INTO `nuclear_power_plants` VALUES (657, 'St. Laurent-B2', 47.720000, 1.581000, 'FR', 3, 21, 'CP2', '1976-07-01', '1983-08-01', NULL, 880, 'WNA/IAEA', '2015-05-24 04:50:53', 177);
INSERT INTO `nuclear_power_plants` VALUES (658, 'St. Lucie-1', 27.348000, -80.244000, 'US', 3, 21, 'CE 2LP (DRYAMB)', '1970-07-01', '1976-12-21', NULL, 830, 'WNA/IAEA', '2017-02-10 23:58:47', 670);
INSERT INTO `nuclear_power_plants` VALUES (659, 'St. Lucie-2', 27.348000, -80.244000, 'US', 3, 21, 'CE 2LP (DRYAMB)', '1977-06-02', '1983-08-08', NULL, 830, 'WNA/IAEA', '2017-02-10 23:58:56', 698);
INSERT INTO `nuclear_power_plants` VALUES (660, 'Stade', 53.620000, 9.530000, 'DE', 5, 21, NULL, '1967-12-01', '1972-05-19', '2003-11-14', 630, 'WNA/IAEA', '2015-05-24 04:50:42', 83);
INSERT INTO `nuclear_power_plants` VALUES (661, 'Summer-1', 34.299000, -81.314000, 'US', 3, 21, 'WH 3LP (DRYAMB)', '1973-03-21', '1984-01-01', NULL, 900, 'WNA/IAEA', '2017-02-10 23:58:58', 701);
INSERT INTO `nuclear_power_plants` VALUES (662, 'Summer-2', 34.295833, -81.320278, 'US', 8, 21, 'AP-1000', '2013-03-09', NULL, NULL, 1117, 'IAEA', '2018-03-10 14:56:12', 1038);
INSERT INTO `nuclear_power_plants` VALUES (663, 'Summer-3', 34.295833, -81.320278, 'US', 8, 21, 'AP-1000', '2013-11-02', NULL, NULL, 1117, 'IAEA', '2018-03-10 14:56:13', 1039);
INSERT INTO `nuclear_power_plants` VALUES (664, 'Super-Phenix', 45.760000, 5.474000, 'FR', 5, 7, 'Na-1200', '1976-12-13', '1986-12-01', '1998-12-31', 1200, 'WNA/IAEA', '2015-05-24 04:50:53', 178);
INSERT INTO `nuclear_power_plants` VALUES (665, 'Surry-1', 37.166000, -76.700000, 'US', 3, 21, 'WH 3LP (DRYSUB)', '1968-06-25', '1972-12-22', NULL, 788, 'WNA/IAEA', '2017-02-10 23:58:10', 631);
INSERT INTO `nuclear_power_plants` VALUES (666, 'Surry-2', 37.166000, -76.700000, 'US', 3, 21, 'WH 3LP (DRYSUB)', '1968-06-25', '1973-05-01', NULL, 788, 'WNA/IAEA', '2017-02-10 23:58:11', 632);
INSERT INTO `nuclear_power_plants` VALUES (667, 'Susquehanna-1', 41.093000, -76.143000, 'US', 3, 5, 'BWR-4 (Mark 2)', '1973-11-02', '1983-06-08', NULL, 1065, 'WNA/IAEA', '2015-05-24 04:51:48', 696);
INSERT INTO `nuclear_power_plants` VALUES (668, 'Susquehanna-2', 41.093000, -76.143000, 'US', 3, 5, 'BWR-4 (Mark 2)', '1973-11-02', '1985-02-12', NULL, 1065, 'WNA/IAEA', '2015-05-24 04:51:48', 697);
INSERT INTO `nuclear_power_plants` VALUES (669, 'Taishan-1', 21.917778, 112.981944, 'CN', 3, 21, 'EPR-1750', '2009-11-18', '2018-12-13', NULL, 1660, 'WNA/IAEA/Wikipedia', '2021-01-09 20:00:00', 918);
INSERT INTO `nuclear_power_plants` VALUES (670, 'Taishan-2', 21.917778, 112.981944, 'CN', 3, 21, 'EPR-1750', '2010-04-15', '2019-09-07', NULL, 1660, 'WNA/IAEA/Wikipedia', '2022-09-24 22:33:57', 919);
INSERT INTO `nuclear_power_plants` VALUES (671, 'Takahama-1', 35.520000, 135.503000, 'JP', 3, 21, 'M (3-loop)', '1970-04-25', '1974-11-14', NULL, 780, 'WNA/IAEA', '2024-03-03 20:43:43', 388);
INSERT INTO `nuclear_power_plants` VALUES (672, 'Takahama-2', 35.520000, 135.503000, 'JP', 3, 21, 'M (3-loop)', '1971-03-09', '1975-11-14', NULL, 780, 'WNA/IAEA', '2024-03-03 20:43:43', 337);
INSERT INTO `nuclear_power_plants` VALUES (673, 'Takahama-3', 35.520000, 135.503000, 'JP', 3, 21, 'M (3-loop)', '1980-12-12', '1985-01-17', NULL, 830, 'WNA/IAEA', '2015-05-24 04:51:28', 354);
INSERT INTO `nuclear_power_plants` VALUES (674, 'Takahama-4', 35.520000, 135.503000, 'JP', 3, 21, 'M (3-loop)', '1981-03-19', '1985-06-05', NULL, 830, 'WNA/IAEA', '2015-05-24 04:51:28', 356);
INSERT INTO `nuclear_power_plants` VALUES (675, 'Taohuajiang-1', NULL, NULL, 'CN', 1, 21, 'AP-1000', NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (676, 'Taohuajiang-2', NULL, NULL, 'CN', 1, 21, 'AP-1000', NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (677, 'Taohuajiang-3', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (678, 'Taohuajiang-4', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (679, 'Tarapur-1', 19.834000, 72.657000, 'IN', 4, 5, 'BWR-1 (Mark 2)', '1964-10-01', '1969-10-28', NULL, 200, 'WNA/IAEA', '2023-08-28 08:01:45', 285);
INSERT INTO `nuclear_power_plants` VALUES (680, 'Tarapur-2', 19.834000, 72.657000, 'IN', 4, 5, 'BWR-1 (Mark 2)', '1964-10-01', '1969-10-28', NULL, 200, 'WNA/IAEA', '2023-08-28 08:01:45', 296);
INSERT INTO `nuclear_power_plants` VALUES (681, 'Tarapur-3', 19.834000, 72.657000, 'IN', 3, 20, 'Horizontal Pressure Tube Type', '2000-05-12', '2006-08-18', NULL, 502, 'WNA/IAEA', '2015-05-24 04:54:06', 300);
INSERT INTO `nuclear_power_plants` VALUES (682, 'Tarapur-4', 19.834000, 72.657000, 'IN', 3, 20, 'Horizontal Pressure Tube Type', '2000-03-08', '2005-09-12', NULL, 502, 'WNA/IAEA', '2015-05-24 04:54:06', 301);
INSERT INTO `nuclear_power_plants` VALUES (683, 'Temelin-1', 49.181000, 14.377000, 'CZ', 3, 21, 'VVER V-320', '1987-02-01', '2002-06-10', NULL, 1027, 'WNA/IAEA', '2021-02-14 03:47:53', 74);
INSERT INTO `nuclear_power_plants` VALUES (684, 'Temelin-2', 49.181000, 14.377000, 'CZ', 3, 21, 'VVER V-320', '1987-02-01', '2003-04-18', NULL, 1029, 'WNA/IAEA', '2021-02-14 03:47:53', 75);
INSERT INTO `nuclear_power_plants` VALUES (685, 'Three Mile Island-1', 40.154000, -76.727000, 'US', 5, 21, 'B&W LLP (DRYAMB)', '1968-05-18', '1974-09-02', '2019-09-20', 819, 'WNA/IAEA', '2019-11-22 00:00:00', 637);
INSERT INTO `nuclear_power_plants` VALUES (686, 'Three Mile Island-2', 40.154000, -76.727000, 'US', 5, 21, 'PWR', '1969-11-01', '1978-12-30', '1979-03-28', 906, 'WNA/IAEA', '2022-04-21 20:26:19', 657);
INSERT INTO `nuclear_power_plants` VALUES (687, 'THTR-300', 51.680000, 7.972000, 'DE', 5, 9, 'Pebble bed reactor', '1971-05-03', '1987-06-01', '1988-09-29', 296, 'WNA/IAEA', '2015-05-24 04:54:05', 92);
INSERT INTO `nuclear_power_plants` VALUES (688, 'Tianwan-1', 34.690000, 119.456000, 'CN', 3, 21, 'VVER V-428', '1999-10-20', '2007-05-17', NULL, 990, 'WNA/IAEA', '2015-05-24 04:51:50', 838);
INSERT INTO `nuclear_power_plants` VALUES (689, 'Tianwan-2', 34.690000, 119.456000, 'CN', 3, 21, 'VVER V-428', '2000-09-20', '2007-08-16', NULL, 990, 'WNA/IAEA', '2015-05-24 04:51:50', 839);
INSERT INTO `nuclear_power_plants` VALUES (690, 'Tianwan-3', 34.686800, 119.456000, 'CN', 3, 21, 'VVER V-428M', '2012-12-27', '2018-02-14', NULL, 1060, 'WNA/IAEA', '2018-07-01 01:21:55', 973);
INSERT INTO `nuclear_power_plants` VALUES (691, 'Tianwan-4', 34.685800, 119.456000, 'CN', 3, 21, 'VVER V-428M', '2013-09-27', '2018-12-22', NULL, 1060, 'WNA/IAEA', '2019-06-02 20:19:28', 974);
INSERT INTO `nuclear_power_plants` VALUES (692, 'Tianwan-5', 34.683800, 119.456000, 'CN', 3, 21, 'CNP-1000', '2015-12-27', '2020-09-08', NULL, 1000, 'WNA/Wikipedia/IAEA', '2021-01-06 01:19:47', 975);
INSERT INTO `nuclear_power_plants` VALUES (693, 'Tianwan-6', 34.682800, 119.456000, 'CN', 3, 21, 'CNP-1000', '2016-09-07', '2021-06-02', NULL, 1000, 'WNA/Wikipedia/IAEA', '2021-06-29 00:12:17', 976);
INSERT INTO `nuclear_power_plants` VALUES (694, 'Tihange-1', 50.533000, 5.271000, 'BE', 3, 21, 'Framatome 3 loops reactor', '1970-06-01', '1975-10-01', NULL, 870, 'WNA/IAEA', '2015-05-24 04:54:04', 10);
INSERT INTO `nuclear_power_plants` VALUES (695, 'Tihange-2', 50.533000, 5.271000, 'BE', 5, 21, 'WH 3LP', '1976-04-01', '1983-06-01', '2023-02-01', 900, 'WNA/IAEA', '2023-08-28 08:01:45', 13);
INSERT INTO `nuclear_power_plants` VALUES (696, 'Tihange-3', 50.533000, 5.271000, 'BE', 3, 21, 'WH 3LP', '1978-11-01', '1985-09-01', NULL, 1020, 'WNA/IAEA', '2017-02-10 23:55:44', 15);
INSERT INTO `nuclear_power_plants` VALUES (697, 'Tokai-1', 36.466000, 140.612000, 'JP', 5, 8, 'MAGNOX', '1961-03-01', '1966-07-25', '1998-03-31', 159, 'WNA/IAEA', '2015-05-24 04:51:27', 344);
INSERT INTO `nuclear_power_plants` VALUES (698, 'Tokai-2', 36.466000, 140.612000, 'JP', 4, 5, 'BWR-5', '1973-10-03', '1978-11-28', NULL, 1056, 'WNA/IAEA', '2023-08-28 08:01:45', 346);
INSERT INTO `nuclear_power_plants` VALUES (699, 'Tomari-1', 43.038000, 140.515000, 'JP', 4, 21, 'M (2-loop)', '1985-04-18', '1989-06-22', NULL, 550, 'WNA/IAEA', '2022-09-24 22:33:57', 370);
INSERT INTO `nuclear_power_plants` VALUES (700, 'Tomari-2', 43.038000, 140.515000, 'JP', 4, 21, 'M (2-loop)', '1985-06-13', '1991-04-12', NULL, 550, 'WNA/IAEA', '2022-09-24 22:33:57', 371);
INSERT INTO `nuclear_power_plants` VALUES (701, 'Tomari-3', 43.038000, 140.515000, 'JP', 4, 21, 'M (3-loop)', '2004-11-18', '2009-12-22', NULL, 866, 'WNA/IAEA', '2022-09-24 22:33:57', 856);
INSERT INTO `nuclear_power_plants` VALUES (702, 'Torness-1', 55.966000, -2.399000, 'GB', 3, 8, 'AGR', '1980-08-01', '1988-05-25', NULL, 645, 'WNA/IAEA', '2015-05-24 04:51:18', 261);
INSERT INTO `nuclear_power_plants` VALUES (703, 'Torness-2', 55.966000, -2.399000, 'GB', 3, 8, 'AGR', '1980-08-01', '1989-02-03', NULL, 645, 'WNA/IAEA', '2015-05-24 04:51:18', 262);
INSERT INTO `nuclear_power_plants` VALUES (704, 'Trawsfynydd-1', 52.923000, -3.947000, 'GB', 5, 8, 'MAGNOX', '1959-07-01', '1965-03-24', '1991-02-06', 250, 'WNA/IAEA', '2015-05-24 04:51:20', 273);
INSERT INTO `nuclear_power_plants` VALUES (705, 'Trawsfynydd-2', 52.922000, -3.947000, 'GB', 5, 8, 'MAGNOX', '1959-07-01', '1965-03-24', '1991-02-04', 250, 'WNA/IAEA', '2015-05-24 04:51:20', 274);
INSERT INTO `nuclear_power_plants` VALUES (706, 'Tricastin-1', 44.330000, 4.733000, 'FR', 3, 21, 'CP1', '1974-11-01', '1980-12-01', NULL, 915, 'WNA/IAEA', '2015-05-24 04:50:51', 170);
INSERT INTO `nuclear_power_plants` VALUES (707, 'Tricastin-2', 44.330000, 4.733000, 'FR', 3, 21, 'CP1', '1974-12-01', '1980-12-01', NULL, 915, 'WNA/IAEA', '2015-05-24 04:50:51', 171);
INSERT INTO `nuclear_power_plants` VALUES (708, 'Tricastin-3', 44.331000, 4.733000, 'FR', 3, 21, 'CP1', '1975-04-01', '1981-05-11', NULL, 915, 'WNA/IAEA', '2015-05-24 04:50:53', 179);
INSERT INTO `nuclear_power_plants` VALUES (709, 'Tricastin-4', 44.331000, 4.733000, 'FR', 3, 21, 'CP1', '1975-05-01', '1981-11-01', NULL, 915, 'WNA/IAEA', '2015-05-24 04:50:53', 180);
INSERT INTO `nuclear_power_plants` VALUES (710, 'Trillo-1', 40.699000, -2.622000, 'ES', 3, 21, 'PWR 3 loops', '1979-08-17', '1988-08-06', NULL, 990, 'WNA/IAEA', '2015-05-24 04:50:49', 141);
INSERT INTO `nuclear_power_plants` VALUES (712, 'Trojan', 46.040000, -122.887000, 'US', 5, 21, NULL, '1970-02-01', '1976-05-20', '1992-11-09', 1130, 'WNA/IAEA', '2015-05-24 04:51:47', 675);
INSERT INTO `nuclear_power_plants` VALUES (713, 'Tsuruga-1', 35.672000, 136.079000, 'JP', 5, 5, 'BWR-2', '1966-11-24', '1970-03-14', '2015-04-27', 341, 'WNA/IAEA', '2015-05-24 04:51:28', 355);
INSERT INTO `nuclear_power_plants` VALUES (714, 'Tsuruga-2', 35.672000, 136.079000, 'JP', 4, 21, 'M (4-loop)', '1982-11-06', '1987-02-17', NULL, 1115, 'WNA/IAEA', '2022-12-30 02:24:37', 360);
INSERT INTO `nuclear_power_plants` VALUES (715, 'Tsuruga-3', NULL, NULL, 'JP', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (716, 'Tsuruga-4', NULL, NULL, 'JP', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (717, 'Turkey Point-3', 25.435000, -80.330000, 'US', 3, 21, 'WH 3LP (DRYAMB)', '1967-04-27', '1972-12-14', NULL, 693, 'WNA/IAEA', '2017-02-10 23:57:56', 613);
INSERT INTO `nuclear_power_plants` VALUES (718, 'Turkey Point-4', 25.435000, -80.330000, 'US', 3, 21, 'WH 3LP (DRYAMB)', '1967-04-27', '1973-09-07', NULL, 693, 'WNA/IAEA', '2017-02-10 23:57:58', 614);
INSERT INTO `nuclear_power_plants` VALUES (725, 'Unterweser', 53.429000, 8.477000, 'DE', 5, 21, 'PWR', '1972-07-01', '1979-09-06', '2011-08-06', 1230, 'WNA/IAEA', '2015-05-24 04:50:42', 90);
INSERT INTO `nuclear_power_plants` VALUES (726, 'Vandellos-1', 40.949000, 0.867000, 'ES', 5, 8, NULL, '1968-06-21', '1972-08-02', '1990-07-31', 480, 'WNA/IAEA', '2015-05-24 04:50:49', 150);
INSERT INTO `nuclear_power_plants` VALUES (727, 'Vandellos-2', 40.949000, 0.867000, 'ES', 3, 21, 'WH 3LP', '1980-12-29', '1988-03-08', NULL, 930, 'WNA/IAEA', '2017-02-10 23:56:13', 146);
INSERT INTO `nuclear_power_plants` VALUES (728, 'Vermont Yankee', 42.779000, -72.514000, 'US', 5, 5, 'BWR-4 (Mark 1)', '1967-12-11', '1972-11-30', '2014-12-29', 514, 'WNA/IAEA', '2015-05-24 04:51:42', 626);
INSERT INTO `nuclear_power_plants` VALUES (729, 'Visaginas-1', 55.605700, 26.575842, 'LT', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (730, 'Visaginas-2', 55.605700, 26.575842, 'LT', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (731, 'Vogtle-1', 33.143000, -81.760000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1976-08-01', '1987-06-01', NULL, 1122, 'WNA/IAEA', '2017-02-10 23:59:15', 718);
INSERT INTO `nuclear_power_plants` VALUES (732, 'Vogtle-2', 33.143000, -81.760000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1976-08-01', '1989-05-20', NULL, 1101, 'WNA/IAEA', '2017-02-10 23:59:16', 719);
INSERT INTO `nuclear_power_plants` VALUES (733, 'Vogtle-3', 33.139900, -81.768600, 'US', 3, 21, 'AP-1000', '2013-03-02', '2023-07-31', NULL, 1117, 'WNA/IAEA', '2023-08-28 08:01:45', 1042);
INSERT INTO `nuclear_power_plants` VALUES (734, 'Vogtle-4', 33.139900, -81.771200, 'US', 2, 21, 'AP-1000', '2013-11-19', NULL, NULL, 1117, 'WNA/IAEA', '2015-05-24 04:51:58', 1043);
INSERT INTO `nuclear_power_plants` VALUES (735, 'Waterford-3', 29.994000, -90.471000, 'US', 3, 21, 'CE 2LP (DRYAMB)', '1974-11-14', '1985-09-24', NULL, 1104, 'WNA/IAEA', '2017-02-10 23:58:56', 695);
INSERT INTO `nuclear_power_plants` VALUES (736, 'Watts Bar-1', 35.601000, -84.789000, 'US', 3, 21, 'WH 4LP (ICECND)', '1973-07-20', '1996-05-27', NULL, 1218, 'WNA/IAEA', '2017-02-10 23:58:57', 699);
INSERT INTO `nuclear_power_plants` VALUES (737, 'Watts Bar-2', 35.601000, -84.789000, 'US', 3, 21, 'WH 4LP (ICECND)', '1973-09-01', '2016-10-19', NULL, 1165, 'WNA/IAEA', '2017-02-10 23:58:57', 700);
INSERT INTO `nuclear_power_plants` VALUES (738, 'Windscale AGR', 54.426000, -3.505000, 'GB', 5, 8, 'AGR', '1958-11-01', '1963-03-01', '1981-04-03', 32, 'WNA/IAEA', '2015-05-24 04:51:19', 268);
INSERT INTO `nuclear_power_plants` VALUES (739, 'Winfrith SGHWR', 50.680000, -2.272000, 'GB', 5, 24, NULL, '1963-05-01', '1968-01-01', '1990-09-11', 92, 'WNA/IAEA', '2015-05-24 04:51:12', 239);
INSERT INTO `nuclear_power_plants` VALUES (740, 'Wolf Creek', 38.239000, -95.691000, 'US', 3, 21, 'WH 4LP (DRYAMB)', '1977-05-31', '1985-09-03', NULL, 1170, 'WNA/IAEA', '2017-02-10 23:59:19', 751);
INSERT INTO `nuclear_power_plants` VALUES (741, 'Wolsong-1', 35.710000, 129.476000, 'KR', 5, 20, 'CANDU 6', '1977-10-30', '1983-04-22', '2019-12-24', 629, 'WNA/IAEA', '2020-04-18 04:46:52', 407);
INSERT INTO `nuclear_power_plants` VALUES (742, 'Wolsong-2', 35.710000, 129.476000, 'KR', 3, 20, 'CANDU 6', '1992-09-25', '1997-07-01', NULL, 652, 'WNA/IAEA', '2022-04-21 20:26:19', 408);
INSERT INTO `nuclear_power_plants` VALUES (743, 'Wolsong-3', 35.710000, 129.476000, 'KR', 3, 20, 'CANDU 6', '1994-03-17', '1998-07-01', NULL, 665, 'WNA/IAEA', '2022-04-21 20:26:19', 400);
INSERT INTO `nuclear_power_plants` VALUES (744, 'Wolsong-4', 35.710000, 129.476000, 'KR', 3, 20, 'CANDU 6', '1994-07-22', '1999-10-01', NULL, 669, 'WNA/IAEA', '2022-04-21 20:26:19', 401);
INSERT INTO `nuclear_power_plants` VALUES (745, 'Wolsong-5', 35.710100, 129.481000, 'KR', 1, 20, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (746, 'Wolsong-6', 35.710100, 129.481000, 'KR', 1, 20, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (747, 'Wuergassen', 51.639000, 9.393000, 'DE', 5, 5, NULL, '1968-01-26', '1975-11-11', '1994-08-26', 640, 'WNA/IAEA', '2015-05-24 04:50:48', 136);
INSERT INTO `nuclear_power_plants` VALUES (748, 'Wuhu-1', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (749, 'Wuhu-2', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (750, 'Wylfa-1', 53.416000, -4.480000, 'GB', 5, 8, 'MAGNOX', '1963-09-01', '1971-11-01', '2015-12-30', 550, 'WNA/IAEA', '2016-03-09 18:43:09', 240);
INSERT INTO `nuclear_power_plants` VALUES (751, 'Wylfa-2', 53.416000, -4.480000, 'GB', 5, 8, 'MAGNOX', '1963-09-01', '1972-01-03', '2012-04-25', 550, 'WNA/IAEA', '2015-05-24 04:51:13', 241);
INSERT INTO `nuclear_power_plants` VALUES (752, 'Xianning-1', 29.660000, 114.670000, 'CN', 1, 21, 'AP-1000', NULL, NULL, NULL, NULL, 'WNA/Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (753, 'Xianning-2', 29.660000, 114.670000, 'CN', 1, 21, 'AP-1000', NULL, NULL, NULL, NULL, 'WNA/Wikipedia', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (754, 'Xiaomoshan (Jiulongshan) 1', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (755, 'Xiaomoshan (Jiulongshan) 2', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (756, 'Yangjiang-1', 21.706000, 112.256000, 'CN', 3, 21, 'CPR-1000', '2008-12-16', '2014-03-25', NULL, 1021, 'WNA/IAEA', '2015-05-24 04:51:52', 881);
INSERT INTO `nuclear_power_plants` VALUES (757, 'Yangjiang-2', 21.706000, 112.256000, 'CN', 3, 21, 'CPR-1000', '2009-06-04', '2015-06-05', NULL, 1000, 'WNA/IAEA', '2015-08-23 03:28:27', 882);
INSERT INTO `nuclear_power_plants` VALUES (758, 'Yangjiang-3', 21.706000, 112.256000, 'CN', 3, 21, 'CPR-1000', '2010-11-15', '2016-01-01', NULL, 1000, 'WNA/IAEA', '2016-03-09 18:43:57', 931);
INSERT INTO `nuclear_power_plants` VALUES (759, 'Yangjiang-4', 21.857500, 111.982500, 'CN', 3, 21, 'CPR-1000', '2012-11-17', '2017-03-15', NULL, 1000, 'WNA/IAEA', '2017-09-25 03:20:38', 932);
INSERT INTO `nuclear_power_plants` VALUES (760, 'Yangjiang-5', 21.857500, 111.982500, 'CN', 3, 21, 'ACPR-1000', '2013-09-18', '2018-07-12', NULL, 1021, 'IAEA', '2019-06-02 20:19:31', 933);
INSERT INTO `nuclear_power_plants` VALUES (761, 'Yangjiang-6', 21.857500, 111.982500, 'CN', 3, 21, 'ACPR-1000', '2013-12-23', '2019-07-24', NULL, 1000, 'IAEA', '2019-11-22 00:00:00', 934);
INSERT INTO `nuclear_power_plants` VALUES (762, 'Yanjiashan-1', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (763, 'Yanjiashan-2', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', NULL, NULL);
INSERT INTO `nuclear_power_plants` VALUES (764, 'Yankee Rowe', 42.728000, -72.929000, 'US', 5, 21, 'PWR', '1957-11-01', '1961-07-01', '1991-10-01', 175, 'WNA/IAEA', '2015-05-24 04:51:43', 638);
INSERT INTO `nuclear_power_plants` VALUES (771, 'Zaporozhye-1', 47.508000, 34.627000, 'UA', 3, 21, 'VVER V-320', '1980-04-01', '1985-12-25', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:40', 584);
INSERT INTO `nuclear_power_plants` VALUES (772, 'Zaporozhye-2', 47.508000, 34.627000, 'UA', 3, 21, 'VVER V-320', '1981-01-01', '1986-02-15', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:40', 586);
INSERT INTO `nuclear_power_plants` VALUES (773, 'Zaporozhye-3', 47.508000, 34.627000, 'UA', 3, 21, 'VVER V-320', '1982-04-01', '1987-03-05', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:40', 594);
INSERT INTO `nuclear_power_plants` VALUES (774, 'Zaporozhye-4', 47.508000, 34.627000, 'UA', 3, 21, 'VVER V-320', '1983-04-01', '1988-04-14', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:40', 595);
INSERT INTO `nuclear_power_plants` VALUES (775, 'Zaporozhye-5', 47.508000, 34.627000, 'UA', 3, 21, 'VVER V-320', '1985-11-01', '1989-10-27', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:39', 566);
INSERT INTO `nuclear_power_plants` VALUES (776, 'Zaporozhye-6', 47.508000, 34.627000, 'UA', 3, 21, 'VVER V-320', '1986-06-01', '1996-09-17', NULL, 950, 'WNA/IAEA', '2015-05-24 04:51:39', 567);
INSERT INTO `nuclear_power_plants` VALUES (777, 'Zhangzhou-1', 23.829167, 117.491667, 'CN', 2, 21, 'HPR1000', '2019-10-16', NULL, NULL, 1126, 'WNA/IAEA/Wikipedia', '2021-01-09 20:00:00', 1083);
INSERT INTO `nuclear_power_plants` VALUES (778, 'Zion-1', 42.446000, -87.801000, 'US', 5, 21, 'WH 4LP', '1968-12-01', '1973-12-31', '1998-02-13', 1040, 'WNA/IAEA', '2017-02-10 23:58:20', 640);
INSERT INTO `nuclear_power_plants` VALUES (779, 'Zion-2', 42.446000, -87.801000, 'US', 5, 21, 'WH 4LP', '1968-12-01', '1974-09-17', '1998-02-13', 1040, 'WNA/IAEA', '2017-02-10 23:58:24', 646);
INSERT INTO `nuclear_power_plants` VALUES (780, 'Fangchenggang-3', 21.600000, 108.300000, 'CN', 3, 21, 'HPR1000', '2015-12-24', '2023-03-25', NULL, 1000, 'IAEA', '2023-08-28 08:01:45', 945);
INSERT INTO `nuclear_power_plants` VALUES (781, 'Barakah-4 (Braka)', 23.952748, 52.203298, 'AE', 2, 21, 'APR-1400', '2015-07-30', NULL, NULL, 1310, 'IAEA', '2023-08-28 08:01:45', 1053);
INSERT INTO `nuclear_power_plants` VALUES (783, 'KANUPP-2', 24.845000, 66.790000, 'PK', 3, 21, 'ACP-1000', '2015-08-20', '2021-05-21', NULL, 1017, 'IAEA', '2022-04-21 20:26:19', 1067);
INSERT INTO `nuclear_power_plants` VALUES (784, 'Fangchenggang-4', 21.600000, 108.300000, 'CN', 2, 21, 'HPR1000', '2016-12-23', NULL, NULL, 1000, 'IAEA', '2017-02-10 23:59:38', 946);
INSERT INTO `nuclear_power_plants` VALUES (785, 'KANUPP-3', 24.845000, 66.790000, 'PK', 3, 21, 'ACP-1000', '2016-05-31', '2022-04-18', NULL, 1014, 'IAEA', '2022-09-24 22:33:57', 1068);
INSERT INTO `nuclear_power_plants` VALUES (786, 'Rooppur-1', 24.066667, 89.047222, 'BD', 2, 21, 'VVER V-523', '2017-11-30', NULL, NULL, 1080, 'IAEA', '2018-03-10 20:52:25', 1078);
INSERT INTO `nuclear_power_plants` VALUES (787, 'Kursk 2-1', 51.674000, 35.607000, 'RU', 2, 21, 'VVER V-510', '2018-04-28', NULL, NULL, 1200, 'IAEA', '2023-08-28 08:01:45', 903);
INSERT INTO `nuclear_power_plants` VALUES (788, 'Rooppur-2', 24.066667, 89.047222, 'BD', 2, 21, 'VVER V-523', '2018-07-14', NULL, NULL, 1080, 'IAEA', '2018-10-13 22:30:35', 1079);
INSERT INTO `nuclear_power_plants` VALUES (789, 'Kursk 2-2', 51.674000, 35.607000, 'RU', 2, 21, 'VVER V-510', '2019-05-01', NULL, NULL, 1200, 'IAEA', '2023-08-28 08:01:45', 1008);
INSERT INTO `nuclear_power_plants` VALUES (790, 'Taipingling-1', 22.693056, 114.983333, 'CN', 2, 21, 'HPR1000', '2019-12-26', NULL, NULL, 1116, 'IAEA', '2020-06-06 02:41:28', 1084);
INSERT INTO `nuclear_power_plants` VALUES (791, 'Zhangzhou-2', 23.829167, 117.491667, 'CN', 2, 21, 'HPR-1000', '2020-09-04', NULL, NULL, 1126, 'IAEA/Wikipedia', '2021-01-09 20:00:00', 1090);
INSERT INTO `nuclear_power_plants` VALUES (792, 'Taipingling-2', 22.693056, 114.983333, 'CN', 2, 21, 'HPR1000', '2020-10-15', NULL, NULL, 1116, 'IAEA', '2021-01-09 17:57:48', 1091);
INSERT INTO `nuclear_power_plants` VALUES (793, 'Xiapu-1', 26.803611, 120.155000, 'CN', 2, 7, 'CFR600', '2017-12-29', NULL, NULL, 642, 'WNA/Wikipedia/IAEA', '2021-04-30 21:49:18', 1101);
INSERT INTO `nuclear_power_plants` VALUES (794, 'Xiapu-2', 26.803611, 120.155000, 'CN', 2, 7, 'CFR-600', '2020-12-27', NULL, NULL, 600, 'WNA/Wikipedia', '2021-02-14 00:09:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (795, 'Cernavoda-4', 44.322000, 28.061000, 'RO', 8, 20, NULL, '1985-08-15', NULL, NULL, 655, 'IAEA/Wikipedia', '2021-02-14 01:00:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (796, 'Cernavoda-5', 44.322000, 28.061000, 'RO', 9, 20, NULL, '1987-05-12', NULL, NULL, 655, 'IAEA/Wikipedia', '2021-02-14 01:01:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (797, 'Zwentendorf', 48.354400, 15.884700, 'AT', 10, 5, NULL, '1972-04-04', NULL, NULL, 692, 'IAEA/Wikipedia', '2021-02-14 02:59:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (798, 'SNR-300 (Kalkar)', 51.763056, 6.326944, 'DE', 10, 7, 'SNR-300', '1973-04-23', NULL, NULL, 295, 'IAEA/Wikipedia', '2021-02-14 02:59:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (799, 'Sanaocun-1', 27.201487, 120.517974, 'CN', 2, 21, 'HRP1000', '2020-12-31', NULL, NULL, 1117, 'IAEA/WNA', '2021-02-14 03:47:53', 1094);
INSERT INTO `nuclear_power_plants` VALUES (800, 'CAP1400-1', 36.965556, 122.520000, 'CN', 2, 21, 'CAP1400', '2013-03-22', NULL, NULL, 1534, 'IAEA/Wikipedia', '2021-04-20 02:47:37', 1085);
INSERT INTO `nuclear_power_plants` VALUES (801, 'CAP1400-2', 36.965556, 122.520000, 'CN', 2, 21, 'CAP1400', '2013-03-22', NULL, NULL, 1534, 'IAEA/Wikipedia', '2021-04-20 02:47:37', 1086);
INSERT INTO `nuclear_power_plants` VALUES (802, 'Changjiang-3', 19.460750, 108.899917, 'CN', 2, 21, 'HPR1000', '2021-03-31', NULL, NULL, 1000, 'IAEA/Wikipedia', '2021-06-29 00:12:17', 941);
INSERT INTO `nuclear_power_plants` VALUES (803, 'Xudabu-1', 40.351389, 120.545833, 'CN', 2, 21, 'CAP1000', '2023-11-03', NULL, NULL, 1000, 'Wikipedia/IAEA', '2024-03-03 20:54:44', 999);
INSERT INTO `nuclear_power_plants` VALUES (804, 'Xudabu-2', 40.351389, 120.545833, 'CN', 1, 21, 'CAP1000', NULL, NULL, NULL, 1000, 'Wikipedia', '2024-03-03 20:54:44', NULL);
INSERT INTO `nuclear_power_plants` VALUES (805, 'Xudabu-3', 40.351389, 120.545833, 'CN', 2, 21, 'VVER-1200/V491', '2021-07-28', NULL, NULL, 1200, 'WNA/Wikipedia/IAEA', '2022-01-05 00:04:08', 1104);
INSERT INTO `nuclear_power_plants` VALUES (806, 'Xudabu-4', 40.351389, 120.545833, 'CN', 2, 21, 'VVER-1200/V491', '2022-05-19', NULL, NULL, 1200, 'Wikipedia/IAEA', '2022-09-24 22:33:57', 1112);
INSERT INTO `nuclear_power_plants` VALUES (807, 'Tianwan-7', 34.682800, 119.456000, 'CN', 2, 21, 'VVER-1200/V491', '2021-05-19', NULL, NULL, 1171, 'WNA/Wikipedia/IAEA', '2022-01-05 00:04:08', 1105);
INSERT INTO `nuclear_power_plants` VALUES (808, 'Tianwan-8', 34.682800, 119.456000, 'CN', 2, 21, 'VVER-1200/V491', '2022-02-25', NULL, NULL, 1171, 'Wikipedia/IAEA', '2022-04-21 20:26:19', 1110);
INSERT INTO `nuclear_power_plants` VALUES (809, 'Changjiang-4', 19.460750, 108.899917, 'CN', 2, 21, 'HPR1000', '2021-12-28', NULL, NULL, 1000, 'Wikipedia/IAEA', '2022-04-21 20:26:19', 942);
INSERT INTO `nuclear_power_plants` VALUES (810, 'Changjiang SMR-1', 19.460070, 108.889920, 'CN', 2, 21, 'ACP100', '2021-07-13', NULL, NULL, 100, 'WNA/IAEA', '2022-04-21 20:26:19', 1111);
INSERT INTO `nuclear_power_plants` VALUES (811, 'Changjiang SMR-2', NULL, NULL, 'CN', 1, 21, 'ACP100', NULL, NULL, NULL, NULL, 'WNA', '2021-05-29 00:00:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (812, 'Bohai Shipyard FNPP', NULL, NULL, 'CN', 1, 21, 'ACPR50S', NULL, NULL, NULL, NULL, 'WNA', '2021-05-29 00:00:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (813, 'Jiaodong Shipyard FNPP', NULL, NULL, 'CN', 1, 21, 'ACP100S', NULL, NULL, NULL, NULL, 'WNA', '2021-05-29 00:00:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (814, 'Shanwei-2', NULL, NULL, 'CN', 1, 21, NULL, NULL, NULL, NULL, NULL, 'WNA', '2021-05-29 00:00:00', NULL);
INSERT INTO `nuclear_power_plants` VALUES (815, 'BREST-OD-300', 56.637414, 84.904510, 'RU', 2, 7, 'BREST-OD-300', '2021-06-08', NULL, NULL, 300, 'IAEA/WNA', '2022-01-05 00:04:08', 1106);
INSERT INTO `nuclear_power_plants` VALUES (816, 'Sanaocun-2', 27.201487, 120.517974, 'CN', 2, 21, 'HRP1000', '2021-12-30', NULL, NULL, 1117, 'IAEA', '2022-04-21 20:26:19', 1107);
INSERT INTO `nuclear_power_plants` VALUES (817, 'El Dabaa-2', 31.044167, 28.497778, 'EG', 2, 21, 'VVER-1200', '2022-11-19', NULL, NULL, 1100, 'IAEA/Wikipedia', '2023-08-28 08:01:45', 138);
INSERT INTO `nuclear_power_plants` VALUES (818, 'El Dabaa-3', 31.044167, 28.497778, 'EG', 2, 21, 'VVER-1200', '2023-05-03', NULL, NULL, 1100, 'IAEA/Wikipedia', '2023-08-28 08:24:00', 1120);
INSERT INTO `nuclear_power_plants` VALUES (819, 'Lufeng-5', NULL, NULL, 'CN', 2, 21, 'HPR1000', '2022-09-08', NULL, NULL, 1116, 'IAEA', '2023-08-28 08:01:45', 1113);
INSERT INTO `nuclear_power_plants` VALUES (820, 'Lufeng-6', NULL, NULL, 'CN', 2, 21, 'HPR1000', '2023-08-26', NULL, NULL, 1116, 'IAEA', '2024-03-03 20:43:43', 1114);

SET FOREIGN_KEY_CHECKS = 1;
