<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Header (navigation, jumbotron)
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the romanian translation of the header elements.
    |
    */
    'about' => 'About',
    'journey' => 'Journey',
    'jobs' => 'Jobs',
    'apply' => 'Apply',
    'about_us' => 'About us',
    'location' => 'Location',
    /*
    |--------------------------------------------------------------------------
    | Jumbotron
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the romanian translation of the Jumbotron headings.
    | Using jumbotron from the header section.
    */
    'jumbotron_title' => 'We offer jobs for',
    'jumbotron_subtitle' => '
        <h3>River Cruise ships</h3>
        <h3>Hotels in Cyprus</h3>
        <h3>Hotels in Germany</h3>
        <h3>Agriculture</h3>
    ',
    /*
    |--------------------------------------------------------------------------
    | About us section
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the romanian translation of the about us elements.
    | Using about_us from the header section.
    */
    'about_us_details' => '
        <p class="large text-muted">At <a href="www.aurasjobs.ro">aurasjobs.ro</a>, we have been in your position, we started just like you, working on both ocean and river cruise lines, collaborating with various recruitment agencies, we felt the need to change something, to make the <a href="#applicationProcess" class="page-scroll">recruitment process</a> how it should be!</p>
      <p class="large text-muted">We assist the candidates with all the steps required to land a job, putting passion into their application process. We keep in touch after their embarkation, getting feedbacks about their experience and offering further assistance in the case is needed.</p>
      <p class="large text-muted">There is no need to pay any fee for our services. Our goal is to find the best offers for you, this is the way it should be!</p>',
    /*
    |--------------------------------------------------------------------------
    | Our team section
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the romanian translation of the header elements.
    |
    */
    'about_heading' => 'Our Amazing Team',
    'about_subheading' => 'Happy to help you',
    'team_member1' => '
        <p class="text-muted">Founder/Administrator</p>
        <p>Mr. Auras started recruiting personnel 8 years ago, his first candidates were Andreea-Elena and Ceamatu Cristian. What followed after, made him create aurasjobs. He is in charge of the accountancy as well.</p>',
    'team_member2' => '
        <p class="text-muted">Recruiter/Office Manager</p>
        <p>Andreea is the heart of our company, always smiling and ready to answer all your questions. She worked on ocean and river cruise lines for 3-4 years, having a good knowledge about working on ships and the recruitment process in general, Andreea will do her best to make your employment successfully. She is also helping with the social media</p>',
    'team_member3' => '
        <p class="text-muted">Recruiter/Contracts Manager</p>
        <p>Having similar cruise experience, Cristian helps with the recruitment process. He is the administrator of aurasjobs.ro website.</p>',
    'about_footer' => 'Feel free to contact us for any information',
    /*
    |--------------------------------------------------------------------------
    | Journey section
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the romanian translation of the journey elements.
    |
    */
    'journey_heading' => 'Just apply!',
    'journey_subheading' => 'There is no cost and we will do our best to find suited job offers for you',
    'journey_member1' => '
        <h4 class="service-heading">No taxes or fees</h4>
        <p class="text-muted">All our services are free of charge, without hidden fees or unpleasant surprises. Our objective is to find you a job where you can successfully finish the contract.</p>',
    'journey_member2' => '
        <h4 class="service-heading">24/7 Support</h4>
        <p class="text-muted">We offer assistance from the initiation of the application process until you finish your contract. You can contact us at any hour in case of an emergency.</p>',
    'journey_member3' => '
        <h4 class="service-heading">Feedback</h4>
        <p class="text-muted">Thanks to our experience in the field, we can offer you correct and honest feedback related to the conditions of each job that we constantly update through the new employee recommendations.</p>',
    'journey_processHeading' => 'Application process',
    'journey_processSubheading' => 'From our first contact to your first working day',
    'journey_process1' => '
        <div class="timeline-heading">
            <h4>Phone conversation</h4>
            <h4 class="subheading">Pre-interview</h4>
        </div>
        <div class="timeline-body">
            <p class="text-muted">Send us your CV, apply online or contact us, we need to have a phone conversation to know each other better and plan all the details.</p>
        </div>',
    'journey_process2' => '
        <div class="timeline-heading">
            <h4>Handshake</h4>
            <h4 class="subheading">Start the application</h4>
        </div>
        <div class="timeline-body">
            <p class="text-muted">After you accept the offer, we email you our collaboration contract (no taxes or fees) together with the documents required by the employer. You can visit our office to sign and fill them or you can send them by email.</p>
        </div>',
    'journey_process3' => '
        <div class="timeline-heading">
            <h4>Application</h4>
            <h4 class="subheading">Making them choose you</h4>
        </div>
        <div class="timeline-body">
            <p class="text-muted">We help to modify your CV, in case it is needed, and prepare you for the interview. We show your final application to our partners.</p>
        </div>',
    'journey_process4' => '
        <div class="timeline-heading">
            <h4>Accepted?</h4>
            <h4 class="subheading">Show me the offers</h4>
        </div>
        <div class="timeline-body">
            <p class="text-muted">You will be contacted for the interview. Our goal is to find best offers suited for your experience. Just a friendly phone conversation can get you an employment contract.</p>
        </div>',
    'journey_process5' => '
        <div class="timeline-heading">
            <h4>I`m ready to CRUISE!</h4>
            <h4 class="subheading">Getting employed</h4>
        </div>
        <div class="timeline-body">
            <p class="text-muted">After signing the documents and securing the job, we prepare the travel details. Depending on the company, the transport can be paid in advance by the employer or reimbursed after a few months of work.</p>
        </div>',
    'journey_processFooter' => '
        <h4>Have
        <br>an easy
        <br>contract !
        </h4>',
    /*
    |--------------------------------------------------------------------------
    | Jobs section
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the romanian translation of the jobs elements.
    |
    */
    'jobs_heading' => '
        <h2 class="section-heading">Job offers</h2>
        <h3 class="section-subheading text-muted">Offers below are part of the packages that you may receive. Click to enlarge</h3>',
    'jobs_offerSubheading' => 'River Cruises',
    'jobs_offerHotelLandJobs' => 'Hotels',
    'jobs_offerCourses' => 'Trainings',
    // 'jobs_carnivalSubheading' => 'Waiters interview January 2018',
    /*
    |--------------------------------------------------------------------------
    | Apply section
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the romanian translation of the apply elements.
    |
    */
    'apply_heading' => '
        <h2 class="section-heading">How to apply</h2>
        <h3 class="section-subheading text-muted">Before applying we reccomend you check the <a href="#applicationProcess" class="page-scroll"><strong>application process</strong></a></h3>',
    'apply_member1' => '
        <a href="#applicationForm" class="page-scroll">
            <i class="fa fa-4x fa-fighter-jet text-primary sr-icons"></i>
            <h3>Send me offers</h3>
        </a>
        <p class="text-muted">Download, complete and upload the fast application form below along with your ID/passport</p>',
    'apply_member2' => '
        <a href="tel:0040728683604">
            <i class="fa fa-4x fa-phone text-primary sr-icons"></i>
            <h3>Call us</h3>
            <p class="text-muted">0728 683604 / 0730 719323 / 0725 085231 This is the fastest way to get answers to all your questions</p>
        </a>',
    'apply_member3' => '
        <a href="mailto:&#111;&#102;&#102;&#105;&#099;&#101;&#064;&#097;&#117;&#114;&#097;&#115;&#106;&#111;&#098;&#115;&#046;&#114;&#111;">
            <i class="fa fa-4x fa-envelope text-primary sr-icons"></i>
            <h3>Via email</h3>
            <p class="text-muted">Sending your CV to &#111;&#102;&#102;&#105;&#099;&#101;&#064;&#097;&#117;&#114;&#097;&#115;&#106;&#111;&#098;&#115;&#046;&#114;&#111;</p>
        </a>',
    /*
    |--------------------------------------------------------------------------
    | Apply Form section
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the romanian translation of the apply form elements.
    |
    */
    'applyForm_heading' => '
        <h2 class="text-center">Fast Application Form</h2>
        <p class="text-center text-muted">The fields with * are mandatory</p>',
    'applyForm_link1' => 'Download application form',
    'applyForm_link2' => 'Application form example',
    'applyForm_name' => 'Your Name *',
    'applyForm_email' => 'Your Email *',
    'applyForm_phone' => 'Your phone *',
    'applyForm_message' => 'Your Message',
    'applyForm_department' => 'Department applying for',
    'applyForm_cv' => 'Upload CV or Application Form *',
    'applyForm_identificationDocument' => 'Upload National ID or passport (OPTIONAL)',
    'applyForm_conditions' => 'By pressing APPLY you agree to our data protection <a href="http://www.aurasjobs.ro/downloads/gdprEN.pdf" target="_blank">terms and conditions.</a>',
    'applyForm_button' => 'Apply',
    /*
    |--------------------------------------------------------------------------
    | Partners section
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the romanian translation of the partners elements.
    |
    */
    'partners_heading' => 'Our partners',
    /*
    |--------------------------------------------------------------------------
    | Contact Form section
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the romanian translation of the contact form elements.
    |
    */
    'contactForm_heading' => '
        <h2 class="section-heading">Have questions?</h2>
        <h3 class="section-subheading">We have all the answers.</h3>',
    'contactForm_name' => 'Your Name *',
    'contactForm_email' => 'Your Email *',
    'contactForm_phone' => 'Your phone *',
    'contactForm_message' => 'Your Message',
    'contactForm_button' => 'Send message',
    /*
    |--------------------------------------------------------------------------
    | JobModals section
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the romanian translation of the jobModals elements.
    |
    */
    'jobs_modalButton' => 'Close job',
    'jobs_modal1' => '
        <ul>
            <li class="jobSubtitle">Job description<li>
                <li><span>Contracts</span> typically run from mid-March to October and in a few cases 5th January the following year.</li>
                <li><span>Travel expenses</span> – Our crew arrange their own transport to the vessel based on the docking location details provided by us. Travel is reimbursed up to 125€ per way for the beginning and end of contract journeys provided crew complete the contract or stay a minimum of 6 months onboard: without any warnings and we are provided with clear scans of tickets/receipts within the time limit designated in their Contracts. Crew are expected to be able to fund the trip out and back on their own.</li>
                <li>During the course of your contract - you will be insured by Allianz!</li>
                <li>Approximately 10 - 14 working hours per day with afternoon rest and free time, 7 days per week (Crew get 1 day off per week, or 4 per month whenever possible, when it is not possible then the days worked extra are paid at the end of their contract or alternatively they can go on holiday for the collected days after a discussion with the Hotel Manager onboard).</li>
                <li><span>Tip Box</span> - tips are a pool system and depending on the guest, approx. € 200 - € 500 on a monthly base</li>
                <li><span>Hand Tips</span> – you are entitled to hand tips depending on your performance and guest satisfaction</li>
                <li>If you complete your first contract correctly – you can expect to receive an invitation for another.</li>
                <li>Languages requirements: English, German, Spanish or French</li>
                <li><span>Website: </span><a href="https://www.cruisinc.eu/" target="_blank">Cruisinc Creative Catering</a></li>
            <li class="jobSubtitle">Position: salary</li>
                <li><span>Hotel Manager</span> Negotiable</li>
                <li><span>Ast. Hotel Manager</span> Negotiable</li>
                <li><span>Receptionist</span> 1200 - 1600 depending on the experience</li>
                <li><span>Allround</span> 1050 - 1200</li>                
                <li><span>Maitre D`/Head Waiter</span> 1400 - 1600</li>                
                <li><span>Waiter/ess</span> 1050 - 1200</li>
                <li><span>Bar/waiter/ess</span> 1050 - 1100</li>
                <li><span>Head Cabin Steward/ess</span> 1200 - 1400</li>
                <li><span>Cabin Steward/ess</span> 1050 - 1100</li>
                <li><span>Laundry</span> 1050 - 1100</li>
                <li><span>Head Chef</span> Negotiable</li>
                <li><span>Sous Chef</span> Negotiable</li>
                <li><span>Chef de Partie</span> 1400</li>
                <li><span>Demi Chef de Partie</span> 1250</li>
                <li><span>Kitchen Porter/Dishwasher</span> 1050 - 1100</li>
                <li><span>Nightwatch</span> 1050 - 1200</li>
        </ul>',
    'jobs_modal2' => '
        <ul>
            <li class="jobSubtitle">Job description<li>
                <li>River Advice is the leading independent manager of river passenger ships. River Advice manages over 50 river cruise vessels, the ships are 3*, 4* & 4 *+ sailing along the European rivers with  English & German speaking passengers mostly, the season starts in March and continues until January next year.</li>
                <li>Contracts are according to position availability, ranging between 6 to 10 months per year with  2 weeks  paid vacation every 6-8 weeks worked during the contract – Swiss or Cypriot contracts with social insurance in Switzerland or France.</li>
                <li>All additionally worked hours will be compensated, either in extra free time or paid out. At the end of your contract, whatever holiday balance & extra working hours are left over, will be paid out entirely.</li>
                <li>You will be supposed to work 7 days per week, 10-12 hours per day, no days off. If you complete your first contract correctly – you can expect to receive an invitation for another.</li>
                <li>Accommodation, meals on board & uniform - provided by the company</li>
                <li>If you complete your first contract correctly – you can expect to receive an invitation for another.</li>
                <li><span>Website: </span><a href="https://www.riveradvice.com/" target="_blank">River Advice Cruises</a></li>
            <li class="jobSubtitle">Position: salary</li>
            <li class="text-danger">With all the base salaries mentioned below you will receive a monthly payment for extra hours worked plus the Tip Box (plus Hand tips for some of the positions)</li>
                <li><span>Hotel Manager</span> €2722</li>
                <li><span>1st Receptionist</span> €1225</li>
                <li><span>Receptionist</span> €1070/1100/1138</li>
                <li><span>Adventure Host (Fitness trainer)</span> €1200</li>
                <li><span>Night-Auditor</span> €1070/1100/1138</li>
                <li><span>Executive Chef</span> €2638</li>
                <li><span>Sous-Chef</span> €1389</li>
                <li><span>Chef de Partie</span> €1144</li>
                <li><span>Demi Chef de Partie</span> €1070/1125/1138</li>
                <li><span>Junior Cook</span> €1070/1100/1138</li>
                <li><span>Utility</span> €1070/1100/1138</li>
                <li><span>Maitre D’</span> €1225</li>
                <li><span>Waiter/Waitress</span> (English) €1070/1100/1138</li>
                <li><span>Bar Waiter/Waitress</span> (English) €1070/1100/1138</li>
                <li><span>Chef de Bar</span> (English/German) €1144</li>
                <li><span>Housekeeper</span> €1225</li>
                <li><span>Cabin Steward/Stewardess</span> €1070/1100/1138</li>
                <li><span>Laundry</span> €1070/1100/1138</li>
                <li><span>Hairdresser/Shop</span> €1138</li>
                <li><span>Wellness</span> €1070/1100/1138</li>
            </li>
            <li class="jobSubtitle">Useful information</li>
                <li>On vessels carrying European/British Guests, the tips will vary @ €400 - 800</li>
                <li>On vessels Avalon/Vantage (American Guests), the tips will vary @ €400 - €1000</li>
        </ul>',
    'jobs_modal3' => '
        <ul>
            <li class="jobSubtitle">Job description<li>
                <li>Luftner Cruise Services is a Cypriot company which specializes in providing intergraded & holistic Human Resources & Management Services to the river cruise industry.</li>
                <li>The company operates 10 ships of the Amadeus Luftner Cruises:</li>
                <li>MS Amadeus Princess</li>
                <li>MS Amadeus Elegant</li>
                <li>MS Amadeus Brilliant</li>
                <li>MS Amadeus Silver</li>
                <li>MS Amadeus Royal</li>
                <li>MS Amadeus Classic</li>
                <li>MS Amadeus Rhapsody</li>
                <li>MS Amadeus Symphony</li>
                <li>MS Danubia</li>
                <li>MS Amadeus</li>
                <li>The vessels are Premium 4+* & Regular 3* ships operating on Dutch & Belgian rivers - Rhine, Main, Moselle & Danube from Amsterdam to the Black Sea with  English, German, French & Spanish speaking passengers.</li>
                <li>The season starts in March and continues until January next year.</li>
                <li><span>Website: </span><a href="https://www.lueftner-cruises.com/en.html
                " target="_blank">Luftner Cruise Lines</a></li>
            <li class="jobSubtitle">Position: salary</li>
                <li><span>Purser</span> € 1,100.00</li>
                <li><span>Receptionist / Night receptionist</span> € 750.00</li>
                <li><span>Executive Chef</span> € 2,000.00</li>
                <li><span>Sous Chef</span> € 1,000.00</li>
                <li><span>Regular cooks/Gardemange, Breakfast cook</span>  € 750.00 -  € 950.00</li>
                <li><span>Pastry Chef</span> € 950.00</li>
                <li><span>Baker / night shifts only</span> / € 850.00</li>
                <li><span>Utility</span> € 650.00</li>
                <li><span>Maitre’D</span> € 1,000.00</li>
                <li><span>Bartender</span> € 750.00</li>
                <li><span>Bar & Restaurant waiter</span> € 700.00</li>
                <li><span>Housekeeper</span> € 900.00</li>
                <li><span>Cabin / Laundry steward</span> € 650.00</li>
                <li><span>Hairdresser & Shop assistant</span> * € 700.00</li>
                <li><span>Massage therapist</span> * € 700.00</li>
            <li class="jobSubtitle">Useful information</li>
                <li>Contracts are according to position availability, between 6 to 10 months, Cyprus contract</li>
                <li>Vacation -  depending on the ship, approx. 2 weeks in November as written in the individual contract of employment /</li>
                <li>Bonus system – if you complete your contract successfully you will receive a contract completion bonus & performance bonus /as written in the individual contract of employment /</li>
                <li>Travel expenses for joining and repatriating the vessel  will be reimbursed by the company at the end of your contract when completed</li>
                <li>Accommodation, meals on board & uniform - provided by the company</li>
                <li>You will be supposed to work 7 days per week, no days off</li>
                <li>Tips are a pool system, depending on the vessel approx. €400 – €500 /monthly</li>
                <li>Additional personal tips on hand by the customer as well.</li>
                <li>Medical insurance – by Bulstrad</li>
                <li>If you complete your first contract correctly, you can expect to receive an invitation for next season.</li>
        </ul>',
    'jobs_modal4' => '<ul>
            <li class="jobSubtitle">Job description<li>
        	<li>Contracts are according to position availability, ranging between 6 to 10 months (with paid holiday days, collecting days and you can go on holiday in discussion with your hotel manager on board) with 2 by 2 week (1 month) vacation during the contract and can be renewed unlimited upon successful completion. </li>
        	<li>Uniforms are provided (100/150 EU) will be deducted from the first salary. (Working shirts will be provided by the company as well and they belong to you. Per shirt 25€ will be deducted without reimbursement because of hygienic reasons. They are your belonging) After the contract the uniform is returned and money will be reimbursed if feasible.</li>
        	<li>During the course of your contract - you will be insured by Allianz!.</li>
        	<li>Approximately 10 - 14 working hours per day with afternoon rest and free time, 7 days per week.</li>
        	<li>If you complete your first contract correctly – you can expect to receive an invitation for another.</li>
        	<li>Tips are a pool system and depending on the guest, between € 300 - € 800 on a monthly base.</li>
            <li>Travel expenses – For the cost of the arrival journey Edelweiss Gastro will reimburse 150,00 Euro (if you have to travel to the Seine or the Rhone 190,00 Euro) after completion of the probation period of 90 days on board. This amount will not be reimbursed if the contract is terminated for any reason during the probation period.</li>
        	<li>Retirement benefits : Employees must be employed continuously for a  minimum of 5 years.</li>
        	<li>Languages requirements: English, German, Spanish or French</li>
                <li><span>Website: </span><a href="https://scylla.ch/en" target="_blank">Scylla/Edelweiss Gastro</a></li>
            <li class="jobSubtitle">Position: salary</li>
                <li class="text-danger">* Salary in EURO without tips included</li>
            	<li><span>Exc. Chef</span>	Individual	</li>
            	<li><span>Sous chef</span>	€ 1750 -1900	</li>
            	<li><span>Junior Sous chef</span>	€ 1.625,00	</li>
            	<li><span>Chef de Partie</span>	€ 1.500,00	</li>
            	<li><span>Demichef de partie</span>	€ 1.300,00	</li>
            	<li><span>Pastry chef</span>	€ 1.625,00	</li>
            	<li><span>Commis de Cuisine</span>	€ 1.100,00	</li>
            	<li><span>Utility</span>	€ 950,00	</li>
            	<li><span>Hotel manager</span>	Individual	</li>
            	<li><span>Ass HM</span>	€ 1.650,00	</li>
            	<li><span>1st Receptionist</span>	€ 1.250,00	</li>
            	<li><span>Receptionist</span>	€ 1.050,00	</li>
            	<li><span>Night watch</span>	€ 1.050,00	</li>
            	<li><span>Maitre’D</span>	€ 1.650,00	</li>
            	<li><span>Bar Manager</span>	€ 1.250,00	</li>
            	<li><span>Waiter (bar/restaurant)</span>	€ 1.100,00 (€ 950,00 probation period 90 days)</li>
            	<li><span>Jumper</span>	€ 1.150,00	</li>
            	<li><span>Head housekeeping</span>	€ 1.250,00	</li>
            	<li><span>Housekeeping</span>	€ 950,00 (€ 825,00 probation period 90 days)</li>
            	<li><span>Spa</span>	€ 1.050,00	</li>
	            <li><span>Musician</span>	Individual</li>
            <li class="jobSubtitle">Requirements</li>
                <li>Experience – minimum 1 -2 years of experience on the position you are applying for, no experience required for dishwashers/kitchen porters</li>
                <li>English language basic level is mandatory, German language is a bonus</li>
        </ul>',
    'jobs_modal5' => '
        <ul>
            <li class="jobSubtitle">Job description<li>
                <li>At Anqor Team Limited is a company located in Cyprus and provides managerial services on what concerns the catering service on board on river cruise ships.</li>
                <li>The ships are 3* 4* 5* sailing along the European rivers with German, English and Spanish speaking passengers.</li>
                <li>The season starts in March and continues until January next year.</li>
                <li>Salaries: Based on Net Rate paid at each calendar month and under the Cypriot Law. Salaries differ from vessels to vessel (3*, 4*, 5*). Salaries may change by the company and are based upon candidate’s experiences and qualifications.</li>
                <li class="text-danger">Tips: Depending on passengers and we cannot guarantee, estimated €300-600 cash on board per month</li>
                <li>Holidays: 4 days Holiday per month, that can been used as a 14 days break after spending on board a period of 2-3 months. Travel expenses for holidays are at the employee expense </li>
                <li>Medical Insurance: Covered by the company with Allianz Worldwide care</li>
                <li>Cost of Living: Free food and shared accommodation is provided free of charged by the company</li>
                <li>Travel arrangements: One way embarkation tickets needs to be arranged by the employees for confirmation of their arrival. Company will reimburse travel expenses up to maximum amount of €250 at the end of their contracts upon successful completion of their employment contracts. End of the season tickets will be covered by the company.</li>
                <li><span>Website: </span><a href="https://anqor.eu/" target="_blank">Anqor River Cruises</a></li>
            <li class="jobSubtitle">Position: salary</li>
                <li class="text-danger">* Salary in EURO without tips included</li>
 <li><span>Hotel Manager</span> €2,300.00 – €2,500.00</li>
                <li><span>Bar Manager</span> €1,100.00 - €1,250.00</li>
                <li><span>Bartender</span> €1,000.00 - €1,150.00</li>
                <li><span>Frontdesk Manager</span> €1,200.00</li>
                <li><span>Accommodations Manager</span> €1,100.00</li>
                <li><span>Receptionist</span> €1,000.00</li>
                <li><span>F + B Waiter/ress</span> €950.00</li>
                <li><span>Laundry Steward/ess</span> €950.00</li>
                <li><span>Cabin Steward/ess</span> €900.00</li>
                <li><span>Maître</span> €1,350.00</li>
                <li><span>Night Watch</span> €950.00</li>
                <li><span>Chef de Partie</span> €1,500.00</li>
                <li><span>Commis de Cuisine</span> €1000.00</li>
                <li><span>Demi Chef de Partie</span> €1,100.00</li>
                <li><span>Executive Chef</span> €2,500.00</li>
                <li><span>Kitchen Steward</span> €950.00</li>
                <li><span>Sous Chef</span> €1.600.00</li>
                <li><span>Pastry Chef</span> €1,200.00 - €1,600.00</li>
            <li class="jobSubtitle">Requirements</li>
                <li>Experience – minimum 1 -2 years of experience on the position you are applying for, no experience required for dishwashers/kitchen porters</li>
                <li>English language basic level is mandatory, German language is a bonus</li>
        </ul>',
    'jobs_modal6' => '
        <ul>
            <li class="jobSubtitle">Job description<li>
                <li>Long term contract of employment, you can work every year February-December</li>
                <li>Residence in one of our company owned apartments , shared with another 1-2 staff members.</li>
                <li>One day off per week, 8 hours working time per day with extra 30 minutes for food break</li>
                <li>Social insurance contribution, paid by the Employer.</li>
                <li>Medical insurance through one of Cyprus Labour Unions.</li>
                <li>Annual leave as per Cyprus existing legislation. </li>
                <li>Free transportation, from airport of arrival in Cyprus to company residence apartments. Free transportation from and to the workplace.</li>
                <li>Provision of work uniform (shoes not included). Provision of food at working time.</li>
                <li>Provision of 25 EURO - per person per month for electricity cost (payable directly by the Employer to Electricity authority ) plus water and other municipal charges.</li>
                <li>Possibility of building your career, training and experience with multicultural staff and customers and upgrading your job position at future.</li>
                <li><span>Website: </span><a href="https://www.cbh-cyprus.com/" target="_blank">Constantinou Bros Hotels</a></li>
            <li class="jobSubtitle">Position: salary</li>
                <li class="text-danger">The Service department will have extra hand tips approximately €50.00-€100.00 per month</li>
                <li><span>Service departments (Bar and Restaurant)</span>: €700.00 - €1200.00 depending of their experience</li>
                <li><span>Guest services</span>: €700.00 - €1400.00 depending of their experience</li>
                <li><span>Front Office</span>: €700.00 - €1100.00 depending of their experience.</li>
                <li><span>Kitchen-cooks</span>: €700.00 - €1500.00 depending of their experience.</li>
        </ul>',
];
