struct pt {
    double x, y;
    pt() {}
    pt(double x, double y): x(x), y(y) {}
    bool operator == (pt const& t) const {
        return x == t.x && y == t.y;
    }
};

struct ConvexHull {
    vector<pt> points;
    vector<pt> convex_hull;
    vector<pt> convex_hull_collinear;
};

vector<ConvexHull> convex_hulls = {
    // 1 |1   2  1 |1   2
    // 0 |0 * 3  0 |0 4 3
    // y +-----  y +-----
    //  x 0 1 2   x 0 1 2
    {{{0,0},{1,0},{2,0},{0,1},{2,1}},
     {{0,0},{0,1},{2,1},{2,0}},
     {{0,0},{0,1},{2,1},{2,0},{1,0}}},
    {{{0,3},{1,1},{2,2},{4,4},{0,0},{1,2},{3,1},{3,3}},
     {{0,0},{0,3},{4,4},{3,1}},
     {{0,0},{0,3},{4,4},{3,1}}},
    {{{0,0},{0,8},{1,6},{3,1},{6,6},{8,0},{8,8}},
     {{0,0},{0,8},{8,8},{8,0}},
     {{0,0},{0,8},{8,8},{8,0}}},
    {{{2,6},{3,2},{6,6},{0,0},{0,11},{1,1},{1,9},{7,1},{7,9},{8,10},{8,0}},
     {{0,0},{0,11},{8,10},{8,0}},
     {{0,0},{0,11},{8,10},{8,0}}},
    {{{0,0},{0,1},{1,0},{1,1}},
     {{0,0},{0,1},{1,1},{1,0}},
     {{0,0},{0,1},{1,1},{1,0}}},
    {{{0,0},{1,0},{2,0},{2,1},{0,1}},
     {{0,0},{0,1},{2,1},{2,0}},
     {{0,0},{0,1},{2,1},{2,0},{1,0}}},
    {{{101,100},{102,100},{103,100},{104,100},{105,100},{106,100},{107,100},{108,100},{109,100},{110,100},{110,101},{110,102},{110,103},{110,104},{110,105},{110,106},{110,107},{110,108},{110,109},{110,110},{109,110},{108,110},{107,110},{106,110},{105,110},{104,110},{103,110},{102,110},{101,110},{100,110},{100,109},{100,108},{100,107},{100,106},{100,105},{100,104},{100,103},{100,102},{100,101},{100,100}},
     {{100,100},{100,110},{110,110},{110,100}},
     {{100,100},{100,101},{100,102},{100,103},{100,104},{100,105},{100,106},{100,107},{100,108},{100,109},{100,110},{101,110},{102,110},{103,110},{104,110},{105,110},{106,110},{107,110},{108,110},{109,110},{110,110},{110,109},{110,108},{110,107},{110,106},{110,105},{110,104},{110,103},{110,102},{110,101},{110,100},{109,100},{108,100},{107,100},{106,100},{105,100},{104,100},{103,100},{102,100},{101,100}}},
    {{{56,57},{43,58},{53,50},{59,60},{55,44},{39,38},{37,50},{53,46},{61,50},{38,63},{46,55},{46,50},{56,43},{45,50},{45,56},{52,47},{40,61},{55,56},{57,42},{60,61},{54,55},{57,58},{58,50},{52,53},{56,50},{44,43},{62,50},{58,41},{42,59},{44,57},{60,39},{41,40},{55,50},{47,54},{43,42},{58,59},{44,50},{40,50},{38,37},{60,50},{46,45},{54,50},{62,63},{40,39},{43,50},{63,50},{61,62},{41,60},{62,37},{47,46},{41,50},{38,50},{47,50},{42,41},{45,44},{61,38},{48,53},{48,47},{59,40},{59,50},{57,50},{42,50},{54,45},{39,50},{39,62},{53,54}},
     {{38,37},{37,50},{38,63},{62,63},{63,50},{62,37}},
     {{38,37},{37,50},{38,63},{62,63},{63,50},{62,37}}},
    {{{52,49},{88,100},{142,55},{64,61},{82,100},{130,133},{151,100},{121,100},{151,154},{121,124},{91,112},{142,145},{124,100},{67,64},{124,73},{112,85},{118,121},{112,115},{145,148},{55,100},{79,100},{55,52},{46,100},{130,100},{67,136},{109,88},{76,73},{82,79},{43,100},{88,115},{115,82},{109,112},{133,136},{88,85},{94,91},{49,46},{61,58},{85,82},{151,46},{130,67},{148,49},{157,100},{145,100},{154,100},{154,157},{139,142},{91,88},{67,100},{70,133},{127,100},{73,130},{64,139},{112,100},{139,100},{94,109},{82,121},{121,76},{142,100},{136,139},{115,118},{148,100},{76,100},{79,124},{85,100},{76,127},{139,58},{109,100},{118,79},{46,157},{55,148},{136,100},{70,67},{136,61},{61,100},{133,64},{91,100},{49,100},{145,52},{118,100},{73,100},{52,151},{52,100},{70,100},{85,118},{58,145},{127,70},{61,142},{148,151},{46,43},{115,100},{79,76},{64,100},{49,154},{58,100},{106,91},{106,109},{73,70},{124,127},{154,43},{58,55},{133,100},{127,130}},
     {{46,43},{43,100},{46,157},{154,157},{157,100},{154,43}},
     {{46,43},{43,100},{46,157},{154,157},{157,100},{154,43}}},
    {{{100,92},{95,100},{101,100},{86,100},{100,93},{114,100},{100,95},{108,100},{99,100},{100,111},{115,100},{100,108},{100,102},{100,91},{103,100},{100,99},{100,86},{100,107},{91,100},{100,103},{113,100},{100,97},{100,112},{100,104},{92,100},{100,94},{100,109},{98,100},{90,100},{88,100},{100,110},{100,106},{100,105},{100,85},{100,87},{111,100},{97,100},{85,100},{105,100},{100,101},{100,89},{100,96},{100,115},{104,100},{107,100},{94,100},{100,114},{100,88},{110,100},{100,113},{93,100},{100,90},{100,98},{89,100},{102,100},{96,100},{106,100},{109,100},{112,100},{87,100}},
     {{100,85},{85,100},{100,115},{115,100}},
     {{100,85},{85,100},{100,115},{115,100}}},
    {{{100,88},{110,100},{96,100},{134,100},{90,100},{84,100},{100,80},{104,100},{80,100},{100,72},{100,122},{100,110},{140,100},{100,134},{100,98},{54,100},{100,82},{100,94},{108,100},{116,100},{100,140},{112,100},{100,64},{92,100},{128,100},{138,100},{100,60},{100,128},{100,68},{100,74},{120,100},{100,102},{100,136},{100,132},{58,100},{76,100},{130,100},{124,100},{100,76},{100,96},{142,100},{106,100},{100,86},{146,100},{100,126},{100,58},{100,84},{100,106},{100,146},{114,100},{100,90},{60,100},{100,124},{100,104},{100,92},{144,100},{100,62},{100,108},{136,100},{62,100},{100,114},{100,78},{100,54},{100,118},{102,100},{78,100},{88,100},{100,116},{74,100},{100,138},{98,100},{118,100},{82,100},{132,100},{94,100},{122,100},{66,100},{100,56},{100,112},{86,100},{126,100},{100,144},{68,100},{64,100},{100,66},{100,142},{56,100},{72,100},{100,120},{100,130},{70,100},{100,70}},
     {{100,54},{54,100},{100,146},{146,100}},
     {{100,54},{54,100},{100,146},{146,100}}},
    {{{4,7},{4,6}, {4,5}, {4,4}, {4,3}, {4,1}, {4,0}, {4,9}, {4,8}, {5,10}, {2,0}, {2,3}, {2,2}, {2,5}, {2,4}, {2,7}, {2,6}, {2,9}, {2,8}, {0,3}, {0,2}, {0,1}, {0,0}, {0,7}, {0,5}, {0,4}, {0,9}, {10,10}, {5,1}, {9,2}, {9,0}, {9,1}, {9,6}, {9,7}, {9,4}, {0,10}, {9,8}, {9,9}, {10,9}, {10,8}, {10,7}, {10,5}, {10,3}, {10,2}, {10,1}, {7,9}, {7,4}, {7,5}, {7,6}, {7,7}, {7,0}, {7,1}, {7,2}, {7,3}, {2,10}, {6,10}, {5,8}, {5,9}, {5,6}, {5,4}, {5,2}, {5,3}, {5,0}, {8,10}, {3,9}, {3,1}, {3,2}, {3,3}, {3,4}, {3,5}, {3,6}, {3,7}, {1,9}, {1,2}, {1,3}, {1,0}, {1,1}, {1,6}, {1,7}, {1,4}, {1,10}, {4,10}, {9,10}, {9,5}, {7,10}, {8,9}, {8,3}, {8,7}, {8,6}, {8,5}, {8,4}, {6,5}, {6,4}, {6,0}, {6,3}, {6,2}, {6,9}, {6,8}, {3,10}},
    {{0,0},{0,10},{10,10},{10,1},{9,0}},
    {{0,0},{0,1},{0,2},{0,3},{0,4},{0,5},{0,7},{0,9},{0,10},{1,10},{2,10},{3,10},{4,10},{5,10},{6,10},{7,10},{8,10},{9,10},{10,10},{10,9},{10,8},{10,7},{10,5},{10,3},{10,2},{10,1},{9,0},{7,0},{6,0},{5,0},{4,0},{2,0},{1,0}}},
    // degenerate cases (single line)
    {{{0,0},{1,1},{2,2}},
     {{0,0},{2,2}},
     {{2,2},{1,1},{0,0}}},
    {{{0,0},{1,1},{2,2},{3,3}},
     {{0,0},{3,3}},
     {{3,3},{2,2},{1,1},{0,0}}},
    {{{0,0},{0,1},{0,2},{0,3}},
     {{0,0},{0,3}},
     {{0,3},{0,2},{0,1},{0,0}}},
    {{{0,0},{1,0},{2,0},{3,0}},
     {{0,0},{3,0}},
     {{3,0},{2,0},{1,0},{0,0}}},
    {{{0,0},{1,1},{2,2},{0,2}},
     {{0,0},{0,2},{2,2}},
     {{2,2},{1,1},{0,0},{0,2}}},
};
