//
//  QueryFactory.swift
//  CouchbaseLite
//
//  Copyright (c) 2022 Couchbase, Inc All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

import Foundation

/// The QueryFactory interface defines a function for creating a query from the given SQL string.
public protocol QueryFactory {
    /// Creates a Query object from the given query string.
    ///
    /// - Parameter query: Query string
    /// - Returns: A query created by the given query string.
    /// - Throws: An error on when the given query string is invalid.
    func createQuery(_ query: String) throws -> Query
}
