//
//  DatabaseEndpoint.swift
//  CouchbaseLite
//
//  Copyright (c) 2018 Couchbase, Inc. All rights reserved.
//
//  Licensed under the Couchbase License Agreement (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//  https://info.couchbase.com/rs/302-GJY-034/images/2017-10-30_License_Agreement.pdf
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//


import Foundation

#if COUCHBASE_ENTERPRISE
/// Database based replication target endpoint. Available in the Enterprise Edition only.
public struct DatabaseEndpoint: IEndpoint {
    
    /// The database object.
    public let database: Database
    
    /// Initializes the DatabaseEndpoint with the database object.
    ///
    /// - Parameter database: The database object.
    public init(database: Database) {
        self.database = database
    }
    
    // MARK: Internal
    
    func toImpl() -> CBLEndpoint {
        return CBLDatabaseEndpoint(database: self.database._impl)
    }
}
#endif
