//
//  CBLQuantifiedExpression.h
//  CouchbaseLite
//
//  Copyright (c) 2017 Couchbase, Inc All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import <Foundation/Foundation.h>
#import "CBLQueryExpression.h"
@class CBLQueryVariableExpression;

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, CBLQuantifiedType) {
    CBLQuantifiedTypeAny,
    CBLQuantifiedTypeAnyAndEvery,
    CBLQuantifiedTypeEvery
};

@interface CBLQuantifiedExpression : CBLQueryExpression

- (instancetype) initWithType: (CBLQuantifiedType)type
                     variable: (CBLQueryVariableExpression*)variable
                           in: (CBLQueryExpression*)inExpression
                    satisfies: (CBLQueryExpression*)satisfies;

@end

NS_ASSUME_NONNULL_END
