//
//  CBLPropertyExpression.h
//  CouchbaseLite
//
//  Copyright (c) 2017 Couchbase, Inc All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import <Foundation/Foundation.h>
#import "CBLQueryExpression.h"

NS_ASSUME_NONNULL_BEGIN

extern NSString* const kCBLAllPropertiesName;

@interface CBLPropertyExpression : CBLQueryExpression

@property(nonatomic, readonly) NSString* keyPath;

@property(nonatomic, readonly, nullable) NSString* from; // Data Source Alias

- (instancetype) initWithKeyPath: (NSString*)keyPath from: (nullable NSString*)from;

+ (instancetype) allFrom: (nullable NSString*)from;

@end

NS_ASSUME_NONNULL_END
