//
//  CBLIndexSpec.h
//  CouchbaseLite
//
//  Copyright (c) 2021 Couchbase, Inc All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import <Foundation/Foundation.h>
#import "c4.h"

NS_ASSUME_NONNULL_BEGIN

@protocol CBLIndexSpec <NSObject>

@property (nonatomic, readonly) C4QueryLanguage queryLanguage;
@property (nonatomic, readonly) C4IndexType indexType;
@property (readonly) NSString* getIndexSpecs;
@property (readonly) C4IndexOptions indexOptions;

- (instancetype) initWithIndexType: (C4IndexType)indexType
                     queryLanguage: (C4QueryLanguage)language;

@end

NS_ASSUME_NONNULL_END
