//
//  Unicode.UTF32.CodeUnit+BlockName.swift
//  CharacterInfo
//
//  CotEditor
//  https://coteditor.com
//
//  Created by 1024jp on 2018-08-13.
//
//  ---------------------------------------------------------------------------
//
//  © 2018-2024 1024jp
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  https://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

extension Unicode.UTF32.CodeUnit {
    
    /// Unicode block name.
    ///
    /// Based on Unicode 15.0.0 (2022-01-28)
    /// cf. <https://www.unicode.org/Public/UNIDATA/Blocks.txt>
    var blockName: String? {
        
        switch self {
            case 0x0000...0x007F: "Basic Latin"
            case 0x0080...0x00FF: "Latin-1 Supplement"
            case 0x0100...0x017F: "Latin Extended-A"
            case 0x0180...0x024F: "Latin Extended-B"
            case 0x0250...0x02AF: "IPA Extensions"
            case 0x02B0...0x02FF: "Spacing Modifier Letters"
            case 0x0300...0x036F: "Combining Diacritical Marks"
            case 0x0370...0x03FF: "Greek and Coptic"
            case 0x0400...0x04FF: "Cyrillic"
            case 0x0500...0x052F: "Cyrillic Supplement"
            case 0x0530...0x058F: "Armenian"
            case 0x0590...0x05FF: "Hebrew"
            case 0x0600...0x06FF: "Arabic"
            case 0x0700...0x074F: "Syriac"
            case 0x0750...0x077F: "Arabic Supplement"
            case 0x0780...0x07BF: "Thaana"
            case 0x07C0...0x07FF: "NKo"
            case 0x0800...0x083F: "Samaritan"
            case 0x0840...0x085F: "Mandaic"
            case 0x0860...0x086F: "Syriac Supplement"
            case 0x0870...0x089F: "Arabic Extended-B"
            case 0x08A0...0x08FF: "Arabic Extended-A"
            case 0x0900...0x097F: "Devanagari"
            case 0x0980...0x09FF: "Bengali"
            case 0x0A00...0x0A7F: "Gurmukhi"
            case 0x0A80...0x0AFF: "Gujarati"
            case 0x0B00...0x0B7F: "Oriya"
            case 0x0B80...0x0BFF: "Tamil"
            case 0x0C00...0x0C7F: "Telugu"
            case 0x0C80...0x0CFF: "Kannada"
            case 0x0D00...0x0D7F: "Malayalam"
            case 0x0D80...0x0DFF: "Sinhala"
            case 0x0E00...0x0E7F: "Thai"
            case 0x0E80...0x0EFF: "Lao"
            case 0x0F00...0x0FFF: "Tibetan"
            case 0x1000...0x109F: "Myanmar"
            case 0x10A0...0x10FF: "Georgian"
            case 0x1100...0x11FF: "Hangul Jamo"
            case 0x1200...0x137F: "Ethiopic"
            case 0x1380...0x139F: "Ethiopic Supplement"
            case 0x13A0...0x13FF: "Cherokee"
            case 0x1400...0x167F: "Unified Canadian Aboriginal Syllabics"
            case 0x1680...0x169F: "Ogham"
            case 0x16A0...0x16FF: "Runic"
            case 0x1700...0x171F: "Tagalog"
            case 0x1720...0x173F: "Hanunoo"
            case 0x1740...0x175F: "Buhid"
            case 0x1760...0x177F: "Tagbanwa"
            case 0x1780...0x17FF: "Khmer"
            case 0x1800...0x18AF: "Mongolian"
            case 0x18B0...0x18FF: "Unified Canadian Aboriginal Syllabics Extended"
            case 0x1900...0x194F: "Limbu"
            case 0x1950...0x197F: "Tai Le"
            case 0x1980...0x19DF: "New Tai Lue"
            case 0x19E0...0x19FF: "Khmer Symbols"
            case 0x1A00...0x1A1F: "Buginese"
            case 0x1A20...0x1AAF: "Tai Tham"
            case 0x1AB0...0x1AFF: "Combining Diacritical Marks Extended"
            case 0x1B00...0x1B7F: "Balinese"
            case 0x1B80...0x1BBF: "Sundanese"
            case 0x1BC0...0x1BFF: "Batak"
            case 0x1C00...0x1C4F: "Lepcha"
            case 0x1C50...0x1C7F: "Ol Chiki"
            case 0x1C80...0x1C8F: "Cyrillic Extended-C"
            case 0x1C90...0x1CBF: "Georgian Extended"
            case 0x1CC0...0x1CCF: "Sundanese Supplement"
            case 0x1CD0...0x1CFF: "Vedic Extensions"
            case 0x1D00...0x1D7F: "Phonetic Extensions"
            case 0x1D80...0x1DBF: "Phonetic Extensions Supplement"
            case 0x1DC0...0x1DFF: "Combining Diacritical Marks Supplement"
            case 0x1E00...0x1EFF: "Latin Extended Additional"
            case 0x1F00...0x1FFF: "Greek Extended"
            case 0x2000...0x206F: "General Punctuation"
            case 0x2070...0x209F: "Superscripts and Subscripts"
            case 0x20A0...0x20CF: "Currency Symbols"
            case 0x20D0...0x20FF: "Combining Diacritical Marks for Symbols"
            case 0x2100...0x214F: "Letterlike Symbols"
            case 0x2150...0x218F: "Number Forms"
            case 0x2190...0x21FF: "Arrows"
            case 0x2200...0x22FF: "Mathematical Operators"
            case 0x2300...0x23FF: "Miscellaneous Technical"
            case 0x2400...0x243F: "Control Pictures"
            case 0x2440...0x245F: "Optical Character Recognition"
            case 0x2460...0x24FF: "Enclosed Alphanumerics"
            case 0x2500...0x257F: "Box Drawing"
            case 0x2580...0x259F: "Block Elements"
            case 0x25A0...0x25FF: "Geometric Shapes"
            case 0x2600...0x26FF: "Miscellaneous Symbols"
            case 0x2700...0x27BF: "Dingbats"
            case 0x27C0...0x27EF: "Miscellaneous Mathematical Symbols-A"
            case 0x27F0...0x27FF: "Supplemental Arrows-A"
            case 0x2800...0x28FF: "Braille Patterns"
            case 0x2900...0x297F: "Supplemental Arrows-B"
            case 0x2980...0x29FF: "Miscellaneous Mathematical Symbols-B"
            case 0x2A00...0x2AFF: "Supplemental Mathematical Operators"
            case 0x2B00...0x2BFF: "Miscellaneous Symbols and Arrows"
            case 0x2C00...0x2C5F: "Glagolitic"
            case 0x2C60...0x2C7F: "Latin Extended-C"
            case 0x2C80...0x2CFF: "Coptic"
            case 0x2D00...0x2D2F: "Georgian Supplement"
            case 0x2D30...0x2D7F: "Tifinagh"
            case 0x2D80...0x2DDF: "Ethiopic Extended"
            case 0x2DE0...0x2DFF: "Cyrillic Extended-A"
            case 0x2E00...0x2E7F: "Supplemental Punctuation"
            case 0x2E80...0x2EFF: "CJK Radicals Supplement"
            case 0x2F00...0x2FDF: "Kangxi Radicals"
            case 0x2FF0...0x2FFF: "Ideographic Description Characters"
            case 0x3000...0x303F: "CJK Symbols and Punctuation"
            case 0x3040...0x309F: "Hiragana"
            case 0x30A0...0x30FF: "Katakana"
            case 0x3100...0x312F: "Bopomofo"
            case 0x3130...0x318F: "Hangul Compatibility Jamo"
            case 0x3190...0x319F: "Kanbun"
            case 0x31A0...0x31BF: "Bopomofo Extended"
            case 0x31C0...0x31EF: "CJK Strokes"
            case 0x31F0...0x31FF: "Katakana Phonetic Extensions"
            case 0x3200...0x32FF: "Enclosed CJK Letters and Months"
            case 0x3300...0x33FF: "CJK Compatibility"
            case 0x3400...0x4DBF: "CJK Unified Ideographs Extension A"
            case 0x4DC0...0x4DFF: "Yijing Hexagram Symbols"
            case 0x4E00...0x9FFF: "CJK Unified Ideographs"
            case 0xA000...0xA48F: "Yi Syllables"
            case 0xA490...0xA4CF: "Yi Radicals"
            case 0xA4D0...0xA4FF: "Lisu"
            case 0xA500...0xA63F: "Vai"
            case 0xA640...0xA69F: "Cyrillic Extended-B"
            case 0xA6A0...0xA6FF: "Bamum"
            case 0xA700...0xA71F: "Modifier Tone Letters"
            case 0xA720...0xA7FF: "Latin Extended-D"
            case 0xA800...0xA82F: "Syloti Nagri"
            case 0xA830...0xA83F: "Common Indic Number Forms"
            case 0xA840...0xA87F: "Phags-pa"
            case 0xA880...0xA8DF: "Saurashtra"
            case 0xA8E0...0xA8FF: "Devanagari Extended"
            case 0xA900...0xA92F: "Kayah Li"
            case 0xA930...0xA95F: "Rejang"
            case 0xA960...0xA97F: "Hangul Jamo Extended-A"
            case 0xA980...0xA9DF: "Javanese"
            case 0xA9E0...0xA9FF: "Myanmar Extended-B"
            case 0xAA00...0xAA5F: "Cham"
            case 0xAA60...0xAA7F: "Myanmar Extended-A"
            case 0xAA80...0xAADF: "Tai Viet"
            case 0xAAE0...0xAAFF: "Meetei Mayek Extensions"
            case 0xAB00...0xAB2F: "Ethiopic Extended-A"
            case 0xAB30...0xAB6F: "Latin Extended-E"
            case 0xAB70...0xABBF: "Cherokee Supplement"
            case 0xABC0...0xABFF: "Meetei Mayek"
            case 0xAC00...0xD7AF: "Hangul Syllables"
            case 0xD7B0...0xD7FF: "Hangul Jamo Extended-B"
            case 0xD800...0xDB7F: "High Surrogates"
            case 0xDB80...0xDBFF: "High Private Use Surrogates"
            case 0xDC00...0xDFFF: "Low Surrogates"
            case 0xE000...0xF8FF: "Private Use Area"
            case 0xF900...0xFAFF: "CJK Compatibility Ideographs"
            case 0xFB00...0xFB4F: "Alphabetic Presentation Forms"
            case 0xFB50...0xFDFF: "Arabic Presentation Forms-A"
            case 0xFE00...0xFE0F: "Variation Selectors"
            case 0xFE10...0xFE1F: "Vertical Forms"
            case 0xFE20...0xFE2F: "Combining Half Marks"
            case 0xFE30...0xFE4F: "CJK Compatibility Forms"
            case 0xFE50...0xFE6F: "Small Form Variants"
            case 0xFE70...0xFEFF: "Arabic Presentation Forms-B"
            case 0xFF00...0xFFEF: "Halfwidth and Fullwidth Forms"
            case 0xFFF0...0xFFFF: "Specials"
            case 0x10000...0x1007F: "Linear B Syllabary"
            case 0x10080...0x100FF: "Linear B Ideograms"
            case 0x10100...0x1013F: "Aegean Numbers"
            case 0x10140...0x1018F: "Ancient Greek Numbers"
            case 0x10190...0x101CF: "Ancient Symbols"
            case 0x101D0...0x101FF: "Phaistos Disc"
            case 0x10280...0x1029F: "Lycian"
            case 0x102A0...0x102DF: "Carian"
            case 0x102E0...0x102FF: "Coptic Epact Numbers"
            case 0x10300...0x1032F: "Old Italic"
            case 0x10330...0x1034F: "Gothic"
            case 0x10350...0x1037F: "Old Permic"
            case 0x10380...0x1039F: "Ugaritic"
            case 0x103A0...0x103DF: "Old Persian"
            case 0x10400...0x1044F: "Deseret"
            case 0x10450...0x1047F: "Shavian"
            case 0x10480...0x104AF: "Osmanya"
            case 0x104B0...0x104FF: "Osage"
            case 0x10500...0x1052F: "Elbasan"
            case 0x10530...0x1056F: "Caucasian Albanian"
            case 0x10570...0x105BF: "Vithkuqi"
            case 0x10600...0x1077F: "Linear A"
            case 0x10780...0x107BF: "Latin Extended-F"
            case 0x10800...0x1083F: "Cypriot Syllabary"
            case 0x10840...0x1085F: "Imperial Aramaic"
            case 0x10860...0x1087F: "Palmyrene"
            case 0x10880...0x108AF: "Nabataean"
            case 0x108E0...0x108FF: "Hatran"
            case 0x10900...0x1091F: "Phoenician"
            case 0x10920...0x1093F: "Lydian"
            case 0x10980...0x1099F: "Meroitic Hieroglyphs"
            case 0x109A0...0x109FF: "Meroitic Cursive"
            case 0x10A00...0x10A5F: "Kharoshthi"
            case 0x10A60...0x10A7F: "Old South Arabian"
            case 0x10A80...0x10A9F: "Old North Arabian"
            case 0x10AC0...0x10AFF: "Manichaean"
            case 0x10B00...0x10B3F: "Avestan"
            case 0x10B40...0x10B5F: "Inscriptional Parthian"
            case 0x10B60...0x10B7F: "Inscriptional Pahlavi"
            case 0x10B80...0x10BAF: "Psalter Pahlavi"
            case 0x10C00...0x10C4F: "Old Turkic"
            case 0x10C80...0x10CFF: "Old Hungarian"
            case 0x10D00...0x10D3F: "Hanifi Rohingya"
            case 0x10E60...0x10E7F: "Rumi Numeral Symbols"
            case 0x10E80...0x10EBF: "Yezidi"
            case 0x10EC0...0x10EFF: "Arabic Extended-C"
            case 0x10F00...0x10F2F: "Old Sogdian"
            case 0x10F30...0x10F6F: "Sogdian"
            case 0x10F70...0x10FAF: "Old Uyghur"
            case 0x10FB0...0x10FDF: "Chorasmian"
            case 0x10FE0...0x10FFF: "Elymaic"
            case 0x11000...0x1107F: "Brahmi"
            case 0x11080...0x110CF: "Kaithi"
            case 0x110D0...0x110FF: "Sora Sompeng"
            case 0x11100...0x1114F: "Chakma"
            case 0x11150...0x1117F: "Mahajani"
            case 0x11180...0x111DF: "Sharada"
            case 0x111E0...0x111FF: "Sinhala Archaic Numbers"
            case 0x11200...0x1124F: "Khojki"
            case 0x11280...0x112AF: "Multani"
            case 0x112B0...0x112FF: "Khudawadi"
            case 0x11300...0x1137F: "Grantha"
            case 0x11400...0x1147F: "Newa"
            case 0x11480...0x114DF: "Tirhuta"
            case 0x11580...0x115FF: "Siddham"
            case 0x11600...0x1165F: "Modi"
            case 0x11660...0x1167F: "Mongolian Supplement"
            case 0x11680...0x116CF: "Takri"
            case 0x11700...0x1174F: "Ahom"
            case 0x11800...0x1184F: "Dogra"
            case 0x118A0...0x118FF: "Warang Citi"
            case 0x11900...0x1195F: "Dives Akuru"
            case 0x119A0...0x119FF: "Nandinagari"
            case 0x11A00...0x11A4F: "Zanabazar Square"
            case 0x11A50...0x11AAF: "Soyombo"
            case 0x11AB0...0x11ABF: "Unified Canadian Aboriginal Syllabics Extended-A"
            case 0x11AC0...0x11AFF: "Pau Cin Hau"
            case 0x11B00...0x11B5F: "Devanagari Extended-A"
            case 0x11C00...0x11C6F: "Bhaiksuki"
            case 0x11C70...0x11CBF: "Marchen"
            case 0x11D00...0x11D5F: "Masaram Gondi"
            case 0x11D60...0x11DAF: "Gunjala Gondi"
            case 0x11EE0...0x11EFF: "Makasar"
            case 0x11F00...0x11F5F: "Kawi"
            case 0x11FB0...0x11FBF: "Lisu Supplement"
            case 0x11FC0...0x11FFF: "Tamil Supplement"
            case 0x12000...0x123FF: "Cuneiform"
            case 0x12400...0x1247F: "Cuneiform Numbers and Punctuation"
            case 0x12480...0x1254F: "Early Dynastic Cuneiform"
            case 0x12F90...0x12FFF: "Cypro-Minoan"
            case 0x13000...0x1342F: "Egyptian Hieroglyphs"
            case 0x13430...0x1345F: "Egyptian Hieroglyph Format Controls"
            case 0x14400...0x1467F: "Anatolian Hieroglyphs"
            case 0x16800...0x16A3F: "Bamum Supplement"
            case 0x16A40...0x16A6F: "Mro"
            case 0x16A70...0x16ACF: "Tangsa"
            case 0x16AD0...0x16AFF: "Bassa Vah"
            case 0x16B00...0x16B8F: "Pahawh Hmong"
            case 0x16E40...0x16E9F: "Medefaidrin"
            case 0x16F00...0x16F9F: "Miao"
            case 0x16FE0...0x16FFF: "Ideographic Symbols and Punctuation"
            case 0x17000...0x187FF: "Tangut"
            case 0x18800...0x18AFF: "Tangut Components"
            case 0x18B00...0x18CFF: "Khitan Small Script"
            case 0x18D00...0x18D7F: "Tangut Supplement"
            case 0x1AFF0...0x1AFFF: "Kana Extended-B"
            case 0x1B000...0x1B0FF: "Kana Supplement"
            case 0x1B100...0x1B12F: "Kana Extended-A"
            case 0x1B130...0x1B16F: "Small Kana Extension"
            case 0x1B170...0x1B2FF: "Nushu"
            case 0x1BC00...0x1BC9F: "Duployan"
            case 0x1BCA0...0x1BCAF: "Shorthand Format Controls"
            case 0x1CF00...0x1CFCF: "Znamenny Musical Notation"
            case 0x1D000...0x1D0FF: "Byzantine Musical Symbols"
            case 0x1D100...0x1D1FF: "Musical Symbols"
            case 0x1D200...0x1D24F: "Ancient Greek Musical Notation"
            case 0x1D2C0...0x1D2DF: "Kaktovik Numerals"
            case 0x1D2E0...0x1D2FF: "Mayan Numerals"
            case 0x1D300...0x1D35F: "Tai Xuan Jing Symbols"
            case 0x1D360...0x1D37F: "Counting Rod Numerals"
            case 0x1D400...0x1D7FF: "Mathematical Alphanumeric Symbols"
            case 0x1D800...0x1DAAF: "Sutton SignWriting"
            case 0x1DF00...0x1DFFF: "Latin Extended-G"
            case 0x1E000...0x1E02F: "Glagolitic Supplement"
            case 0x1E030...0x1E08F: "Cyrillic Extended-D"
            case 0x1E100...0x1E14F: "Nyiakeng Puachue Hmong"
            case 0x1E290...0x1E2BF: "Toto"
            case 0x1E2C0...0x1E2FF: "Wancho"
            case 0x1E4D0...0x1E4FF: "Nag Mundari"
            case 0x1E7E0...0x1E7FF: "Ethiopic Extended-B"
            case 0x1E800...0x1E8DF: "Mende Kikakui"
            case 0x1E900...0x1E95F: "Adlam"
            case 0x1EC70...0x1ECBF: "Indic Siyaq Numbers"
            case 0x1ED00...0x1ED4F: "Ottoman Siyaq Numbers"
            case 0x1EE00...0x1EEFF: "Arabic Mathematical Alphabetic Symbols"
            case 0x1F000...0x1F02F: "Mahjong Tiles"
            case 0x1F030...0x1F09F: "Domino Tiles"
            case 0x1F0A0...0x1F0FF: "Playing Cards"
            case 0x1F100...0x1F1FF: "Enclosed Alphanumeric Supplement"
            case 0x1F200...0x1F2FF: "Enclosed Ideographic Supplement"
            case 0x1F300...0x1F5FF: "Miscellaneous Symbols and Pictographs"
            case 0x1F600...0x1F64F: "Emoticons"
            case 0x1F650...0x1F67F: "Ornamental Dingbats"
            case 0x1F680...0x1F6FF: "Transport and Map Symbols"
            case 0x1F700...0x1F77F: "Alchemical Symbols"
            case 0x1F780...0x1F7FF: "Geometric Shapes Extended"
            case 0x1F800...0x1F8FF: "Supplemental Arrows-C"
            case 0x1F900...0x1F9FF: "Supplemental Symbols and Pictographs"
            case 0x1FA00...0x1FA6F: "Chess Symbols"
            case 0x1FA70...0x1FAFF: "Symbols and Pictographs Extended-A"
            case 0x1FB00...0x1FBFF: "Symbols for Legacy Computing"
            case 0x20000...0x2A6DF: "CJK Unified Ideographs Extension B"
            case 0x2A700...0x2B73F: "CJK Unified Ideographs Extension C"
            case 0x2B740...0x2B81F: "CJK Unified Ideographs Extension D"
            case 0x2B820...0x2CEAF: "CJK Unified Ideographs Extension E"
            case 0x2CEB0...0x2EBEF: "CJK Unified Ideographs Extension F"
            case 0x2F800...0x2FA1F: "CJK Compatibility Ideographs Supplement"
            case 0x30000...0x3134F: "CJK Unified Ideographs Extension G"
            case 0x31350...0x323AF: "CJK Unified Ideographs Extension H"
            case 0xE0000...0xE007F: "Tags"
            case 0xE0100...0xE01EF: "Variation Selectors Supplement"
            case 0xF0000...0xFFFFF: "Supplementary Private Use Area-A"
            case 0x100000...0x10FFFF: "Supplementary Private Use Area-B"
                
            default: nil  // return nil instead of "No_Block"
        }
    }
}
