# Calling all contributors!
The Coronavirus Diary project is endeavoring to aid the COV-SARS-2 response
efforts by offering additional pre-screening capacity and data that can be used
in tracking the spread of the virus. The pandemic is expanding rapidly and this
project needs to ship as soon as possible.

The situation is escalating and we need your help!

You can help out by: 
- Reporting a bug
- Reviewing the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## Branches

We're using the following branches to manage work:
- `develop` is semi-stable and should be used as the branch to fork from
- `master` is stable and ready for prod (or it will be once we merge in the
  first release)
- `feature`, `bug` branches: unstable development

## How to report bugs
We use GitHub issues to track public bugs. Report a bug by [opening a new
issue](https://github.com/joshua-s/coronavirus-diary/issues/new/choose); it's
that easy!

### Write bug reports with detail, background, and sample code
**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
  - Be specific!
  - Give sample code if you can.
- What you expected to happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you
  tried that didn't work)

We <3 thorough bug reports.

## How to contribute code
We use GitHub to host code, to track issues and feature requests, as well as
accept pull requests.

Pull requests are the best way to propose changes to the codebase. We use a
loose version of Git Flow and actively welcome your pull requests:

1. Set up your local development environment. See [USAGE.md](USAGE.md) for
   instructions.
1. Make sure to use the latest Flutter stable-channel SDK release.
1. Create a new branch based on `develop`:
   - Feature branches should start with `feature/`
   - Bugfix branches should start with `bug/`
1. Implement your changes.
1. Add tests if applicable.
1. Make sure your code is clean:
    - If you modified an `*.arb` file, regenerate the internationalization
      code with (use the `dart` in the flutter install):
      ```
      $FLUTTER_ROOT/bin/cache/dart-sdk/bin/dart tools/gen_l10n.dart --arb-dir lib/src/l10n
      ```
    - If you modified any file paired with a `.g.dart` file, regenerate the
      `JsonSerializable` generated code with:
      ```
      flutter pub run build_runner build --delete-conflicting-outputs
      ```
    - Reformat the code with `flutter format .`
    - Check for analysis errors with `flutter analyze .` (Analysis warnings are
      also considered errors).
    - Verify all tests pass locally:
      ```
      # For unit tests
      flutter test

      # For driver tests
      flutter drive --target=test_driver/smoke_workflow.dart
      ```

1. Issue that pull request!

### Any contributions you make will be under the MIT Software License
When you submit code changes, your submissions are understood to be under the
same [MIT License](LICENSE) that covers the project.
