import { updateDates } from "@corejam/base/dist/Functions";
import { hashPassword } from "@corejam/plugin-auth/dist/server/Functions";
import { userEdit, users } from "@corejam/plugin-auth/dist/server/resolvers/db/faker/User";
import { roles, STATUS } from "@corejam/plugin-auth/dist/shared/types/User";
import { random } from "faker";
import { RegisterInput, UserDB } from "../../../../shared/types/User";

export async function userRegister(userInput: RegisterInput): Promise<UserDB> {
  const userObj: UserDB = {
    id: random.uuid(),
    email: userInput.email,
    firstName: userInput.firstName,
    lastName: userInput.lastName,
    password: await hashPassword(userInput.password),
    status: STATUS.PENDING,
    active: true,
    role: [roles.USER],
    ...updateDates(),
  };

  users.push(userObj);

  return userObj;
}

//We want a test account
userRegister({
  firstName: "test",
  lastName: "account",
  email: "test@test.com",
  password: "valid123Password@",
  passwordConfirm: "valid123Password@",
}).then((user) => {
  userEdit(user.id, {
    role: [roles.ADMIN],
    status: STATUS.VERIFIED,
  });
});
