import { canvasPageByUrl } from "@corejam/plugin-canvas/dist/server/resolvers/db/faker/CanvasPage";
import type { SEODocument } from "../../../../shared/types/Seo";
import { categoryByUrl } from "./Category";
import { manufacturerByUrl } from "./Manufacturer";
import { allProducts, productByUrl } from "./Product";

export async function objectFromURL(url: string): Promise<SEODocument> {
  const result = {
    category: await categoryByUrl(url),
    manufacturer: await manufacturerByUrl(url),
    product: await productByUrl(url),
    canvasPage: await canvasPageByUrl(url),
  };

  return new Promise((res) => res(result));
}

export async function getSEOIndex(): Promise<string[]> {
  const urls: string[] = [];

  const products = await allProducts();

  for (const product of products) {
    if (product.seo?.url) urls.push(product.seo?.url);
  }

  return new Promise((res) => res(urls));
}
