/*
 * @Author: Whzcorcd
 * @Date: 2020-12-04 17:03:31
 * @LastEditors: Whzcorcd
 * @LastEditTime: 2021-07-25 21:30:10
 * @Description: file content
 */
/* global __static */
import path from 'path'
import { app, protocol, BrowserWindow, ipcMain } from 'electron'
import { createProtocol } from 'vue-cli-plugin-electron-builder/lib'
import { addDefaultNavigation } from '../public/main/navigation'
import { checkUpdate } from './app/update'

const isDevelopment = process.env.NODE_ENV !== 'production'

app.commandLine.appendSwitch('ignore-certificate-errors')

// Scheme must be registered before the app is ready
protocol.registerSchemesAsPrivileged([
  { scheme: 'app', privileges: { secure: true, standard: true } }
])

let win = null

const createWindow = async () => {
  // Create the browser window.
  // eslint-disable-next-line no-param-reassign
  win = new BrowserWindow({
    width: 1400,
    height: 800,
    resizable: false,
    show: false,
    // frame: false,
    titleBarStyle: 'hidden',
    webPreferences: {
      contextIsolation: false,
      webSecurity: false,
      enableRemoteModule: true,
      nodeIntegration: process.env.ELECTRON_NODE_INTEGRATION
    },
    backgroundColor: '#fff',
    icon: path.join(__static, 'icon.png')
  })

  if (process.env.WEBPACK_DEV_SERVER_URL) {
    // Load the url of the dev server if in development mode
    await win.loadURL(process.env.WEBPACK_DEV_SERVER_URL)
    if (!process.env.IS_TEST) win.webContents.openDevTools()
  } else {
    createProtocol('app')
    // Load the index.html when not in development
    await win.loadURL('app://./index.html')
    // Auto update
    checkUpdate(win)
  }

  win.once('ready-to-show', () => {
    win.show()
  })
}

ipcMain.on('checkForUpdate', async () => {
  checkUpdate(win)
})

// Quit when all windows are closed.
app.on('window-all-closed', () => {
  // On macOS it is common for applications and their menu bar
  // to stay active until the user quits explicitly with Cmd + Q
  // if (process.platform !== 'darwin') {
  //   app.quit()
  // }
  app.quit()
})

app.on('activate', () => {
  // On macOS it's common to re-create a window in the app when the
  // dock icon is clicked and there are no other windows open.
  if (BrowserWindow.getAllWindows().length === 0) createWindow()
})

// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
app.on('ready', async () => {
  createWindow()

  addDefaultNavigation()
})

// Exit cleanly on request from parent process in development mode.
if (isDevelopment) {
  if (process.platform === 'win32') {
    process.on('message', data => {
      if (data === 'graceful-exit') {
        app.quit()
      }
    })
  } else {
    process.on('SIGTERM', () => {
      app.quit()
    })
  }
}
