#include<iostream>
#include<cstdio>
#include "stub.h"
#include "addr_any.h"

// g++ -g test_addr_any.cpp -std=c++11 -I../src -I../src/elfio/elfio -o test_addr_any

//This static function can be in another file or in another dynamic library, needed -g -O0 compile
static int foo()
{
    printf("I am foo\n");
    return 0;
}


int foo_stub()
{
    std::cout << "I am foo_stub" << std::endl;
    return 0;
}

int printf_stub(const char * format, ...)
{
    std::cout<< "I am printf_stub" << std::endl;
    return 0;
}

int main(int argc, char **argv)
{
    //Get application static function address
    {
        AddrAny any;
        
        std::map<std::string,void*> result;
        any.get_local_func_addr_symtab("^foo()$", result);
        
        foo();
        Stub stub;
        std::map<std::string,void*>::iterator it;
        for (it=result.begin(); it!=result.end(); ++it)
        {
            stub.set(it->second ,foo_stub);
            std::cout << it->first << " => " << it->second << std::endl;
        }
        foo();  
    
    }
    //Get dynamic library static function address
    {
        //AddrAny any("libc-2.27.so");// cat /proc/pid/maps
        AddrAny any("libc.so.6");// cat /proc/pid/maps     
        std::map<std::string,void*> result;
#ifdef __clang__ 
        any.get_global_func_addr_dynsym("^printf$", result);
#else
        any.get_weak_func_addr_dynsym("^puts", result);
#endif
        {
            foo();
            Stub stub;
            std::map<std::string,void*>::iterator it;
            for (it=result.begin(); it!=result.end(); ++it)
            {
                stub.set(it->second ,printf_stub);
                std::cout << it->first << " => " << it->second << std::endl;
            }
            foo();
        }
        foo();
    }
    return 0;
}

