<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output encoding="ISO-8859-1" media-type="text/plain" indent="yes"/>
	<xsl:include href="./EJBUtils.xsl"/>
	<xsl:template match="/child::*[local-name()='definitions']">
	<xsl:param name="project"><xsl:call-template name="getClassNameOfCurrent"/></xsl:param>
	<xsl:param name="projectName"><xsl:value-of select="@name"/></xsl:param>
package com.twinsoft.convertigo.ejb;

import javax.ejb.SessionBean;
import localhost.convertigo.projects.<xsl:value-of select="@name"/>.<xsl:value-of select="@name"/>_ws.*;

/**
 * Automatically generated by twinsoft Convertigo.
 */
public abstract class <xsl:call-template name="getClassNameOfCurrent"/>EJBBean implements SessionBean {
	
	java.net.URL convertigoServerAddress;
	
	private String context;

	public java.net.URL getConvertigoServerAddress() {
		return convertigoServerAddress;
	}

	public void setConvertigoServerAddress(java.net.URL convertigoServerAddress){
		this.convertigoServerAddress= convertigoServerAddress;
	}

<xsl:for-each select="child::*[local-name()='portType']/child::*[local-name()='operation']">
	public <xsl:call-template name="getResponseClass"/> t<xsl:value-of select="@name"/>(<xsl:call-template name="getTypeAndParameters"/>){ 
		try {
			<xsl:value-of select="$project"/>Locator myProject= new <xsl:value-of select="$project"/>Locator();
			<xsl:value-of select="$project"/>SoapPortType myTransactions= myProject.get<xsl:value-of select="$projectName"/>Soap(convertigoServerAddress);
			return  myTransactions.<xsl:call-template name="buildClassMethod"><xsl:with-param name="myMethod"><xsl:value-of select="@name"/></xsl:with-param></xsl:call-template>(<xsl:call-template name="getParameters"/>);
		}
		catch (Exception e) {
			System.out.println("Exception in <xsl:value-of select="@name"/> method : " + e.toString());
			return null;
		}
	}
	public <xsl:call-template name="getResponseClass"/> transaction_<xsl:value-of select="@name"/>(<xsl:call-template name="getTypeAndParameters"/>){ 
		return t<xsl:value-of select="@name"/>(<xsl:call-template name="getParameters"/>);
	}
</xsl:for-each>

	public void ejbCreate() {        
		try {
			convertigoServerAddress = new java.net.URL("http://localhost/convertigo/projects/<xsl:value-of select="@name"/>/<xsl:value-of select="@name"/>.ws");
		}
		catch (Exception e) {
			System.out.println("Exception in create() method : " +e);
		}
	}
	
	public void ejbCreate(java.net.URL portAddress) {        
		try {
			convertigoServerAddress = portAddress;
			// creation of a unique context string
			Object o= new Object();
			long currentTimeMillis = System.currentTimeMillis();
			context= o.toString().substring(o.toString().indexOf("@") + 1) + currentTimeMillis;
		}
		catch (Exception e) {
			System.out.println("Exception in create(java.net.URL) method: " +e);
		}
	}
}
	</xsl:template>
</xsl:stylesheet>
