/*
 * Copyright (c) 2001-2024 Convertigo SA.
 * 
 * This program  is free software; you  can redistribute it and/or
 * Modify  it  under the  terms of the  GNU  Affero General Public
 * License  as published by  the Free Software Foundation;  either
 * version  3  of  the  License,  or  (at your option)  any  later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY  or  FITNESS  FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program;
 * if not, see <http://www.gnu.org/licenses/>.
 */

package com.twinsoft.convertigo.eclipse.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import com.twinsoft.convertigo.eclipse.ConvertigoPlugin;
import com.twinsoft.convertigo.eclipse.wizards.import_export.ImportWizard;
import com.twinsoft.convertigo.engine.Engine;

public class ProjectExplorerImportAction extends MyAbstractAction {

	@Override
	public void run(IAction action) {
		if (!Engine.isStarted) {
			return;
		}
		Display display = Display.getDefault();
		Cursor waitCursor = new Cursor(display, SWT.CURSOR_WAIT);

		Shell shell = getParentShell();
		shell.setCursor(waitCursor);

		try {
			ImportWizard importWizard = new ImportWizard();
			importWizard.setWindowTitle("Convertigo project import Wizard");
			WizardDialog wzdlg = new WizardDialog(shell, importWizard);
			wzdlg.open();
		}
		catch (Throwable e) {
			ConvertigoPlugin.logException(e, "Unable to import project!");
		}
		finally {
			shell.setCursor(null);
			waitCursor.dispose();
		}
	}
}