export const convertigoTheme = {
	name: 'convertigo-theme',
	properties: {
		// =~= Theme Properties =~=
		'--theme-font-family-base': `system-ui`,
		'--theme-font-family-heading': `system-ui`,
		'--theme-font-color-base': '0 0 0',
		'--theme-font-color-dark': '255 255 255',
		'--theme-rounded-base': '4px',
		'--theme-rounded-container': '8px',
		'--theme-border-base': '0px',
		// =~= Theme On-X Colors =~=
		'--on-primary': '0 0 0',
		'--on-secondary': '255 255 255',
		'--on-tertiary': '0 0 0',
		'--on-success': '0 0 0',
		'--on-warning': '0 0 0',
		'--on-error': '255 255 255',
		'--on-surface': '255 255 255',
		// =~= Theme Colors  =~=
		// primary | #4285f4
		'--color-primary-50': '227 237 253', // #e3edfd
		'--color-primary-100': '217 231 253', // #d9e7fd
		'--color-primary-200': '208 225 252', // #d0e1fc
		'--color-primary-300': '179 206 251', // #b3cefb
		'--color-primary-400': '123 170 247', // #7baaf7
		'--color-primary-500': '66 133 244', // #4285f4
		'--color-primary-600': '59 120 220', // #3b78dc
		'--color-primary-700': '50 100 183', // #3264b7
		'--color-primary-800': '40 80 146', // #285092
		'--color-primary-900': '32 65 120', // #204178
		// secondary | #34a853
		'--color-secondary-50': '225 242 229', // #e1f2e5
		'--color-secondary-100': '214 238 221', // #d6eedd
		'--color-secondary-200': '204 233 212', // #cce9d4
		'--color-secondary-300': '174 220 186', // #aedcba
		'--color-secondary-400': '113 194 135', // #71c287
		'--color-secondary-500': '52 168 83', // #34a853
		'--color-secondary-600': '47 151 75', // #2f974b
		'--color-secondary-700': '39 126 62', // #277e3e
		'--color-secondary-800': '31 101 50', // #1f6532
		'--color-secondary-900': '25 82 41', // #195229
		// tertiary | #fbbc05
		'--color-tertiary-50': '254 245 218', // #fef5da
		'--color-tertiary-100': '254 242 205', // #fef2cd
		'--color-tertiary-200': '254 238 193', // #feeec1
		'--color-tertiary-300': '253 228 155', // #fde49b
		'--color-tertiary-400': '252 208 80', // #fcd050
		'--color-tertiary-500': '251 188 5', // #fbbc05
		'--color-tertiary-600': '226 169 5', // #e2a905
		'--color-tertiary-700': '188 141 4', // #bc8d04
		'--color-tertiary-800': '151 113 3', // #977103
		'--color-tertiary-900': '123 92 2', // #7b5c02
		// success | #34c759
		'--color-success-50': '225 247 230', // #e1f7e6
		'--color-success-100': '214 244 222', // #d6f4de
		'--color-success-200': '204 241 214', // #ccf1d6
		'--color-success-300': '174 233 189', // #aee9bd
		'--color-success-400': '113 216 139', // #71d88b
		'--color-success-500': '52 199 89', // #34c759
		'--color-success-600': '47 179 80', // #2fb350
		'--color-success-700': '39 149 67', // #279543
		'--color-success-800': '31 119 53', // #1f7735
		'--color-success-900': '25 98 44', // #19622c
		// warning | #ff9500
		'--color-warning-50': '255 239 217', // #ffefd9
		'--color-warning-100': '255 234 204', // #ffeacc
		'--color-warning-200': '255 229 191', // #ffe5bf
		'--color-warning-300': '255 213 153', // #ffd599
		'--color-warning-400': '255 181 77', // #ffb54d
		'--color-warning-500': '255 149 0', // #ff9500
		'--color-warning-600': '230 134 0', // #e68600
		'--color-warning-700': '191 112 0', // #bf7000
		'--color-warning-800': '153 89 0', // #995900
		'--color-warning-900': '125 73 0', // #7d4900
		// error | #ff3b30
		'--color-error-50': '255 226 224', // #ffe2e0
		'--color-error-100': '255 216 214', // #ffd8d6
		'--color-error-200': '255 206 203', // #ffcecb
		'--color-error-300': '255 177 172', // #ffb1ac
		'--color-error-400': '255 118 110', // #ff766e
		'--color-error-500': '255 59 48', // #ff3b30
		'--color-error-600': '230 53 43', // #e6352b
		'--color-error-700': '191 44 36', // #bf2c24
		'--color-error-800': '153 35 29', // #99231d
		'--color-error-900': '125 29 24', // #7d1d18
		// surface | #404040
		'--color-surface-50': '226 226 226', // #e2e2e2
		'--color-surface-100': '255 255 255', // IS THE WITE COLOR USED FOR THE PROJECT
		'--color-surface-200': '207 207 207', // #cfcfcf
		'--color-surface-300': '179 179 179', // #b3b3b3
		'--color-surface-400': '121 121 121', // #797979
		'--color-surface-500': '64 64 64', // #404040
		'--color-surface-600': '58 58 58', // #3a3a3a
		'--color-surface-700': '48 48 48', // #303030
		'--color-surface-800': '38 38 38', // #262626
		'--color-surface-900': '31 31 31' // #1f1f1f
	}
};
