import { BaseStyle, FileBubbleStyle, ImageBubbleStyle, TextBubbleStyle } from "@cometchat/uikit-elements";
import { CardBubbleStyle, CometChatMentionsFormatter, CometChatTextFormatter, CometChatUrlsFormatter, ComposerId, FormBubbleStyle, SchedulerBubbleStyle } from "@cometchat/uikit-shared";
import { CardMessage, CometChatActionsIcon, CometChatActionsView, CometChatDetailsTemplate, CometChatMessageComposerAction, CometChatMessageTemplate, CometChatTheme, FormMessage, MessageBubbleAlignment, SchedulerMessage } from "@cometchat/uikit-resources";
import { AIOptionsStyle } from "@cometchat/uikit-shared";
export declare abstract class DataSource {
    abstract getTextMessageOptions(loggedInUser: CometChat.User, messageObject: CometChat.BaseMessage, theme: CometChatTheme, group?: CometChat.Group): Array<CometChatActionsIcon | CometChatActionsView>;
    abstract getImageMessageOptions(loggedInUser: CometChat.User, messageObject: CometChat.BaseMessage, theme: CometChatTheme, group?: CometChat.Group): Array<CometChatActionsIcon | CometChatActionsView>;
    abstract getVideoMessageOptions(loggedInUser: CometChat.User, messageObject: CometChat.BaseMessage, theme: CometChatTheme, group?: CometChat.Group): Array<CometChatActionsIcon | CometChatActionsView>;
    abstract getAudioMessageOptions(loggedInUser: CometChat.User, messageObject: CometChat.BaseMessage, theme: CometChatTheme, group?: CometChat.Group): Array<CometChatActionsIcon | CometChatActionsView>;
    abstract getFileMessageOptions(loggedInUser: CometChat.User, messageObject: CometChat.BaseMessage, theme: CometChatTheme, group?: CometChat.Group): Array<CometChatActionsIcon | CometChatActionsView>;
    abstract getBottomView(message: CometChat.BaseMessage, alignment: MessageBubbleAlignment): any;
    abstract getTextMessageContentView(message: CometChat.TextMessage, alignment: MessageBubbleAlignment, theme: CometChatTheme, otherParams: any): any;
    abstract getImageMessageContentView(message: CometChat.MediaMessage, alignment: MessageBubbleAlignment, theme: CometChatTheme): any;
    abstract getVideoMessageContentView(message: CometChat.MediaMessage, alignment: MessageBubbleAlignment, theme: CometChatTheme): any;
    abstract getAudioMessageContentView(message: CometChat.MediaMessage, alignment: MessageBubbleAlignment, theme: CometChatTheme): any;
    abstract getFileMessageContentView(message: CometChat.MediaMessage, alignment: MessageBubbleAlignment, theme: CometChatTheme): any;
    abstract getFormMessageContentView(message: FormMessage, alignment: MessageBubbleAlignment, theme: CometChatTheme): any;
    abstract getSchedulerMessageContentView(message: SchedulerMessage, alignment: MessageBubbleAlignment, theme: CometChatTheme): any;
    abstract getCardMessageContentView(message: CardMessage, alignment: MessageBubbleAlignment, theme: CometChatTheme): any;
    abstract getTextMessageTemplate(theme: CometChatTheme, additionalConfigurations?: any): CometChatMessageTemplate;
    abstract getImageMessageTemplate(theme: CometChatTheme): CometChatMessageTemplate;
    abstract getVideoMessageTemplate(theme: CometChatTheme): CometChatMessageTemplate;
    abstract getAudioMessageTemplate(theme: CometChatTheme): CometChatMessageTemplate;
    abstract getFileMessageTemplate(theme: CometChatTheme): CometChatMessageTemplate;
    abstract getFormMessageTemplate(theme: CometChatTheme): CometChatMessageTemplate;
    abstract getSchedulerMessageTemplate(theme: CometChatTheme): CometChatMessageTemplate;
    abstract getCardMessageTemplate(theme: CometChatTheme): CometChatMessageTemplate;
    abstract getGroupActionTemplate(theme: CometChatTheme): CometChatMessageTemplate;
    abstract getAllMessageTemplates(theme?: CometChatTheme, additionalConfigurations?: any): Array<CometChatMessageTemplate>;
    abstract getMessageTemplate(messageType: string, messageCategory: string, theme?: CometChatTheme): CometChatMessageTemplate | null;
    abstract getMessageOptions(loggedInUser: CometChat.User, messageObject: CometChat.BaseMessage, theme: CometChatTheme, group?: CometChat.Group): Array<CometChatActionsIcon | CometChatActionsView>;
    abstract getCommonOptions(loggedInUser: CometChat.User, messageObject: CometChat.BaseMessage, theme: CometChatTheme, group?: CometChat.Group): Array<CometChatActionsIcon | CometChatActionsView>;
    abstract getAttachmentOptions(theme: CometChatTheme, id: ComposerId): CometChatMessageComposerAction[];
    abstract getAllMessageTypes(): Array<string>;
    abstract getAllMessageCategories(): Array<string>;
    abstract getAuxiliaryOptions(id: Map<String, any>, theme: CometChatTheme, user?: CometChat.User, group?: CometChat.Group): any;
    abstract getId(): string;
    abstract getDeleteMessageBubble(messageObject: CometChat.BaseMessage, theme: CometChatTheme, style?: TextBubbleStyle): any;
    abstract getGroupActionBubble(message: CometChat.BaseMessage, theme: CometChatTheme, style?: TextBubbleStyle): any;
    abstract getTextMessageBubble(messageText: string, message: CometChat.TextMessage, alignment: MessageBubbleAlignment, theme: CometChatTheme, style?: TextBubbleStyle, additionalConfigurations?: any): any;
    abstract getVideoMessageBubble(videoUrl: string, message: CometChat.MediaMessage, theme: CometChatTheme, thumbnailUrl?: string, onClick?: Function, style?: BaseStyle): any;
    abstract getImageMessageBubble(imageUrl: string, placeholderImage: string, message: CometChat.MediaMessage, theme: CometChatTheme, onClick?: Function, style?: ImageBubbleStyle): any;
    abstract getAudioMessageBubble(audioUrl: string, message: CometChat.MediaMessage, theme: CometChatTheme, title?: string, style?: BaseStyle): any;
    abstract getFileMessageBubble(fileUrl: string, message: CometChat.MediaMessage, theme: CometChatTheme, title?: string, style?: FileBubbleStyle): any;
    abstract getFormMessageBubble(message: FormMessage, theme: CometChatTheme, style?: FormBubbleStyle, onSubmitClick?: Function): any;
    abstract getSchedulerMessageBubble(message: SchedulerMessage, theme: CometChatTheme, style?: SchedulerBubbleStyle, onSubmitClick?: Function): any;
    abstract getCardMessageBubble(message: CardMessage, theme: CometChatTheme, style?: CardBubbleStyle): any;
    abstract getLastConversationMessage(conversation: CometChat.Conversation, loggedInUser: CometChat.User, additionalConfigurations?: any): string;
    abstract getDefaultDetailsTemplate(loggedInUser: CometChat.User, user: CometChat.User | null, group: CometChat.Group | null, theme: CometChatTheme): CometChatDetailsTemplate[];
    abstract getAuxiliaryHeaderMenu(user?: CometChat.User, group?: CometChat.Group): any;
    abstract getAIOptions(user: CometChat.User | null, group: CometChat.Group | null, theme: CometChatTheme, id?: Map<String, any>, AIOptionsStyle?: AIOptionsStyle): (CometChatMessageComposerAction | CometChatActionsView)[];
    abstract getAllTextFormatters(formatterParams: any): CometChatTextFormatter[];
    abstract getMentionsTextFormatter(params: any): CometChatMentionsFormatter;
    abstract getUrlTextFormatter(params: any): CometChatUrlsFormatter;
    abstract getMentionsFormattedText(message: CometChat.TextMessage, subtitle: string, additionalConfigurations?: any): string;
}
