import { Action, ActionOnClickType, ContentToDisplay } from ".";
import { Group, GroupMembersRequestBuilder, User, UsersRequestBuilder } from "@cometchat/chat-sdk-javascript";
import { CometChatMentionsFormatter, CometChatTextFormatter, UserMemberWrapperConfiguration } from "@cometchat/uikit-shared";
import { UserMemberListType } from "@cometchat/uikit-resources";
import React, { JSX } from "react";
type Args = {
    dispatch: React.Dispatch<Action>;
    textInputRef: React.MutableRefObject<JSX.IntrinsicElements["cometchat-message-input"] | null>;
    liveReactionBtnElement: JSX.IntrinsicElements["cometchat-button"] | null;
    LiveReactionIconURL: string;
    mySetAddToMsgInputText: (text: string) => void;
    actionSheetElement: JSX.IntrinsicElements["cometchat-action-sheet"] | null;
    mediaFilePickerRef: React.MutableRefObject<HTMLInputElement | null>;
    secondaryBtnElement: JSX.IntrinsicElements["cometchat-button"] | null;
    textMessageEditPreviewElement: JSX.IntrinsicElements["cometchat-preview"] | null;
    auxiliaryBtnElement: JSX.IntrinsicElements["cometchat-button"] | null;
    voiceRecordingBtnElement: JSX.IntrinsicElements["cometchat-button"] | null;
    emojiKeyboardElement: JSX.IntrinsicElements["cometchat-emoji-keyboard"] | null;
    voiceRecordingElement: JSX.IntrinsicElements["cometchat-emoji-keyboard"] | null;
    auxiliaryPopoverElement: JSX.IntrinsicElements["cometchat-popover"] | null;
    attachmentPopoverElement: JSX.IntrinsicElements["cometchat-popover"] | null;
    text: string;
    handleSendButtonClick: (text: string) => Promise<void>;
    primaryBtnElement: JSX.IntrinsicElements["cometchat-button"] | null;
    onTextChange?: (text: string) => void;
    actionIdToActionOnClick: React.MutableRefObject<Map<string, ActionOnClickType>>;
    handleTyping: () => void;
    errorHandler: (error: unknown) => void;
    getReceiverDetails: () => {
        receiverId: string;
        receiverType: string;
    };
    contentToDisplay: ContentToDisplay;
    createPollViewRef: any;
    handleSendVoiceMessage: (blob: Blob) => Promise<void>;
    aiPopoverElement: JSX.IntrinsicElements["cometchat-popover"] | null;
    aiBtnElement: JSX.IntrinsicElements["cometchat-button"] | null;
    setSmartRepliesView: any;
    textFormatters: Array<CometChatTextFormatter>;
    disableMentions: boolean;
    textFormatterArray: Array<CometChatTextFormatter>;
    mentionsTextFormatterInstanceRef: React.MutableRefObject<CometChatMentionsFormatter>;
    userMemberWrapperConfiguration: UserMemberWrapperConfiguration | undefined;
    setTextFormatters: React.Dispatch<React.SetStateAction<CometChatTextFormatter[]>>;
    CometChatUIKitLoginListener: any;
    group: CometChat.Group | undefined;
    user: CometChat.User | undefined;
    userMemberWrapperConfig: UserMemberWrapperConfiguration;
    setUserMemberWrapperConfig: React.Dispatch<React.SetStateAction<UserMemberWrapperConfiguration>>;
    userPropRef: React.MutableRefObject<User | undefined>;
    groupPropRef: React.MutableRefObject<Group | undefined>;
    setShowListForMentions: any;
    searchMentions: Function;
    mentionsFormatterInstanceId: string;
    setUsersRequestBuilder: React.Dispatch<React.SetStateAction<UsersRequestBuilder | undefined>>;
    setGroupMembersRequestBuilder: React.Dispatch<React.SetStateAction<GroupMembersRequestBuilder | undefined>>;
    setUserMemberListType: React.Dispatch<React.SetStateAction<UserMemberListType | undefined>>;
    userMemberWrapperRef: any;
    getComposerId: Function;
    parentMessageIdPropRef: any;
    isPartOfCurrentChatForUIEvent: (message: CometChat.BaseMessage) => boolean | undefined;
    propsText: string | undefined;
};
export declare function Hooks(args: Args): void;
export {};
