import { AvatarStyle, BackdropStyle, BaseStyle, ConfirmDialogStyle, LabelStyle, ListItemStyle } from "@cometchat/uikit-elements";
import { CSSProperties } from "react";
import { CometChatDetailsOption, CometChatDetailsTemplate, CometChatTheme } from "@cometchat/uikit-resources";
import { AddMembersConfiguration, AddMembersStyle, BannedMembersConfiguration, BannedMembersStyle, DetailsStyle, GroupMembersConfiguration, GroupMembersStyle, TransferOwnershipConfiguration, TransferOwnershipStyle } from "@cometchat/uikit-shared";
type ButtonStyle = CSSProperties & {
    buttonIconTint?: string;
    buttonTextFont?: string;
    buttonTextColor?: string;
};
export declare function detailsStyle(detailsStyleObject: DetailsStyle | null, theme: CometChatTheme): CSSProperties;
export declare function detailsContentWrapperStyle(detailsStyleObject: DetailsStyle | null): CSSProperties;
export declare function headerStyle(): CSSProperties;
export declare function profileStyle(): CSSProperties;
export declare function titleStyle(detailsStyleObject: DetailsStyle | null, theme: CometChatTheme): LabelStyle;
export declare function closeBtnStyle(detailsStyleObject: DetailsStyle | null, theme: CometChatTheme): ButtonStyle;
export declare function listItemStyle(listItemStyleObject: ListItemStyle | null, theme: CometChatTheme): ListItemStyle;
export declare function statusIndicatorStyle(statusIndicatorStyleObject: CSSProperties | null, theme: CometChatTheme): CSSProperties;
export declare function avatarStyle(avatarStyleObject: AvatarStyle | null, theme: CometChatTheme): AvatarStyle;
export declare function subtitleStyle(isUserOnline: boolean, detailsStyleObject: DetailsStyle | null, theme: CometChatTheme): LabelStyle;
export declare function sectionListStyle(): CSSProperties;
export declare function sectionHeaderWrapperStyle(): CSSProperties;
export declare function sectionHeaderStyle(template: CometChatDetailsTemplate): LabelStyle;
export declare function optionsStyle(): CSSProperties;
export declare function optionBtnStyle(option: CometChatDetailsOption): ButtonStyle;
export declare function defaultOptionContentStyle(): CSSProperties;
export declare function tailWrapperStyle(): CSSProperties;
export declare function defaultOptionStyle(): CSSProperties;
export declare function pageWrapperStyle(): CSSProperties;
export declare function backdropStyle(backdropStyleObject: BaseStyle | null, detailsStyle: DetailsStyle | null): BackdropStyle;
export declare function leaveDialogStyle(confirmDialogStyleObject: ConfirmDialogStyle | null, detailsStyle: DetailsStyle | null, theme: CometChatTheme): ConfirmDialogStyle;
export declare function deleteDialogStyle(confirmDialogStyleObject: ConfirmDialogStyle | null, theme: CometChatTheme): ConfirmDialogStyle;
export declare function dividerStyle(separatorColor: string | undefined, isSectionSeparatorStyle: boolean, theme: CometChatTheme): BaseStyle;
export declare const getSectionStyle: () => {
    padding: string;
};
export declare const getGroupMembersStyle: (groupMembersConfiguration: GroupMembersConfiguration | null, detailsStyle: DetailsStyle | null) => GroupMembersStyle;
export declare const getAddMembersStyle: (addMembersConfiguration: AddMembersConfiguration | null, detailsStyle: DetailsStyle | null) => AddMembersStyle;
export declare const getBannedMembersStyle: (bannedMembersConfiguration: BannedMembersConfiguration | null, detailsStyle: DetailsStyle | null) => BannedMembersStyle;
export declare const getTransferOwnershipStyle: (transferOwnershipConfiguration: TransferOwnershipConfiguration | null, detailsStyle: DetailsStyle | null) => TransferOwnershipStyle;
export {};
