/* vim: set expandtab ts=4 sw=4: */

/*
 * Copyright 2017 The bin2llvm Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __SAVE_TRANSLATED_BBS_H__
#define __SAVE_TRANSLATED_BBS_H__ 1

#include <s2e/S2E.h>

#include <llvm-c/Core.h>
#include <llvm/Function.h>
#include <llvm/Module.h>
#include <llvm/Transforms/Scalar.h>
#include <llvm/Transforms/Utils/ValueMapper.h>

#include <vector>
#include <string>

#include "RecursiveDescentDisassembler.h"

class SaveTranslatedBBs {

public:
    void saveTranslatedBasicBlocks(
            std::vector<s2e::plugins::MyTranslationBasicBlock *> *allBBs,
            std::string fileName);
    llvm::Module * createAndSaveTranslatedBasicBlocksAsAModule(
            std::vector<s2e::plugins::MyTranslationBasicBlock *> *allBBs,
            std::string fileName);

private:
    void copyGlobalReferences(
            llvm::Module *module,
            llvm::Function *func,
            llvm::ValueToValueMapTy &valueMap);
    void annotateNewFunction(llvm::Function &func,
            s2e::plugins::MyTranslationBasicBlock *bb);
    std::string hex(uint64_t val);
};

#endif
