// selectLocationState expects a plain JS object for the routing state
const selectLocationState = () => {
  let prevRoutingState;
  let prevRoutingStateJS;

  return (state) => {
    const routingState = state.get('route'); // or state.route

    if (!routingState.equals(prevRoutingState)) {
      prevRoutingState = routingState;
      prevRoutingStateJS = routingState.toJS();
    }

    return prevRoutingStateJS;
  };
};

const selectGlobal = () => (state) => state.get('global');
import { createSelector } from 'reselect';

const getCounties = () => createSelector(
  selectGlobal(),
  (globalState) => globalState.get('counties')
);

const getIncidentTypes = () => createSelector(
  selectGlobal(),
  (globalState) => globalState.get('incidentTypes')
);


export {
  selectLocationState,
  getCounties,
  getIncidentTypes,
};
