# Monitorizare Vot - Web platform for the general public - Contributing guide

:two_hearts: First off all, thank you for your interest in the project and for taking the time to contribute!

This project is built by amazing volunteers, just like you, from different timezones, backgrounds and skills levels. So to make sure we're all on the same page, it would be great if we all followed a few guidelines. :two_hearts:

[Feedback](#feedback) | [How Can I Contribute?](#how-can-i-contribute) | [Best practices](#best-practices) | [About Code4Ro](#about-code4ro) | [Financial contributions](#financial-contributions) | [Code of conduct](#code-of-conduct)

## Feedback

Just have a quick question? Please e-mail us at at contact@code4.ro

## How can I contribute

### Report bugs

:bug: Think you found a bug? Please check [the list of open issues](https://github.com/code4romania/monitorizare-vot-votanti-client/issues) to see if your bug has already been reported. If it hasn't please [submit a new issue](https://github.com/code4romania/monitorizare-vot-votanti-client/issues/new). 

:shield: If you find a **security vulnerability**, do not open an issue. Please email contact@code4.ro instead.

Please be as specific as possible when describing the issue. Explain the problem and include additional details to help maintainers reproduce the problem:

* **Description**
* **Steps to Reproduce**
* Expected behavior
* Actual behavior
* Reproduces how often

### Suggest new features 

:bulb: Feature requests are welcome. We would love to hear your thoughts on how we can improve our project further. 

To send us a suggestion, just [open an issue](https://github.com/code4romania/monitorizare-vot-votanti-client/issues/new) which describes the feature you would like to see. Give as much information as you can about what you would like to see:

* Description
* Step by step behaviour 
* Explain why this enhancement would be useful

### Contribute to the codebase

:computer: We'd love for you to get your hands dirty and code for the project.

If you are unsure where to begin contributing to the project, you can start by looking through these issues:  
* [Good first issues](https://github.com/code4romania/monitorizare-vot-votanti-client/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22)
* [Help wanted](https://github.com/code4romania/monitorizare-vot-votanti-client/issues?q=is%3Aissue+is%3Aopen+label%3A%22help+wanted%22)

Please make sure to check out the suggested coding [best practices](#best-practices) and tips with working with git below :wink:

## Best practices

### Coding best practices :ok_hand:

* **The language we code in is English.** Please name your variables, methods, classes and other structures using English words.
* Use clean code conventions :heavy_check_mark: *tip: read [The book](https://www.goodreads.com/book/show/3735293-clean-code) if you haven't already. Or check out [a summary](https://gist.github.com/wojteklu/73c6914cc446146b8b533c0988cf8d29)*
* Follow the [JavaScript styleguide](https://github.com/standard/standard)
* Tests are appreciated :relieved:
* Please use relevant commit messages and reference issues in the commit message if applicable

### Git workflow

Our collaboration model [is described here](WORKFLOW.MD). 

## About Code4Ro

Started in 2016, Code for Romania is a civic tech NGO, official member of the Code for All network. We have a community of over 500 volunteers (developers, ux/ui, communications, data scientists, graphic designers, devops, it security and more) who work pro-bono for developing digital solutions to solve social problems. #techforsocialgood. If you want to learn more details about our projects [visit our site](https://www.code4.ro/en/) or if you want to talk to one of our staff members, please e-mail us at contact@code4.ro.

## Financial contributions

Last, but not least, we rely on donations to ensure the infrastructure, logistics and management of our community that is widely spread across 11 timezones, coding for social change to make Romania and the world a better place. If you want to support us, [you can do it here](https://code4.ro/en/donate/).

## Code of conduct

This project and everyone participating in it is governed by the [Code for Romania Code of Conduct](https://code4.ro/en/code-of-conduct/). By participating, you are expected to uphold this code. Please report unacceptable behavior to safespace@code4.ro.
