<!----------------------------------------------------------------------------
Copyright @ 2021-2022 Codam Coding College. All rights reserved.
See copyright and license notice in the root project for more information.
----------------------------------------------------------------------------->

</br>
<div align="center">
  <img src="./assets/logo.png" alt="42MLX_Logo">
</div>
<div align="center" style="margin-top: 8px;">
  <sub>Written by <a href="https://portfolio.w2wizard.dev/">W2.Wizard</a> for the 42 Network</sub>
</div>
</br>

<div align="center">
    <h1>Welcome to the MLX42, 42Campus documentation</h1>
</div>

# Foreword
If you're considering allowing the use of MLX42 in your campus and wondering why you should do it, how it should work, and what it will take to get it working, then you're in the right place!

MLX42 has been battle-tested multiple times at hackathons and other campuses and has received over 500 commits since 2021. All students share the same sentiment: they enjoy using the library, but it's not too easy to finish the projects. During that time many bugs, leaks, and segfaults have been fixed.

It addresses one of the main problems at 42, which is that although it is a tech school, it does not provide its students with well-maintained tools to improve their education. All a campus wants is to give its students the best they can.

| Campus    | Allowed      | Additional Notes   |
| ----------|:------------:| :------------------|
| Codam     |      ✅      |                    |
| Mulhouse  |      ✅      |                    |
| Quebec    |      ✅      |                    |
| Belo Horizonte | ❓      |                    |
| London    |      ❌      | Just because ?     |
| São Paulo |      ✅      |                    |
| Rio       |      ❓      |                    |
| Malaga    |      ✅      |                    |
| Singapore |      ❓      | Asked their pedago, awaiting a response.|
| Barcelona |      ✅      | Would like propose some modifications preferably                   |
| Nice      |      ✅      | Banned `mlx_put_pixel` & `mlx_resize_image` otherwise fully authorized 🎊                   |
| Berlin    |      ✅      | Banned `mlx_put_pixel` & `mlx_resize_image` otherwise fully authorized 🎊`                  |
| Heilbronn |      ✅      |                    |
| 1337      |      ✅      | 1337 Refers to every campus part of 1337                   |
| Angoulême |      ✅      |                    |
| Lausanne  |      ❓      | No idea how to reach them                   |
| Prague    |      ✅      |                    |
| 19        |      ❌      | No reason (?) You can probably blame paris again I guess                   |
| Hive      |      ✅      |                    |
| Le Havre  |      ✅      |                    |
| Vienna    |      ❓      |                    |
| Seoul     |      ❌      | I didn't really understand why but basically as long as Paris says no they will too                  |
| Madrid    |      ✅      | Authorized since the Linux migration                   |
| Porto     |      ❌      | Not Auth from Paris|
| Lisboa    |      ❌      | Not Auth from Paris|
| Wolfsburg |      ❌      | Not Auth from Paris|
| Urduliz   |      ❌      | Not Auth from Paris|
| Paris     |      ❌      | Because its Paris 🤡🤡🤡|

Regarding other campuses the status is unknown.

---

# Technical comparison
## MiniLibX
The miniLibX has many problems that have been around for almost 10+ years:

- `Not maintained`: The library is practically dead, and it's unclear who is available to fix the bugs. It hasn't had any changes in a long time, and student pull requests on Github for the X11 version go unnoticed. Issues are also being ignored.

- `Poor documentation`: The documentation consists of a few man pages that are outdated and an online documentation created by another student. It's understandable that students have to learn on their own, but a library with an extensive API requires proper documentation for anyone to start understanding it.

- `Poor execution`: There are multiple versions: OpenGL, Swift, and X11. Instead of becoming better with each new iteration, they stay the same with no real improvement. It should be future-proof and not dependent on a specific platform. People are struggling with the there being so many different versions that they start losing track where the problem actually is.

- `Not cross-platform`: Students constantly encounter the same problem: at school they work with MacOS, but at home they use Linux. Or they write their project on Linux, but want to show it to their parents using Windows or MacOS. At each point, miniLibX fails to fill that gap. The pandemic in 2019 showed just how much students struggled to evaluate each other using different machines and versions.

---

## MLX42

The main goal of MLX42 is to address all of these shortcomings of the original versions. There are some differences, mainly in the way images are rendered, but everything else is basically the same.

So far, all of the drawbacks of miniLibX have been taken care of, and students using it are enjoying it!

### Rendering

One of the biggest differences between the two libraries is the way rendering is handled.

In `miniLibX`, students change the buffer of an image and then push it to the window.
In `MLX42`, students put the image to the window and can change the buffer at any time, resulting in an immediate update to the image.

MLX42 uses instances instead. An image is like the original painting, while instances are individual copies of this painting on the window.

There is no window clearing function because students need to learn how to properly manage their images. They can still delete images and turn instances on or off, of course.

Internally, it uses batched rendering to further improve performance. The actual documentation and the code itself have more details.

### Maintained & Open-source

The main goal of MLX42 is to empower students and pedagogues by giving them the ability to maintain and fix bugs, instead of leaving their complaints unaddressed. By being open-source, students can explore the code and submit pull requests.

### Documentation
The repository comes with a well-maintained [Wiki](https://github.com/codam-coding-college/MLX42/wiki) and documentation in the form of `markdown` files in the repository root.

### Build system

MLX42 initially used `make`, but it was inflexible and caused weird bugs for others. Since version 2.3.0 it uses `cmake` for a truly cross-platform build system.

Students do not need to understand how to use `cmake`, as building the library requires only two shell commands. The instructions on how to build the library are provided to them.

### XPM42
For historical reasons, I included my own file format that mimics XPM3. In the original miniLibX, the way XPM files were handled made no sense, as they were supposed to be compiled into the binary. Instead, miniLibX parsed the files and pasted the data into memory.

In the `tools` folder, there is a python script that converts XPM3 to XPM42. XPM42 is available as an alternative, but it is highly encouraged to use the PNG importer, which does not leak and uses lodepng for parsing.

---

### How can I migrate? What is necessary to change?

Migrating to MLX42 is easy and requires minimal effort, it requires just 2 dependencies in order to work.

#### Dependencies
- [CMake: >= 3.18.0](https://cmake.org/download/)
- [GLFW: >= 3.3.6](https://github.com/glfw/glfw)

It is up to your pedago staff or system administrator to determine how to distribute MLX42 to students.

The options are:

- `A`: Install it on the machine in a location such as /usr/local/lib and use -lmlx42 to link it.

- `B`: Have students clone the repository, preferably as a submodule, and include it in their repository.

There is not much else to do besides these steps. It is a straightforward replacement, and the choice of distribution is up to the campus.

## F.A.Q

Q: **_"It has too many features! I think students should implement some of them themselves including some functions..."_**

A: If there is one frustrating point in this entire F.A.Q then it is this one. Because 42 Network's pedago never actually clarifies what this even means? They don't communicate what is supposededly "too useful". Because if they did then it wouldn't require having to write this entire F.A.Q and pointing out all their flawed arguments. It's been 2 years now and not once have the maintainers been approached by the network's pedago.

***WHAT*** functions are too useful you may wonder? Well really there aren't many if any that we can think of. The majority of additional functions are just GLFW wrappers to enable more extensive customization of the window. This includes setting custom cursors or app icons which really don't add any complexity nor are students able to do this themselves anyway. They are available without impeding their learning.

If there was something too useful that really criticaly hinders the adoption of this library. I would advise that we use communication much like any other species of this planet to resolve it.

---

Q: **_"The `mlx_put_pixel` works too well..."_**

A: Rather than purposefully sabotaging the library to make a point, I deemed it necessary that the library simply works. By default, this function is already banned by all subjects, and the main idea was to force students to use images.

In MLX42 it always starts with an image, and students are forced to face images no matter what. They still face the same learning curve of how to modify the buffer of an image and learn the concept of bit shifting one way or another.

Our proposal is to allow its use in the first three graphics projects (fract-ol, fdf, so_long) and later ban it for the remaining ones (Cub3D, MiniRT), so students can become familiar with it and then need to explore its workings.

---

Q: **_"Are the libraries 1:1 identical?"_**

A: No, there are 100% breaking changes, and changing from miniLibX to MLX42 will not be a simple drop-in replacement. As in their API is slightly different. That was not the idea eitherway, as it would be impossible to fix the problems present in the current miniLibX.

In terms of usage, it's practically identical, while the API Prototypes are slightly different, the usage is roughly the same and the only core difference is the way images are handled.

My suggestion is for students who are using miniLibX to keep using it to finish their project and for new students to prefer the new one or until they reach the next graphical project.

---

Q: **_"With regards to how the rendering is done, won't that make it too easy for students?"_**

A: After almost a year in use, both new students who didn't use the old one and students who used both managed just fine and even appreciated this change in the way rendering works in MLX42.

It is not taking away from the learning experience, it's just shifting a function call from one place to another. Students still find it challenging to finish the actual project, as they still need to learn a whole new library and how it operates.

---

Q: **_"OpenGL? Isn't that a bit old by now?"_**

A: Is OpenGL old? Sure. But in the end, students don't care. You could argue that it's less future-proof and that Vulkan should be used instead. But ask yourself, does one need an artillery cannon to hunt for a rabbit in a forest? If your answer is no, then why does one need Vulkan to render a bunch of quads on a window?

OpenGL is easy to learn, widely supported and it could be argued that it's actually useful for students who are interested in graphics. Anyway, if one day Vulkan is required, a branch and PR can be created and merged!

Just a small reminder that it takes roughly [700+ lines of code](https://github.com/SaschaWillems/Vulkan/blob/master/examples/triangle/triangle.cpp) to render a triangle with vulkan...

Here is the equivalent in [OpenGL](https://learnopengl.com/code_viewer_gh.php?code=src/1.getting_started/2.1.hello_triangle/hello_triangle.cpp).

---

Q: **_"CMake? Won't that confuse them?"_**

A: It is 2 simple commands that are described in the README, and it's a good opportunity to learn a new way to build your projects.

---

Q: **_"Who will maintain MLX42? How long can this be guaranteed?"_**

A: Currently it is being maintained by `lde-la-h` (W2Wizard). However commits from the 42 Pedago or really anyone are very much welcome.
I myself have been taking care of it since the 1st of January 2021 and aim to continue to support it until I can't.

Once the time comes, someone else will take the lead of maintaining the library whoever that may be.

---

Q: **_"Do we need to update translations or subjects, etc??"_**

A: Regarding the subjects, as long as the library not being adopted there's little room for change in this regard. However the good news is that it basically requires zero effort besides updating the links on the intra and maybe changing the name referenced inside the pdf's. There is really nothing necessary to change besides minor things and to adapt these changes would literally just require at most a day of effort.

If you're really unusure, you as a pedago / campus can just choose to adopt it and mention to students that they can git clone it from here.

---

Q: **_"What if we want to ban some functions?"_**

A: Contact the maintainer or make a PR with the suggestion and watch it get merged or rejected. All it requires is communication... Any change is welcome if it so desired. You don't have to accept anything as is, that is the point of all of this. That if something needs to change, it can actually happen.

---

Q: **_"I don't like the fact that it uses GLFW for the window..."_**

A: `¯\_(ツ)_/¯` Well it's better than using the native windowing framework, at least it is portable, at least if something is wrong with it students can actually fix it by making a PR to the respective repository. Additionally GLFW is pretty standard for things like this, simply checkout any graphics demo and somewhere you will end up with GLFW under the hood quite often.

