{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnLangCollection;
{* |<PRE>
================================================================================
* ƣCnPack 
* ԪƣĿб൥Ԫ
* ԪߣCnPack  (master@cnpack.org)
*     עõԪʵĿб
* ƽ̨PWin2000 + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/6/7
*   õԪеַϱػʽ
* ޸ļ¼2003.12.13 V1.1
*                DefaultFont Դƶ LanguageItem У
*               ÿԿһ DefaultFont Storage 
*           2003.08.20 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Classes, Windows, Graphics, CnIniStrUtils;

type
{$IFDEF UNICODE}
  TCnLangString = string;
{$ELSE}
  TCnLangString = WideString;
{$ENDIF}

  TCnLanguageItem = class (TCollectionItem)
  {* Ŀ }
  private
    FLanguageName: TCnLangString;
    FAuthor: TCnLangString;
    FAuthorEmail: TCnLangString;
    FAbbreviation: TCnLangString;
    FLanguageFileName: TCnLangString;
    FLanguageDirName: TCnLangString;
    FLanguageID: LongWord;
    FOnLanguageIDChanged: TNotifyEvent;
    FDefaultFont: TFont;
    function GetAbbreviation: TCnLangString;
    function GetLanguageName: TCnLangString;
    procedure SetAbbreviation(Value: TCnLangString);
    function GetLanguageFileName: TCnLangString;
    procedure SetLanguageFileName(const Value: TCnLangString);
    procedure SetDefaultFont(Value: TFont);
    function GetDefaultFontStr: TCnLangString;
    function GetLanguageDirName: TCnLangString;
    procedure SetLanguageDirName(const Value: TCnLangString);
  protected
    procedure SetAuthor(Value: TCnLangString);
    procedure SetAuthorEmail(Value: TCnLangString);
    procedure SetLanguageID(Value: LongWord);
    procedure SetLanguageName(Value: TCnLangString);
    procedure DoLanguageIDChanged; virtual;
  public
    constructor Create(Collection: TCollection); override;
    destructor Destroy; override;

    procedure Assign(Source: TPersistent); override;
    {* ֵ}
    function IsValidLanguageID(ALanguageID: LongWord): Boolean;
    {* жһ ID ǷǺϷ ID }
    property OnLanguageIDChanged: TNotifyEvent read FOnLanguageIDChanged
      write FOnLanguageIDChanged;
    {*  ID ıʱ }
    property DefaultFontStr: TCnLangString read GetDefaultFontStr;
    {* Ĭϵ Font  Str}
  published
    property Abbreviation: TCnLangString read GetAbbreviation write SetAbbreviation;
    {* Եд LanguageID ʱԶ }
    property Author: TCnLangString read FAuthor write SetAuthor;
    {* ԵķĿ }
    property AuthorEmail: TCnLangString read FAuthorEmail write SetAuthorEmail;
    {* ԵķĿߵĵʼַ }
    property LanguageID: LongWord read FLanguageID write SetLanguageID;
    {* Ե ID  }
    property LanguageName: TCnLangString read GetLanguageName write SetLanguageName;
    {* Եƣ LanguageID ʱԶ }
    property LanguageFileName: TCnLangString read GetLanguageFileName
      write SetLanguageFileName;
    {* ؿõıļԴ洢ʹãļʽ洢ʱЧ }
    property LanguageDirName: TCnLangString read GetLanguageDirName
      write SetLanguageDirName;
    {* ؿõıĿ¼Ŀ¼ʽ洢ʱЧ }
    property DefaultFont: TFont read FDefaultFont write SetDefaultFont;
    {* ԵĬ Fontڲʹ FontStr 洢 }
  end;

  TCnLanguageCollection = class (TOwnedCollection)
  {* б }
  private
    function GetItems(Index: Integer): TCnLanguageItem;
    procedure SetItems(Index: Integer; Value: TCnLanguageItem);
  public
    constructor Create(AOwner: TPersistent); reintroduce;
    function Add: TCnLanguageItem;
    {* һµĿ }
    function Find(ALanguageID: LongWord): Integer; overload;
    {*  ID Ŀ }
    function Find(ALanguageName: TCnLangString): Integer; overload;
    {* ƲĿ }
    property Items[Index: Integer]: TCnLanguageItem read GetItems write
      SetItems; default;
    {* ĳĿ }
  end;

implementation

uses
  CnLangConsts, CnLangUtils, CnLangStorage;

{***************************** TCnLanguageItem ******************************}

procedure TCnLanguageItem.DoLanguageIDChanged;
begin
  if Assigned(FOnLanguageIDChanged) then
    FOnLanguageIDChanged(Self);
end;

function TCnLanguageItem.GetAbbreviation: TCnLangString;
begin
  Result := FAbbreviation;
end;

function TCnLanguageItem.GetLanguageFileName: TCnLangString;
begin
  Result := FLanguageFileName;
end;

function TCnLanguageItem.GetLanguageName: TCnLangString;
begin
  Result := FLanguageName;
end;

function TCnLanguageItem.IsValidLanguageID(ALanguageID: LongWord): Boolean;
begin
  try
    Result := CnLanguages.IndexOf(ALanguageID) >= 0;
  except
    raise ELanguageStorageError.Create(SCnErrorInCheckingLanguage);
  end;
end;

procedure TCnLanguageItem.SetAbbreviation(Value: TCnLangString);
begin
  if FAbbreviation <> Value then
    FAbbreviation := Value;
end;

procedure TCnLanguageItem.SetAuthor(Value: TCnLangString);
begin
  if FAuthor <> Value then
  begin
    FAuthor := Value;
    
  end;
end;

procedure TCnLanguageItem.SetAuthorEmail(Value: TCnLangString);
begin
  if FAuthorEmail <> Value then
  begin
    FAuthorEmail := Value;

  end;
end;

procedure TCnLanguageItem.SetLanguageFileName(const Value: TCnLangString);
begin
  FLanguageFileName := Value;
end;

procedure TCnLanguageItem.SetLanguageID(Value: LongWord);
begin
  if FLanguageID <> Value then
  begin
    if Value = 0 then
    begin
      FLanguageID := Value;
      LanguageName := '';
      Abbreviation := '';
      LanguageFileName := '';

      LanguageDirName := '';
      DoLanguageIDChanged;
    end
    else if IsValidLanguageID(Value) then
    begin
      FLanguageID := Value;
      LanguageName := CnLanguages.NameFromLocaleID[Value];
      Abbreviation := CnLanguages.Ext[CnLanguages.IndexOf(Value)];
      if LanguageFileName = '' then
        LanguageFileName := Abbreviation;

      LanguageDirName := IntToStr(Value);
      DoLanguageIDChanged;
    end
    else
      raise ELanguageStorageError.CreateFmt(SCnInvalidLanguageIDError, [Value]);
  end;
end;

procedure TCnLanguageItem.SetLanguageName(Value: TCnLangString);
begin
  if FLanguageName <> Value then
  begin
    FLanguageName := Value;

  end;
end;

procedure TCnLanguageItem.SetDefaultFont(Value: TFont);
begin
  FDefaultFont.Assign(Value);
end;

constructor TCnLanguageItem.Create(Collection: TCollection);
begin
  inherited;
  FDefaultFont := TFont.Create;
end;

destructor TCnLanguageItem.Destroy;
begin
  FDefaultFont.Free;
  inherited;
end;

procedure TCnLanguageItem.Assign(Source: TPersistent);
begin
  if Source is TCnLanguageItem then
  begin
    FLanguageName := TCnLanguageItem(Source).LanguageName;
    FAuthor := TCnLanguageItem(Source).Author;
    FAuthorEmail := TCnLanguageItem(Source).AuthorEmail;
    FAbbreviation  := TCnLanguageItem(Source).Abbreviation;
    FLanguageFileName  := TCnLanguageItem(Source).LanguageFileName;
    FLanguageDirName  := TCnLanguageItem(Source).LanguageDirName;
    FLanguageID  := TCnLanguageItem(Source).LanguageID;    
  end
  else
    inherited;
end;

function TCnLanguageItem.GetDefaultFontStr: TCnLangString;
begin
  Result := FontToString(FDefaultFont);
end;

constructor TCnLanguageCollection.Create(AOwner: TPersistent);
begin
  inherited Create(AOwner, TCnLanguageItem);
end;

function TCnLanguageCollection.Add: TCnLanguageItem;
begin
  Result := TCnLanguageItem(inherited Add);
end;

function TCnLanguageCollection.Find(ALanguageID: LongWord): Integer;
var
  i: Integer;
begin
  Result := -1;
  for i := 0 to Count - 1 do
    if Items[i].LanguageID = ALanguageID then
    begin
      Result := i;
      Exit;
    end;
end;

function TCnLanguageCollection.Find(ALanguageName: TCnLangString): Integer;
var
  i: Integer;
begin
  Result := -1;
  for i := 0 to Count - 1 do
    if Items[i].LanguageName = ALanguageName then
    begin
      Result := i;
      Exit;
    end;
end;

function TCnLanguageCollection.GetItems(Index: Integer): TCnLanguageItem;
begin
  Result := TCnLanguageItem(inherited Items[Index]);
end;

procedure TCnLanguageCollection.SetItems(Index: Integer; Value: TCnLanguageItem);
begin
  inherited Items[Index] := Value;
end;

function TCnLanguageItem.GetLanguageDirName: TCnLangString;
begin
  Result := FLanguageDirName;
end;

procedure TCnLanguageItem.SetLanguageDirName(const Value: TCnLangString);
begin
  FLanguageDirName := Value;
end;

end.
