{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnTextControl;
{* |<PRE>
================================================================================
* ƣؼ
* Ԫƣıʾ༭ؼʵֵԪ
* ԪߣCnPack  (master@cnpack.org)
*     עõԪǰΪڲο
* ˵ScreenLineNumber ScreenRow: ؼʾõкţ 1ø
*           LineNumber Row: кţ1 ʼ ScreenLineNumber  FVertOffset
*           PaintLineNumber: кϻƵкţû۵µ LineNumber
*           ؼʾӦкŵĸΪַһȿֻȿ޺ֵ
*           ColNumber Colкţ1 ʼͻе ScreenColNumber  FHoriOffset
*           CaretRowǰڵкţ1 ʼ ScreenLineNumber
*           CaretColǰڵкţߵ 1 ַǵ 1 λ
*           Ϊ϶ͷʱλþӦ仯
*                     ҳʱλ÷仯ݹɼ
*           ؼʾֵϽԭΪؼкұߣ
*                 붥п϶ԭǿؼϽ
*           ؼʾԭҲǿؼϽ
*                 ڲŰΪ壬 1 ʼϽǿڿؼ
*           ŰС״ͬϽΪԭ
* ƽ̨PWin7 + Delphi 5.0
* ݲԣPWinXP/7 + Delphi 5/6
*   õԪеַϱػʽ
* ޸ļ¼2021.04.20 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Classes, Controls, Messages, Windows, Graphics;

type
  ECnTextControlException = class(Exception);

  TCnVirtualTextControl = class(TCustomControl)
  {* ܹʾֲͬĻ࣬;ַ޹}
  private
    FCharFrameSize: TPoint;       // ַߴ磬
    FShowLineNumber: Boolean;     // Ƿʾк
    FLineNumCount: Integer;       // кŵλ
    FLineNumPattern: string;      // кӦַ 0000
    FLineNumWidth: Integer;       // кӦַ
    FMaxLineCount: Integer;       // кţã 1  FMaxLineCount
    FWheelLinesCount: Integer;    // 
    FLineNumColor: TColor;        // кֵɫ
    FLineNumFocusBkColor: TColor;     // нʱкıɫ
    FLineNumNoFocusBkColor: TColor;   // ޽ʱкıɫ
    FGutterRect: TRect;               // 
    FTextRect: TRect;                 // ֻ
    FUseCaret: Boolean;               // Ƿʹù
    FCaretVisible: Boolean;           // Ƿɼ
    FCharFrameIsLeft: Boolean;        // Ƿڵǰַ
    FCharFrameDoubleWidth: Boolean;   // ǰַǷ˫ڿַֽ
    FCaretRow: Integer;               // ڵкţ1 ʼ LineNumber
    FCaretCol: Integer;               // ڵкţ1 ʼ
    FCaretAfterLineEnd: Boolean;      // ǷԽβ
    FLeftMouseDown: Boolean;          // ¼
    FLeftMouseMoveAfterDown: Boolean; // ¼ºǷ϶
    FIsWheeling: Boolean;             // ǰʱǷ¼
    FOnCaretChange: TNotifyEvent;
    FOnScroll: TNotifyEvent;
    FUseSelection: Boolean;
    FOnSelectChange: TNotifyEvent;
    procedure UpdateScrollBars;       // Ļ״ȷλóߴ
    procedure UpdateRects;
    {* ıкȵĳߴ磬ע Paint ûʹ}
    procedure CalcMetrics;
    {* ıʱãȫ}
    function GetVisibleLineCount: Integer;
    function GetScreenBottomLine: Integer;
    procedure SetMaxLineCount(const Value: Integer);
    procedure SetShowLineNumber(const Value: Boolean);
    procedure SetLineNumColor(const Value: TColor);
    procedure SetLineNumFocusBkColor(const Value: TColor);
    procedure SetLineNumNoFocusBkColor(const Value: TColor);
    procedure SetUseCaret(const Value: Boolean);

    procedure DisplayCaret(ACaretVisible: Boolean);
    {* ƹʾ}
    function GetTextRectLeft: Integer;
    {* ̬ıʾڿؼϽǵ꣬кʾ}
    function GetTextRect: TRect;
    {* ıʾԿؼΪȥϡ±߽}
    function ScreenLineNumberToLineNumber(ScreenLineNumber: Integer): Integer;
    {* Ļϵкţ1 ʼģתɹкţ1 ʼģ}
    function ScreenColNumberToColNumber(ScreenColNumber: Integer): Integer;
    {* Ļϵкţ1 ʼģתɹкţ1 ʼģ}
    function LineNumberToScreenLineNumber(LineNumber: Integer): Integer;
    {* Ļϵкţ1 ʼģתĻϵкţ1 ʼģ}
    function ColNumberToScreenColNumber(ColNumber: Integer): Integer;
    {* Ļϵкţ1 ʼģתĻϵкţ1 ʼģ}
    function CalcRowCol(Pt: TPoint; out ACaretRow, ACaretCol: Integer;
      out ACharFrameIsLeft, ACharFrameDoubleWidth: Boolean): Boolean;
    {* ݿؼַλãؼǷɹ}
    procedure UpdateCursorFrameCaret;
    {* ݵǰλöλַλ}
    procedure LimitRowColumnInLine(var LineNumber, Column: Integer);
    {* ݵǰλԼԼǷ곬βλ}
    procedure SyncCaretPosition;
    {* ݵǰλ}
    procedure CalcSelectEnd(Pt: TPoint);
    {* ݿؼ㲢ѡĩβڹƶΧ}

    procedure SetCaretCol(const Value: Integer);
    procedure SetCaretRow(const Value: Integer);
    procedure SetCaretAfterLineEnd(const Value: Boolean);
    procedure SetSelectEndCol(const Value: Integer);    // ѡβ
    procedure SetSelectEndRow(const Value: Integer);    // ѡβ
    procedure SetSelectStartCol(const Value: Integer);
    procedure SetSelectStartRow(const Value: Integer);
    function GetTopLine: Integer;                       // ֻûеԭвȿ
    function GetBottomLine: Integer;
    function GetHoriPixelsOffset: Integer;              // 
    procedure SetUseSelection(const Value: Boolean);
    procedure SetOnSelectChange(const Value: TNotifyEvent);
    function GetScreenCaretRow: Integer;
  protected
    FVertExp: Integer;            // ָڿ̫ʱ̫ϸ
    FVertOffset: Integer;         // ƫΪλ0 ʼ 1  TopLine
    FHoriOffset: Integer;         // ƫƽַΪλ0 ʼǵȿºкûֱӹϵ
    FAveCharWidth: Integer;       // ַƽȣ
    FMaxCharWidth: Integer;       // ַ
    FAveCharWidthHalf: Integer;   // ַߴһ룬жϵʱַǰʹ
    FLineHeight: Integer;         // иߣ
    FFontIsFixedWidth: Boolean;   // Ƿȿ
    FSelectStartRow: Integer;     // ѡʼкţעʼͽһĸǰ
    FSelectEndRow: Integer;       // ѡк
    FSelectStartCol: Integer;     // ѡʼк
    FSelectEndCol: Integer;       // ѡк

    procedure CreateParams(var Params: TCreateParams); override;
    procedure WMSetFont(var message: TMessage); message WM_SETFONT;
    procedure WMGetDlgCode(var Msg: TWMGetDlgCode); message WM_GETDLGCODE;

    procedure WMVScroll(var message: TWMScroll); message WM_VSCROLL;
    {* ϢʼУλ}
    procedure WMHScroll(var message: TWMScroll); message WM_HSCROLL;
    {* ϢºʼУλ}

    procedure WMSetFocus(var message: TWMSetFocus); message WM_SETFOCUS;
    procedure WMKillFocus(var message: TWMSetFocus); message WM_KILLFOCUS;
    procedure WMSize(var message: TWMSize); message WM_SIZE;
    procedure WMMouseWheel(var message: TWMMouseWheel); message WM_MOUSEWHEEL;
    {* ֹöӰĹλãֻλÿƳĻ}

    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;

    procedure KeyDown(var Key: WORD; Shift: TShiftState); override;
    procedure DoScroll; virtual;
    procedure DoCaretChange; virtual;
    {* λ÷ıʱ}
    procedure DoSelectChange; virtual;
    {* ѡıʱ}

    procedure NavigationKey(Key: WORD; Shift: TShiftState); virtual;
    {* յ·Լ PageUp/PageDown Home/End Ĵֻ
      ໹дԴƶ}
    procedure ScrollToVisibleCaret;
    {* λĻʱĻԽ¶겻䣬ܷ仯
      ڲʵ޸ FVertOffset  FHoriOffset ػ}
    function SyncSelectionStartEnd(Force: Boolean = False): Boolean;
    {* ѡ״̬ʱǿƣλͬѡʼλãҲζȡѡ
      ֵΪ True ʱʾִͬȡѡ}

    procedure ScrollUpLine;      // Ϲһ
    procedure ScrollDownLine;    // ¹һ
    procedure ScrollLeftCol;     // һַ
    procedure ScrollRightCol;    // ҹһַ
    procedure ScrollUpPage;      // Ϲһ
    procedure ScrollDownPage;    // ¹һ
    procedure ScrollLeftPage;    // һ
    procedure ScrollRightPage;   // ҹһ

    procedure SetCaretRowCol(Row, Col: Integer);
    procedure MakeOrderSelection(var SelStartRow, SelStartCol, SelEndRow, SelEndCol: Integer);

    function ClientXToVirtualX(X: Integer): Integer;
    function VirtualXToClientX(X: Integer): Integer;
    {* Űĺؼĺת}

    procedure GetVirtualCharPosVirtualRect(ARow, ACol: Integer; var Rect: TRect);
    {* Űڵ RectŰϽԭ}
    function GetVirtualCharPosPhysicalRect(ARow, ACol: Integer; var Rect: TRect): Boolean;
    {* ؼϵ RectǷɹעܳ TextRect}
    function GetColumnVirtualX(ARow, ACol: Integer): Integer;
    {* ĳĹλغ}
    procedure Paint; override;
    {* Ʒ}
    procedure DoPaintLineNum(ScreenLineNumber, LineNumber: Integer; LineNumRect: TRect); virtual;
    {* ĬϵĻкŵķ ScreenLineNumber Ϊ 1 ʼкţ
      LineNumber ΪкţLineNumRect ΪкŴƵķ}

    procedure DoPaintLineBackground(LineCanvas: TCanvas; LineNumber: Integer;
      LineRect: TRect); virtual;
    {* бĬʵÿؼ Color ɫ}
    procedure DoPaintLine(LineCanvas: TCanvas; LineNumber, HoriCharOffset: Integer;
      LineRect: TRect); virtual; abstract;
    {* ʵֵĻݵķ ScreenLineNumber Ϊ 1 ʼкţ
      LineNumber ΪкţHoriCharOffset ΪѾַϸ
      LineNumRect ΪݴƵĳ}

    function GetPaintLineNumber(LineNumber: Integer): Integer; virtual;
    {* ӹкŷкϻƵкţĬֱӷԭʼֵ
      ෵زֵͬԴ۵עֵⷵҪкֵ}

    function ClientPosToVirtualCharPos(Pt: TPoint; out Row, Col: Integer;
      out LeftHalf, DoubleWidth: Boolean; ExtendOut: Boolean = True): Boolean; virtual;
    {* ؼڵתΪ꣬ҲڼУڵڼַڣ
      Լַڿ뻹ǿҰ룬ȷλáǷɹ
      RowCol  1 ʼExtendOut Ϊ True ʱʾҲ￿ȥ
      עһҲܼɹ True}

    function CalcColumnFromPixelOffsetInLine(ARow, VirtualX: Integer;
      out Col: Integer; out LeftHalf, DoubleWidth: Boolean): Boolean; virtual;
    {*** кŰڵĺڵַ򣨻ַߣҲкţ1 ʼ
      LeftHalf  X λǷڴַߣDoubleWidth ظַǷ˫
      ڲʵǣȿʱֱӸַƽ FAveCharWidth 㣬ûǷ
      Ƿɹ}

    function CalcPixelOffsetFromColumnInLine(ARow, ACol: Integer; out Rect: TRect;
      out DoubleWidth: Boolean): Boolean; virtual;
    {*** ккţ㷵ظַڵǰзλ
      ˵йλõұַַԼַǷ˫ڷ
     Rect ԭǵǰеϽǣ Left ǹڵǰڵ꣩
      ǷɹFalse ʾвڣƩ˫ַֽɷָ}

    function GetLastColumnFromLine(LineNumber: Integer): Integer; virtual; abstract;
    {*** кŻøβֵʵ֣һݳȼ 1;޹
      ݣ뷵 1}

    function GetPrevColumn(AColumn, ARow: Integer): Integer; virtual;
    {** ĳĳеǰһУ;޹}
    function GetNextColumn(AColumn, ARow: Integer; ACaretAfterLineEnd: Boolean): Integer; virtual;
    {** ĳĳеĺһУ;޹}
    function GetNearestColumn(AColumn, ARow: Integer): Integer; virtual;
    {** ĳĳиĺϷУмʱҪӼһ}
  public
    procedure SetBounds(ALeft: Integer; ATop: Integer; AWidth: Integer;
      AHeight: Integer); override;

    constructor Create(AOwner: TComponent); override;
    {* 캯}
    destructor Destroy; override;
    {* }

    procedure SelectRange(StartRow, StartCol, EndRow, EndCol: Integer);
    {* ѡָ򣬹˳ƶѡβ}
    procedure SelectAll;
    {* ѡȫ}
    function HasSelection: Boolean;
    {* ǷѡڣҲжʼͽλǷͬ}

    property LineHeight: Integer read FLineHeight;
    {* иߣָ߶ȡ ExternalLeading Լм仭ԤĿ϶}
    property TopLine: Integer read GetTopLine;
    {* ؼʾһекţ FVertOffset + 1}
    property BottomLine: Integer read GetBottomLine;
    {* ؼʾһекţ FMaxLineCount
       FVertOffset + 1 + (TextRect.Bottom - TextRect.Top) div FLineHeight}

    property ScreenBottomLine: Integer read GetScreenBottomLine;
    {* һекţһек 1}
    property VisibleLineCount: Integer read GetVisibleLineCount;
    {* ӻʾ߶и}
    property MaxLineCount: Integer read FMaxLineCount write SetMaxLineCount;
    {* Ƶ}

    property WheelLinesCount: Integer read FWheelLinesCount write FWheelLinesCount;
    {* һι}
    property ShowLineNumber: Boolean read FShowLineNumber write SetShowLineNumber;
    {* Ƿʾк}
    property LineNumFocusBkColor: TColor read FLineNumFocusBkColor write SetLineNumFocusBkColor;
    {* нʱкıɫ}
    property LineNumNoFocusBkColor: TColor read FLineNumNoFocusBkColor write SetLineNumNoFocusBkColor;
    {* ޽ʱкıɫ}
    property LineNumColor: TColor read FLineNumColor write SetLineNumColor;
    {* кɫ}
    property UseCaret: Boolean read FUseCaret write SetUseCaret;
    {* Ƿʾ}
    property CaretAfterLineEnd: Boolean read FCaretAfterLineEnd write SetCaretAfterLineEnd;
    {* ǷԽβ}
    property ScreenCaretRow: Integer read GetScreenCaretRow;
    {* ǰλڵĻкţ1 ʼӦݹ仯Ĳ䣩
      ֵС 0ʾǰڿؼ⡣ûĻкŵԭ岻ȿ}
    property CaretRow: Integer read FCaretRow write SetCaretRow;
    {* ǰλڵĹкţ1 ʼʱ䣬
       ScreenCaretRow һ FVertOffset}
    property CaretCol: Integer read FCaretCol write SetCaretCol;
    {* ǰλڵĹкţ1 ʼʱ䣬
       ScreenCaretCol һ FHoriOffset}

    property UseSelection: Boolean read FUseSelection write SetUseSelection;
    {* Ƿѡ}

    property SelectStartRow: Integer read FSelectStartRow write SetSelectStartRow;
    {* ѡʼУ1 ʼк}
    property SelectStartCol: Integer read FSelectStartCol write SetSelectStartCol;
    {* ѡʼУ1 ʼк}
    property SelectEndRow: Integer read FSelectEndRow write SetSelectEndRow;
    {* ѡУ1 ʼк}
    property SelectEndCol: Integer read FSelectEndCol write SetSelectEndCol;
    {* ѡУ1 ʼк}

    property OnScroll: TNotifyEvent read FOnScroll write FOnScroll;
    {* ¼}
    property OnCaretChange: TNotifyEvent read FOnCaretChange write FOnCaretChange;
    {* ƶ¼}
    property OnSelectChange: TNotifyEvent read FOnSelectChange write SetOnSelectChange;
    {* ѡıʱעʱ겻һ̧}
  published
    property Align;
    property Ctl3D;
    property Color;
    property Font;
  end;

resourcestring
  SCnTextControlErrorColumn = 'Error Column';

implementation

{$IFDEF DEBUG}
uses
  CnDebug;
{$ENDIF}

const
  MAX_NO_EXP_LINES = 32768;
  LEFT_MARGIN = 3;             // кߵĿ϶
  COMMON_MARGIN = 3;           // Ŀ϶
  SEP_WIDTH = 3;               // кָߵĿ
  LINE_GAP = 2;                // ֮Ŀ϶û»߲
  CARET_MARGIN = 3;
  DEFAULT_MAX_WIDTH = 255;

function GetNumWidth(Int: Integer): Integer;
begin
  Result := Length(IntToStr(Int));
end;

function EnumFontsProc(var ELF: TEnumLogFont; var TM: TNewTextMetric;
  FontType: Integer; Data: LPARAM): Integer; stdcall;
begin;
  Result := Integer(FIXED_PITCH = (ELF.elfLogFont.lfPitchAndFamily and FIXED_PITCH));
end;

{ TCnTextControl }

procedure TCnVirtualTextControl.CalcMetrics;
const
  csAlphaText = 'abcdefghijklmnopqrstuvwxyz';
  csHeightText = 'Wj_';
  csWidthText = '1';
var
  LogFont: TLogFont;
  DC: HDC;
  SaveFont: HFONT;
  AHandle: THandle;
  TM: TEXTMETRIC;
  ASize: TSize;
begin
  FLineHeight := 0;

  if GetObject(Font.Handle, SizeOf(LogFont), @LogFont) <> 0 then
  begin
    DC := CreateCompatibleDC(0);
    SaveFont := 0;
    try
      AHandle := CreateFontIndirect(LogFont);
      AHandle := SelectObject(DC, AHandle);
      if SaveFont = 0 then
        SaveFont := AHandle
      else if AHandle <> 0 then
        DeleteObject(AHandle);

      GetTextMetrics(DC, TM);
      FAveCharWidth := TM.tmAveCharWidth; // õַƽ
      FMaxCharWidth := TM.tmMaxCharWidth; // õַ

      GetTextExtentPoint(DC, csAlphaText, Length(csAlphaText), ASize);

      // ȡı߶и
      if TM.tmHeight + TM.tmExternalLeading > FLineHeight then
        FLineHeight := TM.tmHeight + TM.tmExternalLeading;

      if ASize.cy > FLineHeight then
        FLineHeight := ASize.cy;

      // FLineHeight Ҫ¿϶Լ»ߵĿռ
      Inc(FLineHeight, LINE_GAP);

      // 
      if ASize.cx div Length(csAlphaText) > FAveCharWidth then
        FAveCharWidth := ASize.cx div Length(csAlphaText);

      // ͨһַʽַĴС
      GetTextExtentPoint32(DC, csWidthText, Length(csWidthText), ASize);
      FCharFrameSize.x := ASize.cx;
      FAveCharWidthHalf := FCharFrameSize.x shr 1;

      GetTextExtentPoint32(DC, csHeightText, Length(csHeightText), ASize);
      FCharFrameSize.y := ASize.cy;

      // кſ
      GetTextExtentPoint32(DC, PChar(FLineNumPattern), Length(FLineNumPattern), ASize);
      FLineNumWidth := ASize.cx;

      // жǷȿ
{$IFDEF DELPHI104_SYDNEY_UP}
      FFontIsFixedWidth := EnumFontFamiliesEx(DC, LogFont, @EnumFontsProc, 0, 0) = 1;
{$ELSE}
      FFontIsFixedWidth := EnumFontFamiliesEx(DC, LogFont, @EnumFontsProc, 0, 0) = BOOL(1);
{$ENDIF}
    finally
      SaveFont := SelectObject(DC, SaveFont);
      if SaveFont <> 0 then
        DeleteObject(SaveFont);
      DeleteDC(DC);
    end;
  end;
end;

function TCnVirtualTextControl.ClientPosToVirtualCharPos(Pt: TPoint; out Row,
  Col: Integer; out LeftHalf, DoubleWidth: Boolean; ExtendOut: Boolean): Boolean;
var
  TR: TRect;
  SR: Integer;
begin
  Result := False;
  TR := GetTextRect;

  if ExtendOut then
  begin
    // ڷʱжϷ
    if Pt.x < TR.Left then
      Pt.x := TR.Left + 1;
    if Pt.x > TR.Right then
      Pt.x := TR.Right - 1;
    if Pt.y < TR.Top then
      Pt.y := TR.Top + 1;
    if Pt.y > TR.Bottom then
      Pt.y := TR.Bottom - 1;
  end;

  if PtInRect(TR, Pt) then
  begin
    SR := ((Pt.y - TR.Top) div FLineHeight) + 1;
    Row := ScreenLineNumberToLineNumber(SR);

    // ؼڵҪת
    Result := CalcColumnFromPixelOffsetInLine(Row, ClientXToVirtualX(Pt.x), Col,
      LeftHalf, DoubleWidth);
  end;
end;

constructor TCnVirtualTextControl.Create(AOwner: TComponent);
begin
  inherited;
  ControlStyle := [csCaptureMouse, csOpaque, csClickEvents, csDoubleClicks];
  SetBounds(Left, Top, 300, 200);
  ParentFont := True;
  ParentColor := False;
  TabStop := True;
  DoubleBuffered := True;

  FLineNumCount := 1;
  FLineNumPattern := '0';
  FLineHeight := 12;
  FWheelLinesCount := 3;

  FLineNumColor := clNavy;
  FLineNumFocusBkColor := clSilver;
  FLineNumNoFocusBkColor := clGray;

  FCaretRow := 1;
  FCaretCol := 1;
  FCaretAfterLineEnd := True;

  CalcMetrics;
end;

procedure TCnVirtualTextControl.CreateParams(var Params: TCreateParams);
begin
  inherited;
  with Params do
  begin
    Style := Style or WS_VSCROLL or WS_HSCROLL or WS_TABSTOP;
    if NewStyleControls and Ctl3D then
      ExStyle := ExStyle or WS_EX_CLIENTEDGE
    else
      Style := Style or WS_BORDER;
  end;
end;

destructor TCnVirtualTextControl.Destroy;
begin

  inherited;
end;


procedure TCnVirtualTextControl.DoPaintLineNum(ScreenLineNumber,
  LineNumber: Integer; LineNumRect: TRect);
begin
  Canvas.TextOut(LineNumRect.Left, LineNumRect.Top, IntToStr(LineNumber));
end;

procedure TCnVirtualTextControl.DoScroll;
begin
  if Assigned(FOnScroll) then
    FOnScroll(Self);
end;

//procedure TCnVirtualTextControl.GetScreenCharPosRect(ScreenRow,
//  ScreenCol: Integer; var Rect: TRect);
//begin
//  Rect := GetTextRect;
//  Inc(Rect.Top, (ScreenRow - 1) * FLineHeight);
//  Inc(Rect.Left, (ScreenCol - 1) * FCharFrameSize.x);
//
//  Rect.Bottom := Rect.Top + FLineHeight;
//  Rect.Right := Rect.Left + FCharFrameSize.x;
//end;

procedure TCnVirtualTextControl.GetVirtualCharPosVirtualRect(ARow,
  ACol: Integer; var Rect: TRect);
var
  DW: Boolean;
  DV: Integer;
begin
  if not CalcPixelOffsetFromColumnInLine(ARow, ACol, Rect, DW) then
    raise ECnTextControlException.Create(SCnTextControlErrorColumn);

  // õ Rect һڵַ꣬ϽΪͷҪתŰ
  // עøĶ

  // صµ Rect.Top
  DV := (ARow - 1) * FLineHeight;
  Inc(Rect.Top, DV);
  Inc(Rect.Bottom, DV);
end;

function TCnVirtualTextControl.GetVirtualCharPosPhysicalRect(ARow, ACol: Integer;
  var Rect: TRect): Boolean;
var
  DW: Boolean;
  DH, DV: Integer;
begin
  Result := False;
  if not CalcPixelOffsetFromColumnInLine(ARow, ACol, Rect, DW) then
    Exit;

  // õ Rect һڵַ꣬ϽΪͷҪתɿؼ

  // ص Rect.Top  TextRect ϱߵľ
  DV := GetTextRect.Top + ((LineNumberToScreenLineNumber(ARow) - 1) * FLineHeight);
  Inc(Rect.Top, DV);
  Inc(Rect.Bottom, DV);

  DH := GetTextRect.Left - GetHoriPixelsOffset;

  // صĺȥ Rect.Left  TextRect ߵľ
  Inc(Rect.Left, DH);
  Inc(Rect.Right, DH);
  Result := True;
end;

function TCnVirtualTextControl.CalcColumnFromPixelOffsetInLine(ARow,
  VirtualX: Integer; out Col: Integer; out LeftHalf, DoubleWidth: Boolean): Boolean;
var
  T: Integer;
begin
  // ȿûɶ⣬ú
  // ǵȿͲˣúʵ
  Col := (VirtualX div FAveCharWidth) + 1;

  T := VirtualX - (Col - 1) * FAveCharWidth;
  LeftHalf := T <= FAveCharWidthHalf;
  DoubleWidth := False;

  Result := True;
end;

function TCnVirtualTextControl.GetPaintLineNumber(LineNumber: Integer): Integer;
begin
  Result := LineNumber;
end;

function TCnVirtualTextControl.GetTextRect: TRect;
begin
  Result.Top := COMMON_MARGIN;
  Result.Left := GetTextRectLeft;
  Result.Bottom := Result.Top + FLineHeight * VisibleLineCount;
  Result.Right := ClientWidth;
end;

function TCnVirtualTextControl.GetTextRectLeft: Integer;
begin
  Result := LEFT_MARGIN;
  if FShowLineNumber then
    Inc(Result, LEFT_MARGIN + FLineNumWidth + COMMON_MARGIN + SEP_WIDTH);
    // ı߾ƶƵľΪкȼϻ߿
end;

function TCnVirtualTextControl.GetTopLine: Integer;
begin
  Result := FVertOffset + 1;
end;

function TCnVirtualTextControl.GetBottomLine: Integer;
begin
  Result := FVertOffset + GetVisibleLineCount;
  if Result > FMaxLineCount then
    Result := FMaxLineCount;
end;

function TCnVirtualTextControl.GetVisibleLineCount: Integer;
begin
  if HandleAllocated then
    Result := (ClientHeight - COMMON_MARGIN * 2) div FLineHeight
  else
    Result := 0;
end;

procedure TCnVirtualTextControl.NavigationKey(Key: WORD; Shift: TShiftState);
var
  Msg: TWMScroll;
begin
  if FUseCaret then
  begin
    // йʱķ
    if not (ssShift in Shift) then
    begin
      // û Shiftѡģʽƶ꣬ȡѡ񲢸½
      if SyncSelectionStartEnd(True) then
        Invalidate;

      case Key of
        VK_LEFT:
          begin
            // Ʋֿɼ
            CaretCol := GetPrevColumn(CaretCol, CaretRow);
            ScrollToVisibleCaret;
          end;
        VK_RIGHT:
          begin
            // Ʋֿɼ
            CaretCol := GetNextColumn(CaretCol, CaretRow, CaretAfterLineEnd);
            ScrollToVisibleCaret;
          end;
        VK_UP:
          begin
            // Ʋֿɼ
            CaretRow := CaretRow - 1;
            CaretCol := GetNearestColumn(CaretCol, CaretRow);
            ScrollToVisibleCaret;
          end;
        VK_DOWN:
          begin
            // Ʋֿɼ
            CaretRow := CaretRow + 1;
            CaretCol := GetNearestColumn(CaretCol, CaretRow);
            ScrollToVisibleCaret;
          end;
        VK_PRIOR:
          begin
            CaretRow := CaretRow - GetVisibleLineCount;
            CaretCol := GetNearestColumn(CaretCol, CaretRow);
            ScrollToVisibleCaret;
          end;
        VK_NEXT:
          begin
            CaretRow := CaretRow + GetVisibleLineCount;
            CaretCol := GetNearestColumn(CaretCol, CaretRow);
            ScrollToVisibleCaret;
          end;
        VK_HOME:
          begin
            if ssCtrl in Shift then // Ctrl ʱص
              CaretRow := 1;

            CaretCol := 1; // ص
            ScrollToVisibleCaret;
          end;
        VK_END:
          begin
            if ssCtrl in Shift then // Ctrl ʱصββ
              CaretRow := FMaxLineCount;

            CaretCol := GetLastColumnFromLine(FMaxLineCount); // صβ
            ScrollToVisibleCaret;
          end;
      end;
    end
    else
    begin
      //  Shiftѡյλ
      if not FUseSelection then
        Exit;

      case Key of
        VK_LEFT:
          begin
            // ѡյƲֿɼ
            SelectEndCol := GetPrevColumn(SelectEndCol, CaretRow);
            ScrollToVisibleCaret;
          end;
        VK_RIGHT:
          begin
            // ѡյƲֿɼ
            SelectEndCol := GetNextColumn(SelectEndCol, CaretRow, CaretAfterLineEnd);
            ScrollToVisibleCaret;
          end;
        VK_UP:
          begin
            // ѡյƲֿɼ
            SelectEndRow := SelectEndRow - 1;
            SelectEndCol := GetNearestColumn(SelectEndCol, SelectEndRow);
            ScrollToVisibleCaret;
          end;
        VK_DOWN:
          begin
            // ѡյƲֿɼ
            SelectEndRow := SelectEndRow + 1;
            SelectEndCol := GetNearestColumn(SelectEndCol, SelectEndRow);
            ScrollToVisibleCaret;
          end;
        VK_PRIOR:
          begin
            SelectEndRow := SelectEndRow - GetVisibleLineCount;
            SelectEndCol := GetNearestColumn(SelectEndCol, SelectEndRow);
            ScrollToVisibleCaret;
          end;
        VK_NEXT:
          begin
            SelectEndRow := SelectEndRow + GetVisibleLineCount;
            SelectEndCol := GetNearestColumn(SelectEndCol, SelectEndRow);
            ScrollToVisibleCaret;
          end;
        VK_HOME:
          begin
            if ssCtrl in Shift then // Ctrl ʱѡ
              SelectEndRow := 1;

            SelectEndCol := 1; // ѡ
            ScrollToVisibleCaret;
          end;
        VK_END:
          begin
            if ssCtrl in Shift then // Ctrl ʱѡββ
              SelectEndRow := FMaxLineCount;

            SelectEndCol := GetLastColumnFromLine(FMaxLineCount); // ѡβ
            ScrollToVisibleCaret;
          end;
      end;
    end;
  end
  else // ûй꣬ƶ򣬲 Ctrl ļͷβ
  begin
    case Key of
      VK_LEFT: ScrollLeftCol;
      VK_RIGHT: ScrollRightCol;
      VK_UP: ScrollUpLine;
      VK_DOWN: ScrollDownLine;
      VK_PRIOR: ScrollUpPage;
      VK_NEXT: ScrollDownPage;
      VK_HOME:
        begin
          Msg.ScrollCode := SB_THUMBTRACK;
          Msg.Pos := 0;
          WMHScroll(Msg);

          if ssCtrl in Shift then
          begin
            Msg.ScrollCode := SB_THUMBTRACK;
            Msg.Pos := 0;
            WMVScroll(Msg);
          end;
        end;
      VK_END:
        begin
          if ssCtrl in Shift then
          begin
            Msg.ScrollCode := SB_THUMBTRACK;
            Msg.Pos := FMaxLineCount;
            WMVScroll(Msg);
          end;

          Msg.ScrollCode := SB_THUMBTRACK;
          Msg.Pos := DEFAULT_MAX_WIDTH;
          WMHScroll(Msg);
        end;
    end;
  end;
end;

procedure TCnVirtualTextControl.KeyDown(var Key: WORD; Shift: TShiftState);
begin
  inherited;
  if Assigned(OnKeyDown) then
    OnKeyDown(Self, Key, Shift);

  case Key of
    VK_UP, VK_DOWN, VK_PRIOR, VK_NEXT, VK_HOME, VK_END, VK_LEFT, VK_RIGHT:
      NavigationKey(Key, Shift);
  end;
end;

procedure TCnVirtualTextControl.MouseDown(Button: TMouseButton;
  Shift: TShiftState; X, Y: integer);
begin
  inherited;
  if not Focused then
    Windows.SetFocus(Handle);

  UpdateCursorFrameCaret;
  ScrollToVisibleCaret;

  if Button = mbLeft then
  begin
    FLeftMouseDown := True;
    FLeftMouseMoveAfterDown := False;
  end;
end;

procedure TCnVirtualTextControl.Paint;
var
  TR, LR, LineRect: TRect;
  LC: TColor;
  I, V, H: Integer;
  LineBmp: TBitmap;
  LineCanvas: TCanvas;
begin
  // Ȼк
  TR := ClientRect;
  LR := ClientRect;

  Canvas.Brush.Style := bsSolid;
  Canvas.Brush.Color := Color;
  Canvas.FillRect(TR);

  TR.Left := GetTextRectLeft;
  TR.Top := COMMON_MARGIN;
  V := VisibleLineCount;
  H := GetHoriPixelsOffset;

  if FShowLineNumber then // кĵɫĬϵкŻ
  begin
    if Focused then
      LC := FLineNumFocusBkColor
    else
      LC := FLineNumNoFocusBkColor;

    // кΪ Margin + LineNumWidth + Margin
    //  Left Ϊ MarginWidth Ϊ LineNumWidth + Margin

    LR.Right := LEFT_MARGIN + FLineNumWidth + LEFT_MARGIN + SEP_WIDTH;  // SEP_WIDTH ǻ߿

    Canvas.Brush.Color := LC;
    Canvas.FillRect(LR);

    Inc(LR.Left, LEFT_MARGIN);
    Inc(LR.Top, COMMON_MARGIN);

    Canvas.Pen.Color := clGray;
    Dec(LR.Right);
    Canvas.MoveTo(LR.Right, 0);
    Canvas.LineTo(LR.Right, ClientHeight);
    Canvas.Pen.Color := clWhite;
    Dec(LR.Right);
    Canvas.MoveTo(LR.Right, 0);
    Canvas.LineTo(LR.Right, ClientHeight);
    Canvas.Pen.Color := clSilver;
    Dec(LR.Right);
    Canvas.MoveTo(LR.Right, 0);
    Canvas.LineTo(LR.Right, ClientHeight);

    LR.Bottom := COMMON_MARGIN + FLineHeight;

    Canvas.Font.Color := FLineNumColor;
    Canvas.Brush.Style := bsClear;

    for I := 1 to V do
    begin
      if I + FVertOffset <= FMaxLineCount then
        DoPaintLineNum(I, GetPaintLineNumber(I + FVertOffset), LR);

      Inc(LR.Top, FLineHeight);
      Inc(LR.Bottom, FLineHeight);
    end;
  end;

  TR.Bottom := TR.Top + FLineHeight;
  // TR ǿؼڲҪƵĵǰе

  LineBmp := TBitmap.Create;
  LineBmp.PixelFormat := pf24bit;
  LineBmp.Height := FLineHeight;
  LineBmp.Width := H + (FTextRect.Right - FTextRect.Left);

  LineCanvas := LineBmp.Canvas;
  LineCanvas.Font.Assign(Font);

  try
    for I := 1 to V do // I 
    begin
      LineRect := Bounds(0, 0, LineBmp.Width, LineBmp.Height);

      //  LineBmp Background
      DoPaintLineBackground(LineCanvas, I + FVertOffset, LineRect);

      // 
      DoPaintLine(LineCanvas, I + FVertOffset, FHoriOffset, LineRect);

      // ݸƹȥ
      BitBlt(Canvas.Handle, TR.Left, TR.Top, LineBmp.Width - H,
        LineBmp.Height, LineCanvas.Handle, H, 0, SRCCOPY);

      Inc(TR.Top, FLineHeight);
      Inc(TR.Bottom, FLineHeight);
    end;
  finally
    LineBmp.Free;
  end;
end;

function TCnVirtualTextControl.ScreenLineNumberToLineNumber(
  ScreenLineNumber: Integer): Integer;
begin
  Result := ScreenLineNumber + FVertOffset;
end;

procedure TCnVirtualTextControl.SetLineNumColor(const Value: TColor);
begin
  if FLineNumColor <> Value then
  begin
    FLineNumColor := Value;
    Invalidate;
  end;
end;

procedure TCnVirtualTextControl.SetLineNumFocusBkColor(const Value: TColor);
begin
  if FLineNumFocusBkColor <> Value then
  begin
    FLineNumFocusBkColor := Value;
    Invalidate;
  end;
end;

procedure TCnVirtualTextControl.SetLineNumNoFocusBkColor(const Value: TColor);
begin
  if FLineNumNoFocusBkColor <> Value then
  begin
    FLineNumNoFocusBkColor := Value;
    Invalidate;
  end;
end;

procedure TCnVirtualTextControl.SetMaxLineCount(const Value: Integer);
var
  Old: Integer;
begin
  if FMaxLineCount <> Value then
  begin
    FMaxLineCount := Value;

    Old := FLineNumCount;
    FLineNumCount := GetNumWidth(Value);
    FLineNumPattern := StringOfChar('0', FLineNumCount);

    if FLineNumCount <> Old then // λ仯¼ FLineNumWidth
    begin
      CalcMetrics;
      UpdateRects;
      UpdateScrollBars;
    end;
    Invalidate;
  end;
end;

procedure TCnVirtualTextControl.SetShowLineNumber(const Value: Boolean);
begin
  if FShowLineNumber <> Value then
  begin
    FShowLineNumber := Value;
    UpdateRects;
    Invalidate;
  end;
end;

procedure TCnVirtualTextControl.UpdateScrollBars;
var
  SI: TScrollInfo;
begin
  if not HandleAllocated then
    Exit;

  SI.cbSize := SizeOf(TScrollInfo);
  SI.fMask := SIF_RANGE or SIF_POS or SIF_PAGE;
  SI.nMin := 0;

  // 
  FVertExp := 0;
  SI.nMax := FMaxLineCount - 1;       // nMax 
  while SI.nMax > MAX_NO_EXP_LINES do // к̫ʱָʽ̫ϸ
  begin
    SI.nMax := SI.nMax div 2;
    Inc(FVertExp);
  end;

  SI.nPage := VisibleLineCount shr FVertExp; // nPage һݶӦĸ߶
  SI.nPos := FVertOffset shr FVertExp;
  SetScrollInfo(Handle, SB_VERT, SI, True);

  // 
  SI.nMax := DEFAULT_MAX_WIDTH;              // ֪д 256 
  SI.nPage := ClientWidth div FAveCharWidth;    // nPage һݶӦַ
  SI.nPos := FHoriOffset;
  SetScrollInfo(Handle, SB_HORZ, SI, True);
end;

procedure TCnVirtualTextControl.WMGetDlgCode(var Msg: TWMGetDlgCode);
begin
  Msg.Result := DLGC_WANTARROWS;
end;

procedure TCnVirtualTextControl.WMHScroll(var message: TWMScroll);
var
  SI: TScrollInfo;
  Old: Integer;
begin
  SI.cbSize := SizeOf(TScrollInfo);
  SI.fMask := SIF_RANGE or SIF_PAGE or SIF_POS;
  GetScrollInfo(Handle, SB_HORZ, SI);

  Old := FHoriOffset;
  case message.ScrollCode of
    SB_PAGEUP: Dec(FHoriOffset, (FTextRect.Right - FTextRect.Left) div FAveCharWidth);  // һĿ
    SB_PAGEDOWN: Inc(FHoriOffset, (FTextRect.Right - FTextRect.Left) div FAveCharWidth);
    SB_LINEUP: Dec(FHoriOffset);
    SB_LINEDOWN: Inc(FHoriOffset);
    SB_THUMBTRACK: FHoriOffset := message.Pos;
  end;

  if FHoriOffset > SI.nMax - (FTextRect.Right - FTextRect.Left) div FAveCharWidth then
    FHoriOffset := SI.nMax - (FTextRect.Right - FTextRect.Left) div FAveCharWidth;

  if FHoriOffset < 0 then
    FHoriOffset := 0;

  if FHoriOffset = Old then
    Exit;

  SI.nPos := FHoriOffset;
  SetScrollInfo(Handle, SB_HORZ, SI, True);

  Refresh;

  // ʱ겻ܻᶯ
  SyncCaretPosition;
  SyncSelectionStartEnd;

  DoScroll;
end;

procedure TCnVirtualTextControl.WMKillFocus(var message: TWMSetFocus);
begin
  inherited;
  DestroyCaret;
  FCaretVisible := False;

  Invalidate;
end;

procedure TCnVirtualTextControl.WMMouseWheel(var message: TWMMouseWheel);
var
  I: Integer;
begin
  // עʱ FCaretRow  FCaretCol 䣬ҿܵ TextRect ͷȥ
  if GetKeyState(VK_CONTROL) < 0 then
  begin
    FIsWheeling := True;
    try
      if message.WheelDelta > 0 then
        ScrollUpPage
      else
        ScrollDownPage;
    finally
      FIsWheeling := False;
    end;
  end
  else
  begin
    FIsWheeling := True;
    try
      if message.WheelDelta > 0 then
      begin
        for I := 0 to FWheelLinesCount - 1 do
          ScrollUpLine;
      end
      else
      begin
        for I := 0 to FWheelLinesCount - 1 do
          ScrollDownLine;
      end;
    finally
      FIsWheeling := False;
    end;
  end;
end;

procedure TCnVirtualTextControl.WMSetFocus(var message: TWMSetFocus);
begin
  inherited;

  if FLineHeight <= 0 then
    CalcMetrics;

  if FUseCaret then
  begin
    CreateCaret(Handle, HBITMAP(0), 2, FLineHeight);
    SetCaretBlinkTime(GetCaretBlinkTime);

    DisplayCaret(True);
  end;

  Invalidate;
end;

procedure TCnVirtualTextControl.WMSetFont(var message: TMessage);
begin
  inherited;
  Canvas.Font := Font;

  CalcMetrics;
  UpdateRects;
  UpdateScrollbars;
end;

procedure TCnVirtualTextControl.WMSize(var message: TWMSize);
begin
  inherited;
  UpdateRects;
  UpdateScrollBars;
end;

procedure TCnVirtualTextControl.WMVScroll(var message: TWMScroll);
var
  SI: TScrollInfo;
  Old, VL: Integer;
begin
  VL := VisibleLineCount;
  SI.cbSize := SizeOf(TScrollInfo);
  SI.fMask := SIF_RANGE or SIF_PAGE or SIF_POS;
  GetScrollInfo(Handle, SB_VERT, SI);

  Old := FVertOffset;
  case message.ScrollCode of
    SB_PAGEUP: Dec(FVertOffset, VL);
    SB_PAGEDOWN: Inc(FVertOffset, VL);
    SB_LINEUP: Dec(FVertOffset);
    SB_LINEDOWN: Inc(FVertOffset);
    SB_THUMBTRACK: FVertOffset := message.Pos shl FVertExp;
  end;

  if FVertOffset > FMaxLineCount - VL then
    FVertOffset := FMaxLineCount - VL;
  if FVertOffset < 0 then
    FVertOffset := 0;

  if FVertOffset = Old then
    Exit;

  SI.nPos := FVertOffset shr FVertExp;
  SetScrollInfo(Handle, SB_VERT, SI, True);

  Refresh;

  // ʱһ㲻ᶯ
  SyncCaretPosition;
  SyncSelectionStartEnd;

  DoScroll;
end;

procedure TCnVirtualTextControl.SetUseCaret(const Value: Boolean);
begin
  if FUseCaret <> Value then
  begin
    FUseCaret := Value;
    if FUseCaret then   // ֻ
    begin
      if HandleAllocated then
      begin
        CreateCaret(Handle, HBITMAP(0), 2, FLineHeight - 2);
        SetCaretBlinkTime(GetCaretBlinkTime);

        DisplayCaret(Focused);
      end;
    end
    else
    begin
      DisplayCaret(False);
      DestroyCaret;
    end;
  end;
end;

procedure TCnVirtualTextControl.DisplayCaret(ACaretVisible: Boolean);
begin
  if ACaretVisible and Focused then
  begin
    if HandleAllocated then
    begin
      // FCaretVisible := True;
      SyncCaretPosition;
    end;
  end
  else if not ACaretVisible then
  begin
    HideCaret(Handle);
    FCaretVisible := False;
  end;
end;

procedure TCnVirtualTextControl.UpdateCursorFrameCaret;
var
  P: TPoint;
begin
  P := ScreenToClient(Mouse.CursorPos);
  if CalcRowCol(P, FCaretRow, FCaretCol, FCharFrameIsLeft, FCharFrameDoubleWidth) then
  begin
    // ùλ
    SyncCaretPosition;
    SyncSelectionStartEnd;
    DoCaretChange;
  end;
end;

function TCnVirtualTextControl.ScreenColNumberToColNumber(
  ScreenColNumber: Integer): Integer;
begin
  Result := ScreenColNumber + FHoriOffset;
end;

procedure TCnVirtualTextControl.SetCaretCol(const Value: Integer);
begin
  FCaretCol := Value;

  //  FCaretRow ж FCaretCol Ƿ񳬳β
  //  FCaretCol
  LimitRowColumnInLine(FCaretRow, FCaretCol);

  if FUseCaret then
  begin
    SyncCaretPosition;
    SyncSelectionStartEnd;
    DoCaretChange;
  end;
end;

procedure TCnVirtualTextControl.SetCaretRow(const Value: Integer);
begin
  FCaretRow := Value;

  //  FCaretRow ж FCaretRow Ƿ FMaxLineCount  FCaretCol Ƿ񳬳β
  //  FCaretCol
  LimitRowColumnInLine(FCaretRow, FCaretCol);

  // ͬ ScreenCaretCol  ScreenCaretRow
  if FUseCaret then
  begin
    SyncCaretPosition;
    SyncSelectionStartEnd;
    DoCaretChange;
  end;
end;

procedure TCnVirtualTextControl.UpdateRects;
begin
  if not HandleAllocated then
    Exit;

  FTextRect.Left := GetTextRectLeft;
  FTextRect.Top := COMMON_MARGIN;
  FTextRect.Bottom := ClientRect.Bottom - COMMON_MARGIN;
  FTextRect.Right := ClientRect.Right - COMMON_MARGIN;

  FGutterRect.Top := COMMON_MARGIN;
  FGutterRect.Bottom := COMMON_MARGIN;
  if ShowLineNumber then
  begin
    FGutterRect.Left := LEFT_MARGIN;
    FGutterRect.Right := LEFT_MARGIN + FLineNumWidth + COMMON_MARGIN;
  end
  else
  begin
    FGutterRect.Left := 0;
    FGutterRect.Right := 0;
  end;
end;

function TCnVirtualTextControl.GetScreenBottomLine: Integer;
begin
  Result := GetBottomLine - GetTopLine + 1;
end;

function TCnVirtualTextControl.ColNumberToScreenColNumber(
  ColNumber: Integer): Integer;
begin
  Result := ColNumber - FHoriOffset;
end;

function TCnVirtualTextControl.LineNumberToScreenLineNumber(
  LineNumber: Integer): Integer;
begin
  Result := LineNumber - FVertOffset;
end;

procedure TCnVirtualTextControl.DoCaretChange;
begin
  if Assigned(FOnCaretChange) then
    FOnCaretChange(Self);
end;

procedure TCnVirtualTextControl.SetCaretAfterLineEnd(const Value: Boolean);
begin
  if FCaretAfterLineEnd <> Value then
  begin
    FCaretAfterLineEnd := Value;
    LimitRowColumnInLine(FCaretRow, FCaretCol);

    // ǰнùλ
    if FUseCaret and Focused then
    begin
      SyncCaretPosition;
      SyncSelectionStartEnd;
      DoCaretChange;
    end;
    Invalidate;
  end;
end;

procedure TCnVirtualTextControl.LimitRowColumnInLine(var LineNumber, Column: Integer);
var
  C: Integer;
begin
  if LineNumber <= 0 then
    LineNumber := 1;

  if LineNumber > FMaxLineCount then
    LineNumber := FMaxLineCount;

  if Column <= 0 then
    Column := 1;

  if not CaretAfterLineEnd then
  begin
    C := GetLastColumnFromLine(LineNumber);
    if C < Column then
    begin
      Column := C;
      if Column <= 0 then
        Column := 1;
    end;
  end;
end;

procedure TCnVirtualTextControl.SetSelectEndCol(const Value: Integer);
begin
  if FSelectEndCol <> Value then
  begin
    FSelectEndCol := Value;
    LimitRowColumnInLine(FSelectEndRow, FSelectEndCol);
    SetCaretRowCol(FSelectEndRow, FSelectEndCol);
    Invalidate;
    DoSelectChange;
  end;
end;

procedure TCnVirtualTextControl.SetSelectEndRow(const Value: Integer);
begin
  if FSelectEndRow <> Value then
  begin
    FSelectEndRow := Value;
    LimitRowColumnInLine(FSelectEndRow, FSelectEndCol);
    SetCaretRowCol(FSelectEndRow, FSelectEndCol);
    Invalidate;
    DoSelectChange;
  end;
end;

procedure TCnVirtualTextControl.SetSelectStartCol(const Value: Integer);
begin
  if FSelectStartCol <> Value then
  begin
    FSelectStartCol := Value;
    LimitRowColumnInLine(FSelectStartRow, FSelectStartCol);
    Invalidate;
    DoSelectChange;
  end;
end;

procedure TCnVirtualTextControl.SetSelectStartRow(const Value: Integer);
begin
  if FSelectStartRow <> Value then
  begin
    FSelectStartRow := Value;
    LimitRowColumnInLine(FSelectStartRow, FSelectStartCol);
    Invalidate;
    DoSelectChange;
  end;
end;

procedure TCnVirtualTextControl.MouseMove(Shift: TShiftState; X,
  Y: Integer);
var
  P: TPoint;
  TR: TRect;
begin
  inherited;

  if FLeftMouseDown then
  begin
    P.x := X;
    P.y := Y;

    // ϶˱Եȹһ SetCapture
    TR := GetTextRect;
    if P.x < TR.Left then
      ScrollLeftCol
    else if P.x > TR.Right then
      ScrollRightCol;

    if P.y < TR.Top then
      ScrollUpLine
    else if P.y > TR.Bottom then
      ScrollDownLine;

    if FUseSelection then     // ϶ʱ֧ѡѡβ
    begin
      if not FLeftMouseMoveAfterDown then // ϶ MouseDown ״ Move
      begin
        // TODO: жǷѡٴ϶קڼ򵥵ȡѡ׼ٴѡ
        SyncSelectionStartEnd(True);
      end;

      FLeftMouseMoveAfterDown := True;

      CalcSelectEnd(P); // Ȼεѡ
      SetCaretRowCol(FSelectEndRow, FSelectEndCol); // ͬʱҲƶ
    end
    else
    begin
      UpdateCursorFrameCaret; // ϶ʱ֧ѡҲƶ
      ScrollToVisibleCaret;
    end;
  end;
end;

procedure TCnVirtualTextControl.MouseUp(Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  inherited;

  if Button = mbLeft then
  begin
    FLeftMouseDown := False;
    if FUseSelection then  // ̧ʱҪͨʲôȡǰѡδ϶
    begin
      if not FLeftMouseMoveAfterDown and HasSelection then // ϶ɶδ϶ȡѡ
      begin
        SyncSelectionStartEnd(True);
        Invalidate;
        DoSelectChange;
      end;
    end;
  end;
end;

procedure TCnVirtualTextControl.SetCaretRowCol(Row, Col: Integer);
begin
  FCaretRow := Row;
  FCaretCol := Col;

  //  FCaretRow ж FCaretCol Ƿ񳬳β
  //  FCaretCol
  LimitRowColumnInLine(FCaretRow, FCaretCol);

  if FUseCaret then
  begin
    SyncCaretPosition;
    SyncSelectionStartEnd;
    DoCaretChange;
  end;
end;

procedure TCnVirtualTextControl.ScrollToVisibleCaret;
var
  M: Boolean;
  L: Integer;
begin
  if not HandleAllocated and not FUseCaret then
    Exit;

  M := False;
  if FCaretRow < GetTopLine then
  begin
    Dec(FVertOffset, GetTopLine - FCaretRow);
    M := True;
  end
  else if FCaretRow > GetBottomLine then
  begin
    Inc(FVertOffset, FCaretRow - GetBottomLine);
    M := True;
  end;

  // ǵȿУֱӱȽСȼǰ Column Ӧ࣬ѹȽ
  L := GetColumnVirtualX(FCaretRow, FCaretCol);
  if GetHoriPixelsOffset > L - CARET_MARGIN then
  begin
    // ѹ˵ǰ Column ࣬Ҫൽպñ L ӦַСһ
    FHoriOffset := L div FAveCharWidth;
    M := True;
  end
  else if GetHoriPixelsOffset + (FTextRect.Right - FTextRect.Left) < L + CARET_MARGIN then
  begin
    // ѹıȣҲѹҲࣩ̫С˵ǰ Column Ҳ࣬
    // ҪൽҲӦַȴһ
    FHoriOffset := ((L - (FTextRect.Right - FTextRect.Left)) div FAveCharWidth) + 1;
    M := True;
  end;

  if M then
  begin
    Invalidate;
    SyncCaretPosition;
    UpdateScrollBars;
    DoScroll;
  end;
end;

procedure TCnVirtualTextControl.SetUseSelection(const Value: Boolean);
begin
  if FUseSelection <> Value then
  begin
    FUseSelection := Value;
    SyncSelectionStartEnd(True);
    Invalidate;
  end;
end;

function TCnVirtualTextControl.HasSelection: Boolean;
begin
  Result := (FSelectStartRow <> FSelectEndRow) or (FSelectStartCol <> FSelectEndCol);
end;

function TCnVirtualTextControl.SyncSelectionStartEnd(Force: Boolean): Boolean;
begin
  if FUseSelection and (Force or not HasSelection) then
  begin
    FSelectStartRow := FCaretRow;
    FSelectEndRow := FCaretRow;
    FSelectStartCol := FCaretCol;
    FSelectEndCol := FCaretCol;

    Result := True;
  end
  else
    Result := False;
end;

function TCnVirtualTextControl.CalcRowCol(Pt: TPoint; out ACaretRow, ACaretCol: Integer;
  out ACharFrameIsLeft, ACharFrameDoubleWidth: Boolean): Boolean;
begin
  Result := ClientPosToVirtualCharPos(Pt, ACaretRow, ACaretCol, ACharFrameIsLeft,
    ACharFrameDoubleWidth);

  if Result then
  begin
    // ͨ Row/Col ж
    LimitRowColumnInLine(ACaretRow, ACaretCol);

    if not ACharFrameIsLeft then
      ACaretCol := GetNextColumn(ACaretCol, ACaretRow, CaretAfterLineEnd);

    // ͨ Row/Col ж
    LimitRowColumnInLine(ACaretRow, ACaretCol);
  end;
end;

procedure TCnVirtualTextControl.DoSelectChange;
begin
  if Assigned(FOnSelectChange) then
    FOnSelectChange(Self);
end;

procedure TCnVirtualTextControl.CalcSelectEnd(Pt: TPoint);
var
  ACaretRow, ACaretCol: Integer;
  OldSelEndRow, OldSelEndCol: Integer;
  ACharFrameIsLeft, ACharFrameDoubleWidth: Boolean;
begin
  // ϶ѡע Down ʱѾȷѡʼ
  OldSelEndRow := FSelectEndRow;
  OldSelEndCol := FSelectEndCol;

  if CalcRowCol(Pt, ACaretRow, ACaretCol, ACharFrameIsLeft, ACharFrameDoubleWidth) then
  begin
    // ڻк
    FSelectEndRow := ACaretRow;
    FSelectEndCol := ACaretCol;

    LimitRowColumnInLine(FSelectEndRow, FSelectEndCol); // ƱϳΧ

    if (FSelectEndRow <> OldSelEndRow) or (FSelectEndCol <> OldSelEndCol) then
    begin
      Invalidate;
      DoSelectChange;
    end;
  end;
end;

procedure TCnVirtualTextControl.SetOnSelectChange(
  const Value: TNotifyEvent);
begin
  FOnSelectChange := Value;
end;

procedure TCnVirtualTextControl.ScrollDownLine;
var
  Msg: TWMScroll;
begin
  Msg.ScrollCode := SB_LINEDOWN;
  WMVScroll(Msg);
end;

procedure TCnVirtualTextControl.ScrollDownPage;
var
  Msg: TWMScroll;
begin
  Msg.ScrollCode := SB_PAGEDOWN;
  WMVScroll(Msg);
end;

procedure TCnVirtualTextControl.ScrollLeftCol;
var
  Msg: TWMScroll;
begin
  Msg.ScrollCode := SB_LINELEFT;
  WMHScroll(Msg);
end;

procedure TCnVirtualTextControl.ScrollLeftPage;
var
  Msg: TWMScroll;
begin
  Msg.ScrollCode := SB_PAGELEFT;
  WMHScroll(Msg);
end;

procedure TCnVirtualTextControl.ScrollRightCol;
var
  Msg: TWMScroll;
begin
  Msg.ScrollCode := SB_LINERIGHT;
  WMHScroll(Msg);
end;

procedure TCnVirtualTextControl.ScrollRightPage;
var
  Msg: TWMScroll;
begin
  Msg.ScrollCode := SB_PAGERIGHT;
  WMHScroll(Msg);
end;

procedure TCnVirtualTextControl.ScrollUpLine;
var
  Msg: TWMScroll;
begin
  Msg.ScrollCode := SB_LINEUP;
  WMVScroll(Msg);
end;

procedure TCnVirtualTextControl.ScrollUpPage;
var
  Msg: TWMScroll;
begin
  Msg.ScrollCode := SB_PAGEUP;
  WMVScroll(Msg);
end;

procedure TCnVirtualTextControl.SetBounds(ALeft, ATop, AWidth,
  AHeight: Integer);
begin
  inherited;
  UpdateRects;
  UpdateScrollBars;
end;

function TCnVirtualTextControl.GetNextColumn(AColumn,
  ARow: Integer; ACaretAfterLineEnd: Boolean): Integer;
begin
  Result := AColumn + 1;
end;

function TCnVirtualTextControl.GetPrevColumn(AColumn,
  ARow: Integer): Integer;
begin
  Result := AColumn - 1;
end;

function TCnVirtualTextControl.GetHoriPixelsOffset: Integer;
begin
  Result := FHoriOffset * FAveCharWidth;
end;

function TCnVirtualTextControl.CalcPixelOffsetFromColumnInLine(
  ARow, ACol: Integer; out Rect: TRect; out DoubleWidth: Boolean): Boolean;
begin
  Rect.Top := 0;
  Rect.Left := FAveCharWidth * (ACol - 1);
  Rect.Right := Rect.Left + FAveCharWidth;
  Rect.Bottom := FLineHeight;

  DoubleWidth := False;
  Result := True;
end;

function TCnVirtualTextControl.GetScreenCaretRow: Integer;
begin
  Result := LineNumberToScreenLineNumber(FCaretRow);
end;

function TCnVirtualTextControl.GetColumnVirtualX(ARow,
  ACol: Integer): Integer;
var
  R: TRect;
begin
  GetVirtualCharPosVirtualRect(ARow, ACol, R);
  Result := R.Left;
end;

function TCnVirtualTextControl.ClientXToVirtualX(X: Integer): Integer;
begin
  // ꣬ȥ꣬Ǹõ߾࣬Ϻ
  Result := X - GetTextRect.Left + GetHoriPixelsOffset;
end;

function TCnVirtualTextControl.VirtualXToClientX(X: Integer): Integer;
begin
  Result := X - GetHoriPixelsOffset + GetTextRect.Left
end;

procedure TCnVirtualTextControl.SyncCaretPosition;
var
  R: TRect;
begin
  if FUseCaret then
  begin
    if not GetVirtualCharPosPhysicalRect(FCaretRow, FCaretCol, R) then
      Exit;

    if (R.Left >= FTextRect.Left) and (R.Left <= FTextRect.Right) then
    begin
      if not FCaretVisible then
      begin
        ShowCaret(Handle);
        FCaretVisible := True;
      end;
      SetCaretPos(R.Left, R.Top);
    end
    else
    begin
      if FCaretVisible then
      begin
        HideCaret(Handle);
        FCaretVisible := False;
      end;
    end;
  end;
end;

procedure TCnVirtualTextControl.DoPaintLineBackground(LineCanvas: TCanvas;
  LineNumber: Integer; LineRect: TRect);
begin
  LineCanvas.Brush.Color := Color;
  LineCanvas.Brush.Style := bsSolid;
  LineCanvas.FillRect(LineRect);
end;

function TCnVirtualTextControl.GetNearestColumn(AColumn,
  ARow: Integer): Integer;
begin
  Result := AColumn;
end;

procedure TCnVirtualTextControl.MakeOrderSelection(var SelStartRow,
  SelStartCol, SelEndRow, SelEndCol: Integer);
var
  T: Integer;
begin
  if (SelEndRow < SelStartRow) or ((SelEndRow = SelStartRow) and (SelEndCol < SelStartCol)) then
  begin
    T := SelEndRow;
    SelEndRow := SelStartRow;
    SelStartRow := T;

    T := SelEndCol;
    SelEndCol := SelStartCol;
    SelStartCol := T;
  end;    // ȷ StartRow/Col  EndRow/Col ǰ
end;

procedure TCnVirtualTextControl.SelectRange(StartRow, StartCol, EndRow,
  EndCol: Integer);
begin
  if not FUseSelection then
    Exit;

  MakeOrderSelection(StartRow, StartCol, EndRow, EndCol);
  FSelectStartRow := StartRow;
  FSelectStartCol := StartCol;
  FSelectEndRow := EndRow;
  FSelectEndCol := EndCol;
  LimitRowColumnInLine(FSelectStartRow, FSelectStartCol);
  LimitRowColumnInLine(FSelectEndRow, FSelectEndCol);
  SetCaretRowCol(FSelectEndRow, FSelectEndCol);
  SyncSelectionStartEnd;
  Invalidate;
  DoSelectChange;
end;

procedure TCnVirtualTextControl.SelectAll;
begin
  SelectRange(1, 1, MaxInt, MaxInt);
end;

end.
