{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnGraphPropEditors;
{* |<PRE>
================================================================================
* ƣؼ
* ԪƣؼԱ༭Ԫ
* Ԫߣܾ (zjy@cnpack.org)
*     עõԪǰΪڲο
* ƽ̨PWin98SE + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/6
*   õԪеַϱػʽ
* ޸ļ¼2002.04.08 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  {$IFDEF COMPILER6_UP}
  DesignIntf, DesignEditors,
  {$ELSE}
  DsgnIntf,
  {$ENDIF}
  CnVCLBase, CnGraphics, CnImage, ExtDlgs;

type

{ TCnBitmapProperty }

  TCnBitmapProperty = class(TPropertyEditor)
  {* TBitmapԱ༭࣬TCnImageУڲ}
  public
    procedure Edit; override;
    {* ༭}
    function GetAttributes: TPropertyAttributes; override;
    {* ȡԱ༭״̬}
    function GetValue: string; override;
    {* ȡʾ崮}
    procedure SetValue(const Value: string); override;
    {* ıֵ}
  end;

implementation

{ TCnBitmapProperty }

procedure TCnBitmapProperty.Edit;
begin
  if GetComponent(0) is TCnImage then
    with TOpenPictureDialog.Create(nil) do
    try
      if Execute then
        TCnImage(GetComponent(0)).Bitmap.LoadFromFile(FileName);
    finally
      Free;
    end;
end;

function TCnBitmapProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paRevertable];
end;

function TCnBitmapProperty.GetValue: string;
begin
  Result := '(None)';
  if GetComponent(0) is TCnImage then
    with TCnImage(GetComponent(0)) do
      if (Bitmap <> nil) and not Bitmap.Empty then
        Result := '(TCnBitmap)';
end;

procedure TCnBitmapProperty.SetValue(const Value: string);
begin
  if GetComponent(0) is TCnImage then
    if Value = '' then
      TCnImage(GetComponent(0)).Bitmap.FreeImage;
end;

end.



