{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnRSA;
{* |<PRE>
================================================================================
* ƣ
* ԪƣRSA 㷨Ԫ
* ԪߣCnPack  (master@cnpack.org)
*     עԪʵ Int64 Χڵ RSA 㷨Կ Exponent ĬϹ̶ʹ 65537
*           ڴ RSA 㷨ʵ˹˽Կɡ洢ݼӽܡǩǩ 
*           ٷᳫԿܡ˽Կܣ RSA ߵͬҲ˽ԿܡԿܣ
*           Ԫ෽ṩˣʹʱעԡ
* ƽ̨WinXP + Delphi 5.0
* ݲԣδ
*   õԪ豾ػ
* ޸ļ¼2024.11.23 V2.9
*               һֽļӽܺ
*           2024.09.27 V2.8
*               ˽Կλܴ
*           2023.12.14 V2.7
*               ֤˽ԿĻƣƴļм뱣
*           2023.02.16 V2.6
*               ʵִʽĻɢıɫӴ㷨
*           2023.02.15 V2.5
*                RSA ֧ CRTйʣඨ٣˽Կʱ֮һ
*           2022.04.26 V2.4
*               ޸ Integer ַת֧ MacOS64
*           2021.06.12 V2.1
*                OAEP Padding Ĵ
*           2021.05.09 V2.0
*               ˽ԿʱԶж PEM  PKCS1  PKCS8 ʽͷβеĺע
*           2020.06.10 V1.9
*               ˽Կ Stream 
*           2020.03.27 V1.8
*               Կ 3ʵ˼ܵ PEM ļĶдֻ֧ DES/3DES/AES
*           2020.03.13 V1.7
*               ϸĴ롣÷ False ʱͨ GetLastCnRSAError ȡ ECN_RSA_* ʽĴ
*           2019.04.19 V1.6
*               ֧ Win32/Win64/MacOS32
*           2018.06.15 V1.5
*               ֧ļǩ֤ Openssl е÷ԭʼǩӴǩࣺ
*               openssl rsautl -sign -in hello -inkey rsa.pem -out hello.default.sign.openssl
*               // ˽ԿԭʼǩֱӰļݲ˽Կܲ洢ͬڼܣӦ CnRSASignFile ָ sdtNone
*               openssl dgst -md5 -sign rsa.pem -out hello.md5.sign.openssl hello
*               openssl dgst -sha1 -sign rsa.pem -out hello.sha1.sign.openssl hello
*               openssl dgst -sha256 -sign rsa.pem -out hello.sha256.sign.openssl hello
*               // ˽ԿӴǩָӴ㷨Ĭ md5Ӧ CnRSASignFile ָӴ㷨
*               // ԭʼļӴֵ BER  PKCS1 ˽Կܲ洢ǩļ
*               openssl dgst -verify rsa_pub.pem -signature hello.sign.openssl hello
*               // ԿӴ֤ԭʼļǩļӴ㷨ǩļС
*               // Ӧ CnRSAVerifyԿ⿪ǩļȥ PKCS1 ٽ⿪ BER 벢ȶӴֵ
*           2018.06.14 V1.5
*               ֧ļӽܣ Openssl е÷磺
*               openssl rsautl -encrypt -in hello -inkey rsa_pub.pem -pubin -out hello.en.pub.openssl
*               openssl rsautl -encrypt -in hello -inkey rsa.pem -out hello.en.pub.openssl
*               // ùԿܣͬڷ CnRSAEncryptFile  PublicKey
*               openssl rsautl -decrypt -in hello.en.pub.openssl -inkey rsa.pem -out hello.de.priv.openssl
*               // ˽Կܣͬڷ CnRSADecryptFile  PrivateKey
*               ע Openssl ᳫԿ˽ԿܣҲʵ˽ԿܹԿ
*           2018.06.05 V1.4
*                Int64 ֧չ UInt64
*           2018.06.02 V1.4
*               ܹ˽Կɼ Openssl δܵĹ˽Կ PEM ʽļ
*           2018.05.27 V1.3
*               ܹ Openssl 1.0.2 ɵδܵĹ˽Կ PEM ʽļж빫˽Կ
*               openssl genrsa -out private_pkcs1.pem 2048
*                  // PKCS#1 ʽĹ˽Կ
*               openssl pkcs8 -topk8 -inform PEM -in private_pkcs1.pem -outform PEM -nocrypt -out private_pkcs8.pem
*                  // PKCS#8 ʽĹ˽Կ
*               openssl rsa -in private_pkcs1.pem -outform PEM -RSAPublicKey_out -out public_pkcs1.pem
*                  // PKCS#1 ʽĹԿ
*               openssl rsa -in private_pkcs1.pem -outform PEM -pubout -out public_pkcs8.pem
*                  // PKCS#8 ʽĹԿ
*           2018.05.22 V1.2
*               ˽ԿϳɶԷʹ
*           2017.04.05 V1.1
*               ʵִ RSA Կӽ
*           2017.04.03 V1.0
*               ԪInt64 Χڵ RSA  CnPrime ж
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

// ˽Կӽʹ CRT м٣1024 λ˽Կܹʱ֮һ
// ڲֳʹ

uses
  SysUtils, Classes {$IFDEF MSWINDOWS}, Windows {$ENDIF}, CnConsts, CnPrime,
  CnBigNumber, CnBerUtils, CnPemUtils, CnNative, CnMD5, CnSHA1, CnSHA2, CnSM3;

const
  //  OID Ԥд̬
  CN_OID_RSAENCRYPTION_PKCS1: array[0..8] of Byte = ( // $2A = 40 * 1 + 2
    $2A, $86, $48, $86, $F7, $0D, $01, $01, $01
  );
  {* RSA PKCS1  OID 룬ʵֵΪ 1.2.840.113549.1.1.1}

  // 
  ECN_RSA_OK                           = ECN_OK;
  {* RSA ϵд룺޴ֵΪ 0}

  ECN_RSA_ERROR_BASE                   = ECN_CUSTOM_ERROR_BASE + $100;
  {* RSA ϵдĻ׼ʼֵΪ ECN_CUSTOM_ERROR_BASE  $100}

  ECN_RSA_INVALID_INPUT                = ECN_RSA_ERROR_BASE + 1;
  {* RSA ֮Ϊջ򳤶ȴ}
  ECN_RSA_INVALID_BITS                 = ECN_RSA_ERROR_BASE + 2;
  {* RSA ֮Կλ}
  ECN_RSA_BIGNUMBER_ERROR              = ECN_RSA_ERROR_BASE + 3;
  {* RSA ֮}
  ECN_RSA_BER_ERROR                    = ECN_RSA_ERROR_BASE + 4;
  {* RSA ֮ BER ʽ}
  ECN_RSA_PADDING_ERROR                = ECN_RSA_ERROR_BASE + 5;
  {* RSA ֮ PADDING }
  ECN_RSA_DIGEST_ERROR                 = ECN_RSA_ERROR_BASE + 6;
  {* RSA ֮ժҪ}
  ECN_RSA_PEM_FORMAT_ERROR             = ECN_RSA_ERROR_BASE + 7;
  {* RSA ֮ PEM ʽ}
  ECN_RSA_PEM_CRYPT_ERROR              = ECN_RSA_ERROR_BASE + 8;
  {* RSA ֮ PEM ӽܴ}

type
  TCnRSASignDigestType = (rsdtNone, rsdtMD5, rsdtSHA1, rsdtSHA256, rsdtSM3);
  {* RSA ǩֵ֧ӴժҪͣժҪ}

  TCnRSAKeyType = (cktPKCS1, cktPKCS8);
  {* RSA Կļʽע CnECC е TCnEccKeyType ظʹʱҪע}

  TCnRSAPaddingMode = (cpmPKCS1, cpmOAEP);
  {* RSA ܵģʽPKCS1 ʺϼӽܣͣ
    OAEP ֻڹԿܣĬʹ SHA1 ΪӴ㷨}

  TCnRSAPrivateKey = class(TPersistent)
  {* RSA ˽Կ}
  private
    FUseCRT: Boolean;
    FPrimeKey1: TCnBigNumber;
    FPrimeKey2: TCnBigNumber;
    FPrivKeyProduct: TCnBigNumber;
    FPrivKeyExponent: TCnBigNumber;
    FDP1: TCnBigNumber;  // CRT ٵм
    FDQ1: TCnBigNumber;
    FQInv: TCnBigNumber;
    function GetBitsCount: Integer;
    function GetBytesCount: Integer;
  public
    constructor Create(CRT: Boolean = False); virtual;
    {* 캯

       
         CRT: Boolean                     - Ƿʹ CRT ضϽ˽Կ٣Ĭϲʹ

       أTCnRSAPrivateKey             - شĶʵ
    }

    destructor Destroy; override;
    {* }

    procedure Assign(Source: TPersistent); override;
    {* ֵ

       
         Source: TPersistent              - ֵ֮Դ

       ֵޣ
    }

    procedure Clear;
    {* ֵ}
    procedure UpdateCRT;
    {* ʹ CRT ʱⲿĵ˽Կݸʱͬڲ CRT }

    property PrimeKey1: TCnBigNumber read FPrimeKey1 write FPrimeKey1;
    {*  1pҪ q }
    property PrimeKey2: TCnBigNumber read FPrimeKey2 write FPrimeKey2;
    {*  2qҪ p С}
    property PrivKeyProduct: TCnBigNumber read FPrivKeyProduct write FPrivKeyProduct;
    {* ˻ nҲ Modulusʱλϸ谲ȫλ}
    property PrivKeyExponent: TCnBigNumber read FPrivKeyExponent write FPrivKeyProduct;
    {* ˽Կָ d}
    property BitsCount: Integer read GetBitsCount;
    {* ԿλҲ˻ n Чλ}
    property BytesCount: Integer read GetBytesCount;
    {* Կֽ˻ n Чλ 8}
    property UseCRT: Boolean read FUseCRT;
    {* Ƿʹ CRT }
  end;

  TCnRSAPublicKey = class(TPersistent)
  {* RSA Կ}
  private
    FPubKeyProduct: TCnBigNumber;
    FPubKeyExponent: TCnBigNumber;
    function GetBitsCount: Integer;
    function GetBytesCount: Integer;
  public
    constructor Create; virtual;
    {* 캯}
    destructor Destroy; override;
    {* }

    procedure Assign(Source: TPersistent); override;
    {* ֵ

       
         Source: TPersistent              - ֵ֮Դ

       ֵޣ
    }

    procedure Clear;
    {* ֵ}

    property PubKeyProduct: TCnBigNumber read FPubKeyProduct write FPubKeyProduct;
    {* ˻ nҲ Modulus}
    property PubKeyExponent: TCnBigNumber read FPubKeyExponent write FPubKeyExponent;
    {* Կָ e65537}
    property BitsCount: Integer read GetBitsCount;
    {* ԿλҲ˻ n Чλ}
    property BytesCount: Integer read GetBytesCount;
    {* Կֽ˻ n Чλ 8}
  end;

// UInt64 Χڵ RSA ӽʵ

function CnInt64RSAGenerateKeys(out PrimeKey1: Cardinal; out PrimeKey2: Cardinal;
  out PrivKeyProduct: TUInt64; out PrivKeyExponent: TUInt64; out PubKeyProduct: TUInt64;
  out PubKeyExponent: TUInt64; HighBitSet: Boolean = True): Boolean;
{*  RSA 㷨һԹ˽Կ CardinalKeys  UInt64
   HighBitSet Ϊ True ʱҪλΪ 1ҳ˻ 64 Bit

   
     out PrimeKey1: Cardinal              - ɵһ
     out PrimeKey2: Cardinal              - ɵ
     out PrivKeyProduct: TUInt64          - ɵ˽Կ
     out PrivKeyExponent: TUInt64         - ɵ˽Կָ
     out PubKeyProduct: TUInt64           - ɵĹԿ
     out PubKeyExponent: TUInt64          - ɵĹԿ̶ָʹ 65537
     HighBitSet: Boolean                  - ǷҪλΪ 1

   ֵBoolean                        - Ƿɹ
}

function CnInt64RSAEncrypt(Data: TUInt64; PrivKeyProduct: TUInt64;
  PrivKeyExponent: TUInt64; out Res: TUInt64): Boolean;
{*  RSA ˽Կ Data мܣܽд ResؼǷɹ

   
     Data: TUInt64                        - ܵ
     PrivKeyProduct: TUInt64              - RSA ˽Կ
     PrivKeyExponent: TUInt64             - RSA ˽Կָ
     out Res: TUInt64                     - ļܽ

   ֵBoolean                        - ؼǷɹ
}

function CnInt64RSADecrypt(Res: TUInt64; PubKeyProduct: TUInt64;
  PubKeyExponent: TUInt64; out Data: TUInt64): Boolean;
{*  RSA Կ Res нܣܽд DataؽǷɹ

   
     Res: TUInt64                         - ܵ
     PubKeyProduct: TUInt64               - RSA Կ
     PubKeyExponent: TUInt64              - RSA Կָ
     out Data: TUInt64                    - Ľܽ

   ֵBoolean                        - ؽǷɹ
}

// Χڵ RSA ӽʵ

function CnRSAGenerateKeysByPrimeBits(PrimeBits: Integer; PrivateKey: TCnRSAPrivateKey;
  PublicKey: TCnRSAPublicKey; PublicKeyUse3: Boolean = False): Boolean; {$IFDEF SUPPORT_DEPRECATED} deprecated; {$ENDIF}
{*  RSA 㷨һԹ˽ԿPrimeBits ĶλΪɡ
   PrimeBits ȡֵΪ 512/1024/2048ȣעĿǰǳ˻ķΧڲȱȫжϡƼʹá
   PublicKeyUse3 Ϊ True ʱԿָ 3 65537

   
     PrimeBits: Integer                   - ɵλ
     PrivateKey: TCnRSAPrivateKey         - ɵ RSA ˽Կ
     PublicKey: TCnRSAPublicKey           - ɵ RSA Կ
     PublicKeyUse3: Boolean               - ԿǷʹ 3 65537ĬϺ

   ֵBoolean                        - Ƿɹ
}

function CnRSAGenerateKeys(ModulusBits: Integer; PrivateKey: TCnRSAPrivateKey;
  PublicKey: TCnRSAPublicKey; PublicKeyUse3: Boolean = False): Boolean;
{*  RSA 㷨һԹ˽ԿModulusBits ˻ĶλΪɡ
   ModulusBits ȡֵΪ 512/1024/2048ȡڲаȫжϡ
   PublicKeyUse3 Ϊ True ʱԿָ 3 65537

   
     ModulusBits: Integer                 - ɵ˻λ
     PrivateKey: TCnRSAPrivateKey         - ɵ RSA ˽Կ
     PublicKey: TCnRSAPublicKey           - ɵ RSA Կ
     PublicKeyUse3: Boolean               - ԿǷʹ 3 65537ĬϺ

   ֵBoolean                        - Ƿɹ
}

function CnRSAVerifyKeys(PrivateKey: TCnRSAPrivateKey; PublicKey: TCnRSAPublicKey): Boolean;
{* ֤һ RSA ˽ԿǷס

   
     PrivateKey: TCnRSAPrivateKey         - ֤ RSA ˽Կ
     PublicKey: TCnRSAPublicKey           - ֤ RSA Կ

   ֵBoolean                        - ֤Ƿɹ
}

function CnRSALoadKeysFromPem(const PemFileName: string; PrivateKey: TCnRSAPrivateKey;
  PublicKey: TCnRSAPublicKey; KeyHashMethod: TCnKeyHashMethod = ckhMd5;
  const Password: string = ''): Boolean; overload;
{*  PEM ʽļмһ RSA ˽ԿݣĳԿΪ롣
   Զж PKCS1  PKCS8ͷβе ----- ע͡

   
     const PemFileName: string            - ص PEM ļ
     PrivateKey: TCnRSAPrivateKey         - غݴ RSA ˽Կ
     PublicKey: TCnRSAPublicKey           - غݴ RSA Կ
     KeyHashMethod: TCnKeyHashMethod      - PEM ļܣ˴ӦӦļӴ㷨Ĭ MD5޷ PEM Զж
     const Password: string               - PEM ļܣ˴ӦӦ

   ֵBoolean                        - ؼǷɹ
}

function CnRSALoadKeysFromPem(PemStream: TStream; PrivateKey: TCnRSAPrivateKey;
  PublicKey: TCnRSAPublicKey; KeyHashMethod: TCnKeyHashMethod = ckhMd5;
  const Password: string = ''): Boolean; overload;
{*  PEM ʽмһ RSA ˽ԿݣĳԿΪ롣
   Զж PKCS1  PKCS8ͷβе ----- ע͡

   
     PemStream: TStream                   - ص PEM ʽ
     PrivateKey: TCnRSAPrivateKey         - غݴ RSA ˽Կ
     PublicKey: TCnRSAPublicKey           - غݴ RSA Կ
     KeyHashMethod: TCnKeyHashMethod      - PEM ܣ˴ӦӦļӴ㷨Ĭ MD5޷ PEM Զж
     const Password: string               - PEM ܣ˴ӦӦ

   ֵBoolean                        - ؼǷɹ
}

function CnRSASaveKeysToPem(const PemFileName: string; PrivateKey: TCnRSAPrivateKey;
  PublicKey: TCnRSAPublicKey; KeyType: TCnRSAKeyType = cktPKCS1;
  KeyEncryptMethod: TCnKeyEncryptMethod = ckeNone;
  KeyHashMethod: TCnKeyHashMethod = ckhMd5;
  const Password: string = ''): Boolean; overload;
{* һ RSA ˽Կд PEM ʽļУǷɹ

   
     const PemFileName: string                            -  PEM ļ
     PrivateKey: TCnRSAPrivateKey                         -  RSA ˽Կ
     PublicKey: TCnRSAPublicKey                           -  RSA Կ
     KeyType: TCnRSAKeyType                               -  RSA ˽Կ PEM ʽĬ PKCS1
     KeyEncryptMethod: TCnKeyEncryptMethod                -  PEM ļļģʽĬϲܣԺ
     KeyHashMethod: TCnKeyHashMethod                      -  PEM ļܣ˴Ӵ㷨Ĭ MD5
     const Password: string                               -  PEM ļܣ˴Ӧ룬粻贫

   ֵBoolean                                        - رǷɹ
}

function CnRSASaveKeysToPem(PemStream: TStream; PrivateKey: TCnRSAPrivateKey;
  PublicKey: TCnRSAPublicKey; KeyType: TCnRSAKeyType = cktPKCS1;
  KeyEncryptMethod: TCnKeyEncryptMethod = ckeNone;
  KeyHashMethod: TCnKeyHashMethod = ckhMd5;
  const Password: string = ''): Boolean; overload;
{* һ RSA ˽Կд PEM ʽУǷɹ

   
     PemStream: TStream                                   -  PEM ʽ
     PrivateKey: TCnRSAPrivateKey                         -  RSA ˽Կ
     PublicKey: TCnRSAPublicKey                           -  RSA Կ
     KeyType: TCnRSAKeyType                               -  RSA ˽Կ PEM ʽĬ PKCS1
     KeyEncryptMethod: TCnKeyEncryptMethod                -  PEM ļģʽĬϲܣԺ
     KeyHashMethod: TCnKeyHashMethod                      -  PEM ܣ˴Ӵ㷨Ĭ MD5
     const Password: string                               -  PEM ܣ˴Ӧ룬粻贫

   ֵBoolean                                        - رǷɹ
}

function CnRSALoadPublicKeyFromPem(const PemFileName: string;
  PublicKey: TCnRSAPublicKey; KeyHashMethod: TCnKeyHashMethod = ckhMd5;
  const Password: string = ''): Boolean; overload;
{*  PEM ʽļм RSA ԿݣǷɹ

   
     const PemFileName: string            - ص PEM ļ
     PublicKey: TCnRSAPublicKey           - غݴ RSA Կ
     KeyHashMethod: TCnKeyHashMethod      - PEM ļܣ˴ӦӦļӴ㷨Ĭ MD5޷ PEM Զж
     const Password: string               - PEM ļܣ˴ӦӦ

   ֵBoolean                        - ؼǷɹ
}

function CnRSALoadPublicKeyFromPem(const PemStream: TStream;
  PublicKey: TCnRSAPublicKey; KeyHashMethod: TCnKeyHashMethod = ckhMd5;
  const Password: string = ''): Boolean; overload;
{*  PEM ʽм RSA ԿݣǷɹ

   
     const PemStream: TStream             - ص PEM ʽ
     PublicKey: TCnRSAPublicKey           - غݴ RSA Կ
     KeyHashMethod: TCnKeyHashMethod      - PEM ܣ˴ӦӦļӴ㷨Ĭ MD5޷ PEM Զж
     const Password: string               - PEM ܣ˴ӦӦ

   ֵBoolean                        - ؼǷɹ
}

function CnRSASavePublicKeyToPem(const PemFileName: string;
  PublicKey: TCnRSAPublicKey; KeyType: TCnRSAKeyType = cktPKCS8;
  KeyEncryptMethod: TCnKeyEncryptMethod = ckeNone;
  const Password: string = ''): Boolean; overload;
{*  RSA Կд PEM ʽļУǷɹ

   
     const PemFileName: string                            -  PEM ļ
     PublicKey: TCnRSAPublicKey                           -  RSA Կ
     KeyType: TCnRSAKeyType                               -  RSA Կ PEM ʽĬ PKCS1
     KeyEncryptMethod: TCnKeyEncryptMethod                -  PEM ļļģʽĬϲܣԺĲ
     const Password: string                               -  PEM ļܣ˴Ӧ룬粻贫

   ֵBoolean                                        - رǷɹ
}

function CnRSASavePublicKeyToPem(PemStream: TStream;
  PublicKey: TCnRSAPublicKey; KeyType: TCnRSAKeyType = cktPKCS8;
  KeyEncryptMethod: TCnKeyEncryptMethod = ckeNone;
  const Password: string = ''): Boolean; overload;
{*  RSA Կд PEM ʽУǷɹ

   
     PemStream: TStream                                   -  PEM ʽ
     PublicKey: TCnRSAPublicKey                           -  RSA Կ
     KeyType: TCnRSAKeyType                               -  RSA Կ PEM ʽĬ PKCS1
     KeyEncryptMethod: TCnKeyEncryptMethod                -  PEM ļģʽĬϲܣԺĲ
     const Password: string                               -  PEM ܣ˴Ӧ룬粻贫

   ֵBoolean                                        - رǷɹ
}

function CnRSAEncrypt(Data: TCnBigNumber; PrivateKey: TCnRSAPrivateKey;
  Res: TCnBigNumber): Boolean; overload;
{* ʹ RSA ˽Կ Data мܣܽд ResؼǷɹ
   ÷ڲ˽Կ CRT þǷ CRT ١

   
     Data: TCnBigNumber                   - ܵĴ
     PrivateKey: TCnRSAPrivateKey         - ڼܵ RSA ˽Կ
     Res: TCnBigNumber                    - ļܺĴ

   ֵBoolean                        - ؼǷɹ
}

function CnRSAEncrypt(Data: TCnBigNumber; PublicKey: TCnRSAPublicKey;
  Res: TCnBigNumber): Boolean; overload;
{*  RSA Կ Data мܣܽд ResؼǷɹ

   
     Data: TCnBigNumber                   - ܵĴ
     PublicKey: TCnRSAPublicKey           - ڼܵ RSA Կ
     Res: TCnBigNumber                    - ļܺĴ

   ֵBoolean                        - ؼǷɹ
}

function CnRSADecrypt(Res: TCnBigNumber; PrivateKey: TCnRSAPrivateKey;
  Data: TCnBigNumber): Boolean; overload;
{*  RSA ˽Կ Res нܣܽд DataؽǷɹ
   ÷ڲ˽Կ CRT þǷ CRT ١

   
     Res: TCnBigNumber                    - ĽܺĴ
     PrivateKey: TCnRSAPrivateKey         - ڽܵ RSA ˽Կ
     Data: TCnBigNumber                   - ܵĴ

   ֵBoolean                        - ؽǷɹ
}

function CnRSADecrypt(Res: TCnBigNumber; PublicKey: TCnRSAPublicKey;
  Data: TCnBigNumber): Boolean; overload;
{*  RSA Կ Res нܣܽд DataؽǷɹ

   
     Res: TCnBigNumber                    - ĽܺĴ
     PublicKey: TCnRSAPublicKey           - ڽܵ RSA Կ
     Data: TCnBigNumber                   - ܵĴ

   ֵBoolean                        - ؽǷɹ
}

// ======================== RSA ļӽʵ ===========================

function CnRSAEncryptRawData(PlainData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; PublicKey: TCnRSAPublicKey): Boolean; overload;
{* ùԿݿмܣ䣬 OutBuf Уֽڳȡ

   
     PlainData: Pointer                   - ܵݿַ
     DataByteLen: Integer                 - ܵݿֽڳ
     OutBuf: Pointer                      - ɷصݵݿĵַֽڳȲܶԿֽڳ
     out OutByteLen: Integer              - صʵֽڳ
     PublicKey: TCnRSAPublicKey           - ڼܵ RSA Կ

   ֵBoolean                        - ؼǷɹ
}

function CnRSAEncryptRawData(PlainData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; PrivateKey: TCnRSAPrivateKey): Boolean; overload;
{* ˽Կݿмܣ䣬 OutBuf Уֽڳȡ

   
     PlainData: Pointer                   - ܵݿַ
     DataByteLen: Integer                 - ܵݿֽڳ
     OutBuf: Pointer                      - ɷصݵݿĵַֽڳȲܶԿֽڳ
     out OutByteLen: Integer              - صʵֽڳ
     PrivateKey: TCnRSAPrivateKey         - ڼܵ RSA ˽Կ

   ֵBoolean                        - ؼǷɹ
}

function CnRSADecryptRawData(EnData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; PublicKey: TCnRSAPublicKey): Boolean; overload;
{* ùԿݿܣ OutBuf Уֽڳȡ

   
     EnData: Pointer                      - ܵݿַ
     DataByteLen: Integer                 - ܵݿֽڳ
     OutBuf: Pointer                      - ɷصݵݿĵַֽڳȲܶԿֽڳ
     out OutByteLen: Integer              - صʵֽڳ
     PublicKey: TCnRSAPublicKey           - ڽܵ RSA Կ

   ֵBoolean                        - ؽǷɹ
}

function CnRSADecryptRawData(EnData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; PrivateKey: TCnRSAPrivateKey): Boolean; overload;
{* ˽Կݿܽ OutBuf Уֽڳȡ

   
     EnData: Pointer                      - ܵݿַ
     DataByteLen: Integer                 - ܵݿֽڳ
     OutBuf: Pointer                      - ɷصݵݿĵַֽڳȲܶԿֽڳ
     out OutByteLen: Integer              - صʵֽڳ
     PrivateKey: TCnRSAPrivateKey         - ڽܵ RSA ˽Կ

   ֵBoolean                        - ؽǷɹ
}

function CnRSAEncryptRawBytes(PlainData: TBytes; PublicKey: TCnRSAPublicKey): TBytes; overload;
{* ùԿֽܣؼֽܵ顣

   
     PlainData: TBytes                    - ֽܵ
     PublicKey: TCnRSAPublicKey           - ڼܵ RSA Կ

   ֵTBytes                         - ֽ
}

function CnRSAEncryptRawBytes(PlainData: TBytes; PrivateKey: TCnRSAPrivateKey): TBytes; overload;
{* ˽Կֽܣؼֽܵ顣

   
     PlainData: TBytes                    - ֽܵ
     PrivateKey: TCnRSAPrivateKey         - ڼܵ RSA ˽Կ

   ֵTBytes                         - ֽ
}

function CnRSADecryptRawBytes(EnData: TBytes; PublicKey: TCnRSAPublicKey): TBytes; overload;
{* ùԿֽܣؽֽܵ顣

   
     EnData: TBytes                       - ֽܵ
     PublicKey: TCnRSAPublicKey           - ڽܵ RSA Կ

   ֵTBytes                         - ֽ
}

function CnRSADecryptRawBytes(EnData: TBytes; PrivateKey: TCnRSAPrivateKey): TBytes; overload;
{* ˽Կֽܣؽֽܵ顣

   
     EnData: TBytes                       - ֽܵ
     PrivateKey: TCnRSAPrivateKey         - ڽܵ RSA ˽Կ

   ֵTBytes                         - ֽ
}

function CnRSAEncryptData(PlainData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  PublicKey: TCnRSAPublicKey; PaddingMode: TCnRSAPaddingMode = cpmPKCS1): Boolean; overload;
{* ùԿݿмܣǰָʹ PKCS1  OAEP 䣬 OutBuf С
   Ϊ䣬صֽڳȹ̶ΪԿֽڳȡ

   
     PlainData: Pointer                   - ܵݿַ
     DataByteLen: Integer                 - ܵݿֽڳ
     OutBuf: Pointer                      - ɷصݵݿĵַֽڳȲܶԿֽڳ
     PublicKey: TCnRSAPublicKey           - ڼܵ RSA Կ
     PaddingMode: TCnRSAPaddingMode       - ָģʽ

   ֵBoolean                        - ؼǷɹ
}

function CnRSAEncryptData(PlainData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  PrivateKey: TCnRSAPrivateKey): Boolean; overload;
{* ˽Կݿмܣǰʹ PKCS1 䣬 OutBuf С
   Ϊ䣬صֽڳȹ̶ΪԿֽڳȡ

   
     PlainData: Pointer                   - ܵݿַ
     DataByteLen: Integer                 - ܵݿֽڳ
     OutBuf: Pointer                      - ɷصݵݿĵַֽڳȲܶԿֽڳ
     PrivateKey: TCnRSAPrivateKey         - ڼܵ RSA ˽Կ

   ֵBoolean                        - ؼǷɹ
}

function CnRSADecryptData(EnData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; PublicKey: TCnRSAPublicKey): Boolean; overload;
{* ùԿݿнܣ⿪ PKCS1 䣬 OutBuf Уֽڳȡ

   
     EnData: Pointer                      - ܵݿַ
     DataByteLen: Integer                 - ܵݿֽڳ
     OutBuf: Pointer                      - ɷصݵݿĵַֽڳȲܶԿֽڳ
     out OutByteLen: Integer              - صʵֽڳ
     PublicKey: TCnRSAPublicKey           - ڽܵ RSA Կ

   ֵBoolean                        - ؽǷɹ
}

function CnRSADecryptData(EnData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; PrivateKey: TCnRSAPrivateKey;
  PaddingMode: TCnRSAPaddingMode = cpmPKCS1): Boolean; overload;
{* ˽Կݿнܣ⿪ PKCS1  OAEP 䣬 OutBuf Уֽڳȡ

   
     EnData: Pointer                      - ܵݿַ
     DataByteLen: Integer                 - ܵݿֽڳ
     OutBuf: Pointer                      - ɷصݵݿĵַֽڳȲܶԿֽڳ
     out OutByteLen: Integer              - صʵֽڳ
     PrivateKey: TCnRSAPrivateKey         - ڼܵ RSA ˽Կ
     PaddingMode: TCnRSAPaddingMode       - ָģʽĵʵһ

   ֵBoolean                        - ؽǷɹ
}

function CnRSAEncryptBytes(PlainData: TBytes; PublicKey: TCnRSAPublicKey;
  PaddingMode: TCnRSAPaddingMode = cpmPKCS1): TBytes; overload;
{* ùԿֽмܣǰָʹ PKCS1  OAEP 䣬ؼֽܵ顣

   
     PlainData: TBytes                    - ֽܵ
     PublicKey: TCnRSAPublicKey           - ڼܵ RSA Կ
     PaddingMode: TCnRSAPaddingMode       - ָģʽ

   ֵTBytes                         - ֽ
}

function CnRSAEncryptBytes(PlainData: TBytes; PrivateKey: TCnRSAPrivateKey): TBytes; overload;
{* ˽Կֽмܣǰʹ PKCS1 䣬ؼֽܵ顣

   
     PlainData: TBytes                    - ֽܵ
     PrivateKey: TCnRSAPrivateKey         - ڼܵ RSA ˽Կ

   ֵTBytes                         - ֽ
}

function CnRSADecryptBytes(EnData: TBytes; PublicKey: TCnRSAPublicKey): TBytes; overload;
{* ùԿֽнܣ⿪ PKCS1 䣬ؽֽܵ顣

   
     EnData: TBytes                       - ֽܵ
     PublicKey: TCnRSAPublicKey           - ڽܵ RSA Կ

   ֵTBytes                         - ֽ
}

function CnRSADecryptBytes(EnData: TBytes; PrivateKey: TCnRSAPrivateKey;
  PaddingMode: TCnRSAPaddingMode = cpmPKCS1): TBytes; overload;
{* ˽Կֽнܣ⿪ PKCS1  OAEP 䣬ؽֽܵ顣

   
     EnData: TBytes                       - ֽܵ
     PrivateKey: TCnRSAPrivateKey         - ڽܵ RSA ˽Կ
     PaddingMode: TCnRSAPaddingMode       - ָģʽļʵһ

   ֵTBytes                         - ֽ
}

function CnRSAEncryptFile(const InFileName: string; const OutFileName: string;
  PublicKey: TCnRSAPublicKey; PaddingMode: TCnRSAPaddingMode = cpmPKCS1): Boolean; overload;
{* ùԿļмܣǰָʹ PKCS1  OAEP 䣬ļС

   
     const InFileName: string             - ܵļ
     const OutFileName: string            - ܺļ
     PublicKey: TCnRSAPublicKey           - ڼܵ RSA Կ
     PaddingMode: TCnRSAPaddingMode       - ָģʽ

   ֵBoolean                        - ؼǷɹ
}

function CnRSAEncryptFile(const InFileName: string; const OutFileName: string;
  PrivateKey: TCnRSAPrivateKey): Boolean; overload;
{* ˽Կļмܣǰʹ PKCS1 䣬ļС

   
     const InFileName: string             - ܵļ
     const OutFileName: string            - ܺļ
     PrivateKey: TCnRSAPrivateKey         - ڼܵ RSA ˽Կ

   ֵBoolean                        - ؼǷɹ
}

function CnRSADecryptFile(const InFileName: string; const OutFileName: string;
  PublicKey: TCnRSAPublicKey): Boolean; overload;
{* ùԿļнܣ⿪ PKCS1 䣬ļУעⲻ֧ OAEP 䡣

   
     const InFileName: string             - ܵļ
     const OutFileName: string            - ܺļ
     PublicKey: TCnRSAPublicKey           - ڽܵ RSA Կ

   ֵBoolean                        - ؽǷɹ
}

function CnRSADecryptFile(const InFileName: string; const OutFileName: string;
  PrivateKey: TCnRSAPrivateKey; PaddingMode: TCnRSAPaddingMode = cpmPKCS1): Boolean; overload;
{* ˽Կļнܣ⿪ PKCS1  OAEP 䣬ļС

   
     const InFileName: string             - ܵļ
     const OutFileName: string            - ܺļ
     PrivateKey: TCnRSAPrivateKey         - ڽܵ RSA ˽Կ
     PaddingMode: TCnRSAPaddingMode       - ָģʽļʵһ

   ֵBoolean                        - ؽǷɹ
}

// =========================== RSA ļǩ֤ʵ ==========================
//
// ļֿʵΪļժҪʱִ֧ļ FileStream Ͱ汾֧
//
// ע RSA ǩӴƴһ RSA ˽Կܣ֤ʱܽӴֵ
//  ECC ǩͬECC ǩ Hash ֵͨмȶԴ

function CnRSASignFile(const InFileName: string; const OutSignFileName: string;
  PrivateKey: TCnRSAPrivateKey; SignType: TCnRSASignDigestType = rsdtMD5): Boolean;
{*  RSA ˽ԿǩָļǩֱӴ洢 OutSignFileName ļУǩǷɹ
   δָǩӴժҪʱڽԴļ PKCS1 Private_FF ܡ
   ָǩӴժҪʱʹָǩӴժҪ㷨ļмõӴֵ
   ٽԭʼĶӴֵ BER 룬 PKCS1 ˽Կܡ

   
     const InFileName: string             - ǩļ
     const OutSignFileName: string        - ǩݵļ
     PrivateKey: TCnRSAPrivateKey         - ǩ RSA ˽Կ
     SignType: TCnRSASignDigestType       - ָǩӴժҪ

   ֵBoolean                        - ǩǷɹ
}

function CnRSAVerifyFile(const InFileName: string; const InSignFileName: string;
  PublicKey: TCnRSAPublicKey; SignType: TCnRSASignDigestType = rsdtMD5): Boolean;
{*  RSA Կǩֵļָ֤ļҲָǩӴժҪ㷨ļмõӴֵ
   ùԿǩݲ⿪ PKCS1 ٽ⿪ BER õӴ㷨Ӵֵ
   ȶӴֵǷ֤ͬǷͨ

   
     const InFileName: string             - ֤ǩļ
     const InSignFileName: string         - ǩݵļ
     PublicKey: TCnRSAPublicKey           - ֤ǩ RSA Կ
     SignType: TCnRSASignDigestType       - ָǩӴժҪ

   ֵBoolean                        - ֤ǩǷɹ
}

function CnRSASignStream(InStream: TMemoryStream; OutSignStream: TMemoryStream;
  PrivateKey: TCnRSAPrivateKey; SignType: TCnRSASignDigestType = rsdtMD5): Boolean;
{*  RSA ˽Կǩָڴǩֵд OutSignStream УǩǷɹ

   
     InStream: TMemoryStream              - ǩڴ
     OutSignStream: TMemoryStream         - ǩڴ
     PrivateKey: TCnRSAPrivateKey         - ǩ RSA ˽Կ
     SignType: TCnRSASignDigestType       - ָǩӴժҪ

   ֵBoolean                        - ǩǷɹ
}

function CnRSAVerifyStream(InStream: TMemoryStream; InSignStream: TMemoryStream;
  PublicKey: TCnRSAPublicKey; SignType: TCnRSASignDigestType = rsdtMD5): Boolean;
{*  RSA Կǩֵڴָ֤ڴ֤Ƿͨ

   
     InStream: TMemoryStream              - ֤ǩڴ
     InSignStream: TMemoryStream          - ǩڴ
     PublicKey: TCnRSAPublicKey           - ֤ǩ RSA Կ
     SignType: TCnRSASignDigestType       - ָǩӴժҪ

   ֵBoolean                        - ֤ǩǷɹ
}

function CnRSASignBytes(InData: TBytes; PrivateKey: TCnRSAPrivateKey;
  SignType: TCnRSASignDigestType = rsdtMD5): TBytes;
{*  RSA ˽Կǩֽ飬ǩֵֽ飬ǩʧ򷵻ؿա

   
     InData: TBytes                       - ǩֽ
     PrivateKey: TCnRSAPrivateKey         - ǩ RSA ˽Կ
     SignType: TCnRSASignDigestType       - ָǩӴժҪ

   ֵTBytes                         - ǩݵֽ飬ʧ򷵻ؿ
}

function CnRSAVerifyBytes(InData: TBytes; InSignBytes: TBytes;
  PublicKey: TCnRSAPublicKey; SignType: TCnRSASignDigestType = rsdtMD5): Boolean;
{*  RSA Կǩָֽֽ֤飬֤Ƿͨ

   
     InData: TBytes                       - ֤ǩֽ
     InSignBytes: TBytes                  - ǩֽ
     PublicKey: TCnRSAPublicKey           - ֤ǩ RSA Կ
     SignType: TCnRSASignDigestType       - ָǩӴժҪ

   ֵBoolean                        - ֤ǩǷɹ
}

// OAEP Padding ֤㷨

function AddOaepSha1MgfPadding(ToBuf: PByte; ToByteLen: Integer; PlainData: PByte;
  DataByteLen: Integer; DigestParam: PByte = nil; ParamByteLen: Integer = 0): Boolean;
{*  Data  DataLen ݽ OAEP 䣬ݷŵ ToBuf  ToByteLen Ƿɹ
   Ĭʹ SHA1  DigestBuf ݽӴգToByteLen һ RSA ֽ

   
     ToBuf: PByte                         - ݵݿַ
     ToByteLen: Integer                   - ݵݿֽڳȣ㹻
     PlainData: PByte                     -  OAEP ݿַ
     DataByteLen: Integer                 -  OAEP ݿֽڳ
     DigestParam: PByte                   - Ӵƴӵݿַ
     ParamByteLen: Integer                - Ӵƴӵݿֽڳ

   ֵBoolean                        - Ƿɹ
}

function RemoveOaepSha1MgfPadding(ToBuf: PByte; out OutByteLen: Integer; EnData: PByte;
  DataByteLen: Integer; DigestParam: PByte = nil; ParamByteLen: Integer = 0): Boolean;
{*  EnData  DataLen ݽ OAEP 鲢ȥ䣬ݷŵ ToBuf  OutByteLen ؼǷɹ
   ToBuf ɵʵʳȲ̫̣ɹOutByteLen ݳ
   Ĭʹ SHA1  DigestBuf ݽӴգDataByteLen Ҫ RSA ԿĻֽ

   
     ToBuf: PByte                         - ɷصݵݿĵַ
     out OutByteLen: Integer              - ȥɹݳ
     EnData: PByte                        -  OAEP ֤ݿַ
     DataByteLen: Integer                 -  OAEP ֤ݿֽڳ
     DigestParam: PByte                   - Ӵƴӵݿַ
     ParamByteLen: Integer                - Ӵƴӵݿֽڳ

   ֵBoolean                        - ȥǷɹ
}

// ================ Diffie-Hellman ɢԿ㷨 ========================

function CnDiffieHellmanGeneratePrimeRootByBitsCount(BitsCount: Integer;
  Prime: TCnBigNumber; MinRoot: TCnBigNumber): Boolean;
{*  Diffie-Hellman ԿЭ㷨СԭʵʵͬڱɫӴպ
  漰طֽ˽ԭҲǸԪҲǸֵܱ

   
     BitsCount: Integer                   - ɵλ
     Prime: TCnBigNumber                  - ɵ Diffie-Hellman ԿЭ̵
     MinRoot: TCnBigNumber                - ɵ Diffie-Hellman ԿЭ̵Сԭ

   ֵBoolean                        - Ƿɹ
}

function CnDiffieHellmanGenerateOutKey(Prime: TCnBigNumber; Root: TCnBigNumber;
  SelfPrivateKey: TCnBigNumber; OutPublicKey: TCnBigNumber): Boolean;
{* ѡ PrivateKey  Diffie-Hellman ԿЭ̵ԿҪ˫Եá
    OutPublicKey = (Root ^ SelfPrivateKey) mod Prime
   Ҫ֤ȫʹ CnSecretSharing Ԫж CN_PRIME_FFDHE_* ӦԭΪ 2

   
     Prime: TCnBigNumber                  - Diffie-Hellman ԿЭ̵
     Root: TCnBigNumber                   - Diffie-Hellman ԿЭ̵ԭ
     SelfPrivateKey: TCnBigNumber         - ѡ˽Կ
     OutPublicKey: TCnBigNumber           - ɵԿ贫Է

   ֵBoolean                        - Ƿɹ
}

function CnDiffieHellmanComputeKey(Prime: TCnBigNumber; SelfPrivateKey: TCnBigNumber;
  OtherPublicKey: TCnBigNumber; SecretKey: TCnBigNumber): Boolean;
{* ݶԷ͵ Diffie-Hellman ԿЭ̵ԿЭ̵ԿҪ˫Եá
    SecretKey = (OtherPublicKey ^ SelfPrivateKey) mod Prime
   Ҫ֤ȫʹ CnSecretSharing Ԫж CN_PRIME_FFDHE_* ӦԭΪ 2

   
     Prime: TCnBigNumber                  - Diffie-Hellman ԿЭ̵
     SelfPrivateKey: TCnBigNumber         - ѡ˽Կ
     OtherPublicKey: TCnBigNumber         - ӶԷĹԿ
     SecretKey: TCnBigNumber              - ɵЭԿ

   ֵBoolean                        - Ƿɹ
}

// ====================== ɢıɫӴպ =========================

function CnChameleonHashGeneratePrimeRootByBitsCount(BitsCount: Integer;
  Prime: TCnBigNumber; MinRoot: TCnBigNumber): Boolean;
{* ɻɢıɫӴպСԭʵʵͬ Diffie-Hellman
   漰طֽ˽ԭҲǸԪҲǸֵܱ

   
     BitsCount: Integer                   - ɵλ
     Prime: TCnBigNumber                  - ɵڱɫӴյ
     MinRoot: TCnBigNumber                - ɵڱɫӴյСԭ

   ֵBoolean                        - Ƿɹ
}

function CnChameleonHashCalcDigest(InData: TCnBigNumber; InRandom: TCnBigNumber;
  InSecretKey: TCnBigNumber; OutHash: TCnBigNumber; Prime: TCnBigNumber; Root: TCnBigNumber): Boolean;
{* ͨɢıɫӴպһֵһ SecretKeyָϢӴա
   УPrime  Root  CnDiffieHellmanGeneratePrimeRootByBitsCount ɡ

   
     InData: TCnBigNumber                 - Ӵյ
     InRandom: TCnBigNumber               - ֵ
     InSecretKey: TCnBigNumber            -  SecretKey
     OutHash: TCnBigNumber                - ɵıɫӴֵ
     Prime: TCnBigNumber                  - ɫӴյ
     Root: TCnBigNumber                   - ɫӴյԭ

   ֵBoolean                        - Ƿɹ
}

function CnChameleonHashFindRandom(InOldData: TCnBigNumber; InNewData: TCnBigNumber;
  InOldRandom: TCnBigNumber; InSecretKey: TCnBigNumber; OutNewRandom: TCnBigNumber;
  Prime: TCnBigNumber; Root: TCnBigNumber): Boolean;
{* ͨɢıɫӴպ SecretKey ¾ϢܹͬӴյֵ
   УPrime  Root ԭʼϢӴʱͬ
    SecretKey  NewRandom  InNewData  CnChameleonHashCalcDigest ͬӴֵ

   
     InOldData: TCnBigNumber              - Ӵյľ
     InNewData: TCnBigNumber              - Ӵյ
     InOldRandom: TCnBigNumber            - ʱֵ
     InSecretKey: TCnBigNumber            - ʱ SecretKey
     OutNewRandom: TCnBigNumber           - ֵ
     Prime: TCnBigNumber                  - ɫӴյ
     Root: TCnBigNumber                   - ɫӴյԭ

   ֵBoolean                        - Ƿɹ
}

// =================================  ==============================

function GetDigestSignTypeFromBerOID(OID: Pointer; OidByteLen: Integer): TCnRSASignDigestType;
{*  BER  OID ȡӦ RSA ǩӴժҪöֵ

   
     OID: Pointer                         - OID ڵݿַ
     OidLen: Integer                      - OID ڵݿֽڳ

   ֵTCnRSASignDigestType           - ظ OID Ӧ RSA ǩӴժҪöֵ
}

function AddDigestTypeOIDNodeToWriter(AWriter: TCnBerWriter; ASignType: TCnRSASignDigestType;
  AParent: TCnBerWriteNode): TCnBerWriteNode;
{* һ RSA ǩӴժҪöֵ OID ӵһ Ber ڵӽڵС

   
     AWriter: TCnBerWriter                - дʱʹõ BerWriter ʵ
     ASignType: TCnRSASignDigestType      - д RSA ǩӴժҪöֵ
     AParent: TCnBerWriteNode             - ӵ Ber ڵ

   ֵTCnBerWriteNode                - ӵ Ber ӽڵ
}

function GetRSADigestNameFromSignDigestType(Digest: TCnRSASignDigestType): string;
{* ǩӴ㷨öֵȡơ

   
     Digest: TCnRSASignDigestType         - ȡ RSA ǩӴժҪöֵ

   ֵstring                         -  RSA ǩӴժҪ
}

function GetLastCnRSAError: Integer;
{* ȡ߳һ ErrorCodeϺ False ʱɵô˺ȡ顣

   
     ޣ

   ֵInteger                        -  RSA ش
}

implementation

uses
  CnRandom;

const
  // PKCS#1
  PEM_RSA_PRIVATE_HEAD = '-----BEGIN RSA PRIVATE KEY-----';
  PEM_RSA_PRIVATE_TAIL = '-----END RSA PRIVATE KEY-----';

  PEM_RSA_PUBLIC_HEAD = '-----BEGIN RSA PUBLIC KEY-----';
  PEM_RSA_PUBLIC_TAIL = '-----END RSA PUBLIC KEY-----';

  // PKCS#8
  PEM_PRIVATE_HEAD = '-----BEGIN PRIVATE KEY-----';
  PEM_PRIVATE_TAIL = '-----END PRIVATE KEY-----';

  PEM_PUBLIC_HEAD = '-----BEGIN PUBLIC KEY-----';
  PEM_PUBLIC_TAIL = '-----END PUBLIC KEY-----';

  OID_SIGN_MD5: array[0..7] of Byte = (            // 1.2.840.113549.2.5
    $2A, $86, $48, $86, $F7, $0D, $02, $05
  );

  OID_SIGN_SHA1: array[0..4] of Byte = (           // 1.3.14.3.2.26
    $2B, $0E, $03, $02, $1A
  );

  OID_SIGN_SHA256: array[0..8] of Byte = (         // 2.16.840.1.101.3.4.2.1
    $60, $86, $48, $01, $65, $03, $04, $02, $01
  );

// ȡ߳һ ErrorCodeϺ False ʱɵô˺ȡ}
function GetLastCnRSAError: Integer;
begin
  Result := CnGetLastError;
end;

// ù˽Կݽмӽܣעӽʹõͬһ׻ƣ
function Int64RSACrypt(Data: TUInt64; Product: TUInt64; Exponent: TUInt64;
  out Res: TUInt64): Boolean;
begin
  Res := MontgomeryPowerMod(Data, Exponent, Product);
  Result := True;
end;

function GetInt64BitCount(A: TUInt64): Integer;
var
  I: Integer;
begin
  I := 0;
  while A <> 0 do
  begin
    A := A shr 1;
    Inc(I);
  end;
  Result := I;
end;

//  RSA 㷨Ĺ˽Կ CardinalKeys  TUInt64
function CnInt64RSAGenerateKeys(out PrimeKey1: Cardinal; out PrimeKey2: Cardinal;
  out PrivKeyProduct: TUInt64; out PrivKeyExponent: TUInt64;
  out PubKeyProduct: TUInt64; out PubKeyExponent: TUInt64; HighBitSet: Boolean): Boolean;
var
  N: Cardinal;
  Succ: Boolean;
  Product, Y: TUInt64;
begin
  Succ := False;
  repeat
    PrimeKey1 := CnGenerateUInt32Prime(HighBitSet);

    N := Trunc(Random * 100); // Ե CnGenerateUInt32Prime ڲ
    Sleep(N);

    PrimeKey2 := CnGenerateUInt32Prime(HighBitSet);

    if PrimeKey1 = PrimeKey2 then // 
      Continue;

    if HighBitSet then
    begin
      Product := TUInt64(PrimeKey1) * TUInt64(PrimeKey2);
      Succ := GetInt64BitCount(Product) = 64;
    end
    else
      Succ := True;
  until Succ;

  if PrimeKey2 > PrimeKey1 then  // һʹ p > q
  begin
    N := PrimeKey1;
    PrimeKey1 := PrimeKey2;
    PrimeKey2 := N;
  end;

  PrivKeyProduct := TUInt64(PrimeKey1) * TUInt64(PrimeKey2);
  PubKeyProduct := TUInt64(PrimeKey2) * TUInt64(PrimeKey1);   //  n ڹ˽Կͬ
  PubKeyExponent := 65537;                                    // ̶

  Product := TUInt64(PrimeKey1 - 1) * TUInt64(PrimeKey2 - 1);

  //                      e                d             (p-1)(q-1)
  // շת PubKeyExponent * PrivKeyExponent mod Product = 1 е PrivKeyExponent
  // r = (p-1)(q-1) Ҳǽⷽ e * d + r * y = 1 er ֪ d  y
  CnInt64ExtendedEuclideanGcd(PubKeyExponent, Product, PrivKeyExponent, Y);
  while UInt64IsNegative(PrivKeyExponent) do
  begin
     //  d С 0򲻷Ҫ d ϱ rӵΪֹ
     Y := (UInt64Div(-PrivKeyExponent, Product) + 1) * Product;
     PrivKeyExponent := PrivKeyExponent + Y;
  end;
  Result := True;
end;

// ɵ˽ԿݽмܣؼǷɹ
function CnInt64RSAEncrypt(Data: TUInt64; PrivKeyProduct: TUInt64;
  PrivKeyExponent: TUInt64; out Res: TUInt64): Boolean;
begin
  Result := Int64RSACrypt(Data, PrivKeyProduct, PrivKeyExponent, Res);
end;

// ɵĹԿݽнܣؽǷɹ
function CnInt64RSADecrypt(Res: TUInt64; PubKeyProduct: TUInt64;
  PubKeyExponent: TUInt64; out Data: TUInt64): Boolean;
begin
  Result := Int64RSACrypt(Res, PubKeyProduct, PubKeyExponent, Data);
end;

function CnRSAGenerateKeysByPrimeBits(PrimeBits: Integer; PrivateKey: TCnRSAPrivateKey;
  PublicKey: TCnRSAPublicKey; PublicKeyUse3: Boolean): Boolean;
var
  N: Integer;
  Suc: Boolean;
  R, Y, Rem, S1, S2, One: TCnBigNumber;
begin
  Result := False;
  if PrimeBits <= 16 then
  begin
    _CnSetLastError(ECN_RSA_INVALID_BITS);
    Exit;
  end;

  PrivateKey.Clear;
  PublicKey.Clear;

  Suc := False;
  while not Suc do
  begin
    if not BigNumberGeneratePrime(PrivateKey.PrimeKey1, PrimeBits div 8) then
      Exit;

    N := Trunc(Random * 1000);
    Sleep(N);

    if not BigNumberGeneratePrime(PrivateKey.PrimeKey2, PrimeBits div 8) then
      Exit;

    // 
    if BigNumberEqual(PrivateKey.PrimeKey1, PrivateKey.PrimeKey2) then
      Continue;

    // TODO: p  q ĲܹСʱ Continue

    // һҪ Prime1 > Prime2 Ա CRT Ȳ
    if BigNumberCompare(PrivateKey.PrimeKey1, PrivateKey.PrimeKey2) < 0 then
      BigNumberSwap(PrivateKey.PrimeKey1, PrivateKey.PrimeKey2);

    if not BigNumberMul(PrivateKey.PrivKeyProduct, PrivateKey.PrimeKey1, PrivateKey.PrimeKey2) then
      Exit;

    // pq ĻǷ Bit ʱ Continue
    if PrivateKey.PrivKeyProduct.GetBitsCount <> PrimeBits * 2 then
      Continue;

    // TODO: pq Ļ NAF ϵǷʱ Continue

    if not BigNumberMul(PublicKey.PubKeyProduct, PrivateKey.PrimeKey1, PrivateKey.PrimeKey2) then
      Exit;

    if PublicKeyUse3 then
      PublicKey.PubKeyExponent.SetDec('3')
    else
      PublicKey.PubKeyExponent.SetDec('65537');

    Rem := nil;
    Y := nil;
    R := nil;
    S1 := nil;
    S2 := nil;
    One := nil;

    try
      Rem := TCnBigNumber.Create;
      Y := TCnBigNumber.Create;
      R := TCnBigNumber.Create;
      S1 := TCnBigNumber.Create;
      S2 := TCnBigNumber.Create;
      One := TCnBigNumber.Create;

      BigNumberSetOne(One);
      BigNumberSub(S1, PrivateKey.PrimeKey1, One);
      BigNumberSub(S2, PrivateKey.PrimeKey2, One);
      BigNumberMul(R, S1, S2);     // R = (p - 1) * (q - 1)

      //  e Ҳ PubKeyExponent65537Ի R ģԪ d Ҳ PrivKeyExponent
      BigNumberExtendedEuclideanGcd(PublicKey.PubKeyExponent, R, PrivateKey.PrivKeyExponent, Y);

      //  d С 0򲻷Ҫ d ϻ R
      if BigNumberIsNegative(PrivateKey.PrivKeyExponent) then
         BigNumberAdd(PrivateKey.PrivKeyExponent, PrivateKey.PrivKeyExponent, R);

      // TODO: d ̫Сʱ Continue
      PrivateKey.UpdateCRT;
    finally
      One.Free;
      S2.Free;
      S1.Free;
      R.Free;
      Y.Free;
      Rem.Free;
    end;

    Suc := True;
  end;
  Result := True;
end;

function CnRSAGenerateKeys(ModulusBits: Integer; PrivateKey: TCnRSAPrivateKey;
  PublicKey: TCnRSAPublicKey; PublicKeyUse3: Boolean): Boolean;
var
  PB1, PB2, MinDB, MinW: Integer;
  Suc: Boolean;
  Dif, MinD: TCnBigNumber;
  R, Y, Rem, S1, S2, One: TCnBigNumber;
begin
  Result := False;
  _CnSetLastError(ECN_RSA_BIGNUMBER_ERROR);
  if ModulusBits < 128 then
  begin
    _CnSetLastError(ECN_RSA_INVALID_BITS);
    Exit;
  end;

  PrivateKey.Clear;
  PublicKey.Clear;
  Suc := False;

  PB1 := (ModulusBits + 1) div 2;
  PB2 := ModulusBits - PB1;
  MinDB := ModulusBits div 2 - 100;
  if MinDB < ModulusBits div 3 then
    MinDB := ModulusBits div 3;
  MinW := ModulusBits shr 2;

  Rem := nil;
  Y := nil;
  R := nil;
  S1 := nil;
  S2 := nil;
  One := nil;
  Dif := nil;
  MinD := nil;

  try
    Rem := TCnBigNumber.Create;
    Y := TCnBigNumber.Create;
    R := TCnBigNumber.Create;
    S1 := TCnBigNumber.Create;
    S2 := TCnBigNumber.Create;
    One := TCnBigNumber.Create;
    Dif := TCnBigNumber.Create;
    MinD := TCnBigNumber.Create;

    while not Suc do
    begin
      if not BigNumberGeneratePrimeByBitsCount(PrivateKey.PrimeKey1, PB1) then
        Exit;

      if not BigNumberGeneratePrimeByBitsCount(PrivateKey.PrimeKey2, PB2) then
        Exit;

      // 
      if BigNumberEqual(PrivateKey.PrimeKey1, PrivateKey.PrimeKey2) then
        Continue;

      if not BigNumberMul(PrivateKey.PrivKeyProduct, PrivateKey.PrimeKey1, PrivateKey.PrimeKey2) then
        Exit;

      // pq ĻǷ Bit ʱ Continue
      if PrivateKey.PrivKeyProduct.GetBitsCount <> ModulusBits then
        Continue;

      // ˻λΪ n |p-q| λҪ n/3 Ҳ n/2 - 100 
      if not BigNumberSub(Dif, PrivateKey.PrimeKey1, PrivateKey.PrimeKey2) then
        Exit;

      if Dif.GetBitsCount <= MinDB then
        Continue;

      // һҪ Prime1 > Prime2 Ա CRT Ȳ
      if BigNumberCompare(PrivateKey.PrimeKey1, PrivateKey.PrimeKey2) < 0 then
        BigNumberSwap(PrivateKey.PrimeKey1, PrivateKey.PrimeKey2);

      // TODO: pq ĻķʽNon-Adjacent FormNAF ϵǷʱ Continue

      if not BigNumberMul(PublicKey.PubKeyProduct, PrivateKey.PrimeKey1, PrivateKey.PrimeKey2) then
        Exit;

      if PublicKeyUse3 then
        PublicKey.PubKeyExponent.SetDec('3')
      else
        PublicKey.PubKeyExponent.SetDec('65537');

      BigNumberSetOne(One);
      BigNumberSub(S1, PrivateKey.PrimeKey1, One);
      BigNumberSub(S2, PrivateKey.PrimeKey2, One);
      BigNumberMul(R, S1, S2);     // R = (p - 1) * (q - 1)

      //  e Ҳ PubKeyExponent65537Ի R ģԪ d Ҳ PrivKeyExponent
      BigNumberExtendedEuclideanGcd(PublicKey.PubKeyExponent, R, PrivateKey.PrivKeyExponent, Y);

      //  d С 0򲻷Ҫ d ϻ R
      if BigNumberIsNegative(PrivateKey.PrivKeyExponent) then
         BigNumberAdd(PrivateKey.PrivKeyExponent, PrivateKey.PrivKeyExponent, R);

      // d ̫С 2  n/2 η
      MinD.SetOne;
      MinD.ShiftLeft(MinW);
      if BigNumberCompare(PrivateKey.PrivKeyExponent, MinD) <= 0 then
        Continue;

      PrivateKey.UpdateCRT;
      Suc := True;
    end;
  finally
    MinD.Free;
    Dif.Free;
    One.Free;
    S2.Free;
    S1.Free;
    R.Free;
    Y.Free;
    Rem.Free;
  end;

  Result := True;
  _CnSetLastError(ECN_RSA_OK);
end;

function CnRSAVerifyKeys(PrivateKey: TCnRSAPrivateKey; PublicKey: TCnRSAPublicKey): Boolean;
var
  T, M, P: TCnBigNumber;
begin
  // ˽Կ˻Ҫ˽Կ Product
  // ˽Կ Product 
  // Կָ 3  65537
  // ֤ d
  Result := False;
  if (PrivateKey = nil) or (PublicKey = nil) then
    Exit;

  if not BigNumberEqual(PrivateKey.PrivKeyProduct, PublicKey.PubKeyProduct) then
    Exit;

  // e ֻ 3  65537
  if not PublicKey.PubKeyExponent.IsWord(65537) and not PublicKey.PubKeyExponent.IsWord(3) then
    Exit;

  T := nil;
  P := nil;
  M := nil;

  try
    T := TCnBigNumber.Create;
    BigNumberMul(T, PrivateKey.PrimeKey1, PrivateKey.PrimeKey2);
    if not BigNumberEqual(T, PublicKey.PubKeyProduct) then
      Exit;

    // ֤ d Ƿ e * d mod (p-1)(q-1) = 1
    P := TCnBigNumber.Create;
    BigNumberCopy(P, PrivateKey.PrimeKey1);
    BigNumberCopy(T, PrivateKey.PrimeKey2);
    BigNumberSubWord(P, 1);
    BigNumberSubWord(T, 1);

    BigNumberMul(T, P, T); // T õ (p-1)(q-1)

    M := TCnBigNumber.Create;
    BigNumberMul(M, PrivateKey.FPrivKeyExponent, PublicKey.PubKeyExponent); // M õ e * d

    BigNumberMod(P, M, T);
    if not P.IsOne then
      Exit;

    Result := True;
    _CnSetLastError(ECN_RSA_OK);
  finally
    M.Free;
    P.Free;
    T.Free;
  end;
end;

//  PEM ʽļмع˽Կ
(*
PKCS#1:
  RSAPrivateKey ::= SEQUENCE {                       0
    version Version,                                 1 0
    modulus INTEGER, C n                             2 ˽Կ
    publicExponent INTEGER, C e                      3 Կ
    privateExponent INTEGER, C d                     4 ˽Կ
    prime1 INTEGER, C p                              5 ˽Կ
    prime2 INTEGER, C q                              6 ˽Կ
    exponent1 INTEGER, C d mod (p-1)                 7 CRT ϵ 1
    exponent2 INTEGER, C d mod (q-1)                 8 CRT ϵ 2
    coefficient INTEGER, C (1/q) mod p               9 CRT ϵ 3q  p ģԪ
    otherPrimeInfos OtherPrimeInfos OPTIONAL         10

    ģԪ x = (1/q) mod p ɵ xq = 1 mod p Ҳ xq = 1 + yp Ҳ qx + (-p)y = 1
    չŷշתֱ
  }

PKCS#8:
  PrivateKeyInfo ::= SEQUENCE {
    version         Version,
    algorithm       AlgorithmIdentifier,
    PrivateKey      OCTET STRING
  }

  AlgorithmIdentifier ::= SEQUENCE {
    algorithm       OBJECT IDENTIFIER,
    parameters      ANY DEFINED BY algorithm OPTIONAL
  }
  PrivateKey  PKCS#1  RSAPrivateKey ṹ
  Ҳ
  SEQUENCE (3 elem)
    INTEGER 0
    SEQUENCE (2 elem)
      OBJECT IDENTIFIER 1.2.840.113549.1.1.1 rsaEncryption(PKCS #1)
      NULL
    OCTET STRING (1 elem)
      SEQUENCE (9 elem)
        INTEGER 0
        INTEGER                                       8 ˽Կ Modulus
        INTEGER                                       9 Կ   e
        INTEGER                                       10 ˽Կ  d
        INTEGER                                       11 ˽Կ  p
        INTEGER                                       12 ˽Կ  q
        INTEGER

        INTEGER
*)
function CnRSALoadKeysFromPem(const PemFileName: string; PrivateKey: TCnRSAPrivateKey;
  PublicKey: TCnRSAPublicKey; KeyHashMethod: TCnKeyHashMethod; const Password: string): Boolean;
var
  Stream: TStream;
begin
  Stream := TFileStream.Create(PemFileName, fmOpenRead or fmShareDenyWrite);
  try
    Result := CnRSALoadKeysFromPem(Stream, PrivateKey, PublicKey, KeyHashMethod, Password);
  finally
    Stream.Free;
  end;
end;

function CnRSALoadKeysFromPem(PemStream: TStream; PrivateKey: TCnRSAPrivateKey;
  PublicKey: TCnRSAPublicKey; KeyHashMethod: TCnKeyHashMethod = ckhMd5;
  const Password: string = ''): Boolean;
var
  LoadOK: Boolean;
  MemStream: TMemoryStream;
  Reader: TCnBerReader;
  Node: TCnBerReadNode;
{$IFDEF TSTREAM_LONGINT}
  OldPos: LongInt;
{$ELSE}
  OldPos: Int64;
{$ENDIF}
begin
  Result := False;
  MemStream := nil;
  Reader := nil;

  try
    MemStream := TMemoryStream.Create;
    OldPos := PemStream.Position;

    LoadOK := LoadPemStreamToMemory(PemStream, PEM_RSA_PRIVATE_HEAD, PEM_RSA_PRIVATE_TAIL,
      MemStream, Password, KeyHashMethod);
    if not LoadOK then
    begin
      PemStream.Position := OldPos;
      LoadOK := LoadPemStreamToMemory(PemStream, PEM_PRIVATE_HEAD, PEM_PRIVATE_TAIL,
        MemStream, Password, KeyHashMethod);
    end;

    if not LoadOK then
    begin
      _CnSetLastError(ECN_RSA_PEM_FORMAT_ERROR);
      Exit;
    end;

    Reader := TCnBerReader.Create(PByte(MemStream.Memory), MemStream.Size, True);
    Reader.ParseToTree;

    if Reader.TotalCount >= 12 then // ӽڵ࣬˵ PKCS#8  PEM ˽Կʽ
    begin
      Node := Reader.Items[1]; // 0  Sequence1  Version
      if Node.AsByte = 0 then // ְֻ֧汾 0
      begin
        // 8  9 ɹԿ
        if PublicKey <> nil then
        begin
          PutIndexedBigIntegerToBigNumber(Reader.Items[8], PublicKey.PubKeyProduct);
          PutIndexedBigIntegerToBigNumber(Reader.Items[9], PublicKey.PubKeyExponent);
        end;

        // 8 10 11 12 ˽Կ
        if PrivateKey <> nil then
        begin
          PutIndexedBigIntegerToBigNumber(Reader.Items[8], PrivateKey.PrivKeyProduct);
          PutIndexedBigIntegerToBigNumber(Reader.Items[10], PrivateKey.PrivKeyExponent);
          PutIndexedBigIntegerToBigNumber(Reader.Items[11], PrivateKey.PrimeKey1);
          PutIndexedBigIntegerToBigNumber(Reader.Items[12], PrivateKey.PrimeKey2);

          PrivateKey.UpdateCRT;
        end;

        Result := True;
      end;
    end
    else // ӽڵ̫٣²ڲַض
    begin
      Reader.Free;
      Reader := TCnBerReader.Create(PByte(MemStream.Memory), MemStream.Size);
      Reader.ParseToTree;

      if Reader.TotalCount >= 8 then // ӽڵ㣬 PKCS#1  PEM ˽Կʽ
      begin
        Node := Reader.Items[1]; // 0  Sequence1  Version
        if Node.AsByte = 0 then // ְֻ֧汾 0
        begin
          // 2  3 ɹԿ
          if PublicKey <> nil then
          begin
            PutIndexedBigIntegerToBigNumber(Reader.Items[2], PublicKey.PubKeyProduct);
            PutIndexedBigIntegerToBigNumber(Reader.Items[3], PublicKey.PubKeyExponent);
          end;

          // 2 4 5 6 ˽Կ
          if PrivateKey <> nil then
          begin
            PutIndexedBigIntegerToBigNumber(Reader.Items[2], PrivateKey.PrivKeyProduct);
            PutIndexedBigIntegerToBigNumber(Reader.Items[4], PrivateKey.PrivKeyExponent);
            PutIndexedBigIntegerToBigNumber(Reader.Items[5], PrivateKey.PrimeKey1);
            PutIndexedBigIntegerToBigNumber(Reader.Items[6], PrivateKey.PrimeKey2);

            PrivateKey.UpdateCRT;
          end;

          Result := True;
          _CnSetLastError(ECN_RSA_OK);
        end;
      end;
    end;

    if Result then
      _CnSetLastError(ECN_RSA_OK)
    else
      _CnSetLastError(ECN_RSA_PEM_FORMAT_ERROR);
  finally
    MemStream.Free;
    Reader.Free;
  end;
end;

//  PEM ʽļмعԿ
// ע PKCS#8  PublicKey  PEM ڱ׼ ASN.1 һװ
//  Modulus  Exponent  BitString УҪ Paser 
(*
PKCS#1:
  RSAPublicKey ::= SEQUENCE {
      modulus           INTEGER,  -- n
      publicExponent    INTEGER   -- e
  }

PKCS#8:
  PublicKeyInfo ::= SEQUENCE {
    algorithm       AlgorithmIdentifier,
    PublicKey       BIT STRING
  }

  AlgorithmIdentifier ::= SEQUENCE {
    algorithm       OBJECT IDENTIFIER,
    parameters      ANY DEFINED BY algorithm OPTIONAL
  }
  Ҳ
  SEQUENCE (2 elem)
    SEQUENCE (2 elem)
      OBJECT IDENTIFIER 1.2.840.113549.1.1.1 rsaEncryption(PKCS #1)
      NULL
    BIT STRING (1 elem)
      SEQUENCE (2 elem)
        INTEGER     - Modulus
        INTEGER     - Exponent
*)
function CnRSALoadPublicKeyFromPem(const PemFileName: string;
  PublicKey: TCnRSAPublicKey; KeyHashMethod: TCnKeyHashMethod; const Password: string): Boolean;
var
  Stream: TStream;
begin
  Stream := TFileStream.Create(PemFileName, fmOpenRead or fmShareDenyWrite);
  try
    Result := CnRSALoadPublicKeyFromPem(Stream, PublicKey, KeyHashMethod, Password);
  finally
    Stream.Free;
  end;
end;

function CnRSALoadPublicKeyFromPem(const PemStream: TStream;
  PublicKey: TCnRSAPublicKey; KeyHashMethod: TCnKeyHashMethod = ckhMd5;
  const Password: string = ''): Boolean;
var
  Mem: TMemoryStream;
  Reader: TCnBerReader;
{$IFDEF TSTREAM_LONGINT}
  OldPos: LongInt;
{$ELSE}
  OldPos: Int64;
{$ENDIF}
begin
  Result := False;
  Mem := nil;
  Reader := nil;

  try
    Mem := TMemoryStream.Create;
    OldPos := PemStream.Position;

    if LoadPemStreamToMemory(PemStream, PEM_PUBLIC_HEAD, PEM_PUBLIC_TAIL, Mem,
      Password, KeyHashMethod) then
    begin
      //  PKCS#8 ʽĹԿ
      Reader := TCnBerReader.Create(PByte(Mem.Memory), Mem.Size, True);
      Reader.ParseToTree;
      if Reader.TotalCount >= 7 then
      begin
        // 6  7 ɹԿ
        if PublicKey <> nil then
        begin
          PutIndexedBigIntegerToBigNumber(Reader.Items[6], PublicKey.PubKeyProduct);
          PutIndexedBigIntegerToBigNumber(Reader.Items[7], PublicKey.PubKeyExponent);
        end;

        Result := True;
      end;
    end;

    if Result then
    begin
      _CnSetLastError(ECN_RSA_OK);
      Exit;
    end;

    PemStream.Position := OldPos;
    if LoadPemStreamToMemory(PemStream, PEM_RSA_PUBLIC_HEAD, PEM_RSA_PUBLIC_TAIL,
      Mem, Password, KeyHashMethod) then
    begin
      //  PKCS#1 ʽĹԿ
      Reader := TCnBerReader.Create(PByte(Mem.Memory), Mem.Size);
      Reader.ParseToTree;
      if Reader.TotalCount in [3, 4] then // ڵ 5 Ļ PKCS1 ʽ
      begin
        // 1  2 ɹԿ
        if PublicKey <> nil then
        begin
          PutIndexedBigIntegerToBigNumber(Reader.Items[1], PublicKey.PubKeyProduct);
          PutIndexedBigIntegerToBigNumber(Reader.Items[2], PublicKey.PubKeyExponent);
        end;
      
        Result := True;
      end;
    end;

    if Result then
      _CnSetLastError(ECN_RSA_OK)
    else
      _CnSetLastError(ECN_RSA_PEM_FORMAT_ERROR);
  finally
    Mem.Free;
    Reader.Free;
  end;
end;

// ˽Կд PEM ʽļ
function CnRSASaveKeysToPem(const PemFileName: string; PrivateKey: TCnRSAPrivateKey;
  PublicKey: TCnRSAPublicKey; KeyType: TCnRSAKeyType; KeyEncryptMethod: TCnKeyEncryptMethod;
  KeyHashMethod: TCnKeyHashMethod; const Password: string): Boolean;
var
  Stream: TStream;
begin
  Stream := TFileStream.Create(PemFileName, fmCreate);
  try
    Result := CnRSASaveKeysToPem(Stream, PrivateKey, PublicKey, KeyType,
      KeyEncryptMethod, KeyHashMethod, Password);
  finally
    Stream.Free;
  end;
end;

function CnRSASaveKeysToPem(PemStream: TStream; PrivateKey: TCnRSAPrivateKey;
  PublicKey: TCnRSAPublicKey; KeyType: TCnRSAKeyType;
  KeyEncryptMethod: TCnKeyEncryptMethod;
  KeyHashMethod: TCnKeyHashMethod; const Password: string): Boolean;
var
  Root, Node: TCnBerWriteNode;
  Writer: TCnBerWriter;
  Mem: TMemoryStream;
  N, T, R1, R2, X, Y : TCnBigNumber;
  B: Byte;
begin
  Result := False;
  if (PublicKey = nil) or (PublicKey.PubKeyProduct.GetBytesCount <= 0) or
    (PublicKey.PubKeyExponent.GetBytesCount <= 0) then
  begin
    _CnSetLastError(ECN_RSA_INVALID_INPUT);
    Exit;
  end;

  if (PrivateKey = nil) or (PrivateKey.PrivKeyProduct.GetBytesCount <= 0) or
    (PrivateKey.PrivKeyExponent.GetBytesCount <= 0) then
  begin
    _CnSetLastError(ECN_RSA_INVALID_INPUT);
    Exit;
  end;

  Mem := nil;
  Writer := nil;
  T := nil;
  R1 := nil;
  R2 := nil;
  N := nil;
  X := nil;
  Y := nil;

  try
    T := BigNumberNew;
    R1 := BigNumberNew;
    R2 := BigNumberNew;
    N := BigNumberNew;
    X := BigNumberNew;
    Y := BigNumberNew;
    if not T.SetOne then
      Exit;

    BigNumberSub(N, PrivateKey.PrimeKey1, T);
    BigNumberMod(R1, PrivateKey.PrivKeyExponent, N); // R1 = d mod (p - 1)

    BigNumberSub(N, PrivateKey.PrimeKey2, T);
    BigNumberMod(R2, PrivateKey.PrivKeyExponent, N); // R2 = d mod (q - 1)

    // X = ǲ qx + (-p)y = 1 Ľ
    BigNumberExtendedEuclideanGcd(PrivateKey.PrimeKey2, PrivateKey.PrimeKey1, X, Y);
    if BigNumberIsNegative(X) then
      BigNumberAdd(X, X, PrivateKey.PrimeKey1);

    Writer := TCnBerWriter.Create;
    Root := Writer.AddContainerNode(CN_BER_TAG_SEQUENCE);
    B := 0;
    if KeyType = cktPKCS1 then
    begin
      // ƴ PKCS1 ʽ
      Writer.AddBasicNode(CN_BER_TAG_INTEGER, @B, 1, Root);
      AddBigNumberToWriter(Writer, PrivateKey.PrivKeyProduct, Root);
      AddBigNumberToWriter(Writer, PublicKey.PubKeyExponent, Root);
      AddBigNumberToWriter(Writer, PrivateKey.PrivKeyExponent, Root);
      AddBigNumberToWriter(Writer, PrivateKey.PrimeKey1, Root);
      AddBigNumberToWriter(Writer, PrivateKey.PrimeKey2, Root);
      AddBigNumberToWriter(Writer, R1, Root);
      AddBigNumberToWriter(Writer, R2, Root);
      AddBigNumberToWriter(Writer, X, Root);
    end
    else if KeyType = cktPKCS8 then
    begin
      // ƴ PKCS8 ʽ
      Writer.AddBasicNode(CN_BER_TAG_INTEGER, @B, 1, Root);
      Node := Writer.AddContainerNode(CN_BER_TAG_SEQUENCE, Root);

      //  Node1  ObjectIdentifier  Null
      Writer.AddBasicNode(CN_BER_TAG_OBJECT_IDENTIFIER, @CN_OID_RSAENCRYPTION_PKCS1[0],
        SizeOf(CN_OID_RSAENCRYPTION_PKCS1), Node);
      Writer.AddNullNode(Node);

      Node := Writer.AddContainerNode(CN_BER_TAG_OCTET_STRING, Root);
      Node := Writer.AddContainerNode(CN_BER_TAG_SEQUENCE, Node);

      Writer.AddBasicNode(CN_BER_TAG_INTEGER, @B, 1, Node);
      AddBigNumberToWriter(Writer, PrivateKey.PrivKeyProduct, Node);
      AddBigNumberToWriter(Writer, PublicKey.PubKeyExponent, Node);
      AddBigNumberToWriter(Writer, PrivateKey.PrivKeyExponent, Node);
      AddBigNumberToWriter(Writer, PrivateKey.PrimeKey1, Node);
      AddBigNumberToWriter(Writer, PrivateKey.PrimeKey2, Node);
      AddBigNumberToWriter(Writer, R1, Node);
      AddBigNumberToWriter(Writer, R2, Node);
      AddBigNumberToWriter(Writer, X, Node);
    end;

    // ˣ Base64 ٷֶƴͷβдļ
    Mem := TMemoryStream.Create;
    Writer.SaveToStream(Mem);

    if KeyType = cktPKCS1 then
      Result := SaveMemoryToPemStream(PemStream, PEM_RSA_PRIVATE_HEAD,
        PEM_RSA_PRIVATE_TAIL, Mem, KeyEncryptMethod, KeyHashMethod, Password)
    else if KeyType = cktPKCS8 then
      Result := SaveMemoryToPemStream(PemStream, PEM_PRIVATE_HEAD,
        PEM_PRIVATE_TAIL, Mem, KeyEncryptMethod, KeyHashMethod, Password);

    if Result then
      _CnSetLastError(ECN_RSA_OK)
    else
      _CnSetLastError(ECN_RSA_PEM_FORMAT_ERROR);
  finally
    BigNumberFree(T);
    BigNumberFree(R1);
    BigNumberFree(R2);
    BigNumberFree(N);
    BigNumberFree(X);
    BigNumberFree(Y);

    Mem.Free;
    Writer.Free;
  end;
end;

// Կд PEM ʽļ
function CnRSASavePublicKeyToPem(const PemFileName: string;
  PublicKey: TCnRSAPublicKey; KeyType: TCnRSAKeyType;
  KeyEncryptMethod: TCnKeyEncryptMethod; const Password: string): Boolean;
var
  Stream: TStream;
begin
  Stream := TFileStream.Create(PemFileName, fmCreate);
  try
    Result := CnRSASavePublicKeyToPem(Stream, PublicKey, KeyType,
      KeyEncryptMethod, Password);
  finally
    Stream.Free;
  end;
end;

function CnRSASavePublicKeyToPem(PemStream: TStream;
  PublicKey: TCnRSAPublicKey; KeyType: TCnRSAKeyType;
  KeyEncryptMethod: TCnKeyEncryptMethod; const Password: string): Boolean;
var
  Root, Node: TCnBerWriteNode;
  Writer: TCnBerWriter;
  Mem: TMemoryStream;
begin
  Result := False;
  if (PublicKey = nil) or (PublicKey.PubKeyProduct.GetBytesCount <= 0) or
    (PublicKey.PubKeyExponent.GetBytesCount <= 0) then
  begin
    _CnSetLastError(ECN_RSA_INVALID_INPUT);
    Exit;
  end;

  Writer := nil;
  Mem := nil;

  try
    Writer := TCnBerWriter.Create;
    Root := Writer.AddContainerNode(CN_BER_TAG_SEQUENCE);
    if KeyType = cktPKCS1 then
    begin
      // ƴ PKCS1 ʽݣȽϼ
      AddBigNumberToWriter(Writer, PublicKey.PubKeyProduct, Root);
      AddBigNumberToWriter(Writer, PublicKey.PubKeyExponent, Root);
    end
    else if KeyType = cktPKCS8 then
    begin
      // ƴ PKCS8 ʽ
      Node := Writer.AddContainerNode(CN_BER_TAG_SEQUENCE, Root);

      //  Node  ObjectIdentifier  Null
      Writer.AddBasicNode(CN_BER_TAG_OBJECT_IDENTIFIER, @CN_OID_RSAENCRYPTION_PKCS1[0],
        SizeOf(CN_OID_RSAENCRYPTION_PKCS1), Node);
      Writer.AddNullNode(Node);

      Node := Writer.AddContainerNode(CN_BER_TAG_BIT_STRING, Root);
      Node := Writer.AddContainerNode(CN_BER_TAG_SEQUENCE, Node);
      AddBigNumberToWriter(Writer, PublicKey.PubKeyProduct, Node);
      AddBigNumberToWriter(Writer, PublicKey.PubKeyExponent, Node);
    end;

    // ˣ Base64 ٷֶƴͷβдļ
    Mem := TMemoryStream.Create;
    Writer.SaveToStream(Mem);

    if KeyType = cktPKCS1 then
      Result := SaveMemoryToPemStream(PemStream, PEM_RSA_PUBLIC_HEAD,
        PEM_RSA_PUBLIC_TAIL, Mem, KeyEncryptMethod, ckhMd5, Password)
    else if KeyType = cktPKCS8 then
      Result := SaveMemoryToPemStream(PemStream, PEM_PUBLIC_HEAD,
        PEM_PUBLIC_TAIL, Mem, KeyEncryptMethod, ckhMd5, Password);

    if Result then
      _CnSetLastError(ECN_RSA_OK)
    else
      _CnSetLastError(ECN_RSA_PEM_FORMAT_ERROR);
  finally
    Mem.Free;
    Writer.Free;
  end;
end;

// ù˽Կݽмӽܣעӽʹõͬһ׻ƣ֡ڲô
function RSACrypt(Data: TCnBigNumber; Product: TCnBigNumber; Exponent: TCnBigNumber;
  Res: TCnBigNumber): Boolean;
begin
  Result := BigNumberMontgomeryPowerMod(Res, Data, Exponent, Product);
  if not Result then
    _CnSetLastError(ECN_RSA_BIGNUMBER_ERROR);
end;

// ˽ԿݽмܣؼǷɹ
function CnRSAEncrypt(Data: TCnBigNumber; PrivateKey: TCnRSAPrivateKey;
  Res: TCnBigNumber): Boolean;
begin
  Result := CnRSADecrypt(Res, PrivateKey, Data); // ͬһ˽Կ㣬ɸ
end;

// ùԿݽмܣؼǷɹ
function CnRSAEncrypt(Data: TCnBigNumber; PublicKey: TCnRSAPublicKey;
  Res: TCnBigNumber): Boolean;
begin
  Result := RSACrypt(Data, PublicKey.PubKeyProduct, PublicKey.PubKeyExponent, Res);
end;

// ˽ԿݽнܣؽǷɹ
function CnRSADecrypt(Res: TCnBigNumber; PrivateKey: TCnRSAPrivateKey;
  Data: TCnBigNumber): Boolean;
var
  M1, M2: TCnBigNumber;
begin
  if PrivateKey.UseCRT then
  begin
    M1 := nil;
    M2 := nil;

    // m1 = c^dP mod p
    // m2 = c^dQ mod q
    // h = qInv.(m1 - m2) mod p
    // m = m2 + h.q

    try
      M1 := TCnBigNumber.Create;
      BigNumberMontgomeryPowerMod(M1, Data, PrivateKey.FDP1, PrivateKey.FPrimeKey1);
      // m1 = c^dP mod p

      M2 := TCnBigNumber.Create;
      BigNumberMontgomeryPowerMod(M2, Data, PrivateKey.FDQ1, PrivateKey.FPrimeKey2);
      // m2 = c^dQ mod q

      // ¸ m1
      BigNumberSubMod(M1, M1, M2, PrivateKey.FPrimeKey1);
      // m1 := m1 - m2 mod p

      BigNumberDirectMulMod(M1, PrivateKey.FQInv, M1, PrivateKey.FPrimeKey1);
      // m1 := qInv * m1 mod p

      BigNumberMul(M1, M1, PrivateKey.FPrimeKey2);
      // m1 := m1 * q

      BigNumberAdd(Res, M2, M1);
      // m = m2 + m1

      Result := True;
    finally
      M2.Free;
      M1.Free;
    end;
  end
  else
    Result := RSACrypt(Data, PrivateKey.PrivKeyProduct, PrivateKey.PrivKeyExponent, Res);
end;

// ùԿݽнܣؽǷɹ
function CnRSADecrypt(Res: TCnBigNumber; PublicKey: TCnRSAPublicKey;
  Data: TCnBigNumber): Boolean;
begin
  Result := CnRSAEncrypt(Data, PublicKey, Res); // ͬһԿ㣬ɸ
end;

{ TCnRSAPrivateKey }

procedure TCnRSAPrivateKey.Assign(Source: TPersistent);
begin
  if Source is TCnRSAPrivateKey then
  begin
    BigNumberCopy(FPrimeKey1, (Source as TCnRSAPrivateKey).PrimeKey1);
    BigNumberCopy(FPrimeKey2, (Source as TCnRSAPrivateKey).PrimeKey2);
    BigNumberCopy(FPrivKeyProduct, (Source as TCnRSAPrivateKey).PrivKeyProduct);
    BigNumberCopy(FPrivKeyExponent, (Source as TCnRSAPrivateKey).PrivKeyExponent);

    //  CRT ʱ
    if FUseCRT and (Source as TCnRSAPrivateKey).UseCRT then
    begin
      BigNumberCopy(FDP1, (Source as TCnRSAPrivateKey).FDP1);
      BigNumberCopy(FDQ1, (Source as TCnRSAPrivateKey).FDQ1);
      BigNumberCopy(FQInv, (Source as TCnRSAPrivateKey).FQInv);
    end;
  end
  else
    inherited;
end;

procedure TCnRSAPrivateKey.Clear;
begin
  FPrimeKey1.Clear;
  FPrimeKey2.Clear;
  FPrivKeyProduct.Clear;
  FPrivKeyExponent.Clear;
end;

procedure TCnRSAPrivateKey.UpdateCRT;
var
  T: TCnBigNumber;
begin
  if not FUseCRT then
    Exit;

  T := TCnBigNumber.Create;
  try
    if BigNumberCompare(FPrimeKey1, FPrimeKey2) < 0 then // ȷ p > q
      BigNumberSwap(FPrimeKey1, FPrimeKey2);

    //  DP1 = D mod (PrimeKey1 - 1);
    BigNumberCopy(T, FPrimeKey1);
    T.SubWord(1);
    BigNumberMod(FDP1, FPrivKeyExponent, T);

    //  DQ1 = D mod (PrimeKey2 - 1);
    BigNumberCopy(T, FPrimeKey2);
    T.SubWord(1);
    BigNumberMod(FDQ1, FPrivKeyExponent, T);

    //  QInv = Prime2  Prime1 ģԪ
    BigNumberModularInverse(FQInv, FPrimeKey2, FPrimeKey1);
  finally
    T.Free;
  end;
end;

constructor TCnRSAPrivateKey.Create(CRT: Boolean);
begin
  inherited Create;
  FUseCRT := CRT;

  FPrimeKey1 := TCnBigNumber.Create;
  FPrimeKey2 := TCnBigNumber.Create;
  FPrivKeyProduct := TCnBigNumber.Create;
  FPrivKeyExponent := TCnBigNumber.Create;

  if FUseCRT then
  begin
    FDP1 := TCnBigNumber.Create;
    FDQ1 := TCnBigNumber.Create;
    FQInv := TCnBigNumber.Create;
  end;
end;

destructor TCnRSAPrivateKey.Destroy;
begin
  if FUseCRT then
  begin
    FQInv.Free;
    FDQ1.Free;
    FDP1.Free;
  end;

  FPrivKeyExponent.Free;
  FPrivKeyProduct.Free;
  FPrimeKey2.Free;
  FPrimeKey1.Free;
  inherited;
end;

function TCnRSAPrivateKey.GetBitsCount: Integer;
begin
  Result := FPrivKeyProduct.GetBitsCount;
end;

function TCnRSAPrivateKey.GetBytesCount: Integer;
begin
  Result := FPrivKeyProduct.GetBytesCount;
end;

{ TCnRSAPublicKey }

procedure TCnRSAPublicKey.Assign(Source: TPersistent);
begin
  if Source is TCnRSAPublicKey then
  begin
    BigNumberCopy(FPubKeyProduct, (Source as TCnRSAPublicKey).PubKeyProduct);
    BigNumberCopy(FPubKeyExponent, (Source as TCnRSAPublicKey).PubKeyExponent);
  end
  else
    inherited;
end;

procedure TCnRSAPublicKey.Clear;
begin
  FPubKeyProduct.Clear;
  FPubKeyExponent.Clear;
end;

constructor TCnRSAPublicKey.Create;
begin
  inherited;
  FPubKeyProduct := TCnBigNumber.Create;
  FPubKeyExponent := TCnBigNumber.Create;
end;

destructor TCnRSAPublicKey.Destroy;
begin
  FPubKeyExponent.Free;
  FPubKeyProduct.Free;
  inherited;
end;

function TCnRSAPublicKey.GetBitsCount: Integer;
begin
  Result := FPubKeyProduct.GetBitsCount;
end;

function TCnRSAPublicKey.GetBytesCount: Integer;
begin
  Result := FPubKeyProduct.GetBytesCount;
end;

{ RSA ܽ}

function RSACryptRawData(Data: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; Exponent, Product: TCnBigNumber): Boolean;
var
  D, R: TCnBigNumber;
begin
  Result := False;
  if (Data <> nil) and (DataByteLen > 0) then
  begin
    R := TCnBigNumber.Create;
    D := TCnBigNumber.FromBinary(PAnsiChar(Data), DataByteLen);

    if RSACrypt(D, Product, Exponent, R) then
    begin
      R.ToBinary(OutBuf); // TODO: Fixed Len?
      OutByteLen := R.GetBytesCount;

      Result := True;
      _CnSetLastError(ECN_RSA_OK);
    end;
  end
  else
    _CnSetLastError(ECN_RSA_INVALID_INPUT);
end;

function CnRSAEncryptRawData(PlainData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; PublicKey: TCnRSAPublicKey): Boolean;
begin
  Result := RSACryptRawData(PlainData, DataByteLen, OutBuf, OutByteLen,
    PublicKey.PubKeyExponent, PublicKey.PubKeyProduct);
end;

function CnRSAEncryptRawData(PlainData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; PrivateKey: TCnRSAPrivateKey): Boolean;
begin
  Result := RSACryptRawData(PlainData, DataByteLen, OutBuf, OutByteLen,
    PrivateKey.PrivKeyExponent, PrivateKey.PrivKeyProduct);
end;

function CnRSADecryptRawData(EnData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; PublicKey: TCnRSAPublicKey): Boolean;
begin
  Result := RSACryptRawData(EnData, DataByteLen, OutBuf, OutByteLen,
    PublicKey.PubKeyExponent, PublicKey.PubKeyProduct);
end;

function CnRSADecryptRawData(EnData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; PrivateKey: TCnRSAPrivateKey): Boolean;
begin
  Result := RSACryptRawData(EnData, DataByteLen, OutBuf, OutByteLen,
    PrivateKey.PrivKeyExponent, PrivateKey.PrivKeyProduct);
end;

function CnRSAEncryptRawBytes(PlainData: TBytes; PublicKey: TCnRSAPublicKey): TBytes;
var
  OutLen: Integer;
begin
  if (Length(PlainData) = 0) or (PublicKey.GetBytesCount <= 0) then
  begin
    _CnSetLastError(ECN_RSA_INVALID_INPUT);
    Result := nil;
  end
  else
  begin
    SetLength(Result, PublicKey.GetBytesCount);
    if CnRSAEncryptRawData(@PlainData[0], Length(PlainData), @Result[0], OutLen, PublicKey) then
      SetLength(Result, OutLen)
    else
      SetLength(Result, 0);
  end;
end;

function CnRSAEncryptRawBytes(PlainData: TBytes; PrivateKey: TCnRSAPrivateKey): TBytes;
var
  OutLen: Integer;
begin
  if (Length(PlainData) = 0) or (PrivateKey.GetBytesCount <= 0) then
  begin
    _CnSetLastError(ECN_RSA_INVALID_INPUT);
    Result := nil;
  end
  else
  begin
    SetLength(Result, PrivateKey.GetBytesCount);
    if CnRSAEncryptRawData(@PlainData[0], Length(PlainData), @Result[0], OutLen, PrivateKey) then
      SetLength(Result, OutLen)
    else
      SetLength(Result, 0);
  end;
end;

function CnRSADecryptRawBytes(EnData: TBytes; PublicKey: TCnRSAPublicKey): TBytes;
var
  OutLen: Integer;
begin
  if (Length(EnData) = 0) or (PublicKey.GetBytesCount <= 0) then
  begin
    _CnSetLastError(ECN_RSA_INVALID_INPUT);
    Result := nil;
  end
  else
  begin
    SetLength(Result, PublicKey.GetBytesCount);
    if CnRSAEncryptRawData(@EnData[0], Length(EnData), @Result[0], OutLen, PublicKey) then
      SetLength(Result, OutLen)
    else
      SetLength(Result, 0);
  end;
end;

function CnRSADecryptRawBytes(EnData: TBytes; PrivateKey: TCnRSAPrivateKey): TBytes;
var
  OutLen: Integer;
begin
  if (Length(EnData) = 0) or (PrivateKey.GetBytesCount <= 0) then
  begin
    _CnSetLastError(ECN_RSA_INVALID_INPUT);
    Result := nil;
  end
  else
  begin
    SetLength(Result, PrivateKey.GetBytesCount);
    if CnRSAEncryptRawData(@EnData[0], Length(EnData), @Result[0], OutLen, PrivateKey) then
      SetLength(Result, OutLen)
    else
      SetLength(Result, 0);
  end;
end;

// һƬڴָ Padding ģʽ RSA ӽܼ
function RSAPaddingCrypt(PaddingType, BlockSize: Integer; PlainData: Pointer;
  DataByteLen: Integer; OutBuf: Pointer; Exponent, Product: TCnBigNumber;
  PaddingMode: TCnRSAPaddingMode): Boolean;
var
  Stream: TMemoryStream;
  Res, Data: TCnBigNumber;
begin
  Result := False;
  Res := nil;
  Data := nil;
  Stream := nil;

  try
    Stream := TMemoryStream.Create;
    if PaddingMode = cpmPKCS1 then
    begin
      if not AddPKCS1Padding(PaddingType, BlockSize, PlainData, DataByteLen, Stream) then
      begin
        _CnSetLastError(ECN_RSA_PADDING_ERROR);
        Exit;
      end;
    end
    else if PaddingMode = cpmOAEP then
    begin
      // OAEP ԿܣԿĿڵ
      Stream.Size := Product.GetBytesCount;
      if not AddOaepSha1MgfPadding(Stream.Memory, Stream.Size, PlainData, DataByteLen) then
      begin
        _CnSetLastError(ECN_RSA_PADDING_ERROR);
        Exit;
      end;
    end;

    Res := TCnBigNumber.Create;
    Data := TCnBigNumber.FromBinary(PAnsiChar(Stream.Memory), Stream.Size);
    if not RSACrypt(Data, Product, Exponent, Res) then
      Exit;

    Res.ToBinary(PAnsiChar(OutBuf), Stream.Size);

    Result := True;
    _CnSetLastError(ECN_RSA_OK);
  finally
    Stream.Free;
    Data.Free;
    Res.Free;
  end;
end;

function CnRSAEncryptData(PlainData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  PublicKey: TCnRSAPublicKey; PaddingMode: TCnRSAPaddingMode): Boolean;
begin
  Result := RSAPaddingCrypt(CN_PKCS1_BLOCK_TYPE_PUBLIC_RANDOM, PublicKey.BitsCount div 8,
    PlainData, DataByteLen, OutBuf, PublicKey.PubKeyExponent, PublicKey.PubKeyProduct, PaddingMode);
end;

function CnRSAEncryptData(PlainData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  PrivateKey: TCnRSAPrivateKey): Boolean;
begin
  Result := RSAPaddingCrypt(CN_PKCS1_BLOCK_TYPE_PRIVATE_FF, PrivateKey.BitsCount div 8,
    PlainData, DataByteLen, OutBuf, PrivateKey.PrivKeyExponent, PrivateKey.PrivKeyProduct, cpmPKCS1);
  // ˽Կֻ֧ PKCS1 뷽ʽ֧ OAEP 뷽ʽ
end;

function CnRSAEncryptFile(const InFileName, OutFileName: string;
  PublicKey: TCnRSAPublicKey; PaddingMode: TCnRSAPaddingMode): Boolean;
var
  Stream: TMemoryStream;
  Res: TBytes;
begin
  Result := False;
  Stream := nil;
  try
    SetLength(Res, PublicKey.BytesCount);

    Stream := TMemoryStream.Create;
    Stream.LoadFromFile(InFileName);
    if not CnRSAEncryptData(Stream.Memory, Stream.Size, @Res[0], PublicKey, PaddingMode) then
      Exit;

    Stream.Clear;
    Stream.Write(Res[0], PublicKey.BytesCount);
    Stream.SaveToFile(OutFileName);

    Result := True;
    _CnSetLastError(ECN_RSA_OK);
  finally
    Stream.Free;
    SetLength(Res, 0);
  end;
end;

function CnRSAEncryptFile(const InFileName, OutFileName: string;
  PrivateKey: TCnRSAPrivateKey): Boolean;
var
  Stream: TMemoryStream;
  Res: TBytes;
begin
  Result := False;
  Stream := nil;
  try
    SetLength(Res, PrivateKey.BytesCount);

    Stream := TMemoryStream.Create;
    Stream.LoadFromFile(InFileName);
    if not CnRSAEncryptData(Stream.Memory, Stream.Size, @Res[0], PrivateKey) then
      Exit;

    Stream.Clear;
    Stream.Write(Res[0], PrivateKey.BytesCount);
    Stream.SaveToFile(OutFileName);

    Result := True;
    _CnSetLastError(ECN_RSA_OK);
  finally
    Stream.Free;
    SetLength(Res, 0);
  end;
end;

// һƬڴ RSA ӽܼչֵ Padding ʽԭʼ
function RSADecryptPadding(BlockSize: Integer; EnData: Pointer; DataByteLen: Integer;
  OutBuf: Pointer; out OutLen: Integer; Exponent, Product: TCnBigNumber;
  PaddingMode: TCnRSAPaddingMode): Boolean;
var
  Stream: TMemoryStream;
  Res, Data: TCnBigNumber;
  ResBuf: TBytes;
begin
  Result := False;
  Res := nil;
  Data := nil;
  Stream := nil;

  try
    Res := TCnBigNumber.Create;
    Data := TCnBigNumber.FromBinary(PAnsiChar(EnData), DataByteLen);
    if not RSACrypt(Data, Product, Exponent, Res) then
      Exit;

    SetLength(ResBuf, BlockSize);
    Res.ToBinary(PAnsiChar(@ResBuf[0]), BlockSize);
    //  Res ǰ 0  GetBytesCount  BlockSizeҪҶ

    if PaddingMode = cpmPKCS1 then
    begin
      Result := RemovePKCS1Padding(@ResBuf[0], Length(ResBuf), OutBuf, OutLen);
      if not Result then
        _CnSetLastError(ECN_RSA_PADDING_ERROR);
    end
    else if PaddingMode = cpmOAEP then
    begin
      // OAEP ܣ˽ԿĿڵ
      Result := RemoveOaepSha1MgfPadding(OutBuf, OutLen, @ResBuf[0], Length(ResBuf));

      if Result then
        _CnSetLastError(ECN_RSA_OK)
      else
        _CnSetLastError(ECN_RSA_PADDING_ERROR);
    end;
  finally
    Stream.Free;
    Res.Free;
    Data.Free;
  end;
end;

function CnRSADecryptData(EnData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; PublicKey: TCnRSAPublicKey): Boolean;
begin
  Result := RSADecryptPadding(PublicKey.GetBytesCount, EnData, DataByteLen,
    OutBuf, OutByteLen, PublicKey.PubKeyExponent, PublicKey.PubKeyProduct, cpmPKCS1);
  // Կֻ֧ PKCS1֧ OAEP
end;

function CnRSADecryptData(EnData: Pointer; DataByteLen: Integer; OutBuf: Pointer;
  out OutByteLen: Integer; PrivateKey: TCnRSAPrivateKey; PaddingMode: TCnRSAPaddingMode): Boolean;
begin
  Result := RSADecryptPadding(PrivateKey.GetBytesCount, EnData, DataByteLen,
    OutBuf, OutByteLen, PrivateKey.PrivKeyExponent, PrivateKey.PrivKeyProduct, PaddingMode);
end;

function CnRSAEncryptBytes(PlainData: TBytes; PublicKey: TCnRSAPublicKey;
  PaddingMode: TCnRSAPaddingMode): TBytes;
begin
  if (Length(PlainData) = 0) or (PublicKey.GetBytesCount <= 0) then
  begin
    _CnSetLastError(ECN_RSA_INVALID_INPUT);
    Result := nil;
  end
  else
  begin
    SetLength(Result, PublicKey.GetBytesCount);
    if not CnRSAEncryptData(@PlainData[0], Length(PlainData), @Result[0], PublicKey, PaddingMode) then
      SetLength(Result, 0);
  end;
end;

function CnRSAEncryptBytes(PlainData: TBytes; PrivateKey: TCnRSAPrivateKey): TBytes;
begin
  if (Length(PlainData) = 0) or (PrivateKey.GetBytesCount <= 0) then
  begin
    _CnSetLastError(ECN_RSA_INVALID_INPUT);
    Result := nil;
  end
  else
  begin
    SetLength(Result, PrivateKey.GetBytesCount);
    if not CnRSAEncryptData(@PlainData[0], Length(PlainData), @Result[0], PrivateKey) then
      SetLength(Result, 0);
  end;
end;

function CnRSADecryptBytes(EnData: TBytes; PublicKey: TCnRSAPublicKey): TBytes;
var
  OutLen: Integer;
begin
  if (Length(EnData) = 0) or (PublicKey.GetBytesCount <= 0) then
  begin
    _CnSetLastError(ECN_RSA_INVALID_INPUT);
    Result := nil;
  end
  else
  begin
    SetLength(Result, PublicKey.GetBytesCount);
    if CnRSADecryptData(@EnData[0], Length(EnData), @Result[0], OutLen, PublicKey) then
      SetLength(Result, OutLen)
    else
      SetLength(Result, 0);
  end;
end;

function CnRSADecryptBytes(EnData: TBytes; PrivateKey: TCnRSAPrivateKey;
  PaddingMode: TCnRSAPaddingMode): TBytes;
var
  OutLen: Integer;
begin
  if (Length(EnData) = 0) or (PrivateKey.GetBytesCount <= 0) then
  begin
    _CnSetLastError(ECN_RSA_INVALID_INPUT);
    Result := nil;
  end
  else
  begin
    SetLength(Result, PrivateKey.GetBytesCount);
    if CnRSADecryptData(@EnData[0], Length(EnData), @Result[0], OutLen, PrivateKey) then
      SetLength(Result, OutLen)
    else
      SetLength(Result, 0);
  end;
end;

function CnRSADecryptFile(const InFileName, OutFileName: string;
  PublicKey: TCnRSAPublicKey): Boolean;
var
  Stream: TMemoryStream;
  Res: TBytes;
  OutLen: Integer;
begin
  Result := False;
  Stream := nil;
  try
    SetLength(Res, PublicKey.GetBytesCount);

    Stream := TMemoryStream.Create;
    Stream.LoadFromFile(InFileName);

    if Stream.Size <> PublicKey.GetBytesCount then
    begin
      _CnSetLastError(ECN_RSA_INVALID_INPUT);
      Exit;
    end;

    if not CnRSADecryptData(Stream.Memory, Stream.Size, @Res[0], OutLen, PublicKey) then
      Exit;

    Stream.Clear;
    Stream.Write(Res[0], OutLen);
    Stream.SaveToFile(OutFileName);

    Result := True;
    _CnSetLastError(ECN_RSA_OK);
  finally
    Stream.Free;
    SetLength(Res, 0);
  end;
end;

function CnRSADecryptFile(const InFileName, OutFileName: string;
  PrivateKey: TCnRSAPrivateKey; PaddingMode: TCnRSAPaddingMode): Boolean;
var
  Stream: TMemoryStream;
  Res: TBytes;
  OutLen: Integer;
begin
  Result := False;
  Stream := nil;
  try
    SetLength(Res, PrivateKey.BytesCount);

    Stream := TMemoryStream.Create;
    Stream.LoadFromFile(InFileName);

    if Stream.Size <> PrivateKey.GetBytesCount then
    begin
      _CnSetLastError(ECN_RSA_INVALID_INPUT);
      Exit;
    end;

    if not CnRSADecryptData(Stream.Memory, Stream.Size, @Res[0], OutLen, PrivateKey, PaddingMode) then
      Exit;

    Stream.Clear;
    Stream.Write(Res[0], OutLen);
    Stream.SaveToFile(OutFileName);

    Result := True;
    _CnSetLastError(ECN_RSA_OK);
  finally
    Stream.Free;
    SetLength(Res, 0);
  end;
end;

// RSA ļǩ֤ʵ

// ָժҪ㷨ָĶӴֵд Streamڲô
function CalcDigestStream(InStream: TStream; SignType: TCnRSASignDigestType;
  outStream: TStream): Boolean;
var
  Md5: TCnMD5Digest;
  Sha1: TCnSHA1Digest;
  Sha256: TCnSHA256Digest;
  Sm3Dig: TCnSM3Digest;
begin
  Result := False;
  case SignType of
    rsdtMD5:
      begin
        Md5 := MD5Stream(InStream);
        outStream.Write(Md5, SizeOf(TCnMD5Digest));
        Result := True;
      end;
    rsdtSHA1:
      begin
        Sha1 := SHA1Stream(InStream);
        outStream.Write(Sha1, SizeOf(TCnSHA1Digest));
        Result := True;
      end;
    rsdtSHA256:
      begin
        Sha256 := SHA256Stream(InStream);
        outStream.Write(Sha256, SizeOf(TCnSHA256Digest));
        Result := True;
      end;
    rsdtSM3:
      begin
        Sm3Dig := SM3Stream(InStream);
        outStream.Write(Sm3Dig, SizeOf(TCnSM3Digest));
        Result := True;
      end
  end;

  if Result then
    _CnSetLastError(ECN_RSA_OK)
  else
    _CnSetLastError(ECN_RSA_DIGEST_ERROR);
end;

// ָժҪ㷨ļĶӴֵд Stream
function CalcDigestFile(const FileName: string; SignType: TCnRSASignDigestType;
  outStream: TStream): Boolean;
var
  Md5: TCnMD5Digest;
  Sha1: TCnSHA1Digest;
  Sha256: TCnSHA256Digest;
  Sm3Dig: TCnSM3Digest;
begin
  Result := False;
  case SignType of
    rsdtMD5:
      begin
        Md5 := MD5File(FileName);
        outStream.Write(Md5, SizeOf(TCnMD5Digest));
        Result := True;
      end;
    rsdtSHA1:
      begin
        Sha1 := SHA1File(FileName);
        outStream.Write(Sha1, SizeOf(TCnSHA1Digest));
        Result := True;
      end;
    rsdtSHA256:
      begin
        Sha256 := SHA256File(FileName);
        outStream.Write(Sha256, SizeOf(TCnSHA256Digest));
        Result := True;
      end;
    rsdtSM3:
      begin
        Sm3Dig := SM3File(FileName);
        outStream.Write(Sm3Dig, SizeOf(TCnSM3Digest));
        Result := True;
      end;
  end;

  if Result then
    _CnSetLastError(ECN_RSA_OK)
  else
    _CnSetLastError(ECN_RSA_DIGEST_ERROR);
end;

function AddDigestTypeOIDNodeToWriter(AWriter: TCnBerWriter; ASignType: TCnRSASignDigestType;
  AParent: TCnBerWriteNode): TCnBerWriteNode;
begin
  Result := nil;
  case ASignType of
    rsdtMD5:
      Result := AWriter.AddBasicNode(CN_BER_TAG_OBJECT_IDENTIFIER, @OID_SIGN_MD5[0],
        SizeOf(OID_SIGN_MD5), AParent);
    rsdtSHA1:
      Result := AWriter.AddBasicNode(CN_BER_TAG_OBJECT_IDENTIFIER, @OID_SIGN_SHA1[0],
        SizeOf(OID_SIGN_SHA1), AParent);
    rsdtSHA256:
      Result := AWriter.AddBasicNode(CN_BER_TAG_OBJECT_IDENTIFIER, @OID_SIGN_SHA256[0],
        SizeOf(OID_SIGN_SHA256), AParent);
  end;
end;

{
  ͨժҪ㷨ժҪ󣬻Ҫ BER  PKCS1 Padding
  BER ĸʽ£
  DigestInfo ::= SEQUENCE )
    digestAlgorithm DigestAlgorithmIdentifier,
    digest Digest )

  DigestAlgorithmIdentifier ::= AlgorithmIdentifier
  Digest ::= OCTET STRING

  Ҳǣ
  SEQUENCE
    SEQUENCE
      OBJECT IDENTIFIER
      NULL
    OCTET STRING
}

function CnRSASignStream(InStream: TMemoryStream; OutSignStream: TMemoryStream;
  PrivateKey: TCnRSAPrivateKey; SignType: TCnRSASignDigestType = rsdtMD5): Boolean;
var
  Stream, BerStream, EnStream: TMemoryStream;
  Data, Res: TCnBigNumber;
  ResBuf: TBytes;
  Writer: TCnBerWriter;
  Root, Node: TCnBerWriteNode;
begin
  Result := False;
  Stream := nil;
  EnStream := nil;
  BerStream := nil;
  Writer := nil;
  Data := nil;
  Res := nil;

  try
    Stream := TMemoryStream.Create;
    EnStream := TMemoryStream.Create;

    if SignType = rsdtNone then
    begin
      // ժҪֱݶ
      if not AddPKCS1Padding(CN_PKCS1_BLOCK_TYPE_PRIVATE_FF, PrivateKey.GetBytesCount,
        InStream.Memory, InStream.Size, EnStream) then
      begin
        _CnSetLastError(ECN_RSA_PADDING_ERROR);
        Exit;
      end;
    end
    else // ժҪ
    begin
      if not CalcDigestStream(InStream, SignType, Stream) then // Ӵֵ
        Exit;

      BerStream := TMemoryStream.Create;
      Writer := TCnBerWriter.Create;

      // Ȼ󰴸ʽ BER 
      Root := Writer.AddContainerNode(CN_BER_TAG_SEQUENCE);
      Node := Writer.AddContainerNode(CN_BER_TAG_SEQUENCE, Root);
      AddDigestTypeOIDNodeToWriter(Writer, SignType, Node);
      Writer.AddNullNode(Node);
      Writer.AddBasicNode(CN_BER_TAG_OCTET_STRING, Stream.Memory, Stream.Size, Root);
      Writer.SaveToStream(BerStream);

      // ٰ BER  PKCS1 
      if not AddPKCS1Padding(CN_PKCS1_BLOCK_TYPE_PRIVATE_FF, PrivateKey.GetBytesCount,
        BerStream.Memory, BerStream.Size, EnStream) then
      begin
        _CnSetLastError(ECN_RSA_PADDING_ERROR);
        Exit;
      end;
    end;

    // ˽Կ
    Data := TCnBigNumber.FromBinary(PAnsiChar(EnStream.Memory), EnStream.Size);
    Res := TCnBigNumber.Create;

    if RSACrypt(Data, PrivateKey.PrivKeyProduct, PrivateKey.PrivKeyExponent, Res) then
    begin
      // ע Res ܴǰ 0Դ˴ PrivateKey.GetBytesCount Ϊ׼ȷ©ǰ 0
      SetLength(ResBuf, PrivateKey.GetBytesCount);
      Res.ToBinary(@ResBuf[0], PrivateKey.GetBytesCount);

      // ˽Կܺļ
      Stream.Clear;
      Stream.Write(ResBuf[0], PrivateKey.GetBytesCount);
      Stream.SaveToStream(OutSignStream);

      Result := True;
      _CnSetLastError(ECN_RSA_OK);
    end;
  finally
    Stream.Free;
    EnStream.Free;
    BerStream.Free;
    Data.Free;
    Res.Free;
    Writer.Free;
    SetLength(ResBuf, 0);
  end;
end;

function CnRSAVerifyStream(InStream: TMemoryStream; InSignStream: TMemoryStream;
  PublicKey: TCnRSAPublicKey; SignType: TCnRSASignDigestType = rsdtMD5): Boolean;
var
  Stream: TMemoryStream;
  Data, Res: TCnBigNumber;
  ResBuf, BerBuf: TBytes;
  BerLen: Integer;
  Reader: TCnBerReader;
  Node: TCnBerReadNode;
begin
  Result := False;
  Stream := nil;
  Reader := nil;
  Data := nil;
  Res := nil;

  try
    Stream := TMemoryStream.Create;

    // ǩȹԿ
    Data := TCnBigNumber.FromBinary(PAnsiChar(InSignStream.Memory), InSignStream.Size);
    Res := TCnBigNumber.Create;

    if RSACrypt(Data, PublicKey.PubKeyProduct, PublicKey.PubKeyExponent, Res) then
    begin
      // ע Res ܴǰ 0Դ˴ PublicKey.GetBytesCount Ϊ׼ȷ©ǰ 0
      SetLength(ResBuf, PublicKey.GetBytesCount);
      Res.ToBinary(@ResBuf[0], PublicKey.GetBytesCount);

      //  Res н PKCS1 ݷ BerBuf 
      SetLength(BerBuf, Length(ResBuf));
      if not RemovePKCS1Padding(@ResBuf[0], Length(ResBuf), @BerBuf[0], BerLen) then
      begin
        _CnSetLastError(ECN_RSA_PADDING_ERROR);
        Exit;
      end;

      if SignType = rsdtNone then
      begin
        // ժҪʱӽȥ PKCS1  Padding ʣֱԭʼ InStream ݱȶ
        Result := InStream.Size = BerLen;
        if Result then
          Result := CompareMem(InStream.Memory, @BerBuf[0], InStream.Size);

        _CnSetLastError(ECN_RSA_OK); // У飬ʹУ鲻ͨҲմ
      end
      else
      begin
        if (BerLen <= 0) or (BerLen >= Length(ResBuf)) then
        begin
          _CnSetLastError(ECN_RSA_BER_ERROR);
          Exit;
        end;

        // ⿪ Ber ı㷨ʹ SignType ԭʼֵ
        Reader := TCnBerReader.Create(@BerBuf[0], BerLen);
        Reader.ParseToTree;
        if Reader.TotalCount < 5 then
        begin
          _CnSetLastError(ECN_RSA_BER_ERROR);
          Exit;
        end;

        Node := Reader.Items[2];
        SignType := GetDigestSignTypeFromBerOID(Node.BerDataAddress, Node.BerDataLength);
        if SignType = rsdtNone then
        begin
          _CnSetLastError(ECN_RSA_BER_ERROR);
          Exit;
        end;

        if not CalcDigestStream(InStream, SignType, Stream) then // Ӵֵ
          Exit;

        //  Ber ӴֵȽ
        Node := Reader.Items[4];
        Result := Stream.Size = Node.BerDataLength;
        if Result then
          Result := CompareMem(Stream.Memory, Node.BerDataAddress, Stream.Size);

        _CnSetLastError(ECN_RSA_OK); // У飬ʹУ鲻ͨҲմ
      end;
    end;
  finally
    Stream.Free;
    Reader.Free;
    Data.Free;
    Res.Free;
    SetLength(ResBuf, 0);
    SetLength(BerBuf, 0);
  end;
end;

function CnRSASignBytes(InData: TBytes; PrivateKey: TCnRSAPrivateKey;
  SignType: TCnRSASignDigestType): TBytes;
var
  InStream, OutStream: TMemoryStream;
begin
  Result := nil;
  InStream := nil;
  OutStream := nil;

  try
    InStream := TMemoryStream.Create;
    BytesToStream(InData, InStream);

    OutStream := TMemoryStream.Create;
    if CnRSASignStream(InStream, OutStream, PrivateKey, SignType) then
      Result := StreamToBytes(OutStream);
  finally
    OutStream.Free;
    InStream.Free;
  end;
end;

function CnRSAVerifyBytes(InData: TBytes; InSignBytes: TBytes;
  PublicKey: TCnRSAPublicKey; SignType: TCnRSASignDigestType): Boolean;
var
  InStream, SignStream: TMemoryStream;
begin
  InStream := nil;
  SignStream := nil;

  try
    InStream := TMemoryStream.Create;
    BytesToStream(InData, InStream);

    SignStream := TMemoryStream.Create;
    BytesToStream(InSignBytes, SignStream);
    Result := CnRSAVerifyStream(InStream, SignStream, PublicKey, SignType);
  finally
    SignStream.Free;
    InStream.Free;
  end;
end;

function CnRSASignFile(const InFileName, OutSignFileName: string;
  PrivateKey: TCnRSAPrivateKey; SignType: TCnRSASignDigestType): Boolean;
var
  Stream, BerStream, EnStream: TMemoryStream;
  Data, Res: TCnBigNumber;
  ResBuf: TBytes;
  Writer: TCnBerWriter;
  Root, Node: TCnBerWriteNode;
begin
  Result := False;
  Stream := nil;
  EnStream := nil;
  BerStream := nil;
  Writer := nil;
  Data := nil;
  Res := nil;

  try
    Stream := TMemoryStream.Create;
    EnStream := TMemoryStream.Create;

    if SignType = rsdtNone then
    begin
      // ժҪֱݶ
      Stream.LoadFromFile(InFileName);
      if not AddPKCS1Padding(CN_PKCS1_BLOCK_TYPE_PRIVATE_FF, PrivateKey.GetBytesCount,
        Stream.Memory, Stream.Size, EnStream) then
      begin
        _CnSetLastError(ECN_RSA_PADDING_ERROR);
        Exit;
      end;
    end
    else // ժҪ
    begin
      if not CalcDigestFile(InFileName, SignType, Stream) then // ļӴֵ
        Exit;

      BerStream := TMemoryStream.Create;
      Writer := TCnBerWriter.Create;

      // Ȼ󰴸ʽ BER 
      Root := Writer.AddContainerNode(CN_BER_TAG_SEQUENCE);
      Node := Writer.AddContainerNode(CN_BER_TAG_SEQUENCE, Root);
      AddDigestTypeOIDNodeToWriter(Writer, SignType, Node);
      Writer.AddNullNode(Node);
      Writer.AddBasicNode(CN_BER_TAG_OCTET_STRING, Stream.Memory, Stream.Size, Root);
      Writer.SaveToStream(BerStream);

      // ٰ BER  PKCS1 
      if not AddPKCS1Padding(CN_PKCS1_BLOCK_TYPE_PRIVATE_FF, PrivateKey.GetBytesCount,
        BerStream.Memory, BerStream.Size, EnStream) then
      begin
        _CnSetLastError(ECN_RSA_PADDING_ERROR);
        Exit;
      end;
    end;

    // ˽Կ
    Data := TCnBigNumber.FromBinary(PAnsiChar(EnStream.Memory), EnStream.Size);
    Res := TCnBigNumber.Create;

    if RSACrypt(Data, PrivateKey.PrivKeyProduct, PrivateKey.PrivKeyExponent, Res) then
    begin
      // ע Res ܴǰ 0Դ˴ PrivateKey.GetBytesCount Ϊ׼ȷ©ǰ 0
      SetLength(ResBuf, PrivateKey.GetBytesCount);
      Res.ToBinary(@ResBuf[0], PrivateKey.GetBytesCount);

      // ˽Կܺļ
      Stream.Clear;
      Stream.Write(ResBuf[0], PrivateKey.GetBytesCount);
      Stream.SaveToFile(OutSignFileName);

      Result := True;
      _CnSetLastError(ECN_RSA_OK);
    end;
  finally
    Stream.Free;
    EnStream.Free;
    BerStream.Free;
    Data.Free;
    Res.Free;
    Writer.Free;
    SetLength(ResBuf, 0);
  end;
end;

function CnRSAVerifyFile(const InFileName, InSignFileName: string;
  PublicKey: TCnRSAPublicKey; SignType: TCnRSASignDigestType): Boolean;
var
  Stream, Sign: TMemoryStream;
  Data, Res: TCnBigNumber;
  ResBuf, BerBuf: TBytes;
  BerLen: Integer;
  Reader: TCnBerReader;
  Node: TCnBerReadNode;
begin
  Result := False;
  Stream := nil;
  Reader := nil;
  Sign := nil;
  Data := nil;
  Res := nil;

  try
    Stream := TMemoryStream.Create;
    Sign := TMemoryStream.Create;

    // ǩļȹԿ
    Sign.LoadFromFile(InSignFileName);
    Data := TCnBigNumber.FromBinary(PAnsiChar(Sign.Memory), Sign.Size);
    Res := TCnBigNumber.Create;

    if RSACrypt(Data, PublicKey.PubKeyProduct, PublicKey.PubKeyExponent, Res) then
    begin
      SetLength(ResBuf, PublicKey.GetBytesCount);
      Res.ToBinary(@ResBuf[0], PublicKey.GetBytesCount);

      //  Res н PKCS1 ݷ BerBuf 
      SetLength(BerBuf, Length(ResBuf));
      if not RemovePKCS1Padding(@ResBuf[0], Length(ResBuf), @BerBuf[0], BerLen) then
      begin
        _CnSetLastError(ECN_RSA_PADDING_ERROR);
        Exit;
      end;

      if SignType = rsdtNone then
      begin
        Stream.LoadFromFile(InFileName); // ժҪʱֱӱȶԽԭʼļ
        Result := Stream.Size = BerLen;
        if Result then
          Result := CompareMem(Stream.Memory, @BerBuf[0], Stream.Size);

        _CnSetLastError(ECN_RSA_OK); // У飬ʹУ鲻ͨҲմ
      end
      else
      begin
        if (BerLen <= 0) or (BerLen >= Length(ResBuf)) then
        begin
          _CnSetLastError(ECN_RSA_BER_ERROR);
          Exit;
        end;

        // ⿪ Ber ı㷨ʹ SignType ԭʼֵ
        Reader := TCnBerReader.Create(@BerBuf[0], BerLen);
        Reader.ParseToTree;
        if Reader.TotalCount < 5 then
        begin
          _CnSetLastError(ECN_RSA_BER_ERROR);
          Exit;
        end;

        Node := Reader.Items[2];
        SignType := GetDigestSignTypeFromBerOID(Node.BerDataAddress, Node.BerDataLength);
        if SignType = rsdtNone then
        begin
          _CnSetLastError(ECN_RSA_BER_ERROR);
          Exit;
        end;

        if not CalcDigestFile(InFileName, SignType, Stream) then // ļӴֵ
          Exit;

        //  Ber ӴֵȽ
        Node := Reader.Items[4];
        Result := Stream.Size = Node.BerDataLength;
        if Result then
          Result := CompareMem(Stream.Memory, Node.BerDataAddress, Stream.Size);

        _CnSetLastError(ECN_RSA_OK); // У飬ʹУ鲻ͨҲմ
      end;
    end;
  finally
    Stream.Free;
    Reader.Free;
    Sign.Free;
    Data.Free;
    Res.Free;
    SetLength(ResBuf, 0);
    SetLength(BerBuf, 0);
  end;
end;

//  Diffie-Hellman ԿЭ㷨Сԭ漰طֽ˽
function CnDiffieHellmanGeneratePrimeRootByBitsCount(BitsCount: Integer;
  Prime, MinRoot: TCnBigNumber): Boolean;
var
  I: Integer;
  Q, R, T: TCnBigNumber;
begin
  Result := False;
  if BitsCount <= 16 then
  begin
    _CnSetLastError(ECN_RSA_INVALID_BITS);
    Exit;
  end;

  Q := nil;
  T := nil;
  R := nil;

  try
    Q := TCnBigNumber.Create;
    repeat
      if not BigNumberGeneratePrimeByBitsCount(Prime, BitsCount) then
      begin
        _CnSetLastError(ECN_RSA_BIGNUMBER_ERROR);
        Exit;
      end;

      if BigNumberCopy(Q, Prime) = nil then
        Exit;

      Q.SubWord(1);
      Q.ShiftRightOne;

      if BigNumberIsProbablyPrime(Q) then // P = 2Q + 1P  Q ж
        Break;
    until False;

    T := TCnBigNumber.Create;
    R := TCnBigNumber.Create;

    for I := 2 to MaxInt do
    begin
      T.SetWord(I);
      if not BigNumberDirectMulMod(R, T, T, Prime) then // G^2 mod P <> 1
        Exit;

      if not R.IsOne then
      begin
        if not BigNumberPowerMod(R, T, Q, Prime) then   // G^Q mod P <> 1
          Exit;

        if not R.IsOne then
        begin
          Result := BigNumberCopy(MinRoot, T) <> nil;
          Exit;
        end;
      end;
    end;
  finally
    R.Free;
    T.Free;
    Q.Free;
  end;
end;

// ѡ PrivateKey  Diffie-Hellman ԿЭ̵Կ
function CnDiffieHellmanGenerateOutKey(Prime, Root, SelfPrivateKey: TCnBigNumber;
  OutPublicKey: TCnBigNumber): Boolean;
begin
  // OutPublicKey = (Root ^ SelfPrivateKey) mod Prime
  Result := BigNumberMontgomeryPowerMod(OutPublicKey, Root, SelfPrivateKey, Prime);
end;

// ݶԷ͵ Diffie-Hellman ԿЭ̵ԿɹϵԿ
function CnDiffieHellmanComputeKey(Prime, SelfPrivateKey, OtherPublicKey: TCnBigNumber;
  SecretKey: TCnBigNumber): Boolean;
begin
  // SecretKey = (OtherPublicKey ^ SelfPrivateKey) mod Prime
  Result := BigNumberMontgomeryPowerMod(SecretKey, OtherPublicKey, SelfPrivateKey, Prime);
end;

// ɻɢıɫӴպСԭʵʵͬ Diffie-Hellman
function CnChameleonHashGeneratePrimeRootByBitsCount(BitsCount: Integer;
  Prime, MinRoot: TCnBigNumber): Boolean;
begin
  Result := CnDiffieHellmanGeneratePrimeRootByBitsCount(BitsCount, Prime, MinRoot);
end;

// ͨɢıɫӴպһֵһ SecretKeyָϢӴ
function CnChameleonHashCalcDigest(InData: TCnBigNumber; InRandom: TCnBigNumber;
  InSecretKey: TCnBigNumber; OutHash: TCnBigNumber; Prime, Root: TCnBigNumber): Boolean;
var
  T: TCnBigNumber;
begin
  T := nil;

  // Hash(M, R) = g^(M + R * Sk) mod P
  try
    T := TCnBigNumber.Create;
    BigNumberCopy(T, InSecretKey);
    BigNumberDirectMulMod(T, InRandom, T, Prime);

    BigNumberAddMod(T, InData, T, Prime);
    Result := BigNumberMontgomeryPowerMod(OutHash, Root, T, Prime);
  finally
    T.Free;
  end;
end;

// ͨɢıɫӴպ SecretKey ¾ϢܹͬӴյֵ
function CnChameleonHashFindRandom(InOldData, InNewData: TCnBigNumber;
  InOldRandom, InSecretKey: TCnBigNumber; OutNewRandom: TCnBigNumber;
  Prime, Root: TCnBigNumber): Boolean;
var
  M, SK: TCnBigNumber;
begin
  M := nil;
  SK := nil;

  // R2 := ((M1 - M2)/SK + R1) mod P
  try
    M := TCnBigNumber.Create;
    BigNumberSubMod(M, InOldData, InNewData, Prime);

    SK := TCnBigNumber.Create;
    BigNumberModularInverse(SK, InSecretKey, Prime);

    BigNumberDirectMulMod(M, M, SK, Prime);
    Result := BigNumberAddMod(OutNewRandom, M, InOldRandom, Prime);
  finally
    SK.Free;
    M.Free;
  end;
end;

function GetDigestSignTypeFromBerOID(OID: Pointer; OidByteLen: Integer): TCnRSASignDigestType;
begin
  Result := rsdtNone;
  if (OidByteLen = SizeOf(OID_SIGN_MD5)) and CompareMem(OID, @OID_SIGN_MD5[0], OidByteLen) then
    Result := rsdtMD5
  else if (OidByteLen = SizeOf(OID_SIGN_SHA1)) and CompareMem(OID, @OID_SIGN_SHA1[0], OidByteLen) then
    Result := rsdtSHA1
  else if (OidByteLen = SizeOf(OID_SIGN_SHA256)) and CompareMem(OID, @OID_SIGN_SHA256[0], OidByteLen) then
    Result := rsdtSHA256;
end;

function GetRSADigestNameFromSignDigestType(Digest: TCnRSASignDigestType): string;
begin
  case Digest of
    rsdtNone: Result := '<None>';
    rsdtMD5: Result := 'MD5';
    rsdtSHA1: Result := 'SHA1';
    rsdtSHA256: Result := 'SHA256';
  else
    Result := '<Unknown>';
  end;
end;

// Ĭϵʹ SHA1 ɺ
function Pkcs1Sha1MGF(Seed: Pointer; SeedLen: Integer; OutMask: Pointer;
  MaskLen: Integer): Boolean;
var
  I, OutLen, MdLen: Integer;
  Cnt: array[0..3] of Byte;
  Ctx: TCnSHA1Context;
  Dig: TCnSHA1Digest;
begin
  Result := False;
  OutLen := 0;
  MdLen := SizeOf(TCnSHA1Digest);
  if (Seed = nil) or (SeedLen <= 0) then
    Exit;

  if (OutMask = nil) or (MaskLen <= 0) then
    Exit;

  I := 0;
  while OutLen < MaskLen do
  begin
    Cnt[0] := (I shr 24) and $FF;
    Cnt[1] := (I shr 16) and $FF;
    Cnt[2] := (I shr 8) and $FF;
    Cnt[3] := I and $FF;

    SHA1Init(Ctx);
    SHA1Update(Ctx, PAnsiChar(Seed), SeedLen);
    SHA1Update(Ctx, @Cnt[0], SizeOf(Cnt));

    if OutLen + MdLen <= MaskLen then
    begin
      SHA1Final(Ctx, PCnSHA1Digest(TCnNativeInt(OutMask) + OutLen)^);
      OutLen := OutLen + MdLen;
    end
    else
    begin
      SHA1Final(Ctx, Dig);
      Move(Dig[0], PCnSHA1Digest(TCnNativeInt(OutMask) + OutLen)^, MaskLen - OutLen);
      OutLen := MaskLen;
    end;

    Inc(I);
  end;
  Result := True;
end;

function AddOaepSha1MgfPadding(ToBuf: PByte; ToByteLen: Integer; PlainData: PByte;
  DataByteLen: Integer; DigestParam: PByte; ParamByteLen: Integer): Boolean;
var
  EmLen, MdLen, I: Integer;
  SeedMask: TCnSHA1Digest;
  DB, Seed: PByteArray;
  DBMask: TBytes;
begin
  Result := False;
  EmLen:= ToByteLen - 1;

  MdLen := SizeOf(TCnSHA1Digest);

  if (DataByteLen > EmLen - 2 * MdLen - 1) or (EmLen < 2 * MdLen + 1) then
  begin
    _CnSetLastError(ECN_RSA_PADDING_ERROR);
    Exit;
  end;

  ToBuf^ := 0;
  Seed := PByteArray(TCnNativeInt(ToBuf) + 1);
  DB := PByteArray(TCnNativeInt(ToBuf) + MdLen + 1);

  // 00 | 20 λ Seed | DB
  //  DB := ParamHash || PS || 0x01 || Data EmLen - MdLen
  // Ҫ XOR һγΪ MaskDB
  SeedMask := SHA1Buffer(DigestParam, ParamByteLen);
  Move(SeedMask[0], DB^, MdLen);

  // To  DB ǰ 20 ֽţ浽β 0
  FillChar(PByte(TCnNativeInt(DB) + MdLen)^, EmLen - DataByteLen - 2 * MdLen - 1, 0);
  DB^[EmLen - DataByteLen - MdLen - 1] := 1;

  // ĸ
  Move(PlainData^, PByte(TCnNativeInt(DB) + EmLen - DataByteLen - MdLen)^, DataByteLen);

  // To[1] ʼ 20 ֽ Rand һ
  if not CnRandomFillBytes(PAnsiChar(Seed), MdLen) then
  begin
    _CnSetLastError(ECN_RSA_PADDING_ERROR);
    Exit;
  end;

  SetLength(DBMask, EmLen - MdLen);

  //  Seed  MGF ݣ׼ DB  XOR
  if not Pkcs1Sha1MGF(Seed, MdLen, @DBMask[0], EmLen - MdLen) then
  begin
    _CnSetLastError(ECN_RSA_PADDING_ERROR);
    Exit;
  end;

  for I := 0 to EmLen - MdLen - 1 do
    DB^[I] := DB^[I] xor DBMask[I];        // õ Masked DB

  // XOR  Masked DB  MGF ݣ׼ Seed  XOR
  if not Pkcs1Sha1MGF(DB, EmLen - MdLen, @SeedMask[0], MdLen) then
  begin
    _CnSetLastError(ECN_RSA_PADDING_ERROR);
    Exit;
  end;

  for I := 0 to MdLen - 1 do
    Seed^[I] := Seed^[I] xor SeedMask[I];  // õ Masked Seed

  SetLength(DBMask, 0);
  Result := True;
  // Ϣ = 00 || maskedSeed || maskedDB
end;

function RemoveOaepSha1MgfPadding(ToBuf: PByte; out OutByteLen: Integer; EnData: PByte;
  DataByteLen: Integer; DigestParam: PByte; ParamByteLen: Integer): Boolean;
var
  I, MdLen, DBLen, MStart: Integer;
  MaskedDB, MaskedSeed: PByteArray;
  Seed, ParamHash: TCnSHA1Digest;
  DB: TBytes;
begin
  Result := False;
  if (EnData = nil) or (ToBuf = nil) then
  begin
    _CnSetLastError(ECN_RSA_PADDING_ERROR);
    Exit;
  end;

  if EnData^ <> 0 then  // ֽڱ 0
  begin
    _CnSetLastError(ECN_RSA_PADDING_ERROR);
    Exit;
  end;

  MdLen := SizeOf(TCnSHA1Digest);
  DBLen := DataByteLen - MdLen - 1;
  if DBLen <= 0 then
  begin
    _CnSetLastError(ECN_RSA_PADDING_ERROR);
    Exit;
  end;

  // ҳе  MdLen  MaskedSeed Լ泤 DBLen  MaskedDB
  MaskedSeed := PByteArray(TCnNativeInt(EnData) + 1);
  MaskedDB := PByteArray(TCnNativeInt(EnData) + MdLen + 1);

  ParamHash := SHA1Buffer(DigestParam, ParamByteLen);

  //  MaskedDB 
  if not Pkcs1Sha1MGF(@MaskedDB[0], DBLen, @Seed[0], MdLen) then
  begin
    _CnSetLastError(ECN_RSA_PADDING_ERROR);
    Exit;
  end;

  for I := 0 to MdLen - 1 do
    Seed[I] := Seed[I] xor MaskedSeed^[I];  // õ Seed

  SetLength(DB, DBLen);
  try
    if not Pkcs1Sha1MGF(@Seed[0], MdLen, @DB[0], DBLen) then
    begin
      _CnSetLastError(ECN_RSA_PADDING_ERROR);
      Exit;
    end;

    for I := 0 to DBLen - 1 do
      DB[I] := DB[I] xor MaskedDB^[I];  // õ DB

    //  DB ǰ MdLen ֽӦõ ParamHashȽж֮
    if not CompareMem(@DB[0], @ParamHash[0], MdLen) then
    begin
      _CnSetLastError(ECN_RSA_PADDING_ERROR);
      Exit;
    end;

    // ͨ DB[MdLen] ʼ 0  1ѵ 1 1 ĵβ͵ľϢԭ
    MStart := -1;
    for I := MdLen to DBLen - 1 do
    begin
      if DB[I] <> 0 then
      begin
        if DB[I] <> 1 then
        begin
          _CnSetLastError(ECN_RSA_PADDING_ERROR);
          Exit;
        end
        else // 0 ĵһ 1
        begin
          // ¼ʱ I + 1
          MStart := I + 1;
          Break;
        end;
      end; // 0 
    end;

    // DB[MStart]  DB[DBLen - 1] 
    if (MStart > 0) and (MStart < DBLen) then
    begin
//      ûжĿǷ񹻲ɣΪ OutLen û ToBuf ʵʳ
//      if DBLen - MStart > OutLen then
//      begin
//        _CnSetLastError(ECN_RSA_PADDING_ERROR);
//        Exit;
//      end;

      Move(DB[MStart], ToBuf^, DBLen - MStart);
      OutByteLen := DBLen - MStart; // ݳ
      Result := True;
    end;
  finally
    SetLength(DB, 0);
  end;
end;

end.
