{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnPoly1305;
{* |<PRE>
================================================================================
* ƣ
* ԪƣPoly1305 Ϣ֤㷨ʵֵԪ
* ԪߣCnPack 飨master@cnpack.org)
*     עԪ RFC 7539 淶ʵPoly1305 Ϣ֤㷨
*           㷨Ϊⳤ 32 ֽԿ 16 ֽӴֵɢԲǺܺ
*           ע⣺ TCnBigNumber ʹõ Binary ֽ˳ҲǴˣ
*            RFC ֹ涨Сˣ˴Ҫֶ ReverseMemory
*            CPU Ǵ˻Сˡ
* ƽ̨Windows 7 + Delphi 5.0
* ݲԣPWin9X/2000/XP/7 + Delphi 5/6
*   õԪеַϱػʽ
* ޸ļ¼2022.07.19 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Classes, SysUtils, CnNative, CnBigNumber;

const
  CN_POLY1305_KEYSIZE   = 32;
  {* Poly1305 㷨볤ȣ 32 ֽҲ 256 λ Key}

  CN_POLY1305_BLOCKSIZE = 16;
  {* Poly1305 㷨ڲֿ鳤ȣÿ 16 ֽ}

  CN_POLY1305_DIGSIZE   = 16;
  {* Poly1305 㷨ժҪȣ16 ֽҲ 128 λ}

type
  TCnPoly1305Key = array[0..CN_POLY1305_KEYSIZE - 1] of Byte;
  {* Poly1305 㷨 Key}

  TCnPoly1305Digest = array[0..CN_POLY1305_DIGSIZE - 1] of Byte;
  {* Poly1305 㷨Ӵս}

  TCnPoly1305Context = class
  {* ֿ Poly1305 Ķ}
  private
    R: TCnBigNumber;
    S: TCnBigNumber;
    A: TCnBigNumber;
    N: TCnBigNumber;
  public
    constructor Create;
    destructor Destroy; override;
  end;

function Poly1305Buffer(const Buffer; Count: Cardinal; Key: TCnPoly1305Key): TCnPoly1305Digest;
{* ݿ Poly1305 㣬Buffer һ㴫ַ

   
     const Buffer                         - ݿַ
     Count: Cardinal                      - ݿֽڳ
     Key: TCnPoly1305Key                  - 

   ֵTCnPoly1305Digest              - ؼ Poly 1305 Ӵֵ
}

function Poly1305Bytes(Data: TBytes; Key: TBytes): TCnPoly1305Digest;
{* ֽ Poly1305 Ӵֵ

   
     Data: TBytes                         - ֽ
     Key: TBytes                          - ֽ

   ֵTCnPoly1305Digest              - ؼ Poly 1305 Ӵֵ
}

function Poly1305Data(Data: Pointer; DataByteLength: Cardinal;
  Key: TCnPoly1305Key): TCnPoly1305Digest;
{* ݿ Poly1305 Ӵֵ

   
     Data: Pointer                        - ݿַ
     DataByteLength: Cardinal             - ݿֽڳ
     Key: TCnPoly1305Key                  - 

   ֵTCnPoly1305Digest              - ؼ Poly 1305 Ӵֵ
}

function Poly1305Print(const Digest: TCnPoly1305Digest): string;
{* ʮƸʽ Poly1305 ֵ

   
     const Digest: TCnPoly1305Digest      - Poly1305 Ӵֵ

   ֵstring                         - ʮַ
}

function Poly1305Match(const D1: TCnPoly1305Digest; const D2: TCnPoly1305Digest): Boolean;
{* Ƚ Poly1305 ֵǷȡ

   
     const D1: TCnPoly1305Digest          - Ƚϵ Poly1305 Ӵֵһ
     const D2: TCnPoly1305Digest          - Ƚϵ Poly1305 Ӵֵ

   ֵBoolean                        -  Poly 1305 ӴֵǷ
}

function Poly1305DigestToStr(const Digest: TCnPoly1305Digest): string;
{* Poly1305 ֵת string

   
     const Digest: TCnPoly1305Digest      - ת Poly1305 Ӵֵ

   ֵstring                         - תַݣ
}

procedure Poly1305Init(out Context: TCnPoly1305Context; Key: TCnPoly1305Key);
{* ʼһ Poly1305 ģڲ Context ׼ Poly1305 

   
     out Context: TCnPoly1305Context      - ʼ Poly1305 Ľṹ
     Key: TCnPoly1305Key                  - 

   ֵޣ
}

procedure Poly1305Update(Context: TCnPoly1305Context; Input: PAnsiChar;
  ByteLength: Cardinal; ZeroPadding: Boolean = False);
{* ԳʼĶһݽ Poly1305 㡣
   ɶε㲻ͬݿ飬轫ͬݿƴڴС
    Update Ϊĩβʱǿм㣬Ӵһݴһֻ Final
   ZeroPadding ĩβ 16 ʱǷ 0

   
     Context: TCnPoly1305Context          - Poly1305 Ľṹ
     Input: PAnsiChar                     - ݿַ
     ByteLength: Cardinal                 - ݿֽڳȣ 16 ֽʱǿм
     ZeroPadding: Boolean                 - ĩβ 16 ֽʱǷĩβ 0

   ֵޣ
}

procedure Poly1305Final(var Context: TCnPoly1305Context; var Digest: TCnPoly1305Digest);
{* ּ㣬 Poly130  Digest вͷ Context

   
     var Context: TCnPoly1305Context      - Poly1305 Ľṹ
     var Digest: TCnPoly1305Digest        - ص Poly1305 Ӵֵ

   ֵޣ
}

implementation

var
  Prime: TCnBigNumber = nil; // Poly1305 ʹõ
  Clamp: TCnBigNumber = nil; // Poly1305 ʹõ Clamp

function Poly1305Bytes(Data: TBytes; Key: TBytes): TCnPoly1305Digest;
var
  AKey: TCnPoly1305Key;
  L: Integer;
begin
  FillChar(AKey[0], SizeOf(TCnPoly1305Key), 0);
  L := Length(Key);
  if L > SizeOf(TCnPoly1305Key) then
    L := SizeOf(TCnPoly1305Key);

  Move(Key[0], AKey[0], L);
  Result := Poly1305Data(@Data[0], Length(Data), AKey);
end;

function Poly1305Buffer(const Buffer; Count: Cardinal; Key: TCnPoly1305Key): TCnPoly1305Digest;
var
  C: TCnPoly1305Context;
begin
  Poly1305Init(C, Key);
  Poly1305Update(C, PAnsiChar(Buffer), Count);
  Poly1305Final(C, Result);
end;

function Poly1305Data(Data: Pointer; DataByteLength: Cardinal;
  Key: TCnPoly1305Key): TCnPoly1305Digest;
var
  I, B, L: Integer;
  R, S, A, N: TCnBigNumber;
  Buf: array[0..CN_POLY1305_BLOCKSIZE] of Byte;
  P: PByteArray;
  RKey: TCnPoly1305Key;
begin
  Move(Key[0], RKey[0], SizeOf(TCnPoly1305Key));

  //  TCnBigNumber ʹõ Binary ֽ˳ҲǴ
  //  RFC ֹ涨СҪֶ ReverseMemory  CPU Ǵ˻С
  ReverseMemory(@RKey[0], CN_POLY1305_BLOCKSIZE);
  ReverseMemory(@RKey[CN_POLY1305_BLOCKSIZE], CN_POLY1305_BLOCKSIZE);

  R := nil;
  S := nil;
  A := nil;
  N := nil;

  try
    R := TCnBigNumber.FromBinary(@RKey[0], CN_POLY1305_BLOCKSIZE);
    BigNumberAnd(R, R, Clamp);

    S := TCnBigNumber.FromBinary(@RKey[CN_POLY1305_BLOCKSIZE], CN_POLY1305_BLOCKSIZE);

    A := TCnBigNumber.Create;
    A.SetZero;

    N := TCnBigNumber.Create;

    B := (DataByteLength + CN_POLY1305_BLOCKSIZE - 1) div CN_POLY1305_BLOCKSIZE;
    P := PByteArray(Data);

    for I := 1 to B do
    begin
      if I <> B then // ͨ飬16 ֽ
        L := CN_POLY1305_BLOCKSIZE
      else           // β飬ܲ 16 ֽ
      begin
        L := DataByteLength mod CN_POLY1305_BLOCKSIZE;
        if L = 0 then
          L := CN_POLY1305_BLOCKSIZE;
      end;

      Move(P^[(I - 1) * CN_POLY1305_BLOCKSIZE], Buf[0], L);  // 
      Buf[L] := 1;                                           // ڵĸֽø 1

      ReverseMemory(@Buf[0], L + 1);
      N.SetBinary(@Buf[0], L + 1);

      BigNumberAdd(A, A, N);
      BigNumberDirectMulMod(A, R, A, Prime);
    end;

    BigNumberAdd(A, A, S);
    BigNumberKeepLowBits(A, 8 * CN_POLY1305_DIGSIZE);

    A.ToBinary(@Result[0], CN_POLY1305_DIGSIZE);
    ReverseMemory(@Result[0], SizeOf(TCnPoly1305Digest));
  finally
    N.Free;
    A.Free;
    S.Free;
    R.Free;
  end;
end;

function Poly1305Print(const Digest: TCnPoly1305Digest): string;
begin
  Result := DataToHex(@Digest[0], SizeOf(TCnPoly1305Digest));
end;

function Poly1305Match(const D1, D2: TCnPoly1305Digest): Boolean;
begin
  Result := CompareMem(@D1[0], @D2[0], SizeOf(TCnPoly1305Digest));
end;

function Poly1305DigestToStr(const Digest: TCnPoly1305Digest): string;
begin
  Result := MemoryToString(@Digest[0], SizeOf(TCnPoly1305Digest));
end;

{ TCnPoly1305Context }

constructor TCnPoly1305Context.Create;
begin
  inherited;
  R := TCnBigNumber.Create;
  S := TCnBigNumber.Create;
  A := TCnBigNumber.Create;
  N := TCnBigNumber.Create;
end;

destructor TCnPoly1305Context.Destroy;
begin
  N.Free;
  A.Free;
  S.Free;
  R.Free;
  inherited;
end;

procedure Poly1305Init(out Context: TCnPoly1305Context; Key: TCnPoly1305Key);
var
  RKey: TCnPoly1305Key;
begin
  Move(Key[0], RKey[0], SizeOf(TCnPoly1305Key));
  ReverseMemory(@RKey[0], CN_POLY1305_BLOCKSIZE);
  ReverseMemory(@RKey[CN_POLY1305_BLOCKSIZE], CN_POLY1305_BLOCKSIZE);

  Context := TCnPoly1305Context.Create;

  Context.R.SetBinary(@RKey[0], CN_POLY1305_BLOCKSIZE);
  BigNumberAnd(Context.R, Context.R, Clamp);

  Context.S.SetBinary(@RKey[CN_POLY1305_BLOCKSIZE], CN_POLY1305_BLOCKSIZE);
  Context.A.SetZero;
  Context.N.SetZero;
end;

procedure Poly1305Update(Context: TCnPoly1305Context; Input: PAnsiChar;
  ByteLength: Cardinal; ZeroPadding: Boolean);
var
  I, B, L: Integer;
  Buf: array[0..CN_POLY1305_BLOCKSIZE] of Byte;
  P: PByteArray;
begin
  B := (ByteLength + CN_POLY1305_BLOCKSIZE - 1) div CN_POLY1305_BLOCKSIZE;
  P := PByteArray(Input);

  for I := 1 to B do
  begin
    if I <> B then // ͨ飬16 ֽ
      L := CN_POLY1305_BLOCKSIZE
    else           // β飬ܲ 16 ֽ
    begin
      L := ByteLength mod CN_POLY1305_BLOCKSIZE;
      if L = 0 then
        L := CN_POLY1305_BLOCKSIZE
      else if ZeroPadding then
        FillChar(Buf[0], SizeOf(Buf), 0); // ĩβ鲻 16 Ҫ 0 Ҫȫ 0
    end;

    Move(P^[(I - 1) * CN_POLY1305_BLOCKSIZE], Buf[0], L);  // 
    if ZeroPadding then                                    // ĩβҪ 0 油ˣҪ 1
      L := CN_POLY1305_BLOCKSIZE;
    Buf[L] := 1;                                           // ڵĸֽڣ 0 ʱֽڣø 1

    ReverseMemory(@Buf[0], L + 1);
    Context.N.SetBinary(@Buf[0], L + 1);

    BigNumberAdd(Context.A, Context.A, Context.N);
    BigNumberDirectMulMod(Context.A, Context.R, Context.A, Prime);
  end;
end;

procedure Poly1305Final(var Context: TCnPoly1305Context; var Digest: TCnPoly1305Digest);
begin
  BigNumberAdd(Context.A, Context.A, Context.S);
  BigNumberKeepLowBits(Context.A, 8 * CN_POLY1305_DIGSIZE);

  Context.A.ToBinary(@Digest[0], CN_POLY1305_DIGSIZE);
  ReverseMemory(@Digest[0], SizeOf(TCnPoly1305Digest));

  FreeAndNil(Context);
end;

initialization
  Prime := TCnBigNumber.Create;
  Prime.SetOne;
  Prime.ShiftLeft(130);
  Prime.SubWord(5);

  Clamp := TCnBigNumber.FromHex('0FFFFFFC0FFFFFFC0FFFFFFC0FFFFFFF');

finalization
  Clamp.Free;
  Prime.Free;

end.
