{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnOTS;
{* |<PRE>
================================================================================
* ƣ
* ԪƣһӴǩ㷨ʵֵԪ
* ԪߣCnPack  (master@cnpack.org)
*     עԪʵ˻ SM3  SHA256  OTS/M-OTS/W-OTS һӴǩ㷨
*           Hash Based One Time SignatureȵӴ㷨δʵ֡
* ƽ̨Win7 + Delphi 5.0
* ݲԣδ
*   õԪ豾ػ
* ޸ļ¼2023.11.25 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Classes, CnNative, CnBits, CnRandom, CnSM3, CnSHA2;

type

// ================ Lamport ĳ OTS SM3 Ӵ㷨 ==================

  TCnOTSSM3PrivateKey = array[0..(SizeOf(TCnSM3Digest) * 8 * 2) - 1] of TCnSM3Digest;
  {*  SM3 Ӵ㷨һӴǩ˽ԿΪ 256 * 2 ֵΪһֵȡ SM3 Ľ}

  TCnOTSSM3PublicKey = array[0..(SizeOf(TCnSM3Digest) * 8 * 2) - 1] of TCnSM3Digest;
  {*  SM3 Ӵ㷨һӴǩԿΪ 256 * 2 ֵ SM3 Ӵֵ}

  TCnOTSSM3Signature = array[0..(SizeOf(TCnSM3Digest) * 8) - 1] of TCnSM3Digest;
  {*  SM3 Ӵ㷨һӴǩֵʵ 256  SM3 Ӵֵ}

  TCnOTSSM3VerificationKey = array[0..(SizeOf(TCnSM3Digest) * 8) - 1] of TCnSM3Digest;
  {*  SM3 Ӵ㷨һӴǩ֤ԿʵǴ˽Կгȡ 256 ֵ}

// =============== Lamport ĳ OTS SHA256 Ӵ㷨 ================

  TCnOTSSHA256PrivateKey = array[0..(SizeOf(TCnSHA256Digest) * 8 * 2) - 1] of TCnSHA256Digest;
  {*  SHA256 Ӵ㷨һӴǩ˽ԿΪ 256 * 2 ֵΪһֵȡ SHA256 Ľ}

  TCnOTSSHA256PublicKey = array[0..(SizeOf(TCnSHA256Digest) * 8 * 2) - 1] of TCnSHA256Digest;
  {*  SHA256 Ӵ㷨һӴǩԿΪ 256 * 2 ֵ SHA256 Ӵֵ}

  TCnOTSSHA256Signature = array[0..(SizeOf(TCnSHA256Digest) * 8) - 1] of TCnSHA256Digest;
  {*  SHA256 Ӵ㷨һӴǩֵʵ 256  SHA256 Ӵֵ}

  TCnOTSSHA256VerificationKey = array[0..(SizeOf(TCnSHA256Digest) * 8) - 1] of TCnSHA256Digest;
  {*  SHA256 Ӵ㷨һӴǩ֤ԿʵǴ˽Կгȡ 256 ֵ}

// ========== Merkle  M-OTSУ 0 ĸ SM3 Ӵ㷨 ============

  TCnMOTSSM3PrivateKey = array[0..((SizeOf(TCnSM3Digest) + 1) * 8) - 1] of TCnSM3Digest;
  {*  SM3 Ӵ㷨 M-OTS ˽ԿΪ 256 ֵһֽУͣΪһֵȡ SM3 Ľ}

  TCnMOTSSM3PublicKey = array[0..((SizeOf(TCnSM3Digest)+ 1) * 8) - 1] of TCnSM3Digest;
  {*  SM3 Ӵ㷨 M-OTS ԿΪ 256 ֵһֽУ͵ SM3 Ӵֵ}

  TCnMOTSSM3Signature = array[0..((SizeOf(TCnSM3Digest) + 1) * 8) - 1] of TCnSM3Digest;
  {*  SM3 Ӵ㷨 M-OTS ǩʵ 256  SM3 ӴֵһֽУͣ 0 Ӧȫ 0}

// ========== Merkle  M-OTSУ 0 ĸ SHA256 Ӵ㷨 ============

  TCnMOTSSHA256PrivateKey = array[0..((SizeOf(TCnSHA256Digest) + 1) * 8) - 1] of TCnSHA256Digest;
  {*  SHA256 Ӵ㷨 M-OTS ˽ԿΪ 256 ֵһֽУͣΪһֵȡ SHA256 Ľ}

  TCnMOTSSHA256PublicKey = array[0..((SizeOf(TCnSHA256Digest)+ 1) * 8) - 1] of TCnSHA256Digest;
  {*  SHA256 Ӵ㷨 M-OTS ԿΪ 256 ֵһֽУ͵ SHA256 Ӵֵ}

  TCnMOTSSHA256Signature = array[0..((SizeOf(TCnSHA256Digest) + 1) * 8) - 1] of TCnSHA256Digest;
  {*  SHA256 Ӵ㷨 M-OTS ǩʵ 256  SHA256 ӴֵһֽУͣ 0 Ӧȫ 0}

// ===== Winternitz Ľ W-OTSȡ n = 8 Ҳ 1 ֽڣ SM3 Ӵ㷨 ======

  TCnWOTSSM3PrivateKey = array[0..SizeOf(TCnSM3Digest) + 1] of TCnSM3Digest;
  {*  SM3 Ӵ㷨 W-OTS ˽ԿΪ 32 ֵһ˫ֽУͣΪһֵȡ SM3 Ľ}

  TCnWOTSSM3PublicKey = array[0..SizeOf(TCnSM3Digest) + 1] of TCnSM3Digest;
  {*  SM3 Ӵ㷨 W-OTS ԿΪ 32 ֵһ˫ֽУ͸ 256 εõ SM3 Ӵֵ}

  TCnWOTSSM3Signature = array[0..SizeOf(TCnSM3Digest) + 1] of TCnSM3Digest;
  {*  SM3 Ӵ㷨 W-OTS ǩΪ 32  SM3 Ӵֵһ˫ֽУͣע˫ֽڰ˳洢}

// ==== Winternitz Ľ W-OTSȡ n = 8 Ҳ 1 ֽڣ SHA256 Ӵ㷨 ====

  TCnWOTSSHA256PrivateKey = array[0..SizeOf(TCnSHA256Digest) + 1] of TCnSHA256Digest;
  {*  SHA256 Ӵ㷨 W-OTS ˽ԿΪ 32 ֵһ˫ֽУͣΪһֵȡ SHA256 Ľ}

  TCnWOTSSHA256PublicKey = array[0..SizeOf(TCnSHA256Digest) + 1] of TCnSHA256Digest;
  {*  SHA256 Ӵ㷨 W-OTS ԿΪ 32 ֵһ˫ֽУ͸ 256 εõ SHA256 Ӵֵ}

  TCnWOTSSHA256Signature = array[0..SizeOf(TCnSHA256Digest) + 1] of TCnSHA256Digest;
  {*  SHA256 Ӵ㷨 W-OTS ǩΪ 32  SHA256 Ӵֵһ˫ֽУͣע˫ֽڰ˳洢}

// ================ Lamport ĳ OTS SM3 Ӵ㷨 ==================

function CnOTSSM3GenerateKeys(var PrivateKey: TCnOTSSM3PrivateKey;
  var PublicKey: TCnOTSSM3PublicKey): Boolean;
{* һԻ SM3 Ӵ㷨 OTS һӴǩ˽ԿǷɹ

   
     var PrivateKey: TCnOTSSM3PrivateKey  - ɵĻ SM3 һӴǩ˽Կ
     var PublicKey: TCnOTSSM3PublicKey    - ɵĻ SM3 һӴǩԿ

   ֵBoolean                        - Ƿɹ
}

procedure CnOTSSM3SignData(Data: Pointer; DataByteLen: Integer;
  PrivateKey: TCnOTSSM3PrivateKey; PublicKey: TCnOTSSM3PublicKey;
  var OutSignature: TCnOTSSM3Signature; var OutVerifyKey: TCnOTSSM3VerificationKey);
{* ݹ˽Կָݿ OTS һӴǩ֤ǩԿ
   ƽʱġǩֵ빫Կ֤ʱ֤֤Կ
   ֤Կʵ˽Կһ֣֤Կֻ֤ͬһΣ
   ˽ԿϢǩˣһǩĺ塣

   
     Data: Pointer                                        - ǩݿַ
     DataByteLen: Integer                                 - ǩݿֽڳ
     PrivateKey: TCnOTSSM3PrivateKey                      - ǩĻ SM3 һӴǩ˽Կ
     PublicKey: TCnOTSSM3PublicKey                        - ǩĻ SM3 һӴǩԿ
     var OutSignature: TCnOTSSM3Signature                 - ǩֵ
     var OutVerifyKey: TCnOTSSM3VerificationKey           - ֤Կ

   ֵޣ
}

function CnOTSSM3VerifyData(Data: Pointer; DataByteLen: Integer;
  Signature: TCnOTSSM3Signature; PublicKey: TCnOTSSM3PublicKey;
  VerifyKey: TCnOTSSM3VerificationKey): Boolean;
{* ġ֤Կ빫Կָ֤ݿ OTS ǩǷȷ֤Ƿɹ
   ע淶 Signature δ֤ʹ VerifyKey С

   
     Data: Pointer                        - ֤ݿַ
     DataByteLen: Integer                 - ֤ݿֽڳ
     Signature: TCnOTSSM3Signature        - ֤ǩֵ
     PublicKey: TCnOTSSM3PublicKey        - ֤Ļ SM3 һӴǩԿ
     VerifyKey: TCnOTSSM3VerificationKey  - ֤֤Կ

   ֵBoolean                        - ֤ǩǷɹ
}

procedure CnOTSSM3SignBytes(Data: TBytes; PrivateKey: TCnOTSSM3PrivateKey;
  PublicKey: TCnOTSSM3PublicKey; var OutSignature: TCnOTSSM3Signature;
  var OutVerifyKey: TCnOTSSM3VerificationKey);
{* ݹ˽Կֽ OTS һӴǩ֤ǩԿ
   ƽʱġǩֵ빫Կ֤ʱ֤֤Կ
   ֤Կʵ˽Կһ֣֤Կֻ֤ͬһΣ
   ˽ԿϢǩˣһǩĺ塣

   
     Data: TBytes                                         - ǩֽ
     PrivateKey: TCnOTSSM3PrivateKey                      - ǩĻ SM3 һӴǩ˽Կ
     PublicKey: TCnOTSSM3PublicKey                        - ǩĻ SM3 һӴǩԿ
     var OutSignature: TCnOTSSM3Signature                 - ǩֵ
     var OutVerifyKey: TCnOTSSM3VerificationKey           - ֤Կ

   ֵޣ
}

function CnOTSSM3VerifyBytes(Data: TBytes; Signature: TCnOTSSM3Signature;
  PublicKey: TCnOTSSM3PublicKey; VerifyKey: TCnOTSSM3VerificationKey): Boolean;
{* ġ֤Կ빫Կֽ֤ OTS ǩǷȷ֤Ƿɹ
   ע淶 Signature δ֤ʹ VerifyKey С

   
     Data: TBytes                         - ֽ֤
     Signature: TCnOTSSM3Signature        - ֤ǩֵ
     PublicKey: TCnOTSSM3PublicKey        - ֤Ļ SM3 һӴǩԿ
     VerifyKey: TCnOTSSM3VerificationKey  - ֤֤Կ

   ֵBoolean                        - ֤ǩǷɹ
}

// =============== Lamport ĳ OTS SHA256 Ӵ㷨 ================

function CnOTSSHA256GenerateKeys(var PrivateKey: TCnOTSSHA256PrivateKey;
  var PublicKey: TCnOTSSHA256PublicKey): Boolean;
{* һԻ SHA256 Ӵ㷨 OTS һӴǩ˽ԿǷɹ

   
     var PrivateKey: TCnOTSSHA256PrivateKey               - ɵĻ SHA256 һӴǩ˽Կ
     var PublicKey: TCnOTSSHA256PublicKey                 - ɵĻ SHA256 һӴǩԿ

   ֵBoolean                                        - Ƿɹ
}

procedure CnOTSSHA256SignData(Data: Pointer; DataByteLen: Integer;
  PrivateKey: TCnOTSSHA256PrivateKey; PublicKey: TCnOTSSHA256PublicKey;
  var OutSignature: TCnOTSSHA256Signature; var OutVerifyKey: TCnOTSSHA256VerificationKey);
{* ݹ˽Կָݿ OTS һӴǩ֤ǩԿ
   ƽʱġǩֵ빫Կ֤ʱ֤֤Կ
   ֤Կʵ˽Կһ֣֤Կֻ֤ͬһΣ
   ˽ԿϢǩˣһǩĺ塣

   
     Data: Pointer                                        - ǩݿַ
     DataByteLen: Integer                                 - ǩݿֽڳ
     PrivateKey: TCnOTSSHA256PrivateKey                   - ǩĻ SHA256 һӴǩ˽Կ
     PublicKey: TCnOTSSHA256PublicKey                     - ǩĻ SHA256 һӴǩԿ
     var OutSignature: TCnOTSSHA256Signature              - ǩֵ
     var OutVerifyKey: TCnOTSSHA256VerificationKey        - ֤Կ

   ֵޣ
}

function CnOTSSHA256VerifyData(Data: Pointer; DataByteLen: Integer;
  Signature: TCnOTSSHA256Signature; PublicKey: TCnOTSSHA256PublicKey;
  VerifyKey: TCnOTSSHA256VerificationKey): Boolean;
{* ġ֤Կ빫Կָ֤ݿ OTS ǩǷȷ֤Ƿɹ
   ע淶 Signature δ֤ʹ VerifyKey С

   
     Data: Pointer                                        - ֤ݿַ
     DataByteLen: Integer                                 - ֤ݿֽڳ
     Signature: TCnOTSSHA256Signature                     - ֤ǩֵ
     PublicKey: TCnOTSSHA256PublicKey                     - ֤Ļ SHA256 һӴǩԿ
     VerifyKey: TCnOTSSHA256VerificationKey               - ֤֤Կ

   ֵBoolean                                        - ֤ǩǷɹ
}

procedure CnOTSSHA256SignBytes(Data: TBytes; PrivateKey: TCnOTSSHA256PrivateKey;
  PublicKey: TCnOTSSHA256PublicKey; var OutSignature: TCnOTSSHA256Signature;
  var OutVerifyKey: TCnOTSSHA256VerificationKey);
{* ݹ˽Կֽ OTS һӴǩ֤ǩԿ
   ƽʱġǩֵ빫Կ֤ʱ֤֤Կ
   ֤Կʵ˽Կһ֣֤Կֻ֤ͬһΣ
   ˽ԿϢǩˣһǩĺ塣

   
     Data: TBytes                                         - ǩֽ
     PrivateKey: TCnOTSSHA256PrivateKey                   - ǩĻ SHA256 һӴǩ˽Կ
     PublicKey: TCnOTSSHA256PublicKey                     - ǩĻ SHA256 һӴǩԿ
     var OutSignature: TCnOTSSHA256Signature              - ǩֵ
     var OutVerifyKey: TCnOTSSHA256VerificationKey        - ֤Կ

   ֵޣ
}

function CnOTSSHA256VerifyBytes(Data: TBytes; Signature: TCnOTSSHA256Signature;
  PublicKey: TCnOTSSHA256PublicKey; VerifyKey: TCnOTSSHA256VerificationKey): Boolean;
{* ġ֤Կ빫Կֽ֤ OTS ǩǷȷ֤Ƿɹ
   ע淶 Signature δ֤ʹ VerifyKey С

   
     Data: TBytes                                         - ֽ֤
     Signature: TCnOTSSHA256Signature                     - ֤ǩֵ
     PublicKey: TCnOTSSHA256PublicKey                     - ֤Ļ SHA256 һӴǩԿ
     VerifyKey: TCnOTSSHA256VerificationKey               - ֤֤Կ

   ֵBoolean                                        - ֤ǩǷɹ
}

// ========== Merkle Ľ M-OTSУ 0 ĸ SM3 Ӵ㷨 ============

function CnMOTSSM3GenerateKeys(var PrivateKey: TCnMOTSSM3PrivateKey;
  var PublicKey: TCnMOTSSM3PublicKey): Boolean;
{* һԻ SM3 Ӵ㷨 M-OTS ˽ԿǷɹ

   
     var PrivateKey: TCnMOTSSM3PrivateKey -  SM3 Ӵ㷨 M-OTS ˽Կ
     var PublicKey: TCnMOTSSM3PublicKey   -  SM3 Ӵ㷨 M-OTS Կ

   ֵBoolean                        - Ƿɹ
}

procedure CnMOTSSM3SignData(Data: Pointer; DataByteLen: Integer;
  PrivateKey: TCnMOTSSM3PrivateKey; var OutSignature: TCnMOTSSM3Signature);
{* ˽Կָݿ M-OTS һӴǩ
   ƽʱġǩֵ빫Կ֤ʱ֤˽Կ

   
     Data: Pointer                                        - ǩݿַ
     DataByteLen: Integer                                 - ǩݿֽڳ
     PrivateKey: TCnMOTSSM3PrivateKey                     - ǩĻ SM3  M-OTS ˽Կ
     var OutSignature: TCnMOTSSM3Signature                - ǩֵ

   ֵޣ
}

function CnMOTSSM3VerifyData(Data: Pointer; DataByteLen: Integer;
  Signature: TCnMOTSSM3Signature; PublicKey: TCnMOTSSM3PublicKey): Boolean;
{* 빫Կָ֤ݿ M-OTS ǩǷȷ֤Ƿɹ

   
     Data: Pointer                        - ֤ݿַ
     DataByteLen: Integer                 - ֤ݿֽڳ
     Signature: TCnMOTSSM3Signature       - ֤ǩֵ
     PublicKey: TCnMOTSSM3PublicKey       - ֤Ļ SM3  M-OTS Կ

   ֵBoolean                        - ֤ǩǷɹ
}

procedure CnMOTSSM3SignBytes(Data: TBytes; PrivateKey: TCnMOTSSM3PrivateKey;
  var OutSignature: TCnMOTSSM3Signature);
{* ˽Կֽ M-OTS һӴǩ
   ƽʱġǩֵ빫Կ֤ʱ֤˽Կ

   
     Data: TBytes                                         - ǩֽ
     PrivateKey: TCnMOTSSM3PrivateKey                     - ǩĻ SM3  M-OTS ˽Կ
     var OutSignature: TCnMOTSSM3Signature                - ǩֵ

   ֵޣ
}

function CnMOTSSM3VerifyBytes(Data: TBytes; Signature: TCnMOTSSM3Signature;
  PublicKey: TCnMOTSSM3PublicKey): Boolean;
{* 빫Կֽ֤ M-OTS ǩǷȷ֤Ƿɹ

   
     Data: TBytes                         - ֽ֤
     Signature: TCnMOTSSM3Signature       - ֤ǩֵ
     PublicKey: TCnMOTSSM3PublicKey       - ֤Ļ SM3  M-OTS Կ

   ֵBoolean                        - ֤ǩǷɹ
}

// ========== Merkle Ľ M-OTSУ 0 ĸ SHA256 Ӵ㷨 ============

function CnMOTSSHA256GenerateKeys(var PrivateKey: TCnMOTSSHA256PrivateKey;
  var PublicKey: TCnMOTSSHA256PublicKey): Boolean;
{* һԻ SHA256 Ӵ㷨 M-OTS ǩ˽ԿǷɹ

   
     var PrivateKey: TCnMOTSSHA256PrivateKey              -  SHA256 Ӵ㷨 M-OTS ˽Կ
     var PublicKey: TCnMOTSSHA256PublicKey                -  SHA256 Ӵ㷨 M-OTS Կ

   ֵBoolean                                        - Ƿɹ
}

procedure CnMOTSSHA256SignData(Data: Pointer; DataByteLen: Integer;
  PrivateKey: TCnMOTSSHA256PrivateKey; var OutSignature: TCnMOTSSHA256Signature);
{* ˽Կָݿ M-OTS һӴǩ
   ƽʱġǩֵ빫Կ֤ʱ֤˽Կ

   
     Data: Pointer                                        - ǩݿַ
     DataByteLen: Integer                                 - ǩݿֽڳ
     PrivateKey: TCnMOTSSHA256PrivateKey                  - ǩĻ SHA256 Ӵ㷨 M-OTS ˽Կ
     var OutSignature: TCnMOTSSHA256Signature             - ǩֵ

   ֵޣ
}

function CnMOTSSHA256VerifyData(Data: Pointer; DataByteLen: Integer;
  Signature: TCnMOTSSHA256Signature; PublicKey: TCnMOTSSHA256PublicKey): Boolean;
{* 빫Կָ֤ݿ M-OTS ǩǷȷ֤Ƿɹ

   
     Data: Pointer                        - ֤ݿַ
     DataByteLen: Integer                 - ֤ݿֽڳ
     Signature: TCnMOTSSHA256Signature    - ֤ǩֵ
     PublicKey: TCnMOTSSHA256PublicKey    - ֤Ļ SHA256 Ӵ㷨 M-OTS Կ

   ֵBoolean                        - ֤ǩǷɹ
}

procedure CnMOTSSHA256SignBytes(Data: TBytes; PrivateKey: TCnMOTSSHA256PrivateKey;
  var OutSignature: TCnMOTSSHA256Signature);
{* ˽Կֽ M-OTS һӴǩ
   ƽʱġǩֵ빫Կ֤ʱ֤˽Կ

   
     Data: TBytes                                         - ǩֽ
     PrivateKey: TCnMOTSSHA256PrivateKey                  - ǩĻ SHA256 Ӵ㷨 M-OTS ˽Կ
     var OutSignature: TCnMOTSSHA256Signature             - ǩֵ

   ֵޣ
}

function CnMOTSSHA256VerifyBytes(Data: TBytes; Signature: TCnMOTSSHA256Signature;
  PublicKey: TCnMOTSSHA256PublicKey): Boolean;
{* 빫Կֽ֤ M-OTS ǩǷȷ֤Ƿɹ

   
     Data: TBytes                         - ֽ֤
     Signature: TCnMOTSSHA256Signature    - ֤ǩֵ
     PublicKey: TCnMOTSSHA256PublicKey    - ֤Ļ SHA256 Ӵ㷨 M-OTS Կ

   ֵBoolean                        - ֤ǩǷɹ
}

// ===== Winternitz Ľ W-OTSȡ n = 8 Ҳ 1 ֽڣ SM3 Ӵ㷨 ======

function CnWOTSSM3GenerateKeys(var PrivateKey: TCnWOTSSM3PrivateKey;
  var PublicKey: TCnWOTSSM3PublicKey): Boolean;
{* һԻ SM3 Ӵ㷨 W-OTS һӴǩ˽ԿǷɹ

   
     var PrivateKey: TCnWOTSSM3PrivateKey -  SM3 Ӵ㷨 W-OTS ˽Կ
     var PublicKey: TCnWOTSSM3PublicKey   -  SM3 Ӵ㷨 W-OTS Կ

   ֵBoolean                        - Ƿɹ
}

procedure CnWOTSSM3SignData(Data: Pointer; DataByteLen: Integer;
  PrivateKey: TCnWOTSSM3PrivateKey; var OutSignature: TCnWOTSSM3Signature);
{* ˽Կָݿ W-OTS һӴǩ֤ǩԿ
   ƽʱġǩֵ֤ʱ֤Կ

   
     Data: Pointer                                        - ǩݿַ
     DataByteLen: Integer                                 - ǩݿֽڳ
     PrivateKey: TCnWOTSSM3PrivateKey                     - ǩĻ SM3 Ӵ㷨 W-OTS ˽Կ
     var OutSignature: TCnWOTSSM3Signature                - ǩֵ

   ֵޣ
}

function CnWOTSSM3VerifyData(Data: Pointer; DataByteLen: Integer;
  Signature: TCnWOTSSM3Signature; PublicKey: TCnWOTSSM3PublicKey): Boolean;
{* ġĹԿָ֤ݿ W-OTS ǩǷȷ֤Ƿɹ

   
     Data: Pointer                        - ֤ݿַ
     DataByteLen: Integer                 - ֤ݿֽڳ
     Signature: TCnWOTSSM3Signature       - ֤ǩֵ
     PublicKey: TCnWOTSSM3PublicKey       - ֤Ļ SM3 Ӵ㷨 W-OTS Կ

   ֵBoolean                        - ֤ǩǷɹ
}

procedure CnWOTSSM3SignBytes(Data: TBytes; PrivateKey: TCnWOTSSM3PrivateKey;
  var OutSignature: TCnWOTSSM3Signature);
{* ˽Կֽ W-OTS һӴǩ֤ǩԿ
   ƽʱġǩֵ֤ʱ֤Կ

   
     Data: TBytes                                         - ǩֽ
     PrivateKey: TCnWOTSSM3PrivateKey                     - ǩĻ SM3 Ӵ㷨 W-OTS ˽Կ
     var OutSignature: TCnWOTSSM3Signature                - ǩֵ

   ֵޣ
}

function CnWOTSSM3VerifyBytes(Data: TBytes; Signature: TCnWOTSSM3Signature;
  PublicKey: TCnWOTSSM3PublicKey): Boolean;
{* ġĹԿָ֤ݿ W-OTS ǩǷȷ֤Ƿɹ

   
     Data: TBytes                         - ֽ֤
     Signature: TCnWOTSSM3Signature       - ֤ǩֵ
     PublicKey: TCnWOTSSM3PublicKey       - ֤Ļ SM3 Ӵ㷨 W-OTS Կ

   ֵBoolean                        - ֤ǩǷɹ
}

// ==== Winternitz Ľ W-OTSȡ n = 8 Ҳ 1 ֽڣ SHA256 Ӵ㷨 ====

function CnWOTSSHA256GenerateKeys(var PrivateKey: TCnWOTSSHA256PrivateKey;
  var PublicKey: TCnWOTSSHA256PublicKey): Boolean;
{* һԻ SHA256 Ӵ㷨 W-OTS һӴǩ˽ԿǷɹ

   
     var PrivateKey: TCnWOTSSHA256PrivateKey              -  SHA256 Ӵ㷨 W-OTS ˽Կ
     var PublicKey: TCnWOTSSHA256PublicKey                -  SHA256 Ӵ㷨 W-OTS Կ

   ֵBoolean                                        - Ƿɹ
}

procedure CnWOTSSHA256SignData(Data: Pointer; DataByteLen: Integer;
  PrivateKey: TCnWOTSSHA256PrivateKey; var OutSignature: TCnWOTSSHA256Signature);
{* ˽Կָݿ W-OTS һӴǩ֤ǩԿ
   ƽʱġǩֵ֤ʱ֤Կ

   
     Data: Pointer                                        - ǩݿַ
     DataByteLen: Integer                                 - ǩݿֽڳ
     PrivateKey: TCnWOTSSHA256PrivateKey                  - ǩĻ SHA256 Ӵ㷨 W-OTS ˽Կ
     var OutSignature: TCnWOTSSHA256Signature             - ǩֵ

   ֵޣ
}

function CnWOTSSHA256VerifyData(Data: Pointer; DataByteLen: Integer;
  Signature: TCnWOTSSHA256Signature; PublicKey: TCnWOTSSHA256PublicKey): Boolean;
{* ġĹԿָ֤ݿ W-OTS ǩǷȷ֤Ƿɹ

   
     Data: Pointer                        - ֤ݿַ
     DataByteLen: Integer                 - ֤ݿֽڳ
     Signature: TCnWOTSSHA256Signature    - ֤Ļ SHA256 Ӵ㷨 W-OTS Կ
     PublicKey: TCnWOTSSHA256PublicKey    - ֤ǩֵ

   ֵBoolean                        - ֤ǩǷɹ
}

procedure CnWOTSSHA256SignBytes(Data: TBytes; PrivateKey: TCnWOTSSHA256PrivateKey;
  var OutSignature: TCnWOTSSHA256Signature);
{* ˽Կֽ W-OTS һӴǩ֤ǩԿ
   ƽʱġǩֵ֤ʱ֤Կ

   
     Data: TBytes                                         - ǩֽ
     PrivateKey: TCnWOTSSHA256PrivateKey                  - ǩĻ SHA256 Ӵ㷨 W-OTS ˽Կ
     var OutSignature: TCnWOTSSHA256Signature             - ǩֵ

   ֵޣ
}

function CnWOTSSHA256VerifyBytes(Data: TBytes; Signature: TCnWOTSSHA256Signature;
  PublicKey: TCnWOTSSHA256PublicKey): Boolean;
{* ġĹԿָ֤ݿ W-OTS ǩǷȷ֤Ƿɹ

   
     Data: TBytes                         - ֽ֤
     Signature: TCnWOTSSHA256Signature    - ֤ǩֵ
     PublicKey: TCnWOTSSHA256PublicKey    - ֤Ļ SHA256 Ӵ㷨 W-OTS Կ

   ֵBoolean                        - ֤ǩǷɹ
}

implementation

const
  CN_WOTS_ROUND = 256;

function CnOTSSM3GenerateKeys(var PrivateKey: TCnOTSSM3PrivateKey;
  var PublicKey: TCnOTSSM3PublicKey): Boolean;
var
  I: Integer;
begin
  Result := CnRandomFillBytes(@PrivateKey[0], SizeOf(TCnOTSSM3PrivateKey));
  if Result then
    for I := Low(TCnOTSSM3PublicKey) to High(TCnOTSSM3PublicKey) do
      PublicKey[I] := SM3(@PrivateKey[I], SizeOf(TCnSM3Digest));
end;

procedure CnOTSSM3SignData(Data: Pointer; DataByteLen: Integer;
  PrivateKey: TCnOTSSM3PrivateKey; PublicKey: TCnOTSSM3PublicKey;
  var OutSignature: TCnOTSSM3Signature; var OutVerifyKey: TCnOTSSM3VerificationKey);
var
  I: Integer;
  Bits: TCnBitBuilder;
  Dig: TCnSM3Digest;
begin
  Dig := SM3(PAnsiChar(Data), DataByteLen);
  Bits := TCnBitBuilder.Create;
  try
    Bits.AppendData(@Dig[0], SizeOf(TCnSM3Digest));

    for I := 0 to Bits.BitLength - 1 do
    begin
      if Bits.Bit[I] then //  1
      begin
        OutSignature[I] := PublicKey[I * 2 + 1];
        OutVerifyKey[I] := PrivateKey[I * 2 + 1];
      end
      else
      begin
        OutSignature[I] := PublicKey[I * 2];
        OutVerifyKey[I] := PrivateKey[I * 2];
      end;
    end;
  finally
    Bits.Free;
  end;
end;

function CnOTSSM3VerifyData(Data: Pointer; DataByteLen: Integer;
  Signature: TCnOTSSM3Signature; PublicKey: TCnOTSSM3PublicKey;
  VerifyKey: TCnOTSSM3VerificationKey): Boolean;
var
  I: Integer;
  Bits: TCnBitBuilder;
  Dig, Cmp: TCnSM3Digest;
begin
  Result := False;
  Dig := SM3(PAnsiChar(Data), DataByteLen);
  Bits := TCnBitBuilder.Create;
  try
    Bits.AppendData(@Dig[0], SizeOf(TCnSM3Digest));

    for I := 0 to Bits.BitLength - 1 do
    begin
      Cmp := SM3(@VerifyKey[I], SizeOf(TCnSM3Digest)); // ˽ԿӴֵ
      if Bits.Bit[I] then 
        Result := SM3Match(Cmp, PublicKey[I * 2 + 1])  // λ 1Ƚ 1 ӦĹԿ
      else
        Result := SM3Match(Cmp, PublicKey[I * 2]);     // λ 0Ƚ 0 ӦĹԿ

      if not Result then
        Exit;
    end;
  finally
    Bits.Free;
  end;
end;

procedure CnOTSSM3SignBytes(Data: TBytes; PrivateKey: TCnOTSSM3PrivateKey;
  PublicKey: TCnOTSSM3PublicKey; var OutSignature: TCnOTSSM3Signature;
  var OutVerifyKey: TCnOTSSM3VerificationKey);
begin
  if Length(Data) = 0 then
    CnOTSSM3SignData(nil, 0, PrivateKey, PublicKey, OutSignature, OutVerifyKey)
  else
    CnOTSSM3SignData(@Data[0], Length(Data), PrivateKey, PublicKey, OutSignature, OutVerifyKey);
end;

function CnOTSSM3VerifyBytes(Data: TBytes; Signature: TCnOTSSM3Signature;
  PublicKey: TCnOTSSM3PublicKey; VerifyKey: TCnOTSSM3VerificationKey): Boolean;
begin
  if Length(Data) = 0 then
    Result := CnOTSSM3VerifyData(nil, 0, Signature, PublicKey, VerifyKey)
  else
    Result := CnOTSSM3VerifyData(@Data[0], Length(Data), Signature, PublicKey, VerifyKey);
end;

function CnOTSSHA256GenerateKeys(var PrivateKey: TCnOTSSHA256PrivateKey;
  var PublicKey: TCnOTSSHA256PublicKey): Boolean;
var
  I: Integer;
  P: Pointer;
begin
  Result := CnRandomFillBytes(@PrivateKey[0], SizeOf(TCnOTSSHA256PrivateKey));
  if Result then
  begin
    for I := Low(TCnOTSSHA256PublicKey) to High(TCnOTSSHA256PublicKey) do
    begin
      P := @PrivateKey[I];
      PublicKey[I] := SHA256Buffer(P, SizeOf(TCnSHA256Digest));
    end;
  end;
end;

procedure CnOTSSHA256SignData(Data: Pointer; DataByteLen: Integer;
  PrivateKey: TCnOTSSHA256PrivateKey; PublicKey: TCnOTSSHA256PublicKey;
  var OutSignature: TCnOTSSHA256Signature; var OutVerifyKey: TCnOTSSHA256VerificationKey);
var
  I: Integer;
  Bits: TCnBitBuilder;
  Dig: TCnSHA256Digest;
begin
  Dig := SHA256Buffer(PAnsiChar(Data), DataByteLen);
  Bits := TCnBitBuilder.Create;
  try
    Bits.AppendData(@Dig[0], SizeOf(TCnSHA256Digest));

    for I := 0 to Bits.BitLength - 1 do
    begin
      if Bits.Bit[I] then //  1
      begin
        OutSignature[I] := PublicKey[I * 2 + 1];
        OutVerifyKey[I] := PrivateKey[I * 2 + 1];
      end
      else
      begin
        OutSignature[I] := PublicKey[I * 2];
        OutVerifyKey[I] := PrivateKey[I * 2];
      end;
    end;
  finally
    Bits.Free;
  end;
end;

function CnOTSSHA256VerifyData(Data: Pointer; DataByteLen: Integer;
  Signature: TCnOTSSHA256Signature; PublicKey: TCnOTSSHA256PublicKey;
  VerifyKey: TCnOTSSHA256VerificationKey): Boolean;
var
  I: Integer;
  Bits: TCnBitBuilder;
  Dig, Cmp: TCnSHA256Digest;
  P: Pointer;
begin
  Result := False;
  Dig := SHA256Buffer(PAnsiChar(Data), DataByteLen);
  Bits := TCnBitBuilder.Create;
  try
    Bits.AppendData(@Dig[0], SizeOf(TCnSHA256Digest));

    for I := 0 to Bits.BitLength - 1 do
    begin
      P := @VerifyKey[I];
      Cmp := SHA256Buffer(P, SizeOf(TCnSHA256Digest));    // ˽ԿӴֵ
      if Bits.Bit[I] then 
        Result := SHA256Match(Cmp, PublicKey[I * 2 + 1])  // λ 1Ƚ 1 ӦĹԿ
      else
        Result := SHA256Match(Cmp, PublicKey[I * 2]);     // λ 0Ƚ 0 ӦĹԿ

      if not Result then
        Exit;
    end;
  finally
    Bits.Free;
  end;
end;

procedure CnOTSSHA256SignBytes(Data: TBytes; PrivateKey: TCnOTSSHA256PrivateKey;
  PublicKey: TCnOTSSHA256PublicKey; var OutSignature: TCnOTSSHA256Signature;
  var OutVerifyKey: TCnOTSSHA256VerificationKey);
begin
  if Length(Data) = 0 then
    CnOTSSHA256SignData(nil, 0, PrivateKey, PublicKey, OutSignature, OutVerifyKey)
  else
    CnOTSSHA256SignData(@Data[0], Length(Data), PrivateKey, PublicKey, OutSignature, OutVerifyKey);
end;

function CnOTSSHA256VerifyBytes(Data: TBytes; Signature: TCnOTSSHA256Signature;
  PublicKey: TCnOTSSHA256PublicKey; VerifyKey: TCnOTSSHA256VerificationKey): Boolean;
begin
  if Length(Data) = 0 then
    Result := CnOTSSHA256VerifyData(nil, 0, Signature, PublicKey, VerifyKey)
  else
    Result := CnOTSSHA256VerifyData(@Data[0], Length(Data), Signature, PublicKey, VerifyKey);
end;

function CnMOTSSM3GenerateKeys(var PrivateKey: TCnMOTSSM3PrivateKey;
  var PublicKey: TCnMOTSSM3PublicKey): Boolean;
var
  I: Integer;
begin
  Result := CnRandomFillBytes(@PrivateKey[0], SizeOf(TCnMOTSSM3PrivateKey));
  if Result then
    for I := Low(TCnMOTSSM3PublicKey) to High(TCnMOTSSM3PublicKey) do
      PublicKey[I] := SM3(@PrivateKey[I], SizeOf(TCnSM3Digest));
end;

procedure CnMOTSSM3SignData(Data: Pointer; DataByteLen: Integer;
  PrivateKey: TCnMOTSSM3PrivateKey; var OutSignature: TCnMOTSSM3Signature);
var
  I: Integer;
  Bits: TCnBitBuilder;
  Dig: TCnSM3Digest;
  Cnt: Byte;
begin
  FillChar(OutSignature[0], SizeOf(TCnMOTSSM3Signature), 0);
  Dig := SM3(PAnsiChar(Data), DataByteLen);

  Bits := TCnBitBuilder.Create;
  try
    Bits.AppendData(@Dig[0], SizeOf(TCnSM3Digest));

    Cnt := 0;
    for I := 0 to Bits.BitLength - 1 do
    begin
      if Bits.Bit[I] then // ӴֵĶӦλ 1ǩ˽Կ
        OutSignature[I] := PrivateKey[I]
      else
        Inc(Cnt);         // Ӵղȫ 0 Բ
    end;

    Bits.Clear;
    Bits.AppendByte(Cnt);
    for I := 0 to Bits.BitLength - 1 do
    begin
      if Bits.Bit[I] then // У͵ĶӦλ 1ǩ˽Կ
        OutSignature[(SizeOf(TCnSM3Digest) * 8) + I] := PrivateKey[(SizeOf(TCnSM3Digest) * 8) + I];
    end;
  finally
    Bits.Free;
  end;
end;

function CnMOTSSM3VerifyData(Data: Pointer; DataByteLen: Integer;
  Signature: TCnMOTSSM3Signature; PublicKey: TCnMOTSSM3PublicKey): Boolean;
var
  I: Integer;
  Bits: TCnBitBuilder;
  Dig, Zero, Cmp: TCnSM3Digest;
  Cnt: Byte;
begin
  Result := False;
  FillChar(Zero[0], SizeOf(TCnSM3Digest), 0);
  Dig := SM3(PAnsiChar(Data), DataByteLen);

  Bits := TCnBitBuilder.Create;
  try
    Bits.AppendData(@Dig[0], SizeOf(TCnSM3Digest));

    Cnt := 0;
    for I := 0 to Bits.BitLength - 1 do
    begin
      if Bits.Bit[I] then // ӴֵĶӦλ 1ǩ˽ԿӴ֤
      begin
        Cmp := SM3(@Signature[I], SizeOf(TCnSM3Digest)); // ˽ԿӴֵ
        if not SM3Match(Cmp, PublicKey[I]) then
          Exit;
      end
      else
      begin
        if not SM3Match(Signature[I], Zero) then         // Ӧλ 0 ñ֤ȫ 0
          Exit;
        Inc(Cnt);         // Ӵղȫ 0 Բ
      end;
    end;

    Bits.Clear;
    Bits.AppendByte(Cnt);
    for I := 0 to Bits.BitLength - 1 do
    begin
      if Bits.Bit[I] then // У͵ĶӦλ 1ǩ˽ԿӴ֤
      begin
        Cmp := SM3(@Signature[(SizeOf(TCnSM3Digest) * 8) + I], SizeOf(TCnSM3Digest));
        if not SM3Match(Cmp, PublicKey[(SizeOf(TCnSM3Digest) * 8) + I]) then
          Exit;
      end
      else
      begin
        if not SM3Match(Signature[(SizeOf(TCnSM3Digest) * 8) + I], Zero) then         // Ӧλ 0 ñ֤ȫ 0
          Exit;
      end;
    end;
    Result := True;
  finally
    Bits.Free;
  end;
end;

procedure CnMOTSSM3SignBytes(Data: TBytes; PrivateKey: TCnMOTSSM3PrivateKey;
  var OutSignature: TCnMOTSSM3Signature);
begin
  if Length(Data) = 0 then
    CnMOTSSM3SignData(nil, 0, PrivateKey, OutSignature)
  else
    CnMOTSSM3SignData(@Data[0], Length(Data), PrivateKey, OutSignature);
end;

function CnMOTSSM3VerifyBytes(Data: TBytes; Signature: TCnMOTSSM3Signature;
  PublicKey: TCnMOTSSM3PublicKey): Boolean;
begin
  if Length(Data) = 0 then
    Result := CnMOTSSM3VerifyData(nil, 0, Signature, PublicKey)
  else
    Result := CnMOTSSM3VerifyData(@Data[0], Length(Data), Signature, PublicKey);
end;

function CnMOTSSHA256GenerateKeys(var PrivateKey: TCnMOTSSHA256PrivateKey;
  var PublicKey: TCnMOTSSHA256PublicKey): Boolean;
var
  I: Integer;
  P: Pointer;
begin
  Result := CnRandomFillBytes(@PrivateKey[0], SizeOf(TCnMOTSSHA256PrivateKey));
  if Result then
  begin
    for I := Low(TCnMOTSSHA256PublicKey) to High(TCnMOTSSHA256PublicKey) do
    begin
      P := @PrivateKey[I];
      PublicKey[I] := SHA256Buffer(P, SizeOf(TCnSHA256Digest));
    end;
  end;
end;

procedure CnMOTSSHA256SignData(Data: Pointer; DataByteLen: Integer;
  PrivateKey: TCnMOTSSHA256PrivateKey; var OutSignature: TCnMOTSSHA256Signature);
var
  I: Integer;
  Bits: TCnBitBuilder;
  Dig: TCnSHA256Digest;
  Cnt: Byte;
begin
  FillChar(OutSignature[0], SizeOf(TCnMOTSSHA256Signature), 0);
  Dig := SHA256Buffer(PAnsiChar(Data), DataByteLen);

  Bits := TCnBitBuilder.Create;
  try
    Bits.AppendData(@Dig[0], SizeOf(TCnSHA256Digest));

    Cnt := 0;
    for I := 0 to Bits.BitLength - 1 do
    begin
      if Bits.Bit[I] then // ӴֵĶӦλ 1ǩ˽Կ
        OutSignature[I] := PrivateKey[I]
      else
        Inc(Cnt);         // Ӵղȫ 0 Բ
    end;

    Bits.Clear;
    Bits.AppendByte(Cnt);
    for I := 0 to Bits.BitLength - 1 do
    begin
      if Bits.Bit[I] then // У͵ĶӦλ 1ǩ˽Կ
        OutSignature[(SizeOf(TCnSHA256Digest) * 8) + I] := PrivateKey[(SizeOf(TCnSHA256Digest) * 8) + I];
    end;
  finally
    Bits.Free;
  end;
end;

function CnMOTSSHA256VerifyData(Data: Pointer; DataByteLen: Integer;
  Signature: TCnMOTSSHA256Signature; PublicKey: TCnMOTSSHA256PublicKey): Boolean;
var
  I: Integer;
  Bits: TCnBitBuilder;
  Dig, Zero, Cmp: TCnSHA256Digest;
  Cnt: Byte;
  P: Pointer;
begin
  Result := False;
  FillChar(Zero[0], SizeOf(TCnSHA256Digest), 0);
  Dig := SHA256Buffer(PAnsiChar(Data), DataByteLen);

  Bits := TCnBitBuilder.Create;
  try
    Bits.AppendData(@Dig[0], SizeOf(TCnSHA256Digest));

    Cnt := 0;
    for I := 0 to Bits.BitLength - 1 do
    begin
      if Bits.Bit[I] then // ӴֵĶӦλ 1ǩ˽ԿӴ֤
      begin
        P := @Signature[I];
        Cmp := SHA256Buffer(P, SizeOf(TCnSHA256Digest)); // ˽ԿӴֵ
        if not SHA256Match(Cmp, PublicKey[I]) then
          Exit;
      end
      else
      begin
        if not SHA256Match(Signature[I], Zero) then         // Ӧλ 0 ñ֤ȫ 0
          Exit;
        Inc(Cnt);         // Ӵղȫ 0 Բ
      end;
    end;

    Bits.Clear;
    Bits.AppendByte(Cnt);
    for I := 0 to Bits.BitLength - 1 do
    begin
      if Bits.Bit[I] then // У͵ĶӦλ 1ǩ˽ԿӴ֤
      begin
        P := @Signature[(SizeOf(TCnSHA256Digest) * 8) + I];
        Cmp := SHA256Buffer(P, SizeOf(TCnSHA256Digest));
        if not SHA256Match(Cmp, PublicKey[(SizeOf(TCnSHA256Digest) * 8) + I]) then
          Exit;
      end
      else
      begin
        if not SHA256Match(Signature[(SizeOf(TCnSHA256Digest) * 8) + I], Zero) then         // Ӧλ 0 ñ֤ȫ 0
          Exit;
      end;
    end;
    Result := True;
  finally
    Bits.Free;
  end;
end;

procedure CnMOTSSHA256SignBytes(Data: TBytes; PrivateKey: TCnMOTSSHA256PrivateKey;
  var OutSignature: TCnMOTSSHA256Signature);
begin
  if Length(Data) = 0 then
    CnMOTSSHA256SignData(nil, 0, PrivateKey, OutSignature)
  else
    CnMOTSSHA256SignData(@Data[0], Length(Data), PrivateKey, OutSignature);
end;

function CnMOTSSHA256VerifyBytes(Data: TBytes; Signature: TCnMOTSSHA256Signature;
  PublicKey: TCnMOTSSHA256PublicKey): Boolean;
begin
  if Length(Data) = 0 then
    Result := CnMOTSSHA256VerifyData(nil, 0, Signature, PublicKey)
  else
    Result := CnMOTSSHA256VerifyData(@Data[0], Length(Data), Signature, PublicKey);
end;

function CnWOTSSM3GenerateKeys(var PrivateKey: TCnWOTSSM3PrivateKey;
  var PublicKey: TCnWOTSSM3PublicKey): Boolean;
var
  I, J: Integer;
  Dig: TCnSM3Digest;
begin
  Result := CnRandomFillBytes(@PrivateKey[0], SizeOf(TCnWOTSSM3PrivateKey));
  if Result then
  begin
    for I := Low(TCnWOTSSM3PublicKey) to High(TCnWOTSSM3PublicKey) do
    begin
      Dig := PrivateKey[I];
      for J := 0 to CN_WOTS_ROUND - 1 do
        Dig := SM3(@Dig[0], SizeOf(TCnSM3Digest));

      PublicKey[I] := Dig;
    end;
  end;
end;

procedure CnWOTSSM3SignData(Data: Pointer; DataByteLen: Integer;
  PrivateKey: TCnWOTSSM3PrivateKey; var OutSignature: TCnWOTSSM3Signature);
var
  I, J: Integer;
  Dig, D: TCnSM3Digest;
  P: PByte;
  Sum, B: Word;
begin
  Dig := SM3(PAnsiChar(Data), DataByteLen);
  Sum := 0;

  for I := 0 to SizeOf(TCnSM3Digest) - 1 do
  begin
    D := PrivateKey[I];
    B := CN_WOTS_ROUND - Dig[I];             //  Byte Ҫ Word

    for J := 0 to B - 1 do
      D := SM3(@D[0], SizeOf(TCnSM3Digest)); // ֽ˽Կ 256 - ÿֽڵӴմ

    OutSignature[I] := D;
    Sum := Sum + Dig[I];
  end;

  // λУҲͬ
  Sum := UInt16HostToNetwork(Sum);
  P := PByte(@Sum);

  D := PrivateKey[High(TCnSM3Digest) + 1];
  B := CN_WOTS_ROUND - P^;
  for J := 0 to B - 1 do
    D := SM3(@D[0], SizeOf(TCnSM3Digest));
  OutSignature[High(TCnSM3Digest) + 1] := D;

  Inc(P);
  D := PrivateKey[High(TCnSM3Digest) + 2];
  B := CN_WOTS_ROUND - P^;
  for J := 0 to B - 1 do
    D := SM3(@D[0], SizeOf(TCnSM3Digest));
  OutSignature[High(TCnSM3Digest) + 2] := D;
end;

function CnWOTSSM3VerifyData(Data: Pointer; DataByteLen: Integer;
  Signature: TCnWOTSSM3Signature; PublicKey: TCnWOTSSM3PublicKey): Boolean;
var
  I, J: Integer;
  Dig, D: TCnSM3Digest;
  P: PByte;
  Sum, B: Word;
begin
  Result := False;

  Dig := SM3(PAnsiChar(Data), DataByteLen);
  Sum := 0;

  for I := 0 to SizeOf(TCnSM3Digest) - 1 do
  begin
    D := Signature[I];
    B := Dig[I];                             //  Byte Ҫ Word

    for J := 0 to B - 1 do
      D := SM3(@D[0], SizeOf(TCnSM3Digest)); // ֽ˽ԿÿֽڵӴմ

    if not SM3Match(D, PublicKey[I]) then
      Exit;

    Sum := Sum + Dig[I];
  end;

  // λУҲͬ
  Sum := UInt16HostToNetwork(Sum);
  P := PByte(@Sum);

  D := Signature[High(TCnSM3Digest) + 1];
  B := P^;
  for J := 0 to B - 1 do
    D := SM3(@D[0], SizeOf(TCnSM3Digest));

  if not SM3Match(D, PublicKey[High(TCnSM3Digest) + 1]) then
    Exit;

  Inc(P);
  D := Signature[High(TCnSM3Digest) + 2];
  B := P^;
  for J := 0 to B - 1 do
    D := SM3(@D[0], SizeOf(TCnSM3Digest));

  if not SM3Match(D, PublicKey[High(TCnSM3Digest) + 2]) then
    Exit;

  Result := True;
end;

procedure CnWOTSSM3SignBytes(Data: TBytes; PrivateKey: TCnWOTSSM3PrivateKey;
  var OutSignature: TCnWOTSSM3Signature);
begin
  if Length(Data) = 0 then
    CnWOTSSM3SignData(nil, 0, PrivateKey, OutSignature)
  else
    CnWOTSSM3SignData(@Data[0], Length(Data), PrivateKey, OutSignature);
end;

function CnWOTSSM3VerifyBytes(Data: TBytes; Signature: TCnWOTSSM3Signature;
  PublicKey: TCnWOTSSM3PublicKey): Boolean;
begin
  if Length(Data) = 0 then
    Result := CnWOTSSM3VerifyData(nil, 0, Signature, PublicKey)
  else
    Result := CnWOTSSM3VerifyData(@Data[0], Length(Data), Signature, PublicKey);
end;

function CnWOTSSHA256GenerateKeys(var PrivateKey: TCnWOTSSHA256PrivateKey;
  var PublicKey: TCnWOTSSHA256PublicKey): Boolean;
var
  I, J: Integer;
  Dig: TCnSHA256Digest;
  P: Pointer;
begin
  Result := CnRandomFillBytes(@PrivateKey[0], SizeOf(TCnWOTSSHA256PrivateKey));
  if Result then
  begin
    for I := Low(TCnWOTSSHA256PublicKey) to High(TCnWOTSSHA256PublicKey) do
    begin
      Dig := PrivateKey[I];
      for J := 0 to CN_WOTS_ROUND - 1 do
      begin
        P := @Dig[0];
        Dig := SHA256Buffer(P, SizeOf(TCnSHA256Digest));
      end;

      PublicKey[I] := Dig;
    end;
  end;
end;

procedure CnWOTSSHA256SignData(Data: Pointer; DataByteLen: Integer;
  PrivateKey: TCnWOTSSHA256PrivateKey; var OutSignature: TCnWOTSSHA256Signature);
var
  I, J: Integer;
  Dig, D: TCnSHA256Digest;
  P: PByte;
  Sum, B: Word;
  PB: Pointer;
begin
  Dig := SHA256Buffer(PAnsiChar(Data), DataByteLen);
  Sum := 0;

  for I := 0 to SizeOf(TCnSHA256Digest) - 1 do
  begin
    D := PrivateKey[I];
    B := CN_WOTS_ROUND - Dig[I];             //  Byte Ҫ Word

    for J := 0 to B - 1 do
    begin
      PB := @D[0];
      D := SHA256Buffer(PB, SizeOf(TCnSHA256Digest)); // ֽ˽Կ 256 - ÿֽڵӴմ
    end;

    OutSignature[I] := D;
    Sum := Sum + Dig[I];
  end;

  // λУҲͬ
  Sum := UInt16HostToNetwork(Sum);
  P := PByte(@Sum);

  D := PrivateKey[High(TCnSHA256Digest) + 1];
  B := CN_WOTS_ROUND - P^;
  for J := 0 to B - 1 do
  begin
    PB := @D[0];
    D := SHA256Buffer(PB, SizeOf(TCnSHA256Digest));
  end;
  OutSignature[High(TCnSHA256Digest) + 1] := D;

  Inc(P);
  D := PrivateKey[High(TCnSHA256Digest) + 2];
  B := CN_WOTS_ROUND - P^;
  for J := 0 to B - 1 do
  begin
    PB := @D[0];
    D := SHA256Buffer(PB, SizeOf(TCnSHA256Digest));
  end;
  OutSignature[High(TCnSHA256Digest) + 2] := D;
end;

function CnWOTSSHA256VerifyData(Data: Pointer; DataByteLen: Integer;
  Signature: TCnWOTSSHA256Signature; PublicKey: TCnWOTSSHA256PublicKey): Boolean;
var
  I, J: Integer;
  Dig, D: TCnSHA256Digest;
  P: PByte;
  Sum, B: Word;
  PB: Pointer;
begin
  Result := False;

  Dig := SHA256Buffer(PAnsiChar(Data), DataByteLen);
  Sum := 0;

  for I := 0 to SizeOf(TCnSHA256Digest) - 1 do
  begin
    D := Signature[I];
    B := Dig[I];                             //  Byte Ҫ Word

    for J := 0 to B - 1 do
    begin
      PB := @D[0];
      D := SHA256Buffer(PB, SizeOf(TCnSHA256Digest)); // ֽ˽ԿÿֽڵӴմ
    end;

    if not SHA256Match(D, PublicKey[I]) then
      Exit;

    Sum := Sum + Dig[I];
  end;

  // λУҲͬ
  Sum := UInt16HostToNetwork(Sum);
  P := PByte(@Sum);

  D := Signature[High(TCnSHA256Digest) + 1];
  B := P^;
  for J := 0 to B - 1 do
  begin
    PB := @D[0];
    D := SHA256Buffer(PB, SizeOf(TCnSHA256Digest));
  end;

  if not SHA256Match(D, PublicKey[High(TCnSHA256Digest) + 1]) then
    Exit;

  Inc(P);
  D := Signature[High(TCnSHA256Digest) + 2];
  B := P^;
  for J := 0 to B - 1 do
  begin
    PB := @D[0];
    D := SHA256Buffer(PB, SizeOf(TCnSHA256Digest));
  end;

  if not SHA256Match(D, PublicKey[High(TCnSHA256Digest) + 2]) then
    Exit;

  Result := True;
end;

procedure CnWOTSSHA256SignBytes(Data: TBytes; PrivateKey: TCnWOTSSHA256PrivateKey;
  var OutSignature: TCnWOTSSHA256Signature);
begin
  if Length(Data) = 0 then
    CnWOTSSHA256SignData(nil, 0, PrivateKey, OutSignature)
  else
    CnWOTSSHA256SignData(@Data[0], Length(Data), PrivateKey, OutSignature);
end;

function CnWOTSSHA256VerifyBytes(Data: TBytes; Signature: TCnWOTSSHA256Signature;
  PublicKey: TCnWOTSSHA256PublicKey): Boolean;
begin
  if Length(Data) = 0 then
    Result := CnWOTSSHA256VerifyData(nil, 0, Signature, PublicKey)
  else
    Result := CnWOTSSHA256VerifyData(@Data[0], Length(Data), Signature, PublicKey);
end;

end.
