{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnNative;
{* |<PRE>
================================================================================
* ƣCnPack 
* Ԫƣ32 λ 64 λƽ̨һЩͳһԼһʵֵԪ
* ԪߣCnPack  (master@cnpack.org)
*     עԪһ 32 λ 64 λƽ̨һЩͳһʵ֡
*           Delphi XE 2 ֧ 32  64 ų NativeInt  NativeUInt 
*           ǰ 32 λ 64 ̬仯Ӱ쵽 PointerReferenceȶ
*           ǵԣ̶ȵ 32 λ Cardinal/Integer Ⱥ Pointer Щ
*           ͨˣʹ 32 λҲֹ˱Ԫ˼ͣ
*           ͬʱڵͰ汾͸߰汾 Delphi ʹá
*
*           ԪҲڲ֧ UInt64 ı Delphi 5/6/7  Int64 ģ UInt64
*           ĸ㣬ӼȻ֧֣˳Ҫģ div  mod
*           ַ Integer(APtr)  64 λ MacOS ׳ֽضϣҪ NativeInt
*
*           ʵ˴Сءֽת̶ʱȷĴײ㺯빤ࡣ
*
* ƽ̨PWin2000 + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 XE 2
*   õԪеַϱػʽ
* ޸ļ¼2023.08.14 V2.4
*               ϼʱ̶ĺ
*           2022.11.11 V2.3
*               ϼ޷ֽ˳
*           2022.07.23 V2.2
*               Ӽڴλ㺯תַΪ CnNative
*           2022.06.08 V2.1
*               ĸʱ̶ĽԼڴ浹ź
*           2022.03.14 V2.0
*               Ӽʮת
*           2022.02.17 V1.9
*                FPC ı֧
*           2022.02.09 V1.8
*               ڵĴСжϺ
*           2021.09.05 V1.7
*                Int64/UInt64 㺯
*           2020.10.28 V1.6
*                UInt64 صж㺯
*           2020.09.06 V1.5
*                UInt64 ƽĺ
*           2020.07.01 V1.5
*               ж 32 λ 64 λ޷Ƿĺ
*           2020.06.20 V1.4
*                32 λ 64 λȡ͵ 1 λλõĺ
*           2020.01.01 V1.3
*                32 λ޷͵ mul 㣬ڲ֧ UInt64 ϵͳ Int64 Ա
*           2018.06.05 V1.2
*                64 λ͵ div/mod 㣬ڲ֧ UInt64 ϵͳ Int64  
*           2016.09.27 V1.1
*                64 λ͵һЩ
*           2011.07.06 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Classes, SysUtils, SysConst, Math {$IFDEF COMPILER5}, Windows {$ENDIF};
                                    // D5 Ҫ Windows е PByte
type
  ECnNativeException = class(Exception);
  {* Native 쳣}

{$IFDEF COMPILER5}
  PCardinal = ^Cardinal;
  {* D5  System Ԫδ壬}
  PByte = Windows.PByte;
  {* D5  PByte  Windows У汾 System У
    ͳһһ¹ʹ PByte ʱ uses Windowsڿƽ̨}
{$ENDIF}

{$IFDEF BCB5OR6}
  PInt64 = ^Int64;
  {* C++Builder 5/6  sysmac.h û PInt64 Ķ壨е PUINT64 Сдͬ㣩}
{$ENDIF}

{$IFDEF SUPPORT_32_AND_64}
  TCnNativeInt     = NativeInt;
  TCnNativeUInt    = NativeUInt;
  TCnNativePointer = NativeInt;
  TCnNativeIntPtr  = PNativeInt;
  TCnNativeUIntPtr = PNativeUInt;
{$ELSE}
  TCnNativeInt     = Integer;
  TCnNativeUInt    = Cardinal;
  TCnNativePointer = Integer;
  TCnNativeIntPtr  = PInteger;
  TCnNativeUIntPtr = PCardinal;
{$ENDIF}

{$IFDEF CPU64BITS}
  TCnUInt64        = NativeUInt;
  TCnInt64         = NativeInt;
{$ELSE}
  {$IFDEF SUPPORT_UINT64}
  TCnUInt64        = UInt64;
  {$ELSE}
  TCnUInt64 = packed record  // ֻĽṹ
    case Boolean of
      True:  (Value: Int64);
      False: (Lo32, Hi32: Cardinal);
  end;
  {$ENDIF}
  TCnInt64         = Int64;
{$ENDIF}

// TUInt64  cnvcl в֧ UInt64  div mod 
{$IFDEF SUPPORT_UINT64}
  TUInt64          = UInt64;
  {$IFNDEF SUPPORT_PUINT64}
  PUInt64          = ^UInt64;
  {$ENDIF}
{$ELSE}
  TUInt64          = Int64;
  PUInt64          = ^TUInt64;
{$ENDIF}

{$IFNDEF SUPPORT_INT64ARRAY}
  // ϵͳûж Int64Array
  Int64Array  = array[0..$0FFFFFFE] of Int64;
  PInt64Array = ^Int64Array;
{$ENDIF}

  TUInt64Array = array of TUInt64; // ̬ƺ׺;̬гͻ

  ExtendedArray = array[0..65537] of Extended;
  PExtendedArray = ^ExtendedArray;

  PCnWord16Array = ^TCnWord16Array;
  TCnWord16Array = array [0..0] of Word;

{$IFDEF POSIX64}
  TCnLongWord32 = Cardinal; // Linux64/MacOS64 (or POSIX64?) LongWord is 64 Bits
{$ELSE}
  TCnLongWord32 = LongWord;
{$ENDIF}
  PCnLongWord32 = ^TCnLongWord32;

  TCnLongWord32Array = array [0..MaxInt div SizeOf(Integer) - 1] of TCnLongWord32;

  PCnLongWord32Array = ^TCnLongWord32Array;

{$IFNDEF TBYTES_DEFINED}
  TBytes = array of Byte;
  {* ޷ֽڶ̬飬δʱ}
{$ENDIF}

  TShortInts = array of ShortInt;
  {* зֽڶ̬}

  TSmallInts = array of SmallInt;
  {* з˫ֽڶ̬}

  TWords = array of Word;
  {* ޷˫ֽڶ̬}

  TIntegers = array of Integer;
  {* зֽڶ̬}

  TCardinals = array of Cardinal;
  {* ޷ֽڶ̬}

  PCnByte = ^Byte;
  PCnWord = ^Word;

  TCnBitOperation = (boAnd, boOr, boXor, boNot);
  {* λ}

type
  TCnMemSortCompareProc = function (P1, P2: Pointer; ElementByteSize: Integer): Integer;
  {* ڴ̶ߴȽϺԭ}

const
  CN_MAX_SQRT_INT64: Cardinal               = 3037000499;
  CN_MAX_INT64: Int64                       = $7FFFFFFFFFFFFFFF;
  CN_MIN_INT64: Int64                       = $8000000000000000;
  CN_MAX_UINT16: Word                       = $FFFF;
  CN_MAX_UINT32: Cardinal                   = $FFFFFFFF;
  CN_MAX_TUINT64: TUInt64                   = $FFFFFFFFFFFFFFFF;
  CN_MAX_SIGNED_INT64_IN_TUINT64: TUInt64   = $7FFFFFFFFFFFFFFF;

{*
   D567 Ȳ֧ UInt64 ıȻ Int64  UInt64 мӼ洢
  ˳޷ֱɣװ System е _lludiv  _llumod
  ʵ Int64 ʾ UInt64 ݵ div  mod ܡ
}
function UInt64Mod(A: TUInt64; B: TUInt64): TUInt64;
{*  64 λ޷ࡣ

   
     A: TUInt64                           - 
     B: TUInt64                           - 

   ֵTUInt64                        - 
}

function UInt64Div(A: TUInt64; B: TUInt64): TUInt64;
{*  64 λ޷

   
     A: TUInt64                           - 
     B: TUInt64                           - 

   ֵTUInt64                        - 
}

function UInt64Mul(A: Cardinal; B: Cardinal): TUInt64;
{*  32 λ޷ˡڲ֧ UInt64 ƽ̨ϣ UInt64 ʽ Int64 
   ֱʹ Int64 п

   
     A: Cardinal                          - һ
     B: Cardinal                          - 

   ֵTUInt64                        - 
}

procedure UInt64AddUInt64(A: TUInt64; B: TUInt64; var ResLo: TUInt64; var ResHi: TUInt64);
{*  64 λ޷ӣ ResLo  ResHi С
   עڲʵְ㷨ΪӣʵResHi Ȼ 1ֱж 1 

   
     A: TUInt64                           - һ
     B: TUInt64                           - 
     var ResLo: TUInt64                   - ͵λ
     var ResHi: TUInt64                   - ͸λ

   ֵޣ
}

procedure UInt64MulUInt64(A: TUInt64; B: TUInt64; var ResLo: TUInt64; var ResHi: TUInt64);
{* 64 λ޷ˣ ResLo  ResHi СWin 64 λûʵ֣Լһϡ

   
     A: TUInt64                           - һ
     B: TUInt64                           - 
     var ResLo: TUInt64                   - λ
     var ResHi: TUInt64                   - λ

   ֵޣ
}

function UInt64ToHex(N: TUInt64): string;
{*  64 λ޷תΪʮַ

   
     N: TUInt64                           - תֵ

   ֵstring                         - ʮַ
}

function UInt64ToStr(N: TUInt64): string;
{*  64 λ޷תΪʮַ

   
     N: TUInt64                           - תֵ

   ֵstring                         - ʮַ
}

function StrToUInt64(const S: string): TUInt64;
{* ַתΪ 64 λ޷

   
     const S: string                      - תַ

   ֵTUInt64                        - ת
}

function UInt64Compare(A: TUInt64; B: TUInt64): Integer;
{* Ƚ 64 λ޷ֱֵݱȽϵĽǴڡڻС 10-1

   
     A: TUInt64                           - Ƚϵһ
     B: TUInt64                           - Ƚϵ

   ֵInteger                        - رȽϽ
}

function UInt64Sqrt(N: TUInt64): TUInt64;
{*  64 λ޷ƽ֡

   
     N: TUInt64                           - ƽ

   ֵTUInt64                        - ƽ
}

function UInt32IsNegative(N: Cardinal): Boolean;
{* ж 32 λ޷ 32 λзʱǷС 0

   
     N: Cardinal                          - жϵֵ

   ֵBoolean                        - ǷС 0
}

function UInt64IsNegative(N: TUInt64): Boolean;
{* ж 64 λ޷ 64 λзʱǷС 0

   
     N: TUInt64                           - жϵֵ

   ֵBoolean                        - ǷС 0
}

procedure UInt64SetBit(var B: TUInt64; Index: Integer);
{*  64 λĳһλ 1λ Index  0 ʼ 63

   
     var B: TUInt64                       - λֵ
     Index: Integer                       -  1 λ

   ֵޣ
}

procedure UInt64ClearBit(var B: TUInt64; Index: Integer);
{*  64 λĳһλ 0λ Index  0 ʼ 63

   
     var B: TUInt64                       - λֵ
     Index: Integer                       -  0 λ

   ֵޣ
}

function GetUInt64BitSet(B: TUInt64; Index: Integer): Boolean;
{*  64 λĳһλǷ 1λ Index  0 ʼ 63

   
     B: TUInt64                           - жϵֵ
     Index: Integer                       - жϵλ

   ֵBoolean                        - ظλǷ 1
}

function GetUInt64HighBits(B: TUInt64): Integer;
{*  64 λ 1 ߶λǵڼλλ 0û 1 -1

   
     B: TUInt64                           - жϵֵ

   ֵInteger                        -  1 λ
}

function GetUInt32HighBits(B: Cardinal): Integer;
{*  32 λ 1 ߶λǵڼλλ 0û 1 -1

   
     B: Cardinal                          - жϵֵ

   ֵInteger                        -  1 λ
}

function GetUInt16HighBits(B: Word): Integer;
{*  16 λ 1 ߶λǵڼλλ 0û 1 -1

   
     B: Word                              - жϵֵ

   ֵInteger                        -  1 λ
}

function GetUInt8HighBits(B: Byte): Integer;
{*  8 λ 1 ߶λǵڼλλ 0û 1 -1

   
     B: Byte                              - жϵֵ

   ֵInteger                        -  1 λ
}

function GetUInt64LowBits(B: TUInt64): Integer;
{*  64 λ 1 Ͷλǵڼλλ 0ͬĩβ 0û 1 -1

   
     B: TUInt64                           - жϵֵ

   ֵInteger                        -  1 λ
}

function GetUInt32LowBits(B: Cardinal): Integer;
{*  32 λ 1 Ͷλǵڼλλ 0ͬĩβ 0û 1 -1

   
     B: Cardinal                          - жϵֵ

   ֵInteger                        -  1 λ
}

function GetUInt16LowBits(B: Word): Integer;
{*  16 λ 1 Ͷλǵڼλλ 0ͬĩβ 0û 1 -1

   
     B: Word                              - жϵֵ

   ֵInteger                        -  1 λ
}

function GetUInt8LowBits(B: Byte): Integer;
{*  8 λ 1 Ͷλǵڼλλ 0ͬĩβ 0û 1 -1

   
     B: Byte                              - жϵֵ

   ֵInteger                        -  1 λ
}

function Int64Mod(M: Int64; N: Int64): Int64;
{* װ Int64 ModM ֵʱȡģģ N Ҫס

   
     M: Int64                             - 
     N: Int64                             - 

   ֵInt64                          - 
}

function IsUInt32PowerOf2(N: Cardinal): Boolean;
{* жһ 32 λ޷Ƿ 2 ݡ

   
     N: Cardinal                          - жϵֵ

   ֵBoolean                        - Ƿ 2 
}

function IsUInt64PowerOf2(N: TUInt64): Boolean;
{* жһ 64 λ޷Ƿ 2 ݡ

   
     N: TUInt64                           - жϵֵ

   ֵBoolean                        - Ƿ 2 
}

function GetUInt32PowerOf2GreaterEqual(N: Cardinal): Cardinal;
{* õһָ 32 λ޷ȵ 2 ݣ򷵻 0

   
     N: Cardinal                          - ֵ

   ֵCardinal                       - ط 2 ݻ 0
}

function GetUInt64PowerOf2GreaterEqual(N: TUInt64): TUInt64;
{* õһָ 64 λ޷ȵ 2 ݣ򷵻 0

   
     N: TUInt64                           - ֵ

   ֵTUInt64                        - ط 2 ݻ 0
}

function IsInt32AddOverflow(A: Integer; B: Integer): Boolean;
{* ж 32 λзǷ 32 λзޡ

   
     A: Integer                           - һ
     B: Integer                           - 

   ֵBoolean                        - Ƿ
}

function IsUInt32AddOverflow(A: Cardinal; B: Cardinal): Boolean;
{* ж 32 λ޷Ƿ 32 λ޷ޡ

   
     A: Cardinal                          - һ
     B: Cardinal                          - 

   ֵBoolean                        - Ƿ
}

function IsInt64AddOverflow(A: Int64; B: Int64): Boolean;
{* ж 64 λзǷ 64 λзޡ

   
     A: Int64                             - һ
     B: Int64                             - 

   ֵBoolean                        - Ƿ
}

function IsUInt64AddOverflow(A: TUInt64; B: TUInt64): Boolean;
{* ж 64 λ޷Ƿ 64 λ޷ޡ

   
     A: TUInt64                           - һ
     B: TUInt64                           - 

   ֵBoolean                        - Ƿ
}

procedure UInt64Add(var R: TUInt64; A: TUInt64; B: TUInt64; out Carry: Integer);
{*  64 λ޷ӣA + B => R 1 ýλλ㡣

   
     var R: TUInt64                       - 
     A: TUInt64                           - һ
     B: TUInt64                           - 
     out Carry: Integer                   - λ

   ֵޣ
}

procedure UInt64Sub(var R: TUInt64; A: TUInt64; B: TUInt64; out Carry: Integer);
{*  64 λ޷A - B => Rнλ 1 ýλλ㡣

   
     var R: TUInt64                       - 
     A: TUInt64                           - 
     B: TUInt64                           - 
     out Carry: Integer                   - λ

   ֵޣ
}

function IsInt32MulOverflow(A: Integer; B: Integer): Boolean;
{* ж 32 λзǷ 32 λзޡ

   
     A: Integer                           - һ
     B: Integer                           - 

   ֵBoolean                        - Ƿ
}

function IsUInt32MulOverflow(A: Cardinal; B: Cardinal): Boolean;
{* ж 32 λ޷Ƿ 32 λ޷

   
     A: Cardinal                          - һ
     B: Cardinal                          - 

   ֵBoolean                        - Ƿ
}

function IsUInt32MulOverflowInt64(A: Cardinal; B: Cardinal; out R: TUInt64): Boolean;
{* ж 32 λ޷Ƿ 64 λзޣδҲ False ʱR ֱӷؽ
   Ҳ TrueҪµ UInt64Mul ʵʩˡ

   
     A: Cardinal                          - һ
     B: Cardinal                          - 
     out R: TUInt64                       - δʱػ

   ֵBoolean                        - Ƿ
}

function IsInt64MulOverflow(A: Int64; B: Int64): Boolean;
{* ж 64 λзǷ 64 λзޡ

   
     A: Int64                             - һ
     B: Int64                             - 

   ֵBoolean                        - Ƿ
}

function PointerToInteger(P: Pointer): Integer;
{* ָת֧ͣ 32/64 λע 64 λ¿ܻᶪ 32 λݡ

   
     P: Pointer                           - תָ

   ֵInteger                        - ת
}

function IntegerToPointer(I: Integer): Pointer;
{* תָ֧ͣ 32/64 λ

   
     I: Integer                           - ת

   ֵPointer                        - תָ
}

function Int64NonNegativeAddMod(A: Int64; B: Int64; N: Int64): Int64;
{*  64 λзΧĺ࣬Ҫ N  0

   
     A: Int64                             - һ
     B: Int64                             - һ
     N: Int64                             - ģ

   ֵInt64                          - Ľ
}

function UInt64NonNegativeAddMod(A: TUInt64; B: TUInt64; N: TUInt64): TUInt64;
{*  64 λ޷Χĺ࣬Ҫ N  0

   
     A: TUInt64                           - һ
     B: TUInt64                           - 
     N: TUInt64                           - ģ

   ֵTUInt64                        - Ľ
}

function Int64NonNegativeMulMod(A: Int64; B: Int64; N: Int64): Int64;
{* 64 λзΧڵֱ࣬Ӽ㣬Ҫ N  0

   
     A: Int64                             - һ
     B: Int64                             - 
     N: Int64                             - ģ

   ֵInt64                          - Ľ
}

function UInt64NonNegativeMulMod(A: TUInt64; B: TUInt64; N: TUInt64): TUInt64;
{* 64 λ޷Χڵֱ࣬Ӽ㣬

   
     A: TUInt64                           - һ
     B: TUInt64                           - 
     N: TUInt64                           - ģ

   ֵTUInt64                        - Ľ
}

function Int64NonNegativeMod(N: Int64; P: Int64): Int64;
{* װ 64 λзķǸຯҲΪʱӸ豣֤ P  0

   
     N: Int64                             - 
     P: Int64                             - 

   ֵInt64                          - طǸĽ
}

function Int64NonNegativPower(N: Int64; Exp: Integer): Int64;
{*  64 λзķǸָݣ

   
     N: Int64                             - 
     Exp: Integer                         - ָҪ 0

   ֵInt64                          - ݵĽ
}

function Int64NonNegativeRoot(N: Int64; Exp: Integer): Int64;
{*  64 λзķǸη֣

   
     N: Int64                             - 
     Exp: Integer                         - 

   ֵInt64                          - ؿֽ
}

function UInt64NonNegativPower(N: TUInt64; Exp: Integer): TUInt64;
{*  64 λ޷ķǸָݣ

   
     N: TUInt64                           - 
     Exp: Integer                         - ָҪ 0

   ֵTUInt64                        - ݵĽ
}

function UInt64NonNegativeRoot(N: TUInt64; Exp: Integer): TUInt64;
{*  64 λ޷ķǸη֣

   
     N: TUInt64                           - 
     Exp: Integer                         - 

   ֵTUInt64                        - ؿֽ
}

function CurrentByteOrderIsBigEndian: Boolean;
{* صǰڻǷǴˣҲǷеĸֽڴ洢ڽϵ͵ʼַ
   ϴҵĶϰߣ粿ָ ARM  MIPS

   
     ޣ

   ֵBoolean                        - صǰڻǷǴ
}

function CurrentByteOrderIsLittleEndian: Boolean;
{* صǰڻǷСˣҲǷеĸֽڴ洢ڽϸߵʼַ x86 벿Ĭ ARM

   
     ޣ

   ֵBoolean                        - صǰڻǷС
}

function Int64ToBigEndian(Value: Int64): Int64;
{* ȷ 64 λзֵΪˣС˻лת

   
     Value: Int64                         - ת 64 λз

   ֵInt64                          - شֵ
}

function Int32ToBigEndian(Value: Integer): Integer;
{* ȷ 32 λзֵΪˣС˻лת

   
     Value: Integer                       - ת 32 λз

   ֵInteger                        - شֵ
}

function Int16ToBigEndian(Value: SmallInt): SmallInt;
{* ȷ 16 λзֵΪˣС˻лת

   
     Value: SmallInt                      - ת 16 λз

   ֵSmallInt                       - شֵ
}

function Int64ToLittleEndian(Value: Int64): Int64;
{* ȷ 64 λзֵΪСˣڴ˻лת

   
     Value: Int64                         - ת 64 λз

   ֵInt64                          - شֵ
}

function Int32ToLittleEndian(Value: Integer): Integer;
{* ȷ 32 λзֵΪСˣڴ˻лת

   
     Value: Integer                       - ת 32 λз

   ֵInteger                        - Сֵ
}

function Int16ToLittleEndian(Value: SmallInt): SmallInt;
{* ȷ 16 λзֵΪСˣڴ˻лת

   
     Value: SmallInt                      - ת 16 λз

   ֵSmallInt                       - Сֵ
}

function UInt64ToBigEndian(Value: TUInt64): TUInt64;
{* ȷ 64 λ޷ֵΪˣС˻лת

   
     Value: TUInt64                       - ת 64 λ޷

   ֵTUInt64                        - شֵ
}

function UInt32ToBigEndian(Value: Cardinal): Cardinal;
{* ȷ 32 λ޷ֵΪˣС˻лת

   
     Value: Cardinal                      - ת 32 λ޷

   ֵCardinal                       - شֵ
}

function UInt16ToBigEndian(Value: Word): Word;
{* ȷ 16 λ޷ֵΪˣС˻лת

   
     Value: Word                          - ת 16 λ޷

   ֵWord                           - شֵ
}

function UInt64ToLittleEndian(Value: TUInt64): TUInt64;
{* ȷ 64 λ޷ֵΪСˣڴ˻лת

   
     Value: TUInt64                       - ת 64 λ޷

   ֵTUInt64                        - شֵ
}

function UInt32ToLittleEndian(Value: Cardinal): Cardinal;
{* ȷ 32 λ޷ֵΪСˣڴ˻лת

   
     Value: Cardinal                      - ת 32 λ޷

   ֵCardinal                       - Сֵ
}

function UInt16ToLittleEndian(Value: Word): Word;
{* ȷ 16 λ޷ֵΪСˣڴ˻лת

   
     Value: Word                          - ת 16 λ޷

   ֵWord                           - Сֵ
}

function Int64HostToNetwork(Value: Int64): Int64;
{*  64 λзֵֽ˳תΪֽ˳С˻лת

   
     Value: Int64                         - ת 64 λз

   ֵInt64                          - ֽ˳ֵ
}

function Int32HostToNetwork(Value: Integer): Integer;
{*  32 λзֵֽ˳תΪֽ˳С˻лת

   
     Value: Integer                       - ת 32 λз

   ֵInteger                        - ֽ˳ֵ
}

function Int16HostToNetwork(Value: SmallInt): SmallInt;
{*  16 λзֵֽ˳תΪֽ˳С˻лת

   
     Value: SmallInt                      - ת 16 λз

   ֵSmallInt                       - ֽ˳ֵ
}

function Int64NetworkToHost(Value: Int64): Int64;
{*  64 λзֵֽ˳תΪֽ˳С˻лת

   
     Value: Int64                         - ת 64 λз

   ֵInt64                          - ֽ˳ֵ
}

function Int32NetworkToHost(Value: Integer): Integer;
{*  32 λзֵֽ˳תΪֽ˳С˻лת

   
     Value: Integer                       - ת 32 λз

   ֵInteger                        - ֽ˳ֵ
}

function Int16NetworkToHost(Value: SmallInt): SmallInt;
{*  16 λзֵֽ˳תΪֽ˳С˻лת

   
     Value: SmallInt                      - ת 16 λз

   ֵSmallInt                       - ֽ˳ֵ
}

function UInt64HostToNetwork(Value: TUInt64): TUInt64;
{*  64 λ޷ֵֽ˳תΪֽ˳С˻лת

   
     Value: TUInt64                       - ת 64 λ޷

   ֵTUInt64                        - ֽ˳ֵ
}

function UInt32HostToNetwork(Value: Cardinal): Cardinal;
{*  32 λ޷ֵֽ˳תΪֽ˳С˻лת

   
     Value: Cardinal                      - ת 32 λ޷

   ֵCardinal                       - ֽ˳ֵ
}

function UInt16HostToNetwork(Value: Word): Word;
{*  16 λ޷ֵֽ˳תΪֽ˳С˻лת

   
     Value: Word                          - ת 16 λ޷

   ֵWord                           - ֽ˳ֵ
}

function UInt64NetworkToHost(Value: TUInt64): TUInt64;
{*  64 λ޷ֵֽ˳תΪֽ˳С˻лת

   
     Value: TUInt64                       - ת 64 λ޷

   ֵTUInt64                        - ֽ˳ֵ
}

function UInt32NetworkToHost(Value: Cardinal): Cardinal;
{*  32 λ޷ֵֽ˳תΪֽ˳С˻лת

   
     Value: Cardinal                      - ת 32 λ޷

   ֵCardinal                       - ֽ˳ֵ
}

function UInt16NetworkToHost(Value: Word): Word;
{*  16 λ޷ֵֽ˳תΪֽ˳С˻лת

   
     Value: Word                          - ת 16 λ޷

   ֵWord                           - ֽ˳ֵ
}

procedure MemoryNetworkToHost(Mem: Pointer; MemByteLen: Integer);
{* һƬڴֽ˳תΪֽ˳С˻лת
   ÷ӦóϽ٣¶ġֽתѾ㹻

   
     Mem: Pointer                         - תݿַ
     MemByteLen: Integer                  - תݿֽڳ

   ֵޣ
}

procedure MemoryHostToNetwork(Mem: Pointer; MemByteLen: Integer);
{* һƬڴֽ˳תΪֽ˳С˻лת
   ÷ӦóϽ٣¶ġֽתѾ㹻

   
     Mem: Pointer                         - תݿַ
     MemByteLen: Integer                  - תݿֽڳ

   ֵޣ
}

procedure ReverseMemory(Mem: Pointer; MemByteLen: Integer);
{* ֽ˳һڴ飬ֽڲ䡣

   
     Mem: Pointer                         - õݿַ
     MemByteLen: Integer                  - õݿֽڳ

   ֵޣ
}

function ReverseBitsInInt8(V: Byte): Byte;
{* һֽڲλݡ

   
     V: Byte                              - õһֽ

   ֵByte                           - صֵ
}

function ReverseBitsInInt16(V: Word): Word;
{* öֽڼڲλݡ

   
     V: Word                              - õĶֽ

   ֵWord                           - صֵ
}

function ReverseBitsInInt32(V: Cardinal): Cardinal;
{* ֽڼڲλݡ

   
     V: Cardinal                          - õֽ

   ֵCardinal                       - صֵ
}

function ReverseBitsInInt64(V: Int64): Int64;
{* ðֽڼڲλݡ

   
     V: Int64                             - õİֽ

   ֵInt64                          - صֵ
}

procedure ReverseMemoryWithBits(Mem: Pointer; MemByteLen: Integer);
{* ֽ˳һڴ飬ÿֽҲ

   
     Mem: Pointer                         - õݿַ
     MemByteLen: Integer                  - õݿֽڳ

   ֵޣ
}

procedure MemoryAnd(AMem: Pointer; BMem: Pointer; MemByteLen: Integer; ResMem: Pointer);
{* 鳤ͬڴ AMem  BMem λ룬 ResMem У߿ͬ

   
     AMem: Pointer                        - ݿַһ
     BMem: Pointer                        - ݿַ
     MemByteLen: Integer                  - ݿֽڳ
     ResMem: Pointer                      - ݿַ

   ֵޣ
}

procedure MemoryOr(AMem: Pointer; BMem: Pointer; MemByteLen: Integer; ResMem: Pointer);
{* 鳤ͬڴ AMem  BMem λ򣬽 ResMem У߿ͬ

   
     AMem: Pointer                        - ݿַһ
     BMem: Pointer                        - ݿַ
     MemByteLen: Integer                  - ݿֽڳ
     ResMem: Pointer                      - ݿַ

   ֵޣ
}

procedure MemoryXor(AMem: Pointer; BMem: Pointer; MemByteLen: Integer; ResMem: Pointer);
{* 鳤ͬڴ AMem  BMem λ򣬽 ResMem У߿ͬ

   
     AMem: Pointer                        - ݿַһ
     BMem: Pointer                        - ݿַ
     MemByteLen: Integer                  - ݿֽڳ
     ResMem: Pointer                      - ݿַ

   ֵޣ
}

procedure MemoryNot(Mem: Pointer; MemByteLen: Integer; ResMem: Pointer);
{* һڴ AMem ȡ ResMem У߿ͬ

   
     Mem: Pointer                         - ݿַ
     MemByteLen: Integer                  - ݿֽڳ
     ResMem: Pointer                      - ݿַ

   ֵޣ
}

procedure MemoryShiftLeft(AMem: Pointer; BMem: Pointer; MemByteLen: Integer; BitCount: Integer);
{* AMem ڴ BitCount λ BMemڴַλƣλ 0߿ȡ

   
     AMem: Pointer                        - ݿַһ
     BMem: Pointer                        - ݿַ
     MemByteLen: Integer                  - ݿֽڳ
     BitCount: Integer                    - Ƶλ

   ֵޣ
}

procedure MemoryShiftRight(AMem: Pointer; BMem: Pointer; MemByteLen: Integer; BitCount: Integer);
{* AMem ڴ BitCount λ BMemڴַλƣλ 0߿ȡ

   
     AMem: Pointer                        - ݿַһ
     BMem: Pointer                        - ݿַ
     MemByteLen: Integer                  - ݿֽڳ
     BitCount: Integer                    - Ƶλ

   ֵޣ
}

function MemoryIsBitSet(Mem: Pointer; N: Integer): Boolean;
{* ڴĳ Bit λǷ 1ڴַλ 0ֽڻұΪ 0

   
     Mem: Pointer                         - ݿַ
     N: Integer                           - λ

   ֵBoolean                        - Ƿ 1
}

procedure MemorySetBit(Mem: Pointer; N: Integer);
{* ڴĳ Bit λ 1ڴַλ 0ֽڻұΪ 0

   
     Mem: Pointer                         - ݿַ
     N: Integer                           - λ

   ֵޣ
}

procedure MemoryClearBit(Mem: Pointer; N: Integer);
{* ڴĳ Bit λ 0ڴַλ 0ֽڻұΪ 0

   
     Mem: Pointer                         - ݿַ
     N: Integer                           - λ

   ֵޣ
}

function MemoryToBinStr(Mem: Pointer; MemByteLen: Integer; Sep: Boolean = False): string;
{* һڴݴӵ͵ֽ˳ΪַSep ʾֽ֮Ƿոָ

   
     Mem: Pointer                         - ݿַ
     MemByteLen: Integer                  - ݿֽڳ
     Sep: Boolean                         - ֽ֮Ƿÿոָ

   ֵstring                         - ضַ
}

procedure MemorySwap(AMem: Pointer; BMem: Pointer; MemByteLen: Integer);
{* ͬȵڴݣͬڴʲô

   
     AMem: Pointer                        - ݿַһ
     BMem: Pointer                        - ݿַ
     MemByteLen: Integer                  - ݿֽڳ

   ֵޣ
}

function MemoryCompare(AMem: Pointer; BMem: Pointer; MemByteLen: Integer): Integer;
{* ޷ķʽȽڴ棬 10-1ͬڴֱӷ 0

   
     AMem: Pointer                        - Ƚϵݿַһ
     BMem: Pointer                        - Ƚϵݿַ
     MemByteLen: Integer                  - Ƚϵݿֽڳ

   ֵInteger                        - رȽϵĽ
}

procedure MemoryQuickSort(Mem: Pointer; ElementByteSize: Integer;
  ElementCount: Integer; CompareProc: TCnMemSortCompareProc = nil);
{* Թ̶СԪص

   
     Mem: Pointer                         - ݿַ
     ElementByteSize: Integer             - Ԫֽڳ
     ElementCount: Integer                - ݿԪصĸ
     CompareProc: TCnMemSortCompareProc   - ԪرȽϵĻص

   ֵޣ
}

function UInt8ToBinStr(V: Byte): string;
{* һ 8 λ޷תΪַ

   
     V: Byte                              - ת 8 λ޷

   ֵstring                         - ضַ
}

function UInt16ToBinStr(V: Word): string;
{* һ 16 λ޷תΪַ

   
     V: Word                              - ת 16 λ޷

   ֵstring                         - ضַ
}

function UInt32ToBinStr(V: Cardinal): string;
{* һ 32 λ޷תΪַ

   
     V: Cardinal                          - ת 32 λ޷

   ֵstring                         - ضַ
}

function UInt32ToStr(V: Cardinal): string;
{* һ 32 λ޷תΪʮַ

   
     V: Cardinal                          - ת 32 λ޷

   ֵstring                         - ʮַ
}

function UInt64ToBinStr(V: TUInt64): string;
{* һ 64 λ޷תΪַ

   
     V: TUInt64                           - ת 64 λ޷

   ֵstring                         - ضַ
}

function HexToInt(const Hex: string): Integer; overload;
{* һʮַתΪͣʺϽ϶ 2 ַַ

   
     const Hex: string                    - תʮַ

   ֵInteger                        - 
}

function HexToInt(Hex: PChar; CharLen: Integer): Integer; overload;
{* һʮַָָתΪͣʺϽ϶ 2 ַַ

   
     Hex: PChar                           - תʮַַ
     CharLen: Integer                     - ַ

   ֵInteger                        - 
}

function IsHexString(const Hex: string): Boolean;
{* жһַǷϷʮִַСд

   
     const Hex: string                    - жϵʮַ

   ֵBoolean                        - ǷǺϷʮַ
}

function DataToHex(InData: Pointer; ByteLength: Integer; UseUpperCase: Boolean = True): string;
{* ڴתΪʮַڴλݳַ󷽣൱ֽ˳
   UseUpperCase ݵĴСд

   
     InData: Pointer                      - תݿַ
     ByteLength: Integer                  - תݿֽڳ
     UseUpperCase: Boolean                - ʮַڲǷд

   ֵstring                         - ʮַ
}

function HexToData(const Hex: string; OutData: Pointer = nil): Integer;
{* ʮַתΪڴ飬ַ󷽵ݳڴλ൱ֽ˳
   ʮַΪתʧʱ׳쳣תɹֽ
   ע OutData Ӧָ㹻תݵֽڳΪ Length(Hex) div 2
    nilֻֽڳȣʽת

   
     const Hex: string                    - תʮַ
     OutData: Pointer                     - ֽڳӦΪ Length(Hex) div 2

   ֵInteger                        - תֽڳ
}

function StringToHex(const Data: string; UseUpperCase: Boolean = True): string;
{* ַתΪʮַUseUpperCase ݵĴСд

   
     const Data: string                   - תַ
     UseUpperCase: Boolean                - ʮַڲǷд

   ֵstring                         - תʮַ
}

function HexToString(const Hex: string): string;
{* ʮַתΪַʮַΪתʧʱ׳쳣

   
     const Hex: string                    - תʮַ

   ֵstring                         - תַ
}

function HexToAnsiStr(const Hex: AnsiString): AnsiString;
{* ʮַתΪַʮַΪתʧʱ׳쳣

   
     const Hex: AnsiString                - תʮַ

   ֵAnsiString                     - תַ
}

function AnsiStrToHex(const Data: AnsiString; UseUpperCase: Boolean = True): AnsiString;
{* AnsiString תΪʮַUseUpperCase ݵĴСд

   
     const Data: AnsiString               - תַ
     UseUpperCase: Boolean                - ʮַڲǷд

   ֵAnsiString                     - ʮַ
}

function BytesToHex(Data: TBytes; UseUpperCase: Boolean = True): string;
{* ֽתΪʮַ±λݳַ󷽣൱ֽ˳
   UseUpperCase ݵĴСд

   
     Data: TBytes                         - תֽ
     UseUpperCase: Boolean                - ʮַڲǷд

   ֵstring                         - ʮַ
}

function HexToBytes(const Hex: string): TBytes;
{* ʮַתΪֽ飬ַߵݳ±λ൱ֽ˳
   ַΪתʧʱ׳쳣

   
     const Hex: string                    - תʮַ

   ֵTBytes                         - ½ֽ
}

function StreamToHex(Stream: TStream; UseUpperCase: Boolean = True): string;
{* еȫݴͷתΪʮַ

   
     Stream: TStream                      - 
     UseUpperCase: Boolean                - ʮַڲǷд

   ֵstring                         - ʮַ
}

function HexToStream(const Hex: string; Stream: TStream): Integer;
{* ʮַתдУдֽ

   
     const Hex: string                    - תʮַ
     Stream: TStream                      - д

   ֵInteger                        - дֽ
}

procedure ReverseBytes(Data: TBytes);
{* ֽ˳һֽ顣

   
     Data: TBytes                         - õֽ

   ֵޣ
}

function CloneBytes(Data: TBytes): TBytes;
{* һµֽ

   
     Data: TBytes                         - Ƶֽ

   ֵTBytes                         - ½ֽ
}

function StreamToBytes(Stream: TStream): TBytes;
{* ͷȫֽ飬½ֽ顣

   
     Stream: TStream                      - 

   ֵTBytes                         - ½ֽ
}

function BytesToStream(Data: TBytes; OutStream: TStream): Integer;
{* ֽдԭʼдֽ

   
     Data: TBytes                         - дֽ
     OutStream: TStream                   - д

   ֵInteger                        - дֽ
}

function AnsiToBytes(const Str: AnsiString): TBytes;
{*  AnsiString ֱתΪֽ飬롣

   
     const Str: AnsiString                - תַ

   ֵTBytes                         - תֽ
}

function BytesToAnsi(Data: TBytes): AnsiString;
{* ֱֽתΪ AnsiString롣

   
     Data: TBytes                         - תֽ

   ֵAnsiString                     - תַ
}

function BytesToString(Data: TBytes): string;
{* ֽתΪ stringڲ Byte ֵΪ Char롣

   
     Data: TBytes                         - תֽ

   ֵstring                         - תַ
}

function MemoryToString(Mem: Pointer; MemByteLen: Integer): string;
{* ڴתΪ stringڲֽڸֵ롣

   
     Mem: Pointer                         - תݿַ
     MemByteLen: Integer                  - תݿֽڳ

   ֵstring                         - תַ
}

function BitsToString(Bits: TBits): string;
{* λתΪ 0  1 ַ

   
     Bits: TBits                          - תλ

   ֵstring                         - תַ
}

function ConcatBytes(A: TBytes; B: TBytes): TBytes;
{*  A B ֽ˳ƴ÷һֽ飬A B ֲ䡣

   
     A: TBytes                            - ƴӵֽһ
     B: TBytes                            - ƴӵֽ

   ֵTBytes                         - ƴӵֽ
}

function NewBytesFromMemory(Data: Pointer; DataByteLen: Integer): TBytes;
{* ½һֽ飬һƬڴݹ

   
     Data: Pointer                        - ݿַ
     DataByteLen: Integer                 - ݿֽڳ

   ֵTBytes                         - ½ֽ
}

function CompareBytes(A: TBytes; B: TBytes): Boolean; overload;
{* ȽֽǷͬ

   
     A: TBytes                            - Ƚϵֽһ
     B: TBytes                            - Ƚϵֽ

   ֵBoolean                        - رȽϽǷͬ
}

function CompareBytes(A: TBytes; B: TBytes; MaxLength: Integer): Boolean; overload;
{* Ƚֽǰ MaxLength ֽڵǷͬ

   
     A: TBytes                            - Ƚϵֽһ
     B: TBytes                            - Ƚϵֽ
     MaxLength: Integer                   - Ƚϵֽ

   ֵBoolean                        - رȽϽǷͬ
}

function MoveMost(const Source; var Dest; ByteLen: Integer; MostLen: Integer): Integer;
{*  Source ƶ ByteLen Ҳ MostLen ֽڵ Dest Уʵƶֽ
    ByteLen С MostLen Dest  0Ҫ Dest  MostLen

   
     const Source                         - ƶԴλáַ
     var Dest                             - ƶĿλáַҪ MostLen ֽ
     ByteLen: Integer                     - ƶֽ
     MostLen: Integer                     - ƶֽ

   ֵInteger                        - ʵƶֽ
}

// ===============================  ===================================

function SarInt8(var V: Byte; ShiftCount: Integer): Byte;
{* һ 8 λƣҲǱλơ

   
     var V: Byte                          - Ƶ 8 λ
     ShiftCount: Integer                  - Ƶλ

   ֵByte                           - λֵ
}

function SarInt16(var V: Word; ShiftCount: Integer): Word;
{* һ 16 λƣҲǱλơ

   
     var V: Word                          - Ƶ 16 λ
     ShiftCount: Integer                  - Ƶλ

   ֵWord                           - λֵ
}

function SarInt32(var V: Cardinal; ShiftCount: Integer): Cardinal;
{* һ 32 λƣҲǱλơ

   
     var V: Cardinal                      - Ƶ 32 λ
     ShiftCount: Integer                  - Ƶλ

   ֵCardinal                       - λֵ
}

function SarInt64(var V: TUInt64; ShiftCount: Integer): TUInt64;
{* һ 64 λƣҲǱλơ

   
     var V: TUInt64                       - Ƶ 64 λ
     ShiftCount: Integer                  - Ƶλ

   ֵTUInt64                        - λֵ
}

// ================ ִʱ̶ if жϵĲ߼ ===============

procedure ConstTimeConditionalSwap8(CanSwap: Boolean; var A: Byte; var B: Byte);
{*  8 λͱִʱ̶CanSwap Ϊ True ʱʵʩ A B 

   
     CanSwap: Boolean                     - Ƿ񽻻
     var A: Byte                          -  8 λͱһ
     var B: Byte                          -  8 λͱ

   ֵޣ
}

procedure ConstTimeConditionalSwap16(CanSwap: Boolean; var A: Word; var B: Word);
{*  16 λͱִʱ̶CanSwap Ϊ True ʱʵʩ A B 

   
     CanSwap: Boolean                     - Ƿ񽻻
     var A: Word                          -  16 λͱһ
     var B: Word                          -  16 λͱ

   ֵޣ
}

procedure ConstTimeConditionalSwap32(CanSwap: Boolean; var A: Cardinal; var B: Cardinal);
{*  32 λͱִʱ̶CanSwap Ϊ True ʱʵʩ A B 

   
     CanSwap: Boolean                     - Ƿ񽻻
     var A: Cardinal                      -  32 λͱһ
     var B: Cardinal                      -  32 λͱ

   ֵޣ
}

procedure ConstTimeConditionalSwap64(CanSwap: Boolean; var A: TUInt64; var B: TUInt64);
{*  64 λͱִʱ̶CanSwap Ϊ True ʱʵʩ A B 

   
     CanSwap: Boolean                     - Ƿ񽻻
     var A: TUInt64                       -  64 λͱһ
     var B: TUInt64                       -  64 λͱ

   ֵޣ
}

function ConstTimeEqual8(A: Byte; B: Byte): Boolean;
{* ֽڵִʱ̶ıȽϣ CPU ָתԤ⵼µִʱ죬ͬʱ True

   
     A: Byte                              - Ƚϵ 8 λͱһ
     B: Byte                              - Ƚϵ 8 λͱ

   ֵBoolean                        - Ƿ
}

function ConstTimeEqual16(A: Word; B: Word): Boolean;
{* ˫ֽڵִʱ̶ıȽϣ CPU ָתԤ⵼µִʱ죬ͬʱ True

   
     A: Word                              - Ƚϵ 16 λͱһ
     B: Word                              - Ƚϵ 16 λͱ

   ֵBoolean                        - Ƿ
}

function ConstTimeEqual32(A: Cardinal; B: Cardinal): Boolean;
{* ֽڵִʱ̶ıȽϣ CPU ָתԤ⵼µִʱ죬ͬʱ True

   
     A: Cardinal                          - Ƚϵ 32 λͱһ
     B: Cardinal                          - Ƚϵ 32 λͱ

   ֵBoolean                        - Ƿ
}

function ConstTimeEqual64(A: TUInt64; B: TUInt64): Boolean;
{* ֽڵִʱ̶ıȽϣ CPU ָתԤ⵼µִʱ죬ͬʱ True

   
     A: TUInt64                           - Ƚϵ 64 λͱһ
     B: TUInt64                           - Ƚϵ 64 λͱ

   ֵBoolean                        - Ƿ
}

function ConstTimeBytesEqual(A: TBytes; B: TBytes): Boolean;
{* ͬȵִֽʱ̶ıȽϣͬʱ True

   
     A: TBytes                            - Ƚϵֽһ
     B: TBytes                            - Ƚϵֽ

   ֵBoolean                        - Ƿ
}

function ConstTimeExpandBoolean8(V: Boolean): Byte;
{*  V ֵ 8 λȫ 1 ȫ 0

   
     V: Boolean                           - Ƿ񷵻ȫ 1

   ֵByte                           -  $FF  0
}

function ConstTimeExpandBoolean16(V: Boolean): Word;
{*  V ֵ 16 λȫ 1 ȫ 0

   
     V: Boolean                           - Ƿ񷵻ȫ 1

   ֵWord                           -  $FFFF  0
}

function ConstTimeExpandBoolean32(V: Boolean): Cardinal;
{*  V ֵ 32 λȫ 1 ȫ 0

   
     V: Boolean                           - Ƿ񷵻ȫ 1

   ֵCardinal                       -  $FFFFFFFF  0
}

function ConstTimeExpandBoolean64(V: Boolean): TUInt64;
{*  V ֵ 64 λȫ 1 ȫ 0

   
     V: Boolean                           - Ƿ񷵻ȫ 1

   ֵTUInt64                        -  $FFFFFFFFFFFFFFFF  0
}

function ConstTimeConditionalSelect8(Condition: Boolean; A: Byte; B: Byte): Byte;
{* ֽڱִʱ̶жѡCondtion Ϊ True ʱ A򷵻 B

   
     Condition: Boolean                   - Ƿѡ A Ҳǲһ
     A: Byte                              - ѡ 8 λһ
     B: Byte                              - ѡ 8 λ

   ֵByte                           - ѡ 8 λ
}

function ConstTimeConditionalSelect16(Condition: Boolean; A: Word; B: Word): Word;
{* ˫ֽڱִʱ̶жѡCondtion Ϊ True ʱ A򷵻 B

   
     Condition: Boolean                   - Ƿѡ A Ҳǲһ
     A: Word                              - ѡ 16 λһ
     B: Word                              - ѡ 16 λ

   ֵWord                           - ѡ 16 λ
}

function ConstTimeConditionalSelect32(Condition: Boolean; A: Cardinal; B: Cardinal): Cardinal;
{* ֽڱִʱ̶жѡCondtion Ϊ True ʱ A򷵻 B

   
     Condition: Boolean                   - Ƿѡ A Ҳǲһ
     A: Cardinal                          - ѡ 32 λһ
     B: Cardinal                          - ѡ 32 λ

   ֵCardinal                       - ѡ 32 λ
}

function ConstTimeConditionalSelect64(Condition: Boolean; A: TUInt64; B: TUInt64): TUInt64;
{* ֽڱִʱ̶жѡCondtion Ϊ True ʱ A򷵻 B

   
     Condition: Boolean                   - Ƿѡ A Ҳǲһ
     A: TUInt64                           - ѡ 64 λһ
     B: TUInt64                           - ѡ 64 λ

   ֵTUInt64                        - ѡ 64 λ
}

// ================ ִʱ̶ if жϵĲ߼ ===============

{$IFDEF MSWINDOWS}

// ĸΪ Intel ֻ֧࣬ 32 λ 64 λ Intel CPUӦCPUX86  CPUX64

procedure Int64DivInt32Mod(A: Int64; B: Integer;
  var DivRes: Integer; var ModRes: Integer);
{* 64 λз 32 λз̷ DivRes ModRes
   б֤ 32 λΧڣ쳣

   
     A: Int64                             - 
     B: Integer                           - 
     var DivRes: Integer                  - 
     var ModRes: Integer                  - 

   ֵޣ
}

procedure UInt64DivUInt32Mod(A: TUInt64; B: Cardinal;
  var DivRes: Cardinal; var ModRes: Cardinal);
{* 64 λ޷ 32 λ޷̷ DivRes ModRes
   б֤ 32 λΧڣ쳣

   
     A: TUInt64                           - 
     B: Cardinal                          - 
     var DivRes: Cardinal                 - 
     var ModRes: Cardinal                 - 

   ֵޣ
}

procedure Int128DivInt64Mod(ALo: Int64; AHi: Int64; B: Int64;
  var DivRes: Int64; var ModRes: Int64);
{* 128 λз 64 λз̷ DivRes ModRes
   б֤ 64 λΧڣ쳣

   
     ALo: Int64                           -  64 λ
     AHi: Int64                           -  64 λ
     B: Int64                             - 
     var DivRes: Int64                    - 
     var ModRes: Int64                    - 

   ֵޣ
}

procedure UInt128DivUInt64Mod(ALo: TUInt64; AHi: TUInt64; B: TUInt64;
  var DivRes: TUInt64; var ModRes: TUInt64);
{* 128 λ޷ 64 λ޷̷ DivRes ModRes
   б֤ 64 λΧڣ쳣

   
     ALo: TUInt64                         -  64 λ
     AHi: TUInt64                         -  64 λ
     B: TUInt64                           - 
     var DivRes: TUInt64                  - 
     var ModRes: TUInt64                  - 

   ֵޣ
}

{$ENDIF}

function IsUInt128BitSet(Lo: TUInt64; Hi: TUInt64; N: Integer): Boolean;
{*  Int64 ƴɵ 128 λ֣ص N λǷΪ 1N  0  127

   
     Lo: TUInt64                          - жϵĵ 64 λ
     Hi: TUInt64                          - жϵĸ 64 λ
     N: Integer                           - жϵλ

   ֵBoolean                        - ǷΪ 1
}

procedure SetUInt128Bit(var Lo: TUInt64; var Hi: TUInt64; N: Integer);
{*  Int64 ƴɵ 128 λ֣õ N λΪ 1N  0  127

   
     var Lo: TUInt64                      - õĵ 64 λ
     var Hi: TUInt64                      - õĸ 64 λ
     N: Integer                           - õλ

   ֵޣ
}

procedure ClearUInt128Bit(var Lo: TUInt64; var Hi: TUInt64; N: Integer);
{*  Int64 ƴɵ 128 λ֣ N λN  0  127

   
     var Lo: TUInt64                      - õĵ 64 λ
     var Hi: TUInt64                      - õĸ 64 λ
     N: Integer                           - õλ

   ֵޣ
}

function UnsignedAddWithLimitRadix(A: Cardinal; B: Cardinal; C: Cardinal;
  var R: Cardinal; L: Cardinal; H: Cardinal): Cardinal;
{* Ƶ޷żӷA + B + C R Уؽλֵ
   ȷ L  H ıڣûȷ H  LΡ
   úַӳ䣬 C һǽλ

   
     A: Cardinal                          - һ
     B: Cardinal                          - 
     C: Cardinal                          - һǽλ
     var R: Cardinal                      - 
     L: Cardinal                          - ͵
     H: Cardinal                          - ͵

   ֵCardinal                       - Ƿнλ
}

// =========================== ѭλ ====================================

// ע N Ӧ (0, A λ) ڣ N Ϊ 0  A λʱֵӦΪ A
// N ʱࣨΪͲȲͬ 32 λ AN Ϊ 33 ʱֵ N Ϊ 1 ʱķֵ

function RotateLeft16(A: Word; N: Integer): Word; {$IFDEF SUPPORT_INLINE} inline; {$ENDIF}
{*  16 λѭ N λ

   
     A: Word                              - ѭƵ 16 λ
     N: Integer                           - ѭƵλ

   ֵWord                           - λֵ
}

function RotateRight16(A: Word; N: Integer): Word; {$IFDEF SUPPORT_INLINE} inline; {$ENDIF}
{*  16 λѭ N λ

   
     A: Word                              - ѭƵ 16 λ
     N: Integer                           - ѭƵλ

   ֵWord                           - λֵ
}

function RotateLeft32(A: Cardinal; N: Integer): Cardinal; {$IFDEF SUPPORT_INLINE} inline; {$ENDIF}
{*  32 λѭ N λ

   
     A: Cardinal                          - ѭƵ 32 λ
     N: Integer                           - ѭƵλ

   ֵCardinal                       - λֵ
}

function RotateRight32(A: Cardinal; N: Integer): Cardinal; {$IFDEF SUPPORT_INLINE} inline; {$ENDIF}
{*  32 λѭ N λ

   
     A: Cardinal                          - ѭƵ 32 λ
     N: Integer                           - ѭƵλ

   ֵCardinal                       - λֵ
}

function RotateLeft64(A: TUInt64; N: Integer): TUInt64; {$IFDEF SUPPORT_INLINE} inline; {$ENDIF}
{*  64 λѭ N λ

   
     A: TUInt64                           - ѭƵ 64 λ
     N: Integer                           - ѭƵλ

   ֵTUInt64                        - λֵ
}

function RotateRight64(A: TUInt64; N: Integer): TUInt64; {$IFDEF SUPPORT_INLINE} inline; {$ENDIF}
{*  64 λѭ N λ

   
     A: TUInt64                           - ѭƵ 64 λ
     N: Integer                           - ѭƵλ

   ֵTUInt64                        - λֵ
}

{$IFDEF COMPILER5}

function BoolToStr(Value: Boolean; UseBoolStrs: Boolean = False): string;
{* תΪַDelphi 5 ûи BoolToStr ϡ

   
     Value: Boolean                       - תĲֵ
     UseBoolStrs: Boolean                 - Ƿ񷵻Ӣĵ

   ֵstring                         - UseBoolStrs Ϊ False ʱ -1  0򷵻 True  False
}

{$ENDIF}

implementation

uses
  CnFloat;

resourcestring
  SCnErrorNotAHexPChar = 'Error: NOT a Hex PChar: %c';
  SCnErrorLengthNotHex = 'Error Length %d: NOT a Hex String';
  SCnErrorLengthNotHexAnsi = 'Error Length %d: NOT a Hex AnsiString';

var
  FByteOrderIsBigEndian: Boolean = False;

function CurrentByteOrderIsBigEndian: Boolean;
type
  TByteOrder = packed record
    case Boolean of
      False: (C: array[0..1] of Byte);
      True: (W: Word);
  end;
var
  T: TByteOrder;
begin
  T.W := $00CC;
  Result := T.C[1] = $CC;
end;

function CurrentByteOrderIsLittleEndian: Boolean;
begin
  Result := not CurrentByteOrderIsBigEndian;
end;

function ReverseInt64(Value: Int64): Int64;
var
  Lo, Hi: Cardinal;
  Rec: Int64Rec;
begin
  Lo := Int64Rec(Value).Lo;
  Hi := Int64Rec(Value).Hi;
  Lo := ((Lo and $000000FF) shl 24) or ((Lo and $0000FF00) shl 8)
    or ((Lo and $00FF0000) shr 8) or ((Lo and $FF000000) shr 24);
  Hi := ((Hi and $000000FF) shl 24) or ((Hi and $0000FF00) shl 8)
    or ((Hi and $00FF0000) shr 8) or ((Hi and $FF000000) shr 24);
  Rec.Lo := Hi;
  Rec.Hi := Lo;
  Result := Int64(Rec);
end;

function ReverseUInt64(Value: TUInt64): TUInt64;
var
  Lo, Hi: Cardinal;
  Rec: Int64Rec;
begin
  Lo := Int64Rec(Value).Lo;
  Hi := Int64Rec(Value).Hi;
  Lo := ((Lo and $000000FF) shl 24) or ((Lo and $0000FF00) shl 8)
    or ((Lo and $00FF0000) shr 8) or ((Lo and $FF000000) shr 24);
  Hi := ((Hi and $000000FF) shl 24) or ((Hi and $0000FF00) shl 8)
    or ((Hi and $00FF0000) shr 8) or ((Hi and $FF000000) shr 24);
  Rec.Lo := Hi;
  Rec.Hi := Lo;
  Result := TUInt64(Rec);
end;

function Int64ToBigEndian(Value: Int64): Int64;
begin
  if FByteOrderIsBigEndian then
    Result := Value
  else
    Result := ReverseInt64(Value);
end;

function Int32ToBigEndian(Value: Integer): Integer;
begin
  if FByteOrderIsBigEndian then
    Result := Value
  else
    Result := Integer((Value and $000000FF) shl 24) or Integer((Value and $0000FF00) shl 8)
      or Integer((Value and $00FF0000) shr 8) or Integer((Value and $FF000000) shr 24);
end;

function Int16ToBigEndian(Value: SmallInt): SmallInt;
begin
  if FByteOrderIsBigEndian then
    Result := Value
  else
    Result := SmallInt((Value and $00FF) shl 8) or SmallInt((Value and $FF00) shr 8);
end;

function Int64ToLittleEndian(Value: Int64): Int64;
begin
  if not FByteOrderIsBigEndian then
    Result := Value
  else
    Result := ReverseInt64(Value);
end;

function Int32ToLittleEndian(Value: Integer): Integer;
begin
  if not FByteOrderIsBigEndian then
    Result := Value
  else
    Result := Integer((Value and $000000FF) shl 24) or Integer((Value and $0000FF00) shl 8)
      or Integer((Value and $00FF0000) shr 8) or Integer((Value and $FF000000) shr 24);
end;

function Int16ToLittleEndian(Value: SmallInt): SmallInt;
begin
  if not FByteOrderIsBigEndian then
    Result := Value
  else
    Result := SmallInt((Value and $00FF) shl 8) or SmallInt((Value and $FF00) shr 8);
end;

function UInt64ToBigEndian(Value: TUInt64): TUInt64;
begin
  if FByteOrderIsBigEndian then
    Result := Value
  else
    Result := ReverseUInt64(Value);
end;

function UInt32ToBigEndian(Value: Cardinal): Cardinal;
begin
  if FByteOrderIsBigEndian then
    Result := Value
  else
    Result := Cardinal((Value and $000000FF) shl 24) or Cardinal((Value and $0000FF00) shl 8)
      or Cardinal((Value and $00FF0000) shr 8) or Cardinal((Value and $FF000000) shr 24);
end;

function UInt16ToBigEndian(Value: Word): Word;
begin
  if FByteOrderIsBigEndian then
    Result := Value
  else
    Result := Word((Value and $00FF) shl 8) or Word((Value and $FF00) shr 8);
end;

function UInt64ToLittleEndian(Value: TUInt64): TUInt64;
begin
  if not FByteOrderIsBigEndian then
    Result := Value
  else
    Result := ReverseUInt64(Value);
end;

function UInt32ToLittleEndian(Value: Cardinal): Cardinal;
begin
  if not FByteOrderIsBigEndian then
    Result := Value
  else
    Result := Cardinal((Value and $000000FF) shl 24) or Cardinal((Value and $0000FF00) shl 8)
      or Cardinal((Value and $00FF0000) shr 8) or Cardinal((Value and $FF000000) shr 24);
end;

function UInt16ToLittleEndian(Value: Word): Word;
begin
  if not FByteOrderIsBigEndian then
    Result := Value
  else
    Result := Word((Value and $00FF) shl 8) or Word((Value and $FF00) shr 8);
end;

function Int64HostToNetwork(Value: Int64): Int64;
begin
  if not FByteOrderIsBigEndian then
    Result := ReverseInt64(Value)
  else
    Result := Value;
end;

function Int32HostToNetwork(Value: Integer): Integer;
begin
  if not FByteOrderIsBigEndian then
    Result := Integer((Value and $000000FF) shl 24) or Integer((Value and $0000FF00) shl 8)
      or Integer((Value and $00FF0000) shr 8) or Integer((Value and $FF000000) shr 24)
  else
    Result := Value;
end;

function Int16HostToNetwork(Value: SmallInt): SmallInt;
begin
  if not FByteOrderIsBigEndian then
    Result := SmallInt((Value and $00FF) shl 8) or SmallInt((Value and $FF00) shr 8)
  else
    Result := Value;
end;

function Int64NetworkToHost(Value: Int64): Int64;
begin
  if not FByteOrderIsBigEndian then
    REsult := ReverseInt64(Value)
  else
    Result := Value;
end;

function Int32NetworkToHost(Value: Integer): Integer;
begin
  if not FByteOrderIsBigEndian then
    Result := Integer((Value and $000000FF) shl 24) or Integer((Value and $0000FF00) shl 8)
      or Integer((Value and $00FF0000) shr 8) or Integer((Value and $FF000000) shr 24)
  else
    Result := Value;
end;

function Int16NetworkToHost(Value: SmallInt): SmallInt;
begin
  if not FByteOrderIsBigEndian then
    Result := SmallInt((Value and $00FF) shl 8) or SmallInt((Value and $FF00) shr 8)
  else
    Result := Value;
end;

function UInt64HostToNetwork(Value: TUInt64): TUInt64;
begin
  if CurrentByteOrderIsBigEndian then
    Result := Value
  else
    Result := ReverseUInt64(Value);
end;

function UInt32HostToNetwork(Value: Cardinal): Cardinal;
begin
  if not FByteOrderIsBigEndian then
    Result := Cardinal((Value and $000000FF) shl 24) or Cardinal((Value and $0000FF00) shl 8)
      or Cardinal((Value and $00FF0000) shr 8) or Cardinal((Value and $FF000000) shr 24)
  else
    Result := Value;
end;

function UInt16HostToNetwork(Value: Word): Word;
begin
  if not FByteOrderIsBigEndian then
    Result := ((Value and $00FF) shl 8) or ((Value and $FF00) shr 8)
  else
    Result := Value;
end;

function UInt64NetworkToHost(Value: TUInt64): TUInt64;
begin
  if CurrentByteOrderIsBigEndian then
    Result := Value
  else
    Result := ReverseUInt64(Value);
end;

function UInt32NetworkToHost(Value: Cardinal): Cardinal;
begin
  if not FByteOrderIsBigEndian then
    Result := Cardinal((Value and $000000FF) shl 24) or Cardinal((Value and $0000FF00) shl 8)
      or Cardinal((Value and $00FF0000) shr 8) or Cardinal((Value and $FF000000) shr 24)
  else
    Result := Value;
end;

function UInt16NetworkToHost(Value: Word): Word;
begin
  if not FByteOrderIsBigEndian then
    Result := ((Value and $00FF) shl 8) or ((Value and $FF00) shr 8)
  else
    Result := Value;
end;

function ReverseBitsInInt8(V: Byte): Byte;
begin
  // 0  1 2  3 4  5 6  7 
  V := ((V and $AA) shr 1) or ((V and $55) shl 1);
  // 01  23 45  67 
  V := ((V and $CC) shr 2) or ((V and $33) shl 2);
  // 0123  4567 
  V := (V shr 4) or (V shl 4);
  Result := V;
end;

function ReverseBitsInInt16(V: Word): Word;
begin
  Result := (ReverseBitsInInt8(V and $00FF) shl 8)
    or ReverseBitsInInt8((V and $FF00) shr 8);
end;

function ReverseBitsInInt32(V: Cardinal): Cardinal;
begin
  Result := (ReverseBitsInInt16(V and $0000FFFF) shl 16)
    or ReverseBitsInInt16((V and $FFFF0000) shr 16);
end;

function ReverseBitsInInt64(V: Int64): Int64;
begin
  Result := (Int64(ReverseBitsInInt32(V and $00000000FFFFFFFF)) shl 32)
    or ReverseBitsInInt32((V and $FFFFFFFF00000000) shr 32);
end;

procedure ReverseMemory(Mem: Pointer; MemByteLen: Integer);
var
  I, L: Integer;
  P: PByteArray;
  T: Byte;
begin
  if (Mem = nil) or (MemByteLen < 2) then
    Exit;

  L := MemByteLen div 2;
  P := PByteArray(Mem);
  for I := 0 to L - 1 do
  begin
    //  I ͵ MemLen - I - 1
    T := P^[I];
    P^[I] := P^[MemByteLen - I - 1];
    P^[MemByteLen - I - 1] := T;
  end;
end;

procedure ReverseMemoryWithBits(Mem: Pointer; MemByteLen: Integer);
var
  I: Integer;
  P: PByteArray;
begin
  if (Mem = nil) or (MemByteLen <= 0) then
    Exit;

  ReverseMemory(Mem, MemByteLen);
  P := PByteArray(Mem);

  for I := 0 to MemByteLen - 1 do
    P^[I] := ReverseBitsInInt8(P^[I]);
end;

procedure MemoryNetworkToHost(Mem: Pointer; MemByteLen: Integer);
begin
  if not FByteOrderIsBigEndian then
    ReverseMemory(Mem, MemByteLen);
end;

procedure MemoryHostToNetwork(Mem: Pointer; MemByteLen: Integer);
begin
  if not FByteOrderIsBigEndian then
    ReverseMemory(Mem, MemByteLen);
end;

// N ֽڳȵڴλ
procedure MemoryBitOperation(AMem, BMem, RMem: Pointer; N: Integer; Op: TCnBitOperation);
var
  A, B, R: PCnLongWord32Array;
  BA, BB, BR: PByteArray;
begin
  if N <= 0 then
    Exit;

  if (AMem = nil) or ((BMem = nil) and (Op <> boNot)) or (RMem = nil) then
    Exit;

  A := PCnLongWord32Array(AMem);
  B := PCnLongWord32Array(BMem);
  R := PCnLongWord32Array(RMem);

  while (N and (not 3)) <> 0 do
  begin
    case Op of
      boAnd:
        R^[0] := A^[0] and B^[0];
      boOr:
        R^[0] := A^[0] or B^[0];
      boXor:
        R^[0] := A^[0] xor B^[0];
      boNot: // ʱ B
        R^[0] := not A^[0];
    end;

    A := PCnLongWord32Array(TCnNativeInt(A) + SizeOf(Cardinal));
    B := PCnLongWord32Array(TCnNativeInt(B) + SizeOf(Cardinal));
    R := PCnLongWord32Array(TCnNativeInt(R) + SizeOf(Cardinal));

    Dec(N, SizeOf(Cardinal));
  end;

  if N > 0 then
  begin
    BA := PByteArray(A);
    BB := PByteArray(B);
    BR := PByteArray(R);

    while N <> 0 do
    begin
      case Op of
        boAnd:
          BR^[0] := BA^[0] and BB^[0];
        boOr:
          BR^[0] := BA^[0] or BB^[0];
        boXor:
          BR^[0] := BA^[0] xor BB^[0];
        boNot:
          BR^[0] := not BA^[0];
      end;

      BA := PByteArray(TCnNativeInt(BA) + SizeOf(Byte));
      BB := PByteArray(TCnNativeInt(BB) + SizeOf(Byte));
      BR := PByteArray(TCnNativeInt(BR) + SizeOf(Byte));
      Dec(N);
    end;
  end;
end;

procedure MemoryAnd(AMem, BMem: Pointer; MemByteLen: Integer; ResMem: Pointer);
begin
  MemoryBitOperation(AMem, BMem, ResMem, MemByteLen, boAnd);
end;

procedure MemoryOr(AMem, BMem: Pointer; MemByteLen: Integer; ResMem: Pointer);
begin
  MemoryBitOperation(AMem, BMem, ResMem, MemByteLen, boOr);
end;

procedure MemoryXor(AMem, BMem: Pointer; MemByteLen: Integer; ResMem: Pointer);
begin
  MemoryBitOperation(AMem, BMem, ResMem, MemByteLen, boXor);
end;

procedure MemoryNot(Mem: Pointer; MemByteLen: Integer; ResMem: Pointer);
begin
  MemoryBitOperation(Mem, nil, ResMem, MemByteLen, boNot);
end;

procedure MemoryShiftLeft(AMem, BMem: Pointer; MemByteLen: Integer; BitCount: Integer);
var
  I, L, N, LB, RB: Integer;
  PF, PT: PByteArray;
begin
  if (AMem = nil) or (MemByteLen <= 0) or (BitCount = 0) then
    Exit;

  if BitCount < 0 then
  begin
    MemoryShiftRight(AMem, BMem, MemByteLen, -BitCount);
    Exit;
  end;

  if BMem = nil then
    BMem := AMem;

  if (MemByteLen * 8) <= BitCount then // ̫಻ȫ 0
  begin
    FillChar(BMem^, MemByteLen, 0);
    Exit;
  end;

  N := BitCount div 8;  // λֽ
  RB := BitCount mod 8; // ȥֽںʣµλ
  LB := 8 - RB;         // ʣµλһֽʣµλ

  PF := PByteArray(AMem);
  PT := PByteArray(BMem);

  if RB = 0 then // 飬ð죬Ҫλֽ MemLen - NW
  begin
    Move(PF^[N], PT^[0], MemByteLen - N);
    FillChar(PT^[MemByteLen - N], N, 0);
  end
  else
  begin
    //  PF^[N]  PT^[0] MemLen - N ֽڣֽڼн
    L := MemByteLen - N;
    PF := PByteArray(TCnNativeInt(PF) + N);

    for I := 1 to L do // ӵλƶȴ͵
    begin
      PT^[0] := Byte(PF^[0] shl RB);
      if I < L then    // һֽ PF^[1] ᳬ
        PT^[0] := (PF^[1] shr LB) or PT^[0];

      PF := PByteArray(TCnNativeInt(PF) + 1);
      PT := PByteArray(TCnNativeInt(PT) + 1);
    end;

    // ʣµҪ 0
    if N > 0 then
      FillChar(PT^[0], N, 0);
  end;
end;

procedure MemoryShiftRight(AMem, BMem: Pointer; MemByteLen: Integer; BitCount: Integer);
var
  I, L, N, LB, RB: Integer;
  PF, PT: PByteArray;
begin
  if (AMem = nil) or (MemByteLen <= 0) or (BitCount = 0) then
    Exit;

  if BitCount < 0 then
  begin
    MemoryShiftLeft(AMem, BMem, MemByteLen, -BitCount);
    Exit;
  end;

  if BMem = nil then
    BMem := AMem;

  if (MemByteLen * 8) <= BitCount then // ̫಻ȫ 0
  begin
    FillChar(BMem^, MemByteLen, 0);
    Exit;
  end;

  N := BitCount div 8;  // λֽ
  RB := BitCount mod 8; // ȥֽںʣµλ
  LB := 8 - RB;         // ʣµλһֽʣµλ

  if RB = 0 then // 飬ð죬Ҫλֽ MemLen - N
  begin
    PF := PByteArray(AMem);
    PT := PByteArray(BMem);

    Move(PF^[0], PT^[N], MemByteLen - N);
    FillChar(PT^[0], N, 0);
  end
  else
  begin
    //  PF^[0]  PT^[N] MemLen - N ֽڣôӸߴʼֽڼн
    L := MemByteLen - N;

    PF := PByteArray(TCnNativeInt(AMem) + L - 1);
    PT := PByteArray(TCnNativeInt(BMem) + MemByteLen - 1);

    for I := L downto 1 do // Ӹλλƶȴ
    begin
      PT^[0] := Byte(PF^[0] shr RB);
      if I > 1 then        // һֽ PF^[-1] ᳬ
      begin
        PF := PByteArray(TCnNativeInt(PF) - 1);
        PT^[0] := (PF^[0] shl LB) or PT^[0];
      end
      else
        PF := PByteArray(TCnNativeInt(PF) - 1);

      PT := PByteArray(TCnNativeInt(PT) - 1);
    end;

    // ʣµǰҪ 0
    if N > 0 then
      FillChar(BMem^, N, 0);
  end;
end;

function MemoryIsBitSet(Mem: Pointer; N: Integer): Boolean;
var
  P: PByte;
  A, B: Integer;
  V: Byte;
begin
  if (Mem = nil) or (N < 0) then
    raise ERangeError.Create(SRangeError);

  A := N div 8;
  B := N mod 8;
  P := PByte(TCnNativeInt(Mem) + A);

  V := Byte(1 shl B);
  Result := (P^ and V) <> 0;
end;

procedure MemorySetBit(Mem: Pointer; N: Integer);
var
  P: PByte;
  A, B: Integer;
  V: Byte;
begin
  if (Mem = nil) or (N < 0) then
    raise ERangeError.Create(SRangeError);

  A := N div 8;
  B := N mod 8;
  P := PByte(TCnNativeInt(Mem) + A);

  V := Byte(1 shl B);
  P^ := P^ or V;
end;

procedure MemoryClearBit(Mem: Pointer; N: Integer);
var
  P: PByte;
  A, B: Integer;
  V: Byte;
begin
  if (Mem = nil) or (N < 0) then
    raise ERangeError.Create(SRangeError);

  A := N div 8;
  B := N mod 8;
  P := PByte(TCnNativeInt(Mem) + A);

  V := not Byte(1 shl B);
  P^ := P^ and V;
end;

function MemoryToBinStr(Mem: Pointer; MemByteLen: Integer; Sep: Boolean): string;
var
  J, L: Integer;
  P: PByteArray;
  B: PChar;

  procedure FillAByteToBuf(V: Byte; Buf: PChar);
  const
    M = $80;
  var
    I: Integer;
  begin
    for I := 0 to 7 do
    begin
      if (V and M) <> 0 then
        Buf[I] := '1'
      else
        Buf[I] := '0';
      V := V shl 1;
    end;
  end;

begin
  Result := '';
  if (Mem = nil) or (MemByteLen <= 0) then
    Exit;

  L := MemByteLen * 8;
  if Sep then
    L := L + MemByteLen - 1; // мÿոָ

  SetLength(Result, L);
  B := PChar(@Result[1]);
  P := PByteArray(Mem);

  for J := 0 to MemByteLen - 1 do
  begin
    FillAByteToBuf(P^[J], B);
    if Sep then
    begin
      B[8] := ' ';
      Inc(B, 9);
    end
    else
      Inc(B, 8);
  end;
end;

procedure MemorySwap(AMem, BMem: Pointer; MemByteLen: Integer);
var
  A, B: PCnLongWord32Array;
  BA, BB: PByteArray;
  TC: Cardinal;
  TB: Byte;
begin
  if (AMem = nil) or (BMem = nil) or (MemByteLen <= 0) then
    Exit;

  A := PCnLongWord32Array(AMem);
  B := PCnLongWord32Array(BMem);

  if A = B then
    Exit;

  while (MemByteLen and (not 3)) <> 0 do
  begin
    TC := A^[0];
    A^[0] := B^[0];
    B^[0] := TC;

    A := PCnLongWord32Array(TCnNativeInt(A) + SizeOf(Cardinal));
    B := PCnLongWord32Array(TCnNativeInt(B) + SizeOf(Cardinal));

    Dec(MemByteLen, SizeOf(Cardinal));
  end;

  if MemByteLen > 0 then
  begin
    BA := PByteArray(A);
    BB := PByteArray(B);

    while MemByteLen <> 0 do
    begin
      TB := BA^[0];
      BA^[0] := BB^[0];
      BB^[0] :=TB;

      BA := PByteArray(TCnNativeInt(BA) + SizeOf(Byte));
      BB := PByteArray(TCnNativeInt(BB) + SizeOf(Byte));

      Dec(MemByteLen);
    end;
  end;
end;

function MemoryCompare(AMem, BMem: Pointer; MemByteLen: Integer): Integer;
var
  A, B: PCnLongWord32Array;
  BA, BB: PByteArray;
begin
  Result := 0;
  if ((AMem = nil) and (BMem = nil)) or (AMem = BMem) then // ͬһ
    Exit;

  if MemByteLen <= 0 then
    Exit;

  if AMem = nil then
  begin
    Result := -1;
    Exit;
  end;
  if BMem = nil then
  begin
    Result := 1;
    Exit;
  end;

  A := PCnLongWord32Array(AMem);
  B := PCnLongWord32Array(BMem);

  while (MemByteLen and (not 3)) <> 0 do
  begin
    if A^[0] > B^[0] then
    begin
      Result := 1;
      Exit;
    end
    else if A^[0] < B^[0] then
    begin
      Result := -1;
      Exit;
    end;

    A := PCnLongWord32Array(TCnNativeInt(A) + SizeOf(Cardinal));
    B := PCnLongWord32Array(TCnNativeInt(B) + SizeOf(Cardinal));

    Dec(MemByteLen, SizeOf(Cardinal));
  end;

  if MemByteLen > 0 then
  begin
    BA := PByteArray(A);
    BB := PByteArray(B);

    while MemByteLen <> 0 do
    begin
      if BA^[0] > BB^[0] then
      begin
        Result := 1;
        Exit;
      end
      else if BA^[0] < BB^[0] then
      begin
        Result := -1;
        Exit;
      end;

      BA := PByteArray(TCnNativeInt(BA) + SizeOf(Byte));
      BB := PByteArray(TCnNativeInt(BB) + SizeOf(Byte));

      Dec(MemByteLen);
    end;
  end;
end;

function UInt8ToBinStr(V: Byte): string;
const
  M = $80;
var
  I: Integer;
begin
  SetLength(Result, 8 * SizeOf(V));
  for I := 1 to 8 * SizeOf(V) do
  begin
    if (V and M) <> 0 then
      Result[I] := '1'
    else
      Result[I] := '0';
    V := V shl 1;
  end;
end;

function UInt16ToBinStr(V: Word): string;
const
  M = $8000;
var
  I: Integer;
begin
  SetLength(Result, 8 * SizeOf(V));
  for I := 1 to 8 * SizeOf(V) do
  begin
    if (V and M) <> 0 then
      Result[I] := '1'
    else
      Result[I] := '0';
    V := V shl 1;
  end;
end;

function UInt32ToBinStr(V: Cardinal): string;
const
  M = $80000000;
var
  I: Integer;
begin
  SetLength(Result, 8 * SizeOf(V));
  for I := 1 to 8 * SizeOf(V) do
  begin
    if (V and M) <> 0 then
      Result[I] := '1'
    else
      Result[I] := '0';
    V := V shl 1;
  end;
end;

function UInt32ToStr(V: Cardinal): string;
begin
  Result := Format('%u', [V]);
end;

function UInt64ToBinStr(V: TUInt64): string;
const
  M = $8000000000000000;
var
  I: Integer;
begin
  SetLength(Result, 8 * SizeOf(V));

  for I := 1 to 8 * SizeOf(V) do
  begin
    if (V and M) <> 0 then
      Result[I] := '1'
    else
      Result[I] := '0';
    V := V shl 1;
  end;
end;

const
  HiDigits: array[0..15] of Char = ('0', '1', '2', '3', '4', '5', '6', '7',
                                  '8', '9', 'A', 'B', 'C', 'D', 'E', 'F');
const
  LoDigits: array[0..15] of Char = ('0', '1', '2', '3', '4', '5', '6', '7',
                                  '8', '9', 'a', 'b', 'c', 'd', 'e', 'f');

const
  AnsiHiDigits: array[0..15] of AnsiChar = ('0', '1', '2', '3', '4', '5', '6', '7',
                                  '8', '9', 'A', 'B', 'C', 'D', 'E', 'F');
const
  AnsiLoDigits: array[0..15] of AnsiChar = ('0', '1', '2', '3', '4', '5', '6', '7',
                                  '8', '9', 'a', 'b', 'c', 'd', 'e', 'f');

function HexToInt(Hex: PChar; CharLen: Integer): Integer;
var
  I, Res: Integer;
  C: Char;
begin
  Res := 0;
  for I := 0 to CharLen - 1 do
  begin
    C := Hex[I];
    if (C >= '0') and (C <= '9') then
      Res := Res * 16 + Ord(C) - Ord('0')
    else if (C >= 'A') and (C <= 'F') then
      Res := Res * 16 + Ord(C) - Ord('A') + 10
    else if (C >= 'a') and (C <= 'f') then
      Res := Res * 16 + Ord(C) - Ord('a') + 10
    else
      raise ECnNativeException.CreateFmt(SCnErrorNotAHexPChar, [C]);
  end;
  Result := Res;
end;

function HexToInt(const Hex: string): Integer;
begin
  Result := HexToInt(PChar(Hex), Length(Hex));
end;

{$WARNINGS OFF}

function IsHexString(const Hex: string): Boolean;
var
  I, L: Integer;
begin
  Result := False;
  L := Length(Hex);
  if (L <= 0) or ((L and 1) <> 0) then // ջżȶ
    Exit;

  for I := 1 to L do
  begin
    // ע˴ Unicode Ȼ Warningǽ Hex[I]  WideChar ֱӽض AnsiChar
    // ٽжϣᵼ¡޻ޡ $66$66$66$66 ַУ
    // ֱͨ WideChar ֵ ax ˫ֽڵģӼжϣ
    if not (Hex[I] in ['0'..'9', 'A'..'F', 'a'..'f']) then
      Exit;
  end;
  Result := True;
end;

{$WARNINGS ON}

function DataToHex(InData: Pointer; ByteLength: Integer; UseUpperCase: Boolean = True): string;
var
  I: Integer;
  B: Byte;
begin
  Result := '';
  if ByteLength <= 0 then
    Exit;

  SetLength(Result, ByteLength * 2);
  if UseUpperCase then
  begin
    for I := 0 to ByteLength - 1 do
    begin
      B := PByte(TCnNativeInt(InData) + I * SizeOf(Byte))^;
      Result[I * 2 + 1] := HiDigits[(B shr 4) and $0F];
      Result[I * 2 + 2] := HiDigits[B and $0F];
    end;
  end
  else
  begin
    for I := 0 to ByteLength - 1 do
    begin
      B := PByte(TCnNativeInt(InData) + I * SizeOf(Byte))^;
      Result[I * 2 + 1] := LoDigits[(B shr 4) and $0F];
      Result[I * 2 + 2] := LoDigits[B and $0F];
    end;
  end;
end;

function HexToData(const Hex: string; OutData: Pointer): Integer;
var
  I, L: Integer;
  H: PChar;
begin
  L := Length(Hex);
  if (L mod 2) <> 0 then
    raise ECnNativeException.CreateFmt(SCnErrorLengthNotHex, [L]);

  if OutData = nil then
  begin
    Result := L div 2;
    Exit;
  end;

  Result := 0;
  H := PChar(Hex);
  for I := 1 to L div 2 do
  begin
    PByte(TCnNativeInt(OutData) + I - 1)^ := Byte(HexToInt(@H[(I - 1) * 2], 2));
    Inc(Result);
  end;
end;

function StringToHex(const Data: string; UseUpperCase: Boolean): string;
var
  I, L: Integer;
  B: Byte;
  Buffer: PChar;
begin
  Result := '';
  L := Length(Data);
  if L = 0 then
    Exit;

  SetLength(Result, L * 2);
  Buffer := @Data[1];

  if UseUpperCase then
  begin
    for I := 0 to L - 1 do
    begin
      B := PByte(TCnNativeInt(Buffer) + I * SizeOf(Char))^;
      Result[I * 2 + 1] := HiDigits[(B shr 4) and $0F];
      Result[I * 2 + 2] := HiDigits[B and $0F];
    end;
  end
  else
  begin
    for I := 0 to L - 1 do
    begin
      B := PByte(TCnNativeInt(Buffer) + I * SizeOf(Char))^;
      Result[I * 2 + 1] := LoDigits[(B shr 4) and $0F];
      Result[I * 2 + 2] := LoDigits[B and $0F];
    end;
  end;
end;

function HexToString(const Hex: string): string;
var
  I, L: Integer;
  H: PChar;
begin
  L := Length(Hex);
  if (L mod 2) <> 0 then
    raise ECnNativeException.CreateFmt(SCnErrorLengthNotHex, [L]);

  SetLength(Result, L div 2);
  H := PChar(Hex);
  for I := 1 to L div 2 do
    Result[I] := Chr(HexToInt(@H[(I - 1) * 2], 2));
end;

function HexToAnsiStr(const Hex: AnsiString): AnsiString;
var
  I, L: Integer;
  S: string;
begin
  L := Length(Hex);
  if (L mod 2) <> 0 then
    raise ECnNativeException.CreateFmt(SCnErrorLengthNotHexAnsi, [L]);

  SetLength(Result, L div 2);
  for I := 1 to L div 2 do
  begin
    S := string(Copy(Hex, I * 2 - 1, 2));
    Result[I] := AnsiChar(Chr(HexToInt(S)));
  end;
end;

function AnsiStrToHex(const Data: AnsiString; UseUpperCase: Boolean): AnsiString;
var
  I, L: Integer;
  B: Byte;
  Buffer: PAnsiChar;
begin
  Result := '';
  L := Length(Data);
  if L = 0 then
    Exit;

  SetLength(Result, L * 2);
  Buffer := @Data[1];

  if UseUpperCase then
  begin
    for I := 0 to L - 1 do
    begin
      B := PByte(TCnNativeInt(Buffer) + I)^;
      Result[I * 2 + 1] := AnsiHiDigits[(B shr 4) and $0F];
      Result[I * 2 + 2] := AnsiHiDigits[B and $0F];
    end;
  end
  else
  begin
    for I := 0 to L - 1 do
    begin
      B := PByte(TCnNativeInt(Buffer) + I)^;
      Result[I * 2 + 1] := AnsiLoDigits[(B shr 4) and $0F];
      Result[I * 2 + 2] := AnsiLoDigits[B and $0F];
    end;
  end;
end;

function BytesToHex(Data: TBytes; UseUpperCase: Boolean): string;
var
  I, L: Integer;
  B: Byte;
  Buffer: PAnsiChar;
begin
  Result := '';
  L := Length(Data);
  if L = 0 then
    Exit;

  SetLength(Result, L * 2);
  Buffer := @Data[0];

  if UseUpperCase then
  begin
    for I := 0 to L - 1 do
    begin
      B := PByte(TCnNativeInt(Buffer) + I)^;
      Result[I * 2 + 1] := HiDigits[(B shr 4) and $0F];
      Result[I * 2 + 2] := HiDigits[B and $0F];
    end;
  end
  else
  begin
    for I := 0 to L - 1 do
    begin
      B := PByte(TCnNativeInt(Buffer) + I)^;
      Result[I * 2 + 1] := LoDigits[(B shr 4) and $0F];
      Result[I * 2 + 2] := LoDigits[B and $0F];
    end;
  end;
end;

function HexToBytes(const Hex: string): TBytes;
var
  I, L: Integer;
  H: PChar;
begin
  L := Length(Hex);
  if (L mod 2) <> 0 then
    raise ECnNativeException.CreateFmt(SCnErrorLengthNotHex, [L]);

  SetLength(Result, L div 2);
  H := PChar(Hex);

  for I := 1 to L div 2 do
    Result[I - 1] := Byte(HexToInt(@H[(I - 1) * 2], 2));
end;

function StreamToHex(Stream: TStream; UseUpperCase: Boolean): string;
var
  B: Byte;
  I: Integer;
begin
  Result := '';
  if Stream.Size > 0 then
  begin
    Stream.Position := 0;
    SetLength(Result, Stream.Size * 2);
    I := 1;
    if UseUpperCase then
    begin
      while Stream.Read(B, 1) = 1 do
      begin
        Result[I] := HiDigits[(B shr 4) and $0F];
        Inc(I);
        Result[I] := HiDigits[B and $0F];
        Inc(I);
      end;
    end
    else
    begin
      while Stream.Read(B, 1) = 1 do
      begin
        Result[I] := LoDigits[(B shr 4) and $0F];
        Inc(I);
        Result[I] := LoDigits[B and $0F];
        Inc(I);
      end;
    end;
  end;
end;

function HexToStream(const Hex: string; Stream: TStream): Integer;
var
  I, L: Integer;
  H: PChar;
  B: Byte;
begin
  Result := 0;
  L := Length(Hex);
  if (L mod 2) <> 0 then
    raise ECnNativeException.CreateFmt(SCnErrorLengthNotHex, [L]);

  H := PChar(Hex);
  for I := 1 to L div 2 do
  begin
    B := Byte(HexToInt(@H[(I - 1) * 2], 2));
    Inc(Result, Stream.Write(B, 1));
  end;
end;

procedure ReverseBytes(Data: TBytes);
var
  I, L, M: Integer;
  T: Byte;
begin
  if (Data = nil) or (Length(Data) <= 1) then
    Exit;
  L := Length(Data);
  M := L div 2;
  for I := 0 to M - 1 do
  begin
    //  I  L - I - 1
    T := Data[I];
    Data[I] := Data[L - I - 1];
    Data[L - I - 1] := T;
  end;
end;

function CloneBytes(Data: TBytes): TBytes;
begin
  if Length(Data) = 0 then
    Result := nil
  else
  begin
    SetLength(Result, Length(Data));
    Move(Data[0], Result[0], Length(Data));
  end;
end;

function StreamToBytes(Stream: TStream): TBytes;
begin
  Result := nil;
  if (Stream <> nil) and (Stream.Size > 0) then
  begin
    SetLength(Result, Stream.Size);
    Stream.Position := 0;
    Stream.Read(Result[0], Stream.Size);
  end;
end;

function BytesToStream(Data: TBytes; OutStream: TStream): Integer;
begin
  Result := 0;
  if (Data <> nil) and (Length(Data) > 0) and (OutStream <> nil) then
  begin
    OutStream.Size := 0;
    Result := OutStream.Write(Data[0], Length(Data));
  end;
end;

function AnsiToBytes(const Str: AnsiString): TBytes;
begin
  SetLength(Result, Length(Str));
  if Length(Str) > 0 then
    Move(Str[1], Result[0], Length(Str));
end;

function BytesToAnsi(Data: TBytes): AnsiString;
begin
  SetLength(Result, Length(Data));
  if Length(Data) > 0 then
    Move(Data[0], Result[1], Length(Data));
end;

function BytesToString(Data: TBytes): string;
var
  I: Integer;
begin
  SetLength(Result, Length(Data));
  for I := 1 to Length(Data) do
    Result[I] := Chr(Data[I - 1]);
end;

function MemoryToString(Mem: Pointer; MemByteLen: Integer): string;
var
  P: PByteArray;
  I: Integer;
begin
  if (Mem = nil) or (MemByteLen <= 0) then
  begin
    Result := '';
    Exit;
  end;

  P := PByteArray(Mem);
  SetLength(Result, MemByteLen);
  for I := 1 to MemByteLen do
    Result[I] := Chr(P^[I - 1]);
end;

function BitsToString(Bits: TBits): string;
var
  I: Integer;
begin
  if (Bits = nil) or (Bits.Size = 0) then
    Result := ''
  else
  begin
    SetLength(Result, Bits.Size);
    for I := 0 to Bits.Size - 1 do
    begin
      if Bits.Bits[I] then
        Result[I + 1] := '1'
      else
        Result[I + 1] := '0';
    end;
  end;
end;

function ConcatBytes(A, B: TBytes): TBytes;
begin
  //  XE7 ҲֱӣΪ A  B Ϊʱ᷵һֽ
  if (A = nil) or (Length(A) = 0) then
  begin
    SetLength(Result, Length(B));
    if Length(B) > 0 then
      Move(B[0], Result[0], Length(B));
  end
  else if (B = nil) or (Length(B) = 0) then
  begin
    SetLength(Result, Length(A));
    if Length(A) > 0 then
      Move(A[0], Result[0], Length(A));
  end
  else
  begin
    SetLength(Result, Length(A) + Length(B));
    Move(A[0], Result[0], Length(A));
    Move(B[0], Result[Length(A)], Length(B));
  end;
end;

function NewBytesFromMemory(Data: Pointer; DataByteLen: Integer): TBytes;
begin
  if (Data = nil) or (DataByteLen <= 0) then
    Result := nil
  else
  begin
    SetLength(Result, DataByteLen);
    Move(Data^, Result[0], DataByteLen);
  end;
end;

function CompareBytes(A, B: TBytes): Boolean;
var
  L: Integer;
begin
  Result := False;

  L := Length(A);
  if Length(B) <> L then // Ȳ˳
    Exit;

  if L = 0 then          // 
    Result := True       // 綼 0 
  else
    Result := CompareMem(@A[0], @B[0], L);
end;

function CompareBytes(A, B: TBytes; MaxLength: Integer): Boolean;
var
  LA, LB: Integer;
begin
  Result := False;

  LA := Length(A);
  LB := Length(B);

  if LA > MaxLength then
    LA := MaxLength;
  if LB > MaxLength then
    LB := MaxLength;

  if LA <> LB then
    Exit;

  if LA = 0 then
    Result := True
  else
    Result := CompareMem(@A[0], @B[0], LA);
end;

function MoveMost(const Source; var Dest; ByteLen, MostLen: Integer): Integer;
begin
  if (MostLen <= 0) or (ByteLen <= 0) then
  begin
    Result := 0;
    Exit;
  end;

  if ByteLen > MostLen then
    ByteLen := MostLen
  else if ByteLen < MostLen then
  begin
    FillChar(Dest, MostLen, 0);

    // TODO: ҪΪ FillChar(Dest + ByteLen, MostLen - ByteLen, 0); ֻ䲻Ĳ
  end;

  Move(Source, Dest, ByteLen);
  Result := ByteLen;
end;

// ===============================  ===================================

function SarInt8(var V: Byte; ShiftCount: Integer): Byte;
begin
  Result := V shr ShiftCount;
  if (V and $80) <> 0 then
    Result := Result or $80;
end;

function SarInt16(var V: Word; ShiftCount: Integer): Word;
begin
  Result := V shr ShiftCount;
  if (V and $8000) <> 0 then
    Result := Result or $8000;
end;

function SarInt32(var V: Cardinal; ShiftCount: Integer): Cardinal;
begin
  Result := V shr ShiftCount;
  if (V and $80000000) <> 0 then
    Result := Result or $80000000;
end;

function SarInt64(var V: TUInt64; ShiftCount: Integer): TUInt64;
begin
  Result := V shr ShiftCount;
  if (V and $8000000000000000) <> 0 then
    Result := Result or $8000000000000000;
end;

procedure ConstTimeConditionalSwap8(CanSwap: Boolean; var A, B: Byte);
var
  T, V: Byte;
begin
  T := ConstTimeExpandBoolean8(CanSwap);
  V := (A xor B) and T;
  A := A xor V;
  B := B xor V;
end;

procedure ConstTimeConditionalSwap16(CanSwap: Boolean; var A, B: Word);
var
  T, V: Word;
begin
  T := ConstTimeExpandBoolean16(CanSwap);
  V := (A xor B) and T;
  A := A xor V;
  B := B xor V;
end;

procedure ConstTimeConditionalSwap32(CanSwap: Boolean; var A, B: Cardinal);
var
  T, V: Cardinal;
begin
  T := ConstTimeExpandBoolean32(CanSwap);
  V := (A xor B) and T;
  A := A xor V;
  B := B xor V;
end;

procedure ConstTimeConditionalSwap64(CanSwap: Boolean; var A, B: TUInt64);
var
  T, V: TUInt64;
begin
  T := ConstTimeExpandBoolean64(CanSwap);
  V := (A xor B) and T;
  A := A xor V;
  B := B xor V;
end;

function ConstTimeEqual8(A, B: Byte): Boolean;
var
  R: Byte;
begin
  R := not (A xor B);     // 
  R := R and (R shr 4);   // һһ
  R := R and (R shr 2);   // һλ 0
  R := R and (R shr 1);   //  0
  Result := Boolean(R);   // ֻȫ 1  1
end;

function ConstTimeEqual16(A, B: Word): Boolean;
begin
  Result := ConstTimeEqual8(Byte(A shr 8), Byte(B shr 8))
    and ConstTimeEqual8(Byte(A and $FF), Byte(B and $FF));
end;

function ConstTimeEqual32(A, B: Cardinal): Boolean;
begin
  Result := ConstTimeEqual16(Word(A shr 16), Word(B shr 16))
    and ConstTimeEqual16(Word(A and $FFFF), Word(B and $FFFF));
end;

function ConstTimeEqual64(A, B: TUInt64): Boolean;
begin
  Result := ConstTimeEqual32(Cardinal(A shr 32), Cardinal(B shr 32))
    and ConstTimeEqual32(Cardinal(A and $FFFFFFFF), Cardinal(B and $FFFFFFFF));
end;

function ConstTimeBytesEqual(A, B: TBytes): Boolean;
var
  I: Integer;
begin
  Result := False;
  if Length(A) <> Length(B) then
    Exit;

  Result := True;
  for I := 0 to Length(A) - 1 do // ÿֽڶȽϣͬ˳
    Result := Result and (ConstTimeEqual8(A[I], B[I]));
end;

function ConstTimeExpandBoolean8(V: Boolean): Byte;
begin
  Result := Byte(V);
  Result := not Result;                  //  V  True 0˲ R Ǵ $FFR ͷ 0
  Result := Result and (Result shr 4);   // һһ
  Result := Result and (Result shr 2);   // һλ 0
  Result := Result and (Result shr 1);   //  00000000 00000001
  Result := Result or (Result shl 1);    // True õ 00000000False õ 00000001λ
  Result := Result or (Result shl 2);
  Result := Result or (Result shl 4);    // ȫ 0  ȫ 1
  Result := not Result;                  // ȫ 1 ȫ 0
end;

function ConstTimeExpandBoolean16(V: Boolean): Word;
var
  R: Byte;
begin
  R := ConstTimeExpandBoolean8(V);
  Result := R;
  Result := (Result shl 8) or R;         // ֽȫ 1 ȫ 0 ˫ֽ
end;

function ConstTimeExpandBoolean32(V: Boolean): Cardinal;
var
  R: Word;
begin
  R := ConstTimeExpandBoolean16(V);
  Result := R;
  Result := (Result shl 16) or R;        // ˫ֽȫ 1 ȫ 0 ֽ
end;

function ConstTimeExpandBoolean64(V: Boolean): TUInt64;
var
  R: Cardinal;
begin
  R := ConstTimeExpandBoolean32(V);
  Result := R;
  Result := (Result shl 32) or R;        // ֽȫ 1 ȫ 0 ɰֽ
end;

function ConstTimeConditionalSelect8(Condition: Boolean; A, B: Byte): Byte;
begin
  ConstTimeConditionalSwap8(Condition, A, B);
  Result := B;
end;

function ConstTimeConditionalSelect16(Condition: Boolean; A, B: Word): Word;
begin
  ConstTimeConditionalSwap16(Condition, A, B);
  Result := B;
end;

function ConstTimeConditionalSelect32(Condition: Boolean; A, B: Cardinal): Cardinal;
begin
  ConstTimeConditionalSwap32(Condition, A, B);
  Result := B;
end;

function ConstTimeConditionalSelect64(Condition: Boolean; A, B: TUInt64): TUInt64;
begin
  ConstTimeConditionalSwap64(Condition, A, B);
  Result := B;
end;

{$IFDEF MSWINDOWS}

{$IFDEF CPUX64}

// 64 λ IDIV  IDIV ָʵ֣ A  RCX B  EDX/RDX DivRes ַ R8 ModRes ַ R9 
procedure Int64DivInt32Mod(A: Int64; B: Integer; var DivRes, ModRes: Integer); assembler;
asm
        PUSH    RCX                           // RCX  A
        MOV     RCX, RDX                      //  B  RCX
        POP     RAX                           //  A  RAX
        XOR     RDX, RDX                      //  64 λ
        IDIV    RCX
        MOV     [R8], EAX                     // ̷ R8 ָ DivRes
        MOV     [R9], EDX                     //  R9 ָ ModRes
end;

procedure UInt64DivUInt32Mod(A: TUInt64; B: Cardinal; var DivRes, ModRes: Cardinal); assembler;
asm
        PUSH    RCX                           // RCX  A
        MOV     RCX, RDX                      //  B  RCX
        POP     RAX                           //  A  RAX
        XOR     RDX, RDX                      //  64 λ
        DIV     RCX
        MOV     [R8], EAX                     // ̷ R8 ָ DivRes
        MOV     [R9], EDX                     //  R9 ָ ModRes
end;

// 64 λ IDIV  IDIV ָʵ֣ALo  RCXAHi  RDXB  R8DivRes ĵַ R9
procedure Int128DivInt64Mod(ALo, AHi: Int64; B: Int64; var DivRes, ModRes: Int64); assembler;
asm
        MOV     RAX, RCX                      // ALo  RAXAHi Ѿ RDX 
        MOV     RCX, R8                       // B  RCX
        IDIV    RCX
        MOV     [R9], RAX                     // ̷ R9 ָ DivRes
        MOV     RAX, [RBP + $30]              // ModRes ַ RAX
        MOV     [RAX], RDX                    //  RAX ָ ModRes
end;

procedure UInt128DivUInt64Mod(ALo, AHi: UInt64; B: UInt64; var DivRes, ModRes: UInt64); assembler;
asm
        MOV     RAX, RCX                      // ALo  RAXAHi Ѿ RDX 
        MOV     RCX, R8                       // B  RCX
        DIV     RCX
        MOV     [R9], RAX                     // ̷ R9 ָ DivRes
        MOV     RAX, [RBP + $30]              // ModRes ַ RAX
        MOV     [RAX], RDX                    //  RAX ָ ModRes
end;

{$ELSE}

// 32 λ IDIV  IDIV ָʵ֣ A ڶջϣB  EAXDivRes ַ EDXModRes ַ ECX
procedure Int64DivInt32Mod(A: Int64; B: Integer; var DivRes, ModRes: Integer); assembler;
asm
        PUSH    ECX                           // ECX  ModRes ַȱ
        MOV     ECX, B                        // B  EAX УƵ ECX 
        PUSH    EDX                           // DivRes ĵַ EDX УҲ
        MOV     EAX, [EBP + $8]               // A Lo
        MOV     EDX, [EBP + $C]               // A Hi
        IDIV    ECX
        POP     ECX                           //  ECXõ DivRes ַ
        MOV     [ECX], EAX
        POP     ECX                           //  ECXõ ModRes ַ
        MOV     [ECX], EDX
end;

procedure UInt64DivUInt32Mod(A: TUInt64; B: Cardinal; var DivRes, ModRes: Cardinal); assembler;
asm
        PUSH    ECX                           // ECX  ModRes ַȱ
        MOV     ECX, B                        // B  EAX УƵ ECX 
        PUSH    EDX                           // DivRes ĵַ EDX УҲ
        MOV     EAX, [EBP + $8]               // A Lo
        MOV     EDX, [EBP + $C]               // A Hi
        DIV     ECX
        POP     ECX                           //  ECXõ DivRes ַ
        MOV     [ECX], EAX
        POP     ECX                           //  ECXõ ModRes ַ
        MOV     [ECX], EDX
end;

// 32 λµʵ
procedure Int128DivInt64Mod(ALo, AHi: Int64; B: Int64; var DivRes, ModRes: Int64);
var
  C: Integer;
begin
  if B = 0 then
    raise EDivByZero.Create(SDivByZero);

  if (AHi = 0) or (AHi = $FFFFFFFFFFFFFFFF) then //  64 λΪ 0 ֵֵ
  begin
    DivRes := ALo div B;
    ModRes := ALo mod B;
  end
  else
  begin
    if B < 0 then // Ǹ
    begin
      Int128DivInt64Mod(ALo, AHi, -B, DivRes, ModRes);
      DivRes := -DivRes;
      Exit;
    end;

    if AHi < 0 then // Ǹ
    begin
      // AHi, ALo 󷴼 1Եõֵ
      AHi := not AHi;
      ALo := not ALo;
{$IFDEF SUPPORT_UINT64}
      UInt64Add(UInt64(ALo), UInt64(ALo), 1, C);
{$ELSE}
      UInt64Add(ALo, ALo, 1, C);
{$ENDIF}
      if C > 0 then
        AHi := AHi + C;

      // ת
      Int128DivInt64Mod(ALo, AHi, B, DivRes, ModRes);

      // ٵ
      if ModRes = 0 then
        DivRes := -DivRes
      else
      begin
        DivRes := -DivRes - 1;
        ModRes := B - ModRes;
      end;
      Exit;
    end;

    // ȫ󣬰޷
{$IFDEF SUPPORT_UINT64}
    UInt128DivUInt64Mod(TUInt64(ALo), TUInt64(AHi), TUInt64(B), TUInt64(DivRes), TUInt64(ModRes));
{$ELSE}
    UInt128DivUInt64Mod(ALo, AHi, B, DivRes, ModRes);
{$ENDIF}
  end;
end;

procedure UInt128DivUInt64Mod(ALo, AHi: TUInt64; B: TUInt64; var DivRes, ModRes: TUInt64);
var
  I, Cnt: Integer;
  Q, R: TUInt64;
begin
  if B = 0 then
    raise EDivByZero.Create(SDivByZero);

  if AHi = 0 then
  begin
    DivRes := UInt64Div(ALo, B);
    ModRes := UInt64Mod(ALo, B);
  end
  else
  begin
    // иλеλզ죿жǷ AHi >= BʾҪ 64 λ
    if UInt64Compare(AHi, B) >= 0 then
      raise EIntOverflow.Create(SIntOverflow);

    Q := 0;
    R := 0;
    Cnt := GetUInt64LowBits(AHi) + 64;
    for I := Cnt downto 0 do
    begin
      R := R shl 1;
      if IsUInt128BitSet(ALo, AHi, I) then  // ĵ I λǷ 0
        R := R or 1
      else
        R := R and TUInt64(not 1);

      if UInt64Compare(R, B) >= 0 then
      begin
        R := R - B;
        Q := Q or (TUInt64(1) shl I);
      end;
    end;
    DivRes := Q;
    ModRes := R;
  end;
end;

{$ENDIF}

{$ENDIF}

{$IFDEF SUPPORT_UINT64}

// ֻҪ֧ 64 λ޷ 32/64 λ Intel  ARM Delphi  FPCʲôϵͳ

function UInt64Mod(A, B: TUInt64): TUInt64;
begin
  Result := A mod B;
end;

function UInt64Div(A, B: TUInt64): TUInt64;
begin
  Result := A div B;
end;

{$ELSE}
{
  ֧ UInt64 ĵͰ汾 Delphi  Int64  A mod/div B

  õջ˳ A ĸλA ĵλB ĸλB ĵλ push ϲ뺯
  ESP ǷصַESP+4  B ĵλESP + 8  B ĸλESP + C  A ĵλESP + 10  A ĸλ
   push esp  ESP  4Ȼ mov ebp esp֮ EBP ѰַȫҪ 4

   System.@_llumod ҪڸսʱEAX <- A ĵλEDX <- A ĸλSystem Դע EAX/EDX дˣ
  [ESP + 8]Ҳ EBP + C<- B ĸλ[ESP + 4] Ҳ EBP + 8<- B ĵλ

   CALL ǰľƴ롣UInt64 Div Ҳ
}
function UInt64Mod(A, B: TUInt64): TUInt64;
asm
        // PUSH ESP  ESP  4Ҫ
        MOV     EAX, [EBP + $10]              // A Lo
        MOV     EDX, [EBP + $14]              // A Hi
        PUSH    DWORD PTR[EBP + $C]           // B Hi
        PUSH    DWORD PTR[EBP + $8]           // B Lo
        CALL    System.@_llumod;
end;

function UInt64Div(A, B: TUInt64): TUInt64;
asm
        // PUSH ESP  ESP  4Ҫ
        MOV     EAX, [EBP + $10]              // A Lo
        MOV     EDX, [EBP + $14]              // A Hi
        PUSH    DWORD PTR[EBP + $C]           // B Hi
        PUSH    DWORD PTR[EBP + $8]           // B Lo
        CALL    System.@_lludiv;
end;

{$ENDIF}

{$IFDEF SUPPORT_UINT64}

// ֻҪ֧ 64 λ޷ 32/64 λ Intel  ARM Delphi  FPCʲôϵͳ

function UInt64Mul(A, B: Cardinal): TUInt64;
begin
  Result := TUInt64(A) * B;
end;

{$ELSE} // ֻеͰ汾 Delphi Win32 x86

{
  ޷ 32 λˣֱʹ Int64 ģ 64 λ޷

  üĴԼ A -> EAXB -> EDXʹöջ
   System.@_llmul ҪڸսʱEAX <- A ĵλEDX <- A ĸλ 0
  [ESP + 8]Ҳ EBP + C<- B ĸλ 0[ESP + 4] Ҳ EBP + 8<- B ĵλ
}
function UInt64Mul(A, B: Cardinal): TUInt64;
asm
        PUSH    0               // PUSH B λ 0
        PUSH    EDX             // PUSH B λ
                                // EAX A λѾ
        XOR     EDX, EDX        // EDX A λ 0
        CALL    System.@_llmul; //  EAX  32 λEDX  32 λ
end;

{$ENDIF}

// ޷ 64 λӣ ResLo  ResHi 
procedure UInt64AddUInt64(A, B: TUInt64; var ResLo, ResHi: TUInt64);
var
  X, Y, Z, T, R0L, R0H, R1L, R1H: Cardinal;
  R0, R1, R01, R12: TUInt64;
begin
  // ˼룺2^32 ϵ M (xM+y) + (zM+t) = (x+z) M + (y+t)
  // y+t  R0 ռ 01x+z  R1 ռ 12 R0, R1 ٲӳ R01, R12
  if IsUInt64AddOverflow(A, B) then
  begin
    X := Int64Rec(A).Hi;
    Y := Int64Rec(A).Lo;
    Z := Int64Rec(B).Hi;
    T := Int64Rec(B).Lo;

    R0 := TUInt64(Y) + TUInt64(T);
    R1 := TUInt64(X) + TUInt64(Z);

    R0L := Int64Rec(R0).Lo;
    R0H := Int64Rec(R0).Hi;
    R1L := Int64Rec(R1).Lo;
    R1H := Int64Rec(R1).Hi;

    R01 := TUInt64(R0H) + TUInt64(R1L);
    R12 := TUInt64(R1H) + TUInt64(Int64Rec(R01).Hi);

    Int64Rec(ResLo).Lo := R0L;
    Int64Rec(ResLo).Hi := Int64Rec(R01).Lo;
    Int64Rec(ResHi).Lo := Int64Rec(R12).Lo;
    Int64Rec(ResHi).Hi := Int64Rec(R12).Hi;
  end
  else
  begin
    ResLo := A + B;
    ResHi := 0;
  end;
end;

{$IFDEF WIN64}  // ע Linux 64 ²֧ ASMֻ WIN64

// 64 λ޷ 64 λˣ ResLo  ResHi Уֱûʵ֣һ
procedure UInt64MulUInt64(A, B: UInt64; var ResLo, ResHi: UInt64); assembler;
asm
  PUSH RAX
  MOV RAX, RCX
  MUL RDX         // ޷ţзŵ IMUL
  MOV [R8], RAX
  MOV [R9], RDX
  POP RAX
end;

{$ELSE}

// ޷ 64 λˣ ResLo  ResHi 
procedure UInt64MulUInt64(A, B: TUInt64; var ResLo, ResHi: TUInt64);
var
  X, Y, Z, T: Cardinal;
  YT, XT, ZY, ZX: TUInt64;
  P, R1Lo, R1Hi, R2Lo, R2Hi: TUInt64;
begin
  // ˼룺2^32 ϵ M (xM+y)*(zM+t) = xzM^2 + (xt+yz)M + yt
  // ϵ UInt64xz ռ 234xt+yz ռ 123yt ռ 01Ȼۼ
  X := Int64Rec(A).Hi;
  Y := Int64Rec(A).Lo;
  Z := Int64Rec(B).Hi;
  T := Int64Rec(B).Lo;

  YT := UInt64Mul(Y, T);
  XT := UInt64Mul(X, T);
  ZY := UInt64Mul(Y, Z);
  ZX := UInt64Mul(X, Z);

  Int64Rec(ResLo).Lo := Int64Rec(YT).Lo;

  P := Int64Rec(YT).Hi;
  UInt64AddUInt64(P, XT, R1Lo, R1Hi);
  UInt64AddUInt64(ZY, R1Lo, R2Lo, R2Hi);

  Int64Rec(ResLo).Hi := Int64Rec(R2Lo).Lo;

  P := TUInt64(Int64Rec(R2Lo).Hi) + TUInt64(Int64Rec(ZX).Lo);

  Int64Rec(ResHi).Lo := Int64Rec(P).Lo;
  Int64Rec(ResHi).Hi := Int64Rec(R1Hi).Lo + Int64Rec(R2Hi).Lo + Int64Rec(ZX).Hi + Int64Rec(P).Hi;
end;

{$ENDIF}

{$HINTS OFF}

function _ValUInt64(const S: string; var Code: Integer): TUInt64;
const
  FirstIndex = 1;
var
  I: Integer;
  Dig: Integer;
  Sign: Boolean;
  Empty: Boolean;
begin
  I := FirstIndex;
  Dig := 0; 
  Result := 0;

  if S = '' then
  begin
    Code := 1;
    Exit;
  end;

  while S[I] = Char(' ') do
    Inc(I);
  Sign := False;

  if S[I] =  Char('-') then
  begin
    Sign := True;
    Inc(I);
  end
  else if S[I] =  Char('+') then
    Inc(I);
  Empty := True;

  if (S[I] =  Char('$')) or (UpCase(S[I]) =  Char('X'))
    or ((S[I] =  Char('0')) and (I < Length(S)) and (UpCase(S[I+1]) =  Char('X'))) then
  begin
    if S[I] =  Char('0') then
      Inc(I);
    Inc(I);
    while True do
    begin
      case Char(S[I]) of
        Char('0').. Char('9'): Dig := Ord(S[I]) -  Ord('0');
        Char('A').. Char('F'): Dig := Ord(S[I]) - (Ord('A') - 10);
        Char('a').. Char('f'): Dig := Ord(S[I]) - (Ord('a') - 10);
      else
        Break;
      end;

      if Result > (CN_MAX_TUINT64 shr 4) then
        Break;
      if Sign and (Dig <> 0) then
        Break;

      Result := Result shl 4 + TUInt64(Dig);
      Inc(I);
      Empty := False;
    end;
  end
  else
  begin
    while True do
    begin
      case Char(S[I]) of
        Char('0').. Char('9'): Dig := Ord(S[I]) - Ord('0');
      else
        Break;
      end;

      if Result > UInt64Div(CN_MAX_TUINT64, 10) then
        Break;
      if Sign and (Dig <> 0) then
        Break;

      Result := Result * 10 + TUInt64(Dig);
      Inc(I);
      Empty := False;
    end;
  end;

  if (S[I] <> Char(#0)) or Empty then
    Code := I + 1 - FirstIndex
  else
    Code := 0;
end;

{$HINTS ON}

function UInt64ToHex(N: TUInt64): string;
const
  Digits: array[0..15] of Char = ('0', '1', '2', '3', '4', '5', '6', '7',
                                  '8', '9', 'A', 'B', 'C', 'D', 'E', 'F');

  function HC(B: Byte): string;
  begin
    Result := string(Digits[(B shr 4) and $0F] + Digits[B and $0F]);
  end;

begin
  Result :=
      HC(Byte((N and $FF00000000000000) shr 56))
    + HC(Byte((N and $00FF000000000000) shr 48))
    + HC(Byte((N and $0000FF0000000000) shr 40))
    + HC(Byte((N and $000000FF00000000) shr 32))
    + HC(Byte((N and $00000000FF000000) shr 24))
    + HC(Byte((N and $0000000000FF0000) shr 16))
    + HC(Byte((N and $000000000000FF00) shr 8))
    + HC(Byte((N and $00000000000000FF)));
end;

function UInt64ToStr(N: TUInt64): string;
begin
  Result := Format('%u', [N]);
end;

function StrToUInt64(const S: string): TUInt64;
{$IFNDEF DELPHIXE6_UP}
var
  E: Integer;
{$ENDIF}
begin
{$IFDEF DELPHIXE6_UP}
  Result := SysUtils.StrToUInt64(S);  // StrToUInt64 only exists under XE6 or above
{$ELSE}
  Result := _ValUInt64(S,  E);
  if E <> 0 then raise EConvertError.CreateResFmt(@SInvalidInteger, [S]);
{$ENDIF}
end;

function UInt64Compare(A, B: TUInt64): Integer;
{$IFNDEF SUPPORT_UINT64}
var
  HiA, HiB, LoA, LoB: Cardinal;
{$ENDIF}
begin
{$IFDEF SUPPORT_UINT64}
  if A > B then
    Result := 1
  else if A < B then
    Result := -1
  else
    Result := 0;
{$ELSE}
  HiA := (A and $FFFFFFFF00000000) shr 32;
  HiB := (B and $FFFFFFFF00000000) shr 32;
  if HiA > HiB then
    Result := 1
  else if HiA < HiB then
    Result := -1
  else
  begin
    LoA := Cardinal(A and $00000000FFFFFFFF);
    LoB := Cardinal(B and $00000000FFFFFFFF);
    if LoA > LoB then
      Result := 1
    else if LoA < LoB then
      Result := -1
    else
      Result := 0;
  end;
{$ENDIF}
end;

function UInt64Sqrt(N: TUInt64): TUInt64;
var
  Rem, Root: TUInt64;
  I: Integer;
begin
  Result := 0;
  if N = 0 then
    Exit;

  if UInt64Compare(N, 4) < 0 then
  begin
    Result := 1;
    Exit;
  end;

  Rem := 0;
  Root := 0;

  for I := 0 to 31 do
  begin
    Root := Root shl 1;
    Inc(Root);

    Rem := Rem shl 2;
    Rem := Rem or (N shr 62);
    N := N shl 2;

    if UInt64Compare(Root, Rem) <= 0 then
    begin
      Rem := Rem - Root;
      Inc(Root);
    end
    else
      Dec(Root);
  end;
  Result := Root shr 1;
end;

function UInt32IsNegative(N: Cardinal): Boolean;
begin
  Result := (N and (1 shl 31)) <> 0;
end;

function UInt64IsNegative(N: TUInt64): Boolean;
begin
{$IFDEF SUPPORT_UINT64}
  Result := (N and (UInt64(1) shl 63)) <> 0;
{$ELSE}
  Result := N < 0;
{$ENDIF}
end;

//  UInt64 ĳһλ 1λ Index  0 ʼ
procedure UInt64SetBit(var B: TUInt64; Index: Integer);
begin
  B := B or (TUInt64(1) shl Index);
end;

//  UInt64 ĳһλ 0λ Index  0 ʼ
procedure UInt64ClearBit(var B: TUInt64; Index: Integer);
begin
  B := B and not (TUInt64(1) shl Index);
end;

//  UInt64 ĵڼλǷ 10 ʼ
function GetUInt64BitSet(B: TUInt64; Index: Integer): Boolean;
begin
  B := B and (TUInt64(1) shl Index);
  Result := B <> 0;
end;

//  UInt64  1 ߶λǵڼλλ 0û 1 -1
function GetUInt64HighBits(B: TUInt64): Integer;
begin
  if B = 0 then
  begin
    Result := -1;
    Exit;
  end;

  Result := 1;
  if B shr 32 = 0 then
  begin
   Inc(Result, 32);
   B := B shl 32;
  end;
  if B shr 48 = 0 then
  begin
   Inc(Result, 16);
   B := B shl 16;
  end;
  if B shr 56 = 0 then
  begin
    Inc(Result, 8);
    B := B shl 8;
  end;
  if B shr 60 = 0 then
  begin
    Inc(Result, 4);
    B := B shl 4;
  end;
  if B shr 62 = 0 then
  begin
    Inc(Result, 2);
    B := B shl 2;
  end;
  Result := Result - Integer(B shr 63); // õǰ 0 
  Result := 63 - Result;
end;

//  Cardinal  1 ߶λǵڼλλ 0û 1 -1
function GetUInt32HighBits(B: Cardinal): Integer;
begin
  if B = 0 then
  begin
    Result := -1;
    Exit;
  end;

  Result := 1;
  if B shr 16 = 0 then
  begin
   Inc(Result, 16);
   B := B shl 16;
  end;
  if B shr 24 = 0 then
  begin
    Inc(Result, 8);
    B := B shl 8;
  end;
  if B shr 28 = 0 then
  begin
    Inc(Result, 4);
    B := B shl 4;
  end;
  if B shr 30 = 0 then
  begin
    Inc(Result, 2);
    B := B shl 2;
  end;
  Result := Result - Integer(B shr 31); // õǰ 0 
  Result := 31 - Result;
end;

function GetUInt16HighBits(B: Word): Integer;
begin
  if B = 0 then
  begin
    Result := -1;
    Exit;
  end;

  Result := 1;
  if B shr 8 = 0 then
  begin
    Inc(Result, 8);
    B := B shl 8;
  end;
  if B shr 12 = 0 then
  begin
    Inc(Result, 4);
    B := B shl 4;
  end;
  if B shr 14 = 0 then
  begin
    Inc(Result, 2);
    B := B shl 2;
  end;
  Result := Result - Integer(B shr 15); // õǰ 0 
  Result := 15 - Result;
end;

function GetUInt8HighBits(B: Byte): Integer;
begin
  if B = 0 then
  begin
    Result := -1;
    Exit;
  end;

  Result := 1;
  if B shr 4 = 0 then
  begin
    Inc(Result, 4);
    B := B shl 4;
  end;
  if B shr 6 = 0 then
  begin
    Inc(Result, 2);
    B := B shl 2;
  end;
  Result := Result - Integer(B shr 7); // õǰ 0 
  Result := 7 - Result;
end;

//  Int64  1 Ͷλǵڼλλ 0û 1 -1
function GetUInt64LowBits(B: TUInt64): Integer;
var
  Y: TUInt64;
  N: Integer;
begin
  Result := -1;
  if B = 0 then
    Exit;

  N := 63;
  Y := B shl 32;
  if Y <> 0 then
  begin
    Dec(N, 32);
    B := Y;
  end;
  Y := B shl 16;
  if Y <> 0 then
  begin
    Dec(N, 16);
    B := Y;
  end;
  Y := B shl 8;
  if Y <> 0 then
  begin
    Dec(N, 8);
    B := Y;
  end;
  Y := B shl 4;
  if Y <> 0 then
  begin
    Dec(N, 4);
    B := Y;
  end;
  Y := B shl 2;
  if Y <> 0 then
  begin
    Dec(N, 2);
    B := Y;
  end;
  B := B shl 1;
  Result := N - Integer(B shr 63);
end;

//  Cardinal  1 Ͷλǵڼλλ 0û 1 -1
function GetUInt32LowBits(B: Cardinal): Integer;
var
  Y, N: Integer;
begin
  Result := -1;
  if B = 0 then
    Exit;

  N := 31;
  Y := B shl 16;
  if Y <> 0 then
  begin
    Dec(N, 16);
    B := Y;
  end;
  Y := B shl 8;
  if Y <> 0 then
  begin
    Dec(N, 8);
    B := Y;
  end;
  Y := B shl 4;
  if Y <> 0 then
  begin
    Dec(N, 4);
    B := Y;
  end;
  Y := B shl 2;
  if Y <> 0 then
  begin
    Dec(N, 2);
    B := Y;
  end;
  B := B shl 1;
  Result := N - Integer(B shr 31);
end;

//  Word  1 Ͷλǵڼλλ 0ͬĩβ 0û 1 -1
function GetUInt16LowBits(B: Word): Integer;
var
  Y, N: Integer;
begin
  Result := -1;
  if B = 0 then
    Exit;

  N := 15;
  Y := B shl 8;
  if Y <> 0 then
  begin
    Dec(N, 8);
    B := Y;
  end;
  Y := B shl 4;
  if Y <> 0 then
  begin
    Dec(N, 4);
    B := Y;
  end;
  Y := B shl 2;
  if Y <> 0 then
  begin
    Dec(N, 2);
    B := Y;
  end;
  B := B shl 1;
  Result := N - Integer(B shr 15);
end;

//  Byte  1 Ͷλǵڼλλ 0ͬĩβ 0û 1 -1
function GetUInt8LowBits(B: Byte): Integer;
var
  N: Integer;
begin
  Result := -1;
  if B = 0 then
    Exit;

  N := 7;
  if B shr 4 = 0 then
  begin
    Dec(N, 4);
    B := B shl 4;
  end;
  if B shr 6 = 0 then
  begin
    Dec(N, 2);
    B := B shl 2;
  end;
  B := B shl 1;
  Result := N - Integer(B shr 7);
end;

// װ Int64 Modֵʱȡģģ
function Int64Mod(M, N: Int64): Int64;
begin
  if M > 0 then
    Result := M mod N
  else
    Result := N - ((-M) mod N);
end;

// жһ 32 λ޷Ƿ 2 
function IsUInt32PowerOf2(N: Cardinal): Boolean;
begin
  Result := (N and (N - 1)) = 0;
end;

// жһ 64 λ޷Ƿ 2 
function IsUInt64PowerOf2(N: TUInt64): Boolean;
begin
  Result := (N and (N - 1)) = 0;
end;

// õһָ 32 λ޷ȵ 2 ݣ򷵻 0
function GetUInt32PowerOf2GreaterEqual(N: Cardinal): Cardinal;
begin
  Result := N - 1;
  Result := Result or (Result shr 1);
  Result := Result or (Result shr 2);
  Result := Result or (Result shr 4);
  Result := Result or (Result shr 8);
  Result := Result or (Result shr 16);
  Inc(Result);
end;

// õһָ 64 λ޷ 2 ݣ򷵻 0
function GetUInt64PowerOf2GreaterEqual(N: TUInt64): TUInt64;
begin
  Result := N - 1;
  Result := Result or (Result shr 1);
  Result := Result or (Result shr 2);
  Result := Result or (Result shr 4);
  Result := Result or (Result shr 8);
  Result := Result or (Result shr 16);
  Result := Result or (Result shr 32);
  Inc(Result);
end;

// ж 32 λзǷ 32 λз
function IsInt32AddOverflow(A, B: Integer): Boolean;
var
  C: Integer;
begin
  C := A + B;
  Result := ((A > 0) and (B > 0) and (C < 0)) or   // ͬҽ˵
    ((A < 0) and (B < 0) and (C > 0));
end;

// ж 32 λ޷Ƿ 32 λ޷
function IsUInt32AddOverflow(A, B: Cardinal): Boolean;
begin
  Result := (A + B) < A; // ޷ӣֻҪСһ˵
end;

// ж 64 λзǷ 64 λз
function IsInt64AddOverflow(A, B: Int64): Boolean;
var
  C: Int64;
begin
  C := A + B;
  Result := ((A > 0) and (B > 0) and (C < 0)) or   // ͬҽ˵
    ((A < 0) and (B < 0) and (C > 0));
end;

// ж 64 λ޷Ƿ 64 λ޷
function IsUInt64AddOverflow(A, B: TUInt64): Boolean;
begin
  Result := UInt64Compare(A + B, A) < 0; // ޷ӣֻҪСһ˵
end;

//  64 λ޷ӣA + B => R 1 λ
procedure UInt64Add(var R: TUInt64; A, B: TUInt64; out Carry: Integer);
begin
  R := A + B;
  if UInt64Compare(R, A) < 0 then // ޷ӣֻҪСһ˵
    Carry := 1
  else
    Carry := 0;
end;

//  64 λ޷A - B => Rнλ 1 λ
procedure UInt64Sub(var R: TUInt64; A, B: TUInt64; out Carry: Integer);
begin
  R := A - B;
  if UInt64Compare(R, A) > 0 then // ޷ֻҪڱ˵λ
    Carry := 1
  else
    Carry := 0;
end;

// ж 32 λзǷ 32 λз
function IsInt32MulOverflow(A, B: Integer): Boolean;
var
  T: Integer;
begin
  T := A * B;
  Result := (B <> 0) and ((T div B) <> A);
end;

// ж 32 λ޷Ƿ 32 λ޷
function IsUInt32MulOverflow(A, B: Cardinal): Boolean;
var
  T: TUInt64;
begin
  T := TUInt64(A) * TUInt64(B);
  Result := (T = Cardinal(T));
end;

// ж 32 λ޷Ƿ 64 λзδҲ False ʱR ֱӷؽ
function IsUInt32MulOverflowInt64(A, B: Cardinal; out R: TUInt64): Boolean;
var
  T: Int64;
begin
  T := Int64(A) * Int64(B);
  Result := T < 0; //  Int64 ֵ˵
  if not Result then
    R := TUInt64(T);
end;

// ж 64 λзǷ 64 λз
function IsInt64MulOverflow(A, B: Int64): Boolean;
var
  T: Int64;
begin
  T := A * B;
  Result := (B <> 0) and ((T div B) <> A);
end;

// ָת֧ͣ 32/64 λ
function PointerToInteger(P: Pointer): Integer;
begin
{$IFDEF CPU64BITS}
  // ôд Pointer ĵ 32 λ Integer
  Result := Integer(P);
{$ELSE}
  Result := Integer(P);
{$ENDIF}
end;

// תָ֧ͣ 32/64 λ
function IntegerToPointer(I: Integer): Pointer;
begin
{$IFDEF CPU64BITS}
  // ôд Pointer ĵ 32 λ Integer
  Result := Pointer(I);
{$ELSE}
  Result := Pointer(I);
{$ENDIF}
end;

//  Int64 Χĺ࣬Ҫ N  0
function Int64NonNegativeAddMod(A, B, N: Int64): Int64;
begin
  if IsInt64AddOverflow(A, B) then //  Int64
  begin
    if A > 0 then
    begin
      // A  B  0 UInt64 ȡģδ UInt64 ޣע N δ Int64 ȡģС Int64 ޣɸֵ
      Result := UInt64NonNegativeAddMod(A, B, N);
    end
    else
    begin
      // A  B С 0ȡ UInt64 ȡģĺδ UInt64 ޣģٱһ
{$IFDEF SUPPORT_UINT64}
      Result := UInt64(N) - UInt64NonNegativeAddMod(-A, -B, N);
{$ELSE}
      Result := N - UInt64NonNegativeAddMod(-A, -B, N);
{$ENDIF}
    end;
  end
  else // ֱӼ
    Result := Int64NonNegativeMod(A + B, N);
end;

//  UInt64 Χĺ࣬Ҫ N  0
function UInt64NonNegativeAddMod(A, B, N: TUInt64): TUInt64;
var
  C, D: TUInt64;
begin
  if IsUInt64AddOverflow(A, B) then // 
  begin
    C := UInt64Mod(A, N);  // ͸ģ
    D := UInt64Mod(B, N);
    if IsUInt64AddOverflow(C, D) then
    begin
      // ˵ģ󣬸ģûá
      // һڵ 2^63N  2^63 + 1
      //  =  + 2^64
      //  mod N =  mod N + (2^64 - 1) mod N) + 1
      //  N  2^63 + 1 2^64 - 2ǰӲֱӺһģ
      Result := UInt64Mod(UInt64Mod(A + B, N) + UInt64Mod(CN_MAX_TUINT64, N) + 1, N);
    end
    else
      Result := UInt64Mod(C + D, N);
  end
  else
  begin
    Result := UInt64Mod(A + B, N);
  end;
end;

function Int64NonNegativeMulMod(A, B, N: Int64): Int64;
var
  Neg: Boolean;
begin
  if N <= 0 then
    raise EDivByZero.Create(SDivByZero);

  // ΧСֱ
  if not IsInt64MulOverflow(A, B) then
  begin
    Result := A * B mod N;
    if Result < 0 then
      Result := Result + N;
    Exit;
  end;

  // ŵ
  Result := 0;
  if (A = 0) or (B = 0) then
    Exit;

  Neg := False;
  if (A < 0) and (B > 0) then
  begin
    A := -A;
    Neg := True;
  end
  else if (A > 0) and (B < 0) then
  begin
    B := -B;
    Neg := True;
  end
  else if (A < 0) and (B < 0) then
  begin
    A := -A;
    B := -B;
  end;

  // λѭ
  while B <> 0 do
  begin
    if (B and 1) <> 0 then
      Result := ((Result mod N) + (A mod N)) mod N;

    A := A shl 1;
    if A >= N then
      A := A mod N;

    B := B shr 1;
  end;

  if Neg then
    Result := N - Result;
end;

function UInt64NonNegativeMulMod(A, B, N: TUInt64): TUInt64;
begin
  Result := 0;
  if (UInt64Compare(A, CN_MAX_UINT32) <= 0) and (UInt64Compare(B, CN_MAX_UINT32) <= 0) then
  begin
    Result := UInt64Mod(A * B, N); // 㹻СĻֱӳ˺ģ
  end
  else
  begin
    while B <> 0 do
    begin
      if (B and 1) <> 0 then
        Result := UInt64NonNegativeAddMod(Result, A, N);

      A := UInt64NonNegativeAddMod(A, A, N);
      // ôͳ㷨 A := A shl 1 N  mod NΪ

      B := B shr 1;
    end;
  end;
end;

// װķǸຯҲΪʱӸ豣֤ P  0
function Int64NonNegativeMod(N: Int64; P: Int64): Int64;
begin
  if P <= 0 then
    raise EDivByZero.Create(SDivByZero);

  Result := N mod P;
  if Result < 0 then
    Inc(Result, P);
end;

// Int64 ķǸָ
function Int64NonNegativPower(N: Int64; Exp: Integer): Int64;
var
  T: Int64;
begin
  if Exp < 0 then
    raise ERangeError.Create(SRangeError)
  else if Exp = 0 then
  begin
    if N <> 0 then
      Result := 1
    else
      raise EDivByZero.Create(SDivByZero);
  end
  else if Exp = 1 then
    Result := N
  else
  begin
    Result := 1;
    T := N;

    while Exp > 0 do
    begin
      if (Exp and 1) <> 0 then
        Result := Result * T;

      Exp := Exp shr 1;
      T := T * T;
    end;
  end;
end;

function Int64NonNegativeRoot(N: Int64; Exp: Integer): Int64;
var
  I: Integer;
  X: Int64;
  X0, X1: Extended;
begin
  if (Exp < 0) or (N < 0) then
    raise ERangeError.Create(SRangeError)
  else if Exp = 0 then
    raise EDivByZero.Create(SDivByZero)
  else if (N = 0) or (N = 1) then
    Result := N
  else if Exp = 2 then
    Result := UInt64Sqrt(N)
  else
  begin
    // ţٵ
    I := GetUInt64HighBits(N) + 1; // õԼ Log2 N ֵ
    I := (I div Exp) + 1;
    X := 1 shl I;                  // õһϴ X0 ֵΪʼֵ

    X0 := X;
    X1 := X0 - (Power(X0, Exp) - N) / (Exp * Power(X0, Exp - 1));

    while True do
    begin
      if (Trunc(X0) = Trunc(X1)) and (Abs(X0 - X1) < 0.001) then
      begin
        Result := Trunc(X1); // Trunc ֻ֧ Int64˻
        Exit;
      end;

      X0 := X1;
      X1 := X0 - (Power(X0, Exp) - N) / (Exp * Power(X0, Exp - 1));
    end;
  end;
end;

function UInt64NonNegativPower(N: TUInt64; Exp: Integer): TUInt64;
var
  T, RL, RH: TUInt64;
begin
  if Exp < 0 then
    raise ERangeError.Create(SRangeError)
  else if Exp = 0 then
  begin
    if N <> 0 then
      Result := 1
    else
      raise EDivByZero.Create(SDivByZero);
  end
  else if Exp = 1 then
    Result := N
  else
  begin
    Result := 1;
    T := N;

    while Exp > 0 do
    begin
      if (Exp and 1) <> 0 then
      begin
        UInt64MulUInt64(Result, T, RL, RH);
        Result := RL;
      end;

      Exp := Exp shr 1;
      UInt64MulUInt64(T, T, RL, RH);
      T := RL;
    end;
  end;
end;

function UInt64NonNegativeRoot(N: TUInt64; Exp: Integer): TUInt64;
var
  I: Integer;
  X: TUInt64;
  XN, X0, X1: Extended;
begin
  if Exp < 0 then
    raise ERangeError.Create(SRangeError)
  else if Exp = 0 then
    raise EDivByZero.Create(SDivByZero)
  else if (N = 0) or (N = 1) then
    Result := N
  else if Exp = 2 then
    Result := UInt64Sqrt(N)
  else
  begin
    // ţٵ
    I := GetUInt64HighBits(N) + 1; // õԼ Log2 N ֵ
    I := (I div Exp) + 1;
    X := 1 shl I;                  // õһϴ X0 ֵΪʼֵ

    X0 := UInt64ToExtended(X);
    XN := UInt64ToExtended(N);
    X1 := X0 - (Power(X0, Exp) - XN) / (Exp * Power(X0, Exp - 1));

    while True do
    begin
      if (ExtendedToUInt64(X0) = ExtendedToUInt64(X1)) and (Abs(X0 - X1) < 0.001) then
      begin
        Result := ExtendedToUInt64(X1);
        Exit;
      end;

      X0 := X1;
      X1 := X0 - (Power(X0, Exp) - XN) / (Exp * Power(X0, Exp - 1));
    end;
  end;
end;

function IsUInt128BitSet(Lo, Hi: TUInt64; N: Integer): Boolean;
begin
  if N < 64 then
    Result := (Lo and (TUInt64(1) shl N)) <> 0
  else
  begin
    Dec(N, 64);
    Result := (Hi and (TUInt64(1) shl N)) <> 0;
  end;
end;

procedure SetUInt128Bit(var Lo, Hi: TUInt64; N: Integer);
begin
  if N < 64 then
    Lo := Lo or (TUInt64(1) shl N)
  else
  begin
    Dec(N, 64);
    Hi := Hi or (TUInt64(1) shl N);
  end;
end;

procedure ClearUInt128Bit(var Lo, Hi: TUInt64; N: Integer);
begin
  if N < 64 then
    Lo := Lo and not (TUInt64(1) shl N)
  else
  begin
    Dec(N, 64);
    Hi := Hi and not (TUInt64(1) shl N);
  end;
end;

function UnsignedAddWithLimitRadix(A, B, C: Cardinal; var R: Cardinal;
  L, H: Cardinal): Cardinal;
begin
  R := A + B + C;
  if R > H then         // нλ
  begin
    A := H - L + 1;     // õ
    B := R - L;         // õ L ֵ

    Result := B div A;  // Ƶĵڼͽ
    R := L + (B mod A); // ȥƺ
  end
  else
    Result := 0;
end;

procedure InternalQuickSort(Mem: Pointer; L, R: Integer; ElementByteSize: Integer;
  CompareProc: TCnMemSortCompareProc);
var
  I, J, P: Integer;
begin
  repeat
    I := L;
    J := R;
    P := (L + R) shr 1;
    repeat
      while CompareProc(Pointer(TCnNativeInt(Mem) + I * ElementByteSize),
        Pointer(TCnNativeInt(Mem) + P * ElementByteSize), ElementByteSize) < 0 do
        Inc(I);
      while CompareProc(Pointer(TCnNativeInt(Mem) + J * ElementByteSize),
        Pointer(TCnNativeInt(Mem) + P * ElementByteSize), ElementByteSize) > 0 do
        Dec(J);

      if I <= J then
      begin
        MemorySwap(Pointer(TCnNativeInt(Mem) + I * ElementByteSize),
          Pointer(TCnNativeInt(Mem) + J * ElementByteSize), ElementByteSize);

        if P = I then
          P := J
        else if P = J then
          P := I;
        Inc(I);
        Dec(J);
      end;
    until I > J;

    if L < J then
      InternalQuickSort(Mem, L, J, ElementByteSize, CompareProc);
    L := I;
  until I >= R;
end;

function DefaultCompareProc(P1, P2: Pointer; ElementByteSize: Integer): Integer;
begin
  Result := MemoryCompare(P1, P2, ElementByteSize);
end;

procedure MemoryQuickSort(Mem: Pointer; ElementByteSize: Integer;
  ElementCount: Integer; CompareProc: TCnMemSortCompareProc);
begin
  if (Mem <> nil) and (ElementCount > 0) and (ElementCount > 0) then
  begin
    if Assigned(CompareProc) then
      InternalQuickSort(Mem, 0, ElementCount - 1, ElementByteSize, CompareProc)
    else
      InternalQuickSort(Mem, 0, ElementCount - 1, ElementByteSize, DefaultCompareProc);
  end;
end;

{$IFDEF COMPILER5}

function BoolToStr(Value: Boolean; UseBoolStrs: Boolean): string;
begin
  if UseBoolStrs then
  begin
    if Value then
      Result := 'True'
    else
      Result := 'False';
  end
  else
  begin
    if Value then
      Result := '-1'
    else
      Result := '0';
  end;
end;

{$ENDIF}

// =========================== ѭλ ====================================

function RotateLeft16(A: Word; N: Integer): Word;
begin
  Result := (A shl N) or (A shr (16 - N));
end;

function RotateRight16(A: Word; N: Integer): Word;
begin
  Result := (A shr N) or (A shl (16 - N));
end;

function RotateLeft32(A: Cardinal; N: Integer): Cardinal;
begin
  Result := (A shl N) or (A shr (32 - N));
end;

function RotateRight32(A: Cardinal; N: Integer): Cardinal;
begin
  Result := (A shr N) or (A shl (32 - N));
end;

function RotateLeft64(A: TUInt64; N: Integer): TUInt64;
begin
  Result := (A shl N) or (A shr (64 - N));
end;
function RotateRight64(A: TUInt64; N: Integer): TUInt64;
begin
  Result := (A shr N) or (A shl (64 - N));
end;

initialization
  FByteOrderIsBigEndian := CurrentByteOrderIsBigEndian;

end.
