{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnDFT;
{* |<PRE>
================================================================================
* ƣ
* Ԫƣڸ㸴ɢҶ任Լ Int 64 Ŀ۱任ʵֵԪ
* ԪߣCnPack  (master@cnpack.org)
*     עԪʵ˻ڸ㸴ɢҶ任Լ Int 64 Ŀ۱任
*           ʹÿٸҶ任ʵɢҶ任Լٶʽ˷򸡵ڻʧ
*           ʹÿ۱任û⡣۱任Ҳƣ
*           һǶʽϵΪСģϵ֪δ
*           ǶʽС 2^23Ԫģƣ
*
* ƽ̨Win 7 + Delphi 5.0
* ݲԣδ
*   õԪ豾ػ
* ޸ļ¼2022.06.29 V1.2
*               һάɢұ任任
*           2021.08.29 V1.1
*               ӿ۱任ʹض
*           2020.11.23 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Classes, CnNative, CnComplex, CnMatrix;

procedure ButterflyChangeComplex(CA: PCnComplexArray; Len: Integer);
{* 任ڲԪص˳ԱżΡ

   
     CA: PCnComplexArray                  - ָк任ĸ
     Len: Integer                         - ĸ

   ֵޣ
}

procedure ButterflyChangeInt64(IA: PInt64Array; Len: Integer);
{* 任 Int64 ڲԪص˳ԱżΡ

   
     IA: PInt64Array                      - ָк任 Int64 
     Len: Integer                         -  Int64 

   ֵޣ
}

function CnFFT(Data: PCnComplexArray; Len: Integer): Boolean;
{* ٸҶ任ʽϵתΪֵ飬Ҫȷ Len Ϊ 2 ݡ

   
     Data: PCnComplexArray                - ָпٸҶ任ĸ
     Len: Integer                         - ĸ 2 

   ֵBoolean                        - ر任Ƿɹ
}

function CnIFFT(Data: PCnComplexArray; Len: Integer): Boolean;
{* ٸҶ任ֵתΪʽϵ飬Ҫȷ Len Ϊ 2 ݡ

   
     Data: PCnComplexArray                - ָпٸҶ任ĸ
     Len: Integer                         - ĸ 2 

   ֵBoolean                        - 任Ƿɹ
}

function CnNTT(Data: PInt64Array; Len: Integer): Boolean;
{* ۱任ʽϵ int 64 תΪֵ int64 飬
   עҪȷ Len Ϊ 2 ݣ Data ϵ 0 С CN_P

   
     Data: PInt64Array                    - ָп۱任 Int64 
     Len: Integer                         -  Int64  2 

   ֵBoolean                        - ر任Ƿɹ
}

function CnINTT(Data: PInt64Array; Len: Integer): Boolean;
{* 任ֵ int 64 תΪʽϵ int 64 飬
   עҪȷ Len Ϊ 2 ݣ Data ϵ 0 С CN_P

   
     Data: PInt64Array                    - ָп任 Int64 
     Len: Integer                         -  Int64  2 

   ֵBoolean                        - 任Ƿɹ
}

function CnDCT(Data: PExtendedArray; Res: PExtendedArray; Len: Integer): Boolean;
{* һά DCT 任ɢң Data ָĸһһάɢұ任
    Res ָĸУҪ鳤ȾΪ Lenر任Ƿɹ

   
     Data: PExtendedArray                 - ָһά DCT 任ĸ
     Res: PExtendedArray                  - ָ任ĸ
     Len: Integer                         - ĸ

   ֵBoolean                        - ر任Ƿɹ
}

function CnIDCT(Data: PExtendedArray; Res: PExtendedArray; Len: Integer): Boolean;
{* һά DCT 任ɢң Data ָĸһһάɢұ任
    Res ָĸУҪ鳤ȾΪ Len任Ƿɹ

   
     Data: PExtendedArray                 - ָһά DCT 任ĸ
     Res: PExtendedArray                  - ָ任ĸ
     Len: Integer                         - ĸ

   ֵBoolean                        - 任Ƿɹ
}

function CnGenerateDCT2Matrix(M: TCnFloatMatrix; N: Integer): Boolean;
{*  N ׶ά DCT 任󣬸þΪ

   
     M: TCnFloatMatrix                    - ɵĶά DCT 任
     N: Integer                           - Ľ

   ֵBoolean                        - Ƿɹ
}

function CnDCT2(Data: TCnFloatMatrix; Res: TCnFloatMatrix; DCTM: TCnFloatMatrix = nil;
  DCTMT: TCnFloatMatrix = nil; T: TCnFloatMatrix = nil): Boolean;
{* ά DCT 任ɢң Data ĸһζάɢұ任
    Res ĸУҪΪҳߴȣ
   DCTM/DCTMT ΪԤı任תþT Ϊʱ󣬷ر任Ƿɹ

   
     Data: TCnFloatMatrix                 - жά DCT 任ĸ
     Res: TCnFloatMatrix                  - 
     DCTM: TCnFloatMatrix                 - Ԥı任
     DCTMT: TCnFloatMatrix                - Ԥı任תþ
     T: TCnFloatMatrix                    - ʱ

   ֵBoolean                        - ر任Ƿɹ
}

function CnIDCT2(Data: TCnFloatMatrix; Res: TCnFloatMatrix; DCTM: TCnFloatMatrix = nil;
  DCTMT: TCnFloatMatrix = nil; T: TCnFloatMatrix = nil): Boolean;
{* ά DCT 任ɢң Data ĸһζάɢұ任
    Res ĸУҪΪҳߴȣ
   DCTM/DCTMT ΪԤı任תþT Ϊʱ󣬷任Ƿɹ

   
     Data: TCnFloatMatrix                 - жά DCT 任ĸ
     Res: TCnFloatMatrix                  - 
     DCTM: TCnFloatMatrix                 - Ԥı任
     DCTMT: TCnFloatMatrix                - Ԥı任תþ
     T: TCnFloatMatrix                    - ʱ

   ֵBoolean                        - 任Ƿɹ
}

implementation

uses
  CnPrime;

const
  Pi = 3.1415926535897932384626;

  CN_NR = 1 shl 22;     // 2  23 ηһ룬ֻܴΪ CN_NR Ķʽ
  CN_G = 3;             // ԭ 3
  CN_G_INV = 332748118; // ԭԸԪΪ 332748118
  CN_P = 998244353;     // ѡȡΪ 998244353 = 2^23*119 + 1С Int32 ֵ 2147483647

// 任ڲԪص˳Ҫȷ Len Ϊ 2 
procedure ButterflyChangeComplex(CA: PCnComplexArray; Len: Integer);
var
  I: Integer;
  R: array of Integer;
begin
  if Len <= 1 then
    Exit;

  SetLength(R, Len);
  for I := 0 to Len - 1 do
  begin
    R[I] := R[I shr 1] shr 1;
    if (I and 1) <> 0 then
      R[I] := R[I] or (Len shr 1);
  end;

  for I := 0 to Len - 1 do
  begin
    if I < R[I] then
      ComplexNumberSwap(CA^[I], CA^[R[I]]);
  end;
  SetLength(R, 0);
end;

// 任ڲԪص˳Ҫȷ Len Ϊ 2 
procedure ButterflyChangeInt64(IA: PInt64Array; Len: Integer);
var
  I: Integer;
  R: array of Integer;
  T: Int64;
begin
  if Len <= 1 then
    Exit;

  SetLength(R, Len);
  for I := 0 to Len - 1 do
  begin
    R[I] := R[I shr 1] shr 1;
    if (I and 1) <> 0 then
      R[I] := R[I] or (Len shr 1);
  end;

  for I := 0 to Len - 1 do
  begin
    if I < R[I] then
    begin
      T := IA^[I];
      IA^[I] := IA^[R[I]];
      IA^[R[I]] := T;
    end;
  end;
  SetLength(R, 0);
end;

// ǵݹ鷽ʽʵֵĿٸҶ任任
function FFT(Data: PCnComplexArray; Len: Integer; IsReverse: Boolean): Boolean;
var
  J, T, M, R, K: Integer;
  WN, W, X, Y: TCnComplexNumber;
begin
  Result := False;
  if (Data = nil) or (Len <= 0) then
    Exit;

  // Len  2 
  if not IsUInt32PowerOf2(Cardinal(Len)) then
    Exit;

  if IsReverse then
    T := -1
  else
    T := 1;

  ButterflyChangeComplex(Data, Len);

  M := 1;
  while M < Len do
  begin
    WN.R := Cos(Pi / M);
    WN.I := Sin(Pi / M) * T;

    J := 0;
    R := M shl 1;
    while J < Len do
    begin
      W.R := 1.0;
      W.I := 0;

      K := 0;
      while K < M do
      begin
        ComplexNumberCopy(X, Data^[J + K]);
        ComplexNumberMul(Y, Data^[J + K + M], W);

        ComplexNumberAdd(Data^[J + K], X, Y);
        ComplexNumberSub(Data^[J + K + M], X, Y);

        ComplexNumberMul(W, W, WN);
        Inc(K);
      end;

      J := J + R;
    end;

    M := M shl 1;
  end;

  if IsReverse then
    for J := 0 to Len - 1 do
      ComplexNumberDiv(Data^[J], Data^[J], Len);

  Result := True;
end;

function CnFFT(Data: PCnComplexArray; Len: Integer): Boolean;
begin
  Result := FFT(Data, Len, False);
end;

function CnIFFT(Data: PCnComplexArray; Len: Integer): Boolean;
begin
  Result := FFT(Data, Len, True);
end;

// ǵݹ鷽ʽʵֵĿ۱任任
function NTT(Data: PInt64Array; Len: Integer; IsReverse: Boolean): Boolean;
var
  M, K, J, R: Integer;
  G0, GN, X, Y: Int64;
begin
  Result := False;
  if (Data = nil) or (Len <= 0) or (Len > CN_NR) then
    Exit;

  // Len  2 
  if not IsUInt32PowerOf2(Cardinal(Len)) then
    Exit;

  ButterflyChangeInt64(Data, Len);

  M := 1;
  while M < Len do
  begin
    // MontgomeryPowerMod Ѹ Int64 Ϊ޷ UInt64ϵΪʹ
    if IsReverse then
      GN := MontgomeryPowerMod(CN_G_INV, (CN_P - 1) div (M shl 1), CN_P)
    else
      GN := MontgomeryPowerMod(CN_G, (CN_P - 1) div (M shl 1) , CN_P);

    J := 0;
    R := M shl 1;
    while J < Len do
    begin
      G0 := 1;
      K := 0;

      while K < M do
      begin
        X := Data^[J + K];
        Y := Int64MultipleMod(G0, Data^[J + K + M], CN_P);
        Data^[J + K] := Int64AddMod(X, Y, CN_P);

        X := X - Y;
        if X < 0 then
          X := X + CN_P; // X - Y Ǹ AddMod
        Data^[J + K + M] := X mod CN_P;

        G0 := Int64MultipleMod(G0, GN, CN_P);
        Inc(K);
      end;

      J := J + R;
    end;

    M := M shl 1;
  end;

  if IsReverse then
    for J := 0 to Len - 1 do
      Data^[J] := Data^[J] div Len;

  Result := True;
end;

function CnNTT(Data: PInt64Array; Len: Integer): Boolean;
begin
  Result := NTT(Data, Len, False);
end;

function CnINTT(Data: PInt64Array; Len: Integer): Boolean;
begin
  Result := NTT(Data, Len, True);
end;

function CnDCT(Data, Res: PExtendedArray; Len: Integer): Boolean;
var
  X, U: Integer;
  C: Extended;
begin
  Result := False;
  if (Len <= 0) or (Data = nil) or (Res = nil) then
    Exit;

  Res^[0] := 0;
  for X := 0 to Len - 1 do
    Res^[0] := Res^[0] + Data^[X];

  Res^[0] := Res^[0] / Sqrt(Len); //  F0

  for U := 1 to Len - 1 do
  begin
    //  FU
    Res^[U] := 0;
    for X := 0 to Len - 1 do
    begin
      C := Cos(Pi * U * (2 * X + 1) / (2 * Len));
      Res^[U] := Res^[U] + Data^[X] * C;
    end;
    Res^[U] := Res^[U] * Sqrt(2.0 / Len);
  end;
  Result := True;
end;

function CnIDCT(Data, Res: PExtendedArray; Len: Integer): Boolean;
var
  X, U: Integer;
  A1, A2, C: Extended;
begin
  Result := False;
  if (Len <= 0) or (Data = nil) or (Res = nil) then
    Exit;

  A1 := 1.0 / Sqrt(Len);
  A2 := Sqrt(2.0 / Len);

  for X := 0 to Len - 1 do
  begin
    //  fx
    Res^[X] := 0;
    for U := 0 to Len - 1 do
    begin
      C := Cos(Pi * U * (2 * X + 1) / (2 * Len));
      if U = 0 then
        Res^[X] := Res^[X] + Data^[U] * C * A1
      else
        Res^[X] := Res^[X] + Data^[U] * C * A2;
    end;
  end;
  Result := True;
end;

function CnGenerateDCT2Matrix(M: TCnFloatMatrix; N: Integer): Boolean;
var
  I, J: Integer;
  A1, A2: Extended;
begin
  Result := False;
  if (M = nil) or (N < 2) then
    Exit;

  M.RowCount := N;
  M.ColCount := N;

  A1 := 1.0 / Sqrt(N);
  A2 := Sqrt(2.0 / N);

  for I := 0 to M.RowCount - 1 do
  begin
    for J := 0 to M.ColCount - 1 do
    begin
      M.Value[I, J] := Cos(I * (J + 0.5) * Pi / N);

      if I = 0 then
        M.Value[I, J] := M.Value[I, J] * A1
      else
        M.Value[I, J] := M.Value[I, J] * A2;
    end;
  end;
  Result := True;
end;

function CnDCT2(Data, Res: TCnFloatMatrix; DCTM: TCnFloatMatrix;
  DCTMT: TCnFloatMatrix; T: TCnFloatMatrix): Boolean;
var
  MIsNil, MTIsNil, TIsNil: Boolean;
begin
  // Res := M * Data * M'
  Result := False;
  if (Data = nil) or (Res = nil) then
    Exit;

  if Data.RowCount <> Data.ColCount then
    Exit;

  MIsNil := DCTM = nil;
  MTIsNil := DCTMT = nil;
  TIsNil := T = nil;

  try
    if MIsNil then
    begin
      DCTM := TCnFloatMatrix.Create;
      CnGenerateDCT2Matrix(DCTM, Data.RowCount);
    end;

    if MTIsNil then
    begin
      DCTMT := TCnFloatMatrix.Create;
      CnMatrixTranspose(DCTM, DCTMT);
    end;

    if TIsNil then
      T := TCnFloatMatrix.Create;

    CnMatrixMul(DCTM, Data, T);
    CnMatrixMul(T, DCTMT, Res);

    Result := True;
  finally
    if TIsNil then
      T.Free;
    if MIsNil then
      DCTM.Free;
    if MTIsNil then
      DCTMT.Free;
  end;
end;

function CnIDCT2(Data, Res: TCnFloatMatrix; DCTM: TCnFloatMatrix;
  DCTMT: TCnFloatMatrix; T: TCnFloatMatrix): Boolean;
var
  MIsNil, MTIsNil, TIsNil: Boolean;
begin
  // Res := M' * Data * M
  Result := False;
  if (Data = nil) or (Res = nil) then
    Exit;

  if Data.RowCount <> Data.ColCount then
    Exit;

  MIsNil := DCTM = nil;
  MTIsNil := DCTMT = nil;
  TIsNil := T = nil;

  try
    if MIsNil then
    begin
      DCTM := TCnFloatMatrix.Create;
      CnGenerateDCT2Matrix(DCTM, Data.RowCount);
    end;

    if MTIsNil then
    begin
      DCTMT := TCnFloatMatrix.Create;
      CnMatrixTranspose(DCTM, DCTMT);
    end;

    if TIsNil then
      T := TCnFloatMatrix.Create;

    CnMatrixMul(DCTMT, Data, T);
    CnMatrixMul(T, DCTM, Res);

    Result := True;
  finally
    if TIsNil then
      T.Free;
    if MIsNil then
      DCTM.Free;
    if MTIsNil then
      DCTMT.Free;
  end;
end;

end.
