{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnComplex;
{* |<PRE>
================================================================================
* ƣ
* Ԫƣ㸴ʵֵԪ
* ԪߣCnPack  (master@cnpack.org)
*     עԪʵչȸĸṹ TCnComplexNumber 㡣
*           ΪЧʣʹ record  TObject
* ƽ̨Win 7 + Delphi 5.0
* ݲԣδ
*   õԪ豾ػ
* ޸ļ¼2023.06.26 V1.1
*               ӷֵȺ
*           2020.11.20 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Classes, SysUtils, SysConst, Math, CnMath;

type
  ECnComplexNumberException = class(Exception);
  {* ص쳣}

  TCnComplexNumber = packed record
  {* 㾫ȵĸʾṹ}
    R: Extended;
    {* ʵ}
    I: Extended;
    {* 鲿}
  end;
  PCnComplexNumber = ^TCnComplexNumber;
  {* ָṹָ}

  TCnComplexArray = array[0..8191] of TCnComplexNumber;
  {* ṹ}

  PCnComplexArray = ^TCnComplexArray;
  {* ָṹָ}

function ComplexNumberIsZero(var Complex: TCnComplexNumber): Boolean;
{* ظǷΪ 0

   
     var Complex: TCnComplexNumber        - жϵĸ

   ֵBoolean                        - Ƿ 0
}

procedure ComplexNumberSetZero(var Complex: TCnComplexNumber);
{*  0

   
     var Complex: TCnComplexNumber        - õĸ

   ֵޣ
}

procedure ComplexNumberSetValue(var Complex: TCnComplexNumber;
  AR: Extended; AI: Extended); overload;
{* ֵ

   
     var Complex: TCnComplexNumber        - ֵĸ
     AR: Extended                         - ʵ
     AI: Extended                         - 鲿

   ֵޣ
}

procedure ComplexNumberSetValue(var Complex: TCnComplexNumber;
  const AR: string; const AI: string); overload;
{* ֵ

   
     var Complex: TCnComplexNumber        - ֵĸ
     const AR: string                     - ʵĸַʽ
     const AI: string                     - 鲿ĸַʽ

   ֵޣ
}

function ComplexNumberToString(var Complex: TCnComplexNumber): string;
{* תΪ a + bi ַʵ鲿 0 Ӧʡԡ

   
     var Complex: TCnComplexNumber        - תĸ

   ֵstring                         - ظַʽ
}

function ComplexNumberEqual(var Complex1: TCnComplexNumber; var Complex2: TCnComplexNumber): Boolean;
{* жֵǷȡ

   
     var Complex1: TCnComplexNumber       - Ƚϵĸһ
     var Complex2: TCnComplexNumber       - Ƚϵĸ

   ֵBoolean                        - ֵǷ
}

procedure ComplexNumberSwap(var Complex1: TCnComplexNumber; var Complex2: TCnComplexNumber);
{* ֵ

   
     var Complex1: TCnComplexNumber       - ĸһ
     var Complex2: TCnComplexNumber       - ĸ

   ֵޣ
}

procedure ComplexNumberCopy(var Dst: TCnComplexNumber; var Src: TCnComplexNumber);
{* Ƹֵ

   
     var Dst: TCnComplexNumber            - Ŀ긴
     var Src: TCnComplexNumber            - Դ

   ֵޣ
}

procedure ComplexNumberAdd(var Res: TCnComplexNumber;
  var Complex1: TCnComplexNumber; var Complex2: TCnComplexNumber); overload;
{* ӷComplex1  Complex2 ͬһṹRes  Complex1  Complex2

   
     var Res: TCnComplexNumber            - 
     var Complex1: TCnComplexNumber       - һ
     var Complex2: TCnComplexNumber       - 

   ֵޣ
}

procedure ComplexNumberSub(var Res: TCnComplexNumber;
  var Complex1: TCnComplexNumber; var Complex2: TCnComplexNumber); overload;
{* Complex1  Complex2 ͬһṹRes  Complex1  Complex2

   
     var Res: TCnComplexNumber            - 
     var Complex1: TCnComplexNumber       - 
     var Complex2: TCnComplexNumber       - 

   ֵޣ
}

procedure ComplexNumberMul(var Res: TCnComplexNumber;
  var Complex1: TCnComplexNumber; var Complex2: TCnComplexNumber); overload;
{* ˷Complex1  Complex2 ͬһṹRes  Complex1  Complex2

   
     var Res: TCnComplexNumber            - 
     var Complex1: TCnComplexNumber       - һ
     var Complex2: TCnComplexNumber       - 

   ֵޣ
}

procedure ComplexNumberDiv(var Res: TCnComplexNumber;
  var Complex1: TCnComplexNumber; var Complex2: TCnComplexNumber); overload;
{* Complex1  Complex2 ͬһṹRes  Complex1  Complex2

   
     var Res: TCnComplexNumber            - 
     var Complex1: TCnComplexNumber       - 
     var Complex2: TCnComplexNumber       - 

   ֵޣ
}

procedure ComplexNumberAdd(var Res: TCnComplexNumber;
  var Complex: TCnComplexNumber; Value: Extended); overload;
{* 븡ļӷComplex  Res ͬһṹ

   
     var Res: TCnComplexNumber            - 
     var Complex: TCnComplexNumber        - 
     Value: Extended                      - 

   ֵޣ
}

procedure ComplexNumberSub(var Res: TCnComplexNumber;
  var Complex: TCnComplexNumber; Value: Extended); overload;
{* 븡ļComplex  Res ͬһṹ

   
     var Res: TCnComplexNumber            - 
     var Complex: TCnComplexNumber        - 
     Value: Extended                      - 

   ֵޣ
}

procedure ComplexNumberMul(var Res: TCnComplexNumber;
  var Complex: TCnComplexNumber; Value: Extended); overload;
{* 븡ĳ˷Complex  Res ͬһṹ

   
     var Res: TCnComplexNumber            - 
     var Complex: TCnComplexNumber        - 
     Value: Extended                      - 

   ֵޣ
}

procedure ComplexNumberDiv(var Res: TCnComplexNumber;
  var Complex: TCnComplexNumber; Value: Extended); overload;
{* 븡ĳComplex  Res ͬһṹ

   
     var Res: TCnComplexNumber            - 
     var Complex: TCnComplexNumber        - 
     Value: Extended                      - 

   ֵޣ
}

procedure ComplexNumberSqrt(var Res: TCnComplexNumber; var Complex: TCnComplexNumber);
{* ƽֻһҪһʵ鲿ȡС

   
     var Res: TCnComplexNumber            - ƽ
     var Complex: TCnComplexNumber        - ƽĸ

   ֵޣ
}

procedure ComplexConjugate(var Res: TCnComplexNumber; var Complex: TCnComplexNumber);
{* ùRes  Complex

   
     var Res: TCnComplexNumber            - Ĺ
     var Complex: TCnComplexNumber        - ĸ

   ֵޣ
}

function ComplexIsPureReal(var Complex: TCnComplexNumber): Boolean;
{* ǷʵҲж鲿ǷΪ 0

   
     var Complex: TCnComplexNumber        - жϵĸ

   ֵBoolean                        - Ƿʵ
}

function ComplexIsPureImaginary(var Complex: TCnComplexNumber): Boolean;
{* ǷҲжʵǷΪ 0 鲿Ϊ 0

   
     var Complex: TCnComplexNumber        - жϵĸ

   ֵBoolean                        - Ƿ
}

function ComplexNumberAbsolute(var Complex: TCnComplexNumber): Extended;
{* ظľֵҲิƽԭľ롣

   
     var Complex: TCnComplexNumber        - ĸ

   ֵExtended                       - ظľֵ

}

function ComplexNumberArgument(var Complex: TCnComplexNumber): Extended;
{* ظķֵҲ븴ƽ X ļнǣΧ 0  2С

   
     var Complex: TCnComplexNumber        - ĸ

   ֵExtended                       - ظķֵλΪ
}

procedure ComplexNumberSetAbsoluteArgument(var Complex: TCnComplexNumber;
  AnAbsolute: Extended; AnArgument: Extended);
{* һľֵֵ

   
     var Complex: TCnComplexNumber        - õĸ
     AnAbsolute: Extended                 - õľֵ
     AnArgument: Extended                 - õķֵ

   ֵޣ
}

var
  CnComplexZero: TCnComplexNumber;
  {*  0}

  CnComplexOne: TCnComplexNumber;
  {*  1}

  CnComplexOneI: TCnComplexNumber;
  {*  i}

  CnComplexNegOneI: TCnComplexNumber;
  {*  -i}

implementation

function ComplexNumberIsZero(var Complex: TCnComplexNumber): Boolean;
begin
  Result := (Complex.R = 0) and (Complex.I = 0);
end;

procedure ComplexNumberSetZero(var Complex: TCnComplexNumber);
begin
  Complex.R := 0.0;
  Complex.I := 0.0;
end;

procedure ComplexNumberSetValue(var Complex: TCnComplexNumber; AR, AI: Extended);
begin
  Complex.R := AR;
  Complex.I := AI;
end;

procedure ComplexNumberSetValue(var Complex: TCnComplexNumber;
  const AR, AI: string);
begin
  ComplexNumberSetZero(Complex);
  if (AR = '') and (AI = '') then
    Exit
  else if AR = '' then
    Complex.I := StrToFloat(AI)
  else if AI = '' then
    Complex.R := StrToFloat(AR)
  else
    ComplexNumberSetValue(Complex, StrToFloat(AR), StrToFloat(AI));
end;

function ComplexNumberToString(var Complex: TCnComplexNumber): string;
begin
  if ComplexIsPureReal(Complex) then
    Result := Format('%f', [Complex.R])
  else if ComplexIsPureImaginary(Complex) then
    Result := Format('%fi', [Complex.I])
  else if Complex.I < 0 then
    Result := Format('%f%fi', [Complex.R, Complex.I])
  else
    Result := Format('%f+%fi', [Complex.R, Complex.I]);
end;

function ComplexNumberEqual(var Complex1, Complex2: TCnComplexNumber): Boolean;
begin
  Result := FloatEqual(Complex1.R, Complex2.R) and FloatEqual(Complex1.I, Complex2.I);
end;

procedure ComplexNumberSwap(var Complex1, Complex2: TCnComplexNumber);
var
  T: Extended;
begin
  T := Complex1.R;
  Complex1.R := Complex2.R;
  Complex2.R := T;

  T := Complex1.I;
  Complex1.I := Complex2.I;
  Complex2.I := T;
end;

procedure ComplexNumberCopy(var Dst, Src: TCnComplexNumber);
begin
  Dst.R := Src.R;
  Dst.I := Src.I;
end;

procedure ComplexNumberAdd(var Res: TCnComplexNumber;
  var Complex1, Complex2: TCnComplexNumber);
begin
  Res.R := Complex1.R + Complex2.R;
  Res.I := Complex1.I + Complex2.I;
end;

procedure ComplexNumberSub(var Res: TCnComplexNumber;
  var Complex1, Complex2: TCnComplexNumber);
begin
  Res.R := Complex1.R - Complex2.R;
  Res.I := Complex1.I - Complex2.I;
end;

procedure ComplexNumberMul(var Res: TCnComplexNumber;
  var Complex1, Complex2: TCnComplexNumber);
var
  T: Extended;
begin
  T := Complex1.R * Complex2.R - Complex1.I * Complex2.I;
  Res.I := Complex1.R * Complex2.I + Complex1.I * Complex2.R;
  Res.R := T;
end;

procedure ComplexNumberDiv(var Res: TCnComplexNumber;
  var Complex1, Complex2: TCnComplexNumber);
var
  T, D: Extended;
begin
  D := Complex2.R * Complex2.R + Complex2.I * Complex2.I;
  if FloatEqual(D, 0.0) then
    raise EZeroDivide.Create(SZeroDivide);

  T := (Complex1.R * Complex2.R + Complex1.I * Complex2.I) / D;
  Res.I := (Complex1.I * Complex2.R - Complex1.R * Complex2.I) / D;
  Res.R := T;
end;

procedure ComplexNumberAdd(var Res: TCnComplexNumber;
  var Complex: TCnComplexNumber; Value: Extended); overload;
begin
  Res.R := Complex.R + Value;
  Res.I := Complex.I;
end;

procedure ComplexNumberSub(var Res: TCnComplexNumber;
  var Complex: TCnComplexNumber; Value: Extended); overload;
begin
  Res.R := Complex.R - Value;
  Res.I := Complex.I;
end;

procedure ComplexNumberMul(var Res: TCnComplexNumber;
  var Complex: TCnComplexNumber; Value: Extended); overload;
begin
  Res.R := Complex.R * Value;
  Res.I := Complex.I;
end;

procedure ComplexNumberDiv(var Res: TCnComplexNumber;
  var Complex: TCnComplexNumber; Value: Extended); overload;
begin
  Res.R := Complex.R / Value;
  Res.I := Complex.I;
end;

procedure ComplexNumberSqrt(var Res: TCnComplexNumber; var Complex: TCnComplexNumber);
var
  R, A: Extended;
begin
  R := FloatSqrt(ComplexNumberAbsolute(Complex));
  A := ComplexNumberArgument(Complex) / 2;

  ComplexNumberSetAbsoluteArgument(Res, R, A);
end;

procedure ComplexConjugate(var Res, Complex: TCnComplexNumber);
begin
  Res.R := Complex.R;
  Res.I := -Complex.I;
end;

function ComplexIsPureReal(var Complex: TCnComplexNumber): Boolean;
begin
  Result := FloatEqual(Complex.I, 0.0);
end;

function ComplexIsPureImaginary(var Complex: TCnComplexNumber): Boolean;
begin
  Result := FloatEqual(Complex.R, 0.0) and not FloatEqual(Complex.I, 0.0);
end;

function ComplexNumberAbsolute(var Complex: TCnComplexNumber): Extended;
begin
  Result := Sqrt(Complex.R * Complex.R + Complex.I * Complex.I);
end;

function ComplexNumberArgument(var Complex: TCnComplexNumber): Extended;
begin
  if Complex.I = 0 then
  begin
    if Complex.R >= 0 then     // ʵǷ 0 0 Ҳպŷ 0
      Result := 0
    else
      Result := CN_PI;         // ʵǷ 
  end
  else if Complex.R = 0 then
  begin
    if Complex.I > 0 then      // Ƿذ 
      Result := CN_PI / 2
    else
      Result := CN_PI + CN_PI / 2;   // Ƿ 3/2
  end
  else // ʵ鲿Ϊ 0
  begin
    Result := ArcTan2(Complex.I, Complex.R);
    if Result < 0 then
      Result := Result + CN_PI * 2;
  end;
end;

procedure ComplexNumberSetAbsoluteArgument(var Complex: TCnComplexNumber;
  AnAbsolute, AnArgument: Extended);
begin
  Complex.R := AnAbsolute * Cos(AnArgument);
  Complex.I := AnAbsolute * Sin(AnArgument);
end;

initialization
  ComplexNumberSetZero(CnComplexZero);

  CnComplexOne.R := 1;
  CnComplexOne.I := 0;

  CnComplexOneI.R := 0;
  CnComplexOneI.I := 1;

  CnComplexNegOneI.R := 0;
  CnComplexNegOneI.I := -1;

end.
