{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnBits;
{* |<PRE>
================================================================================
* ƣ
* ԪƣλԪ
* ԪߣCnPack 
*     עԪʵλBitװȲʵ TCnBitsֻ֧λ
*           ݣֲ֧ɾ
*           ˳£
*
*            0 ֽ  1 ֽ
*           +--------+-------+
*           |76543210|FEDCBA9| ...
*           +--------+-------+
*
* ƽ̨Win7 + Delphi 5.0
* ݲԣδ
*   õԪ豾ػ
* ޸ļ¼2023.09.09 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Classes, SysUtils, CnNative;

type
// =============================================================================
//  λװ࣬ Bit ṩ˳
//
//   0 ֽ  1 ֽ
//  +--------+-------+
//  |76543210|FEDCBA9| ...
//  +--------+-------+
//
// =============================================================================

  TCnBitBuilder = class
  {* λװֻ֧࣬ݣֲ֧ɾ}
  private
    FData: TBytes;
    FMaxByteCapacity: Integer;
    FBitLength: Integer;
    function GetByteCapacity: Integer;
    procedure SetByteCapacity(const Value: Integer);
    procedure SetByteLength(const Value: Integer);
    function GetByteLength: Integer;
    function GetBit(Index: Integer): Boolean;
    procedure SetBit(Index: Integer; const Value: Boolean);
    procedure SetBitLength(const Value: Integer);
  protected
    procedure ExpandCapacity;
    {* չȱ֤ ByteLength չٷ֮ʮ}

    procedure EnsureCapacity(ABitSize: Integer);
    {* ȷ ABitSize õĵð취 FBitLength + Delta

       
         const ABitSize: Integer          - ȷ ABitSize 

       ֵޣ
    }
  public
    constructor Create; virtual;
    {* 캯}
    destructor Destroy; override;
    {}

    procedure Clear;
    {* }

    function ToString: string; {$IFDEF OBJECT_HAS_TOSTRING} override; {$ENDIF}
    {* λתɰ 0  1 ַ

       
         ޣ

       ֵstring                     - ذλתɰ 0  1 ַ
    }

    procedure AppendBit(Value: Boolean);
    {* һλ

       
         Value: Boolean                   - λǷ 1

       ֵޣ
    }

    procedure AppendByteRange(Value: Byte; MaxRange: Integer);
    {* һֽе 0  MaxRange λ

       
         Value: Byte                      - ӵֵֽ
         MaxRange: Integer                - ӵλΧ0  7

       ֵޣ
    }

    procedure AppendWordRange(Value: Word; MaxRange: Integer);
    {* һ˫ֽе 0  MaxRange λ

       
         Value: Word                      - ӵ˫ֵֽ
         MaxRange: Integer                - ӵλΧ0  15

       ֵޣ
    }

    procedure AppendDWordRange(Value: Cardinal; MaxRange: Integer);
    {* һֽе 0  MaxRange λ

       
         Value: Cardinal                  - ӵֵֽ
         MaxRange: Integer                - ӵλΧ0  31

       ֵޣ
    }

    procedure AppendByte(Value: Byte; Full: Boolean = True);
    {* һֽFull ʾ 8 λȥǺԸλ 0

       
         Value: Byte                      - ӵֵֽ
         Full: Boolean                    -  8 λǺԸλ 0

       ֵޣ
    }

    procedure AppendWord(Value: Word; Full: Boolean = True);
    {* һ˫ֽFull ʾ 16 λȥǺԸλ 0

       
         Value: Word                      - ӵ˫ֵֽ
         Full: Boolean                    -  16 λǺԸλ 0

       ֵޣ
    }

    procedure AppendDWord(Value: Cardinal; Full: Boolean = True);
    {* һֽFull ʾ 32 λȥǺԸλ 0

       
         Value: Cardinal                  - ӵֵֽ
         Full: Boolean                    -  32 λǺԸλ 0

       ֵޣ
    }

    procedure AppendBytes(Value: TBytes);
    {* һֽ

       
         Value: TBytes                    - ӵֽ

       ֵޣ
    }

    procedure AppendData(Data: Pointer; DataByteLen: Integer);
    {* һݿ

       
         Data: Pointer                    - ӵݿַ
         DataByteLen: Integer             - ӵݿֽڳ

       ֵޣ
    }

    function ToBytes: TBytes;
    {* ȫƴճֽ鲢أλֽϴ

       
         ޣ

       ֵTBytes                     - ȫתֽ
    }

    procedure SetBytes(Data: TBytes);
    {* ֽΪλݡ

       
         Data: TBytes                     - õֽ

       ֵޣ
    }

    function ReadFrom(AMem: Pointer; AByteLength: Integer): Integer;
    {* ڴȫݣضֽڳȡ

       
         AMem: Pointer                    - ڴַ
         AByteLength: Integer             - ֽڳ

       ֵInteger                    - سɹֽڳ
    }

    function WriteTo(AMem: Pointer): Integer;
    {* ȫдָڴ򣬷дֽڳȣ AMem  nil 򷵻ĳȡ

       
         AMem: Pointer                    - дڴַ

       ֵInteger                    - дֽڳ
    }

    function Copy(Index: Integer; Count: Integer): Cardinal;
    {* ָ Index  Count λУCount ޷쳣

       
         Index: Integer                   - Ƶʼλƫ
         Count: Integer                   - Ƶλܴ 32

       ֵCardinal                   - Ƶ
    }

    property Bit[Index: Integer]: Boolean read GetBit write SetBit;
    {* λݣ1 Ϊ True0 Ϊ FalseΧΪ 0  BitLength - 1}

    property ByteCapacity: Integer read GetByteCapacity write SetByteCapacity;
    {* ֽΪλڲʱܱ ByteLength С}

    property ByteLength: Integer read GetByteLength write SetByteLength;
    {* ֽΪλڲѾƴյʵݳȣ BitLength }

    property MaxByteCapacity: Integer read FMaxByteCapacity;
    {* ֽΪλĿõ}

    property BitLength: Integer read FBitLength write SetBitLength;
    {* λΪλʵݳ}
  end;

implementation

resourcestring
  SCnErrorByteCapacityFmt = 'Error New Capacity or Length Value %d';
  SCnErrorBitIndexFmt = 'Invalid Bit Index %d';
  SCnErrorBitTooLargeFmt = 'Bit Count Too Large %d';

const
  BIT_BUILDER_DEFAULT_CAPACITY = 16;

{ TCnBitBuilder }

procedure TCnBitBuilder.AppendBit(Value: Boolean);
begin
  Inc(FBitLength);
  EnsureCapacity(FBitLength);
  if Value then
    FData[GetByteLength - 1] := FData[GetByteLength - 1] or (1 shl ((FBitLength - 1) mod 8))
  else
    FData[GetByteLength - 1] := FData[GetByteLength - 1] and not (1 shl ((FBitLength - 1) mod 8));
end;

procedure TCnBitBuilder.AppendByte(Value: Byte; Full: Boolean);
var
  K, I: Integer;
begin
  K := 7;
  if not Full then
    K := GetUInt8HighBits(Value);

  if K < 0 then
    Exit;

  for I := 0 to K do
    AppendBit((Value and (1 shl I)) <> 0);
end;

procedure TCnBitBuilder.AppendByteRange(Value: Byte; MaxRange: Integer);
var
  I: Integer;
begin
  if MaxRange < 0 then
    Exit;

  if MaxRange > 7 then
    MaxRange := 7;

  for I := 0 to MaxRange do
    AppendBit((Value and (1 shl I)) <> 0);
end;

procedure TCnBitBuilder.AppendBytes(Value: TBytes);
var
  I: Integer;
begin
  if Length(Value) <= 0 then
    Exit;

  for I := 0 to Length(Value) - 1 do
    AppendByte(Value[I]);
end;

procedure TCnBitBuilder.AppendData(Data: Pointer; DataByteLen: Integer);
var
  I: Integer;
  P: PByte;
begin
  if (Data <> nil) and (DataByteLen > 0) then
  begin
    P := PByte(Data);
    for I := 0 to DataByteLen - 1 do
    begin
      AppendByte(P^);
      Inc(P);
    end;
  end;
end;

procedure TCnBitBuilder.AppendDWord(Value: Cardinal; Full: Boolean);
var
  H3, H2, H1, H0: Byte;
begin
  H3 := (Value and $FF000000) shr 24;
  H2 := (Value and $00FF0000) shr 16;
  H1 := (Value and $0000FF00) shr 8;
  H0 := Value and $000000FF;

  AppendByte(H0, Full or (H3 * H2 * H1 <> 0)); // иλڵĻλ Full
  AppendByte(H1, Full or (H3 * H2 <> 0));
  AppendByte(H2, Full or (H3 <> 0));
  AppendByte(H3, Full);
end;

procedure TCnBitBuilder.AppendDWordRange(Value: Cardinal; MaxRange: Integer);
var
  I: Integer;
begin
  if MaxRange < 0 then
    Exit;

  if MaxRange > 31 then
    MaxRange := 31;

  for I := 0 to MaxRange do
    AppendBit((Value and (1 shl I)) <> 0);
end;

procedure TCnBitBuilder.AppendWord(Value: Word; Full: Boolean);
var
  H, L: Byte;
begin
  H := (Value and $FF00) shr 8;
  L := Value and $FF;

  AppendByte(L, Full or (H <> 0)); // иλڵĻ 8 λ Full
  AppendByte(H, Full);
end;

procedure TCnBitBuilder.AppendWordRange(Value: Word; MaxRange: Integer);
var
  I: Integer;
begin
  if MaxRange < 0 then
    Exit;

  if MaxRange > 15 then
    MaxRange := 15;

  for I := 0 to MaxRange do
    AppendBit((Value and (1 shl I)) <> 0);
end;

procedure TCnBitBuilder.Clear;
begin
  FBitLength := 0;
  ByteCapacity := BIT_BUILDER_DEFAULT_CAPACITY;
end;

function TCnBitBuilder.Copy(Index: Integer; Count: Integer): Cardinal;
var
  I: Integer;
begin
  if Count > SizeOf(Cardinal) * 8 then
    raise ERangeError.CreateFmt(SCnErrorBitTooLargeFmt, [Count]);

  Result := 0;
  for I := Index to Index + Count - 1 do
  begin
    if Bit[I] then
      Result := Result or (1 shl (I - Index))
    else
      Result := Result and not (1 shl (I - Index));
  end;
end;

constructor TCnBitBuilder.Create;
begin
  inherited;
  FMaxByteCapacity := MaxInt div 2;
  ByteCapacity := BIT_BUILDER_DEFAULT_CAPACITY;
  FBitLength := 0;
end;

destructor TCnBitBuilder.Destroy;
begin
  SetLength(FData, 0);
  inherited;
end;

procedure TCnBitBuilder.EnsureCapacity(ABitSize: Integer);
begin
  while ByteCapacity * 8 < ABitSize do // Ҫõʵλߴ糬˶ֽ̬ڳ
    ExpandCapacity;
end;

procedure TCnBitBuilder.ExpandCapacity;
var
  NC: Integer;
begin
  NC := (ByteCapacity * 3) div 2;
  if ByteLength > NC then
    NC := ByteLength * 2;
  if NC > FMaxByteCapacity then
    NC := FMaxByteCapacity;
  if NC < 0 then
    NC := ByteLength;

  ByteCapacity := NC; // ʵʵͬ ByteCapacity
end;

function TCnBitBuilder.GetBit(Index: Integer): Boolean;
begin
  if (Index >= 0) and (Index < FBitLength) then
    Result := (FData[Index div 8] and (1 shl (Index mod 8))) <> 0
  else
    raise ERangeError.CreateFmt(SCnErrorBitIndexFmt, [Index]);
end;

function TCnBitBuilder.GetByteCapacity: Integer;
begin
  Result := Length(FData);
end;

function TCnBitBuilder.GetByteLength: Integer;
begin
  Result := (FBitLength + 7) div 8;
end;

function TCnBitBuilder.ReadFrom(AMem: Pointer; AByteLength: Integer): Integer;
begin
  Result := 0;
  Clear;

  if (AMem = nil) or (AByteLength <= 0) then
    Exit;

  ByteLength := AByteLength;
  Move(AMem^, FData[0], AByteLength);
  Result := AByteLength;
end;

procedure TCnBitBuilder.SetBit(Index: Integer; const Value: Boolean);
begin
  if (Index >= 0) and (Index < FBitLength) then
  begin
    if Value then
      FData[Index div 8] := FData[Index div 8] or (1 shl (Index mod 8))
    else
      FData[Index div 8] := FData[Index div 8] and not (1 shl (Index mod 8));
  end
  else
    raise ERangeError.CreateFmt(SCnErrorBitIndexFmt, [Index]);
end;

procedure TCnBitBuilder.SetBitLength(const Value: Integer);
begin
  FBitLength := Value;
  EnsureCapacity(FBitLength);
end;

procedure TCnBitBuilder.SetByteCapacity(const Value: Integer);
begin
  if (Value < GetByteLength) or (Value > FMaxByteCapacity) then
    raise ERangeError.CreateResFmt(@SCnErrorByteCapacityFmt, [Value]);

  SetLength(FData, Value);
end;

procedure TCnBitBuilder.SetByteLength(const Value: Integer);
begin
  FBitLength := Value * 8;
  EnsureCapacity(FBitLength);
end;

procedure TCnBitBuilder.SetBytes(Data: TBytes);
begin
  ByteLength := Length(Data);
  if FBitLength > 0 then
    Move(Data[0], FData[0], Length(Data));
end;

function TCnBitBuilder.ToBytes: TBytes;
begin
  SetLength(Result, GetByteLength);
  if Length(Result) > 0 then
    Move(FData[0], Result[0], Length(Result));
end;

function TCnBitBuilder.ToString: string;
var
  I: Integer;
begin
  SetLength(Result, FBitLength);
  if FBitLength > 0 then
  begin
    for I := 0 to FBitLength - 1 do
    begin
      if Bit[I] then
        Result[I + 1] := '1'
      else
        Result[I + 1] := '0';
    end;
  end;
end;

function TCnBitBuilder.WriteTo(AMem: Pointer): Integer;
begin
  Result := GetByteLength;
  if (AMem <> nil) and (Result > 0) then
    Move(FData[0], AMem^, Result);
end;

end.
