{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnAEAD;
{* |<PRE>
================================================================================
* ƣ
* Ԫƣ AEAD ʵֵԪ
* ԪߣCnPack 
*     עAEAD ǹ֤ܵļơԿʼȶ
*           ݽм֤ݣʱ֤ͨʧܡ
*
*           ĿǰԪʵ GHash128Ҳ GMACԼ CMACʵ
*           AES128/192/256/SM4  GCM/CCM CCM  CMAC ͵ CMAC ͬ
*
*           GCM οĵThe Galois/Counter Mode of Operation (GCM)Լ
*           NIST Special Publication 800-38DԼ RFC 8998 
*
*           CMAC οĵ NIST Special Publication 800-38B:
*           Recommendation for Block Cipher Modes of Operation:
*           The CMAC Mode for Authentication Լ RFC 4993 (AES-128)
*
*           CCM οĵ NIST Special Publication 800-38C:
*          Recommendation for Block Cipher Modes of Operation:
*           The CCM Mode for Authentication and Confidentiality
*           Լ RFC 3610 (AES-128)RFC 8998  SM4-CCM
*
*           ע CCM ڵĲժҪ CCM_M_LEN ĳȵֽڳ CCM_L_LEN
*           NIST 800-38C  48RFC 3610  82RFC 8998  16
*           ͬ˵ͬ޷ͨ CCM ȷӽܡ
*
*           䣺Java  AES/GCM/NoPadding ļܷʽʹ AES256-GCM
*            16 ֽڵ Tag ƴĺһ
*
*           Ԫе NonceIv ȻҲгʼڲֱӲضʹ 16 ֽڣ
*           Ǹݳֱ 12 ֽڻ GHash  16 ֽںȡǰ 12 ֽڣƴ
*           ֽڵļΪͳ Iv ʹá
*
*           עֽڴתΪʱ൱ڴ˱﷨Խ±ָԽλĵַ
*
* ƽ̨PWinXP + Delphi 5.0
* ݲԣPWinXP/7 + Delphi 5/6
*   õԪеַϱػʽ
* ޸ļ¼2024.05.09 V1.3
*                AES/SM4 GCM ʮƵļӽܺ
*           2022.07.31 V1.2
*                ChaCha20-Poly1305  XChaCha20-Poly1305 㷨
*           2022.10.22 V1.1
*                AES192/256  Key ܱضϵ⣬ Tag ƴĺĴ
*           2022.07.27 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Classes, CnPoly1305, CnNative;

const
  CN_AEAD_BLOCK  = 16;
  {* GHASH/GCM/CMAC Լ AES/SM4 ȵķ鳤ȣΪ 16 ֽ}

  CN_GCM_NONCE_LENGTH = 12;
  {* 12 ֽڵ Nonce ƴ Iv}

  CN_CCM_M_LEN = 8;
  {* CCM ֤ Tag Ĭϳ 12 ֽڣȡֵΧ 4  16ʵʴŵ (M - 2) / 2}

  CN_CCM_L_LEN = 2;
  {* ĳռֽȡֵΧ 2  88  Int64ʵʴŵ L - 1}

  CN_CCM_NONCE = 15 - CN_CCM_L_LEN;
  {* CCM  Nonce }

type
  TCn128BitsBuffer = array[0..CN_AEAD_BLOCK - 1] of Byte;
  {* AEAD  128 λķֿ}

  TCnGHash128Key = array[0..CN_AEAD_BLOCK - 1] of Byte;
  {* GHash128 Կ}

  TCnGHash128Tag    = array[0..CN_AEAD_BLOCK - 1] of Byte;
  {* GHash128 ļ}

  TCnGHash128Context = packed record
  {* ڶηֿ GHash128 Ľṹ}
    HashKey:     TCn128BitsBuffer;
    State:       TCn128BitsBuffer;
    AADByteLen:  Integer;
    DataByteLen: Integer;
  end;

  TCnGCM128Key = array[0..CN_AEAD_BLOCK - 1] of Byte;
  {* GCM ģʽԿڲ AES  SM4 Ϊ 16 ֽ}

  TCnGCM128Tag    = array[0..CN_AEAD_BLOCK - 1] of Byte;
  {* GCM ļ}

  TCnCMAC128Key = array[0..CN_AEAD_BLOCK - 1] of Byte;
  {* CMAC ģʽԿڲ AES  SM4 Ϊ 16 ֽ}

  TCnCMAC128Tag    = array[0..CN_AEAD_BLOCK - 1] of Byte;
  {* CMAC ļ}

  TCnCCM128Tag = array[0..CN_CCM_M_LEN - 1] of Byte;
  {* CCM ļ}

procedure GMulBlock128(var X: TCn128BitsBuffer; var Y: TCn128BitsBuffer; var R: TCn128BitsBuffer);
{* ʵ GHash е٤޻ (2^128) ϵĿ˷ͨҲϽɡ
   ע 2 ˷ļӷģ 2 ҲҲͬģ 2 
   ͬʱҪģһģʽ GHASH_POLYеĵμͬҲ

   
     var X: TCn128BitsBuffer              - һ
     var Y: TCn128BitsBuffer              - 
     var R: TCn128BitsBuffer              - 

   ֵޣ
}

procedure GHash128(var HashKey: TCnGHash128Key; Data: Pointer; DataByteLength: Integer;
  AAD: Pointer; AADByteLength: Integer; var OutTag: TCnGHash128Tag);
{* ָ HashKey 븽 AADһݽ GHash õ Tag ժҪ
   Ӧĵе GHash(H, A C)

   
     var HashKey: TCnGHash128Key          - ڼԿ
     Data: Pointer                        - ݿַ
     DataByteLength: Integer              - ݿֽڳ
     AAD: Pointer                         - ĸݿַ
     AADByteLength: Integer               - ĸݿֽڳ
     var OutTag: TCnGHash128Tag           - ؼ Tag

   ֵޣ
}

function GHash128Bytes(var HashKey: TCnGHash128Key; Data: TBytes; AAD: TBytes): TCnGHash128Tag;
{* ֽ鷽ʽ GHash 㣬ڲ GHash128

   
     var HashKey: TCnGHash128Key          - ڼԿ
     Data: TBytes                         - ֽ
     AAD: TBytes                          - ĸֽ

   ֵTCnGHash128Tag                 - ؼ Tag
}

// ⲿݽɢ GHash128 㣬GHash128Update ɶα
// ע GHash128Update  Data Ҫ飬粻飬ĩβᲹ 0 㣬
// Ӵպŵһִ

procedure GHash128Start(var Ctx: TCnGHash128Context; var HashKey: TCnGHash128Key;
  AAD: Pointer; AADByteLength: Integer);
{* ʼ GHash128 ĵһʼȫ AAD ݡ

   
     var Ctx: TCnGHash128Context          - ʼĽṹ
     var HashKey: TCnGHash128Key          - ڼԿ
     AAD: Pointer                         - ĸݿַ
     AADByteLength: Integer               - ĸݿֽڳ

   ֵޣ
}

procedure GHash128Update(var Ctx: TCnGHash128Context; Data: Pointer; DataByteLength: Integer);
{* һݽ GHash128㳤Ⱦ¼ Ctx УԶεá
   עҪ飬粻飬ĩβᲹ 0 ɱμ㣬Ӵպŵһִټ㡣

   
     var Ctx: TCnGHash128Context          - Ľṹ
     Data: Pointer                        - ݿַ
     DataByteLength: Integer              - ݿֽڳ

   ֵޣ
}

procedure GHash128Finish(var Ctx: TCnGHash128Context; var Output: TCnGHash128Tag);
{* GHash128 㳤ȣؽ

   
     var Ctx: TCnGHash128Context          - Ľṹ
     var Output: TCnGHash128Tag           - ؼ Tag

   ֵޣ
}

// ======================= AES/SM4-GCM ֽܺ ========================

function AES128GCMEncryptBytes(Key: TBytes; Iv: TBytes; PlainData: TBytes; AAD: TBytes;
  var OutTag: TCnGCM128Tag): TBytes;
{* ʹԿʼݶĽ AES-128-GCM ܣġ
   ϲ뷵ֵΪֽ飬 OutTag з֤ݹ֤

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     PlainData: TBytes                    - ֽܵ
     AAD: TBytes                          - ֽ
     var OutTag: TCnGCM128Tag             - ؼ Tag

   ֵTBytes                         - ֽ
}

function AES192GCMEncryptBytes(Key: TBytes; Iv: TBytes; PlainData: TBytes; AAD: TBytes;
  var OutTag: TCnGCM128Tag): TBytes;
{* ʹԿʼݶĽ AES-192-GCM ܣġ
   ϲ뷵ֵΪֽ飬 OutTag з֤ݹ֤

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     PlainData: TBytes                    - ֽܵ
     AAD: TBytes                          - ֽ
     var OutTag: TCnGCM128Tag             - ؼ Tag

   ֵTBytes                         - ֽ
}

function AES256GCMEncryptBytes(Key: TBytes; Iv: TBytes; PlainData: TBytes; AAD: TBytes;
  var OutTag: TCnGCM128Tag): TBytes;
{* ʹԿʼݶĽ AES-256-GCM ܣġ
   ϲ뷵ֵΪֽ飬 OutTag з֤ݹ֤

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     PlainData: TBytes                    - ֽܵ
     AAD: TBytes                          - ֽ
     var OutTag: TCnGCM128Tag             - ؼ Tag

   ֵTBytes                         - ֽ
}

function SM4GCMEncryptBytes(Key: TBytes; Iv: TBytes; PlainData: TBytes; AAD: TBytes;
  var OutTag: TCnGCM128Tag): TBytes;
{* ʹԿʼݶĽ SM4-GCM ܣġ
   ϲ뷵ֵΪֽ飬 OutTag з֤ݹ֤

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     PlainData: TBytes                    - ֽܵ
     AAD: TBytes                          - ֽ
     var OutTag: TCnGCM128Tag             - ؼ Tag

   ֵTBytes                         - ֽ
}

// ======================== AES/SM4-GCM ݿܺ =========================

procedure AES128GCMEncrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnGCM128Tag);
{* ʹԿʼݶĽ AES-128-GCM ܣ OutEnData ָС
   OutEnData ָ򳤶Ϊ PlainByteLengthԽغ
   ϲΪڴ鲢ָֽڳȵʽ OutTag з֤ݹ֤

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Iv: Pointer                          - ʼݿַ
     IvByteLength: Integer                - ʼݿֽڳ
     PlainData: Pointer                   - ܵݿַ
     PlainByteLength: Integer             - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutEnData: Pointer                   - ĵĴŵַ
     var OutTag: TCnGCM128Tag             - ؼ Tag

   ֵޣ
}

procedure AES192GCMEncrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnGCM128Tag);
{* ʹԿʼݶĽ AES-192-GCM ܣ OutEnData ָС
   OutEnData ָ򳤶Ϊ PlainByteLengthԽغ
   ϲΪڴ鲢ָֽڳȵʽ OutTag з֤ݹ֤

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Iv: Pointer                          - ʼݿַ
     IvByteLength: Integer                - ʼݿֽڳ
     PlainData: Pointer                   - ܵݿַ
     PlainByteLength: Integer             - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutEnData: Pointer                   - ĵĴŵַ
     var OutTag: TCnGCM128Tag             - ؼ Tag

   ֵޣ
}

procedure AES256GCMEncrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnGCM128Tag);
{* ʹԿʼݶĽ AES-256-GCM ܣ OutEnData ָС
   OutEnData ָ򳤶Ϊ PlainByteLengthԽغ
   ϲΪڴ鲢ָֽڳȵʽ OutTag з֤ݹ֤

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Iv: Pointer                          - ʼݿַ
     IvByteLength: Integer                - ʼݿֽڳ
     PlainData: Pointer                   - ܵݿַ
     PlainByteLength: Integer             - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutEnData: Pointer                   - ĵĴŵַ
     var OutTag: TCnGCM128Tag             - ؼ Tag

   ֵޣ
}

procedure SM4GCMEncrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnGCM128Tag);
{* ʹԿʼݶĽ SM4-GCM ܣ OutEnData ָС
   OutEnData ָ򳤶Ϊ PlainByteLengthԽغ
   ϲΪڴ鲢ָֽڳȵʽ OutTag з֤ݹ֤

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Iv: Pointer                          - ʼݿַ
     IvByteLength: Integer                - ʼݿֽڳ
     PlainData: Pointer                   - ܵݿַ
     PlainByteLength: Integer             - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutEnData: Pointer                   - ĵĴŵַ
     var OutTag: TCnGCM128Tag             - ؼ Tag

   ֵޣ
}

procedure AESGCMNoPaddingEncrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer;
  NonceByteLength: Integer; PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer;
  AADByteLength: Integer; OutEnData: Pointer);
{*  Java/Kotlin/OpenSSL ȹ淶 AES/GCM/NoPadding ܺڲʹ AES256
    Nonce ʼTag ֱƴĺҪ OutEnData ָ PlainByteLength  16 ֽڡ

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Nonce: Pointer                       - ʱݿַ
     NonceByteLength: Integer             - ʱݿֽڳ
     PlainData: Pointer                   - ܵݿַ
     PlainByteLength: Integer             - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutEnData: Pointer                   - ĵĴŵַ

   ֵޣ
}

// ======================= AES/SM4-GCM ֽܺ ========================

function AES128GCMDecryptBytes(Key: TBytes; Iv: TBytes; EnData: TBytes; AAD: TBytes;
  var InTag: TCnGCM128Tag): TBytes;
{* ʹԿʼݶĽ AES-128-GCM ֤ܲɹ򷵻ġ
   ϲ뷵ֵΪֽ飬֤ InTag ǷϷϷ nil

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     EnData: TBytes                       - ֽܵ
     AAD: TBytes                          - ֽ
     var InTag: TCnGCM128Tag              - ֤ Tag

   ֵTBytes                         - ֽ
}

function AES192GCMDecryptBytes(Key: TBytes; Iv: TBytes; EnData: TBytes; AAD: TBytes;
  var InTag: TCnGCM128Tag): TBytes;
{* ʹԿʼݶĽ AES-192-GCM ֤ܲɹ򷵻ġ
   ϲ뷵ֵΪֽ飬֤ InTag ǷϷϷ nil

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     EnData: TBytes                       - ֽܵ
     AAD: TBytes                          - ֽ
     var InTag: TCnGCM128Tag              - ֤ Tag

   ֵTBytes                         - ֽ
}

function AES256GCMDecryptBytes(Key: TBytes; Iv: TBytes; EnData: TBytes; AAD: TBytes;
  var InTag: TCnGCM128Tag): TBytes;
{* ʹԿʼݶĽ AES-256-GCM ֤ܲɹ򷵻ġ
   ϲ뷵ֵΪֽ飬֤ InTag ǷϷϷ nil

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     EnData: TBytes                       - ֽܵ
     AAD: TBytes                          - ֽ
     var InTag: TCnGCM128Tag              - ֤ Tag

   ֵTBytes                         - ֽ
}

function SM4GCMDecryptBytes(Key: TBytes; Iv: TBytes; EnData: TBytes; AAD: TBytes;
  var InTag: TCnGCM128Tag): TBytes;
{* ʹԿʼݶĽ SM4-GCM ֤ܲɹ򷵻ġ
   ϲ뷵ֵΪֽ飬֤ InTag ǷϷϷ nil

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     EnData: TBytes                       - ֽܵ
     AAD: TBytes                          - ֽ
     var InTag: TCnGCM128Tag              - ֤ Tag

   ֵTBytes                         - ֽ
}

// ======================== AES/SM4-GCM ݿܺ =========================

function AES128GCMDecrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnGCM128Tag): Boolean;
{* ʹԿʼݶĽ AES-128-GCM ֤ܲ
   ɹ򷵻 True ķ OutPlainData ָУ
   ϲΪڴ鲢ָֽڳȵʽ֤ InTag ǷϷϷ False

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Iv: Pointer                          - ʼݿַ
     IvByteLength: Integer                - ʼݿֽڳ
     EnData: Pointer                      - ܵݿַ
     EnByteLength: Integer                - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutPlainData: Pointer                - ĵĴŵַ
     var InTag: TCnGCM128Tag              - ֤ Tag

   ֵBoolean                        - ؽ֤Ƿɹ
}

function AES192GCMDecrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnGCM128Tag): Boolean;
{* ʹԿʼݶĽ AES-192-GCM ֤ܲ
   ɹ򷵻 True ķ OutPlainData ָУ
   ϲΪڴ鲢ָֽڳȵʽ֤ InTag ǷϷϷ False

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Iv: Pointer                          - ʼݿַ
     IvByteLength: Integer                - ʼݿֽڳ
     EnData: Pointer                      - ܵݿַ
     EnByteLength: Integer                - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutPlainData: Pointer                - ĵĴŵַ
     var InTag: TCnGCM128Tag              - ֤ Tag

   ֵBoolean                        - ؽ֤Ƿɹ
}

function AES256GCMDecrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnGCM128Tag): Boolean;
{* ʹԿʼݶĽ AES-256-GCM ֤ܲ
   ɹ򷵻 True ķ OutPlainData ָУ
   ϲΪڴ鲢ָֽڳȵʽ֤ InTag ǷϷϷ False

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Iv: Pointer                          - ʼݿַ
     IvByteLength: Integer                - ʼݿֽڳ
     EnData: Pointer                      - ܵݿַ
     EnByteLength: Integer                - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutPlainData: Pointer                - ĵĴŵַ
     var InTag: TCnGCM128Tag              - ֤ Tag

   ֵBoolean                        - ؽ֤Ƿɹ
}

function SM4GCMDecrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnGCM128Tag): Boolean;
{* ʹԿʼݶĽ SM4-GCM ֤ܲ
   ɹ򷵻 True ķ OutPlainData ָУ
   ϲΪڴ鲢ָֽڳȵʽ֤ InTag ǷϷϷ False

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Iv: Pointer                          - ʼݿַ
     IvByteLength: Integer                - ʼݿֽڳ
     EnData: Pointer                      - ܵݿַ
     EnByteLength: Integer                - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutPlainData: Pointer                - ĵĴŵַ
     var InTag: TCnGCM128Tag              - ֤ Tag

   ֵBoolean                        - ؽ֤Ƿɹ
}

function AESGCMNoPaddingDecrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer;
  NonceByteLength: Integer; EnData: Pointer; EnByteLength: Integer; AAD: Pointer;
  AADByteLength: Integer; OutPlainData: Pointer): Boolean;
{*  Java/Kotlin/OpenSSL ȹ淶 AES/GCM/NoPadding ܺڲʹ AES256
    Nonce ʼҪ Tag ֱƴĺҲǽĺ 16 ֽڵ Tag нܺıȶԡ

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Nonce: Pointer                       - ʱݿַ
     NonceByteLength: Integer             - ʱݿֽڳ
     EnData: Pointer                      - ܵݿַ
     EnByteLength: Integer                - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutPlainData: Pointer                - ĵĴŵַ

   ֵBoolean                        - ؽ֤Ƿɹ
}

// ======================= AES/SM4-CMAC ֽӴպ =======================

function AES128CMAC128Bytes(Key: TBytes; Data: TBytes): TCnCMAC128Tag;
{* ָ Key ݽ AES-128-CMAC 㣬ؼ TagΪֽ顣

   
     Key: TBytes                          - Կֽ
     Data: TBytes                         - ֽ

   ֵTCnCMAC128Tag                  -
}

function AES192CMAC128Bytes(Key: TBytes; Data: TBytes): TCnCMAC128Tag;
{* ָ Key ݽ AES-192-CMAC 㣬ؼ TagΪֽ

   
     Key: TBytes                          - Կֽ
     Data: TBytes                         - ֽ

   ֵTCnCMAC128Tag                  -
}

function AES256CMAC128Bytes(Key: TBytes; Data: TBytes): TCnCMAC128Tag;
{* ָ Key ݽ AES-256-CMAC 㣬ؼ TagΪֽ

   
     Key: TBytes                          - Կֽ
     Data: TBytes                         -

   ֵTCnCMAC128Tag                  -
}

function SM4CMAC128Bytes(Key: TBytes; Data: TBytes): TCnCMAC128Tag;
{* ָ Key ݽ SM4-CMAC 㣬ؼ TagΪֽ

   
     Key: TBytes                          - Կֽ
     Data: TBytes                         -

   ֵTCnCMAC128Tag                  -
}

// ======================== AES/SM4-CMAC ݿӴպ ========================

function AES128CMAC128(Key: Pointer; KeyByteLength: Integer; Data: Pointer;
  DataByteLength: Integer): TCnCMAC128Tag;
{* ָ Key ݽ AES-128-CMAC 㣬ؼ TagΪڴ顣

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Data: Pointer                        - ݿַ
     DataByteLength: Integer              - ݿֽڳ

   ֵTCnCMAC128Tag                  -
}

function AES192CMAC128(Key: Pointer; KeyByteLength: Integer; Data: Pointer;
  DataByteLength: Integer): TCnCMAC128Tag;
{* ָ Key ݽ AES-192-CMAC 㣬ؼ TagΪڴ顣

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Data: Pointer                        - ݿַ
     DataByteLength: Integer              - ݿֽڳ

   ֵTCnCMAC128Tag                  -
}

function AES256CMAC128(Key: Pointer; KeyByteLength: Integer; Data: Pointer;
  DataByteLength: Integer): TCnCMAC128Tag;
{* ָ Key ݽ AES-256-CMAC 㣬ؼ TagΪڴ顣

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Data: Pointer                        - ݿַ
     DataByteLength: Integer              - ݿֽڳ

   ֵTCnCMAC128Tag                  - ؼ Tag
}

function SM4CMAC128(Key: Pointer; KeyByteLength: Integer; Data: Pointer;
  DataByteLength: Integer): TCnCMAC128Tag;
{* ָ Key ݽ SM4-CMAC 㣬ؼ TagΪڴ顣

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Data: Pointer                        - ݿַ
     DataByteLength: Integer              - ݿֽڳ

   ֵTCnCMAC128Tag                  - ؼ Tag
}

// ======================= AES/SM4-CCM ֽܺ ========================

function AES128CCMEncryptBytes(Key: TBytes; Nonce: TBytes; PlainData: TBytes; AAD: TBytes;
  var OutTag: TCnCCM128Tag): TBytes;
{* ʹԿʱݡݶĽ AES-128-CCM ܣġ
   ϲ뷵ֵΪֽ飬 OutTag з֤ݹ֤

   
     Key: TBytes                          - Կֽ
     Nonce: TBytes                        - ʱֽ
     PlainData: TBytes                    - ֽܵ
     AAD: TBytes                          - ֽ
     var OutTag: TCnCCM128Tag             - ؼ Tag

   ֵTBytes                         - ֽ
}

function AES192CCMEncryptBytes(Key: TBytes; Nonce: TBytes; PlainData: TBytes; AAD: TBytes;
  var OutTag: TCnCCM128Tag): TBytes;
{* ʹԿʱݡݶĽ AES-192-CCM ܣġ
   ϲ뷵ֵΪֽ飬 OutTag з֤ݹ֤

   
     Key: TBytes                          - Կֽ
     Nonce: TBytes                        - ʱֽ
     PlainData: TBytes                    - ֽܵ
     AAD: TBytes                          - ֽ
     var OutTag: TCnCCM128Tag             - ؼ Tag

   ֵTBytes                         - ֽ
}

function AES256CCMEncryptBytes(Key: TBytes; Nonce: TBytes; PlainData: TBytes; AAD: TBytes;
  var OutTag: TCnCCM128Tag): TBytes;
{* ʹԿʱݡݶĽ AES-256-CCM ܣġ
   ϲ뷵ֵΪֽ飬 OutTag з֤ݹ֤

   
     Key: TBytes                          - Կֽ
     Nonce: TBytes                        - ʱֽ
     PlainData: TBytes                    - ֽܵ
     AAD: TBytes                          - ֽ
     var OutTag: TCnCCM128Tag             - ؼ Tag

   ֵTBytes                         - ֽ
}

function SM4CCMEncryptBytes(Key: TBytes; Nonce: TBytes; PlainData: TBytes; AAD: TBytes;
  var OutTag: TCnCCM128Tag): TBytes;
{* ʹԿʱݡݶĽ SM4-CCM ܣġ
   ϲ뷵ֵΪֽ飬 OutTag з֤ݹ֤

   
     Key: TBytes                          - Կֽ
     Nonce: TBytes                        - ʱֽ
     PlainData: TBytes                    - ֽܵ
     AAD: TBytes                          - ֽ
     var OutTag: TCnCCM128Tag             - ؼ Tag

   ֵTBytes                         - ֽ
}

// ======================= AES/SM4-CCM ֽܺ ========================

function AES128CCMDecryptBytes(Key: TBytes; Nonce: TBytes; EnData: TBytes; AAD: TBytes;
  var InTag: TCnCCM128Tag): TBytes;
{* ʹԿʱݡݶĽ AES-128-CCM ֤ܲɹ򷵻ġ
   ϲ뷵ֵΪֽ飬֤ InTag ǷϷϷ nil

   
     Key: TBytes                          - Կֽ
     Nonce: TBytes                        - ʱֽ
     EnData: TBytes                       - ֽܵ
     AAD: TBytes                          - ֽ
     var InTag: TCnCCM128Tag              - ֤ Tag

   ֵTBytes                         - ֽ
}

function AES192CCMDecryptBytes(Key: TBytes; Nonce: TBytes; EnData: TBytes; AAD: TBytes;
  var InTag: TCnCCM128Tag): TBytes;
{* ʹԿʱݡݶĽ AES-192-CCM ֤ܲɹ򷵻ġ
   ϲ뷵ֵΪֽ飬֤ InTag ǷϷϷ nil

   
     Key: TBytes                          - Կֽ
     Nonce: TBytes                        - ʱֽ
     EnData: TBytes                       - ֽܵ
     AAD: TBytes                          - ֽ
     var InTag: TCnCCM128Tag              - ֤ Tag

   ֵTBytes                         - ֽ
}

function AES256CCMDecryptBytes(Key: TBytes; Nonce: TBytes; EnData: TBytes; AAD: TBytes;
  var InTag: TCnCCM128Tag): TBytes;
{* ʹԿʱݡݶĽ AES-256-CCM ֤ܲɹ򷵻ġ
   ϲ뷵ֵΪֽ飬֤ InTag ǷϷϷ nil

   
     Key: TBytes                          - Կֽ
     Nonce: TBytes                        - ʱֽ
     EnData: TBytes                       - ֽܵ
     AAD: TBytes                          - ֽ
     var InTag: TCnCCM128Tag              - ֤ Tag

   ֵTBytes                         - ֽ
}

function SM4CCMDecryptBytes(Key: TBytes; Nonce: TBytes; EnData: TBytes; AAD: TBytes;
  var InTag: TCnCCM128Tag): TBytes;
{* ʹԿʱݡݶĽ SM4-CCM ֤ܲɹ򷵻ġ
   ϲ뷵ֵΪֽ飬֤ InTag ǷϷϷ nil

   
     Key: TBytes                          - Կֽ
     Nonce: TBytes                        - ʱֽ
     EnData: TBytes                       - ֽܵ
     AAD: TBytes                          - ֽ
     var InTag: TCnCCM128Tag              - ֤ Tag

   ֵTBytes                         - ֽ
}

// ======================== AES/SM4-CCM ݿܺ =========================

procedure AES128CCMEncrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnCCM128Tag);
{* ʹԿʱݡݶĽ AES-128-CCM ܣ OutEnData ָС
   OutEnData ָ򳤶Ϊ PlainByteLengthԽغ
   ϲΪڴ鲢ָֽڳȵʽ OutTag з֤ݹ֤

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Nonce: Pointer                       - ʱݿַ
     NonceByteLength: Integer             - ʱݿֽڳ
     PlainData: Pointer                   - ܵݿַ
     PlainByteLength: Integer             - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutEnData: Pointer                   - ĵĴŵַ
     var OutTag: TCnCCM128Tag             - ؼ Tag

   ֵޣ
}

procedure AES192CCMEncrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnCCM128Tag);
{* ʹԿʱݡݶĽ AES-192-CCM ܣ OutEnData ָС
   OutEnData ָ򳤶Ϊ PlainByteLengthԽغ
   ϲΪڴ鲢ָֽڳȵʽ OutTag з֤ݹ֤

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Nonce: Pointer                       - ʼݿַ
     NonceByteLength: Integer             - ʼݿֽڳ
     PlainData: Pointer                   - ܵݿַ
     PlainByteLength: Integer             - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutEnData: Pointer                   - ĵĴŵַ
     var OutTag: TCnCCM128Tag             - ؼ Tag

   ֵޣ
}

procedure AES256CCMEncrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnCCM128Tag);
{* ʹԿʱݡݶĽ AES-256-CCM ܣ OutEnData ָС
   OutEnData ָ򳤶Ϊ PlainByteLengthԽغ
   ϲΪڴ鲢ָֽڳȵʽ OutTag з֤ݹ֤

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Nonce: Pointer                       - ʱݿַ
     NonceByteLength: Integer             - ʱݿֽڳ
     PlainData: Pointer                   - ܵݿַ
     PlainByteLength: Integer             - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutEnData: Pointer                   - ĵĴŵַ
     var OutTag: TCnCCM128Tag             - ؼ Tag

   ֵޣ
}

procedure SM4CCMEncrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnCCM128Tag);
{* ʹԿʱݡݶĽ SM4-CCM ܣ OutEnData ָС
   OutEnData ָ򳤶Ϊ PlainByteLengthԽغ
   ϲΪڴ鲢ָֽڳȵʽ OutTag з֤ݹ֤

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Nonce: Pointer                       - ʱݿַ
     NonceByteLength: Integer             - ʱݿֽڳ
     PlainData: Pointer                   - ܵݿַ
     PlainByteLength: Integer             - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutEnData: Pointer                   - ĵĴŵַ
     var OutTag: TCnCCM128Tag             - ؼ Tag

   ֵޣ
}

// ======================== AES/SM4-CCM ݿܺ =========================

function AES128CCMDecrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnCCM128Tag): Boolean;
{* ʹԿʱݡݶĽ AES-128-CCM ֤ܲ
  ɹ򷵻 True ķ OutPlainData ָУ
  ϲΪڴ鲢ָֽڳȵʽ֤ InTag ǷϷϷ False

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Nonce: Pointer                       - ʱݿַ
     NonceByteLength: Integer             - ʱݿֽڳ
     EnData: Pointer                      - ܵݿַ
     EnByteLength: Integer                - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutPlainData: Pointer                - ĵĴŵַ
     var InTag: TCnCCM128Tag              - ֤ Tag

   ֵBoolean                        - ؽ֤Ƿɹ
}

function AES192CCMDecrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnCCM128Tag): Boolean;
{* ʹԿʱݡݶĽ AES-192-CCM ֤ܲ
  ɹ򷵻 True ķ OutPlainData ָУ
  ϲΪڴ鲢ָֽڳȵʽ֤ InTag ǷϷϷ False

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Nonce: Pointer                       - ʱݿַ
     NonceByteLength: Integer             - ʱݿֽڳ
     EnData: Pointer                      - ܵݿַ
     EnByteLength: Integer                - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutPlainData: Pointer                - ĵĴŵַ
     var InTag: TCnCCM128Tag              - ֤ Tag

   ֵBoolean                        - ؽ֤Ƿɹ
}

function AES256CCMDecrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnCCM128Tag): Boolean;
{* ʹԿʱݡݶĽ AES-256-CCM ֤ܲ
  ɹ򷵻 True ķ OutPlainData ָУ
  ϲΪڴ鲢ָֽڳȵʽ֤ InTag ǷϷϷ False

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Nonce: Pointer                       - ʱݿַ
     NonceByteLength: Integer             - ʱݿֽڳ
     EnData: Pointer                      - ܵݿַ
     EnByteLength: Integer                - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutPlainData: Pointer                - ĵĴŵַ
     var InTag: TCnCCM128Tag              - ֤ Tag

   ֵBoolean                        - ؽ֤Ƿɹ
}

function SM4CCMDecrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnCCM128Tag): Boolean;
{* ʹԿʱݡݶĽ SM4-CCM ֤ܲ
  ɹ򷵻 True ķ OutPlainData ָУ
  ϲΪڴ鲢ָֽڳȵʽ֤ InTag ǷϷϷ False

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Nonce: Pointer                       - ʱݿַ
     NonceByteLength: Integer             - ʱݿֽڳ
     EnData: Pointer                      - ܵݿַ
     EnByteLength: Integer                - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutPlainData: Pointer                - ĵĴŵַ
     var InTag: TCnCCM128Tag              - ֤ Tag

   ֵBoolean                        - ؽ֤Ƿɹ
}

// ======== װ AES|SM4/GCM ʮֽӽܺ Padding ========

function AESGCMEncryptToHex(Key: TBytes; Iv: TBytes; AD: TBytes; Input: TBytes): string;
{* װĳüܺʹԿʼݶĽ AES-GCM ܲתʮַ
   㷨 AES256GCM  Padding֤ Tag ƴַڲܽγġ

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     AD: TBytes                           - ֽ
     Input: TBytes                        - ֽܵ

   ֵstring                         - ʮ
}

function AESGCMDecryptFromHex(Key: TBytes; Iv: TBytes; AD: TBytes; const Input: string): TBytes;
{* װĳýܺʹԿʼݶʮĽ AES-GCM ֤ܲ Tag
   㷨 AES256GCM  Paddingؽֽܺ顣

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     AD: TBytes                           - ֽ
     Input: string                        - ܵʮ

   ֵTBytes                         - ֽ
}

function SM4GCMEncryptToHex(Key: TBytes; Iv: TBytes; AD: TBytes; Input: TBytes): string;
{* װĳüܺʹԿʼݶĽ SM4-GCM ܲתʮַ
   㷨 SM4GCM  Padding֤ Tag ƴַڲܽγġ

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     AD: TBytes                           - ֽ
     Input: TBytes                        - ֽܵ

   ֵstring                         - ʮ
}

function SM4GCMDecryptFromHex(Key: TBytes; Iv: TBytes; AD: TBytes; const Input: string): TBytes;
{* װĳýܺʹԿʼݶʮĽ SM4-GCM ֤ܲ Tag
   㷨 SM4GCM  Paddingؽֽܺ顣

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     AD: TBytes                           - ֽ
     const Input: string                  - ܵʮ

   ֵTBytes                         - ֽ
}

// =================== ChaCha20_Poly1305 ݿӽܺ ======================

procedure ChaCha20Poly1305Encrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnPoly1305Digest);
{* ʹԿʼݶĽ ChaCha20_Poly1305 ܣ OutEnData ָС
   OutEnData ָ򳤶Ϊ PlainByteLengthԽغ
   ϲΪڴ鲢ָֽڳȵʽ OutTag з֤ݹ֤
   УKeyByteLength ҪΪ 32 ֽڷضϻ 0
   Iv ҪΪ 12 ֽڷҲضϻ 0һ˵ 8 ֽȻҪӸ 4 ֽڹ̶ݣδã
    Tag Ϊ 16 ֽڡ

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Iv: Pointer                          - ʼݿַ
     IvByteLength: Integer                - ʼݿֽڳ
     PlainData: Pointer                   - ܵݿַ
     PlainByteLength: Integer             - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutEnData: Pointer                   - ĵĴŵַ
     var OutTag: TCnPoly1305Digest        - ؼ Tag

   ֵޣ
}

function ChaCha20Poly1305Decrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnPoly1305Digest): Boolean;
{* ʹԿʼݶĽ ChaCha20_Poly1305 ֤ܲ
  УKeyByteLength ҪΪ 32 ֽڷضϻ 0
  Iv ҪΪ 12 ֽڷҲضϻ 0һ˵ 8 ֽȻҪӸ 4 ֽڹ̶ݣδã
  ɹ򷵻 True ķ OutPlainData ָУ
  ϲΪڴ鲢ָֽڳȵʽ֤ InTag ǷϷϷ False

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Iv: Pointer                          - ʼݿַ
     IvByteLength: Integer                - ʼݿֽڳ
     EnData: Pointer                      - ܵݿַ
     EnByteLength: Integer                - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutPlainData: Pointer                - ĵĴŵַ
     var InTag: TCnPoly1305Digest         - ֤ Tag

   ֵBoolean                        - ؽ֤Ƿɹ
}

// ================== ChaCha20_Poly1305 ֽӽܺ =====================

function ChaCha20Poly1305EncryptBytes(Key: TBytes; Iv: TBytes; PlainData: TBytes;
  AAD: TBytes; var OutTag: TCnPoly1305Digest): TBytes;
{* ʹԿʱݡݶĽ ChaCha20_Poly1305 ܣ
  ϲ뷵ֵΪֽ飬 OutTag з֤ݹ֤

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     PlainData: TBytes                    - ֽܵ
     AAD: TBytes                          - ֽ
     var OutTag: TCnPoly1305Digest        - ؼ Tag

   ֵTBytes                         - ֽ
}

function ChaCha20Poly1305DecryptBytes(Key: TBytes; Iv: TBytes; EnData: TBytes;
  AAD: TBytes; var InTag: TCnPoly1305Digest): TBytes;
{* ʹԿʼݶĽ ChaCha20_Poly1305 ֤ܲɹ򷵻ġ
   ϲ뷵ֵΪֽ飬֤ InTag ǷϷϷ nil

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     EnData: TBytes                       - ֽܵ
     AAD: TBytes                          - ֽ
     var InTag: TCnPoly1305Digest         - ֤ Tag

   ֵTBytes                         - ֽ
}

// =================== XChaCha20_Poly1305 ݿӽܺ =====================

procedure XChaCha20Poly1305Encrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer;
  IvByteLength: Integer; PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer;
  AADByteLength: Integer; OutEnData: Pointer; var OutTag: TCnPoly1305Digest);
{* ʹԿʼݶĽ XChaCha20_Poly1305 ܣ OutEnData ָС
   OutEnData ָ򳤶Ϊ PlainByteLengthԽغ
   ϲΪڴ鲢ָֽڳȵʽ OutTag з֤ݹ֤
   УKeyByteLength ҪΪ 32 ֽڷضϻ 0
   Iv ҪΪ 24 ֽڷҲضϻ 0һ˵ 8 ֽȻҪӸ 4 ֽڹ̶ݣδã
    Tag Ϊ 16 ֽڡ

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Iv: Pointer                          - ʼݿַ
     IvByteLength: Integer                - ʼݿֽڳ
     PlainData: Pointer                   - ܵݿַ
     PlainByteLength: Integer             - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutEnData: Pointer                   - ĵĴŵַ
     var OutTag: TCnPoly1305Digest        - ؼ Tag

   ֵޣ
}

function XChaCha20Poly1305Decrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer;
  IvByteLength: Integer; EnData: Pointer; EnByteLength: Integer; AAD: Pointer;
  AADByteLength: Integer; OutPlainData: Pointer; var InTag: TCnPoly1305Digest): Boolean;
{* ʹԿʼݶĽ XChaCha20_Poly1305 ֤ܲ
   УKeyByteLength ҪΪ 32 ֽڷضϻ 0
   Iv ҪΪ 24 ֽڷҲضϻ 0һ˵ 8 ֽȻҪӸ 4 ֽڹ̶ݣδã
   ɹ򷵻 True ķ OutPlainData ָУ
   ϲΪڴ鲢ָֽڳȵʽ֤ InTag ǷϷϷ False

   
     Key: Pointer                         - Կݿַ
     KeyByteLength: Integer               - Կݿֽڳ
     Iv: Pointer                          - ʼݿַ
     IvByteLength: Integer                - ʼݿֽڳ
     EnData: Pointer                      - ܵݿַ
     EnByteLength: Integer                - ܵݿֽڳ
     AAD: Pointer                         - ݿַ
     AADByteLength: Integer               - ݿֽڳ
     OutPlainData: Pointer                - ĵĴŵַ
     var InTag: TCnPoly1305Digest         - ֤ Tag

   ֵBoolean                        - ؽ֤Ƿɹ
}

// ================== XChaCha20_Poly1305 ֽӽܺ ====================

function XChaCha20Poly1305EncryptBytes(Key: TBytes; Iv: TBytes; PlainData: TBytes;
  AAD: TBytes; var OutTag: TCnPoly1305Digest): TBytes;
{* ʹԿʱݡݶĽ XChaCha20_Poly1305 ܣġ
   ϲ뷵ֵΪֽ飬 OutTag з֤ݹ֤

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     PlainData: TBytes                    - ֽܵ
     AAD: TBytes                          - ֽ
     var OutTag: TCnPoly1305Digest        - ؼ Tag

   ֵTBytes                         - ֽ
}

function XChaCha20Poly1305DecryptBytes(Key: TBytes; Iv: TBytes; EnData: TBytes;
  AAD: TBytes; var InTag: TCnPoly1305Digest): TBytes;
{* ʹԿʼݶĽ XChaCha20_Poly1305 ֤ܲɹ򷵻ġ
   ϲ뷵ֵΪֽ飬֤ InTag ǷϷϷ nil

   
     Key: TBytes                          - Կֽ
     Iv: TBytes                           - ʼֽ
     EnData: TBytes                       - ֽܵ
     AAD: TBytes                          - ֽ
     var InTag: TCnPoly1305Digest         - ֤ Tag

   ֵTBytes                         - ֽ
}

implementation

uses
  CnSM4, CnAES, CnChaCha20;

const
  GHASH_POLY: TCn128BitsBuffer = ($E1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

  CMAC_POLY: TCn128BitsBuffer =  (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, $87);

type
  TAEADEncryptType = (aetAES128, aetAES192, aetAES256, aetSM4);
  {* ֵֶ֧ԳƼ}

  TAEADContext = packed record
  case TAEADEncryptType of
    aetAES128: (ExpandedKey128: TCnAESExpandedKey128);
    aetAES192: (ExpandedKey192: TCnAESExpandedKey192);
    aetAES256: (ExpandedKey256: TCnAESExpandedKey256);
    aetSM4:    (SM4Context: TCnSM4Context);
  end;

// ע˴жֽ Bit ˳Ҳֽڵĸλ 0
function AeadIsBitSet(AMem: Pointer; N: Integer): Boolean;
var
  P: PByte;
  A1, B1: Integer;
  V: Byte;
begin
  A1 := N div 8;
  B1 := 7 - (N mod 8);
  P := PByte(TCnNativeInt(AMem) + A1);

  V := Byte(1 shl B1);
  Result := (P^ and V) <> 0;
end;

procedure MoveMost128(const Source; var Dest; ByteLen: Integer);
begin
  MoveMost(Source, Dest, ByteLen, CN_AEAD_BLOCK);
end;

{
  GCM ʹõ Galois(2^128) ڵĳ˷

  һ˵ֽڴ $FEDC BIT ˳Ӧ FEDCҲ 1111111011011100
  GCM УӦҲͬ⴮Ƶĳ
  Ȼ LSB ָұߵĵλģMSB ָ߸λģλϳϰߡ
  ⣺± 0 ָң
  GCM õģʽ 128,7,2,1,0㷨еı E1000000000˵±ұ߸λ
  ˣ127 ±λĸλơ
  ͬʱ127 ҲӦŵַλ0 ǵַλַλ
}
procedure GMulBlock128(var X, Y: TCn128BitsBuffer; var R: TCn128BitsBuffer);
var
  I: Integer;
  Z, V: TCn128BitsBuffer;
  B: Boolean;
begin
  FillChar(Z[0], SizeOf(TCn128BitsBuffer), 0);
  Move(X[0], V[0], SizeOf(TCn128BitsBuffer));

  for I := 0 to 127 do
  begin
    if AeadIsBitSet(@Y[0], I) then
      MemoryXor(@Z[0], @V[0], SizeOf(TCn128BitsBuffer), @Z[0]);

    B := AeadIsBitSet(@V[0], 127); // жϴĸλǷ 1
    MemoryShiftRight(@V[0], nil, SizeOf(TCn128BitsBuffer), 1);
    if B then
      MemoryXor(@V[0], @GHASH_POLY[0], SizeOf(TCn128BitsBuffer), @V[0]);
  end;
  Move(Z[0], R[0], SizeOf(TCn128BitsBuffer));
end;

procedure GHash128(var HashKey: TCnGHash128Key; Data: Pointer; DataByteLength: Integer;
  AAD: Pointer; AADByteLength: Integer; var OutTag: TCnGHash128Tag);
var
  AL, DL: Integer;
  AL64, DL64: Int64;
  X, Y, H: TCn128BitsBuffer;
begin
  // Ա GHash(H, A, C)Data  CAAD  AKey  H
  //  16 ֽڷ֣C  m 飬A  n 飨ĩ鶼ܲ
  //  m + n ݵ GaloisMulBlockټһλ

  FillChar(X[0], SizeOf(TCn128BitsBuffer), 0);  // ʼȫ 0
  Move(HashKey[0], H[0], SizeOf(TCn128BitsBuffer));

  AL := AADByteLength;
  DL := DataByteLength;
  if Data = nil then
    DL := 0;
  if AAD = nil then
    AL := 0;

  //  A
  while AL >= CN_AEAD_BLOCK do
  begin
    Move(AAD^, Y[0], CN_AEAD_BLOCK);

    MemoryXor(@Y[0], @X[0], SizeOf(TCn128BitsBuffer), @Y[0]);
    GMulBlock128(Y, H, X);  // һּٴη X

    AAD := Pointer(TCnNativeInt(AAD) + CN_AEAD_BLOCK);
    Dec(AL, CN_AEAD_BLOCK);
  end;

  //  AеĻ
  if AL > 0 then
  begin
    FillChar(Y[0], SizeOf(TCn128BitsBuffer), 0);
    Move(AAD^, Y[0], AL);

    MemoryXor(@Y[0], @X[0], SizeOf(TCn128BitsBuffer), @Y[0]);
    GMulBlock128(Y, H, X);
  end;

  //  C
  while DL >= CN_AEAD_BLOCK do
  begin
    Move(Data^, Y[0], CN_AEAD_BLOCK);

    MemoryXor(@Y[0], @X[0], SizeOf(TCn128BitsBuffer), @Y[0]);
    GMulBlock128(Y, H, X);  // һּٴη X

    Data := Pointer(TCnNativeInt(Data) + CN_AEAD_BLOCK);
    Dec(DL, CN_AEAD_BLOCK);
  end;

  //  CеĻ
  if DL > 0 then
  begin
    FillChar(Y[0], SizeOf(TCn128BitsBuffer), 0);
    Move(Data^, Y[0], DL);

    MemoryXor(@Y[0], @X[0], SizeOf(TCn128BitsBuffer), @Y[0]);
    GMulBlock128(Y, H, X);
  end;

  // һֳȣA  C ֽƴƴҪ׼ĶϰҲ BigEndian
  FillChar(Y[0], SizeOf(TCn128BitsBuffer), 0);
  AL64 := Int64HostToNetwork(AADByteLength * 8);
  DL64 := Int64HostToNetwork(DataByteLength * 8);

  Move(AL64, Y[0], SizeOf(Int64));
  Move(DL64, Y[SizeOf(Int64)], SizeOf(Int64));

  MemoryXor(@Y[0], @X[0], SizeOf(TCn128BitsBuffer), @Y[0]);
  GMulBlock128(Y, H, X); // ٳһ

  Move(X[0], OutTag[0], SizeOf(TCnGHash128Tag));
end;

function GHash128Bytes(var HashKey: TCnGHash128Key; Data, AAD: TBytes): TCnGHash128Tag;
var
  C, A: Pointer;
begin
  if Data = nil then
    C := nil
  else
    C := @Data[0];

  if AAD = nil then
    A := nil
  else
    A := @AAD[0];

  GHash128(HashKey, C, Length(Data), A, Length(AAD), Result);
end;

procedure GHash128Start(var Ctx: TCnGHash128Context; var HashKey: TCnGHash128Key;
  AAD: Pointer; AADByteLength: Integer);
var
  Y: TCn128BitsBuffer;
begin
  FillChar(Ctx.State[0], SizeOf(TCn128BitsBuffer), 0);  // ʼȫ 0
  Move(HashKey[0], Ctx.HashKey[0], SizeOf(TCn128BitsBuffer));

  Ctx.DataByteLen := 0;
  Ctx.AADByteLen := AADByteLength;
  if AAD = nil then
    Ctx.AADByteLen := 0;

  //  A
  while AADByteLength >= CN_AEAD_BLOCK do
  begin
    Move(AAD^, Y[0], CN_AEAD_BLOCK);

    MemoryXor(@Y[0], @Ctx.State[0], SizeOf(TCn128BitsBuffer), @Y[0]);
    GMulBlock128(Y, Ctx.HashKey, Ctx.State);  // һּٴη Ctx.State

    AAD := Pointer(TCnNativeInt(AAD) + CN_AEAD_BLOCK);
    Dec(AADByteLength, CN_AEAD_BLOCK);
  end;

  //  AеĻ
  if AADByteLength > 0 then
  begin
    FillChar(Y[0], SizeOf(TCn128BitsBuffer), 0);
    Move(AAD^, Y[0], AADByteLength);

    MemoryXor(@Y[0], @Ctx.State[0], SizeOf(TCn128BitsBuffer), @Y[0]);
    GMulBlock128(Y, Ctx.HashKey, Ctx.State);
  end;
end;

procedure GHash128Update(var Ctx: TCnGHash128Context; Data: Pointer; DataByteLength: Integer);
var
  Y: TCn128BitsBuffer;
begin
  if (Data = nil) or (DataByteLength <= 0) then
    Exit;

  Ctx.DataByteLen := Ctx.DataByteLen + DataByteLength;

  //  C
  while DataByteLength >= CN_AEAD_BLOCK do
  begin
    Move(Data^, Y[0], CN_AEAD_BLOCK);

    MemoryXor(@Y[0], @Ctx.State[0], SizeOf(TCn128BitsBuffer), @Y[0]);
    GMulBlock128(Y, Ctx.HashKey, Ctx.State);  // һּٴη Ctx.State

    Data := Pointer(TCnNativeInt(Data) + CN_AEAD_BLOCK);
    Dec(DataByteLength, CN_AEAD_BLOCK);
  end;

  //  CеĻ
  if DataByteLength > 0 then
  begin
    FillChar(Y[0], SizeOf(TCn128BitsBuffer), 0);
    Move(Data^, Y[0], DataByteLength);

    MemoryXor(@Y[0], @Ctx.State[0], SizeOf(TCn128BitsBuffer), @Y[0]);
    GMulBlock128(Y, Ctx.HashKey, Ctx.State);
  end;
end;

procedure GHash128Finish(var Ctx: TCnGHash128Context; var Output: TCnGHash128Tag);
var
  Y: TCn128BitsBuffer;
  AL64, DL64: Int64;
begin
  // һֳȣA  C ֽƴ
  FillChar(Y[0], SizeOf(TCn128BitsBuffer), 0);
  AL64 := Int64HostToNetwork(Ctx.AADByteLen * 8);
  DL64 := Int64HostToNetwork(Ctx.DataByteLen * 8);

  Move(AL64, Y[0], SizeOf(Int64));
  Move(DL64, Y[SizeOf(Int64)], SizeOf(Int64));

  MemoryXor(@Y[0], @Ctx.State[0], SizeOf(TCn128BitsBuffer), @Y[0]);
  GMulBlock128(Y, Ctx.HashKey, Ctx.State); // ٳһ֣

  Move(Ctx.State[0], Output[0], SizeOf(TCnGHash128Tag)); //  Output
end;

// ݶԳƼ㷨ͳʼԿṹעⲻҪԿṹ
procedure AEADEncryptInit(var Context: TAEADContext; Key: Pointer;
  KeyByteLength: Integer; EncryptType: TAEADEncryptType);
var
  Key128: TCnAESKey128;
  Key192: TCnAESKey192;
  Key256: TCnAESKey256;
  SM4Key: TCnSM4Key;
begin
  FillChar(Context, SizeOf(TAEADContext), 0);

  case EncryptType of
    aetAES128:
      begin
        MoveMost(Key^, Key128[0], KeyByteLength, SizeOf(TCnAESKey128));
        ExpandAESKeyForEncryption128(Key128, Context.ExpandedKey128);
      end;
    aetAES192:
      begin
        MoveMost(Key^, Key192[0], KeyByteLength, SizeOf(TCnAESKey192));
        ExpandAESKeyForEncryption192(Key192, Context.ExpandedKey192);
      end;
    aetAES256:
      begin
        MoveMost(Key^, Key256[0], KeyByteLength, SizeOf(TCnAESKey256));
        ExpandAESKeyForEncryption256(Key256, Context.ExpandedKey256);
      end;
    aetSM4:
      begin
        MoveMost(Key^, SM4Key[0], KeyByteLength, SizeOf(TCnSM4Key));
        SM4SetKeyEnc(Context.SM4Context, @SM4Key[0]);
      end;
  end;
end;

// ݶԳƼ㷨ͼһ飬鴮ǼܽעⲻҪ
procedure AEADEncryptBlock(var Context: TAEADContext; var InData, OutData: TCn128BitsBuffer;
  EncryptType: TAEADEncryptType);
begin
  case EncryptType of
    aetAES128: EncryptAES128(TCnAESBuffer(InData), Context.ExpandedKey128, TCnAESBuffer(OutData));
    aetAES192: EncryptAES192(TCnAESBuffer(InData), Context.ExpandedKey192, TCnAESBuffer(OutData));
    aetAES256: EncryptAES256(TCnAESBuffer(InData), Context.ExpandedKey256, TCnAESBuffer(OutData));
    aetSM4:    SM4OneRound(@(Context.SM4Context.Sk[0]), @InData[0], @OutData[0]);
  end;
end;

//  KeyIvĺ͸ݣ GCM ֤
procedure GCMEncrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer;
  AADByteLength: Integer; EnData: Pointer; var OutTag: TCnGCM128Tag;
  EncryptType: TAEADEncryptType);
var
  H: TCnGHash128Key;
  Y, Y0: TCn128BitsBuffer; // Y ƴ˼
  Cnt, M: Cardinal;      // 
  C: TCn128BitsBuffer;     // мݴ洢
  AeadCtx: TAEADContext;
  GHashCtx: TCnGHash128Context;
begin
  if Key = nil then
    KeyByteLength := 0;
  if Iv = nil then
    IvByteLength := 0;
  if AAD = nil then
    AADByteLength := 0;

  AEADEncryptInit(AeadCtx, Key, KeyByteLength, EncryptType);

  //  Enc(Key, 128  0)õ H
  FillChar(H[0], SizeOf(H), 0);
  AEADEncryptBlock(AeadCtx, TCn128BitsBuffer(H), TCn128BitsBuffer(H), EncryptType);

  // ʼԺ Cnt  Y ĺ 32 λ
  if IvByteLength = CN_GCM_NONCE_LENGTH then
  begin
    Move(Iv^, Y[0], CN_GCM_NONCE_LENGTH);
    Cnt := 1;
    M := Int32HostToNetwork(Cnt);
    Move(M, Y[CN_GCM_NONCE_LENGTH], SizeOf(M));
  end
  else
  begin
    GHash128(H, Iv, IvByteLength, nil, 0, TCnGHash128Tag(Y));
    Move(Y[CN_GCM_NONCE_LENGTH], Cnt, SizeOf(Cardinal));
    ReverseMemory(@Cnt, SizeOf(Cardinal));
  end;

  // Ȱʼ Y ֵļܽ
  AEADEncryptBlock(AeadCtx, TCn128BitsBuffer(Y), TCn128BitsBuffer(Y0), EncryptType);

  // ʼ GHash
  GHash128Start(GHashCtx, H, AAD, AADByteLength);

  // ʼѭ
  while PlainByteLength >= CN_AEAD_BLOCK do
  begin
    //  Y
    Inc(Cnt);
    M := Int32HostToNetwork(Cnt);
    Move(M, Y[CN_GCM_NONCE_LENGTH], SizeOf(M));

    //  Y  C ʱõļܽ
    AEADEncryptBlock(AeadCtx, TCn128BitsBuffer(Y), C, EncryptType);

    // C õĽ
    MemoryXor(PlainData, @C[0], SizeOf(TCn128BitsBuffer), @C[0]);

    // 
    Move(C[0], EnData^, SizeOf(TCn128BitsBuffer));

    // C  GHash
    GHash128Update(GHashCtx, @C[0], SizeOf(TCn128BitsBuffer));

    // ׼һ
    PlainData := Pointer(TCnNativeInt(PlainData) + CN_AEAD_BLOCK);
    EnData := Pointer(TCnNativeInt(EnData) + CN_AEAD_BLOCK);
    Dec(PlainByteLength, CN_AEAD_BLOCK);
  end;

  if PlainByteLength > 0 then
  begin
    //  Y
    Inc(Cnt);
    M := Int32HostToNetwork(Cnt);
    Move(M, Y[CN_GCM_NONCE_LENGTH], SizeOf(M));

    //  Y  C ʱõļܽ
    AEADEncryptBlock(AeadCtx, TCn128BitsBuffer(Y), C, EncryptType);

    // C õĽֻ PlainByteLength
    MemoryXor(PlainData, @C[0], PlainByteLength, @C[0]);

    // ģ
    Move(C[0], EnData^, PlainByteLength);

    // C  GHash
    GHash128Update(GHashCtx, @C[0], PlainByteLength);
  end;

  //  GHash  Tag
  GHash128Finish(GHashCtx, TCnGHash128Tag(OutTag));

  // ٺͿʼõ Tag
  MemoryXor(@OutTag[0], @Y0[0], SizeOf(TCnGHash128Tag), @OutTag[0]);
end;

//  KeyIvĺ͸ݣ GCM ֤
function GCMDecrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer;
  AADByteLength: Integer; PlainData: Pointer; var InTag: TCnGCM128Tag;
  EncryptType: TAEADEncryptType): Boolean;
var
  H: TCnGHash128Key;
  Y, Y0: TCn128BitsBuffer; // Y ƴ˼
  Cnt, M: Cardinal;      // 
  C: TCn128BitsBuffer;     // мݴ洢
  AeadCtx: TAEADContext;
  GHashCtx: TCnGHash128Context;
  Tag: TCnGCM128Tag;
begin
  if Key = nil then
    KeyByteLength := 0;
  if Iv = nil then
    IvByteLength := 0;
  if AAD = nil then
    AADByteLength := 0;

  AEADEncryptInit(AeadCtx, Key, KeyByteLength, EncryptType);

  //  Enc(Key, 128  0)õ H
  FillChar(H[0], SizeOf(H), 0);
  AEADEncryptBlock(AeadCtx, TCn128BitsBuffer(H), TCn128BitsBuffer(H), EncryptType);

  // ʼԺ Cnt  Y ĺ 32 λ
  if IvByteLength = CN_GCM_NONCE_LENGTH then
  begin
    Move(Iv^, Y[0], CN_GCM_NONCE_LENGTH);
    Cnt := 1;
    M := Int32HostToNetwork(Cnt);
    Move(M, Y[CN_GCM_NONCE_LENGTH], SizeOf(M));
  end
  else
  begin
    GHash128(H, Iv, IvByteLength, nil, 0, TCnGHash128Tag(Y));
    Move(Y[CN_GCM_NONCE_LENGTH], Cnt, SizeOf(Cardinal));
    ReverseMemory(@Cnt, SizeOf(Cardinal));
  end;

  // Ȱʼ Y ֵļܽ
  AEADEncryptBlock(AeadCtx, TCn128BitsBuffer(Y), TCn128BitsBuffer(Y0), EncryptType);

  // ʼ GHash
  GHash128Start(GHashCtx, H, AAD, AADByteLength);

  // ʼѭ
  while EnByteLength >= CN_AEAD_BLOCK do
  begin
    //  Y
    Inc(Cnt);
    M := Int32HostToNetwork(Cnt);
    Move(M, Y[CN_GCM_NONCE_LENGTH], SizeOf(M));

    // Ƚ GHash
    GHash128Update(GHashCtx, EnData, SizeOf(TCn128BitsBuffer));

    //  Y  C ʱõļܽ
    AEADEncryptBlock(AeadCtx, TCn128BitsBuffer(Y), C, EncryptType);

    // C õĽ
    MemoryXor(EnData, @C[0], SizeOf(TCn128BitsBuffer), @C[0]);

    // 
    Move(C[0], PlainData^, SizeOf(TCn128BitsBuffer));

    // ׼һ
    EnData := Pointer(TCnNativeInt(EnData) + CN_AEAD_BLOCK);
    PlainData := Pointer(TCnNativeInt(PlainData) + CN_AEAD_BLOCK);
    Dec(EnByteLength, CN_AEAD_BLOCK);
  end;

  if EnByteLength > 0 then
  begin
    //  Y
    Inc(Cnt);
    M := Int32HostToNetwork(Cnt);
    Move(M, Y[CN_GCM_NONCE_LENGTH], SizeOf(M));

    // Ƚ GHash
    GHash128Update(GHashCtx, EnData, EnByteLength);

    //  Y  C ʱõļܽ
    AEADEncryptBlock(AeadCtx, TCn128BitsBuffer(Y), C, EncryptType);

    // C õĽֻ EnByteLength
    MemoryXor(EnData, @C[0], EnByteLength, @C[0]);

    // ģ
    Move(C[0], PlainData^, EnByteLength);
  end;

  //  GHash  Tag
  GHash128Finish(GHashCtx, TCnGHash128Tag(Tag));

  // ٺͿʼõ Tag
  MemoryXor(@Tag[0], @Y0[0], SizeOf(TCnGHash128Tag), @Tag[0]);

  Result := CompareMem(@Tag[0], @InTag[0], SizeOf(TCnGHash128Tag));
end;

function GCMEncryptBytes(Key, Iv, PlainData, AAD: TBytes; var OutTag: TCnGCM128Tag;
  EncryptType: TAEADEncryptType): TBytes;
var
  K, I, P, A: Pointer;
begin
  if Key = nil then
    K := nil
  else
    K := @Key[0];

  if Iv = nil then
    I := nil
  else
    I := @Iv[0];

  if PlainData = nil then
    P := nil
  else
    P := @PlainData[0];

  if AAD = nil then
    A := nil
  else
    A := @AAD[0];

  if Length(PlainData) > 0 then
  begin
    SetLength(Result, Length(PlainData));
    GCMEncrypt(K, Length(Key), I, Length(Iv), P, Length(PlainData), A,
      Length(AAD), @Result[0], OutTag, EncryptType);
  end
  else
  begin
    GCMEncrypt(K, Length(Key), I, Length(Iv), P, Length(PlainData), A,
      Length(AAD), nil, OutTag, EncryptType);
  end;
end;

function GCMDecryptBytes(Key, Iv, EnData, AAD: TBytes; var InTag: TCnGCM128Tag;
  EncryptType: TAEADEncryptType): TBytes;
var
  K, I, P, A: Pointer;
begin
  if Key = nil then
    K := nil
  else
    K := @Key[0];

  if Iv = nil then
    I := nil
  else
    I := @Iv[0];

  if EnData = nil then
    P := nil
  else
    P := @EnData[0];

  if AAD = nil then
    A := nil
  else
    A := @AAD[0];

  if Length(EnData) > 0 then
  begin
    SetLength(Result, Length(EnData));
    if not GCMDecrypt(K, Length(Key), I, Length(Iv), P, Length(EnData), A,
      Length(AAD), @Result[0], InTag, EncryptType) then // Tag ȶʧ򷵻
      SetLength(Result, 0);
  end
  else
  begin
    GCMDecrypt(K, Length(Key), I, Length(Iv), P, Length(EnData), A,
      Length(AAD), nil, InTag, EncryptType); // ûģʵ Tag ȶԳɹû
  end;
end;

function AES128GCMEncryptBytes(Key, Iv, PlainData, AAD: TBytes; var OutTag: TCnGCM128Tag): TBytes;
begin
  Result := GCMEncryptBytes(Key, Iv, PlainData, AAD, OutTag, aetAES128);
end;

function AES192GCMEncryptBytes(Key, Iv, PlainData, AAD: TBytes; var OutTag: TCnGCM128Tag): TBytes;
begin
  Result := GCMEncryptBytes(Key, Iv, PlainData, AAD, OutTag, aetAES192);
end;

function AES256GCMEncryptBytes(Key, Iv, PlainData, AAD: TBytes; var OutTag: TCnGCM128Tag): TBytes;
begin
  Result := GCMEncryptBytes(Key, Iv, PlainData, AAD, OutTag, aetAES256);
end;

function SM4GCMEncryptBytes(Key, Iv, PlainData, AAD: TBytes; var OutTag: TCnGCM128Tag): TBytes;
begin
  Result := GCMEncryptBytes(Key, Iv, PlainData, AAD, OutTag, aetSM4);
end;

procedure AES128GCMEncrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnGCM128Tag);
begin
  GCMEncrypt(Key, KeyByteLength, Iv, IvByteLength, PlainData, PlainByteLength,
    AAD, AADByteLength, OutEnData, OutTag, aetAES128);
end;

procedure AES192GCMEncrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnGCM128Tag);
begin
  GCMEncrypt(Key, KeyByteLength, Iv, IvByteLength, PlainData, PlainByteLength,
    AAD, AADByteLength, OutEnData, OutTag, aetAES192);
end;

procedure AES256GCMEncrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnGCM128Tag);
begin
  GCMEncrypt(Key, KeyByteLength, Iv, IvByteLength, PlainData, PlainByteLength,
    AAD, AADByteLength, OutEnData, OutTag, aetAES256);
end;

procedure SM4GCMEncrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnGCM128Tag);
begin
  GCMEncrypt(Key, KeyByteLength, Iv, IvByteLength, PlainData, PlainByteLength,
    AAD, AADByteLength, OutEnData, OutTag, aetSM4);
end;

procedure AESGCMNoPaddingEncrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer;
  NonceByteLength: Integer; PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer;
  AADByteLength: Integer; OutEnData: Pointer);
var
  OutTag: TCnGCM128Tag;
begin
  GCMEncrypt(Key, KeyByteLength, Nonce, NonceByteLength, PlainData, PlainByteLength,
    AAD, AADByteLength, OutEnData, OutTag, aetAES256);
  Move(OutTag[0], Pointer(TCnNativeInt(OutEnData) +PlainByteLength)^, SizeOf(TCnGCM128Tag));
end;

function AES128GCMDecryptBytes(Key, Iv, EnData, AAD: TBytes; var InTag: TCnGCM128Tag): TBytes;
begin
  Result := GCMDecryptBytes(Key, Iv, EnData, AAD, InTag, aetAES128);
end;

function AES192GCMDecryptBytes(Key, Iv, EnData, AAD: TBytes; var InTag: TCnGCM128Tag): TBytes;
begin
  Result := GCMDecryptBytes(Key, Iv, EnData, AAD, InTag, aetAES192);
end;

function AES256GCMDecryptBytes(Key, Iv, EnData, AAD: TBytes; var InTag: TCnGCM128Tag): TBytes;
begin
  Result := GCMDecryptBytes(Key, Iv, EnData, AAD, InTag, aetAES256);
end;

function SM4GCMDecryptBytes(Key, Iv, EnData, AAD: TBytes; var InTag: TCnGCM128Tag): TBytes;
begin
  Result := GCMDecryptBytes(Key, Iv, EnData, AAD, InTag, aetSM4);
end;

function AES128GCMDecrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnGCM128Tag): Boolean;
begin
  Result := GCMDecrypt(Key, KeyByteLength, Iv, IvByteLength, EnData, EnByteLength,
    AAD, AADByteLength, OutPlainData, InTag, aetAES128);
end;

function AES192GCMDecrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnGCM128Tag): Boolean;
begin
  Result := GCMDecrypt(Key, KeyByteLength, Iv, IvByteLength, EnData, EnByteLength,
    AAD, AADByteLength, OutPlainData, InTag, aetAES192);
end;

function AES256GCMDecrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnGCM128Tag): Boolean;
begin
  Result := GCMDecrypt(Key, KeyByteLength, Iv, IvByteLength, EnData, EnByteLength,
    AAD, AADByteLength, OutPlainData, InTag, aetAES256);
end;

function SM4GCMDecrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnGCM128Tag): Boolean;
begin
  Result := GCMDecrypt(Key, KeyByteLength, Iv, IvByteLength, EnData, EnByteLength,
    AAD, AADByteLength, OutPlainData, InTag, aetSM4);
end;

function AESGCMNoPaddingDecrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer;
  NonceByteLength: Integer; EnData: Pointer; EnByteLength: Integer; AAD: Pointer;
  AADByteLength: Integer; OutPlainData: Pointer): Boolean;
var
  InTag: TCnGCM128Tag;
begin
  if EnByteLength < SizeOf(TCnGCM128Tag) then // ̫˵û Tag
  begin
    Result := False;
    Exit;
  end;

  Move(Pointer(TCnNativeInt(EnData) + EnByteLength - SizeOf(TCnGCM128Tag))^, InTag[0], SizeOf(TCnGCM128Tag));
  Result := GCMDecrypt(Key, KeyByteLength, Nonce, NonceByteLength, EnData, EnByteLength - SizeOf(TCnGCM128Tag),
    AAD, AADByteLength, OutPlainData, InTag, aetAES256);
end;

procedure CMAC128(var Key: TCnCMAC128Key; Data: Pointer; DataByteLength: Integer;
  EncryptType: TAEADEncryptType; var OutTag: TCnCMAC128Tag);
var
  K1, K2: TCnCMAC128Key;
  L, X, Y: TCn128BitsBuffer;
  AeadCtx: TAEADContext;
  LastFull: Boolean;
begin
  AEADEncryptInit(AeadCtx, @Key[0], Length(Key), EncryptType);

  //  Enc(Key, 128  0)õ L
  FillChar(L[0], SizeOf(L), 0);
  AEADEncryptBlock(AeadCtx, L, L, EncryptType);

  //  L Կ
  MemoryShiftLeft(@L[0], @K1[0], SizeOf(TCnCMAC128Key), 1);
  if AeadIsBitSet(@L[0], 0) then
    MemoryXor(@K1[0], @CMAC_POLY[0], SizeOf(TCnCMAC128Key), @K1[0]);

  MemoryShiftLeft(@K1[0], @K2[0], SizeOf(TCnCMAC128Key), 1);
  if AeadIsBitSet(@K1[0], 0) then
    MemoryXor(@K2[0], @CMAC_POLY[0], SizeOf(TCnCMAC128Key), @K2[0]);

  // ʼֿ㣬ĩҪ⴦
  LastFull := (DataByteLength mod CN_AEAD_BLOCK) = 0;

  //  A
  FillChar(X[0], SizeOf(TCn128BitsBuffer), 0);
  while DataByteLength >= CN_AEAD_BLOCK do
  begin
    Move(Data^, L[0], CN_AEAD_BLOCK); //  L Ϊÿԭʼ
    if LastFull and (DataByteLength = CN_AEAD_BLOCK) then // һ
    begin
      MemoryXor(@K1[0], @L[0], CN_AEAD_BLOCK, @L[0]);
      MemoryXor(@X[0], @L[0], CN_AEAD_BLOCK, @Y[0]);
      AEADEncryptBlock(AeadCtx, Y, TCn128BitsBuffer(OutTag), EncryptType); //  Tag
      Exit;
    end;

    MemoryXor(@L[0], @X[0], SizeOf(TCn128BitsBuffer), @Y[0]);
    AEADEncryptBlock(AeadCtx, Y, X, EncryptType); // һּٴη X

    Data := Pointer(TCnNativeInt(Data) + CN_AEAD_BLOCK);
    Dec(DataByteLength, CN_AEAD_BLOCK);
  end;

  FillChar(L[0], SizeOf(TCn128BitsBuffer), 0);
  if DataByteLength > 0 then
  Move(Data^, L[0], DataByteLength);
  L[DataByteLength] := $80;         // һ飬 Padding

  MemoryXor(@K2[0], @L[0], CN_AEAD_BLOCK, @L[0]);
  MemoryXor(@X[0], @L[0], CN_AEAD_BLOCK, @Y[0]);
  AEADEncryptBlock(AeadCtx, Y, TCn128BitsBuffer(OutTag), EncryptType); //  Tag
end;

function CMAC128Bytes(Key, Data: TBytes; EncryptType: TAEADEncryptType): TCnCMAC128Tag;
var
  D: Pointer;
  Key128: TCnCMAC128Key;
begin
  if Data = nil then
    D := nil
  else
    D := @Data[0];

  MoveMost128(Key[0], Key128[0], Length(Key));
  CMAC128(Key128, D, Length(Data), EncryptType, Result);
end;

function AES128CMAC128Bytes(Key, Data: TBytes): TCnCMAC128Tag;
begin
  Result := CMAC128Bytes(Key, Data, aetAES128);
end;

function AES192CMAC128Bytes(Key, Data: TBytes): TCnCMAC128Tag;
begin
  Result := CMAC128Bytes(Key, Data, aetAES192);
end;

function AES256CMAC128Bytes(Key, Data: TBytes): TCnCMAC128Tag;
begin
  Result := CMAC128Bytes(Key, Data, aetAES256);
end;

function SM4CMAC128Bytes(Key, Data: TBytes): TCnCMAC128Tag;
begin
  Result := CMAC128Bytes(Key, Data, aetSM4);
end;

function AES128CMAC128(Key: Pointer; KeyByteLength: Integer; Data: Pointer;
  DataByteLength: Integer): TCnCMAC128Tag;
var
  Key128: TCnCMAC128Key;
begin
  MoveMost128(Key^, Key128[0], KeyByteLength);
  CMAC128(Key128, Data, DataByteLength, aetAES128, Result);
end;

function AES192CMAC128(Key: Pointer; KeyByteLength: Integer; Data: Pointer;
  DataByteLength: Integer): TCnCMAC128Tag;
var
  Key128: TCnCMAC128Key;
begin
  MoveMost128(Key^, Key128[0], KeyByteLength);
  CMAC128(Key128, Data, DataByteLength, aetAES192, Result);
end;

function AES256CMAC128(Key: Pointer; KeyByteLength: Integer; Data: Pointer;
  DataByteLength: Integer): TCnCMAC128Tag;
var
  Key128: TCnCMAC128Key;
begin
  MoveMost128(Key^, Key128[0], KeyByteLength);
  CMAC128(Key128, Data, DataByteLength, aetAES256, Result);
end;

function SM4CMAC128(Key: Pointer; KeyByteLength: Integer; Data: Pointer;
  DataByteLength: Integer): TCnCMAC128Tag;
var
  Key128: TCnCMAC128Key;
begin
  MoveMost128(Key^, Key128[0], KeyByteLength);
  CMAC128(Key128, Data, DataByteLength, aetSM4, Result);
end;

procedure CCMEncrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer;
  NonceByteLength: Integer; Data: Pointer; DataByteLength: Integer;
  AAD: Pointer; AADByteLength: Integer; EnData: Pointer; var OutTag: TCnCCM128Tag;
  EncryptType: TAEADEncryptType);
var
  CMacCtx: TAEADContext;
  CtrCtx: TAEADContext;
  B0: TCn128BitsBuffer;   // CMAC ֤ʱ Iv
  CX: TCn128BitsBuffer;   // CMAC ļŵм
  A0: TCn128BitsBuffer;   // ݿĵһ飬Լ CMAC еԭʼݵм
  S0: TCn128BitsBuffer;   // һ֤ܿ
  SX: TCn128BitsBuffer;   // CTR ļŵм
  Ctr: TCn128BitsBuffer;  // CTR ļ
  Cnt, T: Int64;
  P: PByte;
begin
  if Key = nil then
    KeyByteLength := 0;
  if Nonce = nil then
    NonceByteLength := 0;
  if Data = nil then
    DataByteLength := 0;
  if AAD = nil then
    AADByteLength := 0;

  FillChar(B0[0], SizeOf(TCn128BitsBuffer), 0);
  FillChar(Ctr[0], SizeOf(TCn128BitsBuffer), 0);

//   +----+-+-+-+-+-+-+-+-+    |L'(L) 
//   | λ |7|6|5|4|3|2|1|0|    |Nonce ĳ
//   +----+-+-+-+-+-+-+-+-+
//   |    |0|A|  M' |  L' |
//   +----+-+-+-+-+-+-+-+-+

  B0[0] := 4 * (CN_CCM_M_LEN - 2) + CN_CCM_L_LEN - 1;
  if (AAD <> nil) and (AADByteLength > 0) then
    B0[0] := B0[0] + 64;   // B0 ĵһֽ׼ãA λ 1 ʾ AAD

  Ctr[0] := CN_CCM_L_LEN - 1;

  //  15 - L  Nonce
  MoveMost(Nonce^, B0[1], NonceByteLength, CN_CCM_NONCE);
  MoveMost(Nonce^, Ctr[1], NonceByteLength, CN_CCM_NONCE);

  // ֽ˳ĳȣҴӸλض CCM_L_LEN ֽڣ B0
  P := PByte(@T);
  Inc(P, SizeOf(Int64) - CN_CCM_L_LEN);  // 佨 P  T ĸ߼λĵַϵʹ

  T := Int64HostToNetwork(DataByteLength);
  Move(P^, B0[CN_CCM_NONCE + 1], CN_CCM_L_LEN);

  // ʼ CMAC/CTR  Key ȣ׼ CMAC/CTR
  AEADEncryptInit(CMacCtx, Key, KeyByteLength, EncryptType);
  AEADEncryptInit(CtrCtx, Key, KeyByteLength, EncryptType);

  // Ctr ĺ˸ֽǼֳʼΪ 0Ҽ S0 Ϊֶ֤֮һ
  Cnt := 0;
  AEADEncryptBlock(CtrCtx, Ctr, S0, EncryptType);

  // CMAC  B0м CXҲ RFC е CBC Iv Out
  AEADEncryptBlock(CMacCtx, B0, CX, EncryptType);

  //  AAD Ļ A0
  if (B0[0] and $40 <> 0) then
  begin
    FillChar(A0[0], CN_AEAD_BLOCK, 0);

    if AADByteLength < $1000 - $100 then
    begin
      PCnWord(@A0[0])^ := Int16HostToNetwork(SmallInt(AADByteLength)); // ֽ

      // һ׼ãԼ
      MoveMost(AAD^, A0[2], AADByteLength, CN_AEAD_BLOCK - 2);

      // һ CX  CMAC ֮Ż CX
      MemoryXor(@A0[0], @CX[0], CN_AEAD_BLOCK, @CX[0]);
      AEADEncryptBlock(CMacCtx, CX, CX, EncryptType);

      // ׼
      AAD := Pointer(TCnNativeInt(AAD) + CN_AEAD_BLOCK - 2);
      Dec(AADByteLength, CN_AEAD_BLOCK - 2);
    end
    else
    begin
      // A0[0] ǰֽ׼
      A0[0] := $FF;
      A0[1] := $FE;
      PCardinal(@A0[2])^ := Int32HostToNetwork(AADByteLength); // ֽ

      // һ׼ãԼ
      MoveMost(AAD^, A0[6], AADByteLength, CN_AEAD_BLOCK - 6);

      // һ CX  CMAC ֮Ż CX
      MemoryXor(@A0[0], @CX[0], CN_AEAD_BLOCK, @CX[0]);
      AEADEncryptBlock(CMacCtx, CX, CX, EncryptType);

      // ׼
      AAD := Pointer(TCnNativeInt(AAD) + CN_AEAD_BLOCK - 6);
      Dec(AADByteLength, CN_AEAD_BLOCK - 6);
    end;

    // ĻAADByteLength ʱСڵ 0
    while AADByteLength >= CN_AEAD_BLOCK do
    begin
      Move(AAD^, A0[0], CN_AEAD_BLOCK);

      // 飨Ҳһ飩 CX  CMAC ֮Ż CX
      MemoryXor(@A0[0], @CX[0], CN_AEAD_BLOCK, @CX[0]);
      AEADEncryptBlock(CMacCtx, CX, CX, EncryptType);

      // ׼
      AAD := Pointer(TCnNativeInt(AAD) + CN_AEAD_BLOCK);
      Dec(AADByteLength, CN_AEAD_BLOCK);
    end;

    if AADByteLength > 0 then // ʣʱٶһ
    begin
      FillChar(A0[0], CN_AEAD_BLOCK, 0);
      Move(AAD^, A0[0], AADByteLength);

      // CMAC һ
      MemoryXor(@A0[0], @CX[0], CN_AEAD_BLOCK, @CX[0]);
      AEADEncryptBlock(CMacCtx, CX, CX, EncryptType);
    end;
  end;

  //  AAD  CMAC ֵʼ Data ģ A0
  // ҿʼܿ
  while DataByteLength >= CN_AEAD_BLOCK do
  begin
    Move(Data^, A0[0], CN_AEAD_BLOCK); // ķ A0

    // һɼܿ
    Inc(Cnt);
    T := Int64HostToNetwork(Cnt);
    Move(P^, Ctr[CN_CCM_NONCE + 1], CN_CCM_L_LEN);

    // õļܽ SX 
    AEADEncryptBlock(CtrCtx, Ctr, SX, EncryptType);
    // õ
    MemoryXor(@SX[0], @A0[0], CN_AEAD_BLOCK, EnData);

    // 飨Ҳһ飩 CX  CMAC ֮Ż CX
    MemoryXor(@A0[0], @CX[0], CN_AEAD_BLOCK, @CX[0]);
    AEADEncryptBlock(CMacCtx, CX, CX, EncryptType);

    // ׼
    Data := Pointer(TCnNativeInt(Data) + CN_AEAD_BLOCK);
    EnData := Pointer(TCnNativeInt(EnData) + CN_AEAD_BLOCK);
    Dec(DataByteLength, CN_AEAD_BLOCK);
  end;

  if DataByteLength > 0 then // ʣʱٶһ
  begin
    FillChar(A0[0], CN_AEAD_BLOCK, 0);
    Move(Data^, A0[0], DataByteLength);

    // һɼܿ
    Inc(Cnt);
    T := Int64HostToNetwork(Cnt);
    Move(P^, Ctr[CN_CCM_NONCE + 1], CN_CCM_L_LEN);

    // õļܽ SX 
    AEADEncryptBlock(CtrCtx, Ctr, SX, EncryptType);
    // һõ
    MemoryXor(@SX[0], @A0[0], DataByteLength, EnData);

    // CMAC һ
    MemoryXor(@A0[0], @CX[0], CN_AEAD_BLOCK, @CX[0]);
    AEADEncryptBlock(CMacCtx, CX, CX, EncryptType);
  end;

  // ȡ CMAC Ľ CTR 0 ļܽ
  MemoryXor(@CX[0], @S0[0], CN_AEAD_BLOCK, @CX[0]);

  // ƶ OutTag з
  FillChar(OutTag[0], SizeOf(TCnCCM128Tag), 0);
  Move(CX[0], OutTag[0], CN_CCM_M_LEN);
end;

function CCMEncryptBytes(Key, Nonce, PlainData, AAD: TBytes; var OutTag: TCnCCM128Tag;
  EncryptType: TAEADEncryptType): TBytes;
var
  K, N, P, A: Pointer;
begin
  if Key = nil then
    K := nil
  else
    K := @Key[0];

  if Nonce = nil then
    N := nil
  else
    N := @Nonce[0];

  if PlainData = nil then
    P := nil
  else
    P := @PlainData[0];

  if AAD = nil then
    A := nil
  else
    A := @AAD[0];

  if Length(PlainData) > 0 then
  begin
    SetLength(Result, Length(PlainData));
    CCMEncrypt(K, Length(Key), N, Length(Nonce), P, Length(PlainData), A,
      Length(AAD), @Result[0], OutTag, EncryptType);
    if Length(Result) > 0 then
      Exit;
  end
  else
  begin
    CCMEncrypt(K, Length(Key), N, Length(Nonce), P, Length(PlainData), A,
      Length(AAD), nil, OutTag, EncryptType);
  end;
end;

function AES128CCMEncryptBytes(Key, Nonce, PlainData, AAD: TBytes; var OutTag: TCnCCM128Tag): TBytes;
begin
  Result := CCMEncryptBytes(Key, Nonce, PlainData, AAD, OutTag, aetAES128);
end;

function AES192CCMEncryptBytes(Key, Nonce, PlainData, AAD: TBytes; var OutTag: TCnCCM128Tag): TBytes;
begin
  Result := CCMEncryptBytes(Key, Nonce, PlainData, AAD, OutTag, aetAES192);
end;

function AES256CCMEncryptBytes(Key, Nonce, PlainData, AAD: TBytes; var OutTag: TCnCCM128Tag): TBytes;
begin
  Result := CCMEncryptBytes(Key, Nonce, PlainData, AAD, OutTag, aetAES256);
end;

function SM4CCMEncryptBytes(Key, Nonce, PlainData, AAD: TBytes; var OutTag: TCnCCM128Tag): TBytes;
begin
  Result := CCMEncryptBytes(Key, Nonce, PlainData, AAD, OutTag, aetSM4);
end;

procedure AES128CCMEncrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnCCM128Tag);
begin
  CCMEncrypt(Key, KeyByteLength, Nonce, NonceByteLength, PlainData, PlainByteLength,
    AAD, AADByteLength, OutEnData, OutTag, aetAES128);
end;

procedure AES192CCMEncrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnCCM128Tag);
begin
  CCMEncrypt(Key, KeyByteLength, Nonce, NonceByteLength, PlainData, PlainByteLength,
    AAD, AADByteLength, OutEnData, OutTag, aetAES192);
end;

procedure AES256CCMEncrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnCCM128Tag);
begin
  CCMEncrypt(Key, KeyByteLength, Nonce, NonceByteLength, PlainData, PlainByteLength,
    AAD, AADByteLength, OutEnData, OutTag, aetAES256);
end;

procedure SM4CCMEncrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnCCM128Tag);
begin
  CCMEncrypt(Key, KeyByteLength, Nonce, NonceByteLength, PlainData, PlainByteLength,
    AAD, AADByteLength, OutEnData, OutTag, aetSM4);
end;

function CCMDecrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer;
  AADByteLength: Integer; PlainData: Pointer; var InTag: TCnCCM128Tag;
  EncryptType: TAEADEncryptType): Boolean;
var
  CMacCtx: TAEADContext;
  CtrCtx: TAEADContext;
  B0: TCn128BitsBuffer;   // CMAC ֤ʱ Iv
  CX: TCn128BitsBuffer;   // CMAC ļŵм
  A0: TCn128BitsBuffer;   // ݿĵһ飬Լ CMAC еԭʼݵм
  S0: TCn128BitsBuffer;   // һ֤ܿ
  SX: TCn128BitsBuffer;   // CTR ļŵм
  Ctr: TCn128BitsBuffer;  // CTR ļ
  Cnt, T: Int64;
  P: PByte;
  Tag: TCnCCM128Tag;
begin
  if Key = nil then
    KeyByteLength := 0;
  if Nonce = nil then
    NonceByteLength := 0;
  if EnData = nil then
    EnByteLength := 0;
  if AAD = nil then
    AADByteLength := 0;

  FillChar(B0[0], SizeOf(TCn128BitsBuffer), 0);
  FillChar(Ctr[0], SizeOf(TCn128BitsBuffer), 0);

//   +----+-+-+-+-+-+-+-+-+    |L'(L) 
//   | λ |7|6|5|4|3|2|1|0|    |Nonce ĳ
//   +----+-+-+-+-+-+-+-+-+
//   |    |0|A|  M' |  L' |
//   +----+-+-+-+-+-+-+-+-+

  B0[0] := 4 * (CN_CCM_M_LEN - 2) + CN_CCM_L_LEN - 1;
  if (AAD <> nil) and (AADByteLength > 0) then
    B0[0] := B0[0] + 64;   // B0 ĵһֽ׼ãA λ 1 ʾ AAD

  Ctr[0] := CN_CCM_L_LEN - 1;

  //  15 - L  Nonce
  MoveMost(Nonce^, B0[1], NonceByteLength, CN_CCM_NONCE);
  MoveMost(Nonce^, Ctr[1], NonceByteLength, CN_CCM_NONCE);

  // ֽ˳ĳȣҴӸλض CCM_L_LEN ֽڣ B0
  P := PByte(@T);
  Inc(P, SizeOf(Int64) - CN_CCM_L_LEN);  // 佨 P  T ĸ߼λĵַϵʹ

  T := Int64HostToNetwork(EnByteLength);
  Move(P^, B0[CN_CCM_NONCE + 1], CN_CCM_L_LEN);

  // ʼ CMAC/CTR  Key ȣ׼ CMAC/CTR
  AEADEncryptInit(CMacCtx, Key, KeyByteLength, EncryptType);
  AEADEncryptInit(CtrCtx, Key, KeyByteLength, EncryptType);

  // Ctr ĺ˸ֽǼֳʼΪ 0Ҽ S0 Ϊֶ֤֮һ
  Cnt := 0;
  AEADEncryptBlock(CtrCtx, Ctr, S0, EncryptType);

  // CMAC  B0м CXҲ RFC е CBC Iv Out
  AEADEncryptBlock(CMacCtx, B0, CX, EncryptType);

  //  AAD Ļ A0
  if (B0[0] and $40 <> 0) then
  begin
    FillChar(A0[0], CN_AEAD_BLOCK, 0);

    if AADByteLength < $1000 - $100 then
    begin
      PCnWord(@A0[0])^ := Int16HostToNetwork(SmallInt(AADByteLength)); // ֽ

      // һ׼ãԼ
      MoveMost(AAD^, A0[2], AADByteLength, CN_AEAD_BLOCK - 2);

      // һ CX  CMAC ֮Ż CX
      MemoryXor(@A0[0], @CX[0], CN_AEAD_BLOCK, @CX[0]);
      AEADEncryptBlock(CMacCtx, CX, CX, EncryptType);

      // ׼
      AAD := Pointer(TCnNativeInt(AAD) + CN_AEAD_BLOCK - 2);
      Dec(AADByteLength, CN_AEAD_BLOCK - 2);
    end
    else
    begin
      // A0[0] ǰֽ׼
      A0[0] := $FF;
      A0[1] := $FE;
      PCardinal(@A0[2])^ := Int32HostToNetwork(AADByteLength); // ֽ

      // һ׼ãԼ
      MoveMost(AAD^, A0[6], AADByteLength, CN_AEAD_BLOCK - 6);

      // һ CX  CMAC ֮Ż CX
      MemoryXor(@A0[0], @CX[0], CN_AEAD_BLOCK, @CX[0]);
      AEADEncryptBlock(CMacCtx, CX, CX, EncryptType);

      // ׼
      AAD := Pointer(TCnNativeInt(AAD) + CN_AEAD_BLOCK - 6);
      Dec(AADByteLength, CN_AEAD_BLOCK - 6);
    end;

    // ĻAADByteLength ʱСڵ 0
    while AADByteLength >= CN_AEAD_BLOCK do
    begin
      Move(AAD^, A0[0], CN_AEAD_BLOCK);

      // 飨Ҳһ飩 CX  CMAC ֮Ż CX
      MemoryXor(@A0[0], @CX[0], CN_AEAD_BLOCK, @CX[0]);
      AEADEncryptBlock(CMacCtx, CX, CX, EncryptType);

      // ׼
      AAD := Pointer(TCnNativeInt(AAD) + CN_AEAD_BLOCK);
      Dec(AADByteLength, CN_AEAD_BLOCK);
    end;

    if AADByteLength > 0 then // ʣʱٶһ
    begin
      FillChar(A0[0], CN_AEAD_BLOCK, 0);
      Move(AAD^, A0[0], AADByteLength);

      // CMAC һ
      MemoryXor(@A0[0], @CX[0], CN_AEAD_BLOCK, @CX[0]);
      AEADEncryptBlock(CMacCtx, CX, CX, EncryptType);
    end;
  end;

  //  AAD  CMAC ֵʼ Data ģ A0
  // ҿʼܿ鲢
  while EnByteLength >= CN_AEAD_BLOCK do
  begin
    Move(EnData^, A0[0], CN_AEAD_BLOCK); // ķ A0

    // һɼܿ
    Inc(Cnt);
    T := Int64HostToNetwork(Cnt);
    Move(P^, Ctr[CN_CCM_NONCE + 1], CN_CCM_L_LEN);

    // õļܽ SX 
    AEADEncryptBlock(CtrCtx, Ctr, SX, EncryptType);
    // õ
    MemoryXor(@SX[0], @A0[0], CN_AEAD_BLOCK, PlainData);

    // 飨Ҳһ飩ĺ CX  CMAC ֮Ż CX
    MemoryXor(PlainData, @CX[0], CN_AEAD_BLOCK, @CX[0]);
    AEADEncryptBlock(CMacCtx, CX, CX, EncryptType);

    // ׼
    EnData := Pointer(TCnNativeInt(EnData) + CN_AEAD_BLOCK);
    PlainData := Pointer(TCnNativeInt(PlainData) + CN_AEAD_BLOCK);
    Dec(EnByteLength, CN_AEAD_BLOCK);
  end;

  if EnByteLength > 0 then // ʣʱٶһ
  begin
    FillChar(A0[0], CN_AEAD_BLOCK, 0);
    Move(EnData^, A0[0], EnByteLength);

    // һɼܿ
    Inc(Cnt);
    T := Int64HostToNetwork(Cnt);
    Move(P^, Ctr[CN_CCM_NONCE + 1], CN_CCM_L_LEN);

    // õļܽ SX 
    AEADEncryptBlock(CtrCtx, Ctr, SX, EncryptType);
    // һõȷ A0 ﹩
    MemoryXor(@SX[0], @A0[0], EnByteLength, @A0[0]);

    // CMAC һ
    MemoryXor(@A0[0], @CX[0], CN_AEAD_BLOCK, @CX[0]);
    AEADEncryptBlock(CMacCtx, CX, CX, EncryptType);

    // һ
    Move(A0[0], PlainData^, EnByteLength);
  end;

  // ȡ CMAC Ľ CTR 0 ļܽ
  MemoryXor(@CX[0], @S0[0], CN_AEAD_BLOCK, @CX[0]);

  // CMAC ƶ Tag 
  FillChar(Tag[0], SizeOf(TCnCCM128Tag), 0);
  Move(CX[0], Tag[0], CN_CCM_M_LEN);

  // ȶ Tag Ƿͬ
  Result := CompareMem(@Tag[0], @InTag[0], CN_CCM_M_LEN);
end;

function CCMDecryptBytes(Key, Nonce, EnData, AAD: TBytes; var InTag: TCnCCM128Tag;
  EncryptType: TAEADEncryptType): TBytes;
var
  K, N, P, A: Pointer;
begin
  if Key = nil then
    K := nil
  else
    K := @Key[0];

  if Nonce = nil then
    N := nil
  else
    N := @Nonce[0];

  if EnData = nil then
    P := nil
  else
    P := @EnData[0];

  if AAD = nil then
    A := nil
  else
    A := @AAD[0];

  if Length(EnData) > 0 then
  begin
    SetLength(Result, Length(EnData));
    if not CCMDecrypt(K, Length(Key), N, Length(Nonce), P, Length(EnData), A,
      Length(AAD), @Result[0], InTag, EncryptType) then // Tag ȶʧ򷵻
      SetLength(Result, 0);
  end
  else
  begin
    CCMDecrypt(K, Length(Key), N, Length(Nonce), P, Length(EnData), A,
      Length(AAD), nil, InTag, EncryptType); // ûģʵ Tag ȶԳɹû
  end;
end;

function AES128CCMDecryptBytes(Key, Nonce, EnData, AAD: TBytes; var InTag: TCnCCM128Tag): TBytes;
begin
  Result := CCMDecryptBytes(Key, Nonce, EnData, AAD, InTag, aetAES128);
end;

function AES192CCMDecryptBytes(Key, Nonce, EnData, AAD: TBytes; var InTag: TCnCCM128Tag): TBytes;
begin
  Result := CCMDecryptBytes(Key, Nonce, EnData, AAD, InTag, aetAES192);
end;

function AES256CCMDecryptBytes(Key, Nonce, EnData, AAD: TBytes; var InTag: TCnCCM128Tag): TBytes;
begin
  Result := CCMDecryptBytes(Key, Nonce, EnData, AAD, InTag, aetAES256);
end;

function SM4CCMDecryptBytes(Key, Nonce, EnData, AAD: TBytes; var InTag: TCnCCM128Tag): TBytes;
begin
  Result := CCMDecryptBytes(Key, Nonce, EnData, AAD, InTag, aetSM4);
end;

function AES128CCMDecrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnCCM128Tag): Boolean;
begin
  Result := CCMDecrypt(Key, KeyByteLength, Nonce, NonceByteLength, EnData, EnByteLength,
    AAD, AADByteLength, OutPlainData, InTag, aetAES128);
end;

function AES192CCMDecrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnCCM128Tag): Boolean;
begin
  Result := CCMDecrypt(Key, KeyByteLength, Nonce, NonceByteLength, EnData, EnByteLength,
    AAD, AADByteLength, OutPlainData, InTag, aetAES192);
end;

function AES256CCMDecrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnCCM128Tag): Boolean;
begin
  Result := CCMDecrypt(Key, KeyByteLength, Nonce, NonceByteLength, EnData, EnByteLength,
    AAD, AADByteLength, OutPlainData, InTag, aetAES256);
end;

function SM4CCMDecrypt(Key: Pointer; KeyByteLength: Integer; Nonce: Pointer; NonceByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnCCM128Tag): Boolean;
begin
  Result := CCMDecrypt(Key, KeyByteLength, Nonce, NonceByteLength, EnData, EnByteLength,
    AAD, AADByteLength, OutPlainData, InTag, aetSM4);
end;

// ======== װ AES|SM4/GCM ʮֽӽܺ Padding ========

function AESGCMEncryptToHex(Key, Iv, AD: TBytes; Input: TBytes): string;
var
  OutTag: TCnGCM128Tag;
  Res: TBytes;
  L: Integer;
begin
  Res := AES256GCMEncryptBytes(Key, Iv, Input, AD, OutTag);
  if Length(Res) > 0 then
  begin
    L := Length(Res);
    SetLength(Res, L + SizeOf(TCnGCM128Tag));
    Move(OutTag[0], Res[L], SizeOf(TCnGCM128Tag));
    Result := BytesToHex(Res);
  end
  else
    Result := '';
end;

function AESGCMDecryptFromHex(Key, Iv, AD: TBytes; const Input: string): TBytes;
var
  InTag: TCnGCM128Tag;
  Res: TBytes;
begin
  Res := HexToBytes(Input);
  if Length(Res) < SizeOf(TCnGCM128Tag) then // ̫˵û Tag
  begin
    Result := nil;
    Exit;
  end;

  Move(Res[Length(Res) - SizeOf(TCnGCM128Tag)], InTag[0], SizeOf(TCnGCM128Tag));
  SetLength(Res, Length(Res) - SizeOf(TCnGCM128Tag));
  Result := AES256GCMDecryptBytes(Key, Iv, Res, AD, InTag);
end;

function SM4GCMEncryptToHex(Key, Iv, AD: TBytes; Input: TBytes): string;
var
  OutTag: TCnGCM128Tag;
  Res: TBytes;
  L: Integer;
begin
  Res := SM4GCMEncryptBytes(Key, Iv, Input, AD, OutTag);
  if Length(Res) > 0 then
  begin
    L := Length(Res);
    SetLength(Res, L + SizeOf(TCnGCM128Tag));
    Move(OutTag[0], Res[L], SizeOf(TCnGCM128Tag));
    Result := BytesToHex(Res);
  end
  else
    Result := '';
end;

function SM4GCMDecryptFromHex(Key, Iv, AD: TBytes; const Input: string): TBytes;
var
  InTag: TCnGCM128Tag;
  Res: TBytes;
begin
  Res := HexToBytes(Input);
  if Length(Res) < SizeOf(TCnGCM128Tag) then // ̫˵û Tag
  begin
    Result := nil;
    Exit;
  end;

  Move(Res[Length(Res) - SizeOf(TCnGCM128Tag)], InTag[0], SizeOf(TCnGCM128Tag));
  SetLength(Res, Length(Res) - SizeOf(TCnGCM128Tag));
  Result := SM4GCMDecryptBytes(Key, Iv, Res, AD, InTag);
end;

// =================== ChaCha20_Poly1305 ݿӽܺ ======================

procedure ChaCha20Poly1305Encrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnPoly1305Digest);
var
  ChaChaKey: TCnChaChaKey;
  Nonce: TCnChaChaNonce;
  OutKey: TCnChaChaState;
  Poly1305Key: TCnPoly1305Key;
  Poly1305Context: TCnPoly1305Context;
  Lens: array[0..1] of Int64;
begin
  MoveMost(Key^, ChaChaKey[0], KeyByteLength, SizeOf(TCnChaChaKey));
  MoveMost(Iv^, Nonce[0], IvByteLength, SizeOf(TCnChaChaNonce));

  ChaCha20Block(ChaChaKey, Nonce, 0, OutKey); // עļ 0

  // 64 ֽڵ OutKey ǰһΪ Poly1305 ժҪ Tag  Key
  Move(OutKey[0], Poly1305Key[0], SizeOf(TCnPoly1305Key));

  ChaCha20EncryptData(ChaChaKey, Nonce, PlainData, PlainByteLength, OutEnData);

  // ʼֿ Poly1305
  Poly1305Init(Poly1305Context, Poly1305Key);

  //  AAD  Padding
  Poly1305Update(Poly1305Context, AAD, AADByteLength, True);

  // ļ Padding
  Poly1305Update(Poly1305Context, OutEnData, PlainByteLength, True);

  Lens[0] := AADByteLength;
  Lens[1] := PlainByteLength;
  Lens[0] := Int64ToLittleEndian(Lens[0]); // RFC 涨ҪС
  Lens[1] := Int64ToLittleEndian(Lens[1]);

  // 
  Poly1305Update(Poly1305Context, @Lens[0], SizeOf(Lens));

  // õ
  Poly1305Final(Poly1305Context, OutTag);
end;

function ChaCha20Poly1305Decrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnPoly1305Digest): Boolean;
var
  ChaChaKey: TCnChaChaKey;
  Nonce: TCnChaChaNonce;
  OutKey: TCnChaChaState;
  Poly1305Key: TCnPoly1305Key;
  Poly1305Context: TCnPoly1305Context;
  Tag: TCnPoly1305Digest;
  Lens: array[0..1] of Int64;
begin
  MoveMost(Key^, ChaChaKey[0], KeyByteLength, SizeOf(TCnChaChaKey));
  MoveMost(Iv^, Nonce[0], IvByteLength, SizeOf(TCnChaChaNonce));

  ChaCha20Block(ChaChaKey, Nonce, 0, OutKey); // עļ 0

  // 64 ֽڵ OutKey ǰһΪ Poly1305 ժҪ Tag  Key
  Move(OutKey[0], Poly1305Key[0], SizeOf(TCnPoly1305Key));

  ChaCha20DecryptData(ChaChaKey, Nonce, EnData, EnByteLength, OutPlainData);

  // ʼֿ Poly1305
  Poly1305Init(Poly1305Context, Poly1305Key);

  //  AAD  Padding
  Poly1305Update(Poly1305Context, AAD, AADByteLength, True);

  // ļ Padding
  Poly1305Update(Poly1305Context, EnData, EnByteLength, True);

  Lens[0] := AADByteLength;
  Lens[1] := EnByteLength;
  Lens[0] := Int64ToLittleEndian(Lens[0]); // RFC 涨ҪС
  Lens[1] := Int64ToLittleEndian(Lens[1]);

  // 
  Poly1305Update(Poly1305Context, @Lens[0], SizeOf(Lens));

  // õ
  Poly1305Final(Poly1305Context, Tag);

  // ҽ Tag ʹ Tag ͬͨ
  Result := CompareMem(@Tag[0], @InTag[0], SizeOf(TCnPoly1305Digest));
end;

// ================== ChaCha20_Poly1305 ֽӽܺ =====================

function ChaCha20Poly1305EncryptBytes(Key, Iv, PlainData, AAD: TBytes;
  var OutTag: TCnPoly1305Digest): TBytes;
var
  K, I, P, A: Pointer;
begin
  if Key = nil then
    K := nil
  else
    K := @Key[0];

  if Iv = nil then
    I := nil
  else
    I := @Iv[0];

  if PlainData = nil then
    P := nil
  else
    P := @PlainData[0];

  if AAD = nil then
    A := nil
  else
    A := @AAD[0];

  if Length(PlainData) > 0 then
  begin
    SetLength(Result, Length(PlainData));
    ChaCha20Poly1305Encrypt(K, Length(Key), I, Length(Iv), P, Length(PlainData), A,
      Length(AAD), @Result[0], OutTag);
  end
  else
  begin
    ChaCha20Poly1305Encrypt(K, Length(Key), I, Length(Iv), P, Length(PlainData), A,
      Length(AAD), nil, OutTag);
  end;
end;

function ChaCha20Poly1305DecryptBytes(Key, Iv, EnData, AAD: TBytes; var InTag: TCnPoly1305Digest): TBytes;
var
  K, I, P, A: Pointer;
begin
  if Key = nil then
    K := nil
  else
    K := @Key[0];

  if Iv = nil then
    I := nil
  else
    I := @Iv[0];

  if EnData = nil then
    P := nil
  else
    P := @EnData[0];

  if AAD = nil then
    A := nil
  else
    A := @AAD[0];

  if Length(EnData) > 0 then
  begin
    SetLength(Result, Length(EnData));
    if not ChaCha20Poly1305Decrypt(K, Length(Key), I, Length(Iv), P, Length(EnData), A,
      Length(AAD), @Result[0], InTag) then // Tag ȶʧ򷵻
      SetLength(Result, 0);
  end
  else
  begin
    ChaCha20Poly1305Decrypt(K, Length(Key), I, Length(Iv), P, Length(EnData), A,
      Length(AAD), nil, InTag); // ûģʵ Tag ȶԳɹû
  end;
end;

// =================== XChaCha20_Poly1305 ݿӽܺ =====================

procedure XChaCha20Poly1305Encrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  PlainData: Pointer; PlainByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutEnData: Pointer; var OutTag: TCnPoly1305Digest);
var
  ChaChaKey: TCnChaChaKey;
  H: TCnHChaChaNonce;
  N: TCnChaChaNonce;
  OutKey: TCnHChaChaSubKey;
  P: PByte;
begin
  MoveMost(Key^, ChaChaKey[0], KeyByteLength, SizeOf(TCnChaChaKey));
  MoveMost(Iv^, H[0], IvByteLength, SizeOf(TCnHChaChaNonce));

  HChaCha20SubKey(ChaChaKey, H, OutKey); // һµ Key
  N[0] := 0;                             // ֽ 0  XChaCha20 ʣ 8 ֽڹ 12 ֽΪ ChaCha20_Poly1305  Nonce
  N[1] := 0;
  N[2] := 0;
  N[3] := 0;

  P := PByte(Iv);
  Inc(P, 16);
  Move(P^, N[4], CN_XCHACHA_NONCE_SIZE - CN_HCHACHA_NONCE_SIZE);

  ChaCha20Poly1305Encrypt(@OutKey[0], SizeOf(TCnHChaChaSubKey), @N[0], SizeOf(TCnChaChaNonce),
    PlainData, PlainByteLength, AAD, AADByteLength, OutEnData, OutTag);
end;

function XChaCha20Poly1305Decrypt(Key: Pointer; KeyByteLength: Integer; Iv: Pointer; IvByteLength: Integer;
  EnData: Pointer; EnByteLength: Integer; AAD: Pointer; AADByteLength: Integer;
  OutPlainData: Pointer; var InTag: TCnPoly1305Digest): Boolean;
var
  ChaChaKey: TCnChaChaKey;
  H: TCnHChaChaNonce;
  N: TCnChaChaNonce;
  OutKey: TCnHChaChaSubKey;
  P: PByte;
begin
  MoveMost(Key^, ChaChaKey[0], KeyByteLength, SizeOf(TCnChaChaKey));
  MoveMost(Iv^, H[0], IvByteLength, SizeOf(TCnHChaChaNonce));

  HChaCha20SubKey(ChaChaKey, H, OutKey); // һµ Key
  N[0] := 0;                             // ֽ 0  XChaCha20 ʣ 8 ֽڹ 12 ֽΪ ChaCha20_Poly1305  Nonce
  N[1] := 0;
  N[2] := 0;
  N[3] := 0;

  P := PByte(Iv);
  Inc(P, 16);
  Move(P^, N[4], CN_XCHACHA_NONCE_SIZE - CN_HCHACHA_NONCE_SIZE);

  Result := ChaCha20Poly1305Decrypt(@OutKey[0], SizeOf(TCnHChaChaSubKey), @N[0], SizeOf(TCnChaChaNonce),
    EnData, EnByteLength, AAD, AADByteLength, OutPlainData, InTag);
end;

// ================== XChaCha20_Poly1305 ֽӽܺ ====================

function XChaCha20Poly1305EncryptBytes(Key, Iv, PlainData, AAD: TBytes;
  var OutTag: TCnPoly1305Digest): TBytes;
var
  K, I, P, A: Pointer;
begin
  if Key = nil then
    K := nil
  else
    K := @Key[0];

  if Iv = nil then
    I := nil
  else
    I := @Iv[0];

  if PlainData = nil then
    P := nil
  else
    P := @PlainData[0];

  if AAD = nil then
    A := nil
  else
    A := @AAD[0];

  if Length(PlainData) > 0 then
  begin
    SetLength(Result, Length(PlainData));
    XChaCha20Poly1305Encrypt(K, Length(Key), I, Length(Iv), P, Length(PlainData), A,
      Length(AAD), @Result[0], OutTag);
  end
  else
  begin
    XChaCha20Poly1305Encrypt(K, Length(Key), I, Length(Iv), P, Length(PlainData), A,
      Length(AAD), nil, OutTag);
  end;
end;

function XChaCha20Poly1305DecryptBytes(Key, Iv, EnData, AAD: TBytes; var InTag: TCnPoly1305Digest): TBytes;
var
  K, I, P, A: Pointer;
begin
  if Key = nil then
    K := nil
  else
    K := @Key[0];

  if Iv = nil then
    I := nil
  else
    I := @Iv[0];

  if EnData = nil then
    P := nil
  else
    P := @EnData[0];

  if AAD = nil then
    A := nil
  else
    A := @AAD[0];

  if Length(EnData) > 0 then
  begin
    SetLength(Result, Length(EnData));
    if not XChaCha20Poly1305Decrypt(K, Length(Key), I, Length(Iv), P, Length(EnData), A,
      Length(AAD), @Result[0], InTag) then // Tag ȶʧ򷵻
      SetLength(Result, 0);
  end
  else
  begin
    XChaCha20Poly1305Decrypt(K, Length(Key), I, Length(Iv), P, Length(EnData), A,
      Length(AAD), nil, InTag); // ûģʵ Tag ȶԳɹû
  end;
end;

end.
