{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnVclFmxMixed;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣ FMX عܵĹ̿ϵԪ
* ԪߣCnPack 
*     עõԪ CnCommon ЩҪͬʱ VCL  FMX ݣ
*           Ҫ CnFmxUtils ʹãԼ CnCommon ֲ FMX ʱ
* ƽ̨WinXP + Delphi XE2
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* ޸ļ¼2018.12.24 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Classes, Controls, Windows
{$IFDEF SUPPORT_FMX}
  , CnFmxUtils
{$ENDIF};

function GetControlScreenRect(AControl: TComponent): TRect;
{* ؿؼĻϵ
  Ӷ⹦ܣ AControl ǲظϽеλãߴ̶д 24}

procedure SetControlScreenRect(AControl: TComponent; ARect: TRect);
{* ÿؼĻϵע⣺ֲ֧}

function GetControlParent(AControl: TComponent): TComponent;
{* װĻȡ Conrol  Parent Ḷ́װ FMX ʵ}

function GetControlTop(AControl: TComponent): Integer;
{* װĻȡ Control  Top Ḷ́װ FMX ʵ}

function GetControlLeft(AControl: TComponent): Integer;
{* װĻȡ Control  Left Ḷ́װ FMX ʵ}

function GetControlWidth(AControl: TComponent): Integer;
{* װĻȡ Control  Width Ḷ́װ FMX ʵ}

function GetControlHeight(AControl: TComponent): Integer;
{* װĻȡ Control  Height Ḷ́װ FMX ʵ}

procedure SetControlTop(AControl: TComponent; AValue: Integer);
{* װ Control  Top Ḷ́װ FMX ʵ}

procedure SetControlLeft(AControl: TComponent; AValue: Integer);
{* װ Control  Left Ḷ́װ FMX ʵ}

procedure SetControlWidth(AControl: TComponent; AValue: Integer);
{* װ Control  Width Ḷ́װ FMX ʵ}

procedure SetControlHeight(AControl: TComponent; AValue: Integer);
{* װ Control  Height Ḷ́װ FMX ʵ}

procedure ControlBringToFront(AControl: TComponent);
{* װ Control  BringToFront Ḷ́װ FMX ʵ}

procedure ControlSendToBack(AControl: TComponent);
{* װ Control  SendToBack Ḷ́װ FMX ʵ}

implementation

// ؿؼĻϵ
function GetControlScreenRect(AControl: TComponent): TRect;
var
  AParent: TWinControl;
  P: TSmallPoint;
begin
  Assert(Assigned(AControl));
  if AControl is TControl then
  begin
    AParent := TControl(AControl).Parent;
    Assert(Assigned(AParent));
    with TControl(AControl) do
    begin
      Result.TopLeft := AParent.ClientToScreen(Point(Left, Top));
      Result.BottomRight := AParent.ClientToScreen(Point(Left + Width, Top + Height));
    end;
    Exit;
  end
  else
  begin
    P := TSmallPoint(AControl.DesignInfo);
    Result.Left := P.x;
    Result.Top := P.y;

    Result.Right := Result.Left + 24;
    Result.Bottom := Result.Top + 24;
  end;
{$IFDEF SUPPORT_FMX}
  if CnFmxIsInheritedFromControl(AControl) then
    Result := CnFmxGetControlScreenRect(AControl);
{$ENDIF}
end;

// ÿؼĻϵ
procedure SetControlScreenRect(AControl: TComponent; ARect: TRect);
var
  AParent: TWinControl;
  P1, P2: TPoint;
begin
  Assert(Assigned(AControl));
  if AControl is TControl then
  begin
    AParent := TControl(AControl).Parent;
    Assert(Assigned(AParent));
    P1 := AParent.ScreenToClient(ARect.TopLeft);
    P2 := AParent.ScreenToClient(ARect.BottomRight);
    TControl(AControl).SetBounds(P1.x, P1.y, P2.x - P1.x, P2.y - P1.y);
    Exit;
  end;
{$IFDEF SUPPORT_FMX}
  if CnFmxIsInheritedFromControl(AControl) then
    CnFmxSetControlScreenRect(AControl, ARect);
{$ENDIF}
end;

// װĻȡ Conrol  Parent Ḷ́װ FMX ʵ
function GetControlParent(AControl: TComponent): TComponent;
begin
  if AControl is TControl then
  begin
    Result := TControl(AControl).Parent;
    Exit;
  end;
{$IFDEF SUPPORT_FMX}
  Result := CnFmxGetControlParent(AControl);
{$ELSE}
  Result := nil;
{$ENDIF}
end;

// װĻȡ Control  Top Ḷ́װ FMX ʵ
function GetControlTop(AControl: TComponent): Integer;
begin
  if AControl is TControl then
  begin
    Result := TControl(AControl).Top;
    Exit;
  end;
{$IFDEF SUPPORT_FMX}
  Result := CnFmxGetControlPositionValue(AControl, fptTop);
{$ELSE}
  Result := -1;
{$ENDIF}
end;

// װĻȡ Control  Left Ḷ́װ FMX ʵ
function GetControlLeft(AControl: TComponent): Integer;
begin
  if AControl is TControl then
  begin
    Result := TControl(AControl).Left;
    Exit;
  end;
{$IFDEF SUPPORT_FMX}
  Result := CnFmxGetControlPositionValue(AControl, fptLeft);
{$ELSE}
  Result := -1;
{$ENDIF}
end;

// װĻȡ Control  Width Ḷ́װ FMX ʵ}
function GetControlWidth(AControl: TComponent): Integer;
begin
  if AControl is TControl then
  begin
    Result := TControl(AControl).Width;
    Exit;
  end;
{$IFDEF SUPPORT_FMX}
  Result := CnFmxGetControlPositionValue(AControl, fptWidth);
{$ELSE}
  Result := -1;
{$ENDIF}
end;

// װĻȡ Control  Height Ḷ́װ FMX ʵ}
function GetControlHeight(AControl: TComponent): Integer;
begin
  if AControl is TControl then
  begin
    Result := TControl(AControl).Height;
    Exit;
  end;
{$IFDEF SUPPORT_FMX}
  Result := CnFmxGetControlPositionValue(AControl, fptHeight);
{$ELSE}
  Result := -1;
{$ENDIF}
end;

// װ Control  Top Ḷ́װ FMX ʵ}
procedure SetControlTop(AControl: TComponent; AValue: Integer);
begin
  if AControl is TControl then
  begin
    TControl(AControl).Top := AValue;
    Exit;
  end;
{$IFDEF SUPPORT_FMX}
  CnFmxSetControlPositionValue(AControl, AValue, fptTop);
{$ENDIF}
end;

{* װ Control  Left Ḷ́װ FMX ʵ}
procedure SetControlLeft(AControl: TComponent; AValue: Integer);
begin
  if AControl is TControl then
  begin
    TControl(AControl).Left := AValue;
    Exit;
  end;
{$IFDEF SUPPORT_FMX}
  CnFmxSetControlPositionValue(AControl, AValue, fptLeft);
{$ENDIF}
end;

{* װ Control  Width Ḷ́װ FMX ʵ}
procedure SetControlWidth(AControl: TComponent; AValue: Integer);
begin
  if AControl is TControl then
  begin
    TControl(AControl).Width := AValue;
    Exit;
  end;
{$IFDEF SUPPORT_FMX}
  CnFmxSetControlPositionValue(AControl, AValue, fptWidth);
{$ENDIF}
end;

{* װ Control  Height Ḷ́װ FMX ʵ}
procedure SetControlHeight(AControl: TComponent; AValue: Integer);
begin
  if AControl is TControl then
  begin
    TControl(AControl).Height := AValue;
    Exit;
  end;
{$IFDEF SUPPORT_FMX}
  CnFmxSetControlPositionValue(AControl, AValue, fptHeight);
{$ENDIF}
end;

// װ Control  BringToFront Ḷ́װ FMX ʵ
procedure ControlBringToFront(AControl: TComponent);
begin
  if AControl is TControl then
  begin
    TControl(AControl).BringToFront;
    Exit;
  end;
{$IFDEF SUPPORT_FMX}
  CnFmxControlBringToFront(AControl);
{$ENDIF}
end;

// װ Control  SendToBack Ḷ́װ FMX ʵ
procedure ControlSendToBack(AControl: TComponent);
begin
  if AControl is TControl then
  begin
    TControl(AControl).SendToBack;
    Exit;
  end;
{$IFDEF SUPPORT_FMX}
  CnFmxControlSendToBack(AControl);
{$ENDIF}
end;

end.
