{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnVarList;
{* |<PRE>
================================================================================
* ƣ
* Ԫƣб
* Ԫߣ簲zzzl
*     ֲChide Ng
*           Liu Xiao
*     עõԪʵһбࣨCListܽͻʵ
            бУתΪַ֮Ҳִַ֧лԭбݣ
            лԭֶ֧͡
* ƽ̨PWin2K SP3 + Delphi 7
* ݲԣPWin9X/2000/XP + Delphi 6/7 C++Builder 6
*   õԪеַϱػʽ
* ޸ļ¼2008.05.16
*                Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Windows, Classes, Math{$IFDEF COMPILER6_UP}, Variants, StrUtils{$ENDIF};

type
  TCnVars = array of Variant;

  TCnVarList = class(TObject)
  private
    FValues: TCnVars;
    FValType: TCnVars;
    function GetCount: Integer;
    function Get(Index: Integer): Variant;
  protected
    function GetString(cList : TCnVarList): WideString;
    procedure DynArrayDelete(var A; elSize: Longint; Index, Count: Integer); virtual;
    function GetList(Index: Integer): TCnVarList;
    {*  I  CnVarList򷵻ش˷װ List, ⲿʹϺͷš}
  public
    constructor Create; virtual;
    destructor Destroy; override;

    procedure SetValues(const AValues: array of Variant);
    procedure Clear;
    procedure Add(AValue: Variant); overload;
    {* һӵбУһ VarArray}
    procedure Add(AValue: TCnVarList); overload;
    {* һбӵбУʵǽһбе Values ӽ}
    procedure Add(AValue: TObject); overload;
    {* һͨע޷ַԭ}
    procedure Remove(Index: Integer);
    {* ɾ Index λֵָ}
    function GetType(Index: Integer): string;
    {* бĳλõıĶӦ͵ַ}
    function GetObject(Index: Integer): TObject;
    {* бĳλõĶʵǶ򷵻 nil}
{$IFDEF UNICODE}
    function ToString: string; override;
    {* бתַǶ}
{$ELSE}
    function ToString: WideString; {$IFDEF OBJECT_HAS_TOSTRING} override; {$ENDIF}
    {* бתַǶ}
{$ENDIF}
    function FromString(Text: WideString; var Error: string): Boolean;
    {* ַлָбʽ򷵻 FalseϢ Error }
    
    property Count: Integer read GetCount;
    {* бԪ}
    property Items[Index: Integer]: Variant read Get;
    {*  Index ñֵ}
    property Values: TCnVars read FValues write FValues;
    {* }
    property ValType: TCnVars read FValType write FValType;
    {* }
  end;

implementation

{$IFDEF DEBUG}
uses
  CnDebug;
{$ENDIF}

{$IFNDEF COMPILER6_UP}
type
  TVarType = Word;

function TryStrToInt(const S: string; out Value: Integer): Boolean;
var
  E: Integer;
begin
  Val(S, Value, E);
  Result := E = 0;
end;

function StrToBool(const S: string): Boolean;
begin
  if UpperCase(S) = 'TRUE' then
    Result := True
  else if UpperCase(S) = 'FALSE' then
    Result := False
  else
    raise EConvertError.CreateFmt('Invalid Boolean Value: %s', [S]);
end;

function AnsiDequotedStr(const S: string; AQuote: Char): string;
var
  LText: PChar;
begin
  LText := PChar(S);
  Result := AnsiExtractQuotedStr(LText, AQuote);
  if Result = '' then
    Result := S;
end;

const
  cSimpleBoolStrs: array [Boolean] of string = ('False', 'True');

function BoolToStr(B: Boolean; UseBoolStrs: Boolean): string;
begin
  Result := cSimpleBoolStrs[B];
end;

function VarTypeAsText(const AType: TVarType): string;
const
  CText: array [varEmpty..varByte] of string = ('Empty', 'Null', 'Smallint', //Do not localize
    'Integer', 'Single', 'Double', 'Currency', 'Date', 'OleStr', 'Dispatch', //Do not localize
    'Error', 'Boolean', 'Variant', 'Unknown', 'Decimal', '$0F', 'ShortInt', //Do not localize
    'Byte'); //Do not localize
begin
  if AType and varTypeMask <= varByte then
    Result := CText[AType and varTypeMask]
  else if AType = varString then
    Result := 'String' //Do not localize
{$IFDEF UNICODE}
  else if AType = varUString then
    Result := 'UString' //Do not localize
{$ENDIF}
  else if AType = varAny then
    Result := 'Any' //Do not localize
  else
    Result := HexDisplayPrefix + IntToHex(AType and varTypeMask, 4);

  if AType and varArray <> 0 then
    Result := 'Array ' + Result; //Do not localize
  if AType and varByRef <> 0 then
    Result := 'ByRef ' + Result; //Do not localize
end;

{$ENDIF}

var
  FVarList: TList = nil;

{ TCnVarList }

procedure TCnVarList.Add(AValue: TCnVarList);
begin
  if (AValue = nil) or (AValue = Self) then Exit;
  SetLength(FValues, Length(FValues) + 1);
  SetLength(FValType, Length(FValType) + 1);
  FValues[High(FValues)] := AValue.FValues;
  FValType[High(FValType)] := AValue.FValType;
end;

procedure TCnVarList.Add(AValue: Variant);
begin
  SetLength(FValues, Length(FValues)+ 1);
  SetLength(FValType, Length(FValType)+ 1);
  FValues[High(FValues)] := AValue;
  FValType[High(FValType)] := VarTypeAsText(VarType(AValue));
end;

procedure TCnVarList.Add(AValue: TObject);
begin
  if not Assigned(Avalue) then Exit;
  SetLength(FValues, Length(FValues)+ 1);
  SetLength(FValType, Length(FValType)+ 1);
  FValues[High(FValues)] := Integer(AValue);
  FValType[High(FValType)] := 'Object:' + AValue.ClassName;
end;

procedure TCnVarList.Clear;
begin
  SetLength(FValues, 0);
  SetLength(FValType, 0);
end;

{
  A ͣelSize = SizeOf(A) Index ʼɾλ Count ɾ
}
constructor TCnVarList.Create;
begin
  FVarList.Add(Self);
end;

destructor TCnVarList.Destroy;
begin
  FVarList.Remove(Self);
  inherited;
end;

procedure TCnVarList.DynArrayDelete(var A; elSize, Index, Count: Integer);
var
  Len, MaxDelete: Integer;
  P : PLongint;
begin
  P := PLongint(A);
  if P = nil then
   Exit;
{ ȫͬ Dec(P) ; Len := P^
  Ϊ Dec(P) = Pchar(P) C 4  ͬƶ4 ֽڵƫֻֽ߰ƶ    }
  Len := PLongint(PChar(P) - 4)^; // ĳ ƫ -4
  if Index >= Len then //ҪɾλóΧ˳
   Exit;

  MaxDelete := Len - Index; // ɾ
  Count := Min(Count, MaxDelete); // ȡһСֵ
  if Count = 0 then  Exit;
  Dec(Len, Count);// ƶҪɾλ
  MoveMemory(PChar(P)+ Index * elSize,
             PChar(P)+ (Index + Count) * elSize ,
             (Len- Index) * elSize); //ƶڴ
  Dec(P);  //Ƴ 鳤ȡλ
  Dec(P);  //Ƴü λ
  //ٷڴ,Len µĳ. Sizeof(Longint) * 2 = 2*Dec(P)
  ReallocMem(P, Len * elSize + Sizeof(Longint) * 2);
  Inc(P); // ָ鳤
  P^ := Len; // new length
  Inc(P); // ָԪأʼλ
  PLongint(A) := P;
end;

type
  TCharState = (csUnknown,
                csBracketLeft,
                csBracketRight,  //
                csComma,
                csSq,        //
                csInteger, csString, csBoolean);

function TCnVarList.FromString(Text: WideString;
  var Error: string): Boolean;
  
  function ParseText(Text: WideString): TCnVars;
  var
    I: Integer;
    State: TCharState;
    Num: Integer;
    Element: WideString;
    eType: TVarType;
    C: WideChar;
    sqCount : Integer;
    //ÿԪرʾΪһ㡣0ԪΪself,1ΪselfµĵһList
    List : TList;
    cvl : TCnVarList;

    procedure _PushElement(); //Elementװ뵱ǰListУElement
    var
      v: Variant;
    begin
      case eType of
        varString {$IFDEF UNICODE}, varUString {$ENDIF}:  v := AnsiDequotedStr(Element, '''');
        varInteger: v := StrToInt(Element);
        varDouble:  v := StrToFloat(Element);
        varBoolean: v := StrToBool(Element);
      end;

      if List.Count > 0 then
      begin
        TCnVarList(List[List.Count - 1]).Add(v);
{$IFDEF DEBUG}
        CnDebugger.LogFmt('Add Value %d VarList: %s.', [List.Count - 1,
          TCnVarList(List[List.Count - 1]).ToString]);
{$ENDIF}
      end;
      Element := '';
    end;

    procedure _NewLayer(); 
    begin
      cvl := TCnVarList.Create;
      List.Add(cvl);
    end;

    procedure _PopLayer();
    var
      L : SmallInt;
    begin
      L := List.Count - 1;
      if L <= 0 then Exit;
{$IFDEF DEBUG}
      CnDebugger.LogFmt('The %d VarList Before Add: %s.', [L - 1, TCnVarList(List[L - 1]).ToString]);
      CnDebugger.LogFmt('The %d VarList Before Add: %s.', [L, TCnVarList(List[L]).ToString]);
{$ENDIF}
      TCnVarList(List[L - 1]).Add(TCnVarList(List[L]));
{$IFDEF DEBUG}
      CnDebugger.LogFmt('The %d VarList After Add: %s.', [L - 1, TCnVarList(List[L - 1]).ToString]);
{$ENDIF}
      TCnVarList(List[L]).Free;
{$IFDEF DEBUG}
      CnDebugger.LogFmt('The %d VarList After Free: %s.', [L - 1, TCnVarList(List[L - 1]).ToString]);
{$ENDIF}
      List.Delete(L);
    end;

    procedure _WantNewElement(); //TextIλÿʼΪһµԪؿʼ
    begin
      if C = '''' then
      begin
        Element := '''';
        eType := varString;
        State := csSq;
      end
      else if TryStrToInt(C, Num) then
      begin
        Element := C;
        eType := varInteger;
        State := csInteger;
      end
      else if (C = 't') or (C = 'T') or (C = 'f') or (C = 'F') then
      begin
        Element := C;
        eType := varBoolean;
        State := csBoolean;
      end
      else if C = '(' then
        _NewLayer;
    end;
  begin
    State := csUnknown;
    sqCount := 0;
    for I := 1 to Length(Text) do
    begin
      C := Text[I];
      case State of
        csUnknown:
          begin
            if C = '(' then
            begin // ҵʼ
              State := csBracketLeft;
              List := TList.Create;
              List.Add(Self);
            end;
          end;
        csBracketLeft:
          begin
            if C = ')' then
            begin
              if Element <> '' then
                _PushElement;

              if List.Count > 0 then
                _PopLayer;

              State := csBracketRight;
              end
            else
              if C = '(' then
              begin
                _NewLayer;
              end
              else
                _WantNewElement;
          end;
        csBracketRight:
          begin
            if Element <> '' then
              _PushElement;
            if List.Count > 0 then
                _PopLayer;
            if C = ',' then
              State := csComma
            else
              _WantNewElement;
            end;
        csComma:
          begin
            if Element <> '' then
              _PushElement;
            _WantNewElement;
          end;
        csSq:
          begin
            Element := Element + C;
            State := csString;
          end;
        csString:
          begin
            if C = ')' then
            begin
              if List.Count > 0 then
                _PopLayer;
              State := csBracketRight;
            end
            else if C = ',' then
              if sqCount mod 2 = 0 then
              begin
                State := csComma;
                sqCount := 0;
              end
              else
                Element := Element + C
            else
              Element := Element + C
          end;
        csInteger:
          begin
            if C = ',' then
              State := csComma
            else if C = ')' then
            begin
              if Element <> '' then
                _PushElement;
              if List.Count > 0 then
                _PopLayer;
              State := csBracketRight;
            end
            else if C = '.' then
            begin
              Element := Element + '.';
              eType := varDouble;
              end
            else if TryStrToInt(C, Num) then
            begin
              Element := Element + C;
            end
          end;
        csBoolean:
          begin
            if C = ')' then
            begin
              _PushElement;
              if List.Count > 0 then
                _PopLayer;
              State := csBracketRight;
            end
            else if C = ',' then
              State := csComma
            else
              Element := Element + C;
          end;
        end;
      end;
  end;
begin
  Clear;
  try
    ParseText(Text);
    Result := True;
  except
    on E: Exception do
    begin
      Error := E.Message;
      Result := False;
    end;
  end;
end;

function TCnVarList.Get(Index: Integer): Variant;
begin
  Result := FValues[Index];
end;

function TCnVarList.GetCount: Integer;
begin
  Result := Length(FValues);
end;

function TCnVarList.GetList(Index: Integer): TCnVarList;
var
  I: Integer;
  vVal, vType: Variant;
begin
  vVal := FValues[Index];
  if VarIsArray(vVal) then
  begin
    Result := TCnVarList.Create;
    vType := FValType[Index];
    SetLength(Result.FValues, VarArrayHighBound(vVal, 1) + 1);
    SetLength(Result.FValType, VarArrayHighBound(vType, 1) + 1);
    for I := VarArrayLowBound(vVal, 1) to VarArrayHighBound(vVal, 1) do
    begin
      Result.FValues[I] := vVal[I];
      Result.FValType[I] := vType[I];
    end;
  end
  else
    Result := nil;
end;

function TCnVarList.GetObject(Index: Integer): TObject;
var
  v: Variant;
begin
  Result := nil;      
  v := FValues[Index];
  if VarIsArray(v) then
    Exit;
  if Pos('Object', FValType[Index]) = 1 then
    Result := TObject(Integer(v));
end;

function TCnVarList.GetString(cList: TCnVarList): WideString;
var
  I: Integer;
  v: Variant;
  aList: TCnVarList;
begin
  Result := '';
  if not Assigned(cList) then Exit;
  Result := '(';
  for I := 0 to High(cList.Values) do
  begin
    v := cList.Values[I];
    if VarArrayDimCount(v) > 0 then
    begin
      // ԪرvararrayCnVarListģݹչ֮
      aList := cList.GetList(I);
      Result := Result + GetString(aList);
      FreeAndNil(aList);
    end
    else
    begin
      if Pos('Object', cList.ValType[I]) = 1 then
        Result := Result + QuotedStr(cList.ValType[I])
      else
        case VarType(v) of
          varString, {$IFDEF UNICODE} varUString, {$ENDIF} varOleStr:
            Result := Result + QuotedStr(v);
          varByte, {$IFDEF COMPILER6_UP}varShortInt,{$ENDIF} varSmallint,
          varInteger, varSingle, varDouble,
          {$IFDEF COMPILER6_UP}varWord, varLongWord, varInt64, {$ENDIF}
          varCurrency:
            Result := Result + VarToStr(v);
          varDate:
            Result := Result + '''' + DateTimeToStr(VarToDateTime(v)) + '''';
          varBoolean:
            Result := Result + BoolToStr(v, True);
          varVariant:
            Result := Result + QuotedStr(v);
        else
          Result := Result + 'Unknown:' + cList.ValType[I];
        end;
    end;
    if I < High(cList.Values) then
      Result := Result + ',';
  end;
  Result := Result + ')';
end;

function TCnVarList.GetType(Index: Integer): string;
begin
  Result := FValType[Index];
end;

procedure TCnVarList.Remove(Index: Integer);
begin
  DynArrayDelete(FValues, Length(FValues), Index, 1);
  DynArrayDelete(FValType, Length(FValType), Index, 1);
end;

procedure TCnVarList.SetValues(const AValues: array of Variant);
var
  I: Integer;
begin
  SetLength(FValues, Length(AValues));
  SetLength(FValType, Length(AValues));
  for I := Low(AValues) to High(AValues) do
  begin
    FValues[I] := AValues[I];
    FValType[I] := VarTypeAsText(VarType(AValues[I]));
  end;
end;

{$IFDEF UNICODE}

function TCnVarList.ToString: string;
begin
  Result := string(GetString(Self));
end;

{$ELSE}

function TCnVarList.ToString: WideString;
begin
  Result := GetString(Self);
end;

{$ENDIF}

procedure CleanVarList;
var
  I: Integer;
begin
  if FVarList <> nil then
    for I := 0 to FVarList.Count - 1 do
      TCnVarList(FVarList[I]).Free;
end;

initialization
  FVarList := TList.Create;

finalization
  CleanVarList;
  FreeAndNil(FVarList);

end.
