{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnTree;
{* |<PRE>
================================================================================
* ƣCnPack Ԫ
* ԪƣʵֵĻ൥Ԫ
* ԪߣCnPack  (master@cnpack.org)
*     עõԪΪ TCnTree  TCnLeaf ĵʵֵԪԼ
*            TCnBinaryTree/Leafֵ TCnTrieTree/Leaf
*           TCnTree/Leaf  TTreeNodes/Node Ĺϵ֧Ⱥ͹ȱ
*           ְ֧ȵ˳ֵʽֱӷʸڵ㡣
*           δȫʵ֣á
*           ⣬ComCtrls ã Windows µĴ FMX Ҳ Vcl ǰ׺Ԫ֮
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6 + 10.3.1
*   õԪеַϱػʽ
* ޸ļ¼2019.09.10 V2.0 by LiuXiao
*               ֮ȡ CnTreeClasses
*           2019.07.14 V1.9 by LiuXiao
*               ʵ浽 TreeView ʱָ Node ⡣
*           2019.04.17 V1.8 by LiuXiao
*               ֧ Win32/Win64/MacOS֧ VCL  FMX µ TreeView 
*           2015.05.30 V1.7 by LiuXiao
*               ֵ Ansi ٲģʽ
*           2015.05.22 V1.6 by LiuXiao
*               ֵʵ֡
*           2015.05.03 V1.5 by LiuXiao
*               ʵ֡
*           2015.03.16 V1.4 by LiuXiao
*               ȱĴ󣬽 Root  Level ĳ 0
*           2005.05.08 V1.3 by Alan
*                LoadFromTreeView  Clear δ RootLeaf Ĵ
*           2004.11.02 V1.2
*               Ľӿ
*           2004.09.04 V1.1
*                TreeView Ĺ
*           2004.05.29 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

{.$DEFINE ENABLE_UIINTERACT}
//  Tree ݽṹ TreeView Ƚؼ
// Ĭϲ壬üӽܿӲҪ

//  ENABLE_FMX ֧ FMX ıͷǷʹ FMXĬϲʹãԱĶ̫
{$IFNDEF ENABLE_FMX}
  {$UNDEF SUPPORT_FMX}
{$ENDIF}

uses
  SysUtils, Classes, Contnrs {$IFDEF ENABLE_UIINTERACT}
  {$IFDEF MSWINDOWS}, ComCtrls {$ENDIF} //  Windows ±ҲõԪڱѡ Vcl ǰ׺
  {$IFDEF SUPPORT_FMX}, FMX.TreeView {$ENDIF}
  // If ComCtrls not found, please add 'Vcl' to 'Unit Scope Names' in Project Options.
  {$ENDIF};

type

//==============================================================================
// Ļ࣬ʵ
//==============================================================================

  ECnTreeException = class(Exception);

  TCnTree = class;

  TCnLeaf = class(TPersistent)
  {* Ҷ}
  private
    FData: Integer;
    FText: string;
    FObj: TObject;
  protected
    FList: TList;
    FTree: TCnTree;
    FParent: TCnLeaf;
    function GetTree: TCnTree;
    function GetAllNonNilCount: Integer;
    function GetParent: TCnLeaf;
    function GetAbsoluteIndex: Integer;
    function GetAllCount: Integer;
    function GetCount: Integer;
    function GetHasChildren: Boolean;
    function GetIndex: Integer;
    function GetItems(AIndex: Integer): TCnLeaf;
    procedure SetItems(AIndex: Integer; const Value: TCnLeaf);
    function GetLevel: Integer;
    function GetSubTreeHeight: Integer; virtual;

    procedure AssignTo(Dest: TPersistent); override;
    procedure DoDepthFirstTravel;
    procedure DoWidthFirstTravel;
    function SetChild(ALeaf: TCnLeaf; Index: Integer): TCnLeaf;
    {* ĳڵ㸳ֵΪ Index ӽڵ㣬ԭڵֵ }
    property AllNonNilCount: Integer read GetAllNonNilCount;
    {* з nil ڵĿ }
  public
    constructor Create(ATree: TCnTree); virtual;
    {* 췽Ҫһ Tree  }
    destructor Destroy; override;
    {*  }
    function AddChild(ALeaf: TCnLeaf): TCnLeaf;
    {* һָӽڵΪֱӽڵ }
    function AddChildFirst(ALeaf: TCnLeaf): TCnLeaf;
    {* һָӽڵΪһֱӽڵ }
    function InsertChild(ALeaf: TCnLeaf; AIndex: Integer): TCnLeaf;
    {* ָһӽڵ }
    procedure Clear; virtual;
    {* ֱӽڵ㣬ӽڵҲᱻɾͷ  }
    procedure DeleteChild(AIndex: Integer); virtual;
    {* ɾһֱӽڵ㣬ӽڵ»ᱻɾͷ }
    procedure Delete;
    {* ɾӽڵ }
    function ExtractChild(AIndex: Integer): TCnLeaf; overload;
    {* һֱӽڵ㣬ӽڵ²ᱻɾͷ }
    function ExtractChild(ALeaf: TCnLeaf): TCnLeaf; overload;
    {* ָһӽڵ㣬ӽڵ²ᱻɾͷ }

    // ڵķ
    function GetFirstChild: TCnLeaf;
    {* õһֱӽڵ }
    function GetLastChild: TCnLeaf;
    {* һֱӽڵ }
    function GetNext: TCnLeaf;
    {* õһӽڵ㣬ޣ򷵻ͬڵĺһڵ㣬ޣ򷵻 nil }
    function GetNextChild(Value: TCnLeaf): TCnLeaf;
    {* ĳӽڵĺһͬڵ㣬򷵻 nil }
    function GetNextSibling: TCnLeaf;
    {* ͬĺһӽڵ㣬򷵻 nil }
    function GetPrev: TCnLeaf;
    {* ͬڵǰһڵ㣬ޣ򷵻ظڵ㣬ޣ򷵻 nil }
    function GetPrevChild(Value: TCnLeaf): TCnLeaf;
    {* ĳһӽڵǰһͬڵ㣬򷵻 nil }
    function GetPrevSibling: TCnLeaf;
    {* ͬǰһӽڵ㣬򷵻 nil }
    function GetAbsoluteItems(AAbsoluteIndex: Integer): TCnLeaf;
    {* ȵı˳õ n ӽڵ㣬 TreeNodes еĻ }
    function GetAbsoluteIndexFromParent(IndirectParentLeaf: TCnLeaf): Integer;
    {*  Leaf  IndirectParentLeaf ȵı˳0 ʼ
       IndirectParentLeaf Ǽӻֱ Parent 򷵻 -1}
    function HasAsParent(Value: TCnLeaf): Boolean;
    {* ָĽڵǷǱڵϼϼ }
    function IndexOf(ALeaf: TCnLeaf): Integer;
    {* ֱӽڵвǷĳһڵ㲢 }
    property AbsoluteIndex: Integer read GetAbsoluteIndex;
    {* еֵ }
    property AllCount: Integer read GetAllCount;
    {* ڵĿ }
    property Count: Integer read GetCount;
    {* ֱӽڵĿ }
    property HasChildren: Boolean read GetHasChildren;
    {* Ƿӽڵ }
    property Index: Integer read GetIndex;
    {* Ҷڵڸڵбе˳ 0 ʼ޸Ϊ -1 }
    property Items[AIndex: Integer]: TCnLeaf read GetItems write SetItems; default;
    {* ֱҶڵ }
    property SubTreeHeight: Integer read GetSubTreeHeight;
    {* ˽ڵ߶ȣӽڵʱΪ 0}

    property Level: Integer read GetLevel;
    {* ڵRoot ڵ Level Ϊ 0 }
    property Parent: TCnLeaf read GetParent;
    {* ڵ㣬д }
    property Tree: TCnTree read GetTree;
    {* һҶһ }
  published
    property Obj: TObject read FObj write FObj;
    {* Աһ}
    property Data: Integer read FData write FData;
    {* Աһԣ Tag }
    property Text: string read FText write FText;
    {* Աһַ }
  end;

  ICnTreeFiler = interface(IUnknown)
  {* Ľӿ }
    ['{E81A9CE0-2D1D-11D9-BA1C-5254AB35836A}']
    procedure LoadFromFile(Instance: TPersistent; const FileName: string);
    procedure SaveToFile(Instance: TPersistent; const FileName: string);
  end;

  TCnLeafClass = class of TCnLeaf;

{$IFDEF ENABLE_UIINTERACT}
{$IFDEF MSWINDOWS}
  TCnTreeNodeEvent = procedure (ALeaf: TCnLeaf; ATreeNode: TTreeNode;
    var Valid: Boolean) of object;
{$ENDIF}

{$IFDEF SUPPORT_FMX}
  TCnTreeViewItemEvent = procedure (ALeaf: TCnLeaf; ATreeItem: TTreeViewItem;
    var Valid: Boolean) of object;
{$ENDIF}
{$ENDIF}

  TCnTree = class(TPersistent)
  {* ʵ}
  private
    FLeafClass: TCnLeafClass;
    FBatchUpdating: Boolean;
    FLeaves: TObjectList;

    FOnWidthFirstTravelLeaf: TNotifyEvent;
    FOnDepthFirstTravelLeaf: TNotifyEvent;
{$IFDEF ENABLE_UIINTERACT}
  {$IFDEF MSWINDOWS}
    FOnSaveANode: TCnTreeNodeEvent;
    FOnLoadANode: TCnTreeNodeEvent;
  {$ENDIF}
  {$IFDEF SUPPORT_FMX}
    FOnSaveAItem: TCnTreeViewItemEvent;
    FOnLoadAItem: TCnTreeViewItemEvent;
  {$ENDIF}
{$ENDIF}
    function GetMaxLevel: Integer;
    procedure AssignLeafAndChildren(Source: TCnLeaf; DestLeaf: TCnLeaf; DestTree: TCnTree);
  protected
    FRoot: TCnLeaf;  
    function DefaultLeafClass: TCnLeafClass; virtual;

    function GetRoot: TCnLeaf;
    function GetItems(AbsoluteIndex: Integer): TCnLeaf;
    function GetCount: Integer;
    function GetRegisteredCount: Integer;
    function GetHeight: Integer; virtual;

    procedure AssignTo(Dest: TPersistent); override;

    function CreateLeaf(ATree: TCnTree): TCnLeaf; virtual;
    procedure DoDepthFirstTravelLeaf(ALeaf: TCnLeaf); virtual;
    procedure DoWidthFirstTravelLeaf(ALeaf: TCnLeaf); virtual;
{$IFDEF ENABLE_UIINTERACT}
  {$IFDEF MSWINDOWS}
    function DoLoadFromATreeNode(ALeaf: TCnLeaf; ANode: TTreeNode): Boolean; virtual;
    function DoSaveToATreeNode(ALeaf: TCnLeaf; ANode: TTreeNode): Boolean; virtual;
  {$ENDIF}

  {$IFDEF SUPPORT_FMX}
    function DoLoadFromATreeViewItem(ALeaf: TCnLeaf; AItem: TTreeViewItem): Boolean;
    function DoSaveToATreeViewItem(ALeaf: TCnLeaf; AItem: TTreeViewItem): Boolean;
  {$ENDIF}
{$ENDIF}

    procedure ValidateComingLeaf(AParent, AChild: TCnLeaf); virtual;
    {* ĳڵҪһӽڵʱã׳쳣ؿ}

    procedure RegisterLeaf(ALeaf: TCnLeaf);
    {* ҶڵãеǼǴҶڵ }
    procedure UnRegisterLeaf(ALeaf: TCnLeaf);
    {* ҶڵãȡҶڵĵǼ }

{$IFDEF ENABLE_UIINTERACT}
  {$IFDEF MSWINDOWS}
    procedure LoadFromATreeNode(ALeaf: TCnLeaf; ANode: TTreeNode); virtual;
    {* һ TreeNode ڵӽڵ㣬ݹ }
    procedure SaveToATreeNode(ALeaf: TCnLeaf; ANode: TTreeNode); virtual;
    {* ڵ㱾Լӽڵдһ TreeNodeݹ }
  {$ENDIF}

  {$IFDEF SUPPORT_FMX}
    procedure LoadFromATreeViewItem(ALeaf: TCnLeaf; AItem: TTreeViewItem); virtual;
    {* һ TreeNode ڵӽڵ㣬ݹ }
    procedure SaveToATreeViewItem(ALeaf: TCnLeaf; AItem: TTreeViewItem); virtual;
    {* ڵ㱾Լӽڵдһ TreeNodeݹ }
  {$ENDIF}
{$ENDIF}
  public
    constructor Create; overload;
    {* 췽 }
    constructor Create(LeafClass: TCnLeafClass); overload;
    {* һ췽}
    destructor Destroy; override;
    {*  }
    procedure DepthFirstTravel;
    {* ȱ }
    procedure WidthFirstTravel;
    {* йȱ }
    function ExtractLeaf(ALeaf: TCnLeaf): TCnLeaf;
    {* аһҶڵ㲢 }
    procedure Clear; virtual;
    {* ͷҶڵ㣬ͷţ֪ͨ }

    // ӷ
    function AddChildFirst(AParent: TCnLeaf): TCnLeaf;
    {* ָĽڵһӽڵ }
    function AddChild(AParent: TCnLeaf): TCnLeaf;
    {* ָĽڵһβӽڵ }
    function InsertChild(AParent: TCnLeaf; AIndex: Integer): TCnLeaf;
    {* ָĽڵһָλõӽڵ }
    function AddFirst(ASibing: TCnLeaf): TCnLeaf;
    {* ָĽڵһͬǰڵ }
    function Add(ASibing: TCnLeaf): TCnLeaf;
    {* ָĽڵһͬڵ }

    procedure ExchangeWithChild(Leaf1: TCnLeaf; Leaf2: TCnLeaf); overload;
    {* ڵλãӽڵһ𽻻 }
    procedure ExchangeWithChild(AbsoluteIndex1: Integer; AbsoluteIndex2: Integer); overload;
    {* ڵλãӽڵһ𽻻 }
    procedure Exchange(Leaf1: TCnLeaf; Leaf2: TCnLeaf); overload;
    {* ڵλ }
    procedure Exchange(AbsoluteIndex1: Integer; AbsoluteIndex2: Integer); overload;
    {* ڵλ }

{$IFDEF ENABLE_UIINTERACT}
  {$IFDEF MSWINDOWS}
    //  TreeView Ľע Root 뽻
    procedure LoadFromTreeView(ATreeView: ComCtrls.TTreeView; RootNode: TTreeNode = nil;
      RootLeaf: TCnLeaf = nil); {$IFDEF SUPPORT_FMX} overload; {$ENDIF}
    {* һ VCL  TreeView ڵݡRootNode ӽڵ㱻 RootLeaf ָ
    ڵӽڵ㣬RootNode Ϊ nil ʾȫ TreeNodesRootLeaf Ϊ nil ʾ
    Ϊ Tree.Root ֱڵ㣬Ҳнڵ}
    procedure SaveToTreeView(ATreeView: ComCtrls.TTreeView; RootNode: TTreeNode = nil;
      RootLeaf: TCnLeaf = nil); {$IFDEF SUPPORT_FMX} overload; {$ENDIF}
    {* ڵдһ VCL  TreeView RootLeaf ӽڵ㱻д RootNode ָ
    ڵӽڵ㣬RootLeaf Ϊ nil ʾд Root ӽڵ㣬ʵҲн
    㣬RootNode Ϊ nil ʾдĽΪ TreeView ĸ TreeNodes}
  {$ENDIF}

  {$IFDEF SUPPORT_FMX}
    procedure LoadFromTreeView(ATreeView: FMX.TreeView.TTreeView; RootItem: TTreeViewItem = nil;
      RootLeaf: TCnLeaf = nil); {$IFDEF MSWINDOWS} overload; {$ENDIF}
    {* һ FMX  TreeView ڵݡRootItem ӽڵ㱻 RootLeaf ָ
    ڵӽڵ㣬RootItem Ϊ nil ʾȫ TreeNodesRootLeaf Ϊ nil ʾ
    Ϊ Tree.Root ֱڵ㣬Ҳнڵ}
    procedure SaveToTreeView(ATreeView: FMX.TreeView.TTreeView; RootItem: TTreeViewItem = nil;
      RootLeaf: TCnLeaf = nil); {$IFDEF MSWINDOWS} overload; {$ENDIF}
    {* ڵдһ FMX  TreeView RootLeaf ӽڵ㱻д RootItem ָ
    ڵӽڵ㣬RootLeaf Ϊ nil ʾд Root ӽڵ㣬ʵҲн
    㣬RootItem Ϊ nil ʾдĽΪ TreeView ĸ TreeNodes}
  {$ENDIF}
{$ENDIF}

    // 
    procedure LoadFromFile(Filer: ICnTreeFiler; const FileName: string); virtual;
    {* ļڵ㣬ṩӿڵĶʵ }
    procedure SaveToFile(Filer: ICnTreeFiler; const FileName: string); virtual;
    {* ڵ㱣ļṩӿڵĶʵ }

    property BatchUpdating: Boolean read FBatchUpdating write FBatchUpdating;
    {* Ƿ£Ϊ True ʱҶڵͷʱ֪ͨ Tree }
    property Root: TCnLeaf read GetRoot;
    {* ڵ㣬Ǵ }
    property Items[AbsoluteIndex: Integer]: TCnLeaf read GetItems;
    {* ȵı˳õ n ӽڵ㣬 TreeNodes еĻƣ0  Root }
    property Count: Integer read GetCount;
    {* нڵĿ Root }
    property MaxLevel: Integer read GetMaxLevel;
    {* ڵĲRoot Ϊ 0}
    property Height: Integer read GetHeight;
    {* ߶ȣֻ Root ʱΪ 1}
    property RegisteredCount: Integer read GetRegisteredCount;
    {* עӽڵĿ }
  published
    property OnDepthFirstTravelLeaf: TNotifyEvent read FOnDepthFirstTravelLeaf write FOnDepthFirstTravelLeaf;
    {* ȱʱһҶڵʱĴ¼Sender Ǵ˽ڵ }
    property OnWidthFirstTravelLeaf: TNotifyEvent read FOnWidthFirstTravelLeaf write FOnWidthFirstTravelLeaf;
    {* ȱʱһҶڵʱĴ¼Sender Ǵ˽ڵ }

{$IFDEF ENABLE_UIINTERACT}
  {$IFDEF MSWINDOWS}
    property OnLoadANode: TCnTreeNodeEvent read FOnLoadANode write FOnLoadANode;
    {*  VCL  TreeView ڵʱÿһڵĴ¼ }
    property OnSaveANode: TCnTreeNodeEvent read FOnSaveANode write FOnSaveANode;
    {* ڵ VCL  TreeView ʱÿһڵĴ¼ }
  {$ENDIF}
  {$IFDEF SUPPORT_FMX}
    property OnLoadAItem: TCnTreeViewItemEvent read FOnLoadAItem write FOnLoadAItem;
    {*  VCL  TreeView ڵʱÿһڵĴ¼ }
    property OnSaveAItem: TCnTreeViewItemEvent read FOnSaveAItem write FOnSaveAItem;
    {* ڵ VCL  TreeView ʱÿһڵĴ¼ }
  {$ENDIF}
{$ENDIF}
  end;

{$IFDEF ENABLE_UIINTERACT}
{$IFDEF SUPPORT_FMX}

function GetNextSiblingItem(Item: TTreeViewItem): TTreeViewItem;

{$ENDIF}
{$ENDIF}

implementation

{$IFDEF ENABLE_UIINTERACT}
{$IFDEF SUPPORT_FMX}

function GetNextSiblingItem(Item: TTreeViewItem): TTreeViewItem;
var
  P: TTreeViewItem;
  T: TCustomTreeView;
begin
  Result := nil;
  P := Item.ParentItem;
  if P <> nil then
  begin
    if (Item.Index >= 0) and (Item.Index < P.Count - 1) then
      Result := P.ItemByIndex(Item.Index + 1);
    Exit;
  end;

  T := Item.TreeView;
  if T <> nil then
  begin
    if (Item.Index >= 0) and (Item.Index < T.Count - 1) then
      Result := T.Items[Item.Index + 1];
  end;
end;

{$ENDIF}
{$ENDIF}

//==============================================================================
// TCnLeaf
//==============================================================================

constructor TCnLeaf.Create(ATree: TCnTree);
begin
  inherited Create;
  Assert(ATree <> nil);
  FList := TList.Create;
  FTree := ATree;
  ATree.RegisterLeaf(Self);
end;

destructor TCnLeaf.Destroy;
var
  I: Integer;
begin
  if not FTree.BatchUpdating then
  begin
    for I := FList.Count - 1 downto 0 do
      DeleteChild(I);
    FTree.UnregisterLeaf(Self);
  end;
  FreeAndNil(FList);
  inherited;
end;

function TCnLeaf.AddChild(ALeaf: TCnLeaf): TCnLeaf;
begin
  Assert(ALeaf.Tree = Self.FTree);
  FTree.ValidateComingLeaf(Self, ALeaf);
  Result := ALeaf;
  FList.Add(Result);
  Result.FParent := Self;
end;

function TCnLeaf.AddChildFirst(ALeaf: TCnLeaf): TCnLeaf;
begin
  Assert(ALeaf.Tree = Self.FTree);
  FTree.ValidateComingLeaf(Self, ALeaf);
  Result := ALeaf;
  FList.Insert(0, Result);
  Result.FParent := Self;
end;

procedure TCnLeaf.Clear;
var
  I: Integer;
begin
  for I := FList.Count - 1 downto 0 do
  begin
    TCnLeaf(FList.Items[I]).Free;
    FList.Delete(I);
  end;
end;

procedure TCnLeaf.DeleteChild(AIndex: Integer);
begin
  if (AIndex >= 0) and (AIndex < Count) then
  begin
    TCnLeaf(FList.Items[AIndex]).Free;
    FList.Delete(AIndex);
  end;
end;

procedure TCnLeaf.Delete;
begin
  if FParent <> nil then
    FParent.DeleteChild(Index)
  else
    raise ECnTreeException.Create('Root can NOT be deleted.');
end;

function TCnLeaf.ExtractChild(ALeaf: TCnLeaf): TCnLeaf;
var
  AIndex: Integer;
begin
  if ALeaf.HasAsParent(Self) then
  begin
    AIndex := ALeaf.Index;
    Result := ALeaf.Parent.Items[AIndex];
    ALeaf.Parent.FList.Delete(AIndex);
  end
  else
    Result := nil;
end;

function TCnLeaf.ExtractChild(AIndex: Integer): TCnLeaf; 
begin
  Result := nil;
  if (AIndex >= 0) and (AIndex < Count) then
  begin
    Result := TCnLeaf(Items[AIndex]);
    Result.FParent := nil;
    FList.Delete(AIndex);
  end;
end;

procedure TCnLeaf.DoDepthFirstTravel;
var
  I: Integer;
begin
  if FTree <> nil then
    FTree.DoDepthFirstTravelLeaf(Self);
  for I := 0 to FList.Count - 1 do
    Items[I].DoDepthFirstTravel;
end;

procedure TCnLeaf.DoWidthFirstTravel;
var
  Queue: TQueue;
  I: Integer;
  Node: TCnLeaf;
begin
  // ȱӽڵĵݹ飬ǿһʹö
  if FTree <> nil then
    FTree.DoWidthFirstTravelLeaf(Self);
  Queue := TQueue.Create;
  try
    for I := 0 to FList.Count - 1 do
      Queue.Push(Items[I]);

    while Queue.Count > 0 do
    begin
      Node := TCnLeaf(Queue.Pop);
      if FTree <> nil then
        FTree.DoWidthFirstTravelLeaf(Node);

      if Node.Count > 0 then
        for I := 0 to Node.Count - 1 do
          Queue.Push(Node.Items[I]);
    end;
  finally
    Queue.Free;
  end;
end;

function TCnLeaf.GetAbsoluteIndex: Integer;
begin
  if FParent <> nil then
    Result := Self.Index + FParent.AbsoluteIndex + 1
  else
    Result := 0;
end;

function TCnLeaf.GetAbsoluteItems(AAbsoluteIndex: Integer): TCnLeaf;
var
  I, ACount, IndexCount: Integer;
begin
  Result := nil;
  if AAbsoluteIndex < 0 then
    Exit
  else
  begin
    IndexCount := 0;
    for I := 0 to Count - 1 do
    begin
      if IndexCount = AAbsoluteIndex then
      begin
        Result := Items[I];
        Exit;
      end;

      if Items[I] <> nil then
        ACount := Items[I].AllCount + 1
      else
        ACount := 1;

      if IndexCount + ACount > AAbsoluteIndex then
      begin
        Result := Items[I].GetAbsoluteItems(AAbsoluteIndex - IndexCount - 1);
        Exit;
      end
      else
        Inc(IndexCount, ACount);
    end;
  end;
end;

function TCnLeaf.GetAllCount: Integer;
var
  I: Integer;
begin
  Result := Count;
  for I := 0 to Self.Count - 1 do
    if Items[I] <> nil then
      Result := Result + Self.Items[I].AllCount;
end;

function TCnLeaf.GetCount: Integer;
begin
  Result := FList.Count;
end;

function TCnLeaf.GetFirstChild: TCnLeaf;
begin
  if HasChildren then
    Result := TCnLeaf(FList.Items[0])
  else
    Result := nil;
end;

function TCnLeaf.GetHasChildren: Boolean;
begin
  Result := FList.Count > 0;
end;

function TCnLeaf.GetIndex: Integer;
begin
  if FParent <> nil then
    Result := FParent.IndexOf(Self)
  else
    Result := -1;
end;

function TCnLeaf.GetItems(AIndex: Integer): TCnLeaf;
begin
  Result := TCnLeaf(FList.Items[AIndex]);
end;

function TCnLeaf.GetLastChild: TCnLeaf;
begin
  if HasChildren then
    Result := TCnLeaf(FList.Items[Count - 1])
  else
    Result := nil;
end;

function TCnLeaf.GetLevel: Integer;
begin
  if FParent = nil then
    Result := 0
  else
    Result := FParent.Level + 1;
end;

function TCnLeaf.GetAllNonNilCount: Integer;
var
  I: Integer;
begin
  Result := 0;
  for I := 0 to Self.Count - 1 do
    if Items[I] <> nil then
      Result := Result + Self.Items[I].AllNonNilCount + 1;
end;

function TCnLeaf.GetSubTreeHeight: Integer;
var
  I, MaxChildHeight: Integer;
begin
  Result := 0;
  if not HasChildren then
    Exit;

  MaxChildHeight := 0;
  for I := 0 to FList.Count - 1 do
  begin
    if FList[I] <> nil then
    begin
      if MaxChildHeight = 0 then // вΪ nil ӽڵ㣬 1
        MaxChildHeight := 1;

      if TCnLeaf(FList[I]).SubTreeHeight > MaxChildHeight then
        MaxChildHeight := TCnLeaf(FList[I]).SubTreeHeight;
    end;
  end;
  Result := MaxChildHeight + 1;
end;

function TCnLeaf.GetParent: TCnLeaf;
begin
  Result := FParent;
end;

function TCnLeaf.GetTree: TCnTree;
begin
  Result := FTree;
end;

function TCnLeaf.HasAsParent(Value: TCnLeaf): Boolean;
var
  AParent: TCnLeaf;
begin
  Result := False;
  if Value.Tree <> Self.Tree then
    Exit;
    
  AParent := FParent;
  while AParent <> nil do
  begin
    if AParent = Value then
    begin
      Result := True;
      Exit;
    end
    else
      AParent := AParent.Parent;
  end;
end;

function TCnLeaf.IndexOf(ALeaf: TCnLeaf): Integer;
begin
  Result := FList.IndexOf(ALeaf);
end;

function TCnLeaf.InsertChild(ALeaf: TCnLeaf; AIndex: Integer): TCnLeaf;
begin
  if (ALeaf <> nil) and (AIndex >= 0) and (AIndex <= Count) then
  begin
    Result := ALeaf;
    FList.Insert(AIndex, ALeaf);
    ALeaf.FParent := Self;
  end
  else
    Result := nil;
end;

function TCnLeaf.GetNext: TCnLeaf;
begin
  Result := GetFirstChild;
  if Result = nil then
    Result := GetNextSibling;
end;

function TCnLeaf.GetNextChild(Value: TCnLeaf): TCnLeaf;
begin
  Result := nil;
  if Value.Parent = Self then
    if Value.Index < Self.Count - 1 then
      Result := Items[Value.Index + 1];
end;

function TCnLeaf.GetNextSibling: TCnLeaf;
begin
  Result := nil;
  if Parent <> nil then
    if Index < Parent.Count - 1 then
      Result := Parent.Items[Index + 1];
end;

function TCnLeaf.GetPrev: TCnLeaf;
begin
  Result := GetPrevSibling;
  if Result = nil then
    Result := Parent;
end;

function TCnLeaf.GetPrevChild(Value: TCnLeaf): TCnLeaf;
begin
  Result := nil;
  if Value.Parent = Self then
    if Value.Index > 0 then
      Result := Items[Value.Index - 1];
end;

function TCnLeaf.GetPrevSibling: TCnLeaf;
begin
  Result := nil;
  if Parent <> nil then
    if Index > 0 then
      Result := Parent.Items[Index - 1];
end;

function TCnLeaf.SetChild(ALeaf: TCnLeaf; Index: Integer): TCnLeaf;
begin
  if (ALeaf <> nil) and (ALeaf.Tree = Self.FTree) and
    (Index >= 0) and (Index < Count) then
  begin
    Result := TCnLeaf(FList.Items[Index]);
    FList.Items[Index] := ALeaf;
    ALeaf.FParent := Self;
  end
  else
    Result := nil;
end;

procedure TCnLeaf.SetItems(AIndex: Integer; const Value: TCnLeaf);
begin
  if (AIndex >= 0) and (AIndex < Count) then
  begin
    FList.Items[AIndex] := Value;
    if Value <> nil then
      Value.FParent := Self;
  end;
end;

procedure TCnLeaf.AssignTo(Dest: TPersistent);
begin
  if Dest is TCnLeaf then
  begin
    TCnLeaf(Dest).Data := FData;
    TCnLeaf(Dest).Text := FText;
    TCnLeaf(Dest).Obj := FObj;
  end
  else
    inherited;
end;

function TCnLeaf.GetAbsoluteIndexFromParent(IndirectParentLeaf: TCnLeaf): Integer;
var
  I, Idx: Integer;
begin
  Result := -1;
  if FParent = IndirectParentLeaf then
  begin
    Idx := Index;
    Result := 0;
    for I := 0 to Idx - 1 do
      Result := Result + IndirectParentLeaf.Items[I].AllCount + 1;
  end
  else if HasAsParent(IndirectParentLeaf) then
  begin
    Result := FParent.GetAbsoluteIndexFromParent(IndirectParentLeaf)
      + GetAbsoluteIndexFromParent(FParent) + 1;
  end;
end;

//==============================================================================
// TCnTree
//==============================================================================

constructor TCnTree.Create;
begin
  inherited;
  FLeaves := TObjectList.Create(True);
  if FLeafClass = nil then
    FLeafClass := DefaultLeafClass;
  FRoot := CreateLeaf(Self);
end;

constructor TCnTree.Create(LeafClass: TCnLeafClass);
begin
  FLeafClass := LeafClass;
  Create;
end;

destructor TCnTree.Destroy;
begin
  FBatchUpdating := True;
  FLeaves.Free;
  inherited;
end;

procedure TCnTree.DepthFirstTravel;
begin
  FRoot.DoDepthFirstTravel;
end;

function TCnTree.CreateLeaf(ATree: TCnTree): TCnLeaf;
begin
  try
    Result := TCnLeaf(FLeafClass.NewInstance);
    Result.Create(ATree);
  except
    Result := nil;
  end;
end;

procedure TCnTree.DoDepthFirstTravelLeaf(ALeaf: TCnLeaf);
begin
  if Assigned(FOnDepthFirstTravelLeaf) then
    FOnDepthFirstTravelLeaf(ALeaf);
end;

procedure TCnTree.DoWidthFirstTravelLeaf(ALeaf: TCnLeaf);
begin
  if Assigned(FOnWidthFirstTravelLeaf) then
    FOnWidthFirstTravelLeaf(ALeaf);
end;

function TCnTree.GetRoot: TCnLeaf;
begin
  Result := FRoot;
end;

procedure TCnTree.RegisterLeaf(ALeaf: TCnLeaf);
begin
  if FLeaves.IndexOf(ALeaf) < 0 then
    FLeaves.Add(ALeaf);
end;

procedure TCnTree.WidthFirstTravel;
begin
  FRoot.DoWidthFirstTravel;
end;

procedure TCnTree.UnRegisterLeaf(ALeaf: TCnLeaf);
begin
  FLeaves.Extract(ALeaf);
end;

procedure TCnTree.Clear;
begin
  FBatchUpdating := True;
  try
    FLeaves.Clear;
    // FRoot Ѿ Fleaves ͷţٴͷ.
    FRoot := CreateLeaf(Self);
  finally
    FBatchUpdating := False;
  end;
end;

function TCnTree.ExtractLeaf(ALeaf: TCnLeaf): TCnLeaf;
begin
  Result := nil;
  if ALeaf.Tree = Self then
  begin
    Self.UnRegisterLeaf(ALeaf);
    if ALeaf.Parent <> nil then
      Result := ALeaf.Parent.ExtractChild(ALeaf.Index);
  end;
end;

function TCnTree.AddChild(AParent: TCnLeaf): TCnLeaf;
begin
  if AParent.Tree = Self then
  begin
    Result := CreateLeaf(Self);
    AParent.AddChild(Result);
  end
  else
    Result := nil;
end;

function TCnTree.AddChildFirst(AParent: TCnLeaf): TCnLeaf;
begin
  if AParent.Tree = Self then
  begin
    Result := CreateLeaf(Self);
    AParent.AddChildFirst(Result);
  end
  else
    Result := nil;
end;

function TCnTree.InsertChild(AParent: TCnLeaf; AIndex: Integer): TCnLeaf;
begin
  if AParent.Tree = Self then
  begin
    Result := CreateLeaf(Self);
    if AParent.InsertChild(Result, AIndex) = nil then
    begin
      Result.Free;
      Result := nil;
    end;
  end
  else
    Result := nil;
end;

function TCnTree.AddFirst(ASibing: TCnLeaf): TCnLeaf;
begin
  if (ASibing <> nil) and (ASibing.Tree = Self) and (ASibing.Parent <> nil) then
  begin
    Result := CreateLeaf(Self);
    if ASibing.Parent.AddChildFirst(Result) = nil then
    begin
      Result.Free;
      Result := nil;
    end;
  end
  else
    Result := nil;
end;

function TCnTree.Add(ASibing: TCnLeaf): TCnLeaf;
begin
  if (ASibing <> nil) and (ASibing.Tree = Self) and (ASibing.Parent <> nil) then
  begin
    Result := CreateLeaf(Self);
    if ASibing.Parent.AddChild(Result) = nil then
    begin
      Result.Free;
      Result := nil;
    end;
  end
  else
    Result := nil;
end;

procedure TCnTree.Exchange(AbsoluteIndex1, AbsoluteIndex2: Integer); 
begin
  Exchange(Items[AbsoluteIndex1], Items[AbsoluteIndex2]);
end;

procedure TCnTree.ExchangeWithChild(AbsoluteIndex1,
  AbsoluteIndex2: Integer);
begin
  ExchangeWithChild(Items[AbsoluteIndex1], Items[AbsoluteIndex2]);
end;

procedure TCnTree.ExchangeWithChild(Leaf1, Leaf2: TCnLeaf); 
var
  Parent2: TCnLeaf;
  Index2: Integer;
begin
  if (Leaf1 <> nil) and (Leaf2 <> nil) and (Leaf1 <> Leaf2)
    and (Leaf1.Tree = Self) and (Leaf2.Tree = Self) then
  begin
    if Leaf1.HasAsParent(Leaf2) or Leaf2.HasAsParent(Leaf1) then
      Exit; // ΪӹϵĲ
    Parent2 := Leaf2.Parent;
    Index2 := Leaf2.Index;

    Leaf1.Parent.SetChild(Leaf2, Leaf1.Index);
    Parent2.SetChild(Leaf1, Index2);
  end;
end;

procedure TCnTree.Exchange(Leaf1, Leaf2: TCnLeaf);
var
  Parent2: TCnLeaf;
  I, Index2: Integer;
  AList: TList;
begin
  if (Leaf1 <> nil) and (Leaf2 <> nil) and (Leaf1 <> Leaf2)
    and (Leaf1.Tree = Self) and (Leaf2.Tree = Self) then
  begin
    // ڵӽڵбڵ㽻
    Parent2 := Leaf2.Parent;
    Index2 := Leaf2.Index;

    AList := nil;
    try
      AList := TList.Create;
      for I := 0 to Leaf1.Count - 1 do
        AList.Add(Leaf1.Items[I]);

      Leaf1.FList.Clear;
      for I := 0 to Leaf2.Count - 1 do
        Leaf1.FList.Add(Leaf2.Items[I]);
      for I := 0 to AList.Count - 1 do
        Leaf2.FList.Add(AList.Items[I]);
    finally
      AList.Free;
    end;

    if Leaf1.Parent <> nil then
      Leaf1.Parent.SetChild(Leaf2, Leaf1.Index)
    else
      Leaf2.FParent := nil;
    if Parent2 <> nil then
      Parent2.SetChild(Leaf1, Index2)
    else
      Leaf1.FParent := nil;

    // ˳жϸڵ
    if FRoot = Leaf1 then
      FRoot := Leaf2
    else if FRoot = Leaf2 then
      FRoot := Leaf1;
  end;
end;

function TCnTree.GetItems(AbsoluteIndex: Integer): TCnLeaf;
begin
  if AbsoluteIndex < 0 then
    Result := nil
  else if AbsoluteIndex = 0 then
    Result := FRoot
  else
    Result := FRoot.GetAbsoluteItems(AbsoluteIndex - 1);
end;

function TCnTree.GetCount: Integer;
begin
  Result := FRoot.AllCount + 1;
end;

function TCnTree.GetMaxLevel: Integer;
var
  I: Integer;
begin
  Result := 0;
  for I := 0 to Count - 1 do
    if (Items[I] <> nil) and (Items[I].Level > Result) then
      Result := Items[I].Level;
end;

function TCnTree.GetRegisteredCount: Integer;
begin
  Result := FLeaves.Count;
end;

{$IFDEF ENABLE_UIINTERACT}
{$IFDEF MSWINDOWS}

procedure TCnTree.LoadFromTreeView(ATreeView: ComCtrls.TTreeView; RootNode: TTreeNode;
  RootLeaf: TCnLeaf);
var
  ANode: TTreeNode;
  ALeaf: TCnLeaf;
begin
  if (RootLeaf <> nil) and (RootLeaf.Tree <> Self) then Exit;
  if (RootNode <> nil) and (RootNode.TreeView <> ATreeView) then Exit;

  if ATreeView <> nil then
  begin
    if RootLeaf = nil then
      Self.Clear
    else
      RootLeaf.Clear;

    if ATreeView.Items.Count > 0 then
    begin
      if RootNode = nil then
        ANode := ATreeView.Items[0]
      else
        ANode := RootNode;
      // һڵ
      if RootLeaf = nil then
        RootLeaf := FRoot;

      ALeaf := Self.AddChild(RootLeaf);
      LoadFromATreeNode(ALeaf, ANode);
      if RootNode <> nil then Exit;
      //  RootNode ʱ RootNode ΪԲ RootNode ͬڵ

      ANode := ANode.GetNextSibling; // ˲̽ڵ
      while ANode <> nil do
      begin
        ALeaf := Self.AddChild(RootLeaf);
        LoadFromATreeNode(ALeaf, ANode);
        ANode := ANode.GetNextSibling;
      end;
    end;
  end;
end;

procedure TCnTree.SaveToTreeView(ATreeView: ComCtrls.TTreeView; RootNode: TTreeNode;
  RootLeaf: TCnLeaf);
var
  I: Integer;
  ANode: TTreeNode;
  ALeaf: TCnLeaf;
begin
  if (RootLeaf <> nil) and (RootLeaf.Tree <> Self) then Exit;
  if (RootNode <> nil) and (RootNode.TreeView <> ATreeView) then Exit;

  if ATreeView <> nil then
  begin
    ATreeView.Items.BeginUpdate;
    try
      if RootNode <> nil then
        RootNode.DeleteChildren
      else
        ATreeView.Items.Clear;

      if RootLeaf = nil then
        RootLeaf := FRoot;

      // ָ RootNode RootLeaf д RootNode RootLeaf 뽻
      if RootNode <> nil then
        DoSaveToATreeNode(RootLeaf, RootNode);

      ANode := RootNode;
      if ANode = nil then // ˳
      begin
        for I := 0 to RootLeaf.Count - 1 do
        begin
          ALeaf := RootLeaf.Items[I]; // RootLeaf ӽڵ
          if ALeaf = nil then
            Continue;
          ANode := ATreeView.Items.Add(ANode, '');
          SaveToATreeNode(ALeaf, ANode);
        end;
      end
      else // иڵ㣬Ϊڵӽڵ
      begin
        for I := 0 to RootLeaf.Count - 1 do
        begin
          ALeaf := RootLeaf.Items[I]; // RootLeaf ӽڵ
          if ALeaf = nil then
            Continue;
          ANode := ATreeView.Items.AddChild(RootNode, '');
          SaveToATreeNode(ALeaf, ANode);
        end;
      end;
    finally
      ATreeView.Items.EndUpdate;
    end;
  end;
end;

{$ENDIF}

{$IFDEF SUPPORT_FMX}

procedure TCnTree.LoadFromTreeView(ATreeView: FMX.TreeView.TTreeView;
  RootItem: TTreeViewItem; RootLeaf: TCnLeaf);
var
  AItem: TTreeViewItem;
  ALeaf: TCnLeaf;
begin
  if (RootLeaf <> nil) and (RootLeaf.Tree <> Self) then Exit;
  if (RootItem <> nil) and (RootItem.TreeView <> ATreeView) then Exit;

  if ATreeView <> nil then
  begin
    if RootLeaf = nil then
      Self.Clear
    else
      RootLeaf.Clear;

    if ATreeView.GlobalCount > 0 then
    begin
      if RootItem = nil then
        AItem := ATreeView.Items[0]
      else
        AItem := RootItem;
      // һڵ
      if RootLeaf = nil then
        RootLeaf := FRoot;

      ALeaf := Self.AddChild(RootLeaf);
      LoadFromATreeViewItem(ALeaf, AItem);
      if RootItem <> nil then Exit;
      //  RootNode ʱ RootNode ΪԲ RootNode ͬڵ

      AItem := GetNextSiblingItem(AItem); // ˲̽ڵ
      while AItem <> nil do
      begin
        ALeaf := Self.AddChild(RootLeaf);
        LoadFromATreeViewItem(ALeaf, AItem);
        AItem := GetNextSiblingItem(AItem);
      end;
    end;
  end;
end;

procedure TCnTree.SaveToTreeView(ATreeView: FMX.TreeView.TTreeView;
  RootItem: TTreeViewItem; RootLeaf: TCnLeaf);
var
  I: Integer;
  AItem: TTreeViewItem;
  ALeaf: TCnLeaf;
begin
  if (RootLeaf <> nil) and (RootLeaf.Tree <> Self) then Exit;
  if (RootItem <> nil) and (RootItem.TreeView <> ATreeView) then Exit;

  if ATreeView <> nil then
  begin
    ATreeView.BeginUpdate;
    try
      if RootItem <> nil then
        RootItem.DeleteChildren
      else
        ATreeView.Clear;

      if RootLeaf = nil then
        RootLeaf := FRoot;

      // ָ RootItem RootLeaf д RootItem RootLeaf 뽻
      if RootItem <> nil then
        DoSaveToATreeViewItem(RootLeaf, RootItem);

      for I := 0 to RootLeaf.Count - 1 do
      begin
        ALeaf := RootLeaf.Items[I]; // RootLeaf ӽڵ
        if ALeaf = nil then
          Continue;

        AItem := TTreeViewItem.Create(ATreeView);
        if RootItem = nil then
          AItem.Parent := ATreeView
        else
          AItem.Parent := RootItem;

        SaveToATreeViewItem(ALeaf, AItem);
      end;
    finally
      ATreeView.EndUpdate;
    end;
  end;
end;

{$ENDIF}
{$ENDIF}

procedure TCnTree.LoadFromFile(Filer: ICnTreeFiler;
  const FileName: string);
begin
  if Filer <> nil then
    Filer.LoadFromFile(Self, FileName);
end;

procedure TCnTree.SaveToFile(Filer: ICnTreeFiler; const FileName: string);
begin
  if Filer <> nil then
    Filer.SaveToFile(Self, FileName);
end;

{$IFDEF ENABLE_UIINTERACT}
{$IFDEF MSWINDOWS}

procedure TCnTree.LoadFromATreeNode(ALeaf: TCnLeaf; ANode: TTreeNode);
var
  I: Integer;
  Leaf: TCnLeaf;
begin
  if (ANode <> nil) and (ALeaf <> nil) then
  begin
    if DoLoadFromATreeNode(ALeaf, ANode) then
    begin
      for I := 0 to ANode.Count - 1 do
      begin
        Leaf := Self.AddChild(ALeaf);
{$IFDEF FPC}
        LoadFromATreeNode(Leaf, ANode.Items[I]);
{$ELSE}
        LoadFromATreeNode(Leaf, ANode.Item[I]);
{$ENDIF}
      end;
    end
    else
    begin
      ALeaf.Delete;
    end;
  end;
end;

procedure TCnTree.SaveToATreeNode(ALeaf: TCnLeaf; ANode: TTreeNode);
var
  I: Integer;
  Node: TTreeNode;
begin
  if (ANode <> nil) and (ALeaf <> nil) and (ANode.TreeView is ComCtrls.TTreeView) then
  begin
    if DoSaveToATreeNode(ALeaf, ANode) then
    begin
      for I := 0 to ALeaf.Count - 1 do
      begin
        if ALeaf.Items[I] = nil then
          Continue;
        Node := (ANode.TreeView as ComCtrls.TTreeView).Items.AddChild(ANode, '');
        SaveToATreeNode(ALeaf.Items[I], Node);
      end;
    end
    else
    begin
      ANode.Delete;
    end;
  end;
end;

function TCnTree.DoLoadFromATreeNode(ALeaf: TCnLeaf; ANode: TTreeNode): Boolean;
begin
  Result := True;
  if Assigned(FOnLoadANode) then
    FOnLoadANode(ALeaf, ANode, Result)
  else
  begin
    ALeaf.Text := ANode.Text;
    ALeaf.Data := Integer(ANode.Data);
  end;
end;

function TCnTree.DoSaveToATreeNode(ALeaf: TCnLeaf; ANode: TTreeNode): Boolean;
begin
  Result := True;
  if Assigned(FOnSaveANode) then
  begin
    FOnSaveANode(ALeaf, ANode, Result);
  end
  else
  begin
    ANode.Text := ALeaf.Text;
    ANode.Data := Pointer(ALeaf.Data);
  end;
end;

{$ENDIF}

{$IFDEF SUPPORT_FMX}

procedure TCnTree.LoadFromATreeViewItem(ALeaf: TCnLeaf; AItem: TTreeViewItem);
var
  I: Integer;
  Leaf: TCnLeaf;
begin
  if (AItem <> nil) and (ALeaf <> nil) then
  begin
    if DoLoadFromATreeViewItem(ALeaf, AItem) then
    begin
      for I := 0 to AItem.Count - 1 do
      begin
        Leaf := AddChild(ALeaf);
        LoadFromATreeViewItem(Leaf, AItem.Items[I]);
      end;
    end
    else
    begin
      ALeaf.Delete;
    end;
  end;
end;

procedure TCnTree.SaveToATreeViewItem(ALeaf: TCnLeaf; AItem: TTreeViewItem);
var
  I: Integer;
  Item: TTreeViewItem;
begin
  if (AItem <> nil) and (ALeaf <> nil) and (AItem.TreeView is TTreeView) then
  begin
    if DoSaveToATreeViewItem(ALeaf, AItem) then
    begin
      for I := 0 to ALeaf.Count - 1 do
      begin
        if ALeaf.Items[I] = nil then
          Continue;

        Item := TTreeViewItem.Create(AItem.TreeView);
        Item.Parent := AItem;
        SaveToATreeViewItem(ALeaf.Items[I], Item);
      end;
    end
    else
    begin
      AItem.Free;
    end;
  end;
end;

function TCnTree.DoLoadFromATreeViewItem(ALeaf: TCnLeaf; AItem: TTreeViewItem): Boolean;
begin
  Result := True;
  if Assigned(FOnLoadAItem) then
    FOnLoadAItem(ALeaf, AItem, Result)
  else
  begin
    ALeaf.Text := AItem.Text;
    try
      ALeaf.Data := AItem.Data.AsInteger;
    except
      ALeaf.Data := 0;
    end;
  end;
end;

function TCnTree.DoSaveToATreeViewItem(ALeaf: TCnLeaf; AItem: TTreeViewItem): Boolean;
begin
  Result := True;
  if Assigned(FOnSaveAItem) then
  begin
    FOnSaveAItem(ALeaf, AItem, Result);
  end
  else
  begin
    AItem.Text := ALeaf.Text;
    AItem.Tag := ALeaf.Data; // Data Ӱ Text Tag
  end;
end;

{$ENDIF}
{$ENDIF}

procedure TCnTree.ValidateComingLeaf(AParent, AChild: TCnLeaf);
begin

end;

procedure TCnTree.AssignLeafAndChildren(Source, DestLeaf: TCnLeaf; DestTree: TCnTree);
var
  I: Integer;
  Leaf: TCnLeaf;
begin
  if (Source <> nil) and (DestLeaf <> nil) and (DestTree <> nil) then
  begin
    DestLeaf.Assign(Source);
    DestLeaf.Clear;
    for I := 0 to Source.Count - 1 do
    begin
      Leaf := DestTree.CreateLeaf(DestTree);
      DestLeaf.AddChild(Leaf);
      AssignLeafAndChildren(Source.Items[I], Leaf, DestTree);
    end;
  end;
end;

procedure TCnTree.AssignTo(Dest: TPersistent);
begin
  if Dest is TCnTree then
  begin
    TCnTree(Dest).Clear;
    // ȫ¡ڵĽṹ
    AssignLeafAndChildren(FRoot, TCnTree(Dest).Root, TCnTree(Dest));
  end
  else
    inherited;
end;

function TCnTree.DefaultLeafClass: TCnLeafClass;
begin
  Result := TCnLeaf;
end;

function TCnTree.GetHeight: Integer;
begin
  if Root = nil then
    Result := 0
  else
    Result := Root.SubTreeHeight + 1;
end;

end.
