{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnSkipList;
{* |<PRE>
================================================================================
* ƣ
* ԪƣԾ SkipList ʵֵԪ
* ԪߣCnPack 
*     עοάٿԼ ftp://ftp.cs.umd.edu/pub/skipLists/
*           Ծʱ临Ӷڵӽ
* ƽ̨Win 7 + Delphi 5.0
* ݲԣδ
*   õԪ豾ػ
* ޸ļ¼2015.05.22 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Classes, Windows, Contnrs;

const
  CN_SKIPLIST_MAX_LEVEL = 16; // 0 ~ 15

type
  ECnSkipListLevelError = Exception;
  ECnSkipListCompareError = Exception;
  ECnSkipListRandomError = Exception;

  TCnSkipListNodeList = class;

  TCnSkipListNode = class
  {* һ洢ݽڵĽṹһָ}
  private
    FLevel: Integer;
    FForwards: TCnSkipListNodeList;
    FData: Pointer;
    FText: string;
    FOnDestroy: TNotifyEvent;
  protected
    procedure DoDestroy; virtual;
  public
    constructor Create(ALevel: Integer);
    destructor Destroy; override;

    property Forwards: TCnSkipListNodeList read FForwards;
    {* ָ룬0 ϸһ}
    property Level: Integer read FLevel write FLevel;
    {*  Node ӵеЧΣ 0  Level}
    
    property Data: Pointer read FData write FData;
    property Text: string read FText write FText;

    property OnDestroy: TNotifyEvent read FOnDestroy write FOnDestroy;
    {* ͷŵĻص¼ͷ Data }
  end;

  TCnSkipListValueCompareFunc = function (const Value: Pointer; const Node: TCnSkipListNode): Integer;
  {* ڱȽϴڵС Function>=< ֱ𷵻 10-1
     ߼ѷװ SkipList ʵ֣Head ڵҪСκֵκֵС nil ڵ}

  TCnSkipListNodeList = class(TObjectList)
  {* һڵṹеָ}
  private
    function GetItem(Index: Integer): TCnSkipListNode;
    procedure SetItem(Index: Integer; const Value: TCnSkipListNode);
  public
    constructor Create; 
    destructor Destroy; override;

    function Add(ANode: TCnSkipListNode): Integer;
    property Items[Index: Integer]: TCnSkipListNode read GetItem write SetItem; default;
  end;

  TCnLevelProbability = (lpDot5, lpDot25, lpDot125); //  Level ĸ

  TCnSkipList = class
  {* Ծ SkipList ʵ}
  private
    FRandomBits: DWORD;
    FAllowDuplicates: Boolean;
    FCompareFunc: TCnSkipListValueCompareFunc;
    FMaxLevel: Integer;
    FHead: TCnSkipListNode;
    FLevelProbability: TCnLevelProbability;
    function GetMaxLevel: Integer;
    function GetCount: Integer;

  protected
    function ValueGreaterThanNode(const Value: Pointer; const Node: TCnSkipListNode): Boolean;
    function ValueEqualsNode(const Value: Pointer; const Node: TCnSkipListNode): Boolean;
    function ValueLessThanNode(const Value: Pointer; const Node: TCnSkipListNode): Boolean;

    function GenerateLevel: Integer;
  public
    constructor Create(CompareFunc: TCnSkipListValueCompareFunc; ALevelProbability:
      TCnLevelProbability = lpDot5; AllowDuplicates: Boolean = False);
    {* 캯
       CompareFuncʹ߱ṩһȽϺԾصжҵֵڵĴСϵ
       ALevelProbabilityĸʣĬΪ 0.5
       AllowDuplicatesǷظֵǷ CompareFunc صֵ
    }
    destructor Destroy; override;
    {* ͷȫڵ㣬ڵ OnDestroy ¼ɹͷ丽}

    function Delete(AValue: Pointer): Boolean;
    {* ҲɾһֵǷɾɹ}
    function Search(AValue: Pointer): TCnSkipListNode;
    {* һֵҵĽڵ㣬򷵻 nil}
    function Insert(AValue: Pointer): TCnSkipListNode;
    {* һֵزĽڵ㣬ⲿʹô˽ڵ洢 AValueʧܷ nil}

    property AllowDuplicates: Boolean read FAllowDuplicates;
    {* Ƿظڵ}
    property MaxLevel: Integer read GetMaxLevel;
    {* нڵΣδ 0  MaxLevel}
    property Head: TCnSkipListNode read FHead;
    {* ͷڵ㣬εָ}
    property Count: Integer read GetCount;
    {* ڵͨõ}
    property LevelProbability: TCnLevelProbability read FLevelProbability;
    {*  Level ĸʣ̶ֵֻ}
  end;

implementation

const
  CN_BITS_IN_RANDOM = 31;
  PROV_RSA_FULL = 1;

function CryptAcquireContext(phProv: PULONG; pszContainer: PAnsiChar;
  pszProvider: PAnsiChar; dwProvType: DWORD; dwFlags: DWORD): BOOL;
  stdcall; external ADVAPI32 name 'CryptAcquireContextA';

function CryptReleaseContext(hProv: ULONG; dwFlags: DWORD): BOOL;
  stdcall; external ADVAPI32 name 'CryptReleaseContext';

function CryptGenRandom(hProv: ULONG; dwLen: DWORD; pbBuffer: PAnsiChar): BOOL;
  stdcall; external ADVAPI32 name 'CryptGenRandom';

// ʹ Windows API ʵ 32 bit
function Rand32: DWORD;
var
  HProv: Cardinal;
  Res: DWORD;
begin
  HProv := 0;
  if not CryptAcquireContext(@HProv, nil, nil, PROV_RSA_FULL, 0) then
    raise ECnSkipListRandomError.Create('SkipList Error Random.');

  if HProv <> 0 then
  begin
    try
      CryptGenRandom(HProv, SizeOf(DWORD), @Res);
    finally
      CryptReleaseContext(HProv, 0);
    end;
  end
  else
    raise ECnSkipListRandomError.Create('SkipList Error Random.');
  
  Result := Res;
end;

{ TCnSkipListNodeList }

function TCnSkipListNodeList.Add(ANode: TCnSkipListNode): Integer;
begin
  Result := inherited Add(ANode);
end;

constructor TCnSkipListNodeList.Create;
begin
  inherited Create(False);
end;

destructor TCnSkipListNodeList.Destroy;
begin
  inherited;

end;

function TCnSkipListNodeList.GetItem(Index: Integer): TCnSkipListNode;
begin
  Result := TCnSkipListNode(inherited GetItem(Index));
end;

procedure TCnSkipListNodeList.SetItem(Index: Integer;
  const Value: TCnSkipListNode);
begin
  inherited SetItem(Index, Value);
end;

{ TCnSkipListNode }

constructor TCnSkipListNode.Create(ALevel: Integer);
var
  I: Integer;
begin
  if (ALevel < 0) or (ALevel >= CN_SKIPLIST_MAX_LEVEL) then
    raise ECnSkipListLevelError.Create('SkipList Error Level.');

  FLevel := ALevel;
  FForwards := TCnSkipListNodeList.Create;

  for I := 0 to CN_SKIPLIST_MAX_LEVEL - 1 do
    FForwards.Add(nil);
end;

destructor TCnSkipListNode.Destroy;
begin
  DoDestroy;
  FForwards.Free;
  inherited;
end;

procedure TCnSkipListNode.DoDestroy;
begin
  if Assigned(FOnDestroy) then
    FOnDestroy(Self);
end;

{ TCnSkipList }

constructor TCnSkipList.Create(CompareFunc: TCnSkipListValueCompareFunc;
  ALevelProbability: TCnLevelProbability; AllowDuplicates: Boolean);
begin
  inherited Create;
  if not Assigned(CompareFunc) then
    raise ECnSkipListCompareError.Create('SkipList No Compare Function.');

  FLevelProbability := ALevelProbability;
  FAllowDuplicates := AllowDuplicates;
  FCompareFunc := CompareFunc;

  FHead := TCnSkipListNode.Create(0); // 0 ~ CN_SKIPLIST_MAX_LEVEL
end;

function TCnSkipList.Delete(AValue: Pointer): Boolean;
var
  K, M: Integer;
  P, PreNode, Q: TCnSkipListNode;
  Prevs: array[0..CN_SKIPLIST_MAX_LEVEL - 1] of TCnSkipListNode;
begin
  Result := False;

  PreNode := FHead;
  K := FMaxLevel;
  M := FMaxLevel;
  FillChar(Prevs, SizeOf(Prevs), 0);

  repeat
    Q := PreNode.Forwards[K];
    while ValueGreaterThanNode(AValue, Q) and (Q <> nil) do
    begin
      PreNode := Q;
      Q := PreNode.Forwards[K];
    end;
    Prevs[K] := PreNode;
    Dec(K);
  until K < 0; // ͬ Search¼м

  if ValueEqualsNode(AValue, Q) then // ҵҪɾ
  begin
    K := 0;
    P := Prevs[K];
    while (K <= M) and (P.Forwards[K] = Q) do
    begin
      P.Forwards[K] := Q.Forwards[K];
      Inc(K);
      P := Prevs[K];
    end;

    Q.Free; // ͷűɾڵ

    while (FHead.Forwards[M] = nil) and (M > 0) do
      Dec(M);
    FMaxLevel := M; // 
    Result := True;
  end;
end;

destructor TCnSkipList.Destroy;
var
  P, Q: TCnSkipListNode;
begin
  P := FHead;
  repeat
    Q := P.Forwards[0];
    P.Free;
    P := Q;
  until P = nil;
  // ײ Node ͷ

  inherited;
end;

function TCnSkipList.GenerateLevel: Integer;
var
  C, B: DWORD;
begin
  Result := 0;
  C := 1;
  case FLevelProbability of
    lpDot5: C := 1;        // 1
    lpDot25: C := 3;       // 11
    lpDot125: C := 7;      // 111
  end;

  repeat
    FRandomBits := Rand32;
    B := FRandomBits and C;
    if B = 0 then    // һĸ FLevelProbability
      Inc(Result);
  until B <> 0;

  if Result >= CN_SKIPLIST_MAX_LEVEL then
    Result := CN_SKIPLIST_MAX_LEVEL - 1;
end;

function TCnSkipList.GetCount: Integer;
var
  P: TCnSkipListNode;
begin
  P := FHead;
  Result := 0;
  while P <> nil do
  begin
    Inc(Result);
    P := P.Forwards[0];
  end;
end;

function TCnSkipList.GetMaxLevel: Integer;
begin
  Result := FMaxLevel;
end;

function TCnSkipList.Insert(AValue: Pointer): TCnSkipListNode;
var
  K: Integer;
  P, Q, PreNode, NewNode: TCnSkipListNode;
  Prevs: array[0..CN_SKIPLIST_MAX_LEVEL - 1] of TCnSkipListNode;
begin
  Result := nil;

  PreNode := FHead;
  K := FMaxLevel;

  FillChar(Prevs, SizeOf(Prevs), 0);
  repeat
    Q := PreNode.Forwards[K];
    while ValueGreaterThanNode(AValue, Q) and (Q <> nil) do
    begin
      PreNode := Q;
      Q := PreNode.Forwards[K];
    end;
    Prevs[K] := PreNode;
    Dec(K);
  until K < 0; // ͬ SearchҲ¼м

  if (not FAllowDuplicates) and ValueEqualsNode(AValue, Q) then
    Exit;
  // ½ڵҪ P 棬δǲ FHead ǰ
  
  K := GenerateLevel;
  if K > FMaxLevel then
  begin
    Inc(FMaxLevel);
    K := FMaxLevel;
    Prevs[K] := FHead;

    // FHead  Level Ҫ
    if FHead.Level < K then
      FHead.Level := K;
  end;  // Update ǴڵһŸڵ㣬Ҫָڵ

  NewNode := TCnSkipListNode.Create(K);
  Result := NewNode;
  repeat
    P := Prevs[K];                        // ȡһ K ߽ڵ
    NewNode.Forwards[K] := P.Forwards[K];  //  K ½ڵָԭڵһ
    P.Forwards[K] := NewNode;              // ڵ K ָڵ
    Dec(K);
  until K < 0;
end;

function TCnSkipList.Search(AValue: Pointer): TCnSkipListNode;
var
  I: Integer;
  P, Q: TCnSkipListNode;
begin
  Result := nil;
  P := FHead;
  I := FMaxLevel;

  repeat
    Q := P.Forwards[I];
    while ValueGreaterThanNode(AValue, Q) and (Q <> nil) do
    begin
      P := Q;
      Q := P.Forwards[I];
    end;
    Dec(I);
  until I < 0;

  if not ValueEqualsNode(AValue, Q) then
    Exit;

  Result := Q;
end;

function TCnSkipList.ValueEqualsNode(const Value: Pointer;
  const Node: TCnSkipListNode): Boolean;
begin
  if Node = FHead then
    Result := False
  else if Node = nil then
    Result := False
  else
    Result := FCompareFunc(Value, Node) = 0;
end;

function TCnSkipList.ValueGreaterThanNode(const Value: Pointer;
  const Node: TCnSkipListNode): Boolean;
begin
  if Node = FHead then     // κӽڵԶ Head
    Result := True
  else if Node = nil then  // κӽڵԶС nil
    Result := False
  else
    Result := FCompareFunc(Value, Node) > 0;
end;

function TCnSkipList.ValueLessThanNode(const Value: Pointer;
  const Node: TCnSkipListNode): Boolean;
begin
  if Node = FHead then     // Head ԶСκӽڵ
    Result := False
  else if Node = nil then  // nil Զκνڵ
    Result := True
  else
    Result := FCompareFunc(Value, Node) < 0;
end;

end.
