{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnMethodHook;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣ󷽷ҽӵԪ
* Ԫߣܾ (zjy@cnpack.org)
*     עõԪҽķ CnWizMethodHook ֲʹ
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣ
*   õԪеֱַ֧ػʽ
* ޸ļ¼2023.05.27
*                Win64 µ֧֣ȷǷ񸲸гת
*           2018.01.12
*               ýӿڳԱַķ DefaultHook 
*           2016.10.31
*                Hooked 
*           2007.11.05
*                CnWizMethodHook ֲ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Windows, SysUtils, Classes;

type
  PCnLongJump = ^TCnLongJump;
  TCnLongJump = packed record
    JmpOp: Byte;        // Jmp תָΪ $E932 λ 64 λͨ
{$IFDEF CPU64BITS}
    Addr: DWORD;        // 64 λµתԵַҲ 32 λȷ޸
{$ELSE}
    Addr: Pointer;      // תԵַ
{$ENDIF}
  end;

  TCnMethodHook = class
  {* ̬ dynamic ҽ࣬ڹҽо̬Ϊ dynamic Ķ̬
     ͨ޸ԭǰ 5 ֽڣΪתָʵַҽӲʹʱ
     뱣֤ԭִ 5 ֽڣܻغ}
  private
    FHooked: Boolean;
    FOldMethod: Pointer;
    FNewMethod: Pointer;
    FSaveData: TCnLongJump;
  public
    constructor Create(const AOldMethod, ANewMethod: Pointer; DefaultHook: Boolean = True);
    {* Ϊԭַ·ַערҰʹãԭַ
        CnGetBplMethodAddress תʵַúԶҽӴķ
     |<PRE>
       Ҫҽ TTest.Abc(const A: Integer) Զ·Ϊ
       procedure MyAbc(ASelf: TTest; const A: Integer);
       ˴ MyAbc Ϊ̣ͨΪһΪ Selfʴ˴һ
       ASelf: TTest ֮ԣʵִп԰ʵʡ
     |</PRE>}
    destructor Destroy; override;
    {* ȡҽ}

    property Hooked: Boolean read FHooked;
    {* Ƿѹҽ}
    procedure HookMethod; virtual;
    {* ¹ҽӣҪִԭ̣ʹ UnhookMethodִɺ¹ҽ}
    procedure UnhookMethod; virtual;
    {* ȡҽӣҪִԭ̣ʹ UnhookMethodٵԭ̣}
  end;

function CnGetBplMethodAddress(Method: Pointer): Pointer;
{*  BPL ʵʵķַרҰ @TPersistent.Assign صʵ
   һ Jmp תַúԷ BPL зʵַ}

function GetInterfaceMethodAddress(const AIntf: IUnknown;
  MethodIndex: Integer): Pointer;
{*  Delphi ֧ @AIntf.Proc ķʽؽӿڵĺڵַ Self ָҲ
   ƫ⡣ڷ AIntf ĵ MethodIndex ڵַ
   Self ָƫ⡣
   MethodIndex  0 ʼ012 ֱ QueryInterface_AddRef_Release
   ע MethodIndex ߽飬˸ Interface ķ}

implementation

resourcestring
  SMemoryWriteError = 'Error Writing Method Memory (%s).';

const
  csJmpCode = $E9;              // תָ
  csJmp32Code = $25FF;          // BPL ڵת룬32 λ 64 λͨ

type
{$IFDEF CPU64BITS}
  TCnAddressInt = NativeInt;
{$ELSE}
  TCnAddressInt = Integer;
{$ENDIF}

//  BPL ʵʵķַ
function CnGetBplMethodAddress(Method: Pointer): Pointer;
type
  PJmpCode = ^TJmpCode;
  TJmpCode = packed record
    Code: Word;                 // תָΪ $25FF
    Addr: ^Pointer;             // תַָָ򱣴Ŀַָ
  end;

begin
  if PJmpCode(Method)^.Code = csJmp32Code then
    Result := PJmpCode(Method)^.Addr^
  else
    Result := Method;
end;

//  Interface ĳŷʵʵַ Self ƫƣ֧ 32 λ 64 λ
function GetInterfaceMethodAddress(const AIntf: IUnknown;
  MethodIndex: Integer): Pointer;
type
  TIntfMethodEntry = packed record
    case Integer of
      0: (ByteOpCode: Byte);        // 32 λµ $05 ֽ
      1: (WordOpCode: Word);        // 32 λµ $C083 һֽ
      2: (DWordOpCode: DWORD);      // 32 λµ $04244483 һֽڻ $04244481 ֽڣ
                                    //  64 λµ $4883C1E0 һֽ
  end;
  PIntfMethodEntry = ^TIntfMethodEntry;

  // תʵϵͬ TJmpCode  TLongJmp ṹ
  TIntfJumpEntry = packed record
    case Integer of
      0: (ByteOpCode: Byte; Offset: LongInt);       // $E9 ֽڣ32 λ 64 λͨ
      1: (WordOpCode: Word; Addr: ^Pointer);        // $25FF ֽ
  end;
  PIntfJumpEntry = ^TIntfJumpEntry;
  PPointer = ^Pointer;

var
  OffsetStubPtr: Pointer;
  IntfPtr: PIntfMethodEntry;
  JmpPtr: PIntfJumpEntry;
begin
  Result := nil;
  if (AIntf = nil) or (MethodIndex < 0) then
    Exit;

  OffsetStubPtr := PPointer(TCnAddressInt(PPointer(AIntf)^) + SizeOf(Pointer) * MethodIndex)^;

  // õ interface Աתڣڻ Self ָ
  // 32 λ£IUnknown ׼ھ add dword ptr [esp+$04],-$xx xx Ϊ ShortInt  LongIntΪ stdcall
  // stdcall/safecall/cdecl ĴΪ $04244483 һֽڵ ShortInt $04244481 ֽڵ LongInt
  // ÷ʽпĬ register  add eax -$xx xx Ϊ ShortInt  LongInt
  // stdcall/safecall/cdecl ĴΪ $C083 һֽڵ ShortInt $05 ֽڵ LongInt
  // pascal ջʽƺԺ stdcall һ
  // Win64 £ھ add ecx, -$20֮ Jump
  IntfPtr := PIntfMethodEntry(OffsetStubPtr);

  JmpPtr := nil;

{$IFDEF CPU64BITS}
  // 64 λתƺһ
  if IntfPtr^.DWordOpCode = $E0C18348 then
    JmpPtr := PIntfJumpEntry(TCnAddressInt(IntfPtr) + 4);
{$ELSE}
  if IntfPtr^.ByteOpCode = $05 then
    JmpPtr := PIntfJumpEntry(TCnAddressInt(IntfPtr) + 1 + 4)
  else if IntfPtr^.DWordOpCode = $04244481 then
    JmpPtr := PIntfJumpEntry(TCnAddressInt(IntfPtr) + 4 + 4)
  else if IntfPtr^.WordOpCode = $C083 then
    JmpPtr := PIntfJumpEntry(TCnAddressInt(IntfPtr) + 2 + 1)
  else if IntfPtr^.DWordOpCode = $04244483 then
    JmpPtr := PIntfJumpEntry(TCnAddressInt(IntfPtr) + 4 + 1);
{$ENDIF}

  if JmpPtr <> nil then
  begin
    // Ҫֲָͬת E9 ֽƫƣ32 λ 64 λͨãԼ 25FF ֽھԵַĵַ
    if JmpPtr^.ByteOpCode = csJmpCode then
    begin
      Result := Pointer(TCnAddressInt(JmpPtr) + JmpPtr^.Offset + 5); // 5 ʾ Jmp ָĳ
    end
    else if JmpPtr^.WordOpCode = csJmp32Code then
    begin
      Result := JmpPtr^.Addr^;
    end;
  end;
end;

//==============================================================================
// ̬ dynamic ҽ
//==============================================================================

{ TCnMethodHook }

constructor TCnMethodHook.Create(const AOldMethod, ANewMethod: Pointer;
  DefaultHook: Boolean);
begin
  inherited Create;
  FHooked := False;
  FOldMethod := AOldMethod;
  FNewMethod := ANewMethod;

  if DefaultHook then
    HookMethod;
end;

destructor TCnMethodHook.Destroy;
begin
  UnHookMethod;
  inherited;
end;

procedure TCnMethodHook.HookMethod;
var
  DummyProtection: DWORD;
  OldProtection: DWORD;
begin
  if FHooked then Exit;
  
  // ôҳдȨ
  if not VirtualProtect(FOldMethod, SizeOf(TCnLongJump), PAGE_EXECUTE_READWRITE, @OldProtection) then
    raise Exception.CreateFmt(SMemoryWriteError, [SysErrorMessage(GetLastError)]);

  try
    // ԭĴ
    FSaveData := PCnLongJump(FOldMethod)^;

    // תָ滻ԭǰ 5 ֽڴ
    PCnLongJump(FOldMethod)^.JmpOp := csJmpCode;
{$IFDEF CPU64BITS}
    PCnLongJump(FOldMethod)^.Addr := DWORD(TCnAddressInt(FNewMethod) -
      TCnAddressInt(FOldMethod) - SizeOf(TCnLongJump)); // 64 Ҳʹ 32 λԵַ
{$ELSE}
    PCnLongJump(FOldMethod)^.Addr := Pointer(TCnAddressInt(FNewMethod) -
      TCnAddressInt(FOldMethod) - SizeOf(TCnLongJump)); // ʹ 32 λԵַ
{$ENDIF}

    // ദָͬ
    FlushInstructionCache(GetCurrentProcess, FOldMethod, SizeOf(TCnLongJump));
  finally
    // ָҳȨ
    if not VirtualProtect(FOldMethod, SizeOf(TCnLongJump), OldProtection, @DummyProtection) then
      raise Exception.CreateFmt(SMemoryWriteError, [SysErrorMessage(GetLastError)]);
  end;

  FHooked := True;
end;

procedure TCnMethodHook.UnhookMethod;
var
  DummyProtection: DWORD;
  OldProtection: DWORD;
begin
  if not FHooked then Exit;
  
  // ôҳдȨ
  if not VirtualProtect(FOldMethod, SizeOf(TCnLongJump), PAGE_READWRITE, @OldProtection) then
    raise Exception.CreateFmt(SMemoryWriteError, [SysErrorMessage(GetLastError)]);

  try
    // ָԭĴ
    PCnLongJump(FOldMethod)^ := FSaveData;
  finally
    // ָҳȨ
    if not VirtualProtect(FOldMethod, SizeOf(TCnLongJump), OldProtection, @DummyProtection) then
      raise Exception.CreateFmt(SMemoryWriteError, [SysErrorMessage(GetLastError)]);
  end;

  // ദָͬ
  FlushInstructionCache(GetCurrentProcess, FOldMethod, SizeOf(TCnLongJump));

  FHooked := False;
end;

end.
