{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnLockFree;
{* |<PRE>
================================================================================
* ƣCnPack 
* Ԫƣ漰ƵһЩԭӲװԼݽṹʵ
* ԪߣCnPack  (master@cnpack.org)
*     עװ CnAtomicCompareAndSet  CAS ʵ֣Ӧ 32 λ 64 λ
*           ڴʵдѭ
*           ο Timothy L. Harris ģ
*             A Pragmatic Implementation of Non-Blocking Linked-Lists
*
*           עΪȱƽ̨ʵ֣ڲʱô˵ԪԱӰƽ̨
*
* ƽ̨PWin2000 + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/ 10.3 Win32/64
*   õԪеַϱػʽ
* ޸ļ¼2021.04.02 V1.2
*               ֧ Atomic  C++Buider ƽ̨ĸ׳쳣
*           2021.01.22 V1.1
*               ʵ̶ֵ߳߳дѭ
*           2021.01.10 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, {$IFDEF MSWINDOWS} Windows, {$ENDIF} Classes, CnNative;

const
  CN_RING_QUEUE_DEFAULT_CAPACITY = 16;

type
{$IFDEF CPU64BITS}
  TCnSpinLockRecord = NativeInt;
{$ELSE}
  TCnSpinLockRecord = Integer;
{$ENDIF}
  {* ֵΪ 1 ʱʾб0 ʾ}

  TCnLockFreeNodeKeyCompare = function(Key1, Key2: TObject): Integer;
  {* Ƚ Key ķͣ -101}

  PCnLockFreeLinkedNode = ^TCnLockFreeLinkedNode;

  TCnLockFreeLinkedNode = packed record
  {* ڵ}
    Key: TObject;
    Value: TObject;
    Next: PCnLockFreeLinkedNode; // ָλΪ 1 ʾýڵɾ
  end;

  TCnLockFreeNodeTravelEvent = procedure(Sender: TObject; Node: PCnLockFreeLinkedNode) of object;

  TCnLockFreeLinkedList = class
  {* ʵ}
  private
    FCompare: TCnLockFreeNodeKeyCompare;
    FGuardHead: PCnLockFreeLinkedNode; // ̶ͷڵָ
    FGuardTail: PCnLockFreeLinkedNode; // ̶βڵָ
    FHiddenHead, FHiddenTail: TCnLockFreeLinkedNode;
    FOnTravelNode: TCnLockFreeNodeTravelEvent;
    function GetLastNode: PCnLockFreeLinkedNode; //  FGuadTail ֮ǰһָ
    function GetLast2Nodes(out P1, P2: PCnLockFreeLinkedNode): Boolean;
    //  FGuadTail ֮ǰָ룬P1.Next ָ P2P2.Next ָ FTail

    function CompareKey(Key1, Key2: TObject): Integer;
    function IsNodePointerMarked(Node: PCnLockFreeLinkedNode): Boolean;  // ڵָλ洢һ Mark 
    function GetMarkedNodePointer(Node: PCnLockFreeLinkedNode): PCnLockFreeLinkedNode;   // һڵָ Mark 
    function ExtractRealNodePointer(Node: PCnLockFreeLinkedNode): PCnLockFreeLinkedNode; // һڵָʵֵ޼ Mark 
    function GetNextNode(Node: PCnLockFreeLinkedNode): PCnLockFreeLinkedNode; // һڵĺʵڵ㣬ȥ Mark ǵ
    procedure InternalSearch(Key: TObject; var LeftNode, RightNode: PCnLockFreeLinkedNode);
    {* ڲض Key δǽڵ㣬ڵ Key < Keyҽڵ Key >= Key}
  protected
    function CreateNode: PCnLockFreeLinkedNode;
    procedure FreeNode(Node: PCnLockFreeLinkedNode);
    procedure DoTravelNode(Node: PCnLockFreeLinkedNode); virtual;
  public
    constructor Create(KeyCompare: TCnLockFreeNodeKeyCompare = nil);
    destructor Destroy; override;

    function GetCount: Integer;
    {* ȡжٸڵ㣬ؽڵ}
    procedure Clear;
    {* ȫգ÷ֶ֧߳}
    procedure Travel;
    {* ͷÿڵ OnTravelNode ¼ֶ֧߳}

    procedure Append(Key, Value: TObject);
    {* βֱ½ڵ㣬б֤ Key }
    function RemoveTail(out Key, Value: TObject): Boolean;
    {* ɾβڵ㣬ɾβڵ Key  Value ءβڵ㣬 False}

    function Insert(Key, Value: TObject): Boolean;
    {* и Key λò벢 True Key Ѿ򷵻 False}
    function HasKey(Key: TObject; out Value: TObject): Boolean;
    {* ָ Key Ƿڣ򷵻 True Ӧ Value }
    function Delete(Key: TObject): Boolean;
    {* ɾָ Key ƥĽڵ㣬Ƿҵ}

    property OnTravelNode: TCnLockFreeNodeTravelEvent read FOnTravelNode write FOnTravelNode;
    {* ʱ¼}
  end;

  TCnLockFreeLinkedStack = class(TCnLockFreeLinkedList)
  {* Ϊʵֵջ}
  public
    procedure Push(Key, Value: TObject);
    {* ջ}
    function Pop(out Key, Value: TObject): Boolean;
    {* ջջ򷵻 False}
  end;

  TCnLockFreeSingleRingQueueNode = packed record
  {* нڵ}
    Key: TObject;
    Value: TObject;
  end;

  TCnLockFreeSingleRingQueue = class
  {* ֻ֧һ̶߳һ߳дѭ}
  private
    FSize: Integer;
    FHead: Cardinal; // вգHead ʼָЧڵ㡣Head һڵʼЧ۶
    FTail: Cardinal; // ۶գTail ʼָЧڵ㡣вգTail һڵʼЧ
    FNodes: array of TCnLockFreeSingleRingQueueNode;
    function GetCount: Integer;
    function GetIndex(Seq: Cardinal): Integer;
  protected

  public
    constructor Create(ASize: Integer = CN_RING_QUEUE_DEFAULT_CAPACITY);
    destructor Destroy; override;

    function Enqueue(Key, Value: TObject): Boolean;
    {* ͷǷɹ򷵻 False}
    function Dequeue(out Key, Value: TObject): Boolean;
    {* βǷɹп򷵻 False}

    function IsEmpty: Boolean;
    {* ǷգҲͷָβָ}
    function IsFull: Boolean;
    {* ǷҲͷָβָһ}
    property Count: Integer read GetCount;
    {* мЧԪ}
    property Size: Integer read FSize;
    {* еĴС}
  end;

//------------------------------------------------------------------------------
// ԭӲװ
//------------------------------------------------------------------------------

function CnAtomicIncrement32(var Addend: Integer): Integer;
{* ԭӲһ 32 λֵ 1Ӻֵ}

function CnAtomicDecrement32(var Addend: Integer): Integer;
{* ԭӲһ 32 λֵ 1ؼٺֵ}

function CnAtomicExchange32(var Target: Integer; Value: Integer): Integer;
{* ԭӲ 32 λֵ Targe ԭʼֵ}

function CnAtomicExchangeAdd32(var Addend: LongInt; Value: LongInt): Longint;
{* ԭӲ 32 λֵ Addend := Addend + Value Addend ԭʼֵ}

//  4  64 λڲ֧ Atomic ĵͰ汾 Delphi  C++Buider ƽ̨ϻʹ API
//  32 λ XP ϵͳϵģڲ֧֣׳쳣

function CnAtomicIncrement64(var Addend: Int64): Int64;
{* ԭӲһ 64 λֵ 1Ӻֵ}

function CnAtomicDecrement64(var Addend: Int64): Int64;
{* ԭӲһ 64 λֵ 1ؼٺֵ}

function CnAtomicExchange64(var Target: Int64; Value: Int64): Int64;
{* ԭӲ 64 λֵ Targe ԭʼֵ}

function CnAtomicExchangeAdd64(var Addend: Int64; Value: Int64): Int64;
{* ԭӲ 64 λֵ Addend := Addend + Value Addend ԭʼֵ}

//  4  64 λв֧

function CnAtomicCompareExchange(var Target: Pointer; NewValue: Pointer; Comperand: Pointer): Pointer;
{* ԭӲȽ Target  Comperand ֵʱ NewValue ֵ Targetؾɵ Target ֵ
  32 λ֧ 32 λֵ64 λ֧ 64 λֵ}

function CnAtomicCompareAndSet(var Target: Pointer; NewValue: Pointer; Comperand: Pointer): Boolean;
{* ԭӲִ´룬Ƚ Target  Comperand ֵʱ NewValue ֵ Target
  32 λ֧ 32 λֵ64 λ֧ 64 λֵδֵʱ Falseֵʱ True
  ע NewValue Ҫ Target޷Ƿִ˸ֵΪǷֵһ
  if Comperand = Target then
  begin
    Target := NewValue;
    Result := True;
  end
  else
    Result := False;
}

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------

procedure CnInitSpinLockRecord(var Critical: TCnSpinLockRecord);
{* ʼһʵǸֵΪ 0ͷ}

procedure CnSpinLockEnter(var Critical: TCnSpinLockRecord);
{* }

procedure CnSpinLockLeave(var Critical: TCnSpinLockRecord);
{* 뿪}

implementation

{$IFDEF MSWINDOWS}
const
  kernel32  = 'kernel32.dll';
{$ELSE}
const // MACOS  Linux TODO: ȷ Mac в
  kernel32  = 'libwine.borland.so';
{$ENDIF}

// ע 32 λ XP ûУҪ̬

type
  TInterlockedCompareExchange64 = function (var Destination: Int64;
    Exchange: Int64; Comparand: Int64): Int64 stdcall;

var
  InterlockedCompareExchange64: TInterlockedCompareExchange64 = nil;

resourcestring
  SCnNotImplemented = 'NOT Implemented!';

//function InterlockedCompareExchange64(var Destination: Int64; Exchange: Int64;
//  Comparand: Int64): Int64 stdcall; external kernel32 name 'InterlockedCompareExchange64';

function CnAtomicIncrement32(var Addend: Integer): Integer;
begin
{$IFDEF SUPPORT_ATOMIC}
  Result := AtomicIncrement(Addend);
{$ELSE}
  Result := InterlockedIncrement(Addend);
{$ENDIF}
end;

function CnAtomicDecrement32(var Addend: Integer): Integer;
begin
{$IFDEF SUPPORT_ATOMIC}
  Result := AtomicDecrement(Addend);
{$ELSE}
  Result := InterlockedDecrement(Addend);
{$ENDIF}
end;

function CnAtomicExchange32(var Target: Integer; Value: Integer): Integer;
begin
{$IFDEF SUPPORT_ATOMIC}
  Result := AtomicExchange(Target, Value);
{$ELSE}
  Result := InterlockedExchange(Target, Value);
{$ENDIF}
end;

function CnAtomicExchangeAdd32(var Addend: LongInt; Value: LongInt): LongInt;
begin
{$IFDEF SUPPORT_ATOMIC}
  Result := AtomicIncrement(Addend, Value) - Value;
{$ELSE}
  {$IFDEF WIN64}
  Result := InterlockedExchangeAdd(Addend, Value);
  {$ELSE}
  Result := InterlockedExchangeAdd(@Addend, Value);
  {$ENDIF}
{$ENDIF}
end;

function CnAtomicIncrement64(var Addend: Int64): Int64;
{$IFNDEF SUPPORT_ATOMIC}
var
  Tmp: Int64;
{$ENDIF}
begin
{$IFDEF SUPPORT_ATOMIC}
  Result := AtomicIncrement(Addend);
{$ELSE}
  if not Assigned(InterlockedCompareExchange64) then
    raise Exception.Create(SCnNotImplemented);
  repeat
    Tmp := Addend;
    Result := InterlockedCompareExchange64(Addend, Tmp + 1, Tmp);
  until Result = Tmp;
  Inc(Result);
{$ENDIF}
end;

function CnAtomicDecrement64(var Addend: Int64): Int64;
{$IFNDEF SUPPORT_ATOMIC}
var
  Tmp: Int64;
{$ENDIF}
begin
{$IFDEF SUPPORT_ATOMIC}
  Result := AtomicDecrement(Addend);
{$ELSE}
  if not Assigned(InterlockedCompareExchange64) then
    raise Exception.Create(SCnNotImplemented);
  repeat
    Tmp := Addend;
    Result := InterlockedCompareExchange64(Addend, Tmp - 1, Tmp);
  until Result = Tmp;
  Dec(Result);
{$ENDIF}
end;

function CnAtomicExchange64(var Target: Int64; Value: Int64): Int64;
{$IFNDEF SUPPORT_ATOMIC}
var
  Tmp: Int64;
{$ENDIF}
begin
{$IFDEF SUPPORT_ATOMIC}
  Result := AtomicExchange(Target, Value);
{$ELSE}
  if not Assigned(InterlockedCompareExchange64) then
    raise Exception.Create(SCnNotImplemented);
  repeat
    Tmp := Target;
    Result := InterlockedCompareExchange64(Target, Value, Tmp);
  until Result = Tmp;
{$ENDIF}
end;

function CnAtomicExchangeAdd64(var Addend: Int64; Value: Int64): Int64;
var
  Tmp: Int64;
begin
  repeat
{$IFDEF SUPPORT_ATOMIC}
    Tmp := Addend;
    Result := AtomicCmpExchange(Addend, Addend + Value, Tmp);
{$ELSE}
    if not Assigned(InterlockedCompareExchange64) then
      raise Exception.Create(SCnNotImplemented);
    Tmp := Addend;
    Result := InterlockedCompareExchange64(Addend, Addend + Value, Tmp);
{$ENDIF}
  until Result = Tmp;
end;

function CnAtomicCompareExchange(var Target: Pointer; NewValue: Pointer; Comperand: Pointer): Pointer;
begin
{$IFDEF SUPPORT_ATOMIC}
  Result := AtomicCmpExchange(Target, NewValue, Comperand);
{$ELSE}
  {$IFDEF BDS}
    // XE2  Win64 ʱ 64 λ汾XE3 İ汾һ
    {$IFDEF DELPHIXE2}
      {$IFDEF WIN64}
       Result := Pointer(InterlockedCompareExchange64(Int64(Target), Int64(NewValue), Int64(Comperand)));
      {$ELSE}
       Result := Pointer(InterlockedCompareExchange(Integer(Target), Integer(NewValue), Integer(Comperand)));
      {$ENDIF}
    {$ELSE}
       Result := Pointer(InterlockedCompareExchange(Integer(Target), Integer(NewValue), Integer(Comperand)));
    {$ENDIF}
  {$ELSE}
    {$IFDEF FPC}
      {$IFDEF CPU64BITS}
      Result := Pointer(InterlockedCompareExchange64(QWord(Target), QWord(NewValue), QWord(Comperand)));
      {$ELSE}
      Result := Pointer(InterlockedCompareExchange(LongInt(Target), LongInt(NewValue), LongInt(Comperand)));
      {$ENDIF}
    {$ELSE}// D567 µ InterlockedCompareExchange Ϊ Pointer
      Result := InterlockedCompareExchange(Target, NewValue, Comperand);
    {$ENDIF}
  {$ENDIF}
{$ENDIF}
end;

{$IFDEF SUPPORT_ATOMIC} // ߰汾 Delphi ʵ֣ͬƽ̨Զ

function CnAtomicCompareAndSet(var Target: Pointer; NewValue: Pointer;
  Comperand: Pointer): Boolean;
begin
  AtomicCmpExchange(Target, NewValue, Comperand, Result);
end;

{$ELSE} // ϵͰ汾 Delphi Լ FPC ķֿʵ

{$IFDEF CPUX64} // WIN64 £ FPC  Win64 Ҳ CPUX64 µĻʵ

// XE2  Win64 û Atomic ϵк
function CnAtomicCompareAndSet(var Target: Pointer; NewValue: Pointer;
  Comperand: Pointer): Boolean; assembler;
asm
  // API  InterlockedCompareExchange ᷵Ƿɹòû
  MOV  RAX,  R8
  LOCK CMPXCHG [RCX], RDX
  SETZ AL
  AND RAX, $FF
end;

{$ELSE}

{$IFDEF CPUX86}

// XE2 °汾 Win32 ʵ
function CnAtomicCompareAndSet(var Target: Pointer; NewValue: Pointer;
  Comperand: Pointer): Boolean; assembler;
asm
  // API  InterlockedCompareExchange ᷵Ƿɹòû
  //  @Target  EAX, NewValue  EDXComperand  ECX
  // Ҫһ ECX  EAX Ļܵ LOCK CMPXCHG [ECX], EDX AL 
  XCHG  EAX, ECX
  LOCK CMPXCHG [ECX], EDX
  SETZ AL
  AND EAX, $FF
end;

{$ELSE}

// TODO: ARM32/64 ʵ֣ FPC Ϊ
function CnAtomicCompareAndSet(var Target: Pointer; NewValue: Pointer;
  Comperand: Pointer): Boolean;
begin
  raise Exception.Create(SCnNotImplemented);
end;

{$ENDIF}

{$ENDIF}

{$ENDIF}

procedure CnInitSpinLockRecord(var Critical: TCnSpinLockRecord);
begin
  Critical := 0;
end;

procedure CnSpinLockEnter(var Critical: TCnSpinLockRecord);
begin
  repeat
    while Critical <> 0 do
      ;  // ˴ĳ Sleep(0) ͻ߳лͲ
  until CnAtomicCompareAndSet(Pointer(Critical), Pointer(1), Pointer(0));
end;

procedure CnSpinLockLeave(var Critical: TCnSpinLockRecord);
begin
  while not CnAtomicCompareAndSet(Pointer(Critical), Pointer(0), Pointer(1)) do
    Sleep(0);
end;

{ TCnLockFreeLinkedList }

function DefaultKeyCompare(Key1, Key2: TObject): Integer;
var
  K1, K2: TCnNativeInt;
begin
  K1 := TCnNativeInt(Key1);
  K2 := TCnNativeInt(Key2);

  if K1 > K2 then
    Result := 1
  else if K1 < K2 then
    Result := -1
  else
    Result := 0;
end;

procedure TCnLockFreeLinkedList.Append(Key, Value: TObject);
var
  Node, P: PCnLockFreeLinkedNode;
begin
  Node := CreateNode;
  Node^.Key := Key;
  Node^.Value := Value;
  Node^.Next := FGuardTail;

  // ԭӲβ Tailж Tail  Next Ƿ FGuardTail Tail  Next Ϊ NewNode
  // ߳޸ Tailȡ Tail βͣô Tail  Next ͲΪ nil͵
  // עβָ FGuardTail ڵһڵ㣬β͵ Next Ӧ FGuardTail
  repeat
    P := GetLastNode;
  until CnAtomicCompareAndSet(Pointer(P^.Next), Pointer(Node), FGuardTail);
end;

procedure TCnLockFreeLinkedList.Clear;
var
  P, N: PCnLockFreeLinkedNode;
begin
  P := GetNextNode(FGuardHead);
  while (P <> nil) and (P <> FGuardTail) do
  begin
    N := P;
    P := GetNextNode(P);
    FreeNode(N);
  end;
  FGuardHead := @FHiddenHead;
  FGuardTail := @FHiddenTail;
end;

function TCnLockFreeLinkedList.CompareKey(Key1, Key2: TObject): Integer;
begin
  if Assigned(FCompare) then
    Result := FCompare(Key1, Key2)
  else
    Result := DefaultKeyCompare(Key1, Key2);
end;

constructor TCnLockFreeLinkedList.Create(KeyCompare: TCnLockFreeNodeKeyCompare);
begin
  inherited Create;
  FCompare := KeyCompare;

  FHiddenTail.Key := nil;
  FHiddenTail.Value := nil;
  FHiddenTail.Next := nil;

  FHiddenHead.Key := nil;
  FHiddenHead.Value := nil;
  FHiddenHead.Next := @FHiddenTail;

  FGuardHead := @FHiddenHead;
  FGuardTail := @FHiddenTail;
end;

function TCnLockFreeLinkedList.CreateNode: PCnLockFreeLinkedNode;
begin
  New(Result);
  Result^.Next := nil;
end;

{$HINTS OFF}

function TCnLockFreeLinkedList.Delete(Key: TObject): Boolean;
var
  R, RN, L: PCnLockFreeLinkedNode;
begin
  Result := False;
  RN := nil;

  while True do
  begin
    InternalSearch(Key, L, R);
    if (R = FGuardTail) or (CompareKey(R^.Key, Key) <> 0) then
      Exit;

    // R ҪҪɾ RȰ R  Next Ϊɾ
    RN := R^.Next;
    if not IsNodePointerMarked(RN) then
      if CnAtomicCompareAndSet(Pointer(R^.Next), GetMarkedNodePointer(RN), RN) then
        Break;
  end;

  // ٰ L  Next ҵ R  Next
  if not CnAtomicCompareAndSet(Pointer(L^.Next), RN, R) then
    InternalSearch(R^.Key, L, R); // Ȼɾ R
  Result := True;
end;

destructor TCnLockFreeLinkedList.Destroy;
begin
  Clear;
  inherited;
end;

function TCnLockFreeLinkedList.ExtractRealNodePointer(
  Node: PCnLockFreeLinkedNode): PCnLockFreeLinkedNode;
begin
  Result := PCnLockFreeLinkedNode(TCnNativeUInt(Node) and TCnNativeUInt(not 1));
end;

procedure TCnLockFreeLinkedList.FreeNode(Node: PCnLockFreeLinkedNode);
begin
  if Node <> nil then
    Dispose(Node);
end;

function TCnLockFreeLinkedList.GetCount: Integer;
var
  P: PCnLockFreeLinkedNode;
begin
  Result := 0;
  P := GetNextNode(FGuardHead);
  while (P <> nil) and (P <> FGuardTail) do
  begin
    Inc(Result);
    P := GetNextNode(P);
  end;
end;

function TCnLockFreeLinkedList.GetLastNode: PCnLockFreeLinkedNode;
begin
  Result := FGuardHead;
  while (Result^.Next <> nil) and (Result^.Next <> FGuardTail) do
    Result := Result^.Next;
end;

function TCnLockFreeLinkedList.GetNextNode(
  Node: PCnLockFreeLinkedNode): PCnLockFreeLinkedNode;
begin
  Result := ExtractRealNodePointer(Node^.Next);
end;

function TCnLockFreeLinkedList.HasKey(Key: TObject; out Value: TObject): Boolean;
var
  L, R: PCnLockFreeLinkedNode;
begin
  InternalSearch(Key, L, R);
  if (R = FGuardTail) or (R^.Key <> Key) then
  begin
    Value := nil;
    Result := False;
  end
  else
  begin
    Value := R^.Value;
    Result := True;
  end;
end;

procedure TCnLockFreeLinkedList.InternalSearch(Key: TObject; var LeftNode,
  RightNode: PCnLockFreeLinkedNode);
var
  T, TN, L: PCnLockFreeLinkedNode;
begin
  L := nil;
  while True do
  begin
    T := FGuardHead;
    TN := T^.Next;

    // ڵ㣬õҽڵ
    repeat
      if not IsNodePointerMarked(TN) then
      begin
        LeftNode := T;
        L := TN;
      end;

      T := ExtractRealNodePointer(TN);
      if T = FGuardTail then
        Break;

      TN := T^.Next;
    until (not IsNodePointerMarked(TN)) and (CompareKey(T^.Key, Key) >= 0);
    RightNode := T;

    //  LeftNode  RightNode Ƿڣ L  LeftNode һڵ㣬
    if L = RightNode then
    begin
      // ҽڵ¸ڵ㱻ˣҪ
      if (RightNode <> FGuardTail) and IsNodePointerMarked(RightNode^.Next) then
        Continue
      else
      begin
        Exit;
      end;
    end;

    // Ļ˵ L  RightNode һмбǹĽڵ㣬ɾǹĽڵ L LeftNode  Next ָ Right
    if CnAtomicCompareAndSet(Pointer(LeftNode^.Next), RightNode, L) then
    begin
      FreeNode(L);
      if (RightNode <> FGuardTail) and IsNodePointerMarked(RightNode^.Next) then
        Continue
      else
      begin
        Exit;
      end;
    end;
  end;
end;

function TCnLockFreeLinkedList.IsNodePointerMarked(
  Node: PCnLockFreeLinkedNode): Boolean;
begin
  Result := (TCnNativeUInt(Node) and 1) <> 0;
end;

function TCnLockFreeLinkedList.GetMarkedNodePointer(
  Node: PCnLockFreeLinkedNode): PCnLockFreeLinkedNode;
begin
  Result := PCnLockFreeLinkedNode(TCnNativeUInt(Node) or 1);
end;

function TCnLockFreeLinkedList.Insert(Key, Value: TObject): Boolean;
var
  L, R, N: PCnLockFreeLinkedNode;
begin
  Result := False;
  N := nil;

  while True do
  begin
    InternalSearch(Key, L, R);
    if (R <> FGuardTail) and (CompareKey(R^.Key, Key) = 0) then
      Exit; // Key Ѵ

    FreeNode(N);
    N := CreateNode;
    N^.Next := R;
    N^.Key := Key;
    N^.Value := Value;

    if CnAtomicCompareAndSet(Pointer(L^.Next), N, R) then
    begin
      Result := True;
      Exit;
    end;
  end;
end;

procedure TCnLockFreeLinkedList.Travel;
var
  P: PCnLockFreeLinkedNode;
begin
  P := GetNextNode(FGuardHead);
  while (P <> nil) and (P <> FGuardTail) do
  begin
    DoTravelNode(P);
    P := GetNextNode(P);
  end;
end;

procedure TCnLockFreeLinkedList.DoTravelNode(Node: PCnLockFreeLinkedNode);
begin
  if Assigned(FOnTravelNode) then
    FOnTravelNode(Self, Node);
end;

function TCnLockFreeLinkedList.RemoveTail(out Key, Value: TObject): Boolean;
var
  P1, P2, RN: PCnLockFreeLinkedNode;
begin
  Result := False;
  RN := nil;

  while True do
  begin
    if not GetLast2Nodes(P1, P2) then
      Exit;

    RN := P2^.Next;
    if not IsNodePointerMarked(RN) then
      if CnAtomicCompareAndSet(Pointer(P2^.Next), GetMarkedNodePointer(RN), RN) then
        Break;
  end;

  Key := P2^.Key;
  Value := P2^.Value;

  if not CnAtomicCompareAndSet(Pointer(P1^.Next), RN, P2) then
    InternalSearch(P2^.Key, P1, P2);
  Result := True;
end;

{$HINTS ON}

function TCnLockFreeLinkedList.GetLast2Nodes(out P1,
  P2: PCnLockFreeLinkedNode): Boolean;
var
  T, TN, L: PCnLockFreeLinkedNode;
begin
  Result := False;
  if FGuardHead^.Next = FGuardTail then
    Exit;

  L := nil;
  while True do
  begin
    T := FGuardHead;
    P1 := T;
    TN := T^.Next;

    // ڵ㣬õҽڵ
    repeat
      if not IsNodePointerMarked(TN) then
      begin
        P1 := T;
        L := TN;
      end;

      T := ExtractRealNodePointer(TN);
      if T^.Next = FGuardTail then
        Break;

      TN := T^.Next;
    until False;
    P2 := T;

    //  LeftNode  RightNode Ƿ
    if L = P2 then
    begin
      // ҽڵ¸ڵ㱻ˣҪ
      if (P2 <> FGuardTail) and IsNodePointerMarked(P2^.Next) then
        Continue
      else
      begin
        Result := True;
        Exit;
      end;
    end;

    // ɾǹĽڵ
    if CnAtomicCompareAndSet(Pointer(P1^.Next), P2, L) then
    begin
      if (P2 <> FGuardTail) and IsNodePointerMarked(P2^.Next) then
        Continue
      else
      begin
        Result := True;
        Exit;
      end;
    end;
  end;
end;

{ TCnLockFreeSingleRingQueue }

constructor TCnLockFreeSingleRingQueue.Create(ASize: Integer);
begin
  if ASize <= 0 then
    ASize := CN_RING_QUEUE_DEFAULT_CAPACITY;

  FSize := GetUInt32PowerOf2GreaterEqual(ASize);
  if FSize <= 1 then
    FSize := CN_RING_QUEUE_DEFAULT_CAPACITY;

  SetLength(FNodes, FSize);
  FHead := 0;
  FTail := 0;
end;

function TCnLockFreeSingleRingQueue.Dequeue(out Key, Value: TObject): Boolean;
var
  Idx: Integer;
begin
  // ȳٸ Tail
  Result := False;
  if not IsEmpty then
  begin
    Idx := GetIndex(FTail + 1);
    Key := FNodes[Idx].Key;
    Value := FNodes[Idx].Value;

    Inc(FTail);
    Result := True;
  end;
end;

destructor TCnLockFreeSingleRingQueue.Destroy;
begin
  SetLength(FNodes, 0);
  inherited;
end;

function TCnLockFreeSingleRingQueue.Enqueue(Key, Value: TObject): Boolean;
var
  Idx: Integer;
begin
  // Ƚٸ Head
  Result := False;
  if not IsFull then
  begin
    Idx := GetIndex(FHead + 1);
    FNodes[Idx].Key := Key;
    FNodes[Idx].Value := Value;

    Inc(FHead);
    Result := True;
  end;
end;

function TCnLockFreeSingleRingQueue.GetCount: Integer;
begin
  Result := FHead - FTail;
end;

function TCnLockFreeSingleRingQueue.GetIndex(Seq: Cardinal): Integer;
begin
  Result := Seq and (FSize - 1);
end;

function TCnLockFreeSingleRingQueue.IsEmpty: Boolean;
begin
  Result := (GetIndex(FHead) = GetIndex(FTail));
end;

function TCnLockFreeSingleRingQueue.IsFull: Boolean;
begin
  Result := (GetIndex(FHead) = GetIndex(FTail - 1));
end;

{ TCnLockFreeLinkedStack }

function TCnLockFreeLinkedStack.Pop(out Key, Value: TObject): Boolean;
begin
  Result := RemoveTail(Key, Value);
end;

procedure TCnLockFreeLinkedStack.Push(Key, Value: TObject);
begin
  Append(Key, Value);
end;

initialization
  InterlockedCompareExchange64 := GetProcAddress(GetModuleHandle(kernel32), 'InterlockedCompareExchange64');

end.
