{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnDancingLinks;
{* |<PRE>
================================================================================
* ƣCnPack Ԫ
* Ԫƣʵֻʮ˫ѭϡ󣬲һڴʵ赸
* ԪߣCnPack  (master@cnpack.org)
*     עõԪΪϡʵʮ˫ѭֿ֧ƽ̨
*           ڴ˻ʵ赸Ŀɾ/ָеĻơ
*           δݵݹ
* ƽ̨PWinXP + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* ޸ļ¼2015.05.29 V1.0 by LiuXiao
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Classes, SysUtils, Contnrs;

type
  ECnCrossLinkedMatrixException = class(Exception);

//==============================================================================
// ʮ˫ڵʵ
//==============================================================================

  TCnCrossLinkedNode = class(TObject)
  {* ʮ˫ڵʵ}
  private
    FUp: TCnCrossLinkedNode;
    FLeft: TCnCrossLinkedNode;
    FRight: TCnCrossLinkedNode;
    FDown: TCnCrossLinkedNode;
    FColumn: Integer;
    FRow: Integer;
    FData: Integer;
    FText: string;
  public
    property Left: TCnCrossLinkedNode read FLeft write FLeft;
    {* ڵ㱾ߵĽڵ㣬籾ֻбڵ㣬ָڵ}
    property Right: TCnCrossLinkedNode read FRight write FRight;
    {* ڵ㱾ұߵĽڵ㣬籾ֻбڵ㣬ָڵ}
    property Up: TCnCrossLinkedNode read FUp write FUp;
    {* ڵ㱾ϱߵĽڵ㣬籾ֻбڵ㣬ָڵ}
    property Down: TCnCrossLinkedNode read FDown write FDown;
    {* ڵ㱾±ߵĽڵ㣬籾ֻбڵ㣬ָڵ}

    property Column: Integer read FColumn;
    {* ڵڵУ 0 ʼ}
    property Row: Integer read FRow;
    {* ڵڵУ 0 ʼ}

    property Data: Integer read FData write FData;
    {* Աһԣ Tag}
    property Text: string read FText write FText;
    {* Աһַ}
  end;

  TCnCrossLinkedNodeClass = class of TCnCrossLinkedNode;

//==============================================================================
// ʮ˫ѭʵֵϡ
//==============================================================================

  TCnCrossLinkedMatrix = class(TObject)
  {* ʮ˫ѭʵֵϡ}
  private
    FCount: Integer;  
    FColCount: Integer;
    FRowCount: Integer;
    FNodeClass: TCnCrossLinkedNodeClass;

    FColumnHeads: TObjectList;  // ͷָ
    FRowHeads: TObjectList;     // ͷָ
    FOnTravelNode: TNotifyEvent;

    function GetCells(Col, Row: Integer): TCnCrossLinkedNode;
    function CreateNode: TCnCrossLinkedNode;
    function GetColumnHead(Col: Integer): TCnCrossLinkedNode;
    function GetRowHead(Row: Integer): TCnCrossLinkedNode;
  protected
    procedure DoTravelNode(Node: TCnCrossLinkedNode); virtual;
  public
    constructor Create(AColCount: Integer; ARowCount: Integer;
      NodeClass: TCnCrossLinkedNodeClass = nil); virtual;
    destructor Destroy; override;

    function InsertNode(ACol, ARow: Integer): TCnCrossLinkedNode;
    {* ϡָλòһڵ㲢ش˽ڵ㣬λѴ򷵻 nil}
    function ExtractNode(ACol, ARow: Integer): TCnCrossLinkedNode;
    {* ϡָλýڵ㲢ش˽ڵ㣬λ޽ڵ򷵻 nil}
    procedure RemoveNode(ACol, ARow: Integer);
    {* ɾϡָλõĽڵ}

    procedure TravelByRow;
    {* б}
    procedure TravelByCol;
    {* б}
    procedure ExpandRow(ExpandCount: Integer = 1);
    {* ̬}
    procedure ExpandCol(ExpandCount: Integer = 1);
    {* ̬}

    property RowCount: Integer read FRowCount;
    {* ϡ}
    property ColCount: Integer read FColCount;
    {* ϡ}
    property Cells[Col, Row: Integer]: TCnCrossLinkedNode read GetCells;
    {* СϡĵԪо 0 ʼ}
    property RowHead[Row: Integer]: TCnCrossLinkedNode read GetRowHead;
    {* зͷԪ}
    property ColumnHead[Col: Integer]: TCnCrossLinkedNode read GetColumnHead;
    {* зͷԪ}
    property Count: Integer read FCount;
    {* Ԫظ}
    property OnTravelNode: TNotifyEvent read FOnTravelNode write FOnTravelNode;
    {* ʱ¼}
  end;

//==============================================================================
// 赸ʵ
//==============================================================================

  TCnDancingLinks = class(TCnCrossLinkedMatrix)
  {* 赸ʵ࣬˿ɾ/ԭеķ}
  public
    function ExtractRow(ARow: Integer): TCnCrossLinkedNode;
    {* һУظеͷԪأԪϵ}
    function RestoreRow(ARowHead: TCnCrossLinkedNode): Boolean;
    {*  ExtractRow ·ûԭλ}
    function ExtractColumn(ACol: Integer): TCnCrossLinkedNode;
    {* һУظеͷԪأԪϵ}
    function RestoreColumn(ColHead: TCnCrossLinkedNode): Boolean;
    {*  ExtractColumn ·ûԭλ}
  end;

implementation

{ TCnCrossLinkedMatrix }

constructor TCnCrossLinkedMatrix.Create(AColCount, ARowCount: Integer;
  NodeClass: TCnCrossLinkedNodeClass);
var
  I: Integer;
begin
  inherited Create;
  if (AColCount <= 0) or (ARowCount <= 0) then
    raise ECnCrossLinkedMatrixException.Create('Error Column/Row Count.');

  FColCount := AColCount;
  FRowCount := ARowCount;
  if NodeClass = nil then
    FNodeClass := TCnCrossLinkedNode
  else
    FNodeClass := NodeClass;

  FColumnHeads := TObjectList.Create(False);
  FRowHeads := TObjectList.Create(False);

  for I := 0 to RowCount - 1 do
    FRowHeads.Add(nil);
  for I := 0 to ColCount - 1 do
    FColumnHeads.Add(nil);
end;

function TCnCrossLinkedMatrix.CreateNode: TCnCrossLinkedNode;
begin
  try
    Result := TCnCrossLinkedNode(FNodeClass.NewInstance);
    Result.Create;
  except
    Result := nil;
  end;
end;

destructor TCnCrossLinkedMatrix.Destroy;
var
  I: Integer;
  P, Q, Head: TCnCrossLinkedNode;
begin
  if FColumnHeads <> nil then
  begin
    for I := 0 to FColumnHeads.Count - 1 do
    begin
      Head := TCnCrossLinkedNode(FColumnHeads[I]);
      if Head <> nil then
      begin
        // ͷű
        P := Head;
        repeat
          Q := P.Down;
          P.Free;
          P := Q;
        until (P = Head) or (P = nil);
      end;
    end;
  end;
  inherited;
end;

procedure TCnCrossLinkedMatrix.DoTravelNode(Node: TCnCrossLinkedNode);
begin
  if Assigned(FOnTravelNode) then
    FOnTravelNode(Node);
end;

procedure TCnCrossLinkedMatrix.ExpandCol(ExpandCount: Integer);
var
  I: Integer;
begin
  if ExpandCount <= 0 then
    raise ECnCrossLinkedMatrixException.Create('Invalid Expand Count.');

  Inc(FColCount, ExpandCount);
  for I := 1 to ExpandCount do
    FColumnHeads.Add(nil);
end;

procedure TCnCrossLinkedMatrix.ExpandRow(ExpandCount: Integer);
var
  I: Integer;
begin
  if ExpandCount <= 0 then
    raise ECnCrossLinkedMatrixException.Create('Invalid Expand Count.');

  Inc(FRowCount, ExpandCount);
  for I := 1 to ExpandCount do
    FRowHeads.Add(nil);
end;

function TCnCrossLinkedMatrix.ExtractNode(ACol, ARow: Integer): TCnCrossLinkedNode;
var
  P, Head: TCnCrossLinkedNode;
begin
  Result := nil;
  if FColumnHeads[ACol] <> nil then  // ָ
  begin
    Head := TCnCrossLinkedNode(FColumnHeads[ACol]);
    P := Head;
    repeat
      if P.Row = ARow then
      begin
        Result := P;

        // ʼ⿪з P
        if (P = Head) and (P.Up = P) and (P.Down = P) then
        begin
          // ֻ Head һֱͷ
          FColumnHeads[ACol] := nil;
        end
        else
        begin
          if P = Head then // P ͷҪͷ
            FColumnHeads[ACol] := P.Down;
          P.Up.Down := P.Down;
          P.Down.Up := P.Up;
        end;

        // ʼ⿪з P
        Head := TCnCrossLinkedNode(FRowHeads[ARow]);
        if (P = Head) and (P.Left = P) and (P.Right = P) then
        begin
          // ֻ Head һֱͷ
          FRowHeads[ARow] := nil;
        end
        else
        begin
          if P = Head then // P ͷҪͷ
            FRowHeads[ARow] := P.Right;
          P.Left.Right := P.Right;
          P.Right.Left := P.Left;
        end;

        Dec(FCount);
        Exit;
      end;
      P := P.Down;
    until (P = Head) or (P = nil);
  end;
end;

function TCnCrossLinkedMatrix.GetCells(Col, Row: Integer): TCnCrossLinkedNode;
var
  P, Head: TCnCrossLinkedNode;
begin
  Result := nil;
  if FColumnHeads[Col] <> nil then  // ָ
  begin
    Head := TCnCrossLinkedNode(FColumnHeads[Col]);
    P := Head;
    repeat
      if P.Row = Row then
      begin
        Result := P;
        Exit;
      end;
      P := P.Down;
    until (P = Head) or (P = nil);
  end;
end;

function TCnCrossLinkedMatrix.GetColumnHead(Col: Integer): TCnCrossLinkedNode;
begin
  if (Col < 0) or (Col >= FColCount) then
    raise ECnCrossLinkedMatrixException.Create('Invalid Column Index.');

  Result := TCnCrossLinkedNode(FColumnHeads[Col]);
end;

function TCnCrossLinkedMatrix.GetRowHead(Row: Integer): TCnCrossLinkedNode;
begin
  if (Row < 0) or (Row >= FColCount) then
    raise ECnCrossLinkedMatrixException.Create('Invalid Row Index.');

  Result := TCnCrossLinkedNode(FRowHeads[Row]);
end;

function TCnCrossLinkedMatrix.InsertNode(ACol, ARow: Integer): TCnCrossLinkedNode;
var
  P, Head: TCnCrossLinkedNode;
  InsertColSuccess, InsertRowSuccess: Boolean;
begin
  Result := nil;
  if (ACol < 0) or (ARow < 0) or (ACol >= FColCount) or (ARow >= FRowCount) then
    raise ECnCrossLinkedMatrixException.Create('Error Column/Row Index.');

  if Cells[ACol, ARow] <> nil then // Ѿ
    Exit;

  InsertRowSuccess := False;
  InsertColSuccess := False;
  Result := CreateNode;
  Result.FColumn := ACol;
  Result.FRow := ARow;

  try
    if FRowHeads[ARow] = nil then // ΪգֱԼ
    begin
      Result.Left := Result;
      Result.Right := Result;
      FRowHeads[ARow] := Result;
    end
    else // вΪգҵص
    begin
      Head := TCnCrossLinkedNode(FRowHeads[ARow]);
      P := Head;
      repeat
        if P.Column = ACol then
        begin
          // еĴλѱռãֱͷ˳
          Exit;
        end
        else if P.Column > ACol then
          Break;

        P := P.Right;
      until (P = Head) or (P = nil);

      if (P = Head) and (Head.Column < ACol) then
      begin
        // ҵͷ˶ûҵҪеģڱĩ
        P := P.Left; // P ʱƻȥβڵ
        P.Right := Result;
        Result.Left := P;
        Result.Right := Head;
        Head.Left := Result;
      end
      else
      begin
        // P  ARow ĵһӦò P  P ֮
        if Head = P then // P ͷͷ
          FRowHeads[ARow] := Result;

        //  P 
        Result.Left := P.Left;
        Result.Right := P;
        P.Left.Right := Result;
        P.Left := Result;
      end;
    end;
    InsertRowSuccess := True;

    if FColumnHeads[ACol] = nil then // ΪգֱԼ
    begin
      Result.Up := Result;
      Result.Down := Result;
      FColumnHeads[ACol] := Result;
    end
    else // вΪգҵص
    begin
      Head := TCnCrossLinkedNode(FColumnHeads[ACol]);
      P := Head;
      repeat
        if P.Row = ARow then
        begin
          // еĴλѱռãҪָɾ Result Ѿ
          // ˼жϣԴ˴Ͻ迼Ǹӵͷ
          Exit;
        end
        else if P.Row > ARow then
          Break;

        P := P.Down;
      until (P = Head) or (P = nil);

      if (P = Head) and (P.Row < ARow) then
      begin
        // ҵͷ˶ûҵҪеģڱĩ
        P := P.Up; // P ʱƻȥβڵ
        P.Down := Result;
        Result.Up := P;
        Result.Down := Head;
        Head.Up := Result;
      end
      else
      begin
        // P  ACol ĵһӦò P  P ֮
        if P = Head then // P ͷͷ
          FColumnHeads[ACol] := Result;

        //  P ϱ
        Result.Up := P.Up;
        Result.Down := P;
        P.Up.Down := Result;
        P.Up := Result;
      end;
    end;
    InsertColSuccess := True;
  finally
    if not InsertColSuccess and not InsertRowSuccess then
      FreeAndNil(Result)
    else
      Inc(FCount);
  end;
end;

procedure TCnCrossLinkedMatrix.RemoveNode(ACol, ARow: Integer);
begin
  ExtractNode(ACol, ARow).Free;
end;

procedure TCnCrossLinkedMatrix.TravelByCol;
var
  I: Integer;
  P, Q, Head: TCnCrossLinkedNode;
begin
  for I := 0 to FColumnHeads.Count - 1 do
  begin
    Head := TCnCrossLinkedNode(FColumnHeads[I]);
    if Head <> nil then
    begin
      P := Head;
      repeat
        Q := P.Down;
        DoTravelNode(P);
        P := Q;
      until (P = Head) or (P = nil);
    end;
  end;
end;

procedure TCnCrossLinkedMatrix.TravelByRow;
var
  I: Integer;
  P, Q, Head: TCnCrossLinkedNode;
begin
  for I := 0 to FRowHeads.Count - 1 do
  begin
    Head := TCnCrossLinkedNode(FRowHeads[I]);
    if Head <> nil then
    begin
      P := Head;
      repeat
        Q := P.Right;
        DoTravelNode(P);
        P := Q;
      until (P = Head) or (P = nil);
    end;
  end

end;

{ TCnDancingLinks }

function TCnDancingLinks.ExtractColumn(ACol: Integer): TCnCrossLinkedNode;
var
  P: TCnCrossLinkedNode;
  Row: Integer;
begin
  if (ACol < 0) or (ACol >= ColCount) then
    raise ECnCrossLinkedMatrixException.Create('Error Column Index.');

  Result := TCnCrossLinkedNode(FColumnHeads[ACol]);
  if Result = nil then
    Exit;

  //  Result ָԪأ⿪
  P := Result;
  repeat
    Row := P.Row;
    if (P.Left = P) and (P.Right = P) and (FRowHeads[Row] = P) then // ֻһֱͷ
      FRowHeads[Row] := nil
    else
    begin
      // P ͷͷָһ
      if FRowHeads[Row] = P then
        FRowHeads[Row] := P.Right;
      // ⿪ P
      P.Left.Right := P.Right;
      P.Right.Left := P.Left;
    end;
    
    Dec(FCount);
    P := P.Down;
  until (P = Result) or (P = nil);
  // ժ
  FColumnHeads[ACol] := nil;
end;

function TCnDancingLinks.ExtractRow(ARow: Integer): TCnCrossLinkedNode;
var
  P: TCnCrossLinkedNode;
  Col: Integer;
begin
  if (ARow < 0) or (ARow >= RowCount) then
    raise ECnCrossLinkedMatrixException.Create('Error Row Index.');

  Result := TCnCrossLinkedNode(FRowHeads[ARow]);
  if Result = nil then
    Exit;

  //  Result ָԪأ⿪
  P := Result;
  repeat
    Col := P.Column;
    if (P.Up = P) and (P.Down = P) and (FColumnHeads[Col] = P) then // ֻһֱͷ
      FColumnHeads[Col] := nil
    else
    begin
      // P ͷͷָһ
      if FColumnHeads[Col] = P then
        FColumnHeads[Col] := P.Down;
      // ⿪ P
      P.Up.Down := P.Down;
      P.Down.Up := P.Up;
    end;

    Dec(FCount);
    P := P.Right;
  until (P = Result) or (P = nil);
  // ժ
  FRowHeads[ARow] := nil;
end;

function TCnDancingLinks.RestoreColumn(ColHead: TCnCrossLinkedNode): Boolean;
var
  Row, Col: Integer;
  P: TCnCrossLinkedNode;
begin
  Result := False;
  if ColHead = nil then
    Exit;

  Col := ColHead.Column;
  if (Col < 0) or (Col >= ColCount) then
    Exit;

  if FColumnHeads[Col] <> nil then // Ѵڣ޷ٴβ
    Exit;

  // ½Ԫز
  FColumnHeads[Col] := ColHead; // ͷָԪ
  P := ColHead;
  repeat
    // ÿһԪأؽеӹϵ
    Row := P.Row;
    if FRowHeads[Row] = nil then
    begin
      // Ԫأֱͷ
      FRowHeads[Row] := P;
      P.Left := P;
      P.Right := P;
    end
    else
    begin
      // ָ P
      P.Left.Right := P;
      P.Right.Left := P;
      //  P ףͷָ
      if P.Column < TCnCrossLinkedNode(FRowHeads[Row]).Column then
        FRowHeads[Row] := P;
    end;

    Inc(FCount);
    P := P.Down;
  until (P = ColHead) or (P = nil);
end;

function TCnDancingLinks.RestoreRow(ARowHead: TCnCrossLinkedNode): Boolean;
var
  Row, Col: Integer;
  P: TCnCrossLinkedNode;
begin
  Result := False;
  if ARowHead = nil then
    Exit;

  Row := ARowHead.Row;
  if (Row < 0) or (Row >= RowCount) then
    Exit;

  if FRowHeads[Row] <> nil then // Ѵڣ޷ٴβ
    Exit;

  // ½Ԫز
  FRowHeads[Row] := ARowHead; // ͷָԪ
  P := ARowHead;
  repeat
    // ÿһԪأؽеӹϵ
    Col := P.Column;
    if FColumnHeads[Col] = nil then
    begin
      // Ԫأֱͷ
      FColumnHeads[Col] := P;
      P.Up := P;
      P.Down := P;
    end
    else
    begin
      // ָ P
      P.Up.Down := P;
      P.Down.Up := P;
      //  P ףͷָ
      if P.Row < TCnCrossLinkedNode(FColumnHeads[Col]).Row then
        FColumnHeads[Col] := P;
    end;

    Inc(FCount);
    P := P.Right;
  until (P = ARowHead) or (P = nil);
end;

end.
