{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnClasses;
{* |<PRE>
================================================================================
* ƣ
* Ԫƣඨ嵥Ԫ
* Ԫߣܾ (zjy@cnpack.org)
*     עõԪĻ
* ƽ̨PWin98SE + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/6
*   õԪеַϱػʽ
* ޸ļ¼2024.05.10 V1.6
*                TCnUInt32List/TCnUInt64List ȥ CnContainers
*           2023.11.30 V1.5
*               װֽ
*           2018.08.30 V1.4
*                TCnUInt32List/TCnUInt64List 
*           2003.03.02 V1.3
*                TCnLockObject 
*           2002.09.10 V1.2
*               ޸ TCnComponent ַ
*           2002.07.09 V1.1
*               
*           2002.04.08 V1.0
*                TCnComponent 
*           2002.01.11 V0.01Demo
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Classes, TypInfo, SyncObjs, {$IFDEF MSWINDOWS} Windows, {$ENDIF}
  {$IFDEF FPC} RTLConsts, {$ELSE}
  {$IFDEF COMPILER6_UP} RTLConsts, {$ELSE} Consts, {$ENDIF} {$ENDIF} CnNative;

type

//==============================================================================
// ߳ͬĶ
//==============================================================================

{ TCnLockObject }

  TCnLockObject = class (TObject)
  {* ߳ͬĶ}
  private
    FLock: SyncObjs.TCriticalSection;
    FLockCount: Integer;
    function GetLocking: Boolean;
  protected
    property LockCount: Integer read FLockCount;
    {* ǰ Lock ֻ}
  public
    constructor Create;
    {* ڲһʵ}
    destructor Destroy; override;
    procedure Lock;
    {* ٽΪ֤߳ͬUnlockɶʹ}
    function TryLock: Boolean;
    {* ǰ Lock Ϊ㣬棬򷵻ؼ١
       棬ڲɺ UnLock ͷ}
    procedure Unlock;
    {* ˳ٽͷͬ Lock ɶʹ}
    property Locking: Boolean read GetLocking;
    {* ȡǰ״̬}
  end;

//==============================================================================
// ʹ RTTI ʵ Assign  TPersistent 
//==============================================================================

{ TCnAssignablePersistent }

  TCnAssignablePersistent = class(TPersistent)
  public
    procedure Assign(Source: TPersistent); override;
  end;

//==============================================================================
// ʹ RTTI ʵ Assign  TCollectionItem 
//==============================================================================

{ TCnAssignableCollectionItem }

  TCnAssignableCollectionItem = class(TCollectionItem)
  public
    procedure Assign(Source: TPersistent); override;
  end;

//==============================================================================
// ʹ RTTI ʵ Assign  TCollection 
//==============================================================================

{ TCnAssignableCollection }

  TCnAssignableCollection = class(TCollection)
  public
    procedure Assign(Source: TPersistent); override;
  end;

//==============================================================================
// ֪̰ͨ߳ȫĳ־
//==============================================================================

{ TCnPersistent }

  TCnPersistent = class(TPersistent)
  {* ֪̰ͨ߳ȫĳ־}
  private
    FUpdateCount: Integer;
    FOnChanging: TNotifyEvent;
    FOnChange: TNotifyEvent;
    FOwner: TPersistent;
    FLockObject: TCnLockObject;
    function GetLocking: Boolean;
    function GetLockObject: TCnLockObject;
  protected
    function GetOwner: TPersistent; override;
    procedure Changing; virtual;
    {* ݿʼ£¼Ϊ0OnChanging¼}
    procedure Changed; virtual;
    {* ѱ¼Ϊ0OnChange¼}

    procedure SetUpdating(Updating: Boolean); virtual;
    {* ״̬̣ء
       ĬΪʼʱChangingʱChanged}
    function IsUpdating: Boolean;
    {* ǰ¼Ƿ0ڸ£}

    procedure OnChildChanging(Sender: TObject); virtual;
    {* Կʼ¼̣ΪݸTCnPersistent.Create
       ĬΪOnChanging¼}
    procedure OnChildChange(Sender: TObject); virtual;
    {* ѱ¼̣ΪݸTCnPersistent.Create
       ĬΪOnChange¼}

    property Owner: TPersistent read FOwner write FOwner;
    {*  }
    property LockObject: TCnLockObject read GetLockObject;
    {* ߳ͬ }
  public
    constructor Create; overload; virtual;
    {* ڲһʵ}
    constructor Create(AOwner: TPersistent); overload;
    {* ΪʵߣֱӻӰTCollectionҪΪ
       published ʱʹ}
    constructor Create(ChangeProc: TNotifyEvent); overload;
    {* ڸOnChange¼ָһʼֵ}
    constructor Create(ChangingProc, ChangeProc: TNotifyEvent); overload;
    {* ڸOnChangingOnChange¼ָһʼֵ}
    destructor Destroy; override;

    procedure BeginUpdate; virtual;
    {* ʼ£ǰ¼Ϊ0ԶChangingء
       ڶԳԽ޸ʱø÷עEndUpdateɶʹ}
    procedure EndUpdate; virtual;
    {* £ǰ¼Ϊ0ԶChangeء
       ڶԳ޸ĺø÷עBeginUpdateɶʹ}

    procedure Lock;
    {* ٽΪ֤߳ͬUnlockɶʹ}
    function TryLock: Boolean;
    {* ǰLockΪ㣬棬򷵻ؼ١
       棬ڲɺUnLockͷ}
    procedure Unlock;
    {* ˳ٽͷͬLockɶʹ}

    property Locking: Boolean read GetLocking;
    {* ȡǰ״̬}
  published
    property OnChanging: TNotifyEvent read FOnChanging write FOnChanging;
    {* ʼ¼}
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    {* ѱ¼}
  end;

//==============================================================================
// Enabledĸ֪ͨ־
//==============================================================================

{ TCnEnabledPersistent }

  TCnEnabledPersistent = class(TCnPersistent)
  {* Enabledĸ֪ͨ־}
  private
    FEnabled: Boolean;
  protected
    procedure SetEnabled(const Value: Boolean); virtual;
    procedure SetUpdating(Updating: Boolean); override;
  public
    constructor Create; override;
    {* ڲһʵ}
    procedure Assign(Source: TPersistent); override;
  published
    property Enabled: Boolean read FEnabled write SetEnabled default False;
    {* EnabledԣΪ٣ChangingChangedĵý¼}
  end;

//==============================================================================
// ֪ͨĳ־
//==============================================================================

{ TCnNotifyClass }

  TCnNotifyClass = class(TPersistent)
  {* ֪ͨĳ־࣬ؼд󲿷ֳ־Ļ࣬һ㲻Ҫֱʹ}
  private
    FOnChanged: TNotifyEvent;
  protected
    FOwner: TPersistent;
    procedure Changed; virtual;
    procedure OnChildChanged(Sender: TObject); virtual;
    function GetOwner: TPersistent; override;
  public
    constructor Create(ChangedProc: TNotifyEvent); virtual;
    {* ๹Ϊ֪ͨ¼}
    procedure Assign(Source: TPersistent); override;
    {* ֵ}
    property OnChanged: TNotifyEvent read FOnChanged write FOnChanged;
    {* ѱ¼}
  end;

//==============================================================================
// 
//==============================================================================

{ TCnComponent }

  TCnCopyright = type string;

  TCnComponent = class(TComponent)
  {* CnPack}
  private
    FAbout: TCnCopyright;
    procedure SetAbout(const Value: TCnCopyright);
  protected
    procedure GetComponentInfo(var AName, Author, Email, Comment: string); virtual;
      abstract;
    {* ȡϢṩ˵ͰȨϢ󷽷ʵ֡
     |<PRE>
       var AName: string      - ƣֱ֧ػַ
       var Author: string     - ߣжߣ÷ֺŷָ
       var Email: string      - 䣬жߣ÷ֺŷָ
       var Comment:           - ˵ֱ֧ػзַ
     |</PRE>}
  public
    constructor Create(AOwner: TComponent); override;
  published
    property About: TCnCopyright read FAbout write SetAbout stored False;
    {* 汾ԣʹ}
  end;

//==============================================================================
// ʵӿڶ
//==============================================================================

{ TCnSingletonInterfacedObject }

  TCnSingletonInterfacedObject = class(TInterfacedObject)
  protected
    function _AddRef: Integer; stdcall;
    function _Release: Integer; stdcall;
  end;

procedure AssignPersistent(Source: TPersistent; Dest: TPersistent; UseDefineProperties:
  Boolean = True);

implementation

uses
  CnConsts;

type
  TPersistentHack = class(TPersistent);

procedure AssignPersistent(Source: TPersistent; Dest: TPersistent; UseDefineProperties:
  Boolean = True);
var
  Stream: TMemoryStream;
  Reader: TReader;
  Writer: TWriter;
  Count: Integer;
  PropIdx: Integer;
  PropList: PPropList;
  PropInfo: PPropInfo;
  AKind: TTypeKind;
begin
  if Source is Dest.ClassType then
  begin
    // ʹ RTTI ֵ֤ published ԣֵܴΪ Default ԣ
    Count := GetPropList(Dest.ClassInfo, tkProperties - [tkArray, tkRecord,
      tkInterface], nil);
    GetMem(PropList, Count * SizeOf(Pointer));
    try
      GetPropList(Source.ClassInfo, tkProperties - [tkArray, tkRecord,
        tkInterface], @PropList^[0]);

      for PropIdx := 0 to Count - 1 do
      begin
        PropInfo := PropList^[PropIdx];
        if PropInfo^.SetProc = nil then // д
          Continue;

{$IFDEF FPC}
        AKind := PropInfo^.PropType^.Kind;
{$ELSE}
        AKind := PropInfo^.PropType^^.Kind;
{$ENDIF}

        case AKind of
          tkInteger, tkChar, tkWChar, tkClass, tkEnumeration, tkSet:
            SetOrdProp(Dest, PropInfo, GetOrdProp(Source, PropInfo));
          tkFloat:
            SetFloatProp(Dest, PropInfo, GetFloatProp(Source, PropInfo));
          tkString, tkLString, tkWString{$IFDEF UNICODE}, tkUString{$ENDIF}:
            SetStrProp(Dest, PropInfo, GetStrProp(Source, PropInfo));
          tkVariant:
            SetVariantProp(Dest, PropInfo, GetVariantProp(Source, PropInfo));
          tkInt64:
            SetInt64Prop(Dest, PropInfo, GetInt64Prop(Source, PropInfo));
          tkMethod:
            SetMethodProp(Dest, PropInfo, GetMethodProp(Source, PropInfo));
        end;
      end;
    finally
      FreeMem(PropList);
    end;

    // ʹԶ
    if UseDefineProperties then
    begin
      Stream := nil;
      Reader := nil;
      Writer := nil;
      try
        Stream := TMemoryStream.Create;
        Writer := TWriter.Create(Stream, 4096);
        TPersistentHack(Source).DefineProperties(Writer);
        Writer.FlushBuffer;
        Stream.Position := 0;
        Reader := TReader.Create(Stream, 4096);
        TPersistentHack(Dest).DefineProperties(Reader);
      finally
        FreeAndNil(Reader);
        FreeAndNil(Writer);
        FreeAndNil(Stream);
      end;
    end;
  end;
end;

//==============================================================================
// ֧̰߳ȫĻ
//==============================================================================

var
  CounterLock: SyncObjs.TCriticalSection = nil;

{ TCnLockObject }

// ʼ
constructor TCnLockObject.Create;
begin
  inherited;
  FLock := SyncObjs.TCriticalSection.Create; // ʼٽ
end;

// ͷ
destructor TCnLockObject.Destroy;
begin
  FLock.Free;
  inherited;
end;

// ԽٽѼ False
function TCnLockObject.TryLock: Boolean;
begin
  CounterLock.Enter;
  try
    Result := FLockCount = 0;
    if Result then Lock;
  finally
    CounterLock.Leave;
  end;
end;

// 
procedure TCnLockObject.Lock;
begin
{$IFDEF SUPPORT_ATOMIC}
  AtomicIncrement(FLockCount);
{$ELSE}
  InterlockedIncrement(FLockCount);
{$ENDIF}
  FLock.Enter;
end;

// ͷ
procedure TCnLockObject.Unlock;
begin
  FLock.Leave;
{$IFDEF SUPPORT_ATOMIC}
  AtomicDecrement(FLockCount);
{$ELSE}
  InterlockedDecrement(FLockCount);
{$ENDIF}
end;

function TCnLockObject.GetLocking: Boolean;
begin
  Result := FLockCount > 0;
end;

//==============================================================================
// ʹ RTTI ʵ Assign  TPersistent 
//==============================================================================

{ TCnAssignablePersistent }

procedure TCnAssignablePersistent.Assign(Source: TPersistent);
begin
  if Source is ClassType then 
  begin
    AssignPersistent(Source, Self);
  end
  else
    inherited Assign(Source);
end;

//==============================================================================
// ʹ RTTI ʵ Assign  TCollectionItem 
//==============================================================================

{ TCnAssignableCollectionItem }

procedure TCnAssignableCollectionItem.Assign(Source: TPersistent);
begin
  if Source is ClassType then
  begin
    AssignPersistent(Source, Self);
  end
  else
    inherited Assign(Source);
end;

//==============================================================================
// ʹ RTTI ʵ Assign  TCollection 
//==============================================================================

{ TCnAssignableCollection }

procedure TCnAssignableCollection.Assign(Source: TPersistent);
begin
  if Source is ClassType then
  begin
    AssignPersistent(Source, Self);
  end;
  inherited Assign(Source);
end;

//==============================================================================
// ֪̰ͨ߳ȫĳ־
//==============================================================================

{ TCnPersistent }

// ʼأ
constructor TCnPersistent.Create;
begin
  inherited;
  FUpdateCount := 0;
end;

// ʼΪʵ
constructor TCnPersistent.Create(AOwner: TPersistent);
begin
  Create;
  FOwner := AOwner;
end;

// ʼΪ֪ͨ¼
constructor TCnPersistent.Create(ChangeProc: TNotifyEvent);
begin
  Create;
  FOnChange := ChangeProc;
end;

// ʼΪ֪ͨ¼
constructor TCnPersistent.Create(ChangingProc, ChangeProc: TNotifyEvent);
begin
  Create;
  FOnChanging := ChangingProc;
  FOnChange := ChangeProc;
end;

destructor TCnPersistent.Destroy;
begin
  if Assigned(FLockObject) then
    FLockObject.Free;
  inherited;
end;

//------------------------------------------------------------------------------
// ֪ͨ
//------------------------------------------------------------------------------

// ʼ
procedure TCnPersistent.BeginUpdate;
begin
  if not IsUpdating then SetUpdating(True); // ʼ
  Inc(FUpdateCount);
end;

// 
procedure TCnPersistent.EndUpdate;
begin                         // AssertҪػ
  Assert(FUpdateCount > 0, 'Unpaired TCnPersistent.EndUpdate');
  Dec(FUpdateCount);
  if not IsUpdating then SetUpdating(False);
end;

// ڱ
procedure TCnPersistent.Changing;
begin
  if not IsUpdating and Assigned(FOnChanging) then FOnChanging(Self);
end;

// 
procedure TCnPersistent.Changed;
begin
  if not IsUpdating and Assigned(FOnChange) then FOnChange(Self);
end;

// ȡ
function TCnPersistent.GetOwner: TPersistent;
begin
  Result := FOwner;
end;

// ڸ
function TCnPersistent.IsUpdating: Boolean;
begin
  Result := FUpdateCount > 0;
end;

// ״̬
procedure TCnPersistent.SetUpdating(Updating: Boolean);
begin
  if Updating then
    Changing
  else
    Changed;
end;

// ӵλ
procedure TCnPersistent.OnChildChanging(Sender: TObject);
begin
  if not IsUpdating and Assigned(FOnChanging) then FOnChanging(Sender);
end;

// ӵλѱ
procedure TCnPersistent.OnChildChange(Sender: TObject);
begin
  if not IsUpdating and Assigned(FOnChange) then FOnChange(Sender);
end;

//------------------------------------------------------------------------------
// ̰߳ȫ
//------------------------------------------------------------------------------

// ٽΪ֤߳ͬUnlockɶʹ
procedure TCnPersistent.Lock;
begin
  LockObject.Lock;
end;

// ǰLockΪ㣬棬򷵻ؼ
function TCnPersistent.TryLock: Boolean;
begin
  Result := LockObject.TryLock;
end;

// ˳ٽͷͬLockɶʹ
procedure TCnPersistent.Unlock;
begin
  LockObject.Unlock;
end;

// Locking Զ
function TCnPersistent.GetLocking: Boolean;
begin
  Result := LockObject.GetLocking;
end;

// LockObject ԶҪʱڲ
function TCnPersistent.GetLockObject: TCnLockObject;
begin
  if not Assigned(FLockObject) then
    FLockObject := TCnLockObject.Create;
  Result := FLockObject;
end;

//==============================================================================
// Enabledĸ֪ͨ־
//==============================================================================

{ TCnEnabledPersistent }

// ֵ
procedure TCnEnabledPersistent.Assign(Source: TPersistent);
begin
  if Source is TCnEnabledPersistent then
    FEnabled := TCnEnabledPersistent(Source).FEnabled
  else
    inherited Assign(Source);
end;

// ֪ͨ
procedure TCnEnabledPersistent.SetUpdating(Updating: Boolean);
begin
  if FEnabled then            // ֪ͨ
    inherited SetUpdating(Updating); 
end;

// 
constructor TCnEnabledPersistent.Create;
begin
  inherited Create;
  FEnabled := False;
end;

// ò
procedure TCnEnabledPersistent.SetEnabled(const Value: Boolean);
begin
  if FEnabled <> Value then
  begin
    FEnabled := True;         // ֪ͨ
    Changed;
    FEnabled := Value;
  end;
end;

{ TCnNotifyClass }

//--------------------------------------------------------//
// ֪ͨĳ־                                   //
//--------------------------------------------------------//

//ֵ
procedure TCnNotifyClass.Assign(Source: TPersistent);
begin
  if not (Source is TCnNotifyClass) then
    inherited Assign(Source);
end;

//֪ͨ
procedure TCnNotifyClass.Changed;
begin
  if Assigned(FOnChanged) then
    FOnChanged(Self);
end;

//
constructor TCnNotifyClass.Create(ChangedProc: TNotifyEvent);
begin
  inherited Create;
  FOnChanged := ChangedProc;
end;

//ȡ
function TCnNotifyClass.GetOwner: TPersistent;
begin
  Result := FOwner;
end;

//ӵλ֪ͨ
procedure TCnNotifyClass.OnChildChanged(Sender: TObject);
begin
  Changed;
end;

//==============================================================================
// 
//==============================================================================

{ TCnComponent }

// ʼ
constructor TCnComponent.Create(AOwner: TComponent);
begin
  inherited;
  FAbout := SCnPackAbout;
end;

// ù
procedure TCnComponent.SetAbout(const Value: TCnCopyright);
begin
  // 
end;

//==============================================================================
// ʵӿڶ
//==============================================================================

{ TCnSingletonInterfacedObject }

function TCnSingletonInterfacedObject._AddRef: Integer; stdcall;
begin
  Result := 1;
end;

function TCnSingletonInterfacedObject._Release: Integer; stdcall;
begin
  Result := 1;
end;

initialization
  CounterLock := SyncObjs.TCriticalSection.Create;

finalization
  CounterLock.Free;

end.

