{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2024 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

{*******************************************************************************
      йԭʼȨԪũֲд Pascal 룩
  _______________________________________________________________________

  йࣨChinese Calendar Class (CCC)
  汾v0.1JavaScript汾

  Ȩ (C) 2002-2003 neweroica (wy25@mail.bnu.edu.cn)

  ϵʽ Email:  wy25@mail.bnu.edu.cn

             QQ: 32460746
  ________________________________________________________________________

*******************************************************************************}

unit CnCalendar;
{* |<PRE>
================================================================================
* ƣ
* Ԫƣ㺯
* ԪߣCnPack  (master@cnpack.org)
*           zjy (zjy@cnpack.org)
*           ޽
*     עڡʱ֧ФڡСʮ񣩡
*           Ԫˡǡʮޡžšλʵ֣
*           ũתҲʵ֡
* ƽ̨PWinXP SP2 + Delphi 2006
* ݲԣPWin9X/2000/XP + Delphi 5/6
*   õԪеַϱػʽ
* ޸ļ¼2022.09.03 V2.4
*               ޽ʵı֤¸֧Сǰ
*           2022.07.03 V2.3
*               ޽ʵı֤ 1582 꼰֮ǰʮƫ
*           2022.01.29 V2.2
*               ոÿռλļ㣬ϲ񡢸񡢹ȣйĬ
*           2018.08.22 V2.1
*               ޽ʲ 2100 굽 2800 ũݲЭռƫ
*           2018.07.18 V2.0
*               ͨ㷨¾ǵļ㣬ӽӼ
*           2016.10.25 V1.9
*               ǵļ㣬Ԫ˾ǡʱ
*           2012.02.24 V1.8
*               һȷСʱ֧ӿ
*           2011.01.05 V1.7
*               ·ݵĽֽ羫ȷ
*           2011.01.05 V1.7
*               һ·ո֧Сʱʵ 23 ʱǴյĻ
*           2010.04.12 V1.6
*               гַļ
*           2009.07.27 V1.5
*               һũʱѭ
*           2009.07.16 V1.4
*               һռ㲻ȷ⣬ӷַ
*           2008.04.16 V1.3
*               Ӹ֧Сʮļũַת
*           2007.11.15 V1.2
*               Ӷʮյļ
*           2006.09.15 V1.1
*               ӹũĲּ㣬ֲй
*           2005.12.18 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Math;

const
  SCnYinYangArray: array[0..1] of string =
    ('', '');
  {* ַ }

  SCnTianGanArray: array[0..9] of string =
    ('', '', '', '', '', '', '', '', '', '');
  {* ַHeavenly Stems}

  SCnDiZhiArray: array[0..11] of string =
    ('', '', '', 'î', '', '', '', 'δ', '', '', '', '');
  {* ַ֧Earthly Branches}

  SCnShengXiaoArray: array[0..11] of string =
    ('', 'ţ', '', '', '', '', '', '', '', '', '', '');
  {* ФַZodiac Animals}

  SCnXingZuoArray: array[0..11] of string =
    ('', 'ţ', '˫', 'з', 'ʨ', 'Ů',
     '', 'Ы', '', 'Ħ', 'ƿ', '˫');
  {* ַZodiac}
  
  SCn28XiuArray: array[0..27] of string =
    ('', '', 'ص', '', '', 'β', '',  // 
     '', 'ţ', 'Ů', '', 'Σ', '', '',  // 
     '', '¦', 'θ', '', '', '', '',  // ׻
     '', '', '', '', '', '', ''); // Ϸȸ
  {* ʮַ }

  SCn28XiuLongArray: array[0..27] of string =
    ('ľ', '', 'ص', '', 'º', 'β', 'ˮ',  // 
     'ľ', 'ţţ', 'Ů', '', 'Σ', 'һ', 'ˮ',  // 
     'ľ', '¦', 'θ', 'ռ', '', '', 'ˮԳ',  // ׻
     'ľ', '', '', '', '¹', '', 'ˮ'); // Ϸȸ
  {* ʮַ }

  SCnLunarMonthLeapName: string = '';
  SCnLunarMonthName: string = '';
  SCnLunarMonthNameArray: array[0..11] of string =
    ('һ', '', '', '', '', '', '', '', '', 'ʮ', 'ʮһ', 'ʮ');
  {* ũ·ַ }

  SCnLunarNumber1Array: array[0..10] of string =
    ('һ', '', '', '', '', '', '', '', '', 'ʮ', '');
  {* ũڸλַ }

  SCnLunarNumber2Array: array[0..5] of string =
    ('', 'ʮ', 'إ', 'ئ', '', '');
  {* ũʮλַ }

  SCnWeekNumberArray: array[0..6] of string =
    ('', 'һ', '', '', '', '', '');
  {* ַ }

  SCn5XingArray: array[0..4] of string =
    ('', 'ľ', 'ˮ', '', '');
  {* ַͨĽľˮΪ˳ }

  SCn12JianArray: array[0..11] of string =
    ('', '', '', 'ƽ', '', 'ִ', '', 'Σ', '', '', '', '');
  {* ʮַ }

  SCn3FuArray: array[0..2] of string =
    ('', 'з', 'ĩ');
  {* ַ }

  SCnJieQiArray: array[0..23] of string = (
    '', //   Beginning of Spring   3
    'ˮ', //   Rain Water            4
    '', //   Waking of Insects     5
    '', //   March Equinox         6
    '', //   Pure Brightness       7
    '', //   Grain Rain            8
    '', //   Beginning of Summer   9
    'С', //   Grain Full            10
    'â', //   Grain in Ear          11
    '', //   Summer Solstice       12
    'С', //   Slight Heat           13
    '', //   Great Heat            14
    '', //   Beginning of Autumn   15
    '', //   Limit of Heat         16
    '¶', //   White Dew             17
    '', //   September Equinox     18
    '¶', //   Cold Dew              19
    '˪', //   Descent of Frost      20
    '', //   Beginning of Winter   21
    'Сѩ', //   Slight Snow           22
    'ѩ', //   Great Snow            23
    '', //   Winter Solstice       24
    'С', //   Slight Cold           1һеĵһ
    ''  //   Great Cold            2
  );
  {* ַSolar Terms}

  SCn3YuanArray: array[0..2] of string =
    ( 'Ԫ', 'Ԫ', 'Ԫ' );
  {* Ԫ}

  SCn9XingArray: array[0..8] of string =
    ( 'һ', '', '', '', '', '', '߳', '˰', '');
  {* }

  SCn9Xing5XingArray: array[0..8] of string =
    ( 'ˮ', '', 'ľ', 'ľ', '', '', '', '', '');
  {* }

  SCn9XingStarArray: array[0..8] of string =
    ( '̰', '', '»', '', '', '', 'ƾ', '', '');
  {* ǵ}

  SCnTaiShen1Array: array[0..59] of string =
    ( 'ռ', 'ĥ', '¯', 'ֿ', '',
      'ռŴ', 'ռĥ', '', 'ֿ¯', '',

      'ż', 'ĥ', '', 'ֿ', '¯',
      'ռ', 'ĥ', '', 'ֿ', '',

      'ռ¯', 'ĥ', '', 'ֿ', '',
      'ռŲ', 'ĥ¯', '¯', 'ֿ', 'ռ',

      'ռ', 'ĥ', '¯', 'ֿ', '',
      'ռŴ', 'ռĥ', '', 'ֿ¬', '',

      'ż', 'ĥ', '', 'ֿ', 'ֿ',
      'ռ', 'ĥ', '', 'ֿ', '',

      'ռ¯', 'ĥ', '', 'ֿⴲ', '',
      'ռŲ', 'ĥ¯', '', 'ֿ', 'ռŴ' );
  {* ÿ̥λãʮ֧ŶӦ}

  SCnTaiShen2Array: array[0..59] of string =
    ( 'ⶫ', 'ⶫ', '', '', '',
      '', '', '', '', '',

      '', '', '', '', '',
      '', '', '', '', '',

      '', '', '', '', '',
      '', '', '', '', 'ڱ',

      'ڱ', 'ڱ', 'ڱ', 'ڱ', '',
      '', '', '', '', '',

      'ڶ', 'ڶ', 'ڶ', 'ڶ', 'ڶ',
      'ⶫ', 'ⶫ', 'ⶫ', 'ⶫ', 'ⶫ',

      'ⶫ', '', '', '', '',
      '', 'ⶫ', 'ⶫ', 'ⶫ', 'ⶫ' );
  {* ÿ̥λʮ֧ŶӦ}

  SCnNaYinWuXingArray: array[0..29] of string =
    ( 'н', '¯л', 'ľ',
      '·', '', 'ɽͷ',

      'ˮ', 'ǽ', '',
      'ľ', 'Ȫˮ', '',

      '׻', 'ɰľ', 'ˮ',
      'ɳн', 'ɽ»', 'ƽľ',

      '', '𲭽', 'ƻ',
      'ˮ', '', '˽',

      'ɣľ', 'Ϫˮ', 'ɳ',
      'ϻ', 'ʯľ', 'ˮ' );
  {* Уһʮ֧Ӧ}

  SCnJiShenFangWeiArray: array[0..7] of string =
    ( '', '', '', '',
      '', '', '', '');
  {* λӦԵİ˸
   ϲ񡢲񡢹񣬹񻹰Ĭָ}

type
  ECnDateException = class(Exception);

  ECnTimeException = class(Exception);

  TCnCalendarType = (ctinvalid, ctJulian, ctGregorian);
  {* ͣ    Ƿ     ԣ    }

  TCnLunarMonthType = (lmtSmall, lmtBig);
  {* ũ      С£    }

  TCnEclipseType = (etNone, etSolar, etMoonFull, etMoonHalf);
  {* ʳͣ ޣ    ʳ   ȫʳ    ƫʳ }

  TCnMoonPhase = (mpNone, mpShuo, mpWang);
  {* ࣬     ޣ    ˷    }

  TCnSunRiseSetType = (stNormal, stAllwaysUp, stAllwaysDown, stError);
  {* ճͣ  ͨ    ղ䣬     ղ       ݴ }

function GetSunRiseSetTime(ADate: TDateTime; Longitude, Latitude: Extended;
  ZoneTime: Integer; var RiseTime, TransitTime, SetTime: TDateTime):
  TCnSunRiseSetType;
{* ճʱ
   ADate        - 
   Longitude    - 
   Latitude     - γ
   ZoneTime     - ʱ
   RiseTime     - ճʱ䣬ճ -1
   TransitTime  - ʱ䣬з -1
   SetTime      - ʱ䣬䷵ -1
   Result       - ؽ
}

function GetDateIsValid(AYear, AMonth, ADay: Integer): Boolean;
{* عǷϷ}

procedure ValidDate(AYear, AMonth, ADay: Integer);
{* жϹǷϷϷ׳쳣}

function GetLunarDateIsValid(ALunarYear, ALunarMonth, ALunarDay: Integer;
  IsLeapMonth: Boolean = False): Boolean;
{* ũǷϷ}

procedure ValidLunarDate(ALunarYear, ALunarMonth, ALunarDay: Integer;
  IsLeapMonth: Boolean = False);
{* жũǷϷϷ׳쳣}

function GetTimeIsValid(AHour, AMinitue, ASecond: Integer): Boolean;
{* ʱǷϷ}

procedure ValidTime(AHour, AMinitue, ASecond: Integer);
{* жʱǷϷϷ׳쳣}

function GetMonthDays(AYear, AMonth: Integer): Integer;
{* ȡĳ 1582  10 µ}

function GetLunarMonthDays(ALunarYear, ALunarMonth: Integer;
  IsLeapMonth: Boolean = False): Integer;
{* ȡũĳ}

function GetIsLeapYear(AYear: Integer): Boolean;
{* ĳǷ꣬Զж Julian  Gregorianֹ֧Ԫǰ}

function GetDayFromYearBegin(AYear, AMonth, ADay: Integer): Integer; overload;
{* ȡĳڵ 1582  10 µ }

function GetDayFromYearBegin(AYear, AMonth, ADay, AHour: Integer;
  AMinute: Integer = 0; ASecond: Integer = 0): Extended; overload;
{* ȡĳڵСʱ֡С 1582  10 µ }

function ExtractMonthDay(Days: Integer; AYear: Integer; out AMonth: Integer;
  out ADay: Integer): Boolean;
{* ӾºжǷ꣬ False ʾϷ}

function GetWeek(const AValue: TDateTime): Integer; overload;
{* ĳڼ0-6 Ӧ յ}

function GetWeek(AYear, AMonth, ADay: Integer): Integer; overload;
{* ĳڼ0-6 Ӧ յ}

function GetWeekFromNumber(const AValue: Integer): string;
{* ֻڶ, 0-6 Ӧ յ}

function GetYinYangFromNumber(const AValue: Integer): string;
{* ֻ, 0-1 Ӧ }

function Get5XingFromNumber(const AValue: Integer): string;
{* ֻ, 0-4 Ӧ ľˮ}

function Get12JianFromNumber(const AValue: Integer): string;
{* ֻʮ, 0-11}

function Get3FuFromNumber(const AValue: Integer): string;
{* ֻ, 0-2}

function GetTianGanFromNumber(const AValue: Integer): string;
{* ֻ, 0-9}

function GetDiZhiFromNumber(const AValue: Integer): string;
{* ֻõ֧, 0-11}

function GetGanZhiFromNumber(const AValue: Integer): string;
{* ֻɵ֧, 0-59}

function GetShengXiaoFromNumber(const AValue: Integer): string;
{* ֻФ, 0-11}

function GetJieQiFromNumber(const AValue: Integer): string;
{* ֻý, 0-23}

function GetXingZuoFromNumber(const AValue: Integer): string;
{* ֻ, 0-11}

function Get28XiuFromNumber(const AValue: Integer): string;
{* ֻöʮ, 0-27}

function Get28XiuLongFromNumber(const AValue: Integer): string;
{* ֻöʮ, 0-27}

function GetLunarMonthFromNumber(const AMonth: Integer; IsLeap: Boolean): string;
{* ֻũ, 1-12}

function GetLunarDayFromNumber(const ADay: Integer): string;
{* ֻũ, 1-30}

function GetYinYangFromGan(const Gan: Integer): Integer;
{* ɻ, 0-9 ת 0-1}

function GetYinYangFromZhi(const Zhi: Integer): Integer;
{* ӵ֧, 0-11 ת 0-1}

function CombineGanZhi(Gan, Zhi: Integer): Integer;
{* ɵ֧ϳɸ֧0-9 0-11 ת 0-59עʮţ֧}

function ExtractGanZhi(GanZhi: Integer; out Gan: Integer; out Zhi: Integer): Boolean;
{* ֳ֧ɵ֧0-59 ת 0-9 0-11 }

function Get5XingFromGan(const Gan: Integer): Integer;
{* ĳɵУ0-4 Ӧ ľˮ}

function Get5XingFromZhi(const Zhi: Integer): Integer;
{* ĳ֧У0-4 Ӧ ľˮ}

function Get5XingFromGanZhi(const GanZhi: Integer): Integer; overload;
{* ĳ֧У̣0-4 Ӧ ľˮ}

function Get5XingFromGanZhi(Gan, Zhi: Integer): Integer; overload;
{* ĳ֧У̣0-4 Ӧ ľˮ}

function Get5XingFromDay(AYear, AMonth, ADay: Integer): Integer;
{* ĳյУ̣0-4 Ӧ ľˮ}

function Get5XingLongFromGanZhi(const GanZhi: Integer): string; overload;
{* ĳ֧Уַ}

function Get5XingLongFromGanZhi(Gan, Zhi: Integer): string; overload;
{* ĳ֧Уַ}

function Get5XingLongFromDay(AYear, AMonth, ADay: Integer): string;
{* ĳյУַ}

function Get3HeFromZhi(const Zhi: Integer; out He1: Integer;
  out He2: Integer): Boolean;
{* ĳ֧}

function GetGanZhiFromHour(AYear, AMonth, ADay, AHour: Integer): Integer;
{* ĳʱɵ֧0-59 Ӧ ӵﺥ}

function GetGanZhiFromDay(AYear, AMonth, ADay: Integer): Integer; overload;
{* ĳյɵ֧0-59 Ӧ ӵﺥ}

function GetGanZhiFromDay(AYear, AMonth, ADay, AHour: Integer): Integer; overload;
{* ĳյɵ֧0-59 Ӧ ӵﺥСʱж 23 СʱǴ}

function GetGanZhiFromDay(AllDays: Integer): Integer; overload;
{* ĳյɵ֧0-59 Ӧ ӵﺥΪ빫ԪԪ 1  0 յľ}

function GetGanZhiFromMonth(AYear, AMonth, ADay: Integer): Integer; overload;
{* ĳµɵ֧ҪΪԽֽ磬ʱ0-59 Ӧ ӵﺥ}

function GetGanZhiFromMonth(AYear, AMonth, ADay, AHour: Integer): Integer; overload;
{* ĳµɵ֧ҪʱΪԽֽ硣0-59 Ӧ ӵﺥ}

function GetGanZhiFromYear(AYear: Integer): Integer; overload;
{* ĳ/ũɵ֧0-59 Ӧ ӵﺥ}

function GetGanZhiFromYear(AYear, AMonth, ADay: Integer): Integer; overload;
{* ݹջĳɵ֧Ϊֽ磬0-59 Ӧ ӵﺥ}

function GetGanZhiFromYear(AYear, AMonth, ADay, AHour: Integer): Integer; overload;
{* ݹջĳɵ֧Ϊֽ磬ȷСʱ0-59 Ӧ ӵﺥ}

function GetGanFromYear(AYear: Integer): Integer;
{* ĳ/ũɣ0-9 Ӧ ׵}

function GetZhiFromYear(AYear: Integer): Integer;
{* ĳ/ũĵ֧0-11 Ӧ ӵ}

function GetShengXiaoFromYear(AYear: Integer): Integer;
{* ĳ/ũФҲǵ֧0-11 Ӧ }

function GetXingZuoFromMonthDay(AMonth, ADay: Integer): Integer;
{* ĳյ0-11 Ӧ ˫}

function Get12JianFromDay(AYear, AMonth, ADay: Integer): Integer;
{* ĳյʮ0-11 Ӧ }

function Get28XiuFromDay(AYear, AMonth, ADay: Integer): Integer;
{* ĳյĶʮޣ0-27 Ӧ ǵ}

function GetTaiShenStringFromDay(AYear, AMonth, ADay: Integer): string; overload;
{* ĳյ̥λ0-59 ̥λü̥λַ}

function GetTaiShenStringFromDay(AYear, AMonth, ADay: Integer;
  out TaiShen1: string; out TaiShen2: string): Boolean; overload;
{* ĳյ̥λ0-59 ̥λ̥λַ}

function GetShiChenFromHour(AHour: Integer): Integer;
{* Сʱʱ̶Ӧʱ0-11 Ӧ}

function AdjustYearByJieQi(var AYear: Integer; AMonth: Integer;
  ADay: Integer; AHour: Integer): Boolean;
{Ϊ磬յĸ֧ȸļ}

function AdjustYearMonthByJieQi(var AYear: Integer; var AMonth: Integer;
  ADay: Integer; AHour: Integer): Boolean;
{ݽΪ磬յ·µĸ֧ȸļ}

function Get3YuanFromNumber(A3Yuan: Integer): string;
{* ֻԪƣ0-2}

function Get9XingFromNumber(A9Xing: Integer): string;
{* ֻþƣ0-8}

function Get3YuanFromYear(AYear, AMonth, ADay: Integer): Integer;
{* ȡԪ0-2}

function GetYun9XingFromYear(AYear, AMonth, ADay: Integer): Integer;
{* ȡ˾ǣ0-8 Ӧһ׵}

function Get9XingFromYear(AYear, AMonth, ADay: Integer): Integer;
{* ȡǣ0-8 Ӧһ׵}

function Get9XingFromMonth(AYear, AMonth, ADay: Integer): Integer;
{* ȡµ¾ǣ0-8 Ӧһ׵}

function Get9XingFromDay(AYear, AMonth, ADay: Integer): Integer;
{* ȡյվǣ0-8 Ӧһ׵}

function Get9XingFromHour(AYear, AMonth, ADay, AHour: Integer): Integer;
{* ȡʱʱǣ0-8 Ӧһ׵}

function GetJiShenFangWeiFromNumber(AFangWei: Integer): string;
{* ݼλֻüλ}

function GetCaiShenFangWeiFromDay(AYear, AMonth, ADay: Integer): Integer;
{* ùյĲλ0-7}

function GetXiShenFangWeiFromDay(AYear, AMonth, ADay: Integer): Integer;
{* ùյϲλ0-7}

function GetFuShenFangWeiFromDay(AYear, AMonth, ADay: Integer): Integer;
{* ùյĸλ0-7}

function GetGuiShenFangWeiFromDay(AYear, AMonth, ADay: Integer): Integer;
{* ùյĹλ0-7ĬΪ}

function GetYangGuiShenFangWeiFromDay(AYear, AMonth, ADay: Integer): Integer;
{* ùյλ0-7}

function GetYingShenFangWeiFromDay(AYear, AMonth, ADay: Integer): Integer;
{* ùյλ0-7}

function GetAllDays(Year, Month, Day: Integer): Integer;
{* þ๫ԪԪ 1  0 յľ}

function GetJieQiInAYear(AYear, N: Integer; out AMonth: Integer;
  out ADay: Integer; out AHour: Integer; out AMinitue: Integer): Boolean;
{* ĳĵ N Ľʱ֣0-23ӦС}

function GetJieQiFromDay(AYear, AMonth, ADay: Integer): Integer;
{* ùǱʲô0-23Ӧ󺮣򷵻 -1}

function GetJieQiTimeFromDay(AYear, AMonth, ADay: Integer; out AHour: Integer; out AMinitue: Integer): Integer;
{* ùǱʲôԼʱ̣0-23Ӧ󺮣򷵻 -1}

function GetShu9Day(AYear, AMonth, ADay: Integer; out JiuSeq: Integer; out JiuDay: Integer): Boolean;
{* ùеĵڼŵĵڼգ1~9,1~9 ӦһŵžţFalse Ϊ}

function Get3FuDay(AYear, AMonth, ADay: Integer; out FuSeq: Integer; out FuDay: Integer): Boolean;
{* ùеĵڼĵڼգ0~2,1~10 20ӦĩķգFalse Ϊڷ}

function GetRuMeiDay(AYear: Integer; out AMonth: Integer; out ADay: Integer): Boolean;
{* ĳе÷ڣ÷꼾ڵĿʼգâֺĵһ}

function GetChuMeiDay(AYear: Integer; out AMonth: Integer; out ADay: Integer): Boolean;
{* ĳеĳ÷ڣ÷꼾ڵĽգСĵһδ}

function GetLunarFromDay(AYear, AMonth, ADay: Integer;
  out LunarYear, LunarMonth, LunarDay: Integer; out IsLeapMonth: Boolean): Boolean;
{* ĳյũպǷ}

function GetLunarMonthDayFromDay(AYear, AMonth, ADay: Integer;
  out LunarMonth, LunarDay: Integer; out IsLeapMonth: Boolean): Boolean;
{* ĳյũպǷµϢݰȴ}

function GetLunarLeapMonth(AYear: Integer): Integer;
{* ĳũĵڼ£ 1~12 Ӧһµʮ£
   Ҳȥʮµʮһ£ 0 ʾ}

function GetDayFromLunar(ALunarYear, ALunarMonth, ALunarDay: Integer; IsLeapMonth:
  Boolean; out AYear, AMonth, ADay: Integer): Boolean;
{* ĳũգǷ£Ĺ}

function Compare2Day(Year1, Month1, Day1, Year2, Month2, Day2: Integer): Integer;
{* Ƚڣ1 > = < 2 ֱ𷵻 10-1}

function Compare2LunarDay(Year1, Month1, Day1: Integer; IsLeap1: Boolean;
  Year2, Month2, Day2: Integer; IsLeap2: Boolean): Integer;
{* ȽũڣϢ1 >=< 2 ֱ𷵻 10-1}

function GetYearSeperatedByLiChun(AYear, AMonth, ADay: Integer): Integer;
{* ݹգظָݣҲ˵պǽ꣬Ϊȥ}

function GetEquStandardDays(AYear, AMonth, ADay: Integer): Integer;
{* ĳյĵЧ׼}

function GetDayFromEquStandardDays(EquDays: Integer;
  out AYear, AMonth, ADay: Integer): Boolean;
{* õЧ׼Ӧĳ}

implementation

const
  RADS = 0.0174532925;

  SCnTaiXuanPeiShuArray: array[0..5] of Integer =
    (9, 8, 7, 6, 5, 4);
  {* ֧̫飬ڲ֧̫Ӷ}

  SCnLeapNumber: array[0..3648] of Integer = (
    0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 8, 
    9, 9, 9, 10, 10, 10, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, 15, 15, 
    15, 16, 16, 16, 17, 17, 17, 18, 18, 19, 19, 19, 20, 20, 20, 21, 21, 
    22, 22, 22, 23, 23, 23, 24, 24, 24, 25, 25, 26, 26, 26, 27, 27, 27, 
    28, 28, 29, 29, 29, 30, 30, 30, 31, 31, 31, 32, 32, 33, 33, 33, 34, 
    34, 34, 35, 35, 36, 36, 36, 37, 37, 37, 38, 38, 38, 39, 39, 40, 40, 
    40, 41, 41, 41, 42, 42, 43, 43, 43, 44, 44, 44, 45, 45, 46, 46, 46, 
    47, 47, 47, 48, 48, 48, 49, 49, 50, 50, 50, 51, 51, 52, 52, 52, 53, 
    53, 53, 54, 54, 54, 55, 55, 56, 56, 56, 56, 57, 57, 57, 58, 58, 59, 
    59, 59, 59, 60, 60, 61, 61, 62, 62, 63, 63, 64, 64, 64, 64, 65, 65, 
    65, 65, 66, 66, 66, 67, 67, 68, 68, 69, 69, 69, 69, 70, 71, 71, 71, 
    71, 71, 71, 72, 72, 73, 73, 74, 74, 74, 75, 75, 75, 75, 76, 76, 77, 
    77, 77, 77, 78, 79, 79, 79, 79, 79, 80, 80, 80, 81, 82, 82, 82, 83, 
    83, 84, 84, 84, 85, 85, 85, 86, 86, 86, 86, 87, 87, 87, 87, 88, 88, 
    89, 89, 90, 90, 91, 91, 91, 92, 92, 93, 93, 94, 94, 94, 94, 95, 95, 
    96, 96, 96, 96, 97, 97, 98, 98, 98, 99, 99, 100, 100, 100, 101, 101, 
    101, 102, 102, 102, 103, 103, 104, 104, 104, 105, 105, 105, 106, 106, 
    106, 107, 107, 107, 108, 108, 109, 109, 109, 110, 110, 111, 111, 111, 
    112, 112, 112, 113, 113, 114, 114, 114, 115, 115, 116, 116, 116, 117, 
    117, 117, 117, 118, 118, 119, 119, 119, 120, 120, 121, 121, 121, 122, 
    122, 122, 123, 123, 124, 124, 124, 124, 125, 125, 126, 126, 126, 126, 
    127, 127, 128, 128, 129, 129, 130, 130, 130, 130, 131, 131, 132, 132, 
    132, 133, 133, 133, 134, 134, 135, 135, 135, 136, 136, 136, 137, 137, 
    137, 138, 138, 139, 139, 139, 140, 140, 141, 141, 141, 142, 142, 142, 
    143, 143, 143, 144, 144, 144, 145, 145, 146, 146, 146, 147, 147, 147, 
    148, 148, 149, 149, 149, 150, 150, 150, 151, 151, 151, 152, 152, 153, 
    153, 153, 154, 154, 154, 155, 155, 156, 156, 156, 157, 157, 157, 158, 
    158, 158, 159, 159, 160, 160, 160, 161, 161, 161, 162, 162, 163, 163, 
    163, 164, 164, 164, 165, 165, 165, 166, 166, 167, 167, 167, 168, 168, 
    168, 169, 169, 170, 170, 170, 171, 171, 171, 172, 172, 172, 173, 173, 
    174, 174, 174, 175, 175, 175, 176, 176, 177, 177, 177, 178, 178, 178, 
    179, 179, 179, 180, 180, 181, 181, 181, 182, 182, 182, 183, 183, 184, 
    184, 184, 185, 185, 185, 186, 186, 186, 187, 187, 188, 188, 188, 189, 
    189, 189, 190, 190, 191, 191, 191, 192, 192, 192, 193, 193, 193, 194, 
    194, 195, 195, 195, 196, 196, 196, 197, 197, 198, 198, 198, 199, 199, 
    199, 200, 200, 200, 201, 201, 202, 202, 202, 203, 203, 203, 204, 204, 
    205, 205, 205, 206, 206, 206, 207, 207, 207, 208, 208, 209, 209, 209, 
    210, 210, 210, 211, 211, 212, 212, 212, 213, 213, 213, 214, 214, 214, 
    214, 214, 215, 215, 215, 216, 216, 216, 217, 217, 218, 218, 218, 219, 
    219, 219, 220, 220, 221, 221, 221, 222, 222, 222, 223, 223, 223, 224, 
    224, 225, 225, 225, 226, 226, 226, 227, 227, 228, 228, 228, 229, 229, 
    229, 230, 230, 230, 231, 231, 232, 232, 232, 233, 233, 233, 234, 234, 
    235, 235, 235, 236, 236, 236, 237, 237, 237, 238, 238, 239, 239, 239, 
    240, 240, 240, 241, 241, 242, 242, 242, 243, 243, 243, 244, 244, 244, 
    245, 245, 246, 246, 246, 247, 247, 247, 248, 248, 249, 249, 249, 250, 
    250, 250, 251, 251, 252, 252, 252, 253, 253, 253, 254, 254, 254, 255, 
    255, 256, 256, 256, 257, 257, 257, 258, 258, 259, 259, 259, 260, 260, 
    260, 261, 261, 261, 262, 262, 263, 263, 263, 264, 264, 264, 265, 265, 
    266, 266, 266, 267, 267, 267, 268, 268, 268, 269, 269, 270, 270, 270, 
    271, 271, 271, 272, 272, 273, 273, 273, 274, 274, 274, 275, 275, 276, 
    276, 276, 277, 277, 277, 278, 278, 278, 279, 279, 280, 280, 280, 281, 
    281, 281, 282, 282, 283, 283, 283, 284, 284, 284, 285, 285, 285, 286, 
    286, 287, 287, 287, 288, 288, 288, 289, 289, 290, 290, 290, 291, 291, 
    291, 292, 292, 292, 293, 293, 294, 294, 294, 295, 295, 295, 296, 296, 
    297, 297, 297, 298, 298, 298, 299, 299, 299, 300, 300, 301, 301, 301, 
    302, 302, 302, 303, 303, 304, 304, 304, 305, 305, 305, 306, 306, 306, 
    307, 307, 308, 308, 308, 309, 309, 309, 310, 310, 311, 311, 312, 312, 
    312, 313, 313, 313, 314, 314, 315, 315, 315, 316, 316, 316, 317, 317, 
    317, 318, 318, 319, 319, 319, 320, 320, 320, 321, 321, 322, 322, 322, 
    323, 323, 323, 324, 324, 325, 325, 325, 326, 326, 326, 327, 327, 327, 
    328, 328, 329, 329, 329, 330, 330, 330, 331, 331, 332, 332, 332, 333, 
    333, 333, 334, 334, 334, 335, 335, 336, 336, 336, 337, 337, 337, 338, 
    338, 339, 339, 339, 340, 340, 340, 341, 341, 341, 342, 342, 343, 343, 
    343, 344, 344, 344, 345, 345, 346, 346, 346, 347, 347, 347, 348, 348, 
    348, 349, 349, 350, 350, 350, 351, 351, 351, 352, 352, 353, 353, 353, 
    354, 354, 354, 355, 355, 355, 356, 356, 357, 357, 357, 358, 358, 358, 
    359, 359, 360, 360, 360, 361, 361, 361, 362, 362, 362, 363, 363, 364, 
    364, 364, 365, 365, 365, 366, 366, 367, 367, 367, 368, 368, 368, 369, 
    369, 369, 370, 370, 371, 371, 371, 372, 372, 372, 373, 373, 374, 374, 
    374, 375, 375, 375, 376, 376, 376, 377, 377, 378, 378, 378, 379, 379, 
    379, 380, 380, 381, 381, 381, 382, 382, 382, 383, 383, 383, 384, 384, 
    385, 385, 385, 386, 386, 386, 387, 387, 388, 388, 388, 389, 389, 389, 
    390, 390, 390, 391, 391, 392, 392, 392, 393, 393, 393, 394, 394, 395, 
    395, 395, 396, 396, 396, 397, 397, 397, 398, 398, 399, 399, 399, 400, 
    400, 400, 401, 401, 402, 402, 402, 403, 403, 403, 404, 404, 404, 405, 
    405, 406, 406, 406, 407, 407, 407, 408, 408, 409, 409, 409, 410, 410, 
    410, 411, 411, 411, 412, 412, 413, 413, 413, 414, 414, 414, 415, 415, 
    416, 416, 416, 417, 417, 417, 418, 418, 418, 419, 419, 420, 420, 420, 
    421, 421, 421, 422, 422, 423, 423, 423, 424, 424, 424, 425, 425, 425, 
    426, 426, 427, 427, 427, 428, 428, 428, 429, 429, 430, 430, 430, 431, 
    431, 431, 432, 432, 432, 433, 433, 434, 434, 434, 435, 435, 435, 436, 
    436, 437, 437, 437, 438, 438, 438, 439, 439, 439, 440, 440, 441, 441, 
    441, 442, 442, 442, 443, 443, 444, 444, 444, 445, 445, 445, 446, 446, 
    446, 447, 447, 448, 448, 448, 449, 449, 449, 450, 450, 451, 451, 451, 
    452, 452, 452, 453, 453, 453, 454, 454, 455, 455, 455, 456, 456, 456, 
    457, 457, 458, 458, 458, 459, 459, 459, 460, 460, 460, 461, 461, 462, 
    462, 462, 463, 463, 463, 464, 464, 465, 465, 465, 466, 466, 466, 467, 
    467, 467, 468, 468, 469, 469, 469, 470, 470, 470, 471, 471, 472, 472, 
    472, 473, 473, 473, 474, 474, 474, 475, 475, 475, 476, 476, 477, 477, 
    477, 478, 478, 478, 479, 479, 480, 480, 480, 481, 481, 481, 482, 482, 
    482, 483, 483, 484, 484, 484, 485, 485, 485, 486, 486, 487, 487, 487, 
    488, 488, 488, 489, 489, 489, 490, 490, 491, 491, 491, 492, 492, 492, 
    493, 493, 494, 494, 494, 495, 495, 495, 496, 496, 496, 497, 497, 498, 
    498, 498, 499, 499, 499, 500, 500, 501, 501, 501, 502, 502, 502, 503, 
    503, 503, 504, 504, 505, 505, 505, 506, 506, 506, 507, 507, 508, 508, 
    508, 509, 509, 509, 510, 510, 510, 511, 511, 512, 512, 512, 513, 513, 
    513, 514, 514, 515, 515, 515, 516, 516, 516, 517, 517, 517, 518, 518, 
    519, 519, 519, 520, 520, 520, 521, 521, 522, 522, 522, 523, 523, 523, 
    524, 524, 524, 525, 525, 526, 526, 526, 527, 527, 527, 528, 528, 529, 
    529, 529, 530, 530, 530, 531, 531, 531, 532, 532, 533, 533, 533, 534, 
    534, 534, 535, 535, 536, 536, 536, 537, 537, 537, 538, 538, 538, 539, 
    539, 540, 540, 540, 541, 541, 541, 542, 542, 543, 543, 543, 544, 544, 
    544, 545, 545, 545, 546, 546, 547, 547, 547, 548, 548, 548, 549, 549, 
    550, 550, 550, 551, 551, 551, 552, 552, 552, 553, 553, 554, 554, 554, 
    555, 555, 555, 556, 556, 557, 557, 557, 558, 558, 558, 559, 559, 559, 
    560, 560, 561, 561, 561, 562, 562, 562, 563, 563, 563, 564, 564, 565, 
    565, 565, 566, 566, 566, 567, 567, 568, 568, 568, 569, 569, 569, 570, 
    570, 570, 571, 571, 572, 572, 572, 573, 573, 573, 574, 574, 575, 575, 
    575, 576, 576, 576, 577, 577, 578, 578, 578, 579, 579, 579, 580, 580, 
    580, 581, 581, 582, 582, 582, 583, 583, 583, 584, 584, 584, 585, 585, 
    586, 586, 586, 587, 587, 587, 588, 588, 589, 589, 589, 590, 590, 590, 
    591, 591, 591, 592, 592, 593, 593, 593, 594, 594, 594, 595, 595, 596, 
    596, 596, 597, 597, 597, 598, 598, 598, 599, 599, 600, 600, 600, 601, 
    601, 601, 602, 602, 603, 603, 603, 604, 604, 604, 605, 605, 605, 606, 
    606, 607, 607, 607, 608, 608, 608, 609, 609, 610, 610, 610, 611, 611, 
    611, 612, 612, 612, 613, 613, 614, 614, 614, 615, 615, 615, 616, 616, 
    617, 617, 617, 618, 618, 618, 619, 619, 619, 620, 620, 621, 621, 621, 
    622, 622, 622, 623, 623, 624, 624, 624, 625, 625, 625, 626, 626, 626, 
    627, 627, 628, 628, 628, 629, 629, 629, 630, 630, 631, 631, 631, 632, 
    632, 632, 633, 633, 633, 634, 634, 635, 635, 635, 636, 636, 636, 637, 
    637, 638, 638, 638, 639, 639, 639, 640, 640, 640, 641, 641, 642, 642, 
    642, 643, 643, 643, 644, 644, 645, 645, 645, 646, 646, 646, 647, 647, 
    647, 648, 648, 649, 649, 649, 650, 650, 650, 651, 651, 652, 652, 652, 
    653, 653, 653, 654, 654, 654, 655, 655, 656, 656, 656, 657, 657, 657, 
    658, 658, 659, 659, 659, 660, 660, 660, 661, 661, 661, 662, 662, 663, 
    663, 663, 664, 664, 664, 665, 665, 666, 666, 666, 667, 667, 667, 668, 
    668, 668, 669, 669, 670, 670, 670, 671, 671, 671, 672, 672, 673, 673, 
    673, 674, 674, 674, 675, 675, 675, 676, 676, 677, 677, 677, 678, 678, 
    678, 679, 679, 680, 680, 680, 681, 681, 681, 682, 682, 682, 683, 683, 
    684, 684, 684, 685, 685, 685, 686, 686, 687, 687, 687, 688, 688, 688, 
    689, 689, 689, 690, 690, 691, 691, 691, 692, 692, 692, 693, 693, 694, 
    694, 694, 695, 695, 695, 696, 696, 696, 697, 697, 698, 698, 698, 699, 
    699, 699, 700, 700, 701, 701, 701, 702, 702, 702, 703, 703, 703, 704, 
    704, 705, 705, 705, 706, 706, 706, 707, 707, 707, 708, 708, 709, 709, 
    709, 710, 710, 710, 711, 711, 712, 712, 712, 713, 713, 713, 714, 714, 
    714, 715, 715, 716, 716, 716, 717, 717, 717, 718, 718, 719, 719, 719, 
    720, 720, 720, 721, 721, 721, 722, 722, 723, 723, 723, 724, 724, 724, 
    725, 725, 726, 726, 726, 727, 727, 727, 728, 728, 728, 729, 729, 730, 
    730, 730, 731, 731, 731, 732, 732, 733, 733, 733, 734, 734, 734, 735, 
    735, 736, 736, 736, 737, 737, 737, 738, 738, 738, 739, 739, 740, 740, 
    740, 741, 741, 741, 742, 742, 742, 743, 743, 744, 744, 744, 745, 745, 
    745, 746, 746, 747, 747, 747, 748, 748, 748, 749, 749, 749, 750, 750, 
    751, 751, 751, 752, 752, 752, 754, 754, 755, 755, 755, 756, 756, 756, 
    757, 757, 757, 758, 758, 759, 759, 759, 760, 760, 760, 761, 761, 762, 
    762, 762, 763, 763, 763, 764, 764, 764, 765, 765, 766, 766, 766, 767, 
    767, 767, 768, 768, 769, 769, 769, 770, 770, 770, 771, 771, 771, 772, 
    772, 773, 773, 773, 774, 774, 774, 775, 775, 776, 776, 776, 777, 777, 
    777, 778, 778, 778, 779, 779, 780, 780, 780, 781, 781, 781, 782, 782, 
    783, 783, 783, 784, 784, 784, 785, 785, 785, 786, 786, 787, 787, 787, 
    788, 788, 788, 789, 789, 790, 790, 790, 791, 791, 791, 792, 792, 792, 
    793, 793, 794, 794, 794, 795, 795, 795, 796, 796, 796, 797, 797, 798, 
    798, 798, 799, 799, 799, 800, 800, 801, 801, 801, 802, 802, 802, 803, 
    803, 804, 804, 804, 805, 805, 805, 806, 806, 806, 807, 807, 808, 808, 
    808, 809, 809, 809, 810, 810, 810, 811, 811, 812, 812, 812, 813, 813, 
    813, 814, 814, 815, 815, 815, 816, 816, 816, 817, 817, 818, 818, 818, 
    819, 819, 819, 820, 820, 820, 821, 821, 822, 822, 822, 823, 823, 823, 
    824, 824, 825, 825, 825, 826, 826, 826, 827, 827, 827, 828, 828, 829, 
    829, 829, 830, 830, 830, 831, 831, 832, 832, 832, 833, 833, 833, 834, 
    834, 834, 835, 835, 836, 836, 836, 837, 837, 837, 838, 838, 839, 839, 
    839, 840, 840, 840, 841, 841, 841, 842, 842, 843, 843, 843, 844, 844, 
    844, 845, 845, 845, 846, 846, 847, 847, 847, 848, 848, 848, 849, 849, 
    850, 850, 850, 851, 851, 851, 852, 852, 852, 853, 853, 854, 854, 854, 
    855, 855, 855, 856, 856, 857, 857, 857, 858, 858, 858, 859, 859, 859, 
    860, 860, 861, 861, 861, 862, 862, 862, 863, 863, 864, 864, 863, 864, 
    864, 864, 865, 865, 865, 866, 866, 867, 867, 867, 868, 868, 868, 869, 
    869, 870, 870, 870, 871, 871, 871, 872, 872, 873, 873, 873, 874, 874, 
    874, 875, 875, 875, 876, 876, 877, 877, 877, 878, 878, 878, 879, 879, 
    879, 880, 880, 881, 881, 881, 882, 882, 882, 883, 883, 884, 884, 884, 
    885, 885, 885, 886, 886, 886, 887, 887, 888, 888, 888, 889, 889, 889, 
    890, 890, 891, 891, 891, 892, 892, 892, 893, 893, 893, 894, 894, 895, 
    895, 895, 896, 896, 896, 897, 897, 898, 898, 898, 899, 899, 899, 900, 
    900, 900, 901, 901, 902, 902, 902, 903, 903, 903, 904, 904, 905, 905, 
    905, 906, 906, 906, 907, 907, 907, 908, 908, 909, 909, 909, 910, 910, 
    910, 911, 911, 912, 912, 912, 913, 913, 913, 914, 914, 914, 915, 915, 
    916, 916, 916, 917, 917, 917, 918, 918, 919, 919, 919, 920, 920, 920, 
    921, 921, 921, 922, 922, 923, 923, 923, 924, 924, 924, 925, 925, 925, 
    926, 926, 927, 927, 927, 928, 928, 928, 929, 929, 930, 930, 930, 931, 
    931, 931, 932, 932, 932, 933, 933, 934, 934, 934, 935, 935, 935, 936, 
    936, 937, 937, 937, 938, 938, 938, 939, 939, 939, 940, 940, 941, 941, 
    941, 942, 942, 942, 943, 943, 944, 944, 944, 945, 945, 945, 946, 946, 
    946, 947, 947, 948, 948, 948, 949, 949, 949, 950, 950, 951, 951, 951, 
    952, 952, 952, 953, 953, 953, 954, 954, 955, 955, 955, 956, 956, 956, 
    957, 957, 958, 958, 958, 959, 959, 959, 960, 960, 960, 961, 961, 962, 
    962, 962, 963, 963, 963, 964, 964, 965, 965, 965, 966, 966, 966, 967, 
    967, 967, 968, 968, 969, 969, 969, 970, 970, 970, 971, 971, 971, 972, 
    972, 973, 973, 973, 974, 974, 974, 975, 975, 976, 976, 976, 977, 977, 
    977, 978, 978, 978, 979, 979, 980, 980, 980, 981, 981, 981, 982, 982, 
    983, 983, 983, 984, 984, 984, 985, 985, 986, 986, 986, 987, 987, 987, 
    988, 988, 988, 989, 989, 990, 990, 990, 991, 991, 991, 992, 992, 993, 
    993, 993, 994, 994, 994, 995, 995, 995, 996, 996, 997, 997, 997, 998, 
    998, 998, 999, 999, 1000, 1000, 1000, 1001, 1001, 1001, 1002, 1002, 
    1002, 1003, 1003, 1004, 1004, 1004, 1005, 1005, 1005, 1006, 1006, 
    1006, 1007, 1007, 1008, 1008, 1008, 1009, 1009, 1009, 1010, 1010, 
    1011, 1011, 1011, 1012, 1012, 1012, 1013, 1013, 1013, 1014, 1014, 
    1015, 1015, 1015, 1016, 1016, 1016, 1017, 1017, 1018, 1018, 1018, 
    1019, 1019, 1019, 1020, 1020, 1020, 1021, 1021, 1022, 1022, 1022, 
    1023, 1023, 1023, 1024, 1024, 1025, 1025, 1025, 1026, 1026, 1026, 
    1027, 1027, 1027, 1028, 1028, 1029, 1029, 1029, 1030, 1030, 1030, 
    1031, 1031, 1032, 1032, 1032, 1033, 1033, 1033, 1034, 1034, 1034, 
    1035, 1035, 1036, 1036, 1036, 1037, 1037, 1037, 1038, 1038, 1039, 
    1039, 1039, 1040, 1040, 1040, 1041, 1041, 1042, 1042, 1042, 1043, 
    1043, 1043, 1044, 1044, 1044, 1045, 1045, 1046, 1046, 1046, 1047, 
    1047, 1047, 1048, 1048, 1048, 1049, 1049, 1050, 1050, 1050, 1051, 
    1051, 1051, 1052, 1052, 1053, 1053, 1053, 1054, 1054, 1054, 1055, 
    1055, 1055, 1056, 1056, 1057, 1057, 1057, 1058, 1058, 1058, 1059, 
    1059, 1060, 1060, 1060, 1061, 1061, 1061, 1062, 1062, 1062, 1063, 
    1063, 1064, 1064, 1064, 1065, 1065, 1065, 1066, 1066, 1067, 1067, 
    1067, 1068, 1068, 1068, 1069, 1069, 1069, 1070, 1070, 1071, 1071, 
    1071, 1072, 1072, 1072, 1073, 1073, 1074, 1074, 1074, 1075, 1075, 
    1075, 1076, 1076, 1076, 1077, 1077, 1078, 1078, 1078, 1079, 1079, 
    1079, 1080, 1080, 1081, 1081, 1081, 1082, 1082, 1082, 1083, 1083, 
    1083, 1084, 1084,
    1085, 1085, 1085, 1086, 1086, 1086, 1087, 1087, 1088, 1088, 1088,
    1089, 1089, 1089, 1090, 1090, 1090, 1091, 1091, 1092, 1092, 1092,
    1093, 1093, 1093, 1094, 1094, 1095, 1095, 1095, 1096, 1096, 1096,
    1097, 1097, 1097, 1098, 1098, 1099, 1099, 1099, 1100, 1100, 1100,
    1101, 1101, 1102, 1102, 1102, 1103, 1103, 1103, 1104, 1104, 1104,
    1105, 1105, 1106, 1106, 1106, 1107, 1107, 1107, 1108, 1108, 1109,
    1109, 1109, 1110, 1110, 1110, 1111, 1111, 1111, 1112, 1112, 1113,
    1113, 1113, 1114, 1114, 1114, 1115, 1115, 1115, 1116, 1116, 1117,
    1117, 1117, 1118, 1118, 1118, 1119, 1119, 1120, 1120, 1120, 1121,
    1121, 1121, 1122, 1122, 1123, 1123, 1123, 1124, 1124, 1124, 1125,
    1125, 1125, 1126, 1126, 1127, 1127, 1127, 1128, 1128, 1128, 1129,
    1129, 1130, 1130, 1130, 1131, 1131, 1131, 1132, 1132, 1132, 1133,
    1133, 1134, 1134, 1134, 1135, 1135, 1135, 1136, 1136, 1137, 1137,
    1137, 1138, 1138, 1138, 1139, 1139, 1139, 1140, 1140, 1141, 1141,
    1141, 1142, 1142, 1142, 1143, 1143, 1143, 1144, 1144, 1145, 1145,
    1145, 1146, 1146, 1146, 1147, 1147, 1148, 1148, 1148, 1149, 1149,
    1149, 1150, 1150, 1150, 1151, 1151, 1152, 1152, 1152, 1153, 1153,
    1153, 1154, 1154, 1155, 1155, 1155, 1156, 1156, 1156, 1157, 1157,
    1157, 1158, 1158, 1159, 1159, 1159, 1160, 1160, 1160, 1161, 1161,
    1162, 1162, 1162, 1163, 1163, 1163, 1164, 1164, 1165, 1165, 1165,
    1166, 1166, 1166, 1167, 1167, 1167, 1168, 1168, 1169, 1169, 1169,
    1170, 1170, 1170, 1171, 1171, 1171, 1172, 1172, 1173, 1173, 1173,
    1174, 1174, 1174, 1175, 1175, 1176, 1176, 1176, 1177, 1177, 1177,
    1178, 1178, 1178, 1179, 1179, 1180, 1180, 1180, 1181, 1181, 1181,
    1182, 1182, 1183, 1183, 1183, 1184, 1184, 1184, 1185, 1185, 1185,
    1186, 1186, 1187, 1187, 1187, 1188, 1188, 1188, 1189, 1189, 1190,
    1190, 1190, 1191, 1191, 1191, 1192, 1192, 1192, 1193, 1193, 1194,
    1194, 1194, 1195, 1195, 1195, 1196, 1196, 1197, 1197, 1197, 1198,
    1198, 1198, 1199, 1199, 1199, 1200, 1200, 1201, 1201, 1201, 1202,
    1202, 1202, 1203, 1203, 1204, 1204, 1204, 1205, 1205, 1205, 1206,
    1206, 1206, 1207, 1207, 1208, 1208, 1208, 1209, 1209, 1209, 1210,
    1210, 1211, 1211, 1211, 1212, 1212, 1212, 1213, 1213, 1213, 1214,
    1214, 1215, 1215, 1215, 1216, 1216, 1216, 1217, 1217, 1218, 1218,
    1218, 1219, 1219, 1219, 1220, 1220, 1220, 1221, 1221, 1222, 1222,
    1222, 1223, 1223, 1223, 1224, 1224, 1225, 1225, 1225, 1226, 1226,
    1226, 1227, 1227, 1227, 1228, 1228, 1229, 1229, 1229, 1230, 1230,
    1230, 1231, 1231, 1232, 1232, 1232, 1233, 1233, 1233, 1234, 1234,
    1234, 1235, 1235, 1236, 1236, 1236, 1237, 1237, 1237, 1238, 1238,
    1238, 1239, 1239, 1240, 1240, 1240, 1241, 1241, 1241, 1242, 1242,
    1243, 1243, 1243, 1244, 1244, 1244, 1245, 1245, 1245, 1246, 1246,
    1247, 1247, 1247, 1248, 1248, 1248, 1249, 1249, 1250, 1250, 1250,
    1251, 1251, 1251, 1252, 1252, 1253, 1253, 1253, 1254, 1254, 1254,
    1255, 1255, 1255, 1256, 1256, 1257, 1257, 1257, 1258, 1258, 1258,
    1259, 1259, 1260, 1260, 1260, 1261, 1261, 1261, 1262, 1262, 1262,
    1263, 1263, 1264, 1264, 1264, 1265, 1265, 1265, 1266, 1266, 1267,
    1267, 1267, 1268, 1268, 1268, 1269, 1269, 1269, 1270, 1270, 1271,
    1271, 1271, 1272, 1272, 1272, 1273, 1273, 1274, 1274, 1274, 1275,
    1275, 1275, 1276, 1276, 1276, 1277, 1277, 1278, 1278, 1278, 1279,
    1279, 1279, 1280, 1280, 1280, 1281, 1281, 1282, 1282, 1282, 1283,
    1283, 1283, 1284, 1284, 1285, 1285, 1285, 1286, 1286, 1286, 1287,
    1287, 1287, 1288, 1288, 1289, 1289, 1289, 1290, 1290, 1290, 1291,
    1291, 1292, 1292, 1292, 1293, 1293, 1293, 1294, 1294, 1294, 1295,
    1295, 1296, 1296, 1296, 1297, 1297, 1297, 1298, 1298, 1299, 1299,
    1299, 1300, 1300, 1300, 1301, 1301, 1301, 1302, 1302, 1303, 1303,
    1303, 1304, 1304, 1304, 1305, 1305, 1306, 1306, 1306, 1307, 1307,
    1307, 1308, 1308, 1308, 1309, 1309, 1310, 1310, 1310, 1311, 1311,
    1311, 1312, 1312, 1313, 1313, 1313, 1314, 1314, 1314, 1315, 1315,
    1316, 1316, 1316, 1317, 1317, 1317, 1318, 1318, 1318, 1319, 1319,
    1320, 1320, 1320, 1321, 1321, 1321, 1322, 1322, 1322, 1323, 1323,
    1324, 1324, 1324, 1325, 1325, 1325, 1326, 1326, 1327, 1327, 1327,
    1328, 1328, 1328, 1329, 1329, 1329, 1330, 1330, 1331, 1331, 1331,
    1332, 1332, 1332, 1333, 1333, 1334, 1334, 1334, 1335, 1335, 1335,
    1336, 1336, 1336, 1337, 1337, 1338, 1338, 1338, 1339, 1339, 1339,
    1340, 1340, 1341, 1341, 1341, 1342, 1342
  );
  { * ԹԪǰ 850 꿪ʼũ-849~2100 ֲй࣬2100 ޽ʼ㲹}

  SCnLeapMonth =
    '0c0080050010a0070030c0080050010a0070030c0080050020a0070030c0080050020a' +
    '0070030c0090050020a0070030c0090050020a0060030c0060030c00900600c0c0060c' +
    '00c00c00c0c000600c0c0006090303030006000c00c060c0006c00000c0c0c00600030' +
    '30006c00009009c0090c00c009000300030906030030c0c00060c00090c0060600c003' +
    '0060c00c003006009060030c0060060c0090900c00090c0090c00c0060300060600030' +
    '30c0c00030c0060030c0090060030c0090300c0080050020a0060030c0080050020b00' +
    '70030c0090050010a0070030b0090060020a0070040c0080050020a0060030c0080050' +
    '020b0070030c0090050010a0070030b0090060020a0070040c0080050020a0060030c0' +
    '080050020b0070030c0090050000c00900909009009090090090090900900909009009' +
    '0090900900909009009009090090090900900900909009009090090090900900900909' +
    '00900909009009009090090090900900900909009009090060030c0090050010a00700' +
    '30b008005001090070040c0080050020a0060030c0090040010a0060030c0090050010' +
    'a0070030b0080050010a008005001090050020a0060030c0080040010a0060030c0090' +
    '050010a0070030b0080050010a0070030b008005001090070040c0080050020a006003' +
    '0c0080040010a0060030c0090050010a0070030b008005001090070040c0080050020a' +
    '0060030c0080040010a0060030c0090050010a0060030c0090050010a0070030b00800' +
    '5001090070040c0080050020a0060030c0080040010a0070030b0080050010a0070040' +
    'c0080050020a0060030c0080040010a0070030c0090050010a0070030b0080050020a0' +
    '060030c0080040010a0060030c0090050050020a0060030c0090050010b0070030c009' +
    '0050010a0070040c0080040020a0060030c0080050020a0060030c0090050010a00700' +
    '30b0080040020a0060040c0090050020b0070030c00a0050010a0070030b0090050020' +
    'a0070030c0080040020a0060030c0090050010a0070030c0090050030b007005001090' +
    '050020a007004001090060020c0070050c0090060030b0080040020a0060030b008004' +
    '0010a0060030b0080050010a0050040c0080050010a0060030c0080050010b0070030c' +
    '007005001090070030b0070040020a0060030c0080040020a0070030b0090050010a00' +
    '60040c0080050020a0060040c0080050010b0070030c007005001090070030c0080050' +
    '020a0070030c0090050020a0070030c0090050020a0060040c0090050020a0060040c0' +
    '090050010b0070030c0080050030b007004001090060020c008004002090060020a008' +
    '004001090050030b0080040020a0060040b0080040c00a0060020b0070050010900600' +
    '30b0070050020a0060020c008004002090070030c008005002090070040c0080040020' +
    'a0060040b0090050010a0060030b0080050020a0060040c0080050010b007003001080' +
    '05001090070030c0080050020a007003001090050030a0070030b0090050020a006004' +
    '0c0090050030b0070040c0090050010c0070040c0080060020b00700400a090060020b' +
    '007003002090060020a005004001090050030b007004001090050040c0080040c00a00' +
    '60020c007005001090060030b0070050020a0060020c008004002090060030b0080040' +
    '02090060030b0080040020a0060040b0080040010b0060030b0070050010a006004002' +
    '0700500308006004003070050030700600400307005003080060040030700500409006' +
    '0040030700500409006005002070050030a00600500307005004002060040020600500' +
    '30020600400307005004090060040030700500408007005003080050040a0060050030' +
    '7005004002060050030800500400206005002070050040020600500307006004002070' +
    '050030800600400307005004080060040a006005003080050040020700500409006004' +
    '002060050030b006005002070050030800600400307005004080060040030700500408' +
    '0060040020' +
    '700500409006004003070050040b006005002070050040b006005003070060040a0060' +
    '0500307006004002060050030700600409006004003070050040900700500308005004' +
    '0b00600500307006005001070050030800600400206005003070060040020600500307' +
    '0060040a00700500308006004003070050040800600500107005004080060050020700' +
    '50040a0060040020600500308006005002070050030800600400307005004080070050' +
    '030800500408006005003070050040a006005003070050040a00600500207005004001' +
    '0600500307006004001070050030700600408007005004070060040900600400307005'+
    '0040a007005003080060040b0060050030800600500107005003080060040020700500' +
    '3070060040030700500307006004003070050030800600400307005004090060050b00' +
    '7005004090060050020700600408006005003070060030800600500307006003080060'
    ;
  { * ԹԪǰ 850 꿪ʼũϢ -849~2100ֲй࣬2100 ޽ʼ㲹}

var
  SCnGanZhiArray: array[0..59] of string;
  {* ַ֧Sexagenary Cycle}
  
//==============================================================================
// ճ
//==============================================================================

function HoursMin(Hours: Extended): TDateTime;
begin
  Result := Hours / 24;
end;

function IntPart(X: Extended): Extended;
begin
  if X > 0 then
    Result := Floor(X)
  else
    Result := Ceil(X);
end;

function Range360(X: Extended): Extended;
var
  A: Extended;
begin
  A := X / 360;
  Result := 360 * (A - IntPart(A));
  if Result < 0 then
    Result := Result + 360;
end;

// Լ
function Mjd(Year, Month, Day, Hour: Integer): Extended;
var
  A, B: Extended;
begin
  if Month <= 2 then
  begin
    Month := Month + 12;
    Year := Year - 1;
  end;

  A := 10000.0 * Year + 100.0 * Month + Day;
  if A <= 15821004.1 then
  begin
    B := -2 * Floor((Year + 4716) / 4) - 1179;
  end
  else
  begin
    B := Floor(Year / 400) - Floor(Year / 100) + Floor(Year / 4);
  end;

  A := 365.0 * Year - 679004.0;
  Result := A + B + Floor(30.6001 * (Month + 1)) + Day + Hour / 24.0;
end;

procedure Quad(ym, yz, yp: Extended; var nz, z1, z2, xe, ye: Extended);
var
  A, B, c, dis, dx: Extended;
begin
  nz := 0;
  A := 0.5 * (ym + yp) - yz;
  B := 0.5 * (yp - ym);
  c := yz;
  xe := -B / (2 * A);
  ye := (A * xe + B) * xe + c;
  dis := B * B - 4.0 * A * c;
  if dis > 0 then
  begin
    dx := 0.5 * Sqrt(dis) / Abs(A);
    z1 := xe - dx;
    z2 := xe + dx;
    if Abs(z1) <= 1.0 then
      nz := nz + 1;
    if Abs(z2) <= 1.0 then
      nz := nz + 1;
    if z1 < -1.0 then
      z1 := z2;
  end;
end;

function Lmst(AMjd, Glong: Extended): Extended;
var
  Lst, T, D: Extended;
begin
  D := AMjd - 51544.5;
  T := D / 36525.0;
  Lst := Range360(280.46061837 + 360.98564736629 * D + 0.000387933 * T * T -
    T * T * T / 38710000);
  Result := Lst / 15.0 + Glong / 15;
end;

procedure MiniSun(T: Extended; var ADec, Ra: Extended);
const
  P2 = 6.283185307;
  CosEps = 0.91748;
  SinEps = 0.39778;
var
  L, M, DL, SL, X, Y, Z, RHO: Extended;
begin
  M := P2 * Frac(0.993133 + 99.997361 * T);
  DL := 6893.0 * Sin(M) + 72.0 * Sin(2 * M);
  L := P2 * Frac(0.7859453 + M / P2 + (6191.2 * T + DL) / 1296000);
  SL := Sin(L);
  X := Cos(L);
  Y := CosEps * SL;
  Z := SinEps * SL;
  RHO := Sqrt(1 - Z * Z);
  ADec := (360.0 / P2) * ArcTan2(Z, RHO);
  Ra := (48.0 / P2) * ArcTan2(Y, (X + RHO));
  if Ra < 0 then
    Ra := Ra + 24;
end;

function SinAlt(Mjd0, hour, Glong, Cglat, Sglat: Extended): Extended;
var
  AMjd, T, Ra, ADec, Tau, Salt: Extended;
begin
  AMjd := Mjd0 + hour / 24.0;
  T := (AMjd - 51544.5) / 36525.0;
  MiniSun(T, ADec, Ra);
  Tau := 15.0 * (Lmst(AMjd, Glong) - Ra);
  Salt := Sglat * Sin(RADS * ADec) + Cglat * Cos(RADS * ADec) * Cos(RADS * Tau);
  Result := Salt;
end;

function GetZTTime(Mjd, Tz, Glong: Extended): Extended;
var
  sinho, date, ym, yz, utrise, utset: Extended;
  yp, ye, nz, hour, z1, z2, xe: Extended;
begin
  sinho := Sin(RADS * -0.833);
  date := Mjd - Tz / 24;
  hour := 1.0;
  ym := SinAlt(date, hour - 1.0, Glong, 1, 0) - sinho;

  utrise := 0;
  utset := 0;
  while hour < 25 do
  begin
    yz := SinAlt(date, hour, Glong, 1, 0) - sinho;
    yp := SinAlt(date, hour + 1.0, Glong, 1, 0) - sinho;
    Quad(ym, yz, yp, nz, z1, z2, xe, ye);

    if nz = 1 then
    begin
      if ym < 0.0 then
        utrise := hour + z1
      else
        utset := hour + z1;
    end;

    if nz = 2 then
    begin
      if ye < 0.0 then
      begin
        utrise := hour + z2;
        utset := hour + z1;
      end
      else
      begin
        utrise := hour + z1;
        utset := hour + z2;
      end;
    end;
    ym := yp;
    hour := hour + 2.0;
  end;

  Result := (utrise + utset) / 2;
  if Result < utrise then
    Result := Result + 12;
  if Result > 24 then
    Result := Result - 24;
end;

function DoSunCalc(AMjd: Extended; Glong, Glat: Extended;
  Tz: Integer; var RiseTime, TransitTime, SetTime: TDateTime):
  TCnSunRiseSetType;
var
  sinho, sglat, cglat: Extended;
  yz, yp, ym, nz, z1, z2, xe, ye: Extended;
  utrise, utset, zt: Extended;
  date, hour: Extended;
  rise, sett, above: Boolean;
begin
  sinho := Sin(RADS * -0.833);
  sglat := Sin(RADS * Glat);
  cglat := Cos(RADS * Glat);
  Date := AMjd - Tz / 24;

  rise := False;
  sett := False;
  above := False;
  hour := 1.0;
  utrise := 0;
  utset := 0;
  ym := SinAlt(date, hour - 1.0, Glong, cglat, sglat) - sinho;
  if ym > 0.0 then
    above := True;

  while (hour < 25) and (not sett or not rise) do
  begin
    yz := SinAlt(date, hour, Glong, cglat, sglat) - sinho;
    yp := SinAlt(date, hour + 1.0, Glong, cglat, sglat) - sinho;
    Quad(ym, yz, yp, nz, z1, z2, xe, ye);
    if nz = 1 then
    begin
      if ym < 0.0 then
      begin
        utrise := hour + z1;
        rise := True;
      end
      else
      begin
        utset := hour + z1;
        sett := True;
      end;
    end;

    if nz = 2 then
    begin
      if ye < 0.0 then
      begin
        utrise := hour + z2;
        utset := hour + z1;
      end
      else
      begin
        utrise := hour + z1;
        utset := hour + z2;
      end;
    end;

    ym := yp;
    hour := hour + 2.0;
  end;

  RiseTime := -1;
  TransitTime := -1;
  SetTime := -1;
  if rise or sett then
  begin
    if rise then
      RiseTime := HoursMin(utrise);

    zt := GetZTTime(AMjd, Tz, Glong);
    TransitTime := HoursMin(zt);

    if sett then
      SetTime := HoursMin(utset);
      
    Result := stNormal;
  end
  else if above then
  begin
    zt := GetZTTime(AMjd, Tz, Glong);
    TransitTime := HoursMin(zt);
    
    Result := stAllwaysUp;
  end
  else
  begin
    Result := stAllwaysDown;
  end;
end;

// ճʱ
function GetSunRiseSetTime(ADate: TDateTime; Longitude, Latitude: Extended;
  ZoneTime: Integer; var RiseTime, TransitTime, SetTime: TDateTime):
  TCnSunRiseSetType;
var
  Year, Month, Day: Word;
  Mg: Extended;
begin
  try
    DecodeDate(ADate, Year, Month, Day);
    Mg := Mjd(Year, Month, Day, 0);
    Result := DoSunCalc(Mg, Longitude, Latitude, ZoneTime, RiseTime, TransitTime, SetTime);
  except
    Result := stError;
  end;          
end;

//==============================================================================
// ճ
//==============================================================================

// ɱصĸַ֧бΪֹ ;)
procedure GenerateGanZhiArray;
var
  I: Integer;
begin
  for I := 0 to 59 do
    SCnGanZhiArray[I] := SCnTianGanArray[I mod 10] + SCnDiZhiArray[I mod 12];
end;

// ֻ, 0-4 Ӧ ľˮ
function Get5XingFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if AValue in [0..4] then
    Result := SCn5XingArray[AValue];
end;

// ֻʮ, 0-11
function Get12JianFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if AValue in [0..11] then
    Result := SCn12JianArray[AValue];
end;

// ֻ, 0-2
function Get3FuFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if AValue in [0..2] then
    Result := SCn3FuArray[AValue];
end;

// ֻ, 0-1
function GetYinYangFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if AValue in [0..1] then
    Result := SCnYinYangArray[AValue];
end;  

// ֻ,0-9
function GetTianGanFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if (AValue >= 0)  and (AValue < 10) then
    Result := SCnTianGanArray[AValue];
end;

// ֻõ֧, 0-11
function GetDiZhiFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if (AValue >= 0)  and (AValue < 12) then
    Result := SCnDiZhiArray[AValue];
end;

// ֻɵ֧, 0-59
function GetGanZhiFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if (AValue >= 0)  and (AValue < 60) then
    Result := SCnGanZhiArray[AValue];
end;

// ֻФ, 0-11
function GetShengXiaoFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if (AValue >= 0)  and (AValue < 12) then
    Result := SCnShengXiaoArray[AValue];
end;

// ֻý, 0-23
function GetJieQiFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if (AValue >= 0)  and (AValue < 24) then
    Result := SCnJieQiArray[AValue];
end;

// ֻ, 0-11
function GetXingZuoFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if (AValue >= 0)  and (AValue < 12) then
    Result := SCnXingZuoArray[AValue];
end;

// ֻöʮ, 0-27
function Get28XiuFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if (AValue >= 0)  and (AValue < 28) then
    Result := SCn28XiuArray[AValue];
end;

// ֻöʮ, 0-27
function Get28XiuLongFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if (AValue >= 0)  and (AValue < 28) then
    Result := SCn28XiuLongArray[AValue];
end;

// ֻũ, 1-12
function GetLunarMonthFromNumber(const AMonth: Integer; IsLeap: Boolean): string;
begin
  Result := '';
  if (AMonth >= 1) and (AMonth <= 12) then
  begin
    Result := SCnLunarMonthNameArray[AMonth - 1] + SCnLunarMonthName;
    if IsLeap then
      Result := SCnLunarMonthLeapName + Result;
  end;  
end;

// ֻũ, 1-30
function GetLunarDayFromNumber(const ADay: Integer): string;
var
  D1, D2: Integer;
begin
  Result := '';
  if ADay in [1..30] then
  begin
    D2 := ADay div 10; // ʮλ
    D1 := ADay mod 10; // λ
    // 
    if D1 = 0 then
    begin
      case D2 of
      1:
        begin
          D2 := 0;
          D1 := 10; // ʮ
        end;
      2, 3:
        begin
          Inc(D2, 2);
          D1 := 10; // һ㲻إئǶʮʮ
        end;
      end;
    end;
    Result := SCnLunarNumber2Array[D2] + SCnLunarNumber1Array[D1 - 1];
  end;  
end;

// ɻ, 0-9 ת 0-1
function GetYinYangFromGan(const Gan: Integer): Integer;
begin
  Result := -1;
  if Gan in [0..9] then // Դ
    Result := 1 - (Gan mod 2);
end;

// ӵ֧, 0-11 ת 0-1
function GetYinYangFromZhi(const Zhi: Integer): Integer;
begin
  Result := -1;
  if Zhi in [0..11] then // îԴ
    Result := 1 - (Zhi mod 2);
end;  

// ɵ֧ϳɸ֧0-9 0-11 ת 0-59עʮţ֧
function CombineGanZhi(Gan, Zhi: Integer): Integer;
var
  I: Integer;
begin
  Result := -1;
  if (Gan in [0..9]) and (Zhi in [0..11]) then
  begin
    for I := 0 to 6 do
    begin
      if (I * 10 + Gan) mod 12 = Zhi then
      begin
        Result := I * 10 + Gan;
        Exit;
      end;
    end;
  end;
end;

// ֳ֧ɵ֧0-59 ת 0-9 0-11
function ExtractGanZhi(GanZhi: Integer; out Gan: Integer; out Zhi: Integer): Boolean;
begin
  if GanZhi in [0..59] then
  begin
    Result := True;
    Gan := GanZhi mod 10;
    Zhi := GanZhi mod 12;
  end
  else
  begin
    Result := False;
    Gan := -1;
    Zhi := -1;
  end;
end;

// ĳɵУ0-4 Ӧ ľˮ
function Get5XingFromGan(const Gan: Integer): Integer;
begin
  case Gan div 2 of
    0: Result := 1; // ľ
    1: Result := 3; // 
    2: Result := 4; // 켺
    3: Result := 0; // 
    4: Result := 2; // ɹˮ
  else
    Result := -1;
  end;
end;  

// ĳ֧У0-4 Ӧ ľˮ
function Get5XingFromZhi(const Zhi: Integer): Integer;
begin
  case Zhi of
    8, 9: Result := 0;
    2, 3: Result := 1;
    0,11: Result := 2;
    5, 6: Result := 3;
    1, 4, 7, 10: Result := 4;
  else
    Result := -1;
  end;
end;  

// ɻֵ̫ڲʹ
function GetTaiXuanPeiShuFromGan(const Gan: Integer): Integer;
begin
  Result := -1;
  if Gan in [0..9] then
    Result := SCnTaiXuanPeiShuArray[Gan mod 5];
end;

// ӵֵ֧̫ڲʹ
function GetTaiXuanPeiShuFromZhi(const Zhi: Integer): Integer;
begin
  Result := -1;
  if Zhi in [0..11] then
    Result := SCnTaiXuanPeiShuArray[Zhi mod 6];
end;

// ĳ֧У̣0-4 Ӧ ľˮ
function Get5XingFromGanZhi(const GanZhi: Integer): Integer; overload;
var
  Gan, Zhi: Integer;
begin
  ExtractGanZhi(GanZhi, Gan, Zhi);
  Result := Get5XingFromGanZhi(Gan, Zhi);
end;

// ĳ֧У̣0-4 Ӧ ľˮ
function Get5XingFromGanZhi(Gan, Zhi: Integer): Integer; overload;
var
  TaiXuan1, TaiXuan2, TaiXuan3, TaiXuan4: Integer; // ĸ̫
begin
  // ˴֧ͬΪͬΪżԷǷ
  Result := -1;
  if (Gan + Zhi) mod 2 = 0 then
  begin
    TaiXuan1 := GetTaiXuanPeiShuFromGan(Gan);
    TaiXuan2 := GetTaiXuanPeiShuFromZhi(Zhi);
    if Gan mod 2 = 0 then
    begin
      // żΪԣȡ
      Inc(Gan);
      Inc(Zhi);
    end
    else // 棬Ϊԣȡ
    begin
      Dec(Gan);
      Dec(Zhi);
    end;
    TaiXuan3 := GetTaiXuanPeiShuFromGan(Gan);
    TaiXuan4 := GetTaiXuanPeiShuFromZhi(Zhi);

    Result := (TaiXuan1 + TaiXuan2 + TaiXuan3 + TaiXuan4) mod 5;
    case Result of // ӳ䣬һΪ𣬶ΪΪľΪ壨0Ϊˮ
      0: Result := 2;
      1: Result := 3;
      2: Result := 4;
      3: Result := 1;
      4: Result := 0;
    end;
  end;  
end;

// ĳյУ̣0-4 Ӧ ľˮ
function Get5XingFromDay(AYear, AMonth, ADay: Integer): Integer;
var
  Gan, Zhi: Integer;
begin
  ExtractGanZhi(GetGanZhiFromDay(AYear, AMonth, ADay), Gan, Zhi);
  Result := Get5XingFromGanZhi(Gan, Zhi);
end;

// ĳ֧Уַ
function Get5XingLongFromGanZhi(const GanZhi: Integer): string; overload;
var
  I: Integer;
begin
  I := GanZhi div 2;
  if I in [0..29] then
    Result := SCnNaYinWuXingArray[I]
  else
    Result := '';
end;

// ĳ֧Уַ
function Get5XingLongFromGanZhi(Gan, Zhi: Integer): string; overload;
var
  GanZhi: Integer;
begin
  GanZhi := CombineGanZhi(Gan, Zhi);
  Result := Get5XingLongFromGanZhi(GanZhi);
end;
// ĳյУַ
function Get5XingLongFromDay(AYear, AMonth, ADay: Integer): string;
var
  Gan, Zhi: Integer;
begin
  ExtractGanZhi(GetGanZhiFromDay(AYear, AMonth, ADay), Gan, Zhi);
  Result := Get5XingLongFromGanZhi(Gan, Zhi);
end;

// ĳ֧ϵ֧
function Get3HeFromZhi(const Zhi: Integer; out He1: Integer;
  out He2: Integer): Boolean;
begin
  // ǻ4֧Ҳӳ硢ϳîδ
  // ˵߼ţ
  Result := False;
  if Zhi in [0..11] then
  begin
    case Zhi of
      0:  begin He1 := 8;  He2 := 4;  end;
      1:  begin He1 := 5;  He2 := 9;  end;
      2:  begin He1 := 6;  He2 := 10; end;
      3:  begin He1 := 11; He2 := 7;  end;
      4:  begin He1 := 8;  He2 := 0;  end;
      5:  begin He1 := 9;  He2 := 1;  end;
      6:  begin He1 := 2;  He2 := 10; end;
      7:  begin He1 := 3;  He2 := 11; end;
      8:  begin He1 := 0;  He2 := 4;  end;
      9:  begin He1 := 5;  He2 := 1;  end;
      10: begin He1 := 2;  He2 := 6;  end;
      11: begin He1 := 3;  He2 := 7;  end;
    else
      He1 := -1;
      He2 := -1;
    end;
    Result := True;
  end;
end;

// ݹжϵʱ
function GetCalendarType(AYear, AMonth, ADay: Integer): TCnCalendarType;
begin
  if AYear > 1582 then
    Result := ctGregorian
  else if AYear < 1582 then
    Result := ctJulian
  else if AMonth < 10 then
    Result := ctJulian
  else if (AMonth = 10) and (ADay <= 4) then
    Result := ctJulian
  else if (AMonth = 10) and (ADay in [5..14]) then
    Result := ctInvalid
  else
    Result := ctGregorian;
end;

// ĳǷ
function GetIsLeapYear(AYear: Integer): Boolean;
begin
  if GetCalendarType(AYear, 1, 1) = ctGregorian then
    Result := (AYear mod 4 = 0) and ((AYear mod 100 <> 0) or (AYear mod 400 = 0))
  else if AYear >= 0 then
    Result := (AYear mod 4 = 0)
  else // ҪжϹԪǰԭûйԪ 0 
    Result := (AYear - 3) mod 4 = 0
end;

// ȡ 1582  10 µ
function GetMonthDays(AYear, AMonth: Integer): Integer;
begin
  case AMonth of
    1,3,5,7,8,10,12:
      Result := 31;
    4,6,9,11:
      Result:= 30;
    2:// 
      if GetIsLeapYear(AYear) then
        Result :=  29
      else
        Result := 28
  else
    Result := 0;
  end;
end;

// ȡũĳ
function GetLunarMonthDays(ALunarYear, ALunarMonth: Integer;
  IsLeapMonth: Boolean = False): Integer;
var
  EquDay1, EquDay2: Integer;
  AYear, AMonth, ADay: Integer;
  ALeap: Boolean;
begin
  Result := -1;
  if IsLeapMonth and (GetLunarLeapMonth(ALunarYear) <> ALunarMonth) then
    Exit; // ޴˳

  if not GetDayFromLunar(ALunarYear, ALunarMonth, 1, IsLeapMonth, AYear, AMonth, ADay) then
    Exit;

  EquDay1 := GetEquStandardDays(AYear, AMonth, ADay);

  ALeap := False;
  if GetLunarLeapMonth(ALunarYear) = ALunarMonth then // ڱиµ
  begin
    if IsLeapMonth then // £һ
    begin
      Inc(ALunarMonth);
      if ALunarMonth > 12 then
      begin
        Dec(ALunarMonth, 12);
        Inc(ALunarYear);
      end;
    end
    else
      ALeap := True; // һ
  end
  else
  begin
    Inc(ALunarMonth);
    if ALunarMonth > 12 then
    begin
      Dec(ALunarMonth, 12);
      Inc(ALunarYear);
    end;
  end;

  if not GetDayFromLunar(ALunarYear, ALunarMonth, 1, ALeap, AYear, AMonth, ADay) then
    Exit;

  EquDay2 := GetEquStandardDays(AYear, AMonth, ADay);
  Result := EquDay2 - EquDay1;
end;

// عǷϷ
function GetDateIsValid(AYear, AMonth, ADay: Integer): Boolean;
begin
  Result := (AYear <> 0) and (AMonth in [1..12]) and (ADay > 0)
    and (ADay <= GetMonthDays(AYear, AMonth));
  if Result and (AYear = 1582) and (AMonth = 10) then
    Result := not (ADay in [5..14]);
end;

// жϹǷϷϷ׳쳣
procedure ValidDate(AYear, AMonth, ADay: Integer);
begin
  if not GetDateIsValid(AYear, AMonth, ADay) then
    raise ECnDateException.CreateFmt('Date is Invalid: %d-%d-%d.', [AYear, AMonth, ADay]);
end;

// ũǷϷ
function GetLunarDateIsValid(ALunarYear, ALunarMonth, ALunarDay: Integer;
  IsLeapMonth: Boolean): Boolean;
begin
  Result := False;
  if not (ALunarMonth in [1..12]) then
    Exit;

  if ALunarDay > 30 then
    Exit;

  if IsLeapMonth and (GetLunarLeapMonth(ALunarYear) <> ALunarMonth) then
    Exit; // ޴˳

  // жϴСǷ񳬽
  if ALunarDay = 30 then
    if ALunarDay > GetLunarMonthDays(ALunarYear, ALunarMonth, IsLeapMonth) then
      Exit;

  Result := True;
end;

// жũǷϷϷ׳쳣
procedure ValidLunarDate(ALunarYear, ALunarMonth, ALunarDay: Integer; IsLeapMonth: Boolean);
begin
  if not GetLunarDateIsValid(ALunarYear, ALunarMonth, ALunarDay, IsLeapMonth) then
    raise ECnDateException.CreateFmt('Lunar Date is Invalid: %d-%d-%d, MonthLeap %d.',
      [ALunarYear, ALunarMonth, ALunarDay, Integer(IsLeapMonth)]);
end;

// ʱǷϷ
function GetTimeIsValid(AHour, AMinitue, ASecond: Integer): Boolean;
begin
  Result := (AHour in [0..23]) and (AMinitue in [0..59]) and (ASecond in [0..59]);
end;

// жʱǷϷϷ׳쳣
procedure ValidTime(AHour, AMinitue, ASecond: Integer);
begin
  if not GetTimeIsValid(AHour, AMinitue, ASecond) then
    raise ECnTimeException.CreateFmt('Time is Invalid: %d:%d:%d.', [AHour, AMinitue, ASecond]);
end;

// Ƚڣ1 >=< 2 ֱ𷵻 10-1
function Compare2Day(Year1, Month1, Day1, Year2, Month2, Day2: Integer): Integer;
begin
  if Year1 > Year2 then // 
  begin
    Result := 1
  end
  else if Year1 = Year2 then // 
  begin
    if Month1 > Month2 then  // ´
    begin
      Result := 1
    end
    else if Month1 = Month2 then // µ
    begin
      if Day1 > Day2 then // µմ
      begin
        Result := 1
      end
      else if Day1 = Day2 then // µյ
      begin
        Result := 0;
      end
      else  // µС
      begin
        Result := -1;
      end;
    end
    else // С
    begin
      Result := -1;
    end;
  end
  else // С
  begin
    Result := -1;
  end;
end;

// ȽũڣϢ1 >=< 2 ֱ𷵻 10-1
function Compare2LunarDay(Year1, Month1, Day1: Integer; IsLeap1: Boolean;
  Year2, Month2, Day2: Integer; IsLeap2: Boolean): Integer;
begin
  if Year1 > Year2 then // 
  begin
    Result := 1
  end
  else if Year1 = Year2 then // 
  begin
    if Month1 > Month2 then  // ´
    begin
      Result := 1
    end
    else if Month1 = Month2 then // µ
    begin
      if IsLeap1 = IsLeap2 then // Ҳ
      begin
        if Day1 > Day2 then // µմ
        begin
          Result := 1
        end
        else if Day1 = Day2 then // µյ
        begin
          Result := 0;
        end
        else  // µС
        begin
          Result := -1;
        end;
      end
      else if IsLeap1 and not IsLeap2 then // ĳ´ĳ
        Result := 1
      else
        Result := -1;
    end
    else // С
    begin
      Result := -1;
    end;
  end
  else // С
  begin
    Result := -1;
  end;
end;

// ȡĳڵ 1582  10 µ
function GetDayFromYearBegin(AYear, AMonth, ADay: Integer): Integer;
const
  MonthAbsDays: array [Boolean] of TDayTable =
    ((0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334),
     (0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335));
begin
  Result := MonthAbsDays[GetIsLeapYear(AYear)][AMonth] + ADay;
end;

// ȡĳڵСʱ֡С 1582  10 µ
function GetDayFromYearBegin(AYear, AMonth, ADay, AHour: Integer;
  AMinute, ASecond: Integer): Extended;
begin
  Result := GetDayFromYearBegin(AYear, AMonth, ADay);
  Result := Result + (AHour / 24.0) + (AMinute / 1440.0) + (ASecond / 86400.0);
end;

// ӾºжǷ꣬ False ʾϷ
function ExtractMonthDay(Days: Integer; AYear: Integer; out AMonth: Integer;
  out ADay: Integer): Boolean;
var
  I, Day: Integer;
begin
  if (Days <= 0) or (Days > 366) or ((Days > 365) and (not GetIsLeapYear(AYear))) then
  begin
    Result := False;
    AMonth := -1;
    ADay := -1;
    Exit;
  end;

  for I := 1 to 12 do
  begin
    Day := GetMonthDays(AYear, I);
    if Days > Day then
      Days := Days - Day
    else
    begin
      AMonth := I;
      Break;
    end;
  end;
  ADay := Floor(Days);
  Result := True;
end;

// þ๫Ԫԭ
function GetAllDays(Year, Month, Day: Integer): Integer;

  function GetBasicDays(AYear, AMonth, ADay: Integer): Integer;
  var
    I: Integer;
  begin
    if AYear > 0 then
      Result := (AYear - 1) * 365
    else
      Result := AYear * 365;

    for I := 1 to AMonth - 1 do
      Inc(Result, GetMonthDays(AYear, I));
    Inc(Result, ADay);
  end;

  function GetLeapDays(AYear, AMonth, ADay: Integer): Integer;
  begin
    if AYear >= 0 then // Ԫ
    begin
      if GetCalendarType(AYear, AMonth, ADay) in [ctJulian, ctInvalid] then
        Result := 0
      else
      begin
        // 1582.10.5/15 ǰ Julian ֻһպΪ Gregorian 
        Result := 10; //  Gregory ɾȥ 10 

        if AYear > 1700 then // 㷨򻯰棬 1701  11 
        begin
          // ÿһۼһ
          Inc(Result, 1 + ((AYear - 1701) div 100));
          //  400 Ͳ
          Dec(Result, ((AYear - 1601) div 400));
        end;
      end;
      Result := ((AYear - 1) div 4) - Result; // 4 һ
    end
    else // Ԫǰ
    begin
      Result := - ((- AYear + 3) div 4);
    end;
  end;

begin
  Result := GetBasicDays(Year, Month, Day) + GetLeapDays(Year, Month, Day);
end;

// ȡЧ׼˸ϵֲƺǾ Gregorian ԪԪ
// ע˴ Gregorian ɾȥ 10 죬˵Ч׼
function GetEquStandardDays(AYear, AMonth, ADay: Integer): Integer;
var
  AType: TCnCalendarType;
begin
  Result := 0;
  AType := GetCalendarType(AYear, AMonth, ADay);
  if AType = ctGregorian then
  begin
    Result := (AYear - 1) * 365 + ((AYear - 1) div 4) -((AYear - 1) div 100)
     + ((AYear - 1) div 400) + GetDayFromYearBegin(AYear, AMonth, ADay);
  end
  else if AType = ctJulian then
  begin
    Result := (AYear - 1) * 365 + ((AYear - 1) div 4)
      + GetDayFromYearBegin(AYear, AMonth, ADay) - 2;
    { Ϊɶ 2²⹫Ԫ 1 굽 1582 ꣬Julian  Gregorian  12 죬
      (100, 200, 300, 500, 600, 700, 900, 1000, 1100, 1300, 1400, 1500)
       Gregory ֻɾȥ 10 죬 2 Ĳֵ
      ˵ Gregorian  1582.10.4 ǰƵõ Gregorian ԪԪ
      ʵʹԪԪԪͬһ졣 }
  end;
end;

// õЧ׼Ӧĳգƶ
function GetDayFromEquStandardDays(EquDays: Integer;
  out AYear, AMonth, ADay: Integer): Boolean;
const
  D1 = 365;
  D4 = D1 * 4 + 1;
  D100 = D4 * 25 - 1;
  D400 = D100 * 4 + 1;
var
  Diff: Integer;
  Y, M, D, I: Word;
  T: Integer;
  DayTable: PDayTable;
begin
  Result := False;
  AYear := 0;
  AMonth := 0;
  ADay := 0;

  if EquDays < 0 then Exit; // ݲԪǰĵЧ׼

  if EquDays <= 577735 then //  1582.10.4 (577735) ֮ǰΪJulianҪ
  begin
    Diff := EquDays div (365 * 100) - EquDays div (365 * 400);
    Dec(EquDays, 10); // Gregorian ɾȥ 10 
    Inc(EquDays, 12 - Diff); // ϶ 12 жĲ
  end;

  T := EquDays;
  Y := 1;
  while T >= D400 do
  begin
    Dec(T, D400);
    Inc(Y, 400);
  end;
  I := T div D100;
  D := T mod D100;
  if I = 4 then
  begin
    Dec(I);
    Inc(D, D100);
  end;
  Inc(Y, I * 100);
  I := D div D4;
  D := D mod D4;
  Inc(Y, I * 4);
  I := D div D1;
  D := D mod D1;
  if I = 4 then
  begin
    Dec(I);
    Inc(D, D1);
  end;
  Inc(Y, I);
  DayTable := @MonthDays[GetIsLeapYear(Y)];
  M := 1;
  while True do
  begin
    I := DayTable^[M];
    if D < I then Break;
    Dec(D, I);
    Inc(M);
  end;
  AYear := Y;
  AMonth := M;
  ADay := D + 1;
  Result := True;
end;

// ĳڼ0-6
function GetWeek(const AValue: TDateTime): Integer; overload;
var
  Year, Month, Day: Word;
begin
  DecodeDate(AValue, Year, Month, Day);
  // -2 ԴڹԪ 1  1  2 ղ
  Result := (GetAllDays(Year, Month, Day) - 2) mod 7;
  if Result < 0 then
    Inc(Result, 7);  
end;

// ĳڼ0-6
function GetWeek(AYear, AMonth, ADay: Integer): Integer; overload;
begin
  // -2 ԴڹԪ 1  1  2 ղ
  Result := (GetAllDays(AYear, AMonth, ADay) - 2) mod 7;
  if Result < 0 then
    Inc(Result, 7);
end;

// ֻڶ, 0-6 Ӧ յ
function GetWeekFromNumber(const AValue: Integer): string;
begin
  Result := '';
  if AValue in [0..6] then
    Result := SCnWeekNumberArray[AValue];
end;  

// ĳڵĵ N 1-24ӦС 1582 ֮ǰʮƫ
function GetJieQiDayTimeFromYear(AYear, N: Integer): Extended;
var
  JuD, Tht, YrD, ShuoD: Extended;
begin
  { ڽ¶ɵӰ죬̫ͨʱ䲢һȷع
    û 365.2422 ΪֱӼʱ̡ʽֲ
    صСʱ֡}

  if AYear <= 0 then // ûйԪ 0 ĵ
    Inc(AYear);

  JuD := AYear * (365.2423112 - 6.4e-14 * (AYear-100) * (AYear - 100)
    - 3.047e-8 * (AYear-100)) + 15.218427 * N + 1721050.71301;
  Tht := 3e-4 * AYear - 0.372781384 - 0.2617913325 * N;
  YrD := (1.945 * sin(Tht) - 0.01206 * sin(2 * Tht)) * (1.048994 - 2.583e-5 * AYear);
  ShuoD := -18e-4 * sin(2.313908653 * AYear - 0.439822951 - 3.0443 * N);
  Result := JuD + YrD + ShuoD - GetEquStandardDays(AYear, 1, 0) - 1721425; // 
  // (juD - GetEquStandardDays(AYear, 1, 0) - 1721425); ƽ
  if AYear <= 1582 then // 1582 걻ɾ 10 죬Ҫӻ
    Result := Result + 10;
end;

// ĳĵ N Ľʱ֣0-23ӦС
function GetJieQiInAYear(AYear, N: Integer; out AMonth: Integer;
  out ADay: Integer; out AHour: Integer; out AMinitue: Integer): Boolean;
var
  Days: Extended;
  I, Day: Integer;
begin
  Result := N in [0..23];
  if Result then
  begin
    Days := GetJieQiDayTimeFromYear(AYear, N + 1);
    for I := 1 to 12 do
    begin
      Day := GetMonthDays(AYear, I);
      if Days > Day then
        Days := Days - Day
      else
      begin
        AMonth := I;
        Break;
      end;
    end;
    ADay := Floor(Days);

    Days := Days - ADay;
    AHour := Floor(Days * 24);

    Days := Days * 24 - AHour;
    AMinitue := Round(Days * 60);

    // ǡõ 60СʱҪһСʱǡõ 24Ҫһ
    if AMinitue >= 60 then
    begin
      Dec(AMinitue, 60);
      Inc(AHour);

      if AHour >= 24 then
      begin
        Dec(AHour, 24);
        Inc(ADay);
      end;

      // µףһ㲻ÿһ·ݸı
    end;
  end
  else
  begin
    AMonth := 0;
    ADay := 0;
    AHour := 0;
    AMinitue := 0;
  end;
end;

// ùǱʲô0-23Ӧ󺮣򷵻 -1
function GetJieQiFromDay(AYear, AMonth, ADay: Integer): Integer;
var
  Month, Day, Idx, DummyHour, DummyMinute: Integer;
begin
  Result := -1;

  // ÿڴ¶Ӧپȷ㣬Ż
  Idx := (AMonth - 1) * 2;
  if ADay >= 15 then
    Inc(Idx);

  if GetJieQiInAYear(AYear, Idx, Month, Day, DummyHour, DummyMinute) then
  begin
    if (AMonth = Month) and (ADay = Day) then
    begin
      // ʱ I ʾ 0 С
      Result := Idx - 2;
      // ת 0 
      if Result < 0 then
        Inc(Result, 24);
      Exit;
    end;
  end;
end;

// ùǱʲôԼʱ̣0-23Ӧ󺮣򷵻 -1
function GetJieQiTimeFromDay(AYear, AMonth, ADay: Integer; out AHour: Integer;
  out AMinitue: Integer): Integer;
var
  Month, Day, Idx: Integer;
begin
  Result := -1;

  // ÿڴ¶Ӧپȷ㣬Ż
  Idx := (AMonth - 1) * 2;
  if ADay >= 15 then
    Inc(Idx);

  if GetJieQiInAYear(AYear, Idx, Month, Day, AHour, AMinitue) then
  begin
    if (AMonth = Month) and (ADay = Day) then
    begin
      // ʱ I ʾ 0 С
      Result := Idx - 2;
      // ת 0 
      if Result < 0 then
        Inc(Result, 24);
      Exit;
    end;
  end;
  AHour := -1;
  AMinitue := -1;
end;


// ĳʱɵ֧0-59 Ӧ ӵﺥ
function GetGanZhiFromHour(AYear, AMonth, ADay, AHour: Integer): Integer;
var
  Gan, Zhi, DummyZhi: Integer;
begin
  AHour := AHour mod 24;
  ExtractGanZhi(GetGanZhiFromDay(AYear, AMonth, ADay), Gan, DummyZhi);

  // Zhiʱ(0-11)Ҳ֧
  if AHour = 23 then
  begin
    // ʱ
    Gan := (Gan + 1) mod 10;
    Zhi := 0;
  end
  else
  begin
    Inc(AHour);
    Zhi := AHour div 2;
  end;

  // Gan ʱǱոݹɱʱ
  if Gan >= 5 then
    Dec(Gan, 5);
  Gan := 2 * Gan;
  
  // ʱ
  Gan := (Gan + Zhi) mod 10;
  Result := CombineGanZhi(Gan, Zhi);
end;

// ĳյɵ֧0-59 Ӧ ӵﺥ
function GetGanZhiFromDay(AllDays: Integer): Integer;
begin
  Result := (AllDays + 12) mod 60;
  if Result < 0 then
    Inc(Result, 60);
end;

function GetGanZhiFromDay(AYear, AMonth, ADay: Integer): Integer;
begin
  Result := GetGanZhiFromDay(GetAllDays(AYear, AMonth, ADay));
end;

// ĳյɵ֧0-59 Ӧ ӵﺥСʱж 23 СʱǴ}
function GetGanZhiFromDay(AYear, AMonth, ADay, AHour: Integer): Integer;
begin
  AHour := AHour mod 24;
  if AHour >= 23 then
    Result := GetGanZhiFromDay(GetAllDays(AYear, AMonth, ADay) + 1)
  else
    Result := GetGanZhiFromDay(GetAllDays(AYear, AMonth, ADay));
end;

// ĳµɵ֧0-59 Ӧ ӵﺥ
function GetGanZhiFromMonth(AYear, AMonth, ADay: Integer): Integer;
begin
  Result := GetGanZhiFromMonth(AYear, AMonth, ADay, 0);
end;

// ĳµɵ֧0-59 Ӧ ӵﺥ
function GetGanZhiFromMonth(AYear, AMonth, ADay, AHour: Integer): Integer;
var
  Gan, DummyZhi, M: Integer;
begin
  // Ҫȸݽ·Լ
  AdjustYearMonthByJieQi(AYear, AMonth, ADay, AHour);

  Result := -1;
  ExtractGanZhi(GetGanZhiFromYear(AYear), Gan, DummyZhi);
  case Gan of // ݿھӱ㱾£֮ڵ£һǶ£ĸ
    0,5: // ׼ ף
      Result := 2;
    1,6: // Ҹ Ϊͷ
      Result := 4;
    2,7: //  Ѱ
      Result := 6;
    3,8: //  λ
      Result := 8;
    4,9: //  ׺
      Result := 0;
  end;

  M := AMonth - 2;
  if M < 0 then
    M := M + 10;
  Inc(Result, M mod 10); // 㱾¸

  if Result >= 10 then
    Result := Result mod 10;

  Result := CombineGanZhi(Result, AMonth mod 12); // ֧֮ڵıΪһǶ£=2
end;

// ĳ/ũĸ֧0-59 Ӧ ӵﺥ
function GetGanZhiFromYear(AYear: Integer): Integer;
begin
  if AYear > 0 then
    Result := (AYear - 4) mod 60
  else // ҪжϹԪǰԭûйԪ 0 
    Result := (AYear - 3) mod 60;

  if Result < 0 then
    Inc(Result, 60);
end;

// ݹջĳɵ֧Ϊֽ磬0-59 Ӧ ӵﺥ
function GetGanZhiFromYear(AYear, AMonth, ADay: Integer): Integer; overload;
begin
  // ǰǰһꡣһ
  if GetDayFromYearBegin(AYear, AMonth, ADay) < Floor(GetJieQiDayTimeFromYear(AYear, 3)) then
    Dec(AYear);
  Result := GetGanZhiFromYear(AYear);
end;

// ݹջĳɵ֧Ϊֽ磬ȷСʱ0-59 Ӧ ӵﺥ
function GetGanZhiFromYear(AYear, AMonth, ADay, AHour: Integer): Integer; overload;
begin
  // ǰǰһ꣬ȷСʱжϡһ
  if GetDayFromYearBegin(AYear, AMonth, ADay, AHour) < GetJieQiDayTimeFromYear(AYear, 3) then
    Dec(AYear);
  Result := GetGanZhiFromYear(AYear);
end;

// ĳ/ũɣ0-9 Ӧ ׵
function GetGanFromYear(AYear: Integer): Integer;
begin
  if AYear > 0 then
    Result := (AYear - 4) mod 10
  else // ҪжϹԪǰԭûйԪ 0 
    Result := (AYear - 3) mod 10;

  if Result < 0 then
    Inc(Result, 10);
end;

// ĳ/ũĵ֧0-11 Ӧ ӵ
function GetZhiFromYear(AYear: Integer): Integer;
begin
  if AYear > 0 then
    Result := (AYear - 4) mod 12
  else // ҪжϹԪǰԭûйԪ 0 
    Result := (AYear - 3) mod 12;

  if Result < 0 then
    Inc(Result, 12);
end;

// ĳ/ũФҲǵ֧0-11 Ӧ 
function GetShengXiaoFromYear(AYear: Integer): Integer;
begin
  Result := GetZhiFromYear(AYear);
end;

// ĳյ0-11 Ӧ ˫}
function GetXingZuoFromMonthDay(AMonth, ADay: Integer): Integer;
const
  SCnXingZuoDays: array[0..11] of Integer =
    (120, 219, 321, 421, 521, 622, 723, 823, 923, 1023, 1123, 1222);
  // ÿʼ
var
  I, Days: Integer;
begin
  Result := -1;
  Days := AMonth * 100 + ADay;

  for I := 0 to 11 do
  begin
    // ڵһǱƿԵüӸƫ
    if Days < SCnXingZuoDays[I] then
    begin
      Result := (I + 9) mod 12;
      Exit;
    end
    else if (Days >= SCnXingZuoDays[I]) and (Days < SCnXingZuoDays[I + 1]) then
    begin
      Result := (I + 10) mod 12;
      Exit;
    end;
  end;
end;

// ĳյʮ0-11 Ӧ 
function Get12JianFromDay(AYear, AMonth, ADay: Integer): Integer;
var
  I, LiChun, JianStart, Days, AllDays, JieQi: Integer;
  DummyGan, Zhi: Integer;
begin
  Result := -1;

  // ʮڵ֧תڷĽظǰһ
  // һΪ
  JianStart := -1;
  LiChun := Floor(GetJieQiDayTimeFromYear(AYear, 3)); // 
  AllDays := GetAllDays(AYear, 1, 1) - 1;

  for I := LiChun + 1 to LiChun + 13 do
  begin
    ExtractGanZhi(GetGanZhiFromDay(AllDays + I), DummyGan, Zhi);

    // õ֧жǷ
    if Zhi = 2 then
    begin
      JianStart := I;
      Break;
    end;
  end;

  Days := GetDayFromYearBegin(AYear, AMonth, ADay);

  // ҵĵһ
  if JianStart > 0 then
  begin
    // 
    if JianStart = Days then
    begin
      Result := 0;
      Exit;
    end
    else
    begin
      Result := Days - JianStart; // ȼֵ mod 12 

      if Days < JianStart then // ֮ǰֲ֮ͬ
      begin
        for I := 3 downto 1 do
        begin
          if (I mod 2 = 0) then Continue; // 
          JieQi := Floor(GetJieQiDayTimeFromYear(AYear, I));
          if JieQi > Days then // ˽ڴں󣬱ʾ֮󵽽ʮͣ
            Inc(Result);
        end;
      end
      else
      begin
        for I := 4 to 24 do
        begin
          if (I mod 2 = 0) then Continue; // 
          JieQi := Floor(GetJieQiDayTimeFromYear(AYear, I));
          if JieQi <= Days then // ˽ڴǰʾʮͣ
            Dec(Result);
        end;
      end;

      Result := Result mod 12;
      if Result < 0 then
        Inc(Result, 12);
    end;
  end;
end;  

// ĳյĶʮޣ0-27 Ӧ ǵ
function Get28XiuFromDay(AYear, AMonth, ADay: Integer): Integer;
begin
  // +22 ԴڹԪ 1  1  0 
  Result := (GetAllDays(AYear, AMonth, ADay) + 22) mod 28;
  if Result < 0 then
    Inc(Result, 28);
end;

// ĳյ̥λ0-59 ̥λü̥λַ
function GetTaiShenStringFromDay(AYear, AMonth, ADay: Integer): string; overload;
var
  GanZhi: Integer;
begin
  GanZhi := GetGanZhiFromDay(AYear, AMonth, ADay);
  Result := SCnTaiShen1Array[GanZhi] + SCnTaiShen2Array[GanZhi];
end;

// ĳյ̥λ0-59 ̥λ̥λַ
function GetTaiShenStringFromDay(AYear, AMonth, ADay: Integer;
  out TaiShen1: string; out TaiShen2: string): Boolean;
var
  GanZhi: Integer;
begin
  GanZhi := GetGanZhiFromDay(AYear, AMonth, ADay);
  TaiShen1 := SCnTaiShen1Array[GanZhi];
  TaiShen2 := SCnTaiShen2Array[GanZhi];
  Result := True;
end;

// Сʱʱ̶Ӧʱ0-11 Ӧ
function GetShiChenFromHour(AHour: Integer): Integer;
begin
  Result := -1;
  if not (AHour in [0..23]) then
    Exit;

  if AHour = 23 then
  begin
    // ʱ
    Result := 0;
  end
  else
  begin
    Inc(AHour);
    Result := AHour div 2;
  end;
end;

// Ϊ磬յĸ֧ȸļ
function AdjustYearByJieQi(var AYear: Integer; AMonth: Integer;
  ADay: Integer; AHour: Integer): Boolean;
var
  Days: Extended;
begin
  Result := GetDateIsValid(AYear, AMonth, ADay);
  if not Result then
    Exit;

  Days := GetDayFromYearBegin(AYear, AMonth, ADay, AHour);

  // ļ¼Ϊɵ֧Ϊֽģ
  // 籾Ǳǰǰһꡣһ
  if Days < Floor(GetJieQiDayTimeFromYear(AYear, 3)) then
  begin
    // ҪΪǰһ
    Dec(AYear);
  end;
end;

// ݽΪ磬յ·µĸ֧ȸļ
function AdjustYearMonthByJieQi(var AYear: Integer; var AMonth: Integer;
  ADay: Integer; AHour: Integer): Boolean;
var
  Days, XH: Extended;
begin
  Result := GetDateIsValid(AYear, AMonth, ADay);
  if not Result then
    Exit;

  Days := GetDayFromYearBegin(AYear, AMonth, ADay, AHour);

  XH := Floor(GetJieQiDayTimeFromYear(AYear, 1)); // 1 µС
  if Days < XH then
  begin
    Dec(AYear);    // С֮ǰȥ 12 £Сڽ
    AMonth := 12;
  end
  else
  begin
    // 㱾Ľǰһģ
    // ׽ľͷڵڴգϸ£ڱ
    // TODO: Ӧüж I ׽ڱ£ǰǽ㷨нϴƫܲڱ£
    // ֮ǰ 1582 꼰ǰ 10 ƫδˣ˴˴ʱ

    if Days < Floor(GetJieQiDayTimeFromYear(AYear, 2 * AMonth - 1)) then
      Dec(AMonth);
  end;
end;

// ֻԪƣ0-2
function Get3YuanFromNumber(A3Yuan: Integer): string;
begin
  Result := '';
  if (A3Yuan >= 0) and (A3Yuan < 3) then
    Result := SCn3YuanArray[A3Yuan];
end;

// ֻþƣ0-8
function Get9XingFromNumber(A9Xing: Integer): string;
begin
  Result := '';
  if (A9Xing >= 0) and (A9Xing < 9) then
    Result := SCn9XingArray[A9Xing];
end;

// ȡԪ0-2 ӦԪԪԪ
function Get3YuanFromYear(AYear, AMonth, ADay: Integer): Integer;
begin
  Result := -1;
  if AYear = 0 then
    Exit;

  AYear := GetYearSeperatedByLiChun(AYear, AMonth, ADay);
  if AYear < 0 then  // ޹Ԫ 0 
    Inc(AYear);

  // 1864 ĳһԪ֮ʼ
  AYear := (AYear - 1864) mod 180;
  if AYear < 0 then
    Inc(AYear, 180);

  if AYear in [0..59] then
    Result := 0
  else if AYear in [60..119] then
    Result := 1
  else
    Result := 2;
end;

// ȡ˾ǣ0-8 Ӧһ׵
function GetYun9XingFromYear(AYear, AMonth, ADay: Integer): Integer;
begin
  Result := -1;
  if AYear = 0 then
    Exit;

  AYear := GetYearSeperatedByLiChun(AYear, AMonth, ADay);
  if AYear < 0 then  // ޹Ԫ 0 
    Inc(AYear);

  // 1864 ĳһԪҲǾ֮ʼ
  AYear := (AYear - 1864) mod 180;
  if AYear < 0 then
    Inc(AYear, 180);

  Result := AYear div 20;
end;

// ȡǣ0-8 Ӧһ׵
function Get9XingFromYear(AYear, AMonth, ADay: Integer): Integer;
var
  Yuan: Integer;
begin
  Result := -1;
  if AYear = 0 then
    Exit;

  Yuan := Get3YuanFromYear(AYear, AMonth, ADay);
  AYear := GetYearSeperatedByLiChun(AYear, AMonth, ADay);

  AYear := (AYear - 1864) mod 60;
  if AYear < 0 then
    Inc(AYear, 60);

  case Yuan of
    0:       // Ԫһ
      begin
        Result := 8 - ((AYear + 8) mod 9);
      end;
    1:       // Ԫ
      begin
        Result := 8 - ((AYear + 5) mod 9);
      end;
    2:       // Ԫ߳
      begin
        Result := 8 - ((AYear + 2) mod 9);
      end;
  end;
end;

// ȡµ¾ǣ0-8 Ӧһ׵
function Get9XingFromMonth(AYear, AMonth, ADay: Integer): Integer;
var
  Zhi: Integer;
begin
  Result := -1;
  if AdjustYearMonthByJieQi(AYear, AMonth, ADay, 0) then
  begin
    // õָԼָºȡ֧
    Zhi := GetZhiFromYear(AYear);
    case Zhi of
      0, 3, 6, 9:
        begin
          // îϰ˰
          Result := 8 - (AMonth mod 9);
        end;
      2, 5, 8, 11:
        begin
          // Ⱥ
          Result := 8 - ((AMonth + 6) mod 9);
        end;
      1, 4, 7, 10:
        begin
          // δ
          Result := 8 - ((AMonth + 3) mod 9);
        end;
    end;
  end;
end;

// ȡյվǣ0-8 Ӧһ׵
function Get9XingFromDay(AYear, AMonth, ADay: Integer): Integer;
const
  JIEQI_SEQ: array[0..5] of Integer = (0, 4, 8, 12, 16, 20);
  // һ꣩ˮꡢ˪
var
  I, PreYear, GanZhi, AllDays, Days: Integer;
  Matched: Boolean;
  JieQis: array[0..5] of Integer; // ڣ
  JiaZiQians: array[0..5] of Integer; // ǰĵһյڣ
  JiaZiHous: array[0..5] of Integer;  // ĵһյڣ
begin
  Result := -1;
  if AYear = 0 then
    Exit;

  if AYear = 1 then
    PreYear := -1
  else
    PreYear := AYear - 1;

  for I := Low(JIEQI_SEQ) to High(JIEQI_SEQ) do
  begin
    if JIEQI_SEQ[I] > 0 then
    begin
      JieQis[I] := Floor(GetJieQiDayTimeFromYear(AYear, JIEQI_SEQ[I]));
      AllDays := GetAllDays(AYear, 1, 1) - 1;
    end
    else
    begin
      JieQis[I] := Floor(GetJieQiDayTimeFromYear(PreYear, JIEQI_SEQ[I] + 24));
      AllDays := GetAllDays(PreYear, 1, 1) - 1;
    end;

    GanZhi := GetGanZhiFromDay(Alldays + JieQis[I]);  // õյĸ֧
    JiaZiHous[I] := JieQis[I] + (60 - GanZhi);        // õյľ 0 Ϊһ
    JiaZiQians[I] := JiaZiHous[I] - 60;               // õǰյľ 0 Ϊһ
  end;

  JiaZiHous[0] := JiaZiHous[0] - 365;
  JiaZiQians[0] := JiaZiQians[0] - 365;
  JieQis[0] := JieQis[0] - 365;          // ɾ౾
  if IsLeapYear(PreYear) then
  begin
    Dec(JiaZiHous[0]);
    Dec(JiaZiQians[0]);
  end;

  // JiaZiHous յľ౾׵ 0 Ϊֵʾȥ
  // JiaZiQians ǰյľ౾׵ 01 Ϊֵʾȥ
  Days := GetDayFromYearBegin(AYear, AMonth, ADay);
  for I := High(JiaZiHous) downto Low(JiaZiHous) do
  begin
    Matched := False;
    if (Days >= JieQis[I]) and (Days < JiaZiHous[I]) then
    begin
      // 󣨺һգڣӽǰļ
      Days := Days - JiaZiQians[I];
      Matched := True;
    end
    else if Days >= JiaZiHous[I] then
    begin
      // ڵڽգӸý
      Days := Days - JiaZiHous[I];
      Matched := True;
    end;

    if not Matched then
      Continue;

    case I of
      0:
        begin
          // ǰһף˳
          Result := Days mod 9;
        end;
      1:
        begin
          // ˮǰ߳࣬˳
          Result := (Days + 6) mod 9;
        end;
      2:
        begin
          // ǰı̣˳
          Result := (Days + 3) mod 9;
        end;
      3:
        begin
          // ǰϣ
          Result := 8 - (Days mod 9);
        end;
      4:
        begin
          // ǰ̣
          Result := 8 - ((Days + 6) mod 9);
        end;
      5:
        begin
          // ˪ǰף
          Result := 8 - ((Days + 3) mod 9);
        end;
    end;
    Exit;
  end;
end;

// ȡʱʱǣ0-8 Ӧһ׵
function Get9XingFromHour(AYear, AMonth, ADay, AHour: Integer): Integer;
var
  SCH, Days, DayGanZhi, DayGan, DayZhi, XiaZhi, DongZhi: Integer;
begin
  Result := -1;
  if AYear = 0 then
    Exit;

  SCH := GetShiChenFromHour(AHour);
  Days := GetDayFromYearBegin(AYear, AMonth, ADay);

  DayGanZhi := GetGanZhiFromDay(AYear, AMonth, ADay, AHour);
  ExtractGanZhi(DayGanZhi, DayGan, DayZhi);

  DongZhi := Floor(GetJieQiDayTimeFromYear(AYear, 24));
  XiaZhi := Floor(GetJieQiDayTimeFromYear(AYear, 12));

  if (Days >= XiaZhi) and (Days < DongZhi) then
  begin
    // Ҷǰ
    case DayZhi of
      0, 3, 6, 9:
        begin
          // îյʱǾ
          Result := 8 - (SCH mod 9);
        end;
      2, 5, 8, 11:
        begin
          // Ⱥյʱ
          Result := 8 - ((SCH + 3) mod 9);
        end;
      1, 4, 7, 10:
        begin
          // δյʱ
          Result := 8 - ((SCH + 6) mod 9);
        end;
    end;
  end
  else
  begin
    // ǰ˳
    case DayZhi of
      0, 3, 6, 9:
        begin
          // îյʱһ
          Result := SCH mod 9;
        end;
      2, 5, 8, 11:
        begin
          // Ⱥյʱ߳
          Result := (SCH + 6) mod 9;
        end;
      1, 4, 7, 10:
        begin
          // δյʱ
          Result := (SCH + 3) mod 9;
        end;
    end;
  end;
end;

// ݼλֻüλ
function GetJiShenFangWeiFromNumber(AFangWei: Integer): string;
begin
  Result := '';
  if (AFangWei >= 0) and (AFangWei < 8) then
    Result := SCnJiShenFangWeiArray[AFangWei];
end;

// ùյĲλ0-7
function GetCaiShenFangWeiFromDay(AYear, AMonth, ADay: Integer): Integer;
var
  Gan, Zhi: Integer;
begin
  Result := -1;
  ExtractGanZhi(GetGanZhiFromDay(AYear, AMonth, ADay), Gan, Zhi);
  // ھҶǲ񣬱Ѱ켺λȥɹԭǲλ
  case Gan of
    0,1: Result := 1; // ڶ
    2,3: Result := 5; // 
    4,5: Result := 0; // 켺
    6,7: Result := 2; // 
    8,9: Result := 4; // ɹ
  end;
end;

// ùյϲλ0-7
function GetXiShenFangWeiFromDay(AYear, AMonth, ADay: Integer): Integer;
var
  Gan, Zhi: Integer;
begin
  Result := -1;
  ExtractGanZhi(GetGanZhiFromDay(AYear, AMonth, ADay), Gan, Zhi);
  // ھҸǬλϲ񰲣ɱ빬ԭ䡣
  // ԶӦλǬޣ㣬ϣ룬ϣϣң

  case Gan of
    0,5: Result := 1; // ׼ڶ
    1,6: Result := 7; // Ҹ
    2,7: Result := 5; // 
    3,8: Result := 4; // 
    4,9: Result := 3; // ڶ
  end;
end;

// ùյĸλ0-7
function GetFuShenFangWeiFromDay(AYear, AMonth, ADay: Integer): Integer;
var
  Gan, Zhi: Integer;
begin
  Result := -1;
  ExtractGanZhi(GetGanZhiFromDay(AYear, AMonth, ADay), Gan, Zhi);
  // Ȼ׿ھһǴ˴õļ׼Ǹ񣬱Ǭ档Ҹλޣ׷Ѱ
  // ǣҶǸ񣬱ǿˣ챱ϸǬϡɸá

  case Gan of
    0,5: Result := 0; // ׼
    1,6: Result := 5; // Ҹ
    2,7: Result := 7; // 
    3,8: Result := 3; // ڶ
    4,9: Result := 1; // ڶ
  end;
end;

// ùյĹλ0-7ĬΪ
function GetGuiShenFangWeiFromDay(AYear, AMonth, ADay: Integer): Integer;
begin
  Result := GetYangGuiShenFangWeiFromDay(AYear, AMonth, ADay);
end;

// ùյλ0-7
function GetYangGuiShenFangWeiFromDay(AYear, AMonth, ADay: Integer): Integer;
var
  Gan, Zhi: Integer;
begin
  Result := -1;
  ExtractGanZhi(GetGanZhiFromDay(AYear, AMonth, ADay), Gan, Zhi);

  case Gan of
    0,1: Result := 5; // 
    2:   Result := 6; // 
    3:   Result := 7; // 
    4,6,7: Result := 1; // ڶ
    5:   Result := 0; // 
    8:   Result := 2; // 
    9:   Result := 3; // ڶ
  end;
end;

// ùյλ0-7
function GetYingShenFangWeiFromDay(AYear, AMonth, ADay: Integer): Integer;
var
  Gan, Zhi: Integer;
begin
  Result := -1;
  ExtractGanZhi(GetGanZhiFromDay(AYear, AMonth, ADay), Gan, Zhi);

  case Gan of
    0:   Result := 1; // ڶ
    1:   Result := 0; // 
    2:   Result := 7; // 
    3:   Result := 6; // 
    4,5,6: Result := 5; // 켺
    7:   Result := 4; // 
    8:   Result := 3; // ڶ
    9:   Result := 2; // 
  end;
end;

// ùеĵڼŵĵڼգ1~9,1~9 ӦһŵžţFalse Ϊ
function GetShu9Day(AYear, AMonth, ADay: Integer; out JiuSeq: Integer; out JiuDay: Integer): Boolean;
var
  DongZhi, Days: Integer;
begin
  Result := False;
  JiuSeq := -1;
  JiuDay := -1;

  DongZhi := Floor(GetJieQiDayTimeFromYear(AYear, 24));
  Days := GetDayFromYearBegin(AYear, AMonth, ADay);

  if (Days >= DongZhi) and (Days - DongZhi < 81) then // ڽľž
  begin
    Result := True;
    JiuSeq := ((Days - DongZhi) div 9) + 1;
    JiuDay := ((Days - DongZhi) mod 9) + 1;
  end
  else
  begin // Ƿǰһڵľž
    Dec(AYear);
    if AYear = 0 then
      Dec(AYear);

    // һĶ
    DongZhi := Floor(GetJieQiDayTimeFromYear(AYear, 24));

    // ôһ׵ĳ
    Days := Days + 365;
    if GetIsLeapYear(AYear) then
      Inc(Days);

    if (Days >= DongZhi) and (Days - DongZhi < 81) then
    begin
      Result := True;
      JiuSeq := ((Days - DongZhi) div 9) + 1;
      JiuDay := ((Days - DongZhi) mod 9) + 1;
    end;
  end;
end;

// ùеĵڼĵڼգ0~2,1~10 20ӦĩķգFalse Ϊڷ
function Get3FuDay(AYear, AMonth, ADay: Integer; out FuSeq: Integer; out FuDay: Integer): Boolean;
var
  Days, XiaZhi, LiQiu: Integer;
  AllDays, I: Integer;
  Gan, DummyZhi: Integer;
  F1, F2, F3: Integer;
begin
  Result := False;
  FuSeq := -1;
  FuDay := -1;

  Days := GetDayFromYearBegin(AYear, AMonth, ADay);
  XiaZhi := Floor(GetJieQiDayTimeFromYear(AYear, 12)); // 
  LiQiu := Floor(GetJieQiDayTimeFromYear(AYear, 15)); // 
  AllDays := GetAllDays(AYear, 1, 1) - 1;

  for I := XiaZhi + 1 to XiaZhi + 21 do // ֤һյĺ 10 죬ղ
  begin
    if ExtractGanZhi(GetGanZhiFromDay(AllDays + I), Gan, DummyZhi) then
    begin
      if Gan = 6 then // һ
      begin
        ExtractMonthDay(I, AYear, AMonth, ADay);
        
        F1 := I + 20; // գ
        F2 := I + 30; // зգĸ

        if (Days >= F1) and (Days < F1 + 10) then
        begin
          Result := True;
          FuSeq := 0;
          FuDay := Days - F1 + 1;
        end
        else if Days >= F2 then // з
        begin
          if (Days < F2 + 10) or // з 10 ڻǰ 20 
            ((Days >= F2 + 10) and (Days < F2 + 20) and (F2 + 10 <= LiQiu)) then
          begin
            Result := True;
            FuSeq := 1;
            FuDay := Days - F2 + 1;
          end;
        end;

        if Result then
          Exit;

        Break;
      end;
    end;
  end;

  for I := LiQiu + 1 to LiQiu + 21 do // ֤һյĺ 10 죬ﵱղ
  begin
    if ExtractGanZhi(GetGanZhiFromDay(AllDays + I), Gan, DummyZhi) then
    begin
      if Gan = 6 then // һ
      begin
        F3 := I; // ĩ

        if (Days >= F3) and (Days < F3 + 10) then
        begin
          ExtractMonthDay(I, AYear, AMonth, ADay);
          Result := True;
          FuSeq := 2;
          FuDay := Days - F3 + 1;
        end
        else
          Result := False;

        Exit; // ѭˣְѵڶĩʼĴ
      end;
    end;
  end;
end;

// ĳе÷ڣ÷꼾ڵĿʼգâֺĵһ
function GetRuMeiDay(AYear: Integer; out AMonth: Integer; out ADay: Integer): Boolean;
var
  I, MangZhong, AllDays: Integer;
  Gan, DummyZhi: Integer;
begin
  Result := False;
  MangZhong := Floor(GetJieQiDayTimeFromYear(AYear, 11)); // â
  AllDays := GetAllDays(AYear, 1, 1) - 1;

  for I := MangZhong + 1 to MangZhong + 21 do
  begin
    if ExtractGanZhi(GetGanZhiFromDay(AllDays + I), Gan, DummyZhi) then
    begin
      if Gan = 2 then // âֺһ
      begin
        ExtractMonthDay(I, AYear, AMonth, ADay);
        Result := True;
        Exit;
      end;
    end;
  end;
end;

// ĳеĳ÷ڣ÷꼾ڵĽգСĵһδ
function GetChuMeiDay(AYear: Integer; out AMonth: Integer; out ADay: Integer): Boolean;
var
  I, XiaoShu, AllDays: Integer;
  DummyGan, Zhi: Integer;
begin
  Result := False;
  XiaoShu := Floor(GetJieQiDayTimeFromYear(AYear, 13)); // С
  AllDays := GetAllDays(AYear, 1, 1) - 1;
  
  for I := XiaoShu + 1 to XiaoShu + 21 do
  begin
    if ExtractGanZhi(GetGanZhiFromDay(AllDays + I), DummyGan, Zhi) then
    begin
      if Zhi = 7 then // Сһδ
      begin
        ExtractMonthDay(I, AYear, AMonth, ADay);
        Result := True;
        Exit;
      end;
    end;
  end;
end;

// ݹգظָݣҲ˵պǽ꣬Ϊȥ
function GetYearSeperatedByLiChun(AYear, AMonth, ADay: Integer): Integer;
var
  Days: Extended;
begin
  Result := AYear;
  Days := GetDayFromYearBegin(AYear, AMonth, ADay);

  // 籾ǰǰһ
  if Days < GetJieQiDayTimeFromYear(AYear, 3) then
  begin
    // Ϊǰһ
    Dec(Result);
    if Result = 0 then // ûйԪ 0 
      Dec(Result);
  end;
end;

// ֲй
function GetLeapNum(AYear: Integer): Integer;
begin
  if AYear < 0 then
    Result := SCnLeapNumber[AYear + 849]
  else
    Result := SCnLeapNumber[AYear - 1 + 849];
end;

// ֲй
function GetLeapMonth(AYear: Integer): Integer;
var
  C: Char;
begin
  C := SCnLeapMonth[AYear + 850]; // ַ± 1 ʼ
  if {$IFDEF UNICODE}CharInSet(C, ['0'..'9']){$ELSE}C in ['0'..'9']{$ENDIF} then
    Result := StrToInt(C)
  else if {$IFDEF UNICODE}CharInSet(C , ['a'..'c']){$ELSE}C in ['a'..'c']{$ENDIF} then
    Result := 10 + Ord(C) - Ord('a')
  else
    Result := -1;
end;

// һС
function GetTail(X: Real): Real;
begin
  if X > 0 then
    Result := X - Trunc(X)
  else
    Result := X + Trunc(X);
end;

// ĳǶȼ㺯ֲй
function GetAng(X, T, C1, T0, T2, T3: Real): Real;
begin
  Result := GetTail(C1 * X) * 2 * Pi + T0 - T2 * T * T - T3 * T * T * T;
end;

// ĳյũ͸Լʳͺʱ
function GetLunarMoon(AYear, AMonth, ADay: Integer; out EclipseType: TCnEclipseType;
  out MoonPhase: TCnMoonPhase; out theTime: Double): Real;
var
  K, K1: Real;
  T, Rpi, Zone, F0, Fc, J0, Aa0, Ab0, Ac0, ShuoTime, WangTime: Real;
  Aa, Ab, Ac, F1, J: Real;
  Ms, LunDay, LunDay0, WangDay: Integer;
  S, R, P, Q: Real;
  StdDays: Integer;
begin
  T := (AYear - 1899.5) / 100;
  Ms := Floor((AYear - 1900) * 12.3685);
  Rpi := 180 / Pi;
  Zone := 8;
  F0 := GetAng(Ms, T, 0, 0.75933, 2.172e-4, 1.55e-7)
    + 0.53058868 * Ms - 8.37e-4 * T + Zone / 24 + 0.5;
  Fc := 0.1734 - 3.93e-4 * T;
  J0 := 693595 + 29 * Ms;
  Aa0 := GetAng(Ms, T, 0.08084821133, 359.2242/Rpi, 0.0000333/Rpi, 0.00000347/Rpi);
  Ab0 := GetAng(Ms, T, 7.171366127999999e-2, 306.0253/Rpi, -0.0107306/Rpi, -0.00001236/Rpi);
  Ac0 := GetAng(Ms, T, 0.08519585128, 21.2964/Rpi, 0.0016528/Rpi, 0.00000239/Rpi);

  EclipseType := etNone;
  LunDay := -1;

  ShuoTime := 0;
  WangDay := 0;
  WangTime := 0;

  K1 := -1; K := -1;
  StdDays := GetEquStandardDays(AYear, AMonth, ADay);
  while K <= 13 do
  begin
    Aa := Aa0 + 0.507984293 * K;
    Ab := Ab0 + 6.73377553 * K;
    Ac := Ac0 + 6.818486628 * K;
    F1 := F0 + 1.53058868 * K + Fc * Sin(Aa) - 0.4068 * Sin(Ab)
      + 0.0021 * Sin(2 * Aa) + 0.0161 * Sin(2 * Ab) + 0.0104 * Sin(2 * Ac)
      - 0.0074 * Sin(Aa - Ab) - 0.0051 * Sin(Aa + Ab);

    J := J0 + 28 * K + F1;

    LunDay0 := StdDays - Floor(J);
    if (K = Floor(K)) and (LunDay0 >= 0) and (LunDay0 <= 29) then
    begin
      K1 := K;
      ShuoTime := GetTail(J);
      LunDay := LunDay0 + 1;
    end;

    if (K = K1 + 0.5) then
    begin
      WangTime := GetTail(J);
      WangDay := Floor(J) - (StdDays - LunDay + 1) + 1;
    end;

    if((LunDay = 1) and (K = K1)) or
      ((LunDay = WangDay) and (K = K1 + 0.5)) then
    begin
      if Abs(Sin(Ac))<= 0.36 then
      begin
        S := 5.19595 - 0.0048 * Cos(Aa) + 0.002 * Cos(2 * Aa) - 0.3283 * Cos(Ab)
          - 0.006 * Cos(Aa + Ab) + 0.0041 * Cos(Aa - Ab);
        R := 0.207 * Sin(Aa) + 0.0024 * Sin(2 * Aa) - 0.039 * Sin(Ab)
          + 0.0115 * Sin(2 * Ab) - 0.0073 * Sin(Aa + Ab) - 0.0067 * Sin(Aa - Ab)
          + 0.0117 * Sin(2 * Ac);
        P := Abs(S * Sin(Ac) + R * Cos(Ac));
        Q := 0.0059 + 0.0046 * Cos(Ac) - 0.0182 * Cos(Ab) + 0.0004 * Cos(2 * Ab)
          - 0.0005 * Cos(Aa + Ab);
          
        if P - Q <= 1.5572 then 
        begin
          EclipseType := etSolar; // ʳ
          if K <> Floor(K) then
          begin
            if P + Q >= 1.0129 then
              EclipseType := etMoonHalf  //ƫʳ
            else
              EclipseType := etMoonFull;  //ȫʳ
          end;
        end;
      end;
    end;

    K := K + 0.5;
  end;

  // 1924.3.5 ~ 4.3 һ
  if (AYear = 1924)
    and (((AMonth = 3) and (ADay >= 5)) or ((AMonth = 4) and (ADay <= 3))) then
  begin
    Inc(LunDay);
    if LunDay > 30 then
      LunDay := Lunday - 30;	
  end;
  
  // 2018.11.7 ~ 12.6 һ
  if (AYear = 2018)
    and (((AMonth = 11) and (ADay >= 7)) or ((AMonth = 12) and (ADay <= 6))) then
  begin
    Dec(LunDay);
    if LunDay < 1 then
      LunDay := LunDay + 30;
  end;
  
  // 2025.4.27 ~ 5.26 һ
  if (AYear = 2025)
    and (((AMonth = 4) and (ADay >= 27)) or ((AMonth = 5) and (ADay <= 26))) then
  begin
    Inc(LunDay);
    if LunDay > 30 then
      LunDay := LunDay - 30;
  end;

  Result := LunDay;

  if LunDay = 1 then // ˷
  begin
    MoonPhase := mpShuo;
    theTime := ShuoTime;
  end
  else if LunDay = WangDay then
  begin
    MoonPhase := mpWang;
    theTime := WangTime;
  end
  else
  begin
    MoonPhase := mpNone;
    theTime := -1;
  end;
end;

// ĳũ£ 1~12 Ӧһµʮ£ 0 ʾ
function GetLunarLeapMonth(AYear: Integer): Integer;
begin
  Result := GetLeapMonth(AYear);
  if Result < 0 then
    Result := 0;
end;

// ĳյũ
function GetLunarMonth(AYear, AMonth, ADay: Integer): Real;
var
  LunDay: Real;
  aEclipsType: TCnEclipseType;
  aMoonPhase: TCnMoonPhase;
  aTime: Double;
  LeapMons, NMonth: Integer;

  // С
  function GetRemain(X, W: Real): Real;
  begin
    Result := GetTail(X/W) * W;
  end;

begin
  LunDay := GetLunarMoon(AYear, AMonth, ADay, aEclipsType, aMoonPhase, aTime);
  if aTime <> -1 then
    LunDay := LunDay + aTime;
  LunDay := Floor(LunDay - Floor(LunDay / 100) * 100);

  LeapMons := GetLeapNum(AYear);
  NMonth := Round((GetEquStandardDays(AYear, AMonth, ADay)
    - GetEquStandardDays(-849, 1, 21) - LunDay)/ 29.530588) - LeapMons;

  //ʷϵ޸½
  if AYear <= 240 then Inc(NMonth);
  if AYear <= 237 then Dec(NMonth);
  if AYear < 24 then Inc(NMonth);
  if AYear < 9 then Dec(NMonth);
  if AYear <= -255 then Inc(NMonth);
  if AYear <= -256 then Inc(NMonth, 2);
  if AYear <= -722 then Inc(NMonth);

  Result := Round(GetRemain(NMonth - 3, 12) + 1);

  if (Result = GetLeapMonth(AYear - 1)) and (AMonth = 1) and (ADay < LunDay) then
  begin
    Result := - Result;    //  AYear - 1 ĩҸ½ӵ AYear , AYear Ҳ
  end
  else if Result = GetLeapMonth(AYear) then
  begin
    // õ·뵱ͬ 1612  1  31 š
    // õ 11 £ 1612 и 11 £ܻ
    if (AMonth in [1, 2]) and (GetLeapMonth(AYear) <> 12) then
    begin
      // жϣ·ҽ²12£˵²һģ
      // Բ£Ϊͨ¡̫ܲ׼ȷ

      //  1984  10 £ 1984.1.1 ũΪ 10
      // Ǵ 1983 ӹģԲ 1984  10 
      Result := Result + 1;
    end
    else
    begin
      Result := - Result;
    end;
  end
  else
  begin
    if (Result < GetLeapMonth(AYear)) or (AMonth < Result) and (GetLeapMonth(AYear) > 0) then
      Result := Result + 1;  //  AYear µδǰ۳˱£Ӧ

    Result := Round(GetRemain(Result - 1, 12) + 1);
  end;
end;

// ĳյũպǷµϢ
function GetLunarFromDay(AYear, AMonth, ADay: Integer;
  out LunarYear, LunarMonth, LunarDay: Integer; out IsLeapMonth: Boolean): Boolean;
var
  aEclipsType: TCnEclipseType;
  aMoonPhase: TCnMoonPhase;
  aTime: Double;
begin
  Result := False;
  if (AYear >= -849) and (AYear <= 2800) then
  begin
    LunarDay := Floor(GetLunarMoon(AYear, AMonth, ADay, aEclipsType, aMoonPhase, aTime));
    LunarMonth := Floor(GetLunarMonth(AYear, AMonth, ADay));
    IsLeapMonth := LunarMonth < 0;
    if IsLeapMonth then
      LunarMonth := - LunarMonth;
    LunarYear := AYear;

    // ũ°꣬ϰ꣬ũӦΪһ
    if (LunarMonth > 6) and (AMonth < 6) then
      Dec(LunarYear);

    Result := True;
  end;
end;

// ĳյũպǷµϢ
function GetLunarMonthDayFromDay(AYear, AMonth, ADay: Integer;
  out LunarMonth, LunarDay: Integer; out IsLeapMonth: Boolean): Boolean;
var
  aEclipsType: TCnEclipseType;
  aMoonPhase: TCnMoonPhase;
  aTime: Double;
begin
  Result := False;
  if (AYear >= -849) and (AYear <= 2800) then
  begin
    LunarDay := Floor(GetLunarMoon(AYear, AMonth, ADay, aEclipsType, aMoonPhase, aTime));
    LunarMonth := Floor(GetLunarMonth(AYear, AMonth, ADay));
    IsLeapMonth := LunarMonth < 0;
    if IsLeapMonth then
      LunarMonth := - LunarMonth;
    Result := True;
  end;
end;

// ĳũգǷ£Ĺ
// ú÷ַ
function GetDayFromLunar(ALunarYear, ALunarMonth, ALunarDay: Integer; IsLeapMonth:
  Boolean; out AYear, AMonth, ADay: Integer): Boolean;
type
  TLunarSearchDirection = (lsdInvalid, lsdUp, lsdDown);
var
  StartYear, StartMonth, StartDay: Integer;
  EndYear, EndMonth, EndDay: Integer;
  StartDays, EndDays, InterDays: Integer;
  TempYear, TempMonth, TempDay: Integer;
  TempLunarYear, TempLunarMonth, TempLunarDay, OldTempLunarMonth: Integer;
  TempIsLeap, Only2: Boolean;
  Lsd: TLunarSearchDirection;
  Count: Integer;
begin
  Result := False;
  if IsLeapMonth and (GetLunarLeapMonth(ALunarYear) <> ALunarMonth) then
    Exit; // ޴˳

  // ʼΧΪһһյʮʮһգǰʷ³һ
  // û䵽ǰȥɿʵΧ
  // һһһյʮʮһգֿΧжϵĴ
  StartYear := ALunarYear;
  StartMonth := 1;
  StartDay := 1;
  StartDays := GetEquStandardDays(StartYear, StartMonth, StartDay);

  EndYear := ALunarYear + 1;
  EndMonth := 12;
  EndDay := 31;
  EndDays := GetEquStandardDays(EndYear, EndMonth, EndDay);

  Only2 := False;
  Lsd := lsdInvalid;
  TempYear := StartYear;
  TempLunarYear := StartYear;
  OldTempLunarMonth := 0;

  Count := 0;
  while StartDays < EndDays do
  begin
    Inc(Count);
    if Count > 100 then // ѭ
      Exit;

    InterDays := (StartDays + EndDays) div 2;
    if Only2 then
      Inc(InterDays);

    if EndDays - StartDays = 1 then
      Only2 := True;

    GetDayFromEquStandardDays(InterDays, TempYear, TempMonth, TempDay);
    GetLunarMonthDayFromDay(TempYear, TempMonth, TempDay, TempLunarMonth,
      TempLunarDay, TempIsLeap);
    // תֱӻȡݣжȡ

    case Lsd of
      lsdUp:
        begin
          // δʱũɴСˣ˵꣬ݵüһ
          if TempLunarMonth < OldTempLunarMonth then
            Inc(TempLunarYear);
        end;
      lsdDown:
        begin
          // ȥʱũСˣ˵꣬ݵüһ
          if TempLunarMonth > OldTempLunarMonth then
            Dec(TempLunarYear);
        end;
    end;

    case Compare2LunarDay(TempLunarYear, TempLunarMonth, TempLunarDay, TempIsLeap,
      ALunarYear, ALunarMonth, ALunarDay, IsLeapMonth) of
      -1:
        begin
          StartDays := InterDays;
          Lsd := lsdUp; // δ
        end;  
      0:
        begin
          AYear := TempYear;
          AMonth := TempMonth;
          ADay := TempDay;
          Result := True;
          Exit;
        end;
      1:
        begin
          EndDays := InterDays;
          Lsd := lsdDown; // ȥ
        end;
    end;
    OldTempLunarMonth := TempLunarMonth;
  end;
end;

initialization
  GenerateGanZhiArray;

end.
